#!/usr/bin/perl

package eBay::API::XML::DataType::VeROReportedItemType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VeROReportedItemType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::VeROReportedItemType

=head1 DESCRIPTION

A container for item and VeROReportedItem's.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::VeROReportedItemType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::VeROItemStatusCodeType;


my @gaProperties = ( [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ItemReasonForFailure', 'xs:string', '', '', '' ]
	, [ 'ItemStatus', 'ns:VeROItemStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::VeROItemStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setItemID()

The item ID of the item reported for infringment.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetVeROReportStatus
  Returned: Conditionally

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setItemReasonForFailure()

The explanation entered by eBay when an item reported for infringement is 
given a status of SubmissionFailed or ClarificationRequired.

#    Argument: 'xs:string'

=cut

sub setItemReasonForFailure {
  my $self = shift;
  $self->{'ItemReasonForFailure'} = shift
}

=head2 getItemReasonForFailure()

  Calls: GetVeROReportStatus
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getItemReasonForFailure {
  my $self = shift;
  return $self->{'ItemReasonForFailure'};
}


=head2 setItemStatus()

The VeRO reporting status for a given item.

#    Argument: 'ns:VeROItemStatusCodeType'

=cut

sub setItemStatus {
  my $self = shift;
  $self->{'ItemStatus'} = shift
}

=head2 getItemStatus()

  Calls: GetVeROReportStatus
  Returned: Conditionally

#    Returns: 'ns:VeROItemStatusCodeType'

=cut

sub getItemStatus {
  my $self = shift;
  return $self->{'ItemStatus'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
