# Generated by default/object.tt
package Paws::IoTEvents::Payload;
  use Moose;
  has ContentExpression => (is => 'ro', isa => 'Str', request_name => 'contentExpression', traits => ['NameInRequest'], required => 1);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::Payload

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::Payload object:

  $service_obj->Method(Att1 => { ContentExpression => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::Payload object:

  $result = $service_obj->Method(...);
  $result->Att1->ContentExpression

=head1 DESCRIPTION

Information needed to configure the payload.

By default, AWS IoT Events generates a standard payload in JSON for any
action. This action payload contains all attribute-value pairs that
have the information about the detector model instance and the event
triggered the action. To configure the action payload, you can use
C<contentExpression>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContentExpression => Str

The content of the payload. You can use a string expression that
includes quoted strings (C<'E<lt>stringE<gt>'>), variables
(C<$variable.E<lt>variable-nameE<gt>>), input values
(C<$input.E<lt>input-nameE<gt>.E<lt>path-to-datumE<gt>>), string
concatenations, and quoted strings that contain C<${}> as the content.
The recommended maximum size of a content expression is 1 KB.


=head2 B<REQUIRED> Type => Str

The value of the payload type can be either C<STRING> or C<JSON>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

