package Daje::Workflow::FileChanged::Database::Model::FileHashes;
use Mojo::Base  -base, -signatures;


has 'db';


sub save_hash($self, $file, $hash) {

    $self->db->insert(
        'file_hashes',
        {
            file => $file, hash => $hash, moddatetime => 'NOW()'
        },
        {
            on_conflict => [
                file => {
                    hash => $hash
                }
            ]
        }
    );
}

sub load_hash($self, $file_path_name) {

    my $hash;
    my $data = $self->db->select(
        'file_hashes',
            ['*'],
            {
                file =>  $file_path_name
            }
    );

    $hash = $data->hash if defined $data and $data->rows > 0;

    return $hash;
}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::FileChanged::Database::Model::FileHashes


=head1 REQUIRES

L<Mojo::Base> 


=head1 METHODS

=head2 load_hash($self,

 load_hash($self,();

=head2 save_hash($self,

 save_hash($self,();


=cut

