package Sah::SchemaR::filesize;

our $DATE = '2020-03-08'; # DATE
our $VERSION = '0.009'; # VERSION

our $rschema = do{my$a=["float",[{description=>"\nFloat, in bytes.\n\nCan be coerced from string that contains units, e.g.:\n\n    2KB   -> 2048      (kilobyte, 1024-based)\n    2mb   -> 2097152   (megabyte, 1024-based)\n    1.5K  -> 1536      (kilobyte, 1024-based)\n    1.6ki -> 1600      (kibibyte, 1000-based)\n\n",examples=>[{valid=>1,validated_value=>2048,value=>"2KB"},{valid=>1,validated_value=>2048,value=>"2 kb"},{valid=>1,validated_value=>2097152,value=>"2mb"},{valid=>1,validated_value=>1536,value=>"1.5K"},{valid=>1,validated_value=>1600,value=>"1.6ki"},{valid=>0,value=>"1zzz"}],min=>0,summary=>"Data size","x.perl.coerce_rules"=>["From_str::suffix_datasize"]},{examples=>'fix',summary=>"File size"}],["datasize","float"]];$a->[1][1]{examples}=$a->[1][0]{examples};$a};

1;
# ABSTRACT: File size

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::filesize - File size

=head1 VERSION

This document describes version 0.009 of Sah::SchemaR::filesize (from Perl distribution Sah-Schemas-DataSizeSpeed), released on 2020-03-08.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-DataSizeSpeed>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-DataSizeSpeed>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-DataSizeSpeed>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
