# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191016;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97\\d
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441254", "Blackburn",
"441758", "Pwllheli",
"4414377", "Haverfordwest",
"441671", "Newton\ Stewart",
"441644", "New\ Galloway",
"441573", "Kelso",
"441503", "Looe",
"4414301", "North\ Cave\/Market\ Weighton",
"441685", "Merthyr\ Tydfil",
"441228", "Carlisle",
"441440", "Haverhill",
"441724", "Scunthorpe",
"441555", "Lanark",
"4413882", "Stanhope\ \(Eastgate\)",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441144", "Sheffield",
"44121", "Birmingham",
"4412298", "Barrow\-in\-Furness",
"441242", "Cheltenham",
"441535", "Keighley",
"441234", "Bedford",
"441652", "Brigg",
"441582", "Luton",
"4419758", "Strathdon",
"441738", "Perth",
"441666", "Malmesbury",
"441267", "Carmarthen",
"4414346", "Hexham",
"441994", "St\ Clears",
"441489", "Bishops\ Waltham",
"441838", "Dalmally",
"441260", "Congleton",
"441436", "Helensburgh",
"442825", "Ballymena",
"441695", "Skelmersdale",
"441824", "Ruthin",
"4413398", "Aboyne",
"441358", "Ellon",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441945", "Wisbech",
"441569", "Stonehaven",
"441984", "Watchet\ \(Williton\)",
"441858", "Market\ Harborough",
"441499", "Inveraray",
"441324", "Falkirk",
"441592", "Kirkcaldy",
"441462", "Hitchin",
"4414307", "Market\ Weighton",
"441456", "Glenurquhart",
"441934", "Weston\-super\-Mare",
"441798", "Pulborough",
"441377", "Driffield",
"441307", "Forfar",
"441967", "Strontian",
"442848", "Northern\ Ireland",
"441294", "Ardrossan",
"441942", "Wigan",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"4419649", "Hornsea",
"441465", "Girvan",
"441700", "Rothesay",
"441877", "Callander",
"441807", "Ballindalloch",
"441770", "Isle\ of\ Arran",
"441928", "Runcorn",
"441388", "Bishop\ Auckland",
"441888", "Turriff",
"441954", "Madingley",
"441669", "Rothbury",
"442822", "Northern\ Ireland",
"441692", "North\ Walsham",
"441245", "Chelmsford",
"441284", "Bury\ St\ Edmunds",
"441788", "Rugby",
"4414234", "Boroughbridge",
"441439", "Helmsley",
"441655", "Maybole",
"441501", "Harthill",
"4415075", "Spilsby\ \(Horncastle\)",
"441603", "Norwich",
"441544", "Kington",
"441673", "Market\ Rasen",
"441571", "Lochinver",
"4418478", "Thurso",
"4418510", "Great\ Bernera\/Stornoway",
"4416869", "Newtown",
"441635", "Newbury",
"441707", "Welwyn\ Garden\ City",
"441870", "Isle\ of\ Benbecula",
"441398", "Dulverton",
"441777", "Retford",
"4414232", "Harrogate",
"441566", "Launceston",
"441496", "Port\ Ellen",
"4418516", "Great\ Bernera",
"442879", "Magherafelt",
"441300", "Cerne\ Abbas",
"441844", "Thame",
"441871", "Castlebay",
"441885", "Pencombe",
"4415242", "Hornby",
"441427", "Gainsborough",
"441209", "Redruth",
"441279", "Bishops\ Stortford",
"441332", "Derby",
"4416868", "Newtown",
"441832", "Clopton",
"441925", "Warrington",
"441371", "Great\ Dunmow",
"441344", "Bracknell",
"441301", "Arrochar",
"4418479", "Tongue",
"4414303", "North\ Cave",
"441852", "Kilmelford",
"44287", "Northern\ Ireland",
"44280", "Northern\ Ireland",
"441866", "Kilchrenan",
"441598", "Lynton",
"441366", "Downham\ Market",
"441352", "Mold",
"441795", "Sittingbourne",
"4413885", "Stanhope\ \(Eastgate\)",
"442884", "Northern\ Ireland",
"441443", "Pontypridd",
"442845", "Northern\ Ireland",
"441570", "Lampeter",
"441577", "Kinross",
"441919", "Durham",
"441895", "Uxbridge",
"441766", "Porthmadog",
"441638", "Newmarket",
"4419648", "Hornsea",
"441752", "Plymouth",
"441395", "Budleigh\ Salterton",
"441588", "Bishops\ Castle",
"441732", "Sevenoaks",
"441263", "Cromer",
"44116", "Leicester",
"4414373", "Clynderwen\ \(Clunderwen\)",
"442894", "Antrim",
"441420", "Alton",
"441248", "Bangor\ \(Gwynedd\)",
"441624", "Isle\ of\ Man",
"441785", "Stafford",
"441744", "St\ Helens",
"441771", "Maud",
"441206", "Colchester",
"441276", "Camberley",
"441677", "Bedale",
"4418906", "Ayton",
"441782", "Stoke\-on\-Trent",
"441538", "Ipstones",
"441261", "Banff",
"441225", "Bath",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441558", "Llandeilo",
"441869", "Bicester",
"4413399", "Ballater",
"441892", "Tunbridge\ Wells",
"441773", "Ripley",
"441369", "Dunoon",
"441524", "Lancaster",
"441909", "Worksop",
"4418900", "Coldstream\/Ayton",
"441392", "Exeter",
"441948", "Whitchurch",
"441855", "Ballachulish",
"442867", "Lisnaskea",
"4414235", "Harrogate",
"441803", "Torquay",
"441873", "Abergavenny",
"441916", "Tyneside",
"441769", "South\ Molton",
"441303", "Folkestone",
"441373", "Frome",
"441355", "East\ Kilbride",
"441963", "Wincanton",
"441792", "Swansea",
"4415074", "Alford\ \(Lincs\)",
"44281", "Northern\ Ireland",
"442842", "Kircubbin",
"441882", "Kinloch\ Rannoch",
"441335", "Ashbourne",
"442828", "Larne",
"4412299", "Millom",
"441698", "Motherwell",
"441922", "Walsall",
"441835", "St\ Boswells",
"441382", "Dundee",
"441670", "Morpeth",
"4415072", "Spilsby\ \(Horncastle\)",
"441404", "Honiton",
"441474", "Gravesend",
"441600", "Monmouth",
"4419759", "Alford\ \(Aberdeen\)",
"441536", "Kettering",
"441290", "Cumnock",
"441621", "Maldon",
"441208", "Bodmin",
"442891", "Bangor\ \(Co\.\ Down\)",
"441665", "Alnwick",
"4413873", "Langholm",
"4415394", "Hawkshead",
"441278", "Bridgwater",
"441704", "Southport",
"441547", "Knighton",
"441950", "Sandwick",
"441287", "Guisborough",
"4418517", "Stornoway",
"441599", "Kyle",
"4418903", "Coldstream",
"441469", "Killingholme",
"441556", "Castle\ Douglas",
"441562", "Kidderminster",
"441492", "Colwyn\ Bay",
"441280", "Buckingham",
"441957", "Mid\ Yell",
"44114705", "Sheffield",
"44241", "Coventry",
"441639", "Neath",
"441918", "Tyneside",
"441455", "Hinckley",
"441403", "Horsham",
"441540", "Kingussie",
"442881", "Newtownstewart",
"441473", "Ipswich",
"4418511", "Great\ Bernera\/Stornoway",
"441946", "Whitehaven",
"4417684", "Pooley\ Bridge",
"441435", "Heathfield",
"4415078", "Alford\ \(Lincs\)",
"4418475", "Thurso",
"441874", "Brecon",
"441841", "Newquay\ \(Padstow\)",
"441249", "Chippenham",
"442826", "Northern\ Ireland",
"441482", "Kingston\-upon\-Hull",
"441937", "Wetherby",
"441297", "Axminster",
"441304", "Dover",
"441341", "Barmouth",
"441659", "Sanquhar",
"441327", "Daventry",
"441250", "Blairgowrie",
"441432", "Hereford",
"441987", "Ebbsfleet",
"4419755", "Alford\ \(Aberdeen\)",
"441539", "Kendal",
"4416862", "Llanidloes",
"442883", "Northern\ Ireland",
"441444", "Haywards\ Heath",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"4412295", "Barrow\-in\-Furness",
"441485", "Hunstanton",
"4414300", "North\ Cave\/Market\ Weighton",
"441827", "Tamworth",
"441720", "Isles\ of\ Scilly",
"441140", "Sheffield",
"441908", "Milton\ Keynes",
"441978", "Wrexham",
"4416864", "Llanidloes",
"441843", "Thanet",
"441368", "Dunbar",
"441452", "Gloucester",
"44247", "Coventry",
"441466", "Huntly",
"441559", "Llandysul",
"441343", "Elgin",
"4414306", "Market\ Weighton",
"441689", "Orpington",
"4414239", "Boroughbridge",
"441237", "Bideford",
"441997", "Strathpeffer",
"4419642", "Hornsea",
"4414376", "Haverfordwest",
"441264", "Andover",
"441768", "Penrith",
"441636", "Newark\-on\-Trent",
"4413395", "Aboyne",
"441743", "Shrewsbury",
"442893", "Ballyclare",
"441565", "Knutsford",
"441949", "Whatton",
"441623", "Mansfield",
"441495", "Pontypool",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441727", "St\ Albans",
"441647", "Moretonhampstead",
"4419644", "Patrington",
"441246", "Chesterfield",
"442829", "Kilrea",
"441980", "Amesbury",
"441320", "Fort\ Augustus",
"441257", "Coppull",
"441586", "Campbeltown",
"4414347", "Hexham",
"441656", "Bridgend",
"441912", "Tyneside",
"44114702", "Sheffield",
"441821", "Kinrossie",
"441865", "Oxford",
"441477", "Holmes\ Chapel",
"441407", "Holyhead",
"442846", "Northern\ Ireland",
"441796", "Pitlochry",
"4415395", "Grange\-over\-Sands",
"441905", "Worcester",
"441759", "Pocklington",
"441981", "Wormbridge",
"441953", "Wymondham",
"441293", "Crawley",
"441488", "Hungerford",
"441933", "Wellingborough",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441520", "Lochcarron",
"441386", "Evesham",
"442837", "Armagh",
"4418901", "Coldstream\/Ayton",
"441926", "Warwick",
"441527", "Redditch",
"4418472", "Thurso",
"441202", "Bournemouth",
"442830", "Newry",
"4418907", "Ayton",
"4416973", "Wigton",
"4418513", "Stornoway",
"441786", "Stirling",
"441896", "Galashiels",
"4418474", "Thurso",
"441568", "Leominster",
"44118", "Reading",
"441283", "Burton\-on\-Trent",
"441859", "Harris",
"4414238", "Harrogate",
"441141", "Sheffield",
"441604", "Northampton",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441400", "Honington",
"441641", "Strathy",
"441543", "Cannock",
"441359", "Pakenham",
"441674", "Montrose",
"44114704", "Sheffield",
"441765", "Ripon",
"441721", "Peebles",
"441747", "Shaftesbury",
"441840", "Camelford",
"442897", "Saintfield",
"4419754", "Alford\ \(Aberdeen\)",
"441226", "Barnsley",
"442849", "Northern\ Ireland",
"441993", "Witney",
"441799", "Saffron\ Walden",
"441340", "Craigellachie\ \(Aberlour\)",
"441756", "Skipton",
"4414343", "Haltwhistle",
"4412294", "Barrow\-in\-Furness",
"44113", "Leeds",
"441233", "Ashford\ \(Kent\)",
"4416865", "Newtown",
"441736", "Penzance",
"4415079", "Alford\ \(Lincs\)",
"441205", "Boston",
"441275", "Clevedon",
"4419752", "Alford\ \(Aberdeen\)",
"441668", "Bamburgh",
"44115", "Nottingham",
"441889", "Rugeley",
"441253", "Blackpool",
"44114708", "Sheffield",
"441143", "Sheffield",
"441723", "Scarborough",
"441389", "Dumbarton",
"441643", "Minehead",
"442880", "Carrickmore",
"4412292", "Barrow\-in\-Furness",
"441929", "Wareham",
"442887", "Dungannon",
"441823", "Taunton",
"441438", "Stevenage",
"441951", "Colonsay",
"4413394", "Ballater",
"441789", "Stratford\-upon\-Avon",
"441323", "Eastbourne",
"441983", "Isle\ of\ Wight",
"441915", "Sunderland",
"441347", "Easingwold",
"441899", "Biggar",
"441458", "Glastonbury",
"441291", "Chepstow",
"4419645", "Hornsea",
"441931", "Shap",
"441862", "Tain",
"441856", "Orkney",
"441620", "North\ Berwick",
"442890", "Belfast",
"441424", "Hastings",
"441740", "Sedgefield",
"441902", "Wolverhampton",
"441972", "Glenborrodale",
"441356", "Brechin",
"4413392", "Aboyne",
"441362", "Dereham",
"4414231", "Harrogate\/Boroughbridge",
"44291", "Cardiff",
"442877", "Limavady",
"441457", "Glossop",
"441348", "Fishguard",
"441863", "Ardgay",
"441446", "Barry",
"441848", "Thornhill",
"441779", "Peterhead",
"441709", "Rotherham",
"441955", "Wick",
"441363", "Crediton",
"4415073", "Louth",
"441903", "Worthing",
"441911", "Tyneside\/Durham\/Sunderland",
"442888", "Northern\ Ireland",
"441295", "Banbury",
"441935", "Yeovil",
"441822", "Tavistock",
"4414349", "Bellingham",
"441594", "Lydney",
"441464", "Insch",
"441982", "Builth\ Wells",
"441322", "Dartford",
"441667", "Nairn",
"441252", "Aldershot",
"441634", "Medway",
"4418908", "Coldstream",
"441142", "Sheffield",
"44161", "Manchester",
"441642", "Middlesbrough",
"441722", "Salisbury",
"441271", "Barnstaple",
"442898", "Belfast",
"441244", "Chester",
"4414237", "Harrogate",
"441285", "Cirencester",
"441628", "Maidenhead",
"441809", "Tomdoun",
"441748", "Richmond",
"441879", "Scarinish",
"441992", "Lea\ Valley",
"441450", "Hawick",
"441309", "Forres",
"441763", "Royston",
"441379", "Diss",
"441654", "Machynlleth",
"441584", "Ludlow",
"4415396", "Sedbergh",
"442870", "Coleraine",
"441545", "Llanarth",
"441969", "Leyburn",
"441497", "Hay\-on\-Wye",
"441567", "Killin",
"441282", "Burnley",
"4414372", "Clynderwen\ \(Clunderwen\)",
"4419646", "Patrington",
"441534", "Jersey",
"442310", "Portsmouth",
"441449", "Stowmarket",
"441995", "Garstang",
"441776", "Stranraer",
"441706", "Rochdale",
"441235", "Abingdon",
"441542", "Keith",
"44151", "Liverpool",
"4419640", "Hornsea\/Patrington",
"441255", "Clacton\-on\-Sea",
"441528", "Laggan",
"44117", "Bristol",
"441273", "Brighton",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441145", "Sheffield",
"441480", "Huntingdon",
"441684", "Malvern",
"441554", "Llanelli",
"441725", "Rockbourne",
"441761", "Temple\ Cloud",
"441292", "Ayr",
"4416866", "Newtown",
"441932", "Weybridge",
"441825", "Uckfield",
"441487", "Warboys",
"441269", "Ammanford",
"442838", "Portadown",
"441944", "West\ Heslerton",
"441971", "Scourie",
"4414304", "North\ Cave",
"441985", "Warminster",
"441361", "Duns",
"441325", "Darlington",
"4418519", "Great\ Bernera",
"441408", "Golspie",
"4416860", "Newtown\/Llanidloes",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441913", "Durham",
"441806", "Shetland",
"44286", "Northern\ Ireland",
"4420", "London",
"441876", "Lochmaddy",
"442824", "Northern\ Ireland",
"441490", "Corwen",
"441694", "Church\ Stretton",
"44114709", "Sheffield",
"441560", "Moscow",
"44114703", "Sheffield",
"4414302", "North\ Cave",
"441306", "Dorking",
"441376", "Braintree",
"441952", "Telford",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"4418476", "Tongue",
"441224", "Aberdeen",
"441728", "Saxmundham",
"4414233", "Boroughbridge",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441258", "Blandford",
"441525", "Leighton\ Buzzard",
"441754", "Skegness",
"441491", "Henley\-on\-Thames",
"441663", "New\ Mills",
"441561", "Laurencekirk",
"441767", "Sandy",
"4418470", "Thurso\/Tongue",
"4418518", "Stornoway",
"441970", "Aberystwyth",
"441900", "Workington",
"441360", "Killearn",
"441576", "Lockerbie",
"442892", "Lisburn",
"441506", "Bathgate",
"441622", "Maidstone",
"441367", "Faringdon",
"441977", "Pontefract",
"441842", "Thetford",
"441334", "St\ Andrews",
"441405", "Goole",
"441481", "Guernsey",
"441475", "Greenock",
"441453", "Dursley",
"441760", "Swaffham",
"441834", "Narberth",
"44131", "Edinburgh",
"441342", "East\ Grinstead",
"441433", "Hathersage",
"441988", "Wigtown",
"441854", "Ullapool",
"441328", "Fakenham",
"442882", "Omagh",
"442311", "Southampton",
"441828", "Coupar\ Angus",
"441609", "Northallerton",
"4415077", "Louth",
"441354", "Chatteris",
"441270", "Crewe",
"44114701", "Sheffield",
"441200", "Clitheroe",
"4418909", "Ayton",
"441794", "Romsey",
"441451", "Stow\-on\-the\-Wold",
"442885", "Ballygawley",
"442871", "Londonderry",
"442844", "Downpatrick",
"441298", "Buxton",
"4413390", "Aboyne\/Ballater",
"441483", "Guildford",
"441938", "Welshpool",
"441431", "Helmsdale",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441845", "Thirsk",
"441884", "Tiverton",
"442866", "Enniskillen",
"441472", "Grimsby",
"441579", "Liskeard",
"441924", "Wakefield",
"441509", "Loughborough",
"4413396", "Ballater",
"441917", "Sunderland",
"441384", "Dudley",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441910", "Tyneside\/Durham\/Sunderland",
"441548", "Kingsbridge",
"4412290", "Barrow\-in\-Furness\/Millom",
"4414305", "North\ Cave",
"442895", "Belfast",
"441661", "Prudhoe",
"441563", "Kilmarnock",
"441625", "Macclesfield",
"441288", "Bude",
"441493", "Great\ Yarmouth",
"441784", "Staines",
"441745", "Rhyl",
"4414348", "Hexham",
"4419756", "Strathdon",
"441394", "Felixstowe",
"441277", "Brentwood",
"441207", "Consett",
"441429", "Hartlepool",
"4412296", "Barrow\-in\-Furness",
"441522", "Lincoln",
"441606", "Northwich",
"441676", "Meriden",
"441697", "Brampton",
"442827", "Ballymoney",
"441259", "Alloa",
"441883", "Caterham",
"441296", "Aylesbury",
"4416867", "Llanidloes",
"441530", "Coalville",
"441729", "Settle",
"441383", "Dunfermline",
"44283", "Northern\ Ireland",
"441923", "Watford",
"4413393", "Aboyne",
"4419641", "Hornsea\/Patrington",
"441872", "Truro",
"442868", "Kesh",
"441947", "Whitby",
"441962", "Winchester",
"441302", "Doncaster",
"441239", "Cardigan",
"441372", "Esher",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441445", "Gairloch",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441484", "Huddersfield",
"441793", "Swindon",
"441550", "Llandovery",
"441286", "Caernarfon",
"4419753", "Strathdon",
"441557", "Kirkcudbright",
"441687", "Mallaig",
"4419647", "Patrington",
"441546", "Lochgilphead",
"441772", "Preston",
"441702", "Southend\-on\-Sea",
"4414344", "Bellingham",
"4412293", "Millom",
"441608", "Chipping\ Norton",
"441678", "Bala",
"4416861", "Newtown\/Llanidloes",
"441829", "Tarporley",
"4419467", "Gosforth",
"441329", "Fareham",
"441690", "Betws\-y\-Coed",
"441564", "Lapworth",
"441751", "Pickering",
"442820", "Ballycastle",
"441494", "High\ Wycombe",
"441989", "Ross\-on\-Wye",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"4414342", "Bellingham",
"441733", "Peterborough",
"4414230", "Harrogate\/Boroughbridge",
"441262", "Bridlington",
"441939", "Wem",
"441256", "Basingstoke",
"441299", "Bewdley",
"441726", "St\ Austell",
"4416974", "Raughton\ Head",
"4418514", "Great\ Bernera",
"441646", "Milford\ Haven",
"441146", "Sheffield",
"441578", "Lauder",
"4418473", "Thurso",
"441223", "Cambridge",
"441508", "Brooke",
"4414309", "Market\ Weighton",
"4414236", "Harrogate",
"441753", "Slough",
"4418512", "Stornoway",
"441460", "Chard",
"441664", "Melton\ Mowbray",
"441590", "Lymington",
"441775", "Spalding",
"441959", "Westerham",
"441236", "Coatbridge",
"44239", "Portsmouth",
"441637", "Newquay",
"441805", "Torrington",
"441875", "Tranent",
"441467", "Inverurie",
"441289", "Berwick\-upon\-Tweed",
"441597", "Llandrindod\ Wells",
"441630", "Market\ Drayton",
"441353", "Ely",
"441549", "Lairg",
"441381", "Fortrose",
"441305", "Dorchester",
"441375", "Grays\ Thurrock",
"441442", "Hemel\ Hempstead",
"44141", "Glasgow",
"4414379", "Haverfordwest",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441428", "Haslemere",
"44238", "Southampton",
"441326", "Falmouth",
"44292", "Cardiff",
"441833", "Barnard\ Castle",
"441986", "Bungay",
"4418905", "Ayton",
"4417687", "Keswick",
"441650", "Cemmaes\ Road",
"441454", "Chipping\ Sodbury",
"442841", "Rostrevor",
"441580", "Cranbrook",
"441204", "Bolton",
"441241", "Arbroath",
"441274", "Bradford",
"441397", "Fort\ William",
"441778", "Bourne",
"441708", "Romford",
"441349", "Dingwall",
"441553", "Kings\ Lynn",
"441651", "Oldmeldrum",
"4413391", "Aboyne\/Ballater",
"4414378", "Haverfordwest",
"441790", "Spilsby",
"442840", "Banbridge",
"441575", "Kirriemuir",
"441683", "Moffat",
"441505", "Johnstone",
"441581", "New\ Luce",
"441631", "Oban",
"4419643", "Patrington",
"441880", "Tarbert",
"441787", "Sudbury",
"4419757", "Strathdon",
"441526", "Martin",
"441672", "Marlborough",
"442889", "Fivemiletown",
"441920", "Ware",
"4412297", "Millom",
"441380", "Devizes",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441387", "Dumfries",
"441914", "Tyneside",
"44114700", "Sheffield",
"4412291", "Barrow\-in\-Furness\/Millom",
"4414345", "Haltwhistle",
"442823", "Northern\ Ireland",
"441461", "Gretna",
"441425", "Ringwood",
"441591", "Llanwrtyd\ Wells",
"441887", "Aberfeldy",
"441780", "Stamford",
"442847", "Northern\ Ireland",
"441968", "Penicuik",
"441308", "Bridport",
"4414308", "Market\ Weighton",
"441797", "Rye",
"4416863", "Llanidloes",
"441808", "Tomatin",
"441878", "Lochboisdale",
"441749", "Shepton\ Mallet",
"442899", "Northern\ Ireland",
"441943", "Guiseley",
"441629", "Matlock",
"441406", "Holbeach",
"4413397", "Ballater",
"441476", "Grantham",
"441357", "Strathaven",
"441346", "Fraserburgh",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441857", "Sanday",
"441691", "Oswestry",
"441593", "Lybster",
"4418515", "Stornoway",
"4417683", "Appleby",
"442821", "Martinstown",
"441750", "Selkirk",
"441463", "Inverness",
"441864", "Abington\ \(Crawford\)",
"441837", "Okehampton",
"4418471", "Thurso\/Tongue",
"441730", "Petersfield",
"441904", "York",
"441529", "Sleaford",
"441974", "Llanon",
"44114707", "Sheffield",
"441364", "Ashburton",
"442886", "Cookstown",
"441337", "Ladybank",
"441422", "Halifax",
"4415076", "Louth",
"4418477", "Tongue",
"441243", "Chichester",
"441330", "Banchory",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441583", "Carradale",
"441675", "Coleshill",
"441268", "Basildon",
"441764", "Crieff",
"4418902", "Coldstream",
"441653", "Malton",
"441830", "Kirkwhelpington",
"441737", "Redhill",
"441531", "Ledbury",
"441633", "Newport",
"441757", "Selby",
"441746", "Bridgnorth",
"442896", "Belfast",
"441572", "Oakham",
"441626", "Newton\ Abbot",
"441502", "Lowestoft",
"4418904", "Coldstream",
"441227", "Canterbury",
"441409", "Holsworthy",
"441350", "Dunkeld",
"441479", "Grantown\-on\-Spey",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([0-24-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;