package Google::Ads::AdWords::v201109::ReportDefinitionSelector;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %definitionIds_of :ATTR(:get<definitionIds>);
my %paging_of :ATTR(:get<paging>);

__PACKAGE__->_factory(
    [ qw(        definitionIds
        paging

    ) ],
    {
        'definitionIds' => \%definitionIds_of,
        'paging' => \%paging_of,
    },
    {
        'definitionIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'paging' => 'Google::Ads::AdWords::v201109::Paging',
    },
    {

        'definitionIds' => 'definitionIds',
        'paging' => 'paging',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::ReportDefinitionSelector

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ReportDefinitionSelector from the namespace https://adwords.google.com/api/adwords/cm/v201109.

A selector used to specify which report definitions should be returned. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * definitionIds


=item * paging




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::ReportDefinitionSelector
   definitionIds =>  $some_value, # long
   paging =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Paging
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

