package OpenInteract::SQLInstall::Security;

# $Id: Security.pm,v 1.5 2002/05/02 05:14:16 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
   tables        => [ 'sys_security.sql' ],
   tables_oracle => [ 'sys_security_oracle.sql',
                      'sys_security_sequence.sql' ],
   tables_pg     => [ 'sys_security.sql', 'sys_security_sequence.sql' ],
   tables_ib     => [ 'sys_security_interbase.sql',
                      'sys_security_generator.sql' ],
   data          => [ 'install_theme_prop.dat' ],
   security      => [ 'install_security.dat' ],
);

%HANDLERS = (
   create_structure => { '_default_' => [ 'create_structure',
                                          { table_file_list => $files{tables} } ],
                         'Oracle'    => [ 'create_structure',
                                          { table_file_list => $files{tables_oracle} } ],
                         'Pg'        => [ 'create_structure',
                                          { table_file_list => $files{tables_pg} } ],
                         'InterBase' => [ 'create_structure',
                                          { table_file_list => $files{tables_ib} } ]
   },
   install_data     => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{data} } ] },
   install_security => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{security} } ] },
);

1;
