# Generated by default/object.tt
package Paws::IoTSiteWise::PortalSummary;
  use Moose;
  has CreationDate => (is => 'ro', isa => 'Str', request_name => 'creationDate', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);
  has LastUpdateDate => (is => 'ro', isa => 'Str', request_name => 'lastUpdateDate', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest']);
  has StartUrl => (is => 'ro', isa => 'Str', request_name => 'startUrl', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Paws::IoTSiteWise::PortalStatus', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::PortalSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::PortalSummary object:

  $service_obj->Method(Att1 => { CreationDate => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::PortalSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDate

=head1 DESCRIPTION

Contains a portal summary.

=head1 ATTRIBUTES


=head2 CreationDate => Str

The date the portal was created, in Unix epoch time.


=head2 Description => Str

The portal's description.


=head2 B<REQUIRED> Id => Str

The ID of the portal.


=head2 LastUpdateDate => Str

The date the portal was last updated, in Unix epoch time.


=head2 B<REQUIRED> Name => Str

The name of the portal.


=head2 RoleArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the service role that allows the portal's users to access your AWS
IoT SiteWise resources on your behalf. For more information, see Using
service roles for AWS IoT SiteWise Monitor
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
in the I<AWS IoT SiteWise User Guide>.


=head2 B<REQUIRED> StartUrl => Str

The URL for the AWS IoT SiteWise Monitor portal. You can use this URL
to access portals that use AWS SSO for authentication. For portals that
use IAM for authentication, you must use the AWS IoT SiteWise console
to get a URL that you can use to access the portal.


=head2 B<REQUIRED> Status => L<Paws::IoTSiteWise::PortalStatus>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

