# Generated by default/object.tt
package Paws::MediaConvert::HlsRenditionGroupSettings;
  use Moose;
  has RenditionGroupId => (is => 'ro', isa => 'Str', request_name => 'renditionGroupId', traits => ['NameInRequest']);
  has RenditionLanguageCode => (is => 'ro', isa => 'Str', request_name => 'renditionLanguageCode', traits => ['NameInRequest']);
  has RenditionName => (is => 'ro', isa => 'Str', request_name => 'renditionName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::HlsRenditionGroupSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::HlsRenditionGroupSettings object:

  $service_obj->Method(Att1 => { RenditionGroupId => $value, ..., RenditionName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::HlsRenditionGroupSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->RenditionGroupId

=head1 DESCRIPTION

Settings specific to audio sources in an HLS alternate rendition group.
Specify the properties (renditionGroupId, renditionName or
renditionLanguageCode) to identify the unique audio track among the
alternative rendition groups present in the HLS manifest. If no unique
track is found, or multiple tracks match the properties provided, the
job fails. If no properties in hlsRenditionGroupSettings are specified,
the default audio track within the video segment is chosen. If there is
no audio within video segment, the alternative audio with DEFAULT=YES
is chosen instead.

=head1 ATTRIBUTES


=head2 RenditionGroupId => Str

Optional. Specify alternative group ID


=head2 RenditionLanguageCode => Str

Optional. Specify ISO 639-2 or ISO 639-3 code in the language property


=head2 RenditionName => Str

Optional. Specify media name



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

