# Generated by default/object.tt
package Paws::AccessAnalyzer::S3AccessPointConfiguration;
  use Moose;
  has AccessPointPolicy => (is => 'ro', isa => 'Str', request_name => 'accessPointPolicy', traits => ['NameInRequest']);
  has NetworkOrigin => (is => 'ro', isa => 'Paws::AccessAnalyzer::NetworkOriginConfiguration', request_name => 'networkOrigin', traits => ['NameInRequest']);
  has PublicAccessBlock => (is => 'ro', isa => 'Paws::AccessAnalyzer::S3PublicAccessBlockConfiguration', request_name => 'publicAccessBlock', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::S3AccessPointConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::S3AccessPointConfiguration object:

  $service_obj->Method(Att1 => { AccessPointPolicy => $value, ..., PublicAccessBlock => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::S3AccessPointConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessPointPolicy

=head1 DESCRIPTION

The configuration for an Amazon S3 access point for the bucket. You can
propose up to 10 access points per bucket. If the proposed Amazon S3
access point configuration is for an existing bucket, the access
preview uses the proposed access point configuration in place of the
existing access points. To propose an access point without a policy,
you can provide an empty string as the access point policy. For more
information, see Creating access points
(https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html).
For more information about access point policy limits, see Access
points restrictions and limitations
(https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html).

=head1 ATTRIBUTES


=head2 AccessPointPolicy => Str

The access point policy.


=head2 NetworkOrigin => L<Paws::AccessAnalyzer::NetworkOriginConfiguration>

The proposed C<Internet> and C<VpcConfiguration> to apply to this
Amazon S3 access point. If the access preview is for a new resource and
neither is specified, the access preview uses C<Internet> for the
network origin. If the access preview is for an existing resource and
neither is specified, the access preview uses the exiting network
origin.


=head2 PublicAccessBlock => L<Paws::AccessAnalyzer::S3PublicAccessBlockConfiguration>

The proposed C<S3PublicAccessBlock> configuration to apply to this
Amazon S3 Access Point.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

