/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.gco.NameValue;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

abstract class NameAdapter<ValueType extends NameAdapter<ValueType, BoundType>, BoundType extends GenericName>
extends XmlAdapter<ValueType, BoundType> {
    GenericName name;

    NameAdapter() {
    }

    private void ensureUndefined() throws IllegalStateException {
        if (this.name != null) {
            throw new IllegalStateException(Errors.format((short)164, "name"));
        }
    }

    @XmlElementRef
    public final NameValue getValue() {
        NameValue nameValue;
        GenericName genericName = this.name;
        if (genericName instanceof LocalName) {
            if (genericName instanceof TypeName || genericName instanceof MemberName) {
                return null;
            }
            nameValue = new NameValue.Local();
        } else if (genericName instanceof ScopedName) {
            nameValue = new NameValue.Scoped();
        } else {
            return null;
        }
        nameValue.setName(genericName);
        return nameValue;
    }

    @XmlElementRef
    public final DefaultLocalName getName() {
        GenericName genericName = this.name;
        if (genericName instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)genericName);
        }
        if (genericName instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)genericName);
        }
        return null;
    }

    public final void setValue(NameValue nameValue) throws IllegalStateException {
        this.ensureUndefined();
        if (nameValue != null) {
            this.name = nameValue.getName();
        }
    }

    public final void setName(DefaultLocalName defaultLocalName) throws IllegalStateException {
        this.ensureUndefined();
        this.name = defaultLocalName;
    }
}

