use Test::More;
use File::Find;

# This test file will test that all of perl files in the distribution
# compile and have use strict in them

use strict;
use warnings;
use diagnostics;

$|=1;

# if the Test::Strict modules are not installed, then the tests are
# skipped.

eval "use Test::Strict";

plan skip_all => "This is not an error, Test::Strict 1.00 is required
for testing that perl files compile and use strict" if $@;

my %filesToTest;

find(\&wanted, ('./'));

plan tests => (3 * (scalar(keys %filesToTest))) - 2; # -2 due to Native.pm

foreach my $file (sort keys %filesToTest){

    # check all files for syntax and strictness.  Note, we skip the
    # strict and warnings test on Native.pm, which is autogenerated,
    # and does not use strict

    syntax_ok($file);
    strict_ok($file)   unless $file =~ /Native\.pm$/;
    warnings_ok($file) unless $file =~ /Native\.pm$/;;

}

sub wanted {

    # find the .pm, the .t, .pl and .PL files to test

    # don't check under ./lib, as we check under ./blib

    if (/\.(pm|t|pl|PL)$/ && $File::Find::name !~ /^\.\/lib\//){

	$filesToTest{$File::Find::name} = undef;

    }

}
