use warnings;
use strict;
use 5.008;
use ExtUtils::MakeMaker;

if( build_hashes() ) {
	WriteMakefile(
  	  NAME              => 'Lingua::GA::Gramadoir',
  	  VERSION_FROM      => 'lib/Lingua/GA/Gramadoir.pm',
	  EXE_FILES         => ['scripts/gram-ga.pl'],
  	  PREREQ_PM         => { 
	  			'Carp' => '0',
				'Encode' => '0',
				'ExtUtils::MakeMaker' => '6.03',
	  			'File::Spec' => '0.83',
				'Getopt::Long' => '2.32',
				'Memoize' => '0.52',
				'Memoize::ExpireLRU' => '0',
	  			'Storable' => '2.04',
	  			'String::Approx' => '3.19',
				'Term::ANSIColor' => '1.05',
	    			},
	  clean		    => { 
	  			FILES => "lib/Lingua/GA/Gramadoir/*.hash"
				},
  	  ($] >= 5.005 ?
   	   (ABSTRACT_FROM  => 'lib/Lingua/GA/Gramadoir.pm',
   	    AUTHOR         => 'Kevin P. Scannell <scannell@slu.edu>') : ()),
	);
}
else {
	die "Problem creating dictionary hash tables.\n";
}

sub build_hashes {
	use Storable;
	use File::Spec;

	my $dir = File::Spec->catfile( 'lib', 'Lingua', 'GA', 'Gramadoir' );
	my $srcdir = File::Spec->catfile( 'share' );


	my $combofile = File::Spec->catfile( $dir, 'nocombo.hash');
	my $replfile = File::Spec->catfile( $dir, 'eile.hash');
	my $errfile = File::Spec->catfile( $dir, 'earraidi.hash');
	my $posfile = File::Spec->catfile( $dir, 'pos.hash');
	my $gramfile = File::Spec->catfile( $dir, '3grams.hash');
	my $rawfile;

	for my $i (0 .. 6) {
		my $lexfile = File::Spec->catfile( $dir, "focail$i.hash");
		unless( -f $lexfile ) {
			my %FOCAIL;
	
			$rawfile = File::Spec->catfile( $srcdir, "focail$i.bs");
			open(DATABASE, $rawfile) or die "Can't open dictionary: $!";
			binmode DATABASE, ":bytes";
			{
			local $/ = "\cJ";
			my $grambytes;  # byte semantics always
#			binmode DATABASE, ":utf8";
			chomp(my $currword=<DATABASE>);
#			binmode DATABASE, ":bytes";
			chomp($grambytes = <DATABASE>);
			$FOCAIL{$currword} = $grambytes;
#			binmode DATABASE, ":utf8";
			while (<DATABASE>) {
				chomp;
				m/^([0-9]*)(.*)/;
				$currword = substr($currword,0,$1).$2;
#				binmode DATABASE, ":bytes";
				chomp ($grambytes = <DATABASE>);
				$FOCAIL{$currword} = $grambytes;
#				binmode DATABASE, ":utf8";
			}
			}
			close DATABASE;
			store \%FOCAIL, $lexfile;
		}
	}
	unless ( -f $replfile ) {
		my %EILE;
		$rawfile = File::Spec->catfile( $srcdir, 'eile.bs');
		open(DATABASE, $rawfile) or die "Can't open dictionary: $!";
		binmode DATABASE, ":bytes";
#		binmode DATABASE, ":utf8";
		while (<DATABASE>) {
			chomp;
			m/^([^ ]*) (.*)$/;
			$EILE{$1} = $2;
		}
		close DATABASE;
		store \%EILE, $replfile;
	}

	unless ( -f $errfile ) {
		my %EARRAIDI;
		$rawfile = File::Spec->catfile( $srcdir, 'earraidi.bs');
		open(DATABASE, $rawfile) or die "Can't open dictionary: $!";
		binmode DATABASE, ":bytes";
#		binmode DATABASE, ":utf8";
		while (<DATABASE>) {
			chomp;
			m/^([^ ]*) (.*)$/;
			$EARRAIDI{$1} = $2;
		}
		close DATABASE;
		store \%EARRAIDI, $errfile;
	}

	unless ( -f $posfile ) {
		my %POS;
		$rawfile = File::Spec->catfile( $srcdir, 'pos.bs');
		open(DATABASE, $rawfile) or die "Can't open dictionary: $!";
		binmode DATABASE, ":bytes";
#		binmode DATABASE, ":utf8";
		while (<DATABASE>) {
			chomp;
			m/^([^ ]*) (.*)$/;
			$POS{$1} = $2;
		}
		close DATABASE;
		store \%POS, $posfile;
	}

	unless ( -f $gramfile ) {
		my %GRAMS;
		$rawfile = File::Spec->catfile( $srcdir, '3grams.bs');
		open(DATABASE, $rawfile) or die "Can't open dictionary: $!";
		binmode DATABASE, ":bytes";
#		binmode DATABASE, ":utf8";
		while (<DATABASE>) {
			chomp;
			m/^([^ ]*) (.*)$/;
			$GRAMS{$1} = $2;
		}
		close DATABASE;
		store \%GRAMS, $gramfile;
	}
	unless ( -f $combofile ) {
		my %COMBO;
		$rawfile = File::Spec->catfile( $srcdir, 'nocombo.bs');
		open(DATABASE, $rawfile) or die "Can't open dictionary: $!";
		binmode DATABASE, ":bytes";
#		binmode DATABASE, ":utf8";
		while (<DATABASE>) {
			chomp;
			$COMBO{$_}++;
		}
		close DATABASE;
		store \%COMBO, $combofile;
	}
	return ( -f $replfile and -f $combofile and
		-f $errfile and -f $posfile and -f $gramfile );
}
