/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

import java.lang.reflect.Constructor;
import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

public class Factory {
    public static final String CLASS_NAME_KEY = "className";

    private Factory() {
    }

    public static Object create(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not create an instance of " + string + " because of " + throwable);
        }
    }

    public static Object create(ConfigParameters configParameters) {
        String string = configParameters.get(CLASS_NAME_KEY);
        return Factory.createObject(configParameters, string);
    }

    public static Object create(ConfigParameters configParameters, String string) {
        String string2 = configParameters.get(CLASS_NAME_KEY, string);
        return Factory.createObject(configParameters, string2);
    }

    public static Object createOrGet(ConfigParameters configParameters, Object object) {
        String string = configParameters.get(CLASS_NAME_KEY, null);
        return string == null ? object : Factory.createObject(configParameters, string);
    }

    private static Object createObject(ConfigParameters configParameters, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object var3_4 = null;
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(ConfigParameters.class);
                var3_4 = constructor.newInstance(configParameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                var3_4 = clazz.newInstance();
            }
            return var3_4;
        }
        catch (Throwable throwable) {
            throw new FactoryException(configParameters, CLASS_NAME_KEY, throwable);
        }
    }
}

