package SNMP::Insight::MIB::SNMPv2;

#ABSTRACT: Support for data in SNMPv2 MIB

use Moose::Role;

our $VERSION = '0.002';    #TRIAL VERSION:

use SNMP::Insight::Moose::MIB;

use namespace::autoclean;
with 'SNMP::Insight::MIB';

mib_oid "1.3.6.1.2.1.1";
mib_name "SNMPv2-MIB";

has_scalar "sysDescr"    => ( oid => "1" );
has_scalar "sysObjectID" => ( oid => "2" );
has_scalar "sysUpTime"   => ( oid => "3" );
has_scalar "sysContact"  => ( oid => "4" );
has_scalar "sysName"     => ( oid => "5" );
has_scalar "sysLocation" => ( oid => "6" );
has_scalar "sysServices" => ( oid => "7" );

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::MIB::SNMPv2 - Support for data in SNMPv2 MIB

=head1 VERSION

version 0.002

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
