=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::SlideReplaceResult;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ResourceUri;
use AsposeSlidesCloud::Object::Slide;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Represents slide replace result DTO.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut
#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	
	return $self;
}  

# return perl hash
sub to_hash {
    return decode_json(JSON->new->convert_blessed->encode( shift ));
}

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}

# from Perl hashref
sub from_hash {
    my ($self, $hash) = @_;

    # loop through attributes and use swagger_types to deserialize the data
    while ( my ($_key, $_type) = each %{$self->swagger_types} ) {
    	my $_json_attribute = $self->attribute_map->{$_key}; 
        if ($_type =~ /^array\[/i) { # array
            my $_subclass = substr($_type, 6, -1);
            my @_array = ();
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                push @_array, $self->_deserialize($_subclass, $_element);
            }
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                push @_array, $self->_deserialize(lcfirst($_subclass), $_element);
            }
            $self->{$_key} = \@_array;
        } elsif (exists $hash->{$_json_attribute}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{$_json_attribute});
        } elsif (exists $hash->{lcfirst($_json_attribute)}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{lcfirst($_json_attribute)});
        }
    }
  
    return $self;
}

# deserialize non-array data
sub _deserialize {
    my ($self, $type, $data) = @_;
        
    if ($type eq 'DateTime') {
        return DateTime->from_epoch(epoch => str2time($data));
    } elsif ( grep( /^$type$/, ('int', 'double', 'string', 'boolean'))) {
        return $data;
    } else { # hash(model)
        my $_instance = eval "AsposeSlidesCloud::Object::$type->new()";
        return $_instance->from_hash($data);
    }
}



__PACKAGE__->class_documentation({description => 'Represents slide replace result DTO.',
                                  class => 'SlideReplaceResult',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'self_uri' => {
    	datatype => 'ResourceUri',
    	base_name => 'SelfUri',
    	description => 'Gets or sets the link to this resource.',
    	format => '',
    	read_only => '',
    		},
    'alternate_links' => {
    	datatype => 'ARRAY[ResourceUri]',
    	base_name => 'AlternateLinks',
    	description => 'List of alternate links.',
    	format => '',
    	read_only => '',
    		},
    'width' => {
    	datatype => 'double',
    	base_name => 'Width',
    	description => 'Gets or sets the width.',
    	format => '',
    	read_only => '',
    		},
    'height' => {
    	datatype => 'double',
    	base_name => 'Height',
    	description => 'Gets or sets the height.',
    	format => '',
    	read_only => '',
    		},
    'show_master_shapes' => {
    	datatype => 'boolean',
    	base_name => 'ShowMasterShapes',
    	description => 'Specifies if shapes of the master slide should be shown on the slide. True by default.',
    	format => '',
    	read_only => '',
    		},
    'layout_slide' => {
    	datatype => 'ResourceUri',
    	base_name => 'LayoutSlide',
    	description => 'Gets or sets the  link to the layout slide.',
    	format => '',
    	read_only => '',
    		},
    'shapes' => {
    	datatype => 'ResourceUri',
    	base_name => 'Shapes',
    	description => 'Gets or sets the  link to list of top-level shapes.',
    	format => '',
    	read_only => '',
    		},
    'theme' => {
    	datatype => 'ResourceUri',
    	base_name => 'Theme',
    	description => 'Gets or sets the link to theme.',
    	format => '',
    	read_only => '',
    		},
    'placeholders' => {
    	datatype => 'ResourceUri',
    	base_name => 'Placeholders',
    	description => 'Gets or sets the  link to placeholders.',
    	format => '',
    	read_only => '',
    		},
    'images' => {
    	datatype => 'ResourceUri',
    	base_name => 'Images',
    	description => 'Gets or sets the link to images.',
    	format => '',
    	read_only => '',
    		},
    'comments' => {
    	datatype => 'ResourceUri',
    	base_name => 'Comments',
    	description => 'Gets or sets the link to comments.',
    	format => '',
    	read_only => '',
    		},
    'background' => {
    	datatype => 'ResourceUri',
    	base_name => 'Background',
    	description => 'Get or sets the link to slide&#39;s background',
    	format => '',
    	read_only => '',
    		},
    'notes_slide' => {
    	datatype => 'ResourceUri',
    	base_name => 'NotesSlide',
    	description => 'Get or sets the link to notes slide.',
    	format => '',
    	read_only => '',
    		},
    'matches' => {
    	datatype => 'int',
    	base_name => 'Matches',
    	description => 'Gets or sets the number of matches ',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'self_uri' => 'ResourceUri',
    'alternate_links' => 'ARRAY[ResourceUri]',
    'width' => 'double',
    'height' => 'double',
    'show_master_shapes' => 'boolean',
    'layout_slide' => 'ResourceUri',
    'shapes' => 'ResourceUri',
    'theme' => 'ResourceUri',
    'placeholders' => 'ResourceUri',
    'images' => 'ResourceUri',
    'comments' => 'ResourceUri',
    'background' => 'ResourceUri',
    'notes_slide' => 'ResourceUri',
    'matches' => 'int'
} );

__PACKAGE__->attribute_map( {
    'self_uri' => 'SelfUri',
    'alternate_links' => 'AlternateLinks',
    'width' => 'Width',
    'height' => 'Height',
    'show_master_shapes' => 'ShowMasterShapes',
    'layout_slide' => 'LayoutSlide',
    'shapes' => 'Shapes',
    'theme' => 'Theme',
    'placeholders' => 'Placeholders',
    'images' => 'Images',
    'comments' => 'Comments',
    'background' => 'Background',
    'notes_slide' => 'NotesSlide',
    'matches' => 'Matches'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
