=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Xnr - Package for language Kangri

=cut

package Locale::CLDR::Locales::Xnr;
# This file auto generated from Data\common\main\xnr.xml
#	on Fri 17 Jan 12:03:31 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'अफ़ार',
 				'ab' => 'अब्ख़ाज़ियन',
 				'ace' => 'अचाइनीस',
 				'ada' => 'अदान्गमे',
 				'ady' => 'अदिघे',
 				'af' => 'अफ़्रीकी',
 				'agq' => 'अग्हेम',
 				'ain' => 'ऐनू',
 				'ak' => 'अकन',
 				'ale' => 'अलेउत',
 				'alt' => 'दखणे बखें अल्ताई',
 				'am' => 'अम्हेरी',
 				'an' => 'अर्गोनी',
 				'anp' => 'अंगिका',
 				'ar' => 'अरबी',
 				'ar_001' => 'आधुनिक मानक अरबी',
 				'arn' => 'मापूचे',
 				'arp' => 'अरापाहो',
 				'ars' => 'नज्दी अरबी',
 				'as' => 'असमी',
 				'asa' => 'असु',
 				'ast' => 'अस्तुरियन',
 				'av' => 'अवेरिक',
 				'awa' => 'अवधी',
 				'ay' => 'आयमारा',
 				'az' => 'अज़रबैजानी',
 				'az@alt=short' => 'अज़ेरी',
 				'ba' => 'बशख़िर',
 				'ban' => 'बालिनीस',
 				'bas' => 'बसा',
 				'be' => 'बेलारूसी',
 				'bem' => 'बेम्बा',
 				'bez' => 'बेना',
 				'bg' => 'बुल्गारियाई',
 				'bgn' => 'पश्चिमी बलोची',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिस्लामा',
 				'bin' => 'बिनी',
 				'bla' => 'सिक्सिका',
 				'bm' => 'बाम्बारा',
 				'bn' => 'बंगाली',
 				'bo' => 'तिब्बती',
 				'br' => 'ब्रेटन',
 				'brx' => 'बोडो',
 				'bs' => 'बोस्नियाई',
 				'bug' => 'बगिनीस',
 				'byn' => 'ब्लिन',
 				'ca' => 'कातालान',
 				'ccp' => 'चकमा',
 				'ce' => 'चेचन',
 				'ceb' => 'सिबुआनो',
 				'cgg' => 'शिगा',
 				'ch' => 'कमोरो',
 				'chk' => 'चूकीस',
 				'chm' => 'मारी',
 				'cho' => 'चोक्तौ',
 				'chp' => 'शिपेव्यान',
 				'chr' => 'चेरोकी',
 				'chy' => 'शेयेन्न',
 				'ckb' => 'सोरानी कुर्दिश',
 				'ckb@alt=menu' => 'कुर्दी, सोरानी',
 				'co' => 'कोर्सीकन',
 				'cs' => 'चेक',
 				'cu' => 'चर्च साल्विक',
 				'cv' => 'चूवाश',
 				'cy' => 'वेल्श',
 				'da' => 'डेनिश',
 				'dak' => 'दाकोता',
 				'dar' => 'दार्गवा',
 				'dav' => 'तैता',
 				'de' => 'जर्मन',
 				'de_AT' => 'ऑस्ट्रिया आली जर्मन',
 				'de_CH' => 'स्विस उच्च जर्मन',
 				'dgr' => 'डोग्रिब',
 				'dje' => 'झार्मा',
 				'doi' => 'डोगरी',
 				'dsb' => 'बुरला सॉर्बियन',
 				'dua' => 'दुआला',
 				'dv' => 'दिवेही',
 				'dyo' => 'जोला-फोंई',
 				'dz' => 'ज़ोन्गखा',
 				'dzg' => 'दज़ागा',
 				'ebu' => 'एम्बु',
 				'ee' => 'ईवे',
 				'efi' => 'एफिक',
 				'eka' => 'एकाजुक',
 				'el' => 'यूनानी',
 				'en' => 'अंग्रेज़ी',
 				'en_AU' => 'अस्ट्रेलिया आली अंग्रेज़ी',
 				'en_CA' => 'कनेडे आली अंग्रेज़ी',
 				'en_GB' => 'ब्रिटेने आली अंग्रेज़ी',
 				'en_GB@alt=short' => 'यू॰के॰ आली अंग्रेज़ी',
 				'en_US' => 'अमरिके आली अंग्रेज़ी',
 				'eo' => 'एस्पेरेंतो',
 				'es' => 'स्पेनी',
 				'es_419' => 'लैटिन अमरिकी स्पेनिश',
 				'es_ES' => 'यूरोपे आली स्पेनिश',
 				'es_MX' => 'मैक्सिको आली स्पेनिश',
 				'et' => 'एस्टोनिये आली',
 				'eu' => 'बास्क',
 				'ewo' => 'इवोन्डो',
 				'fa' => 'फ़ारसी',
 				'fa_AF' => 'दारी',
 				'ff' => 'फुलाह',
 				'fi' => 'फ़िनिश',
 				'fil' => 'फ़िलिपीनो',
 				'fj' => 'फिजियन',
 				'fo' => 'फ़ैरोइज़',
 				'fon' => 'फॉन',
 				'fr' => 'फ़्रांसीसी',
 				'fr_CA' => 'कनेडे आली फ़्रांसीसी',
 				'fr_CH' => 'स्विस फ़्रांसीसी',
 				'frc' => 'केजन फ़्रांसीसी',
 				'frr' => 'उत्तरी फ़्रीसियाई',
 				'fur' => 'फ्रीयुलीयान',
 				'fy' => 'पश्चिमी फ़्रिसियाई',
 				'ga' => 'आयरिश',
 				'gaa' => 'गा',
 				'gd' => 'स्कॉटिश गाएलिक',
 				'gez' => 'गीज़',
 				'gil' => 'गिल्बरतीस',
 				'gl' => 'गैलिशियन',
 				'gn' => 'गुआरानी',
 				'gor' => 'गोरोन्तालो',
 				'gsw' => 'स्विस जर्मन',
 				'gu' => 'गुजराती',
 				'guz' => 'गुसी',
 				'gv' => 'मैंक्स',
 				'gwi' => 'ग्विचइन',
 				'ha' => 'हौसा',
 				'hai' => 'हैडा',
 				'haw' => 'हवाई',
 				'he' => 'हिब्रू',
 				'hi' => 'हिन्दी',
 				'hi_Latn@alt=variant' => 'हिंग्लिस',
 				'hil' => 'हिलिगेनन',
 				'hmn' => 'ह्मॉंग',
 				'hr' => 'क्रोएशियाई',
 				'hsb' => 'उपरली सॉर्बियन',
 				'ht' => 'हैतियाई',
 				'hu' => 'हंगेरियाई',
 				'hup' => 'हूपा',
 				'hy' => 'आर्मेनियाई',
 				'hz' => 'हरैरो',
 				'ia' => 'इंटरलिंगुआ',
 				'iba' => 'इबान',
 				'ibb' => 'इबिबियो',
 				'id' => 'इंडोनेशियाई',
 				'ie' => 'ईन्टरलिंगुइ',
 				'ig' => 'ईग्बो',
 				'ii' => 'सिचुआन यी',
 				'ilo' => 'इलोको',
 				'inh' => 'इंगुश',
 				'io' => 'इडौ',
 				'is' => 'आइसलैंडिक',
 				'it' => 'इतालवी',
 				'iu' => 'इनूकीटूत्',
 				'ja' => 'जापानी',
 				'jbo' => 'लोज्बान',
 				'jgo' => 'नगोंबा',
 				'jmc' => 'मैकहैमे',
 				'jv' => 'जावानीज़',
 				'ka' => 'जॉर्जियाई',
 				'kaa' => 'कारा-कल्पक',
 				'kab' => 'कबाइल',
 				'kac' => 'काचिन',
 				'kaj' => 'ज्जु',
 				'kam' => 'कम्बा',
 				'kbd' => 'कबार्डियन',
 				'kcg' => 'त्याप',
 				'kde' => 'मैकोंड',
 				'kea' => 'काबुवेर्दियानु',
 				'kfo' => 'कोरो',
 				'kgp' => 'कइंगंग',
 				'kha' => 'खासी',
 				'khq' => 'कोयरा चीनी',
 				'ki' => 'किकुयू',
 				'kj' => 'क्वान्यामा',
 				'kk' => 'कज़ाख़',
 				'kkj' => 'काको',
 				'kl' => 'कलालीसुत',
 				'kln' => 'कलेंजिन',
 				'km' => 'खमेर',
 				'kmb' => 'किम्बन्दु',
 				'kn' => 'कन्नड़',
 				'ko' => 'कोरियाई',
 				'kok' => 'कोंकणी',
 				'kpe' => 'क्पेल',
 				'kr' => 'कनुरी',
 				'krc' => 'कराचय-बल्कार',
 				'krl' => 'करेलियन',
 				'kru' => 'कुरूख',
 				'ks' => 'कश्मीरी',
 				'ksb' => 'शम्बाला',
 				'ksf' => 'बफिआ',
 				'ksh' => 'कोलोनियाई',
 				'ku' => 'कुर्दिश',
 				'kum' => 'कुमीक',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निश',
 				'ky' => 'किर्गीज़',
 				'la' => 'लैटिन',
 				'lad' => 'लादीनो',
 				'lag' => 'लांगि',
 				'lb' => 'लग्ज़मबर्गी',
 				'lez' => 'लेज़्घीयन',
 				'lg' => 'गांडा',
 				'li' => 'लिंबर्गिश',
 				'lkt' => 'लैकोटा',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'lou' => 'लुईज़ियाना क्रियोल',
 				'loz' => 'लोज़ी',
 				'lrc' => 'उत्तरी लूरी',
 				'lt' => 'लिथुआनियाई',
 				'lu' => 'ल्यूबा-कटांगा',
 				'lua' => 'ल्यूबा-लुलुआ',
 				'lun' => 'लुन्डा',
 				'luo' => 'ल्युओ',
 				'lus' => 'मिज़ो',
 				'luy' => 'ल्युईआ',
 				'lv' => 'लातवियाई',
 				'mad' => 'मादुरीस',
 				'mag' => 'मगही',
 				'mai' => 'मैथिली',
 				'mak' => 'मकासर',
 				'mas' => 'मसाई',
 				'mdf' => 'मुगती',
 				'men' => 'मेन्डे',
 				'mer' => 'मेरु',
 				'mfe' => 'मोरीस्येन',
 				'mg' => 'मालागासी',
 				'mgh' => 'मैखुवा-मीट्टो',
 				'mgo' => 'मेटा',
 				'mh' => 'मार्शलीज़',
 				'mi' => 'माओरी',
 				'mic' => 'मिकमैक',
 				'min' => 'मिनांग्काबाउ',
 				'mk' => 'मकदूनियाई',
 				'ml' => 'मलयालम',
 				'mn' => 'मंगोलियाई',
 				'mni' => 'मणिपुरी',
 				'moh' => 'मोहौक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलय',
 				'mt' => 'माल्टीज़',
 				'mua' => 'मुंडैंग',
 				'mul' => 'इक ते जादा बोलियाँ',
 				'mus' => 'क्रीक',
 				'mwl' => 'मिरांडी',
 				'my' => 'बर्मीज़',
 				'myv' => 'एर्ज़या',
 				'mzn' => 'माज़न्देरानी',
 				'na' => 'नाउरू',
 				'nap' => 'नीपोलिटन',
 				'naq' => 'नामा',
 				'nb' => 'नॉर्वेजियाई बोकमाल',
 				'nd' => 'उत्तरी देबेल',
 				'nds' => 'बुरला जर्मन',
 				'ne' => 'नेपाली',
 				'new' => 'नेवाड़ी',
 				'ng' => 'डोन्गा',
 				'nia' => 'नियास',
 				'niu' => 'नियुआन',
 				'nl' => 'डच',
 				'nl_BE' => 'फ़्लेमिश',
 				'nmg' => 'क्वासिओ',
 				'nn' => 'नॉर्वेजियाई नॉयनॉर्स्क',
 				'nnh' => 'गैम्बू',
 				'no' => 'नॉर्वेजियाई',
 				'nog' => 'नोगाई',
 				'nqo' => 'एन्को',
 				'nr' => 'दखण देबेल',
 				'nso' => 'उत्तरी सोथो',
 				'nus' => 'नुएर',
 				'nv' => 'नावाजो',
 				'ny' => 'न्यानजा',
 				'nyn' => 'न्यानकोल',
 				'oc' => 'ओसीटान',
 				'om' => 'ओरोमो',
 				'or' => 'उड़िया',
 				'os' => 'ओस्सेटिक',
 				'osa' => 'ओसेज',
 				'pa' => 'पंजाबी',
 				'pag' => 'पंगासीनान',
 				'pam' => 'पाम्पान्गा',
 				'pap' => 'पापियामेन्टो',
 				'pau' => 'पलोउआन',
 				'pcm' => 'नाइजीरियाई पिडगिन',
 				'pl' => 'पोलिश',
 				'prg' => 'प्रुशियाई',
 				'ps' => 'पश्तो',
 				'pt' => 'पुर्तगाली',
 				'pt_BR' => 'ब्राज़ीली पुर्तगाली',
 				'pt_PT' => 'यूरोपीय पुर्तगाली',
 				'qu' => 'क्वेचुआ',
 				'quc' => 'किश',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रारोतोंगन',
 				'rm' => 'रोमान्श',
 				'rn' => 'रुन्दी',
 				'ro' => 'रोमानियाई',
 				'rof' => 'रोम्बो',
 				'ru' => 'रूसी',
 				'rup' => 'अरोमानियन',
 				'rw' => 'किन्यारवांडा',
 				'rwk' => 'रवा',
 				'sa' => 'संस्कृत',
 				'sad' => 'सन्डावे',
 				'sah' => 'याकूत',
 				'saq' => 'सैम्बुरु',
 				'sat' => 'संथाली',
 				'sba' => 'न्गाम्बे',
 				'sbp' => 'सैंगु',
 				'sc' => 'सार्दिनियन',
 				'scn' => 'सिसिलियन',
 				'sco' => 'स्कॉट्स',
 				'sd' => 'सिंधी',
 				'se' => 'उतरी सामी',
 				'seh' => 'सेना',
 				'ses' => 'कोयराबोरो सेन्नी',
 				'sg' => 'सांगो',
 				'shi' => 'तैचेल्हित',
 				'shn' => 'शैन',
 				'si' => 'सिंहली',
 				'sk' => 'स्लोवाक',
 				'sl' => 'स्लोवेनियाई',
 				'sm' => 'सामोन',
 				'smn' => 'इनारी सामी',
 				'sms' => 'स्कोल्ट सामी',
 				'sn' => 'शोणा',
 				'snk' => 'सोनिन्के',
 				'so' => 'सोमाली',
 				'sq' => 'अल्बानियाई',
 				'sr' => 'सर्बियाई',
 				'srn' => 'स्रानान टॉन्गो',
 				'ss' => 'स्वाती',
 				'ssy' => 'साहो',
 				'st' => 'दखणे बखें सेसेथो',
 				'su' => 'सुंडानी',
 				'suk' => 'सुकुमा',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिली',
 				'swb' => 'कोमोरियन',
 				'ta' => 'तमिल',
 				'te' => 'तेलुगू',
 				'tem' => 'टिम्ने',
 				'teo' => 'टेसो',
 				'tet' => 'तेतुम',
 				'tg' => 'ताजिक',
 				'th' => 'थाई',
 				'ti' => 'तिग्रीन्या',
 				'tig' => 'टाइग्रे',
 				'tk' => 'तुर्कमेन',
 				'tlh' => 'क्लिंगन',
 				'tli' => 'त्लिंगित',
 				'tn' => 'सेत्स्वाना',
 				'to' => 'टोंगन',
 				'tpi' => 'टोक पिसिन',
 				'tr' => 'तुर्की',
 				'trv' => 'तारोको',
 				'ts' => 'सोंगा',
 				'tt' => 'तातार',
 				'tvl' => 'तुवालु',
 				'twq' => 'टासवाक',
 				'ty' => 'ताहितियन',
 				'tyv' => 'तुवीनियन',
 				'tzm' => 'बिचला एटलस तमाज़ित',
 				'udm' => 'उदमुर्त',
 				'ug' => 'उइगर',
 				'uk' => 'यूक्रेनियाई',
 				'umb' => 'उम्बुन्डु',
 				'und' => 'अणजाण बोली',
 				'ur' => 'उर्दू',
 				'uz' => 'उज़्बेक',
 				'vai' => 'वाई',
 				've' => 'वेन्दा',
 				'vi' => 'वियतनामी',
 				'vo' => 'वोलापुक',
 				'vun' => 'वुंजो',
 				'wa' => 'वाल्लून',
 				'wae' => 'वाल्सर',
 				'wal' => 'वलामो',
 				'war' => 'वारै',
 				'wbp' => 'वॉल्पेरी',
 				'wo' => 'वोलोफ़',
 				'wuu' => 'वू चीनी',
 				'xal' => 'काल्मिक',
 				'xh' => 'ख़ोसा',
 				'xnr' => 'कांगड़ी',
 				'xog' => 'सोगा',
 				'yav' => 'यांगबेन',
 				'ybb' => 'येंबा',
 				'yi' => 'यहूदी',
 				'yo' => 'योरूबा',
 				'yue' => 'कैंटोनीज़',
 				'yue@alt=menu' => 'चीनी, कैंटोनीज़',
 				'za' => 'ज़ुआंग',
 				'zgh' => 'मानक मोरक्कन तामाज़ाइट',
 				'zh' => 'चीनी',
 				'zh@alt=menu' => 'चीनी, मैंडेरिन',
 				'zh_Hans' => 'सादी चीनी',
 				'zh_Hans@alt=long' => 'सादी मैंडेरिन चीनी',
 				'zh_Hant' => 'पारंपरिक चीनी',
 				'zh_Hant@alt=long' => 'पारंपरिक मैंडेरिन चीनी',
 				'zu' => 'ज़ुलू',
 				'zun' => 'ज़ूनी',
 				'zxx' => 'कोई बोली सामग्री नी',
 				'zza' => 'ज़ाज़ा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'अरबी',
 			'Armi' => 'इम्पिरियल आर्मेनिक',
 			'Armn' => 'आर्मेनियाई',
 			'Avst' => 'अवेस्तन',
 			'Bali' => 'बाली',
 			'Batk' => 'बटकी',
 			'Beng' => 'बंगाली',
 			'Bopo' => 'बोपोमोफ़ो',
 			'Brah' => 'ब्रह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बगिनीस',
 			'Buhd' => 'बुहिद',
 			'Cakm' => 'चकमा',
 			'Cans' => 'युनिफाइड कैनेडियन एबोरिजनल सिलेबिक्स',
 			'Cari' => 'करैन',
 			'Cham' => 'चाम',
 			'Cher' => 'चेरोकी',
 			'Copt' => 'कॉप्टिक',
 			'Cprt' => 'काइप्रायट',
 			'Cyrl' => 'सिरिलिक',
 			'Cyrs' => 'ओल्ड चर्च स्लावोनिक सिरिलिक',
 			'Deva' => 'देवनागरी',
 			'Dsrt' => 'डेसरेट',
 			'Egyp' => 'इजिप्शियन हाइरोग्लिफ्स',
 			'Ethi' => 'इथियोपियाई',
 			'Geor' => 'जॉर्जियन',
 			'Glag' => 'ग्लेगोलिटिक',
 			'Goth' => 'गोथिक',
 			'Gran' => 'ग्रन्थ',
 			'Grek' => 'यूनानी',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरमुखी',
 			'Hanb' => 'हांब',
 			'Hang' => 'हंगुल',
 			'Hani' => 'हान',
 			'Hano' => 'हनुनू',
 			'Hans' => 'सादी',
 			'Hans@alt=stand-alone' => 'सादी हान',
 			'Hant' => 'पारंपरिक',
 			'Hant@alt=stand-alone' => 'पारंपरिक हान',
 			'Hebr' => 'हिब्रू',
 			'Hira' => 'हिरागाना',
 			'Hmng' => 'पाहो ह्मोन्ग',
 			'Hrkt' => 'जापानी सिलेबरीज़',
 			'Hung' => 'ऑल्ड हंगेरियन',
 			'Ital' => 'पराणी इटली',
 			'Jamo' => 'जामो',
 			'Java' => 'जावानीस',
 			'Jpan' => 'जापानी',
 			'Kali' => 'कायाह ली',
 			'Kana' => 'काताकाना',
 			'Khar' => 'खारोशथी',
 			'Khmr' => 'खमेर',
 			'Knda' => 'कन्नड़',
 			'Kore' => 'कोरियाई',
 			'Kthi' => 'कैथी',
 			'Lana' => 'लाना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ़्रैक्टुर लातिनी',
 			'Latg' => 'गेली लातिनी',
 			'Latn' => 'लैटिन',
 			'Lepc' => 'लेपचा',
 			'Limb' => 'लिम्बू',
 			'Lina' => 'रेखा आली ए',
 			'Linb' => 'रेखा आली बी',
 			'Lyci' => 'लिशियन',
 			'Lydi' => 'लिडियन',
 			'Mand' => 'मनडेन',
 			'Mani' => 'मनीशीन',
 			'Mero' => 'मेरोइटिक',
 			'Mlym' => 'मलयालम',
 			'Mong' => 'मंगोलियाई',
 			'Mtei' => 'मेइतेइ मायेक',
 			'Mymr' => 'म्यांमार',
 			'Nkoo' => 'एन्‘को',
 			'Ogam' => 'ओगम',
 			'Olck' => 'ऑल चिकी',
 			'Orkh' => 'ओरखोन',
 			'Orya' => 'उड़िया',
 			'Osma' => 'ओस्मान्या',
 			'Perm' => 'ओल्ड परमिक',
 			'Phag' => 'फाग्स-पा',
 			'Phli' => 'इंस्क्रिपश्नल पाहलवी',
 			'Phlp' => 'सॉल्टर पाहलवी',
 			'Phnx' => 'फोनिशियन',
 			'Plrd' => 'पॉलार्ड फोनेटिक',
 			'Prti' => 'इंस्क्रिपश्नल पार्थियन',
 			'Rjng' => 'रीजांग',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समरिटन',
 			'Saur' => 'सौरासटर',
 			'Sgnw' => 'सांकेतिक लेख',
 			'Shaw' => 'शावियान',
 			'Sinh' => 'सिंहली',
 			'Sund' => 'सूडानी',
 			'Sylo' => 'सिलोती नागरी',
 			'Syrc' => 'सिरियेक',
 			'Syre' => 'एस्त्रेन्जेलो सिरिएक',
 			'Syrj' => 'पश्चिम सिरिएक',
 			'Syrn' => 'पूर्व सिरिएक',
 			'Tagb' => 'तगबन्वा',
 			'Tale' => 'ताई ली',
 			'Talu' => 'नोआ ताई लु',
 			'Taml' => 'तमिल',
 			'Tavt' => 'ताई विएत',
 			'Telu' => 'तेलुगू',
 			'Tfng' => 'तिफिनाघ',
 			'Tglg' => 'टैगालोग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिब्बती',
 			'Ugar' => 'युगारिटिक',
 			'Vaii' => 'वाई',
 			'Xpeo' => 'पुरानी फारसी',
 			'Xsux' => 'सुमेरो अक्कादियन सुनिफॉर्म',
 			'Yiii' => 'यी',
 			'Zinh' => 'विरासत',
 			'Zmth' => 'गणिते आले संकेतन',
 			'Zsye' => 'ईमोजी',
 			'Zsym' => 'चिह्न',
 			'Zxxx' => 'नी लखोया',
 			'Zyyy' => 'सामान्य',
 			'Zzzz' => 'अणजाण लिपि',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'दुनिया',
 			'002' => 'अफ़्रीका',
 			'003' => 'उत्तर अमरिका',
 			'005' => 'दखण अमरिका',
 			'009' => 'ओशिआनिया',
 			'011' => 'पश्चिमी अफ़्रीका',
 			'013' => 'बिचला अमरिका',
 			'014' => 'पूर्वी अफ़्रीका',
 			'015' => 'उत्तरी अफ़्रीका',
 			'017' => 'बिचला अफ़्रीका',
 			'018' => 'दखणे बखें अफ़्रीका',
 			'019' => 'अमरिका दा',
 			'021' => 'उत्तरी अमरिका',
 			'029' => 'कैरिबियन',
 			'030' => 'पूर्वी एशिया',
 			'034' => 'दखणे बखें एशिया',
 			'035' => 'दखण-पूर्व एशिया',
 			'039' => 'दखणे बखें यूरोप',
 			'053' => 'ऑस्ट्रेलेशिया',
 			'054' => 'मेलानेशिया',
 			'057' => 'माइक्रोनेशियाई लाका',
 			'061' => 'पोलिनेशिया',
 			'142' => 'एशिया',
 			'143' => 'बिचला एशिया',
 			'145' => 'पश्चिमी एशिया',
 			'150' => 'यूरोप',
 			'151' => 'पूर्वी यूरोप',
 			'154' => 'उत्तरी यूरोप',
 			'155' => 'पश्चिमी यूरोप',
 			'202' => 'उप-सहारा अफ़्रीका',
 			'419' => 'लैटिन अमरिका',
 			'AC' => 'असेंशन द्वीप',
 			'AD' => 'एंडोरा',
 			'AE' => 'संयुक्त अरब अमीरात',
 			'AF' => 'अफ़गानिस्तान',
 			'AG' => 'एंटिगुआ कने बरबुडा',
 			'AI' => 'एंग्विला',
 			'AL' => 'अल्बानिया',
 			'AM' => 'आर्मेनिया',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्कटिका',
 			'AR' => 'अर्जेंटीना',
 			'AS' => 'अमरिकी समोआ',
 			'AT' => 'ऑस्ट्रिया',
 			'AU' => 'ऑस्ट्रेलिया',
 			'AW' => 'अरूबा',
 			'AX' => 'एलैंड द्वीपां दा झुंड',
 			'AZ' => 'अज़रबैजान',
 			'BA' => 'बोस्निया कने हर्ज़ेगोविना',
 			'BB' => 'बारबाडोस',
 			'BD' => 'बांग्लादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फ़ासो',
 			'BG' => 'बुल्गारिया',
 			'BH' => 'बहरीन',
 			'BI' => 'बुरुंडी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेंट बार्थेलेमी',
 			'BM' => 'बरमूडा',
 			'BN' => 'ब्रूनेई',
 			'BO' => 'बोलीविया',
 			'BQ' => 'कैरिबियन नीदरलैंड',
 			'BR' => 'ब्राज़ील',
 			'BS' => 'बहामास',
 			'BT' => 'भूटान',
 			'BV' => 'बोवेत द्वीप',
 			'BW' => 'बोत्स्वाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलीज़',
 			'CA' => 'कनेडा',
 			'CC' => 'कोकोस (कीलिंग) द्वीपां दा झुंड',
 			'CD' => 'कांगो - किंशासा',
 			'CD@alt=variant' => 'कांगो (डीआरसी)',
 			'CF' => 'बिचला अफ़्रीकी गणराज्य',
 			'CG' => 'कांगो – ब्राज़ाविल',
 			'CG@alt=variant' => 'कांगो (गणराज्य)',
 			'CH' => 'स्विट्ज़रलैंड',
 			'CI' => 'कोट डी आइवर',
 			'CI@alt=variant' => 'आइवरी कोस्ट',
 			'CK' => 'कुक द्वीपां दा झुंड',
 			'CL' => 'चिली',
 			'CM' => 'कैमरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलंबिया',
 			'CP' => 'क्लिपर्टन द्वीप',
 			'CR' => 'कोस्टारिका',
 			'CU' => 'क्यूबा',
 			'CV' => 'केप वर्ड',
 			'CW' => 'क्यूरासाओ',
 			'CX' => 'क्रिसमस द्वीप',
 			'CY' => 'साइप्रस',
 			'CZ' => 'चेकिया',
 			'CZ@alt=variant' => 'चेक गणराज्य',
 			'DE' => 'जर्मनी',
 			'DG' => 'डिएगो गार्सिया',
 			'DJ' => 'जिबूती',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन गणराज्य',
 			'DZ' => 'अल्जीरिया',
 			'EA' => 'सेउटा कने मेलिला',
 			'EC' => 'इक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'मिस्र',
 			'EH' => 'पश्चिमी सहारा',
 			'ER' => 'इरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथियोपिया',
 			'EU' => 'यूरोपीय संघ',
 			'EZ' => 'यूरोज़ोन',
 			'FI' => 'फ़िनलैंड',
 			'FJ' => 'फ़िजी',
 			'FK' => 'फ़ॉकलैंड द्वीपां दा झुंड',
 			'FK@alt=variant' => 'फ़ॉकलैंड द्वीपां दा झुंड (इज़्लास माल्विनास)',
 			'FM' => 'माइक्रोनेशिया',
 			'FO' => 'फ़ेरो द्वीपां दा झुंड',
 			'FR' => 'फ़्रांस',
 			'GA' => 'गैबॉन',
 			'GB' => 'यूनाइटेड किंगडम',
 			'GB@alt=short' => 'यू॰के॰',
 			'GD' => 'ग्रेनेडा',
 			'GE' => 'जॉर्जिया',
 			'GF' => 'फ़्रेंच गुयाना',
 			'GG' => 'गर्नसी',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलैंड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलूप',
 			'GQ' => 'इक्वेटोरियल गिनी',
 			'GR' => 'यूनान',
 			'GS' => 'दखण जॉर्जिया कने दखण सैंडविच द्वीपां दा झुंड',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गिनी-बिसाउ',
 			'GY' => 'गुयाना',
 			'HK' => 'हाँग काँग (चीन खास प्रशासनिक लाका)',
 			'HK@alt=short' => 'हाँग काँग',
 			'HM' => 'हर्ड द्वीप कने मैकडोनॉल्ड द्वीपां दा झुंड',
 			'HN' => 'होंडूरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैती',
 			'HU' => 'हंगरी',
 			'IC' => 'कैनेरी द्वीपां दा झुंड',
 			'ID' => 'इंडोनेशिया',
 			'IE' => 'आयरलैंड',
 			'IL' => 'इज़राइल',
 			'IM' => 'आइल ऑफ़ मैन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश हिंद महासागरीय लाका',
 			'IQ' => 'इराक',
 			'IR' => 'ईरान',
 			'IS' => 'आइसलैंड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमैका',
 			'JO' => 'जॉर्डन',
 			'JP' => 'जापान',
 			'KE' => 'केन्या',
 			'KG' => 'किर्गिज़स्तान',
 			'KH' => 'कंबोडिया',
 			'KI' => 'किरिबाती',
 			'KM' => 'कोमोरोस',
 			'KN' => 'सेंट किट्स कने नेविस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दखण कोरिया',
 			'KW' => 'कुवैत',
 			'KY' => 'कैमेन द्वीपसमूह',
 			'KZ' => 'कज़ाखस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनान',
 			'LC' => 'सेंट लूसिया',
 			'LI' => 'लिचेंस्टीन',
 			'LK' => 'श्रीलंका',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लग्ज़मबर्ग',
 			'LV' => 'लातविया',
 			'LY' => 'लीबिया',
 			'MA' => 'मोरक्को',
 			'MC' => 'मोनाको',
 			'MD' => 'मॉल्डोवा',
 			'ME' => 'मोंटेनेग्रो',
 			'MF' => 'सेंट मार्टिन',
 			'MG' => 'मेडागास्कर',
 			'MH' => 'मार्शल द्वीपां दा झुंड',
 			'MK' => 'उत्तरी मकदूनिया',
 			'ML' => 'माली',
 			'MM' => 'म्यांमार (बर्मा)',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाऊ (खास प्रशासनिक लाका चीन)',
 			'MO@alt=short' => 'मकाऊ',
 			'MP' => 'उत्तरी मारियाना द्वीपां दा झुंड',
 			'MQ' => 'मार्टीनिक',
 			'MR' => 'मॉरिटानिया',
 			'MS' => 'मोंटसेरात',
 			'MT' => 'माल्टा',
 			'MU' => 'मॉरीशस',
 			'MV' => 'मालदीव',
 			'MW' => 'मलावी',
 			'MX' => 'मैक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मोज़ांबिक',
 			'NA' => 'नामीबिया',
 			'NC' => 'न्यू कैलेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नॉरफ़ॉक द्वीप',
 			'NG' => 'नाइजीरिया',
 			'NI' => 'निकारागुआ',
 			'NL' => 'नीदरलैंड',
 			'NO' => 'नॉर्वे',
 			'NP' => 'नेपाल',
 			'NR' => 'नाउरु',
 			'NU' => 'नीयू',
 			'NZ' => 'न्यूज़ीलैंड',
 			'NZ@alt=variant' => 'औटेआरोआ न्यूज़ीलैंड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ़्रेंच पोलिनेशिया',
 			'PG' => 'पापुआ न्यू गिनी',
 			'PH' => 'फ़िलिपींस',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलैंड',
 			'PM' => 'सेंट पिएरे कने मिक्वेलान',
 			'PN' => 'पिटकैर्न द्वीपसमूह',
 			'PR' => 'पोर्टो रिको',
 			'PS' => 'फ़िलिस्तीनी लाका',
 			'PS@alt=short' => 'फ़िलिस्तीन',
 			'PT' => 'पुर्तगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पराग्वे',
 			'QA' => 'क़तर',
 			'QO' => 'आउटलाइंग ओशिनिया',
 			'RE' => 'रियूनियन',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रवांडा',
 			'SA' => 'सऊदी अरब',
 			'SB' => 'सोलोमन द्वीपसमूह',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सूडान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापुर',
 			'SH' => 'सेंट हेलेना',
 			'SI' => 'स्लोवेनिया',
 			'SJ' => 'स्वालबार्ड कने जान मायेन',
 			'SK' => 'स्लोवाकिया',
 			'SL' => 'सिएरा लियोन',
 			'SM' => 'सैन मेरीनो',
 			'SN' => 'सेनेगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सूरीनाम',
 			'SS' => 'दखण सूडान',
 			'ST' => 'साओ टोम कने प्रिंसिपे',
 			'SV' => 'अल सल्वाडोर',
 			'SX' => 'सिंट मार्टिन',
 			'SY' => 'सीरिया',
 			'SZ' => 'एस्वाटिनी',
 			'SZ@alt=variant' => 'स्वाज़ीलैंड',
 			'TA' => 'ट्रिस्टन दा कुना',
 			'TC' => 'तुर्क कने कैकोज़ द्वीपां दा झुंड',
 			'TD' => 'चाड',
 			'TF' => 'फ़्रांसीसी दखणे बखें लाका',
 			'TG' => 'टोगो',
 			'TH' => 'थाईलैंड',
 			'TJ' => 'ताज़िकिस्तान',
 			'TK' => 'तोकेलाउ',
 			'TL' => 'तिमोर-लेस्त',
 			'TL@alt=variant' => 'पूर्वी तिमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्यूनीशिया',
 			'TO' => 'टोंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'त्रिनिदाद कने टोबैगो',
 			'TV' => 'तुवालू',
 			'TW' => 'ताइवान',
 			'TZ' => 'तंज़ानिया',
 			'UA' => 'यूक्रेन',
 			'UG' => 'युगांडा',
 			'UM' => 'यू॰एस॰ आउटलाइंग द्वीपां दा झुंड',
 			'UN' => 'संयुक्त रास्टर',
 			'US' => 'संयुक्त राज्य',
 			'US@alt=short' => 'अमरिका',
 			'UY' => 'उरूग्वे',
 			'UZ' => 'उज़्बेकिस्तान',
 			'VA' => 'वेटिकन सिटी',
 			'VC' => 'सेंट विंसेंट कने ग्रेनाडाइंस',
 			'VE' => 'वेनेज़ुएला',
 			'VG' => 'ब्रिटिश वर्जिन द्वीपां दा झुंड',
 			'VI' => 'यू॰एस॰ वर्जिन द्वीपां दा झुंड',
 			'VN' => 'वियतनाम',
 			'VU' => 'वनुआतू',
 			'WF' => 'वालिस कने फ़्यूचूना',
 			'WS' => 'समोआ',
 			'XA' => 'सूडो-एक्सेंट',
 			'XB' => 'सूडो-बायडायरेक्शनल',
 			'XK' => 'कोसोवो',
 			'YE' => 'यमन',
 			'YT' => 'मायोते',
 			'ZA' => 'दखण अफ़्रीका',
 			'ZM' => 'ज़ाम्बिया',
 			'ZW' => 'ज़िम्बाब्वे',
 			'ZZ' => 'अणजाण लाका',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'पारम्पारिक जर्मन वर्तनी',
 			'1996' => 'जर्मेनी दी 1996 वर्तनी',
 			'MONOTON' => 'एकस्वरीय',
 			'NJIVA' => 'जनीवा बोली',
 			'POLYTON' => 'बड़े सारे स्वरां आली',
 			'POSIX' => 'कम्प्यूटर',
 			'REVISED' => 'संशोधित वर्तनी',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'कैलेंडर',
 			'cf' => 'मुद्रा प्रारूप',
 			'collation' => 'सॉर्ट क्रम',
 			'currency' => 'मुद्रा',
 			'hc' => 'घंटेयां दा चक्र (12 कने 24)',
 			'lb' => 'पंक्ति विच्छेद शैली',
 			'ms' => 'मापन प्रणाली',
 			'numbers' => 'संख्यां',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध पंचांग},
 				'chinese' => q{चीनी पंचांग},
 				'dangi' => q{दांगी कैलेंडर},
 				'ethiopic' => q{इथियोपिक कैलेंडर},
 				'gregorian' => q{ग्रेगोरियन कैलेंडर},
 				'hebrew' => q{हिब्रू पंचांग},
 				'indian' => q{भारतीय रास्टरिया कैलेंडर},
 				'islamic' => q{इस्लामी पंचांग},
 				'islamic-civil' => q{इस्लामी नागरिक पंचांग},
 				'iso8601' => q{आईएसओ-8601 कैलेंडर},
 				'japanese' => q{जापानी पंचांग},
 				'persian' => q{फ़ारसी कैलेंडर},
 				'roc' => q{चीनी गणतंत्र पंचांग},
 			},
 			'cf' => {
 				'account' => q{लेखांकन मुद्रा प्रारूप},
 				'standard' => q{मानक मुद्रा प्रारूप},
 			},
 			'collation' => {
 				'big5han' => q{पारम्पारिक चीनी वर्गीकरण},
 				'ducet' => q{डिफ़ॉल्ट यूनिकोड सॉर्ट क्रम},
 				'gb2312han' => q{सरलीकृत चीनी वर्गीकरण},
 				'phonebook' => q{फोनबुक छंटाई क्रम},
 				'pinyin' => q{पिनयीन वर्गीकरण},
 				'search' => q{सामान्य-उद्देश्य खोज},
 				'standard' => q{मानक सॉर्ट क्रम},
 				'stroke' => q{स्ट्रोक वर्गीकरण},
 				'traditional' => q{पारम्पारिक वर्गीकरण},
 			},
 			'hc' => {
 				'h11' => q{12 घंटेयां दी प्रणाली (0–11)},
 				'h12' => q{12 घंटेयां दी प्रणाली (1–12)},
 				'h23' => q{24 घंटेयां दी प्रणाली (0–23)},
 				'h24' => q{24 घंटेयां दी प्रणाली (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ढीली लैंण विच्छेद शैली<},
 				'normal' => q{सामान्य लैंण विच्छेद शैली},
 				'strict' => q{सख्त लैंण विच्छेद शैली},
 			},
 			'ms' => {
 				'metric' => q{मेट्रिक प्रणाली},
 				'uksystem' => q{इम्पीरियल मापन प्रणाली},
 				'ussystem' => q{अमरिकी मापन प्रणाली},
 			},
 			'numbers' => {
 				'arab' => q{अरबी-भारतीय अंक},
 				'arabext' => q{बधायो अरबी-भारतीय अंक},
 				'armn' => q{आर्मेनियाई संख्याएँ},
 				'armnlow' => q{आर्मेनियाई लोअरकेस संख्यां},
 				'beng' => q{बंगाली अंक},
 				'deva' => q{देवनागरी अंक},
 				'ethi' => q{इथियोपियाई संख्यां},
 				'fullwide' => q{पूरी चौड़ाई अंक},
 				'geor' => q{जॉर्जियन संख्यां},
 				'grek' => q{यूनानी संख्यां},
 				'greklow' => q{यूनानी लोअरकेस संख्यां},
 				'gujr' => q{गुजराती अंक},
 				'guru' => q{गुरमुखी अंक},
 				'hanidec' => q{चीनी दशमलव संख्यां},
 				'hans' => q{सरलीकृत चीनी संख्यां},
 				'hansfin' => q{सरलीकृत चीनी वित्तीय संख्यां},
 				'hant' => q{पारंपरिक चीनी संख्यां},
 				'hantfin' => q{पारंपरिक चीनी वित्तीय संख्यां},
 				'hebr' => q{हिब्रू संख्यां},
 				'jpan' => q{जापानी संख्यां},
 				'jpanfin' => q{जापानी वित्तीय संख्यां},
 				'khmr' => q{खमेर अंक},
 				'knda' => q{कन्नड़ अंक},
 				'laoo' => q{लाओ अंक},
 				'latn' => q{पश्चिमी अंक},
 				'mlym' => q{मलयालम अंक},
 				'mymr' => q{म्यांमार अंक},
 				'orya' => q{उड़िया अंक},
 				'roman' => q{रोमन संख्यां},
 				'romanlow' => q{रोमन लोअरकेस संख्यां},
 				'taml' => q{पारंपरिक तमिल संख्यां},
 				'tamldec' => q{तमिल अंक},
 				'telu' => q{तेलुगू अंक},
 				'thai' => q{थाई अंक},
 				'tibt' => q{तिब्बती अंक},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{मीट्रिक},
 			'UK' => q{यूके},
 			'US' => q{यूएस},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'बोली: {0}',
 			'script' => 'लिपि: {0}',
 			'region' => 'लाका: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ॄ]},
			main => qr{[‌‍ ़ ँ ंः ॐ अ आ इ ई उ ऊ ऍ ए ऐ ऑ ओ औ क ख ग घ ङ च छ ज झ ञ ट ठ ड ढ ण त थ द ध न प फ ब भ म य र ल ळ व श स ह ऽ ा ि ी ु ू ृ ॅ े ै ॉ ो ौ ्]},
			numbers => qr{[\- ‑ , . % ‰ + 0० 1१ 2२ 3३ 4४ 5५ 6६ 7७ 8८ 9९]},
			punctuation => qr{[\- ‑ , ; \: ! ? . '‘’ "“” ( ) \[ \] \{ \} ॰]},
		};
	},
EOT
: sub {
		return {};
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(खास पास्सा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(खास पास्सा),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} पूरब),
						'north' => q({0} उत्तर),
						'south' => q({0} दखण),
						'west' => q({0} पच्छम),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} पूरब),
						'north' => q({0} उत्तर),
						'south' => q({0} दखण),
						'west' => q({0} पच्छम),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} हर {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} हर {1}),
					},
					# Long Unit Identifier
					'times' => {
						'1' => q({0}-{1}),
					},
					# Core Unit Identifier
					'times' => {
						'1' => q({0}-{1}),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}पू),
						'north' => q({0}उ),
						'south' => q({0}द),
						'west' => q({0}प),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}पू),
						'north' => q({0}उ),
						'south' => q({0}द),
						'west' => q({0}प),
					},
				},
			} }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0}, कने {1}),
				2 => q({0} कने {1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'other' => '0 हजार',
				},
				'10000' => {
					'other' => '00 हजार',
				},
				'100000' => {
					'other' => '0 लख',
				},
				'1000000' => {
					'other' => '00 लख',
				},
				'10000000' => {
					'other' => '0 क॰',
				},
				'100000000' => {
					'other' => '00 क॰',
				},
				'1000000000' => {
					'other' => '0 अ॰',
				},
				'10000000000' => {
					'other' => '00 अ॰',
				},
				'100000000000' => {
					'other' => '0 ख॰',
				},
				'1000000000000' => {
					'other' => '00 ख॰',
				},
				'10000000000000' => {
					'other' => '0 नील',
				},
				'100000000000000' => {
					'other' => '00 नील',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0 हजार',
				},
				'10000' => {
					'other' => '00 हजार',
				},
				'100000' => {
					'other' => '0 लख',
				},
				'1000000' => {
					'other' => '00 लख',
				},
				'10000000' => {
					'other' => '0 करोड़',
				},
				'100000000' => {
					'other' => '00 करोड़',
				},
				'1000000000' => {
					'other' => '0 अरब',
				},
				'10000000000' => {
					'other' => '00 अरब',
				},
				'100000000000' => {
					'other' => '0 खरब',
				},
				'1000000000000' => {
					'other' => '00 खरब',
				},
				'10000000000000' => {
					'other' => '000 खरब',
				},
				'100000000000000' => {
					'other' => '0000 खरब',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0 हजार',
				},
				'10000' => {
					'other' => '00 हजार',
				},
				'100000' => {
					'other' => '0 लख',
				},
				'1000000' => {
					'other' => '00 लख',
				},
				'10000000' => {
					'other' => '0 क॰',
				},
				'100000000' => {
					'other' => '00 क॰',
				},
				'1000000000' => {
					'other' => '0 अ॰',
				},
				'10000000000' => {
					'other' => '00 अ॰',
				},
				'100000000000' => {
					'other' => '0 ख॰',
				},
				'1000000000000' => {
					'other' => '00 ख॰',
				},
				'10000000000000' => {
					'other' => '0 नील',
				},
				'100000000000000' => {
					'other' => '00 नील',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(कट्ठा अरब अमीरात दा दिराम),
				'other' => q(कट्ठा अरब अमीरात दे दिराम),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफ़गान दा अफ़गानी),
				'other' => q(अफ़गान दे अफ़गानी),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(अल्बानिया दा लेक),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(आर्मेनिया दा द्राम),
				'other' => q(आर्मेनिया दे द्राम),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(नीदरलैंड एंटिलिया दा गिल्डर),
				'other' => q(नीदरलैंड एंटीलिया दे गिल्डर),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(अंगोला दा क्वांज़ा),
				'other' => q(अंगोला दे क्वांज़ा),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(अर्जेंटीनी दा पेसो),
				'other' => q(अर्जेंटीनी दे पेसो),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(अस्ट्रेलिया दा डॉलर),
				'other' => q(अस्ट्रेलिया दे डॉलर),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(अरूबा दा फ़्लोरिन),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(अज़रबैजान दा मैनेट),
				'other' => q(अज़रबैजान दे मैनेट),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(बोस्निया हर्ज़ेगोविना बदलने जोगा मार्क),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(बार्बेडिया दा डॉलर),
				'other' => q(बार्बेडिया दे डॉलर),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बांग्लादेशे दा टका),
				'other' => q(बांग्लादेशे दे टका),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(बुल्गारिया दा लेव),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(बहरेने दा दिनार),
				'other' => q(बहरेने दे दिनार),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(बुरूंडी दा फ़्रैंक),
				'other' => q(बुरूंडी दे फ़्रैंक),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(बरमूडा दा डॉलर),
				'other' => q(बरमूडा दे डॉलर),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रूने दे डॉलर),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(बोलिविया दा बोलिवियानो),
				'other' => q(बोलिविया दे बोलिवियानो),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ब्राज़ीले दा रियाल),
				'other' => q(ब्राज़ीले दे रियाल),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(बहामा दा डॉलर),
				'other' => q(बहामा दे डॉलर),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भूटाने दा नंगलट्रम),
				'other' => q(भूटाने दे नंगलट्रम),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(बोत्सवानियाई दा पुला),
				'other' => q(बोत्सवानिया दे पुला),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(बेलारूस दा रूबल),
				'other' => q(बेलारूस दे रूबल),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(बेलीज़ दा डॉलर),
				'other' => q(बेलीज़ दे डॉलर),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(कनेडा दा डॉलर),
				'other' => q(कनेडा दे डॉलर),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(कोंगोली फ़्रैंक),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(स्विस फ़्रैंक),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(चिली पेसो),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(चीनी युआन \(ऑफ़शोर\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(चीनी युआन),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(कोलंबिया दा पेसो),
				'other' => q(कोलंबिया दे पेसो),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(कोस्टा रिका कोलोन),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(क्यूबा बदलने जोगा पेसो),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(क्यूबा दा पेसो),
				'other' => q(क्यूबा दे पेसो),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(केप वर्ड एस्कूडो),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(चेक गणराज्य कोरुना),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(जिबूती दा फ़्रैंक),
				'other' => q(जिबूती दे फ़्रैंक),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(डैनिश क्रोन),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(डैनमार्के दा पेसो),
				'other' => q(डैनमार्के दे पेसो),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(अल्जीरिया दा दिनार),
				'other' => q(अल्जीरिया दे दिनार),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(मिस्र दा पाउंड),
				'other' => q(मिस्र दे पाउंड),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(इरीट्रिया दा नाक्फ़ा),
				'other' => q(इरीट्रिया दे नाक्फ़ा),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(इथियोपिया दा बिर),
				'other' => q(इथियोपिया दे बिर),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(यूरो),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फ़िजी डॉलर),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(फ़ॉकलैंड टापुआं दे झुंडे दे पाउंड),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ब्रिटिश पाउंड स्टर्लिंग),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(जॉर्जिया दा लारी),
				'other' => q(जॉर्जिया दे लारी),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(घाना दा सेडी),
				'other' => q(घाना दे सेडी),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(जिब्राल्टरे दा पाउंड),
				'other' => q(जिब्राल्टरे दे पाउंड),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(गैंबिया दा डलासी),
				'other' => q(गैंबिया दे डलासी),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(गिनाया दा फ़्रैंक),
				'other' => q(गिनीया दे फ़्रैंक),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ग्वाटेमाला दा क्वेटज़ल),
				'other' => q(ग्वाटेमाला दे क्वेटज़ल),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(गयाना दा डॉलर),
				'other' => q(गयाना दे डॉलर),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(हाँगकाँगे दा डॉलर),
				'other' => q(हाँगकाँग दे डॉलर),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(होंडुरे दा लेम्पिरा),
				'other' => q(होंडुरे दे लेम्पिरा),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(क्रोएशिया दा कुना),
				'other' => q(क्रोएशिया दे कुना),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(हैतिया दा गर्ड),
				'other' => q(हैतियाई दे गर्ड),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(हंगेरिया दा फ़ोरिंट),
				'other' => q(हंगेरिया दे फ़ोरिंट),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इंडोनेशिया दा रुपिया),
				'other' => q(इंडोनेशिया दे रुपिये),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(इज़राइली न्यू शेकेल),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(भारते दा रुपया),
				'other' => q(भारते दे रुपए),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(इराके दिनार),
				'other' => q(इराके दे दिनार),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ईराने दा रियाल),
				'other' => q(ईराने दे रियाल),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(आइसलैंडे दा क्रोना),
				'other' => q(आइसलैंडे दे क्रोना),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(जमैका दा डॉलर),
				'other' => q(जमैके दे डॉलर),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(जॉर्डनिया दा दिनार),
				'other' => q(जॉर्डनिया दे दिनार),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(जपाने दा येन),
				'other' => q(जपाने दे येन),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(केन्या दा शिलिंग),
				'other' => q(केन्या दे शिलिंग),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(किर्गिस्ताने दा सोम),
				'other' => q(किर्गिस्ताने दे सोम),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कंबोडिया दा रियाल),
				'other' => q(कंबोडिया दे रियाल),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(कोमोरिया दा फ़्रैंक),
				'other' => q(कोमोरिया दे फ़्रैंक),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(उत्तर कोरिया दा वॉन),
				'other' => q(उत्तर कोरिया दे वॉन),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(दखण कोरिया दा वॉन),
				'other' => q(दखण कोरिया दे वॉन),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(कुवैते दा दिनार),
				'other' => q(कुवैते दे दिनार),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(कैमेन टापुआं दे झुंडे दा डॉलर),
				'other' => q(कैमेन टापुआं दे झुंडे दे डॉलर),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(कज़ाखिस्ताने दा टेंज़),
				'other' => q(कज़ाखिस्ताने दे टेंज),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लाओशिया दा किप),
				'other' => q(लाओशिया दे किप),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(लेबनाने दा पाउंड),
				'other' => q(लेबनाने दे पाउंड),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्रीलंका दा रुपया),
				'other' => q(श्रीलंका दे रुपए),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(लाइबेरिया दा डॉलर),
				'other' => q(लाइबेरिया दे डॉलर),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(लीबिया दा दिनार),
				'other' => q(लीबिया दे दिनार),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(मोरक्को दा दिरहम),
				'other' => q(मोरक्को दे दिरहम),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(मोल्डोवा दा लियू),
				'other' => q(मोल्डोवा दे लियू),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(मालागासे दा आरियरी),
				'other' => q(मालागासे दे आरियरी),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(मैसीडोनिया दा दिनार),
				'other' => q(मैसीडोनिया दे दिनार),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यांमार दा क्याट),
				'other' => q(म्यांमार दे क्याट),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(मंगोलिया दा टगरिक),
				'other' => q(मंगोलिया दे टगरिक),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(मेकानी दा पाटाका),
				'other' => q(मेकानी दे पाटाके),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(मॉरीटेनिया दा ओगुइया),
				'other' => q(मॉरीटेनिया दे ओगुइया),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(मारिशियश दा रुपया),
				'other' => q(मारिशियश दे रुपया),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालदीवी दा रुफ़िया),
				'other' => q(मालदीवी दे रुफ़िया),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(मालावियन दा क्वाचा),
				'other' => q(मालावियन दे क्वाचा),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(मैक्सिकन दा पेसो),
				'other' => q(मैक्सिकन दे पेसो),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियाई दा रिंगित),
				'other' => q(मलेशियाई दे रिंगित),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(मोज़ाम्बिकन दा मेटिकल),
				'other' => q(मोज़ाम्बिकन दे मेटिकल),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(नामीबियाई दा डॉलर),
				'other' => q(नामीबियाई दे डॉलर),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(नाइजीरियाई दा नाइरा),
				'other' => q(नाइजीरियाई दे नाइरा),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(निकारागुअन दा कोरडोबा),
				'other' => q(निकारागुअन दे कोरडोबा),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(नॉर्वेजियन दा क्रोन),
				'other' => q(नॉर्वेजियन दे क्रोन),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(नेपाले दा रुपया),
				'other' => q(नेपाले दे रुपए),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(न्यूज़ीलैंड दा डॉलर),
				'other' => q(न्यूज़ीलैंड दे डॉलर),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ओमानी दा रियाल),
				'other' => q(ओमानी दे रियाल),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(पनामेनियन दा बैल्बोआ),
				'other' => q(पनामेनियन दे बैल्बोआ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(पेरूवियन दा सोल),
				'other' => q(पेरूवियन दे सोल),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पापुआ नोआ गिनीयन किना),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(फ़िलिपीनी दा पेसो),
				'other' => q(फ़िलिपीनी दे पेसो),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्ताने दा रुपया),
				'other' => q(पाकिस्ताने दे रुपए),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(पोलिश दा ज़्लॉटी),
				'other' => q(पोलिश दे ज़्लॉटी),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(पैराग्वियन दा गुआरानी),
				'other' => q(पैराग्वियन दे गुआरानी),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(क़तरी दा रियाल),
				'other' => q(क़तरी दे रियाल),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(रोमानिया दा ल्यू),
				'other' => q(रोमानिया दे ल्यू),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(सर्बिया दा दिनार),
				'other' => q(सर्बिया दे दिनार),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रूसे दा रूबल),
				'other' => q(रूसे दे रूबल),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(रवांडा दा फ़्रैंक),
				'other' => q(रवांडा दे फ़्रैंक),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(सउदी दा रियाल),
				'other' => q(सउदी दे रियाल),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन टापुआं दे झुंडे दा डॉलर),
				'other' => q(सोलोमन टापुआं दे झुंडे दे डॉलर),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(सेशेल्सिया दा रुपया),
				'other' => q(सेशेल्सिया दे रुपए),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(सूडाने दा पाउंड),
				'other' => q(सूडाने दे पाउंड),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(स्वीडेने दा क्रोना),
				'other' => q(स्वीडेने दे क्रोना),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिंगापुरे दा डॉलर),
				'other' => q(सिंगापुरे दे डॉलर),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(सेंट हेलेना दा पाउंड),
				'other' => q(सेंट हेलेना दे पाउंड),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(सिएरा लियोनिया दा लियोन),
				'other' => q(सिएरा लियोनिया दे लियोन),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(सिएरा लियोनिया दा लियोन \(1964—2022\)),
				'other' => q(सिएरा लियोनिया दे लियोन \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(सोमाले दा शिलिंग),
				'other' => q(सोमाले दे शिलिंग),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(सूरीनामे दा डॉलर),
				'other' => q(सूरीनामे दे डॉलर),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(दखण सूडाने दा पाउंड),
				'other' => q(दखण सूडाने दे पाउंड),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(साओ टोम कने प्रिंसिपे दा डोबरा),
				'other' => q(साओ टोम कने प्रिंसिपे दे डोबरा),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(सीरिया दा पाउंड),
				'other' => q(सीरिया दे पाउंड),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(स्वाज़ी लिलांजेनी),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(थाई बहत),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ताजिकिस्ताने दा सोमोनी),
				'other' => q(ताजिकिस्ताने दे सोमोनी),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(तुर्कमेनिस्ताने दा मैनत),
				'other' => q(तुर्कमेनिस्ताने दे मैनत),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ट्यूनीशिया दा दिनार),
				'other' => q(ट्यूनीशिया दे दिनार),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टोंगे दा पांगा),
				'other' => q(टोंगे दे पांगा),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(तुर्के दा लीरा),
				'other' => q(तुर्के दे लीरा),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(त्रिनिदाद कने टोबैगो दा डॉलर),
				'other' => q(त्रिनिदाद कने टोबैगो दे डॉलर),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(नोआ ताईवानी डॉलर),
				'other' => q(नोए ताईवानी डॉलर),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(तंज़ानिया दा शिलिंग),
				'other' => q(तंज़ानिया दे शिलिंग),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(यूक्रेनिया दा रिव्निया),
				'other' => q(यूक्रेनिया दे रिव्निया),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(युगांडा दा शिलिंग),
				'other' => q(युगांडा दे शिलिंग),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(यूएस दा डॉलर),
				'other' => q(यूएस दे डॉलर),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(उरुग्विया दा पेसो),
				'other' => q(उरुग्विया दे पेसो),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(उज़्बेकिस्ताने दा सोम),
				'other' => q(उज़्बेकिस्ताने दे सोम),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(वेनेज़ुएला दा बोलिवर),
				'other' => q(वेनेज़ुएला दे बोलिवर),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(वियतनामे दा डोंग),
				'other' => q(वियतनामे दे डोंग),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(वनुआतू दा वातू),
				'other' => q(वनुआतू दे वातू),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(समोआ दा ताला),
				'other' => q(समोआ दे ताला),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(केंद्रीय अफ़्रीका दा CFA फ़्रैंक),
				'other' => q(केंद्रीय अफ़्रीका दे CFA फ़्रैंक),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(पूर्वी कैरिबिया दा डॉलर),
				'other' => q(पूर्वी कैरिबिया दे डॉलर),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(पश्चिमी अफ़्रीका दा CFA फ़्रैंक),
				'other' => q(पश्चिमी अफ़्रीका दे CFA फ़्रैंक),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q([CFP] फ़्रैंक),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अणजाण मुद्रा),
				'other' => q(\(अणजाण मुद्रा\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(यमने दा रियाल),
				'other' => q(यमने दे रियाल),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(दखण अफ़्रीका दा रैंड),
				'other' => q(दखण अफ़्रीका दे रैंड),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ज़ाम्बिया दा क्वाचा),
				'other' => q(ज़ाम्बिया दे क्वाचा),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जन॰',
							'फ़र॰',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुल॰',
							'अग॰',
							'सित॰',
							'अक्तू॰',
							'नव॰',
							'दिस॰'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फ़रवरी',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुलाई',
							'अगस्त',
							'सितंबर',
							'अक्तूबर',
							'नवंबर',
							'दिसंबर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ज',
							'फ़',
							'मा',
							'अ',
							'म',
							'जू',
							'जु',
							'अ',
							'सि',
							'अ',
							'न',
							'दि'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'चैतर',
							'बसाख',
							'जेठ',
							'हाड़',
							'सौण',
							'भादों',
							'अस्सु',
							'कत्तक',
							'मगैर',
							'पोह',
							'माहग',
							'फगण'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोआर',
						tue => 'मंगल',
						wed => 'बुध',
						thu => 'वीर',
						fri => 'शुक्कर',
						sat => 'शनि',
						sun => 'तोआर'
					},
					short => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'वी',
						fri => 'शु',
						sat => 'श',
						sun => 'त'
					},
					wide => {
						mon => 'सोआर',
						tue => 'मंगलवार',
						wed => 'बुधवार',
						thu => 'वीरवार',
						fri => 'शुक्करवार',
						sat => 'शनिच्चरवार',
						sun => 'तोआर'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'वी',
						fri => 'शु',
						sat => 'श',
						sun => 'त'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ति1',
						1 => 'ति2',
						2 => 'ति3',
						3 => 'ति4'
					},
					wide => {0 => 'पैले तिन मीन्ने',
						1 => 'दूजे तिन मीन्ने',
						2 => 'तीजे तिन मीन्ने',
						3 => 'चौथे तिन मीन्ने'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{भ्यागा},
					'pm' => q{दपेहरा/संजा},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसा-पैले',
				'1' => 'ईस्वी'
			},
			wide => {
				'1' => 'ईसवी सन'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'सक'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G EEEE, d MMMM y},
			'long' => q{G d MMMM y},
			'medium' => q{G d MMM y},
			'short' => q{G d/M/y},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			GyMMMEd => q{G E, d MMM y},
			GyMMMd => q{G d MMM y},
			GyMd => q{GGGGG d/M/y},
			M => q{M},
			MEd => q{E, d/M},
			MMM => q{MMM},
			MMMEd => q{E, d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			yyyyM => q{GGGGG M/y},
			yyyyMEd => q{G E, d/M/y},
			yyyyMMM => q{G MMM y},
			yyyyMMMEd => q{G E, d MMM y},
			yyyyMMMd => q{G d MMM y},
			yyyyMd => q{G d/M/y},
			yyyyQQQ => q{QQQ G y},
			yyyyQQQQ => q{QQQQ G y},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{d/M/y G},
			MEd => q{E, d/M},
			MMMEd => q{E, d MMM},
			MMMMW => q{MMMM दा सप्ताह W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y दा सप्ताह w},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM – E, d MMM y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(ग्री॰ मै॰ टै॰{0}),
		regionFormat => q({0} टैम),
		regionFormat => q({0} ध्याड़े दे उजाले दा टैम),
		regionFormat => q({0} मानक टैम),
		'Afghanistan' => {
			long => {
				'standard' => q#अफ़गानिस्ताने दा टैम#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिदजान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#एक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#अदीस अबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जीयर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#अस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बमाको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बांगुइ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बैंजुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाऊ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लांटायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राज़ाविले#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुंबूरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#कायरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कासाब्लांका#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउटा#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#दार अस सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबूती#,
		},
		'Africa/Douala' => {
			exemplarCity => q#डूआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#अल आइयून<#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ़्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गाबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहांसबर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#कंपाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्तूम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किंशासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रेविले#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआंडा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुमबाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मलाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुटो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मासेरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#एमबाबेन#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगादिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोनरोविया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नैरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#नेद्जामीना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नियामी#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नौआकशॉट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#औगाडोगू#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोवो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ टोम#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ट्यूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विंडहोक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#मध्य अफ़्रीका दा टैम#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#पैलेी अफ़्रीका दा टैम#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#दखण अफ़्रीका दा मानक टैम#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#पश्चिम अफ़्रीका दी तोंदिया दा टैम#,
				'generic' => q#पश्चिम अफ़्रीका दा टैम#,
				'standard' => q#पश्चिम अफ़्रीका दा मानक टैम#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#अलास्‍का दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#अलास्का दा टैम#,
				'standard' => q#अलास्‍का दा मानक टैम#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#एमेज़ोन दी तोंदिया दा टैम#,
				'generic' => q#एमेज़ोन दा टैम#,
				'standard' => q#एमेज़ोन दा मानक टैम#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#अडक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#एंकरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एंग्विला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एंटीगुआ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#आराग्वेना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रिओजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गालेगोस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#साल्टा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सैन ह्वान#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सैन लूई#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टोकूमन#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशुआइया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरूबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#एसनशियॉन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बेहिया बांडेरास#,
		},
		'America/Barbados' => {
			exemplarCity => q#बारबाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलीज़#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लांक-सेबलोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ विस्ता#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बॉइसी#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्यूनस आयरस#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#कैम्ब्रिज खाड़ी#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#कैंपो ग्रांडे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कैनकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकस#,
		},
		'America/Catamarca' => {
			exemplarCity => q#काटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन#,
		},
		'America/Cayman' => {
			exemplarCity => q#कैमेन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#अटिकोकान#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोर्डोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोस्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#क्यूआबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#कुराकाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डेनमार्कशॉन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डॉसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डॉसन क्रीक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेनवर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रॉयट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमंटन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ईरुनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#अल सल्वाडोर#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#फ़ोर्ट नेल्सन#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फ़ोर्टालेज़ा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस खाड़ी#,
		},
		'America/Godthab' => {
			exemplarCity => q#नुक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूस खाड़ी#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रांड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलोप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ग्वायाकील#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हेलिफ़ैक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हर्मोसिल्लो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नौक्स, इंडियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेंगो, इंडियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पीटर्सबर्ग, इंडियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इंडियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#वेवे, इंडियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#विंसेनेस, इंडियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनामेक, इंडियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इंडियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनूविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालुईट#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजोए#,
		},
		'America/Juneau' => {
			exemplarCity => q#ज्यूनाउ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोंटीसेलो, केंटकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#क्रालैंडिजिक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज़#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लॉस एंजिल्स#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुइसविले#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिंसेस क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मेसीओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मानागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनौस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मैरीगोट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माटामोरोस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#मज़ाटलान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेंडोज़ा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेट्लेकाट्ला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिकेलॉन#,
		},
		'America/Moncton' => {
			exemplarCity => q#मोंकटन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मोंटेरेरी#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोंटेवीडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मोंटसेरात#,
		},
		'America/Nassau' => {
			exemplarCity => q#नासाउ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यूयॉर्क#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ब्यूला, उत्तरी डकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#मध्य, उत्तरी दाकोता#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यू सालेम, उत्तरी डकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओखाजीनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फ़ीनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-ऑ-प्रिंस#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट ऑफ़ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो वेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पोर्टो रिको#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#पुंटा एरिनास#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रेंकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसाइफ़#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रिसोल्यूट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रांको#,
		},
		'America/Santarem' => {
			exemplarCity => q#सैंटारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सैंटियागो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सेंटो डोमिंगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पाउलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#इटोकोर्टोरमिट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सिट्का#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेंट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जोंस#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लूसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट थॉमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विंसेंट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ़्ट करंट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#टेगुसिगल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थ्यूले#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टोर्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#वैंकूवर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हाइटहोर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विनीपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#याकूटाट#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#उत्तरी अमरिकी केंद्रीय दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#उत्तरी अमरिकी केंद्रीय दा टैम#,
				'standard' => q#उत्तरी अमरिकी केंद्रीय दा मानक टैम#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#उत्तरी अमरिकी पैलेी दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#उत्तरी अमरिकी पैलेी टैम#,
				'standard' => q#उत्तरी अमरिकी पैलेी दा मानक टैम#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#उत्तरी अमेरिकी पहाड़े दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#उत्तरी अमरिकी पहाड़े दा टैम#,
				'standard' => q#उत्तरी अमेरिकी पहाड़े दा मानक टैम#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#उत्तरी अमेरिकी प्रशांते दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#उत्तरी अमेरिकी प्रशांते दा टैम#,
				'standard' => q#उत्तरी अमेरिकी प्रशांते दा मानक टैम#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केसी#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेविस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ड्यूमोंट डी अर्विले#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मक्वारी#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#मॉसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#मैकमुर्डो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पॉमर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#स्योवा#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ट्रोल#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#वोस्तोक#,
		},
		'Apia' => {
			long => {
				'daylight' => q#एपिआ दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#एपिआ दा टैम#,
				'standard' => q#एपिआ दा मानक टैम#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#अरब दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#अरब दा टैम#,
				'standard' => q#अरब दा मानक टैम#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लॉन्गईयरबायेन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#अर्जेंटीना दी तोंदिया दा टैम#,
				'generic' => q#अर्जेंटीना दा टैम#,
				'standard' => q#अर्जेंटीना दा मानक टैम#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#पश्चिमी अर्जेंटीना दी तोंदिया दा टैम#,
				'generic' => q#पश्चिमी अर्जेंटीना दा टैम#,
				'standard' => q#पश्चिमी अर्जेंटीना दा मानक टैम#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#आर्मेनिया दी तोंदिया दा टैम#,
				'generic' => q#आर्मेनिया दा टैम#,
				'standard' => q#आर्मेनिया दा मानक टैम#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#अदन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#अल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#अम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#अनाडिर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अक्ताउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#अक्तोब#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#एतराउ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहरीन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकु#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंकॉक#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#बर्नोल#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बेरुत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रूनेई#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कलकाता#,
		},
		'Asia/Chita' => {
			exemplarCity => q#त्शिता#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलंबो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दमास्कस#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिलि#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#डबई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशांबे#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#फ़ामागुस्ता#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाज़ा#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हेब्रोन#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हाँग काँग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होव्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#इर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#यरूशलम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कमचत्का#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमांडू#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खांडिगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#कुआलालंपुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कूचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवैत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाऊ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मागादान#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#मकस्सर#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनीला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्कट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नोवोकुज़्नेत्स्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोवोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओरल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#नोम पेन्ह#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोंटीयांक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योंगयांग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतर#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#कोस्टाने#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#केज़ेलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रंगून#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाद#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो ची मिन्ह शहर#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#सखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकंद#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सिओल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#शंघाई#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#स्रेद्निकोलिमस्क#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताइपेई#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताशकंद#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#टबिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिंपू#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोक्यो#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#तोम्स्क#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबातर#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरूम्की#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#यूस्ट–नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#विएनतियान#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#व्लादिवोस्तोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#याकूत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#येकातेरिनबर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेवान#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#अटलांटिक दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#अटलांटिक दा टैम#,
				'standard' => q#अटलांटिक दा मानक टैम#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#अज़ोरेस#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बरमूडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#कैनेरी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप वर्ड#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फ़ैरो#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#मडेरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रेक्याविक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दखणी जॉर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेंट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टैनली#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडिलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिस्बन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#यूक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होबार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिंडेमान#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लॉर्ड होवे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबोर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#अस्‍ट्रेलिया दे केंद्रीय दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#बिचले अस्ट्रेलिया दा टैम#,
				'standard' => q#अस्‍ट्रेलिया दे केंद्रीय दा मानक टैम#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#अस्‍ट्रेलियाई केंद्रीय पश्चिमी ध्याड़े दे उजाले दा टैम#,
				'generic' => q#अस्‍ट्रेलियाई केंद्रीय पश्चिमी दा टैम#,
				'standard' => q#अस्‍ट्रेलिया केंद्रीय पश्चिमी दा मानक टैम#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#अस्‍ट्रेलियाई पैलेी दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#पैलेी अस्ट्रेलिया दा टैम#,
				'standard' => q#अस्‍ट्रेलियाई पैलेी दा मानक टैम#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#अस्ट्रेलिया पश्चिमी दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#पश्चिमी अस्ट्रेलिया दा टैम#,
				'standard' => q#अस्ट्रेलिया पश्चिमी दा मानक टैम#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#अज़रबैजान दी तोंदिया दा टैम#,
				'generic' => q#अज़रबैजान दा टैम#,
				'standard' => q#अज़रबैजान दा मानक टैम#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#अज़ोरेस दी तोंदिया दा टैम#,
				'generic' => q#अज़ोरेस दा टैम#,
				'standard' => q#अज़ोरेस दा मानक टैम#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#बांग्लादेशे दी तोंदिया दा टैम#,
				'generic' => q#बांग्लादेशा दा टैम#,
				'standard' => q#बांग्लादेशे दा मानक टैम#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#भूटाने दा टैम#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#बोलीविया दा टैम#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राज़ीलिया दी तोंदिया दा टैम#,
				'generic' => q#ब्राज़ीलिया दा टैम#,
				'standard' => q#ब्राज़ीलिया दा मानक टैम#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ब्रूनेई दारूस्सलम दा टैम#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#केप वर्ड दी तोंदिया दा टैम#,
				'generic' => q#केप वर्ड दा टैम#,
				'standard' => q#केप वर्ड दा मानक टैम#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#चामोरो दा मानक टैम#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#चैथम दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#चैथम दा टैम#,
				'standard' => q#चैथम दा मानक टैम#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चिली दी तोंदिया दा टैम#,
				'generic' => q#चिली दा टैम#,
				'standard' => q#चिली दा मानक टैम#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#चीन दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#चीन दा टैम#,
				'standard' => q#चीन दा मानक टैम#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#क्रिसमस टापू दा टैम#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#कोकोस टापुआं दे झुंडे दा टैम#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कोलंबिया दी तोंदिया दा टैम#,
				'generic' => q#कोलंबिया दा टैम#,
				'standard' => q#कोलंबिया दा मानक टैम#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#कुक टापुआं दे झुंडे दा अद्धी तोंदिया दा टैम#,
				'generic' => q#कुक टापुआं दे झुंडे दा टैम#,
				'standard' => q#कुक टापुआं दे झुंडे दा मानक टैम#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#क्यूबा दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#क्यूबा दा टैम#,
				'standard' => q#क्यूबा दा मानक टैम#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#डेविस दा टैम#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ड्यूमोंट डी अर्विले दा टैम#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#पैलेी तिमोरे दा टैम#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ईस्टर टापू दी तोंदिया दा टैम#,
				'generic' => q#ईस्टर टापू दा टैम#,
				'standard' => q#ईस्टर टापू दा मानक टैम#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#इक्वाडोर दा टैम#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#समन्वित दुनिया दा टैम#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अणजाण शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#एम्स्टरडम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#अंडोरा#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#आस्ट्राखान#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथेंस#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्रातिस्लावा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रूसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुख़ारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ब्यूसिनजेन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसीनाउ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनहेगन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डबलिन#,
			long => {
				'daylight' => q#आइरिश दा मानक टैम#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टर#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#गर्नसी#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेलसिंकी#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#आइल ऑफ़ मैन#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्तांबुल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कालीनिनग्राड#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीव#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#किरोव#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ल्यूबेलजाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लंदन#,
			long => {
				'daylight' => q#ब्रिटिश दी तोंदिया दा टैम#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्ज़मबर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#मैड्रिड#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#मारियाहैम#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिंस्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनाको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मॉस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ओस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पैरस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पोड्गोरिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रीगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#समारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सैन मारीनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेवो#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#सारातोव#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फ़ेरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कोप्जे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफ़िया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टॉकहोम#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#तेलिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टाइरेन#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#उल्यानोव्स्क#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#वादुज़#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#वेटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#विएना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#विल्नियस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#वोल्गोग्राड#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वॉरसॉ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ज़ाग्रेब#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ज़्यूरिख़#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#बिचले यूरोपे दी तोंदिया दा टैम#,
				'generic' => q#बिचले यूरोपे दा टैम#,
				'standard' => q#बिचले यूरोपे दा मानक टैम#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#पैलेी यूरोपे दी तोंदिया दा टैम#,
				'generic' => q#पैलेी यूरोपे दा टैम#,
				'standard' => q#पैलेी यूरोपे दा मानक टैम#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#अग्र पैलेी यूरोपे दा टैम#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#पश्चिमी यूरोपे दी तोंदिया दा टैम#,
				'generic' => q#पश्चिमी यूरोपे दा टैम#,
				'standard' => q#पश्चिमी यूरोपे दा मानक टैम#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फ़ॉकलैंड टापुआं दे झुंडे दी तोंदिया दा टैम#,
				'generic' => q#फ़ॉकलैंड टापुआं दे झुंडे दा टैम#,
				'standard' => q#फ़ॉकलैंड टापुआं दे झुंडे दा मानक टैम#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#फ़िजी दी तोंदिया दा टैम#,
				'generic' => q#फ़िजी दा टैम#,
				'standard' => q#फ़िजी दा मानक टैम#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ़्रेंच गुयाना दा टैम#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#दखणे बखें फ़्रांस कने अंटार्कटिक दा टैम#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ग्रीनविच मीन टैम#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गैलापेगोस दा टैम#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#गैंबियर दा टैम#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#जॉर्जिया दी तोंदिया दा टैम#,
				'generic' => q#जॉर्जिया दा टैम#,
				'standard' => q#जॉर्जिया दा मानक टैम#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#गिल्बर्ट टापुआं दे झुंडे दा टैम#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#पैलेी ग्रीनलैंड दी तोंदिया दा टैम#,
				'generic' => q#पैलेी ग्रीनलैंड टैम#,
				'standard' => q#पैलेी ग्रीनलैंड दा मानक टैम#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#पश्चिमी ग्रीनलैंड दी तोंदिया दा टैम#,
				'generic' => q#पश्चिमी ग्रीनलैंड टैम#,
				'standard' => q#पश्चिमी ग्रीनलैंड दा मानक टैम#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#खाड़ी दा मानक टैम#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गुयाना दा टैम#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हवाई–आल्यूशन दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#हवाई–आल्यूशन दा टैम#,
				'standard' => q#हवाई–आल्यूशन दा मानक टैम#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#हाँग काँग दी तोंदिया दा टैम#,
				'generic' => q#हाँग काँग दा टैम#,
				'standard' => q#हाँग काँग दा मानक टैम#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#होव्ड दी तोंदिया दा टैम#,
				'generic' => q#होव्ड दा टैम#,
				'standard' => q#होव्ड दा मानक टैम#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारते दा मानक टैम#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#एंटानानरीवो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#शागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#क्रिसमिस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#करगुलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीव#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मॉरीशस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोत्ते#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रीयूनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#हिंद महासागर दा टैम#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#इंडोचाइना दा टैम#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#बिचले इंडोनेशिया दा टैम#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#पैलेी इंडोनेशिया दा टैम#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#पश्चिमी इंडोनेशिया दा टैम#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ईरान दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#ईरान दा टैम#,
				'standard' => q#ईरान दा मानक टैम#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#इर्कुत्स्क दी तोंदिया दा टैम#,
				'generic' => q#इर्कुत्स्क दा टैम#,
				'standard' => q#इर्कुत्स्क दा मानक टैम#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#इज़राइल दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#इज़राइल दा टैम#,
				'standard' => q#इज़राइल दा मानक टैम#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#जापाने दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#जापाने दा टैम#,
				'standard' => q#जापाने दा मानक टैम#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#पैले कज़ाखस्तान दा टैम#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#पश्चिम कज़ाखस्तान दा टैम#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#कोरियाई दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#कोरियाई दा टैम#,
				'standard' => q#कोरियाई दा मानक टैम#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#कोसराए दा टैम#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#क्रास्नोयार्स्क दी तोंदिया दा टैम#,
				'generic' => q#क्रास्नोयार्स्क दा टैम#,
				'standard' => q#क्रास्नोयार्स्क दा मानक टैम#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#किर्गिस्‍तान दा टैम#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#लाइन टापुआं दे झुंडे दा टैम#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#लॉर्ड होवे दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#लॉर्ड होवे दा टैम#,
				'standard' => q#लॉर्ड होवे दा मानक टैम#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#मागादान दी तोंदिया दा टैम#,
				'generic' => q#मागादान दा टैम#,
				'standard' => q#मागादान दा मानक टैम#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#मलेशिया दा टैम#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#मालदीव दा टैम#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#मार्केसस दा टैम#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#मार्शल टापुआं दे झुंडे दा टैम#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#मॉरीशस दी तोंदिया दा टैम#,
				'generic' => q#मॉरीशस दा टैम#,
				'standard' => q#मॉरीशस दा मानक टैम#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#माव्सन दा टैम#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#मेक्सिकन प्रशांत दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#मेक्सिकन प्रशांत दा टैम#,
				'standard' => q#मेक्सिकन प्रशांत दा मानक टैम#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#उलान बटोर दी तोंदिया दा टैम#,
				'generic' => q#उलान बटोर दा टैम#,
				'standard' => q#उलान बटोर दा मानक टैम#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#मॉस्को दि तोंदिया दा टैम#,
				'generic' => q#मॉस्को दा टैम#,
				'standard' => q#मॉस्को दा मानक टैम#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#म्यांमार दा टैम#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#नौरू दा टैम#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#नेपाल दा टैम#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#न्यू कैलेडोनिया दी तोंदिया दा टैम#,
				'generic' => q#न्यू कैलेडोनिया दा टैम#,
				'standard' => q#न्यू कैलेडोनिया दा मानक टैम#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#न्यूज़ीलैंड दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#न्यूज़ीलैंड दा टैम#,
				'standard' => q#न्यूज़ीलैंड दा मानक टैम#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#न्यूफ़ाउंडलैंड दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#न्यूफ़ाउंडलैंड दा टैम#,
				'standard' => q#न्यूफ़ाउंडलैंड दा मानक टैम#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#नीयू दा टैम#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#नॉरफ़ॉक टापू दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#नॉरफ़ॉक टापू दा टैम#,
				'standard' => q#नॉरफ़ॉक टापू दा मानक टैम#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#फ़र्नांर्डो डे नोरोन्हा दे तोंदिया दा टैम#,
				'generic' => q#फ़र्नांर्डो डे नोरोन्हा दा टैम#,
				'standard' => q#फ़र्नांर्डो डे नोरोन्हा मानक दा टैम#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#नोवोसिबिर्स्क दी तोंदिया दा टैम#,
				'generic' => q#नोवोसिबिर्स्क दा टैम#,
				'standard' => q#नोवोसिबिर्स्क दा मानक टैम#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ओम्स्क दी तोंदिया दा टैम#,
				'generic' => q#ओम्स्क दा टैम#,
				'standard' => q#ओम्स्क दा मानक टैम#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#एपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ऑकलैंड#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#बोगनविले#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चैथम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#एफ़ेट#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फ़ाकाओफ़ो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फ़िजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फ़्यूनाफ़ुटी#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गेलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#गैंबियर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ग्वाडलकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुआम#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#कैंटन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरीतिमाति#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोसराए#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाज़ालीन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#माजुरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मार्केसस#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मिडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नौरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#नीयू#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नॉरफ़ॉक#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नौमिया#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पागो गंगो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पलाऊ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पिटकैर्न#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनपेई#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोरेस्बी#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#रारोटोंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#सायपान#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ताहिती#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#टारावा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टोंगाटापू#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#पाकिस्ताने दी तोंदिया दा टैम#,
				'generic' => q#पाकिस्ताने दा टैम#,
				'standard' => q#पाकिस्ताने दा मानक टैम#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#पलाउ दा टैम#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#पापुआ न्यू गिनी दा टैम#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#पैराग्वे दी तोंदिया दा टैम#,
				'generic' => q#पैराग्वे दा टैम#,
				'standard' => q#पैराग्वे दा मानक टैम#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरू दी तोंदिया दा टैम#,
				'generic' => q#पेरू दा टैम#,
				'standard' => q#पेरू दा मानक टैम#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#फ़िलिपीन दी तोंदिया दा टैम#,
				'generic' => q#फ़िलिपीन दा टैम#,
				'standard' => q#फ़िलिपीन दा मानक टैम#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#फ़ीनिक्स टापुआं दे झुंडे दा टैम#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सेंट पिएरे कने मिक्वेलान दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#सेंट पिएरे कने मिक्वेलान दा टैम#,
				'standard' => q#सेंट पिएरे कने मिक्वेलान दा मानक टैम#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#पिटकैर्न दा टैम#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#पोनापे दा टैम#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#प्योंगयांग दा टैम#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#रीयूनियन दा टैम#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#रोथेरा दा टैम#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#सखालिन दी तोंदिया दा टैम#,
				'generic' => q#सखालिन दा टैम#,
				'standard' => q#सखालिन दा मानक टैम#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#समोआ दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#समोआ दा टैम#,
				'standard' => q#समोआ दा मानक टैम#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#सेशेल्स दा टैम#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#सिंगापुरे दा टैम#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#सोलोमन टापुआं दे झुंडे दा टैम#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#दखण जॉर्जिया दा टैम#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सूरीनामे दा टैम#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#स्योवा दा टैम#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ताहिती दा टैम#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ताइपे दे ध्याड़े दे उजाले दा टैम#,
				'generic' => q#ताइपे दा टैम#,
				'standard' => q#ताइपे दा मानक टैम#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ताजिकिस्ताने दा टैम#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#टोकेलाऊ दा टैम#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#टोंगा दी तोंदिया दा टैम#,
				'generic' => q#टोंगा दा टैम#,
				'standard' => q#टोंगा दा मानक टैम#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#चुक दा टैम#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#तुर्कमेनिस्ताने दी तोंदिया दा टैम#,
				'generic' => q#तुर्कमेनिस्तान दा टैम#,
				'standard' => q#तुर्कमेनिस्ताने दा मानक टैम#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#तुवालू दा टैम#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#उरुग्वे दी तोंदिया दा टैम#,
				'generic' => q#उरुग्वे दा टैम#,
				'standard' => q#उरुग्वे दा मानक टैम#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#उज़्बेकिस्तान दी तोंदिया दा टैम#,
				'generic' => q#उज़्बेकिस्तान दा टैम#,
				'standard' => q#उज़्बेकिस्तान दा मानक टैम#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#वनुआतू दी तोंदिया दा टैम#,
				'generic' => q#वनुआतू दा टैम#,
				'standard' => q#वनुआतू दा मानक टैम#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#वेनेज़ुएला दा टैम#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#व्लादिवोस्तोक दी तोंदिया दा टैम#,
				'generic' => q#व्लादिवोस्तोक दा टैम#,
				'standard' => q#व्लादिवोस्तोक दा मानक टैम#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#वोल्गोग्राड दी तोंदिया दा टैम#,
				'generic' => q#वोल्गोग्राड दा टैम#,
				'standard' => q#वोल्गोग्राड दा मानक टैम#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#वोस्तोक दा टैम#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#वेक टापू दा टैम#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#वालिस कने फ़्यूचूना दा टैम#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#याकुत्स्क दी तोंदिया दा टैम#,
				'generic' => q#याकुत्स्क दा टैम#,
				'standard' => q#याकुत्स्क दा मानक टैम#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#येकातेरिनबर्ग दी तोंदिया दा टैम#,
				'generic' => q#येकातेरिनबर्ग दा टैम#,
				'standard' => q#येकातेरिनबर्ग दा मानक टैम#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#युकॉन टैम#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
