# -*- coding: utf-8 -*-
# vim:fenc=utf-8

# Copyright (C) 2012-2020 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# X2Go Session Broker is free software; you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# X2Go Session Broker is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import unittest
import copy
import tempfile

# Python X2GoBroker modules
import x2gobroker.brokers.zeroconf_broker

class TestX2GoBrokerBackendZeroconf(unittest.TestCase):

    ### TEST: list_profiles() method

    def test_profilelist(self):
        _save_maxDiff = self.maxDiff
        self.maxDiff = None
        list_of_profiles = {
            'unittest': {
                'user': '',
                'defsndport': True,
                'useiconv': False,
                'iconvfrom': 'UTF-8',
                'height': 600,
                'export': '',
                'quality': 9,
                'fullscreen': False,
                'layout': '',
                'useexports': 1,
                'width': 800,
                'speed': 2,
                'soundsystem': 'pulse',
                'print': True,
                'type': 'auto',
                'sndport': 4713,
                'xinerama': True,
                'variant': '',
                'usekbd': True,
                'fstunnel': True,
                'applications': ['TERMINAL','WWWBROWSER','MAILCLIENT','OFFICE',],
                'host': 'localhost',
                'multidisp': 0,
                'sshproxyport': 22,
                'sound': True,
                'rootless': 0,
                'name': 'LOCALHOST',
                'iconvto': 'UTF-8',
                'soundtunnel': True,
                'command': 'KDE',
                'dpi': 96,
                'sshport': 22,
                'setdpi': 0,
                'pack': '16m-jpeg',
                # make sure, hard-coded defaults end up in the list_profiles() output of the zeroconf backend, as well
                'directrdp': False,
            },
        }
        zeroconf_backend = x2gobroker.brokers.zeroconf_broker.X2GoBroker()
        _profiles = zeroconf_backend.list_profiles('user_foo')
        self.assertEqual(len(list(_profiles.keys())), 1)
        _key = list(_profiles.keys())[0]
        # replace profile ID ,,unittest'' with the returned random profile ID (uuid hash)
        _test_profiles = {
            _key: list_of_profiles['unittest']
        }
        self.assertEqual(_profiles, _test_profiles)
        self.maxDiff = _save_maxDiff

    ### TEST: select_profile() method

    def test_desktopshell_uppercase(self):
        _config_defaults = copy.deepcopy(x2gobroker.defaults.X2GOBROKER_CONFIG_DEFAULTS)
        _config = """
[broker_zeroconf]
enable = true
desktop-shell = kDe
"""
        tf = tempfile.NamedTemporaryFile(mode='w')
        tf.write(_config)
        tf.seek(0)
        zeroconf_backend = x2gobroker.brokers.zeroconf_broker.X2GoBroker(config_file=tf.name, config_defaults=_config_defaults)
        _profiles = zeroconf_backend.list_profiles('user_foo')
        self.assertEqual(len(list(_profiles.keys())), 1)
        _key = list(_profiles.keys())[0]
        self.assertEqual(_profiles[_key]['command'], 'KDE')

    def test_sessionselection(self):
        _output = {
            'server': 'localhost',
            'port': 22,
        }
        zeroconf_backend = x2gobroker.brokers.zeroconf_broker.X2GoBroker()
        self.assertEqual(zeroconf_backend.select_session('any-profile-id'), _output)


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestX2GoBrokerBackendZeroconf))
    return suite
