#ifndef UNIT_DEFINITIONS_H
#define UNIT_DEFINITIONS_H 1

#include "known-syntaxes.h"

/* The functions exported by this module are the only ones which need
 * access to the data structures dumped into this file, which are
 * potentially subject to change.  The implementation of this header
 * file is generated by ../grammar/ParseUnits.java, using the
 * unit-definitions.c.template file in that directory.
 *
 * The structure elements with leading underscores are intended to be internal to
 * this unit-definition.c module.
*/

/**
 * Encapsulates per-syntax information about a unit.  This should be
 * regarded as an opaque type, and instances of it, and its contents,
 * should be obtained using the various <code>unity_get_unit...</code>
 * functions.
 */
typedef struct {
    const char* uri;            /* the name for this unit, as a URI */
    int _idx;                   /* the internal index for this unit, in the list of unit_definition entries */
    const char* name; /* the name of the unit, such as 'Metre' -- not the abbreviation 'm' */
    const char* label; /* a unique label for the unit; typically == name, but without spaces */
    const char* type; /* type such as 'length', as a URI */
    const char* dimension; /* the dimensions of this unit, as a string, eg "M L-2" */
    const char* description; /* for example 'Hz = s-1', NULL if no notes present */
    const char* latex_form; /* an abbrev suitable for LaTeX, if different from a preferred syntax */
} UnitDef;

//typedef struct unit_definition UnitDef;

#if UNITY_INTERNAL
/* A unit_representation indicates how a particular unit may be used in a particular syntax. */
struct unit_representation {
    const char* symbol;         /* a symbol for this unit, in one syntax */
    int _unit_index;            /* the index in the array of unit_definition entries */
    int si_prefixes_p;          /* true if this unit may be given SI prefixes */
    int binary_prefixes_p;      /* true if this unit may be given binary prefixes */
    int is_deprecated_p;        /* true if this unit is deprecated */
    int is_preferred_p;         /* true if this unit is the preferred unit amongst some alternatives */
};
typedef struct unit_representation UnitRep;
UnitRep* u_get_unit_representation(const UnitDef*, UnitySyntax syntax);
UnitRep* u_get_unit_representation_any(const UnitDef*);
#endif

const UnitDef* unity_get_unitdef_from_string(const char* abbrev, UnitySyntax syntax);
const char* unity_get_syntax_name(UnitySyntax syntax);
const char* unity_get_unit_uri(const UnitDef*);
const char* unity_get_unit_name(const UnitDef*);
const char* unity_get_unit_type(const UnitDef*);
const char* unity_get_unit_dimension(const UnitDef*);
const char* unity_get_unit_description(const UnitDef*);
const char* unity_get_unit_latex_form(const UnitDef*);
#endif /* UNIT_DEFINITIONS_H */
