/* SPDX-License-Identifier: BSD-3-Clause */
/*
 * Cadence DDR Driver
 *
 * Copyright (C) 2012-2022 Cadence Design Systems, Inc.
 * Copyright (C) 2018-2022 Texas Instruments Incorporated - https://www.ti.com/
 */

#ifndef LPDDR4_J721E_IF_H
#define LPDDR4_J721E_IF_H

#include <linux/types.h>

#define LPDDR4_INTR_MAX_CS (2U)

#define LPDDR4_INTR_CTL_REG_COUNT (459U)

#define LPDDR4_INTR_PHY_INDEP_REG_COUNT (300U)

#define LPDDR4_INTR_PHY_REG_COUNT (1423U)

typedef enum {
	LPDDR4_INTR_RESET_DONE			= 0U,
	LPDDR4_INTR_BUS_ACCESS_ERROR		= 1U,
	LPDDR4_INTR_MULTIPLE_BUS_ACCESS_ERROR	= 2U,
	LPDDR4_INTR_ECC_MULTIPLE_CORR_ERROR	= 3U,
	LPDDR4_INTR_ECC_MULTIPLE_UNCORR_ERROR	= 4U,
	LPDDR4_INTR_ECC_WRITEBACK_EXEC_ERROR	= 5U,
	LPDDR4_INTR_ECC_SCRUB_DONE		= 6U,
	LPDDR4_INTR_ECC_SCRUB_ERROR		= 7U,
	LPDDR4_INTR_PORT_COMMAND_ERROR		= 8U,
	LPDDR4_INTR_MC_INIT_DONE		= 9U,
	LPDDR4_INTR_LP_DONE			= 10U,
	LPDDR4_INTR_BIST_DONE			= 11U,
	LPDDR4_INTR_WRAP_ERROR			= 12U,
	LPDDR4_INTR_INVALID_BURST_ERROR		= 13U,
	LPDDR4_INTR_RDLVL_ERROR			= 14U,
	LPDDR4_INTR_RDLVL_GATE_ERROR		= 15U,
	LPDDR4_INTR_WRLVL_ERROR			= 16U,
	LPDDR4_INTR_CA_TRAINING_ERROR		= 17U,
	LPDDR4_INTR_DFI_UPDATE_ERROR		= 18U,
	LPDDR4_INTR_MRR_ERROR			= 19U,
	LPDDR4_INTR_PHY_MASTER_ERROR		= 20U,
	LPDDR4_INTR_WRLVL_REQ			= 21U,
	LPDDR4_INTR_RDLVL_REQ			= 22U,
	LPDDR4_INTR_RDLVL_GATE_REQ		= 23U,
	LPDDR4_INTR_CA_TRAINING_REQ		= 24U,
	LPDDR4_INTR_LEVELING_DONE		= 25U,
	LPDDR4_INTR_PHY_ERROR			= 26U,
	LPDDR4_INTR_MR_READ_DONE		= 27U,
	LPDDR4_INTR_TEMP_CHANGE			= 28U,
	LPDDR4_INTR_TEMP_ALERT			= 29U,
	LPDDR4_INTR_SW_DQS_COMPLETE		= 30U,
	LPDDR4_INTR_DQS_OSC_BV_UPDATED		= 31U,
	LPDDR4_INTR_DQS_OSC_OVERFLOW		= 32U,
	LPDDR4_INTR_DQS_OSC_VAR_OUT		= 33U,
	LPDDR4_INTR_MR_WRITE_DONE		= 34U,
	LPDDR4_INTR_INHIBIT_DRAM_DONE		= 35U,
	LPDDR4_INTR_DFI_INIT_STATE		= 36U,
	LPDDR4_INTR_DLL_RESYNC_DONE		= 37U,
	LPDDR4_INTR_TDFI_TO			= 38U,
	LPDDR4_INTR_DFS_DONE			= 39U,
	LPDDR4_INTR_DFS_STATUS			= 40U,
	LPDDR4_INTR_REFRESH_STATUS		= 41U,
	LPDDR4_INTR_ZQ_STATUS			= 42U,
	LPDDR4_INTR_SW_REQ_MODE			= 43U,
	LPDDR4_INTR_LOR_BITS			= 44U
} lpddr4_intr_ctlinterrupt;

typedef enum {
	LPDDR4_INTR_PHY_INDEP_INIT_DONE_BIT		= 0U,
	LPDDR4_INTR_PHY_INDEP_CONTROL_ERROR_BIT		= 1U,
	LPDDR4_INTR_PHY_INDEP_CA_PARITY_ERR_BIT		= 2U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_ERROR_BIT		= 3U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_G_ERROR_BIT		= 4U,
	LPDDR4_INTR_PHY_INDEP_WRLVL_ERROR_BIT		= 5U,
	LPDDR4_INTR_PHY_INDEP_CALVL_ERROR_BIT		= 6U,
	LPDDR4_INTR_PHY_INDEP_WDQLVL_ERROR_BIT		= 7U,
	LPDDR4_INTR_PHY_INDEP_UPDATE_ERROR_BIT		= 8U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_REQ_BIT		= 9U,
	LPDDR4_INTR_PHY_INDEP_RDLVL_GATE_REQ_BIT	= 10U,
	LPDDR4_INTR_PHY_INDEP_WRLVL_REQ_BIT		= 11U,
	LPDDR4_INTR_PHY_INDEP_CALVL_REQ_BIT		= 12U,
	LPDDR4_INTR_PHY_INDEP_WDQLVL_REQ_BIT		= 13U,
	LPDDR4_INTR_PHY_INDEP_LVL_DONE_BIT		= 14U,
	LPDDR4_INTR_PHY_INDEP_BIST_DONE_BIT		= 15U,
	LPDDR4_INTR_PHY_INDEP_TDFI_INIT_TIME_OUT_BIT	= 16U,
	LPDDR4_INTR_PHY_INDEP_DLL_LOCK_STATE_CHANGE_BIT = 17U
} lpddr4_intr_phyindepinterrupt;

#endif  /* LPDDR4_J721E_IF_H */
