# Development processes

## Releasing

New releases are created by starting at either the most recent commit on main,
or by backporting fixes on top of an existing tag. Some things to take note of
before starting the release process:

- Have all dependencies recently been updated using `cargo update`?
- Does the changelog contain all recent additions, removals, changes and fixes?
- Are there still any open issues in any related milestone on GitHub?

To determine what version to release we keep to semantic versioning:

- If there are any (major) breaking changes, we always release a new major
  version.
- Patch versions are generally only released for tiny fix-only releases.
- Minor versions are released when large fixes or new features are introduced.
- At any time a new dev release can be made, if unknown what version the next
  release will be you should always assume a patch version change and only
  increase minor or major versions if any new features or breaking changes are
  happening respectively.
- Before big releases or if testing is required, a beta or release candidate
  can be released.

### Checklist

- [ ] Run `utils/update-version.sh [version]`
- [ ] Update `CHANGELOG.md` with the new version, remove any `Unreleased`
      section in the changelog.
- [ ] `git switch -c release/[version]`
- [ ] `git commit -a -S -m "Release [version]"`
- [ ] `git push -u origin release/[version]`
- [ ] Wait for all actions to finish and succeed, make sure both the checks and
      the packaging workflow succeed.
- [ ] Either create a PR and let someone review the release, or directly merge
      into the target branch (for most releases this will be `main`).
- [ ] On the merged commit, create a new (signed) tag:
      `git tag -a -s -m "Version [version]" v[version]`
- [ ] Push the tag to GitHub: `git push origin v[version]`
- [ ] Release on crates.io by running `utils/release.sh`
- [ ] Download the artifacts by running `utils/prepare-artifacts.sh --api-token [github-api-token] --run-id [run-id] --download-artifacts --delete-zips --reset`
      The run id can be extracted from the URL by going to the `Actions` page on
      GitHub and clicking through to the specific packaging run. A GitHub API
      token can be generated by going to your personal settings (via your
      profile picture), clicking on `Developer settings` (at the bottom) and
      generating a new 'Fine grained personal access token'. Easiest way here
      is to select 'All repositories' and then enabling the Actions 'Read-only'
      permission.
- [ ] Create a new release on GitHub: https://github.com/pendulum-project/ntpd-rs/releases/new
- [ ] Pick the tag just pushed.
- [ ] Set the title to `Version [version]`.
- [ ] Add the contents of the changelog specific to this version to the body
      of the release. You may add any additional text at the top of the release
      text.
- [ ] Upload all the files in the `target/pkg` directory.
- [ ] Publish the release.
