% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_return.R
\name{to_return}
\alias{to_return}
\title{Expectation for what's returned from a stubbed request}
\usage{
to_return(.data, ..., .list = list(), times = 1)
}
\arguments{
\item{.data}{input. Anything that can be coerced to a \code{StubbedRequest} class
object}

\item{...}{Comma separated list of named variables. accepts the following:
\code{status}, \code{body}, \code{headers}. See Details for more.}

\item{.list}{named list, has to be one of 'status', 'body',
and/or 'headers'. An alternative to passing in via \code{...}. Don't pass the
same thing to both, e.g. don't pass 'status' to \code{...}, and also 'status' to
this parameter}

\item{times}{(integer) number of times the given response should be
returned; default: 1. value must be greater than or equal to 1. Very large
values probably don't make sense, but there's no maximum value. See
Details.}
}
\value{
an object of class \code{StubbedRequest}, with print method describing
the stub
}
\description{
Set response status code, response body, and/or response headers
}
\details{
Values for status, body, and headers:
\itemize{
\item status: (numeric/integer) three digit status code
\item body: various: \code{character}, \code{json}, \code{list}, \code{raw}, \code{numeric},
\code{NULL}, \code{FALSE}, a file connection (other connetion types
not supported), or a \code{mock_file} function call (see \code{\link[=mock_file]{mock_file()}})
\item headers: (list) a named list, must be named
}

response headers are returned with all lowercase names and the values
are all of type character. if numeric/integer values are given
(e.g., \code{to_return(headers = list(a = 10))}), we'll coerce any
numeric/integer values to character.
}
\note{
see more examples in \code{\link[=stub_request]{stub_request()}}
}
\section{multiple \code{to_return()}}{

You can add more than one \code{to_return()} to a webmockr stub (including
\code{\link[=to_raise]{to_raise()}}, \code{\link[=to_timeout]{to_timeout()}}). Each one is a HTTP response returned.
That is, you'll match to an HTTP request based on \code{stub_request()} and
\code{wi_th()}; the first time the request is made, the first response
is returned; the second time the reqeust is made, the second response
is returned; and so on.

Be aware that webmockr has to track number of requests
(see \code{\link[=request_registry]{request_registry()}}), and so if you use multiple \code{to_return()}
or the \code{times} parameter, you must clear the request registry
in order to go back to mocking responses from the start again.
\code{\link[=webmockr_reset]{webmockr_reset()}} clears the stub registry and  the request registry,
after which you can use multiple responses again (after creating
your stub(s) again of course)
}

\section{Raise vs. Return}{

\code{to_raise()} always raises a stop condition, while \code{to_return(status=xyz)} only
sets the status code on the returned HTTP response object. So if you want to
raise a stop condition then \code{to_raise()} is what you want. But if you
don't want to raise a stop condition use \code{to_return()}. Use cases for each
vary. For example, in a unit test you may have a test expecting a 503 error;
in this case \code{to_raise()} makes sense. In another case, if a unit test
expects to test some aspect of an HTTP response object that httr or crul
typically returns, then you'll want \code{to_return()}.
}

\examples{
# first, make a stub object
foo <- function() {
  stub_request("post", "https://httpbin.org/post")
}

# add status, body and/or headers
foo() \%>\% to_return(status = 200)
foo() \%>\% to_return(body = "stuff")
foo() \%>\% to_return(body = list(a = list(b = "world")))
foo() \%>\% to_return(headers = list(a = 5))
foo() \%>\% 
  to_return(status = 200, body = "stuff", headers = list(a = 5))

# .list - pass in a named list instead
foo() \%>\% to_return(.list = list(body = list(foo = "bar")))

# multiple responses using chained `to_return()`
foo() \%>\% to_return(body = "stuff") \%>\% to_return(body = "things")

# many of the same response using the times parameter
foo() \%>\% to_return(body = "stuff", times = 3)
}
