% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withSpinner.R
\name{withSpinner}
\alias{withSpinner}
\title{Add a spinner (loader) that shows when an output is recalculating}
\usage{
withSpinner(ui_element, type = getOption("spinner.type", default = 1),
  color = getOption("spinner.color", default = "#0275D8"),
  size = getOption("spinner.size", default = 1),
  color.background = getOption("spinner.color.background"),
  custom.css = FALSE, proxy.height = if (grepl("height:\\\\s*\\\\d",
  ui_element)) NULL else "400px")
}
\arguments{
\item{ui_element}{A UI element that should be wrapped with a spinner when the corresponding output is being calculated.}

\item{type}{The type of spinner to use, valid values are integers between 1-8. They correspond to the enumeration in \url{https://projects.lukehaas.me/css-loaders/}}

\item{color}{The color of the spinner to be applied in HTML in hex format}

\item{size}{The size of the spinner, relative to it's default size.}

\item{color.background}{For certain spinners (type 2-3), you will need to specify the background colour of the spinner}

\item{custom.css}{If custom css is to be applied, we don't enforce the color / size options to the given spinner id}

\item{proxy.height}{If the output doesn't specify the output height, you can set a proxy height. It defaults to 400px for outputs with undefined height.}
}
\description{
Add a spinner (loader) that shows when an output is recalculating
}
\examples{
\dontrun{withSpinner(plotOutput("my_plot"))}
}
