% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.group.R
\name{list.cases}
\alias{list.cases}
\title{Get all unique cases of a list field by expression}
\usage{
list.cases(.data, expr, simplify = TRUE, sorted = TRUE)
}
\arguments{
\item{.data}{A \code{list} or \code{vector}}

\item{expr}{A lambda expression. The function will returns all cases
of the elements if \code{expr} is missing.}

\item{simplify}{\code{logical}. Should atomic vectors be simplified
by \code{unlist}?}

\item{sorted}{\code{logical}. Should the cases be sorted in ascending order?}
}
\description{
Get all unique cases of a list field by expression
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.cases(x,type)
list.cases(x,mean(unlist(score)))

foo <- list(x = LETTERS[1:3], y = LETTERS[3:5])
list.cases(foo)
}

