% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory.R
\name{ps_system_memory}
\alias{ps_system_memory}
\title{Statistics about system memory usage}
\usage{
ps_system_memory()
}
\value{
Named list. All numbers are in bytes:
\itemize{
\item \code{total}: total physical memory (exclusive swap).
\item \code{avail} the memory that can be given instantly to processes without
the system going into swap. This is calculated by summing different
memory values depending on the platform and it is supposed to be used
to monitor actual memory usage in a cross platform fashion.
\item \code{percent}: Percentage of memory that is taken.
\item \code{used}: memory used, calculated differently depending on
the platform and designed for informational purposes only.
\code{total} - \code{free} does not necessarily match \code{used}.
\item \code{free}: memory not being used at all (zeroed) that is
readily available; note that this doesn’t reflect the actual memory
available (use \code{available} instead). \code{total} - \code{used} does not
necessarily match \code{free}.
\item \code{active}: (Unix only) memory currently in use or very recently used,
and so it is in RAM.
\item \code{inactive}: (Unix only) memory that is marked as not used.
\item \code{wired}: (macOS only) memory that is marked to always stay in RAM. It
is never moved to disk.
\item \code{buffers}: (Linux only) cache for things like file system metadata.
\item \code{cached}: (Linux only) cache for various things.
\item \code{shared}: (Linux only) memory that may be simultaneously accessed by
multiple processes.
\item \code{slab}:  (Linux only) in-kernel data structures cache.
}
}
\description{
Statistics about system memory usage
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_system_memory()
\dontshow{\}) # examplesIf}
}
\seealso{
Other memory functions: 
\code{\link{ps_system_swap}()}
}
\concept{memory functions}
