% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/later.R
\name{later}
\alias{later}
\title{Executes a function later}
\usage{
later(func, delay = 0, loop = current_loop())
}
\arguments{
\item{func}{A function or formula (see \code{\link[rlang:as_function]{rlang::as_function()}}).}

\item{delay}{Number of seconds in the future to delay execution. There is no
guarantee that the function will be executed at the desired time, but it
should not execute earlier.}

\item{loop}{A handle to an event loop. Defaults to the currently-active loop.}
}
\value{
A function, which, if invoked, will cancel the callback. The
function will return \code{TRUE} if the callback was successfully
cancelled and \code{FALSE} if not (this occurs if the callback has
executed or has been cancelled already).
}
\description{
Schedule an R function or formula to run after a specified period of time.
Similar to JavaScript's \code{setTimeout} function. Like JavaScript, R is
single-threaded so there's no guarantee that the operation will run exactly
at the requested time, only that at least that much time will elapse.
}
\details{
The mechanism used by this package is inspired by Simon Urbanek's
\href{https://github.com/s-u/background}{background} package and similar code in
Rhttpd.
}
\note{
To avoid bugs due to reentrancy, by default, scheduled operations only run
when there is no other R code present on the execution stack; i.e., when R is
sitting at the top-level prompt. You can force past-due operations to run at
a time of your choosing by calling \code{\link[=run_now]{run_now()}}.

Error handling is not particularly well-defined and may change in the future.
options(error=browser) should work and errors in \code{func} should generally not
crash the R process, but not much else can be said about it at this point.
If you must have specific behavior occur in the face of errors, put error
handling logic inside of \code{func}.
}
\examples{
# Example of formula style
later(~cat("Hello from the past\n"), 3)

# Example of function style
later(function() {
  print(summary(cars))
}, 2)

}
