% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-jitter.r
\name{position_jitter}
\alias{position_jitter}
\title{Jitter points to avoid overplotting}
\usage{
position_jitter(width = NULL, height = NULL)
}
\arguments{
\item{width, height}{Amount of vertical and horizontal jitter. The jitter
  is added in both positive and negative directions, so the total spread
  is twice the value specified here.

  If omitted, defaults to 40\% of the resolution of the data: this means the
  jitter values will occupy 80\% of the implied bins. Categorical data
  is aligned on the integers, so a width or height of 0.5 will spread the
  data so it's not possible to see the distinction between the categories.}
}
\description{
Couterintuitively adding random noise to a plot can sometimes make it
easier to read. Jittering is particularly useful for small datasets with
at least one discrete position.
}
\examples{
# Jittering is useful when you have a discrete position, and a relatively
# small number of points
# take up as much space as a boxplot or a bar
ggplot(mpg, aes(class, hwy)) +
  geom_boxplot(colour = "grey50") +
  geom_jitter()

# If the default jittering is too much, as in this plot:
ggplot(mtcars, aes(am, vs)) +
  geom_jitter()

# You can adjust it in two ways
ggplot(mtcars, aes(am, vs)) +
  geom_jitter(width = 0.1, height = 0.1)
ggplot(mtcars, aes(am, vs)) +
  geom_jitter(position = position_jitter(width = 0.1, height = 0.1))
}
\seealso{
Other position adjustments: \code{\link{position_dodge}},
  \code{\link{position_identity}},
  \code{\link{position_jitterdodge}},
  \code{\link{position_nudge}},
  \code{\link{position_stack}}
}
