% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{chunk_dataframe}
\alias{chunk_dataframe}
\title{Create a chunk representation suitable for flextable}
\usage{
chunk_dataframe(...)
}
\arguments{
\item{...}{values to set.}
}
\value{
a data.frame with an additional class "chunk" that makes it
suitable for beeing used in \code{\link[=as_paragraph]{as_paragraph()}}
}
\description{
This function is to be used by external packages
that want to provide an object that can be inserted as a chunk
object in paragraphs of a flextable object.
}
\section{text pattern with default values}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{chunk_dataframe(txt = c("any text", "other text"))
}\if{html}{\out{</div>}}
}

\section{text pattern with bold set to TRUE}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{chunk_dataframe(
  txt = c("any text", "other text"),
  bold = c(TRUE, TRUE))
}\if{html}{\out{</div>}}
}

\section{text pattern with control over all formatting properties}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{chunk_dataframe(
  txt = c("any text", "other text"),
  font.size = c(12, 10),
  italic = c(FALSE, TRUE),
  bold = c(FALSE, TRUE),
  underlined = c(FALSE, TRUE),
  color = c("black", "red"),
  shading.color = c("transparent", "yellow"),
  font.family = c("Arial", "Arial"),
  hansi.family = c("Arial", "Arial"),
  eastasia.family = c("Arial", "Arial"),
  cs.family = c("Arial", "Arial"),
  vertical.align = c("top", "bottom") )
}\if{html}{\out{</div>}}
}

\section{text with url pattern}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{chunk_dataframe(
  txt = c("any text", "other text"),
  url = rep("https://www.google.fr", 2),
  font.size = c(12, 10),
  italic = c(FALSE, TRUE),
  bold = c(FALSE, TRUE),
  underlined = c(FALSE, TRUE),
  color = c("black", "red"),
  shading.color = c("transparent", "yellow"),
  font.family = c("Arial", "Arial"),
  hansi.family = c("Arial", "Arial"),
  eastasia.family = c("Arial", "Arial"),
  cs.family = c("Arial", "Arial"),
  vertical.align = c("top", "bottom") )
}\if{html}{\out{</div>}}
}

\section{images pattern}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{chunk_dataframe(width = width, height = height, img_data = files )
}\if{html}{\out{</div>}}
}

\keyword{internal}
