% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpca.R
\docType{class}
\name{kPCA-class}
\alias{kPCA-class}
\alias{kPCA}
\title{Kernel PCA}
\description{
An S4 Class implementing Kernel PCA
}
\details{
Kernel PCA is a nonlinear extension of PCA using kernel methods.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

Kernel PCA can take the following parameters:
\describe{
  \item{ndim}{the number of output dimensions, defaults to 2}
  \item{kernel}{The kernel function, either as a function or a
  character vector with the name of the kernel. Defaults to
  \code{"rbfdot"}}
  \item{kpar}{A list with the parameters for the kernel function}
}
}

\section{Implementation}{


Wraps around \code{\link[kernlab]{kpca}}, but provides additionally
forward and backward projections.
}

\examples{
\dontrun{
dat <- loadDataSet("3D S Curve")

## use the S4 class directly:
kpca <- kPCA()
emb <- kpca@fun(dat, kpca@stdpars)

## simpler, use embed():
emb2 <- embed(dat, "kPCA")

plot(emb, type = "2vars")
}
}
\seealso{
Other dimensionality reduction methods: \code{\link{DRR-class}},
  \code{\link{DiffusionMaps-class}},
  \code{\link{DrL-class}}, \code{\link{FastICA-class}},
  \code{\link{FruchtermanReingold-class}},
  \code{\link{HLLE-class}}, \code{\link{Isomap-class}},
  \code{\link{KamadaKawai-class}}, \code{\link{LLE-class}},
  \code{\link{MDS-class}}, \code{\link{PCA-class}},
  \code{\link{dimRedMethod-class}},
  \code{\link{nMDS-class}}, \code{\link{tSNE-class}}
}
