# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.trusthub.v1 import V1


class Trusthub(Domain):

    def __init__(self, twilio):
        """
        Initialize the Trusthub Domain

        :returns: Domain for Trusthub
        :rtype: twilio.rest.trusthub.Trusthub
        """
        super(Trusthub, self).__init__(twilio)

        self.base_url = 'https://trusthub.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of trusthub
        :rtype: twilio.rest.trusthub.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def customer_profiles(self):
        """
        :rtype: twilio.rest.trusthub.v1.customer_profiles.CustomerProfilesList
        """
        return self.v1.customer_profiles

    @property
    def end_users(self):
        """
        :rtype: twilio.rest.trusthub.v1.end_user.EndUserList
        """
        return self.v1.end_users

    @property
    def end_user_types(self):
        """
        :rtype: twilio.rest.trusthub.v1.end_user_type.EndUserTypeList
        """
        return self.v1.end_user_types

    @property
    def policies(self):
        """
        :rtype: twilio.rest.trusthub.v1.policies.PoliciesList
        """
        return self.v1.policies

    @property
    def supporting_documents(self):
        """
        :rtype: twilio.rest.trusthub.v1.supporting_document.SupportingDocumentList
        """
        return self.v1.supporting_documents

    @property
    def supporting_document_types(self):
        """
        :rtype: twilio.rest.trusthub.v1.supporting_document_type.SupportingDocumentTypeList
        """
        return self.v1.supporting_document_types

    @property
    def trust_products(self):
        """
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsList
        """
        return self.v1.trust_products

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trusthub>'
