# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class A2ARecoveryAvailabilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery availability type of the virtual machine."""

    SINGLE = "Single"
    AVAILABILITY_SET = "AvailabilitySet"
    AVAILABILITY_ZONE = "AvailabilityZone"


class A2ARpRecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_CRASH_CONSISTENT = "LatestCrashConsistent"
    LATEST_PROCESSED = "LatestProcessed"


class AgentAutoUpdateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether the auto update is enabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class AgentUpgradeBlockedReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AgentUpgradeBlockedReason."""

    ALREADY_ON_LATEST_VERSION = "AlreadyOnLatestVersion"
    REBOOT_REQUIRED = "RebootRequired"
    AGENT_NO_HEARTBEAT = "AgentNoHeartbeat"
    RCM_PROXY_NO_HEARTBEAT = "RcmProxyNoHeartbeat"
    PROCESS_SERVER_NO_HEARTBEAT = "ProcessServerNoHeartbeat"
    INCOMPATIBLE_APPLIANCE_VERSION = "IncompatibleApplianceVersion"
    NOT_PROTECTED = "NotProtected"
    UNSUPPORTED_PROTECTION_SCENARIO = "UnsupportedProtectionScenario"
    DISTRO_IS_NOT_REPORTED = "DistroIsNotReported"
    DISTRO_NOT_SUPPORTED_FOR_UPGRADE = "DistroNotSupportedForUpgrade"
    MISSING_UPGRADE_PATH = "MissingUpgradePath"
    INVALID_AGENT_VERSION = "InvalidAgentVersion"
    INVALID_DRIVER_VERSION = "InvalidDriverVersion"
    UNKNOWN = "Unknown"


class AgentVersionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether security update required."""

    SUPPORTED = "Supported"
    NOT_SUPPORTED = "NotSupported"
    DEPRECATED = "Deprecated"
    UPDATE_REQUIRED = "UpdateRequired"
    SECURITY_UPDATE_REQUIRED = "SecurityUpdateRequired"


class AlternateLocationRecoveryOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The ALR option."""

    CREATE_VM_IF_NOT_FOUND = "CreateVmIfNotFound"
    NO_ACTION = "NoAction"


class AutomationAccountAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating the type authentication to use for automation Account."""

    RUN_AS_ACCOUNT = "RunAsAccount"
    SYSTEM_ASSIGNED_IDENTITY = "SystemAssignedIdentity"


class AutoProtectionOfDataDisk(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether the auto protection is enabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DataSyncStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data sync option."""

    FOR_DOWN_TIME = "ForDownTime"
    FOR_SYNCHRONIZATION = "ForSynchronization"


class DisableProtectionReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Disable protection reason. It can have values NotSpecified/MigrationComplete."""

    NOT_SPECIFIED = "NotSpecified"
    MIGRATION_COMPLETE = "MigrationComplete"


class DiskAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The DiskType."""

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"


class DiskReplicationProgressHealth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The progress health."""

    NONE = "None"
    IN_PROGRESS = "InProgress"
    SLOW_PROGRESS = "SlowProgress"
    NO_PROGRESS = "NoProgress"
    QUEUED = "Queued"


class EthernetAddressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The source IP address type."""

    DYNAMIC = "Dynamic"
    STATIC = "Static"


class ExportJobOutputSerializationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The output type of the jobs."""

    JSON = "Json"
    XML = "Xml"
    EXCEL = "Excel"


class ExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The extended location type."""

    EDGE_ZONE = "EdgeZone"


class FailoverDeploymentModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The failover deployment model."""

    NOT_APPLICABLE = "NotApplicable"
    CLASSIC = "Classic"
    RESOURCE_MANAGER = "ResourceManager"


class HealthErrorCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The category of the health error."""

    NONE = "None"
    REPLICATION = "Replication"
    TEST_FAILOVER = "TestFailover"
    CONFIGURATION = "Configuration"
    FABRIC_INFRASTRUCTURE = "FabricInfrastructure"
    VERSION_EXPIRY = "VersionExpiry"
    AGENT_AUTO_UPDATE_INFRA = "AgentAutoUpdateInfra"
    AGENT_AUTO_UPDATE_ARTIFACT_DELETED = "AgentAutoUpdateArtifactDeleted"
    AGENT_AUTO_UPDATE_RUN_AS_ACCOUNT = "AgentAutoUpdateRunAsAccount"
    AGENT_AUTO_UPDATE_RUN_AS_ACCOUNT_EXPIRY = "AgentAutoUpdateRunAsAccountExpiry"
    AGENT_AUTO_UPDATE_RUN_AS_ACCOUNT_EXPIRED = "AgentAutoUpdateRunAsAccountExpired"


class HealthErrorCustomerResolvability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Value indicating whether the health error is customer resolvable."""

    ALLOWED = "Allowed"
    NOT_ALLOWED = "NotAllowed"


class HyperVReplicaAzureRpRecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_PROCESSED = "LatestProcessed"


class InMageRcmFailbackRecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    APPLICATION_CONSISTENT = "ApplicationConsistent"
    CRASH_CONSISTENT = "CrashConsistent"


class InMageV2RpRecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_CRASH_CONSISTENT = "LatestCrashConsistent"
    LATEST_PROCESSED = "LatestProcessed"


class LicenseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """License type."""

    NOT_SPECIFIED = "NotSpecified"
    NO_LICENSE_TYPE = "NoLicenseType"
    WINDOWS_SERVER = "WindowsServer"


class MigrationItemOperation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MigrationItemOperation."""

    DISABLE_MIGRATION = "DisableMigration"
    TEST_MIGRATE = "TestMigrate"
    TEST_MIGRATE_CLEANUP = "TestMigrateCleanup"
    MIGRATE = "Migrate"
    START_RESYNC = "StartResync"
    PAUSE_REPLICATION = "PauseReplication"
    RESUME_REPLICATION = "ResumeReplication"


class MigrationRecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    NOT_SPECIFIED = "NotSpecified"
    APPLICATION_CONSISTENT = "ApplicationConsistent"
    CRASH_CONSISTENT = "CrashConsistent"


class MigrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The migration status."""

    NONE = "None"
    ENABLE_MIGRATION_IN_PROGRESS = "EnableMigrationInProgress"
    ENABLE_MIGRATION_FAILED = "EnableMigrationFailed"
    DISABLE_MIGRATION_IN_PROGRESS = "DisableMigrationInProgress"
    DISABLE_MIGRATION_FAILED = "DisableMigrationFailed"
    INITIAL_SEEDING_IN_PROGRESS = "InitialSeedingInProgress"
    INITIAL_SEEDING_FAILED = "InitialSeedingFailed"
    REPLICATING = "Replicating"
    MIGRATION_IN_PROGRESS = "MigrationInProgress"
    MIGRATION_SUCCEEDED = "MigrationSucceeded"
    MIGRATION_FAILED = "MigrationFailed"
    RESUME_IN_PROGRESS = "ResumeInProgress"
    RESUME_INITIATED = "ResumeInitiated"
    SUSPENDING_PROTECTION = "SuspendingProtection"
    PROTECTION_SUSPENDED = "ProtectionSuspended"
    MIGRATION_COMPLETED_WITH_INFORMATION = "MigrationCompletedWithInformation"
    MIGRATION_PARTIALLY_SUCCEEDED = "MigrationPartiallySucceeded"


class MobilityAgentUpgradeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The agent auto upgrade state."""

    NONE = "None"
    STARTED = "Started"
    COMPLETED = "Completed"
    COMMIT = "Commit"


class MultiVmGroupCreateOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether Multi VM group is auto created or specified by user."""

    AUTO_CREATED = "AutoCreated"
    USER_SPECIFIED = "UserSpecified"


class MultiVmSyncPointOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether multi VM sync enabled VMs should use multi VM sync points for
    failover.
    """

    USE_MULTI_VM_SYNC_RECOVERY_POINT = "UseMultiVmSyncRecoveryPoint"
    USE_PER_VM_RECOVERY_POINT = "UsePerVmRecoveryPoint"


class PlannedFailoverStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The last planned failover status."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    UNKNOWN = "Unknown"


class PossibleOperationsDirections(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PossibleOperationsDirections."""

    PRIMARY_TO_RECOVERY = "PrimaryToRecovery"
    RECOVERY_TO_PRIMARY = "RecoveryToPrimary"


class PresenceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether the VM has a physical disk attached. String value of
    SrsDataContract.PresenceStatus enum.
    """

    UNKNOWN = "Unknown"
    PRESENT = "Present"
    NOT_PRESENT = "NotPresent"


class ProtectionHealth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The health."""

    NONE = "None"
    NORMAL = "Normal"
    WARNING = "Warning"
    CRITICAL = "Critical"


class RcmComponentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The throughput status."""

    HEALTHY = "Healthy"
    WARNING = "Warning"
    CRITICAL = "Critical"
    UNKNOWN = "Unknown"


class RecoveryPlanActionLocation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The fabric location."""

    PRIMARY = "Primary"
    RECOVERY = "Recovery"


class RecoveryPlanGroupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The group type."""

    SHUTDOWN = "Shutdown"
    BOOT = "Boot"
    FAILOVER = "Failover"


class RecoveryPlanPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_CRASH_CONSISTENT = "LatestCrashConsistent"
    LATEST_PROCESSED = "LatestProcessed"


class RecoveryPointSyncType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether the recovery point is multi VM consistent."""

    MULTI_VM_SYNC_RECOVERY_POINT = "MultiVmSyncRecoveryPoint"
    PER_VM_RECOVERY_POINT = "PerVmRecoveryPoint"


class RecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom,
    the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery
    point id will be ignored.
    """

    LATEST_TIME = "LatestTime"
    LATEST_TAG = "LatestTag"
    CUSTOM = "Custom"


class ReplicationProtectedItemOperation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ReplicationProtectedItemOperation."""

    REVERSE_REPLICATE = "ReverseReplicate"
    COMMIT = "Commit"
    PLANNED_FAILOVER = "PlannedFailover"
    UNPLANNED_FAILOVER = "UnplannedFailover"
    DISABLE_PROTECTION = "DisableProtection"
    TEST_FAILOVER = "TestFailover"
    TEST_FAILOVER_CLEANUP = "TestFailoverCleanup"
    FAILBACK = "Failback"
    FINALIZE_FAILBACK = "FinalizeFailback"
    CANCEL_FAILOVER = "CancelFailover"
    CHANGE_PIT = "ChangePit"
    REPAIR_REPLICATION = "RepairReplication"
    SWITCH_PROTECTION = "SwitchProtection"
    COMPLETE_MIGRATION = "CompleteMigration"


class ResyncState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The resync state."""

    NONE = "None"
    PREPARED_FOR_RESYNCHRONIZATION = "PreparedForResynchronization"
    STARTED_RESYNCHRONIZATION = "StartedResynchronization"


class RpInMageRecoveryPointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recovery point type."""

    LATEST_TIME = "LatestTime"
    LATEST_TAG = "LatestTag"
    CUSTOM = "Custom"


class SetMultiVmSyncStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or
    'Disabled'.
    """

    ENABLE = "Enable"
    DISABLE = "Disable"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity of error."""

    NONE = "NONE"
    WARNING = "Warning"
    ERROR = "Error"
    INFO = "Info"


class SourceSiteOperations(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating whether source site operations are required."""

    REQUIRED = "Required"
    NOT_REQUIRED = "NotRequired"


class SqlServerLicenseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SQL Server license type."""

    NOT_SPECIFIED = "NotSpecified"
    NO_LICENSE_TYPE = "NoLicenseType"
    PAYG = "PAYG"
    AHUB = "AHUB"


class TestMigrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The test migrate state."""

    NONE = "None"
    TEST_MIGRATION_IN_PROGRESS = "TestMigrationInProgress"
    TEST_MIGRATION_SUCCEEDED = "TestMigrationSucceeded"
    TEST_MIGRATION_FAILED = "TestMigrationFailed"
    TEST_MIGRATION_CLEANUP_IN_PROGRESS = "TestMigrationCleanupInProgress"
    TEST_MIGRATION_COMPLETED_WITH_INFORMATION = "TestMigrationCompletedWithInformation"
    TEST_MIGRATION_PARTIALLY_SUCCEEDED = "TestMigrationPartiallySucceeded"


class VmEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption type of the VM."""

    NOT_ENCRYPTED = "NotEncrypted"
    ONE_PASS_ENCRYPTED = "OnePassEncrypted"
    TWO_PASS_ENCRYPTED = "TwoPassEncrypted"


class VmReplicationProgressHealth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The initial replication progress health."""

    NONE = "None"
    IN_PROGRESS = "InProgress"
    SLOW_PROGRESS = "SlowProgress"
    NO_PROGRESS = "NoProgress"
