# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccountCredentialDetails(_serialization.Model):
    """Credential details of the account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_name: Name of the account.
    :vartype account_name: str
    :ivar data_destination_type: Data Destination Type. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_destination_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.DataDestinationType
    :ivar account_connection_string: Connection string of the account endpoint to use the account
     as a storage endpoint on the device.
    :vartype account_connection_string: str
    :ivar share_credential_details: Per share level unencrypted access credentials.
    :vartype share_credential_details:
     list[~azure.mgmt.databox.v2019_09_01.models.ShareCredentialDetails]
    """

    _validation = {
        "account_name": {"readonly": True},
        "data_destination_type": {"readonly": True},
        "account_connection_string": {"readonly": True},
        "share_credential_details": {"readonly": True},
    }

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "data_destination_type": {"key": "dataDestinationType", "type": "str"},
        "account_connection_string": {"key": "accountConnectionString", "type": "str"},
        "share_credential_details": {"key": "shareCredentialDetails", "type": "[ShareCredentialDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.account_name = None
        self.data_destination_type = None
        self.account_connection_string = None
        self.share_credential_details = None


class AddressValidationOutput(_serialization.Model):
    """Output of the address validation api.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_type: Identifies the type of validation response. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar validation_status: The address validation status. Known values are: "Valid", "Invalid",
     and "Ambiguous".
    :vartype validation_status: str or
     ~azure.mgmt.databox.v2019_09_01.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.v2019_09_01.models.ShippingAddress]
    """

    _validation = {
        "error": {"readonly": True},
        "validation_status": {"readonly": True},
        "alternate_addresses": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "properties.validationType", "type": "str"},
        "error": {"key": "properties.error", "type": "Error"},
        "validation_status": {"key": "properties.validationStatus", "type": "str"},
        "alternate_addresses": {"key": "properties.alternateAddresses", "type": "[ShippingAddress]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: Optional[str] = None
        self.error = None
        self.validation_status = None
        self.alternate_addresses = None


class ValidationInputResponse(_serialization.Model):
    """Minimum properties that should be present in each individual validation response.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AddressValidationProperties, CreateOrderLimitForSubscriptionValidationResponseProperties,
    DataDestinationDetailsValidationResponseProperties, PreferencesValidationResponseProperties,
    SkuAvailabilityValidationResponseProperties,
    SubscriptionIsAllowedToCreateJobValidationResponseProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    _subtype_map = {
        "validation_type": {
            "ValidateAddress": "AddressValidationProperties",
            "ValidateCreateOrderLimit": "CreateOrderLimitForSubscriptionValidationResponseProperties",
            "ValidateDataDestinationDetails": "DataDestinationDetailsValidationResponseProperties",
            "ValidatePreferences": "PreferencesValidationResponseProperties",
            "ValidateSkuAvailability": "SkuAvailabilityValidationResponseProperties",
            "ValidateSubscriptionIsAllowedToCreateJob": "SubscriptionIsAllowedToCreateJobValidationResponseProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: Optional[str] = None
        self.error = None


class AddressValidationProperties(ValidationInputResponse):
    """The address validation output.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar validation_status: The address validation status. Known values are: "Valid", "Invalid",
     and "Ambiguous".
    :vartype validation_status: str or
     ~azure.mgmt.databox.v2019_09_01.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.v2019_09_01.models.ShippingAddress]
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "validation_status": {"readonly": True},
        "alternate_addresses": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "validation_status": {"key": "validationStatus", "type": "str"},
        "alternate_addresses": {"key": "alternateAddresses", "type": "[ShippingAddress]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateAddress"
        self.validation_status = None
        self.alternate_addresses = None


class ApplianceNetworkConfiguration(_serialization.Model):
    """The Network Adapter configuration of a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the network.
    :vartype name: str
    :ivar mac_address: Mac Address.
    :vartype mac_address: str
    """

    _validation = {
        "name": {"readonly": True},
        "mac_address": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.mac_address = None


class ArmBaseObject(_serialization.Model):
    """Base class for all objects under resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None


class AvailableSkuRequest(_serialization.Model):
    """The filters for showing the available skus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar transfer_type: Type of the transfer. Required. Default value is "ImportToAzure".
    :vartype transfer_type: str
    :ivar country: ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
    :vartype country: str
    :ivar location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype location: str
    :ivar sku_names: Sku Names to filter for available skus.
    :vartype sku_names: list[str or ~azure.mgmt.databox.v2019_09_01.models.SkuName]
    """

    _validation = {
        "transfer_type": {"required": True, "constant": True},
        "country": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "transfer_type": {"key": "transferType", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku_names": {"key": "skuNames", "type": "[str]"},
    }

    transfer_type = "ImportToAzure"

    def __init__(
        self,
        *,
        country: str,
        location: str,
        sku_names: Optional[List[Union[str, "_models.SkuName"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword country: ISO country code. Country for hardware shipment. For codes check:
         https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
        :paramtype country: str
        :keyword location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype location: str
        :keyword sku_names: Sku Names to filter for available skus.
        :paramtype sku_names: list[str or ~azure.mgmt.databox.v2019_09_01.models.SkuName]
        """
        super().__init__(**kwargs)
        self.country = country
        self.location = location
        self.sku_names = sku_names


class AvailableSkusResult(_serialization.Model):
    """The available skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of available skus.
    :vartype value: list[~azure.mgmt.databox.v2019_09_01.models.SkuInformation]
    :ivar next_link: Link for the next set of skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CancellationReason(_serialization.Model):
    """Reason for cancellation.

    All required parameters must be populated in order to send to Azure.

    :ivar reason: Reason for cancellation. Required.
    :vartype reason: str
    """

    _validation = {
        "reason": {"required": True},
    }

    _attribute_map = {
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: str, **kwargs: Any) -> None:
        """
        :keyword reason: Reason for cancellation. Required.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.reason = reason


class CloudError(_serialization.Model):
    """The error information object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code string.
    :vartype code: str
    :ivar message: Descriptive error information.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: More detailed error information.
    :vartype details: list[~azure.mgmt.databox.v2019_09_01.models.CloudError]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudError]"},
    }

    def __init__(
        self, *, target: Optional[str] = None, details: Optional[List["_models.CloudError"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: More detailed error information.
        :paramtype details: list[~azure.mgmt.databox.v2019_09_01.models.CloudError]
        """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = target
        self.details = details


class ContactDetails(_serialization.Model):
    """Contact Details.

    All required parameters must be populated in order to send to Azure.

    :ivar contact_name: Contact name of the person. Required.
    :vartype contact_name: str
    :ivar phone: Phone number of the contact person. Required.
    :vartype phone: str
    :ivar phone_extension: Phone extension number of the contact person.
    :vartype phone_extension: str
    :ivar mobile: Mobile number of the contact person.
    :vartype mobile: str
    :ivar email_list: List of Email-ids to be notified about job progress. Required.
    :vartype email_list: list[str]
    :ivar notification_preference: Notification preference for a job stage.
    :vartype notification_preference:
     list[~azure.mgmt.databox.v2019_09_01.models.NotificationPreference]
    """

    _validation = {
        "contact_name": {"required": True},
        "phone": {"required": True},
        "email_list": {"required": True},
    }

    _attribute_map = {
        "contact_name": {"key": "contactName", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "phone_extension": {"key": "phoneExtension", "type": "str"},
        "mobile": {"key": "mobile", "type": "str"},
        "email_list": {"key": "emailList", "type": "[str]"},
        "notification_preference": {"key": "notificationPreference", "type": "[NotificationPreference]"},
    }

    def __init__(
        self,
        *,
        contact_name: str,
        phone: str,
        email_list: List[str],
        phone_extension: Optional[str] = None,
        mobile: Optional[str] = None,
        notification_preference: Optional[List["_models.NotificationPreference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_name: Contact name of the person. Required.
        :paramtype contact_name: str
        :keyword phone: Phone number of the contact person. Required.
        :paramtype phone: str
        :keyword phone_extension: Phone extension number of the contact person.
        :paramtype phone_extension: str
        :keyword mobile: Mobile number of the contact person.
        :paramtype mobile: str
        :keyword email_list: List of Email-ids to be notified about job progress. Required.
        :paramtype email_list: list[str]
        :keyword notification_preference: Notification preference for a job stage.
        :paramtype notification_preference:
         list[~azure.mgmt.databox.v2019_09_01.models.NotificationPreference]
        """
        super().__init__(**kwargs)
        self.contact_name = contact_name
        self.phone = phone
        self.phone_extension = phone_extension
        self.mobile = mobile
        self.email_list = email_list
        self.notification_preference = notification_preference


class CopyLogDetails(_serialization.Model):
    """Details for log generated during copy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxAccountCopyLogDetails, DataBoxDiskCopyLogDetails, DataBoxHeavyAccountCopyLogDetails

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    """

    _validation = {
        "copy_log_details_type": {"required": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
    }

    _subtype_map = {
        "copy_log_details_type": {
            "DataBox": "DataBoxAccountCopyLogDetails",
            "DataBoxDisk": "DataBoxDiskCopyLogDetails",
            "DataBoxHeavy": "DataBoxHeavyAccountCopyLogDetails",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: Optional[str] = None


class CopyProgress(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Copy progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account where the data needs to be uploaded.
    :vartype storage_account_name: str
    :ivar data_destination_type: Data Destination Type. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_destination_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.DataDestinationType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_sent_to_cloud: Amount of data uploaded by the job as of now.
    :vartype bytes_sent_to_cloud: int
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: int
    :ivar files_processed: Number of files processed by the job as of now.
    :vartype files_processed: int
    :ivar total_files_to_process: Total number of files to be processed by the job.
    :vartype total_files_to_process: int
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: int
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: int
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: int
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: int
    """

    _validation = {
        "storage_account_name": {"readonly": True},
        "data_destination_type": {"readonly": True},
        "account_id": {"readonly": True},
        "bytes_sent_to_cloud": {"readonly": True},
        "total_bytes_to_process": {"readonly": True},
        "files_processed": {"readonly": True},
        "total_files_to_process": {"readonly": True},
        "invalid_files_processed": {"readonly": True},
        "invalid_file_bytes_uploaded": {"readonly": True},
        "renamed_container_count": {"readonly": True},
        "files_errored_out": {"readonly": True},
    }

    _attribute_map = {
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "data_destination_type": {"key": "dataDestinationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "bytes_sent_to_cloud": {"key": "bytesSentToCloud", "type": "int"},
        "total_bytes_to_process": {"key": "totalBytesToProcess", "type": "int"},
        "files_processed": {"key": "filesProcessed", "type": "int"},
        "total_files_to_process": {"key": "totalFilesToProcess", "type": "int"},
        "invalid_files_processed": {"key": "invalidFilesProcessed", "type": "int"},
        "invalid_file_bytes_uploaded": {"key": "invalidFileBytesUploaded", "type": "int"},
        "renamed_container_count": {"key": "renamedContainerCount", "type": "int"},
        "files_errored_out": {"key": "filesErroredOut", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.storage_account_name = None
        self.data_destination_type = None
        self.account_id = None
        self.bytes_sent_to_cloud = None
        self.total_bytes_to_process = None
        self.files_processed = None
        self.total_files_to_process = None
        self.invalid_files_processed = None
        self.invalid_file_bytes_uploaded = None
        self.renamed_container_count = None
        self.files_errored_out = None


class ValidationRequest(_serialization.Model):
    """Input request for all pre job creation validation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CreateJobValidations

    All required parameters must be populated in order to send to Azure.

    :ivar individual_request_details: List of request details contain validationType and its
     request as key and value respectively. Required.
    :vartype individual_request_details:
     list[~azure.mgmt.databox.v2019_09_01.models.ValidationInputRequest]
    :ivar validation_category: Identify the nature of validation. Required. Default value is
     "JobCreationValidation".
    :vartype validation_category: str
    """

    _validation = {
        "individual_request_details": {"required": True},
        "validation_category": {"required": True},
    }

    _attribute_map = {
        "individual_request_details": {"key": "individualRequestDetails", "type": "[ValidationInputRequest]"},
        "validation_category": {"key": "validationCategory", "type": "str"},
    }

    _subtype_map = {"validation_category": {"JobCreationValidation": "CreateJobValidations"}}

    def __init__(self, *, individual_request_details: List["_models.ValidationInputRequest"], **kwargs: Any) -> None:
        """
        :keyword individual_request_details: List of request details contain validationType and its
         request as key and value respectively. Required.
        :paramtype individual_request_details:
         list[~azure.mgmt.databox.v2019_09_01.models.ValidationInputRequest]
        """
        super().__init__(**kwargs)
        self.individual_request_details = individual_request_details
        self.validation_category: Optional[str] = None


class CreateJobValidations(ValidationRequest):
    """It does all pre-job creation validations.

    All required parameters must be populated in order to send to Azure.

    :ivar individual_request_details: List of request details contain validationType and its
     request as key and value respectively. Required.
    :vartype individual_request_details:
     list[~azure.mgmt.databox.v2019_09_01.models.ValidationInputRequest]
    :ivar validation_category: Identify the nature of validation. Required. Default value is
     "JobCreationValidation".
    :vartype validation_category: str
    """

    _validation = {
        "individual_request_details": {"required": True},
        "validation_category": {"required": True},
    }

    _attribute_map = {
        "individual_request_details": {"key": "individualRequestDetails", "type": "[ValidationInputRequest]"},
        "validation_category": {"key": "validationCategory", "type": "str"},
    }

    def __init__(self, *, individual_request_details: List["_models.ValidationInputRequest"], **kwargs: Any) -> None:
        """
        :keyword individual_request_details: List of request details contain validationType and its
         request as key and value respectively. Required.
        :paramtype individual_request_details:
         list[~azure.mgmt.databox.v2019_09_01.models.ValidationInputRequest]
        """
        super().__init__(individual_request_details=individual_request_details, **kwargs)
        self.validation_category: str = "JobCreationValidation"


class ValidationInputRequest(_serialization.Model):
    """Minimum fields that must be present in any type of validation request.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ValidateAddress, CreateOrderLimitForSubscriptionValidationRequest,
    DataDestinationDetailsValidationRequest, PreferencesValidationRequest,
    SkuAvailabilityValidationRequest, SubscriptionIsAllowedToCreateJobValidationRequest

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    """

    _validation = {
        "validation_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
    }

    _subtype_map = {
        "validation_type": {
            "ValidateAddress": "ValidateAddress",
            "ValidateCreateOrderLimit": "CreateOrderLimitForSubscriptionValidationRequest",
            "ValidateDataDestinationDetails": "DataDestinationDetailsValidationRequest",
            "ValidatePreferences": "PreferencesValidationRequest",
            "ValidateSkuAvailability": "SkuAvailabilityValidationRequest",
            "ValidateSubscriptionIsAllowedToCreateJob": "SubscriptionIsAllowedToCreateJobValidationRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: Optional[str] = None


class CreateOrderLimitForSubscriptionValidationRequest(ValidationInputRequest):
    """Request to validate create order limit for current subscription.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", and "DataBoxHeavy".
    :vartype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
    }

    def __init__(self, *, device_type: Union[str, "_models.SkuName"], **kwargs: Any) -> None:
        """
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", and "DataBoxHeavy".
        :paramtype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateCreateOrderLimit"
        self.device_type = device_type


class CreateOrderLimitForSubscriptionValidationResponseProperties(ValidationInputResponse):
    """Properties of create order limit for subscription validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar status: Create order limit validation status. Known values are: "Valid", "Invalid", and
     "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateCreateOrderLimit"
        self.status = None


class DataBoxAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account of a DataBox job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar account_name: Destination account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: str
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "account_name": {"readonly": True},
        "copy_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "copy_log_link": {"key": "copyLogLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBox"
        self.account_name = None
        self.copy_log_link = None


class DataBoxDiskCopyLogDetails(CopyLogDetails):
    """Copy Log Details for a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar disk_serial_number: Disk Serial Number.
    :vartype disk_serial_number: str
    :ivar error_log_link: Link for copy error logs.
    :vartype error_log_link: str
    :ivar verbose_log_link: Link for copy verbose logs.
    :vartype verbose_log_link: str
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "disk_serial_number": {"readonly": True},
        "error_log_link": {"readonly": True},
        "verbose_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "disk_serial_number": {"key": "diskSerialNumber", "type": "str"},
        "error_log_link": {"key": "errorLogLink", "type": "str"},
        "verbose_log_link": {"key": "verboseLogLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBoxDisk"
        self.disk_serial_number = None
        self.error_log_link = None
        self.verbose_log_link = None


class DataBoxDiskCopyProgress(_serialization.Model):
    """DataBox Disk Copy Progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar serial_number: The serial number of the disk.
    :vartype serial_number: str
    :ivar bytes_copied: Bytes copied during the copy of disk.
    :vartype bytes_copied: int
    :ivar percent_complete: Indicates the percentage completed for the copy of the disk.
    :vartype percent_complete: int
    :ivar status: The Status of the copy. Known values are: "NotStarted", "InProgress",
     "Completed", "CompletedWithErrors", "Failed", "NotReturned", "HardwareError",
     "DeviceFormatted", "DeviceMetadataModified", "StorageAccountNotAccessible", and
     "UnsupportedData".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.CopyStatus
    """

    _validation = {
        "serial_number": {"readonly": True},
        "bytes_copied": {"readonly": True},
        "percent_complete": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "serial_number": {"key": "serialNumber", "type": "str"},
        "bytes_copied": {"key": "bytesCopied", "type": "int"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.serial_number = None
        self.bytes_copied = None
        self.percent_complete = None
        self.status = None


class JobDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Job details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxJobDetails, DataBoxDiskJobDetails, DataBoxHeavyJobDetails

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2019_09_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer. Required.
    :vartype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar destination_account_details: Destination account details. Required.
    :vartype destination_account_details:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.v2019_09_01.models.JobErrorDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2019_09_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "shipping_address": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "destination_account_details": {"required": True},
        "error_details": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
    }

    _attribute_map = {
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "destination_account_details": {"key": "destinationAccountDetails", "type": "[DestinationAccountDetails]"},
        "error_details": {"key": "errorDetails", "type": "[JobErrorDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
    }

    _subtype_map = {
        "job_details_type": {
            "DataBox": "DataBoxJobDetails",
            "DataBoxDisk": "DataBoxDiskJobDetails",
            "DataBoxHeavy": "DataBoxHeavyJobDetails",
        }
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: "_models.ShippingAddress",
        destination_account_details: List["_models.DestinationAccountDetails"],
        expected_data_size_in_tera_bytes: Optional[int] = None,
        preferences: Optional["_models.Preferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer. Required.
        :paramtype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
        :keyword destination_account_details: Destination account details. Required.
        :paramtype destination_account_details:
         list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
        """
        super().__init__(**kwargs)
        self.expected_data_size_in_tera_bytes = expected_data_size_in_tera_bytes
        self.job_stages = None
        self.contact_details = contact_details
        self.shipping_address = shipping_address
        self.delivery_package = None
        self.return_package = None
        self.destination_account_details = destination_account_details
        self.error_details = None
        self.job_details_type: Optional[str] = None
        self.preferences = preferences
        self.copy_log_details = None
        self.reverse_shipment_label_sas_key = None
        self.chain_of_custody_sas_key = None


class DataBoxDiskJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """DataBox Disk Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2019_09_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer. Required.
    :vartype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar destination_account_details: Destination account details. Required.
    :vartype destination_account_details:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.v2019_09_01.models.JobErrorDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2019_09_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar preferred_disks: User preference on what size disks are needed for the job. The map is
     from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but
     will be checked against an int.
    :vartype preferred_disks: dict[str, int]
    :ivar copy_progress: Copy progress per disk.
    :vartype copy_progress: list[~azure.mgmt.databox.v2019_09_01.models.DataBoxDiskCopyProgress]
    :ivar disks_and_size_details: Contains the map of disk serial number to the disk size being
     used for the job. Is returned only after the disks are shipped to the customer.
    :vartype disks_and_size_details: dict[str, int]
    :ivar passkey: User entered passkey for DataBox Disk job.
    :vartype passkey: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "shipping_address": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "destination_account_details": {"required": True},
        "error_details": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "copy_progress": {"readonly": True},
        "disks_and_size_details": {"readonly": True},
    }

    _attribute_map = {
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "destination_account_details": {"key": "destinationAccountDetails", "type": "[DestinationAccountDetails]"},
        "error_details": {"key": "errorDetails", "type": "[JobErrorDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "preferred_disks": {"key": "preferredDisks", "type": "{int}"},
        "copy_progress": {"key": "copyProgress", "type": "[DataBoxDiskCopyProgress]"},
        "disks_and_size_details": {"key": "disksAndSizeDetails", "type": "{int}"},
        "passkey": {"key": "passkey", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: "_models.ShippingAddress",
        destination_account_details: List["_models.DestinationAccountDetails"],
        expected_data_size_in_tera_bytes: Optional[int] = None,
        preferences: Optional["_models.Preferences"] = None,
        preferred_disks: Optional[Dict[str, int]] = None,
        passkey: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer. Required.
        :paramtype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
        :keyword destination_account_details: Destination account details. Required.
        :paramtype destination_account_details:
         list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
        :keyword preferred_disks: User preference on what size disks are needed for the job. The map is
         from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but
         will be checked against an int.
        :paramtype preferred_disks: dict[str, int]
        :keyword passkey: User entered passkey for DataBox Disk job.
        :paramtype passkey: str
        """
        super().__init__(
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            contact_details=contact_details,
            shipping_address=shipping_address,
            destination_account_details=destination_account_details,
            preferences=preferences,
            **kwargs
        )
        self.job_details_type: str = "DataBoxDisk"
        self.preferred_disks = preferred_disks
        self.copy_progress = None
        self.disks_and_size_details = None
        self.passkey = passkey


class JobSecrets(_serialization.Model):
    """The base class for the secrets.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataboxJobSecrets, DataBoxDiskJobSecrets, DataBoxHeavyJobSecrets

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
    """

    _validation = {
        "job_secrets_type": {"required": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
    }

    _subtype_map = {
        "job_secrets_type": {
            "DataBox": "DataboxJobSecrets",
            "DataBoxDisk": "DataBoxDiskJobSecrets",
            "DataBoxHeavy": "DataBoxHeavyJobSecrets",
        }
    }

    def __init__(
        self, *, dc_access_security_code: Optional["_models.DcAccessSecurityCode"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
        :paramtype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
        """
        super().__init__(**kwargs)
        self.job_secrets_type: Optional[str] = None
        self.dc_access_security_code = dc_access_security_code


class DataBoxDiskJobSecrets(JobSecrets):
    """The secrets related to disk job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
    :ivar disk_secrets: Contains the list of secrets object for that device.
    :vartype disk_secrets: list[~azure.mgmt.databox.v2019_09_01.models.DiskSecret]
    :ivar pass_key: PassKey for the disk Job.
    :vartype pass_key: str
    :ivar is_passkey_user_defined: Whether passkey was provided by user.
    :vartype is_passkey_user_defined: bool
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "disk_secrets": {"readonly": True},
        "pass_key": {"readonly": True},
        "is_passkey_user_defined": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "disk_secrets": {"key": "diskSecrets", "type": "[DiskSecret]"},
        "pass_key": {"key": "passKey", "type": "str"},
        "is_passkey_user_defined": {"key": "isPasskeyUserDefined", "type": "bool"},
    }

    def __init__(
        self, *, dc_access_security_code: Optional["_models.DcAccessSecurityCode"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
        :paramtype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
        """
        super().__init__(dc_access_security_code=dc_access_security_code, **kwargs)
        self.job_secrets_type: str = "DataBoxDisk"
        self.disk_secrets = None
        self.pass_key = None
        self.is_passkey_user_defined = None


class DataBoxHeavyAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account for Databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar account_name: Destination account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: list[str]
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "account_name": {"readonly": True},
        "copy_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "copy_log_link": {"key": "copyLogLink", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBoxHeavy"
        self.account_name = None
        self.copy_log_link = None


class DataBoxHeavyJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """Databox Heavy Device Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2019_09_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer. Required.
    :vartype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar destination_account_details: Destination account details. Required.
    :vartype destination_account_details:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.v2019_09_01.models.JobErrorDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2019_09_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar copy_progress: Copy progress per account.
    :vartype copy_progress: list[~azure.mgmt.databox.v2019_09_01.models.CopyProgress]
    :ivar device_password: Set Device password for unlocking Databox Heavy.
    :vartype device_password: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "shipping_address": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "destination_account_details": {"required": True},
        "error_details": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "copy_progress": {"readonly": True},
    }

    _attribute_map = {
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "destination_account_details": {"key": "destinationAccountDetails", "type": "[DestinationAccountDetails]"},
        "error_details": {"key": "errorDetails", "type": "[JobErrorDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "copy_progress": {"key": "copyProgress", "type": "[CopyProgress]"},
        "device_password": {"key": "devicePassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: "_models.ShippingAddress",
        destination_account_details: List["_models.DestinationAccountDetails"],
        expected_data_size_in_tera_bytes: Optional[int] = None,
        preferences: Optional["_models.Preferences"] = None,
        device_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer. Required.
        :paramtype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
        :keyword destination_account_details: Destination account details. Required.
        :paramtype destination_account_details:
         list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
        :keyword device_password: Set Device password for unlocking Databox Heavy.
        :paramtype device_password: str
        """
        super().__init__(
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            contact_details=contact_details,
            shipping_address=shipping_address,
            destination_account_details=destination_account_details,
            preferences=preferences,
            **kwargs
        )
        self.job_details_type: str = "DataBoxHeavy"
        self.copy_progress = None
        self.device_password = device_password


class DataBoxHeavyJobSecrets(JobSecrets):
    """The secrets related to a databox heavy job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
    :ivar cabinet_pod_secrets: Contains the list of secret objects for a databox heavy job.
    :vartype cabinet_pod_secrets: list[~azure.mgmt.databox.v2019_09_01.models.DataBoxHeavySecret]
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "cabinet_pod_secrets": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "cabinet_pod_secrets": {"key": "cabinetPodSecrets", "type": "[DataBoxHeavySecret]"},
    }

    def __init__(
        self, *, dc_access_security_code: Optional["_models.DcAccessSecurityCode"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
        :paramtype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
        """
        super().__init__(dc_access_security_code=dc_access_security_code, **kwargs)
        self.job_secrets_type: str = "DataBoxHeavy"
        self.cabinet_pod_secrets = None


class DataBoxHeavySecret(_serialization.Model):
    """The secrets related to a databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations:
     list[~azure.mgmt.databox.v2019_09_01.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details:
     list[~azure.mgmt.databox.v2019_09_01.models.AccountCredentialDetails]
    """

    _validation = {
        "device_serial_number": {"readonly": True},
        "device_password": {"readonly": True},
        "network_configurations": {"readonly": True},
        "encoded_validation_cert_pub_key": {"readonly": True},
        "account_credential_details": {"readonly": True},
    }

    _attribute_map = {
        "device_serial_number": {"key": "deviceSerialNumber", "type": "str"},
        "device_password": {"key": "devicePassword", "type": "str"},
        "network_configurations": {"key": "networkConfigurations", "type": "[ApplianceNetworkConfiguration]"},
        "encoded_validation_cert_pub_key": {"key": "encodedValidationCertPubKey", "type": "str"},
        "account_credential_details": {"key": "accountCredentialDetails", "type": "[AccountCredentialDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataBoxJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """Databox Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2019_09_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer. Required.
    :vartype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2019_09_01.models.PackageShippingDetails
    :ivar destination_account_details: Destination account details. Required.
    :vartype destination_account_details:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
    :ivar error_details: Error details for failure. This is optional.
    :vartype error_details: list[~azure.mgmt.databox.v2019_09_01.models.JobErrorDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2019_09_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar copy_progress: Copy progress per storage account.
    :vartype copy_progress: list[~azure.mgmt.databox.v2019_09_01.models.CopyProgress]
    :ivar device_password: Set Device password for unlocking Databox.
    :vartype device_password: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "shipping_address": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "destination_account_details": {"required": True},
        "error_details": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "copy_progress": {"readonly": True},
    }

    _attribute_map = {
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "destination_account_details": {"key": "destinationAccountDetails", "type": "[DestinationAccountDetails]"},
        "error_details": {"key": "errorDetails", "type": "[JobErrorDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "copy_progress": {"key": "copyProgress", "type": "[CopyProgress]"},
        "device_password": {"key": "devicePassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: "_models.ShippingAddress",
        destination_account_details: List["_models.DestinationAccountDetails"],
        expected_data_size_in_tera_bytes: Optional[int] = None,
        preferences: Optional["_models.Preferences"] = None,
        device_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer. Required.
        :paramtype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
        :keyword destination_account_details: Destination account details. Required.
        :paramtype destination_account_details:
         list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2019_09_01.models.Preferences
        :keyword device_password: Set Device password for unlocking Databox.
        :paramtype device_password: str
        """
        super().__init__(
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            contact_details=contact_details,
            shipping_address=shipping_address,
            destination_account_details=destination_account_details,
            preferences=preferences,
            **kwargs
        )
        self.job_details_type: str = "DataBox"
        self.copy_progress = None
        self.device_password = device_password


class DataboxJobSecrets(JobSecrets):
    """The secrets related to a databox job.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2019_09_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
    :ivar pod_secrets: Contains the list of secret objects for a job.
    :vartype pod_secrets: list[~azure.mgmt.databox.v2019_09_01.models.DataBoxSecret]
    """

    _validation = {
        "job_secrets_type": {"required": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "pod_secrets": {"key": "podSecrets", "type": "[DataBoxSecret]"},
    }

    def __init__(
        self,
        *,
        dc_access_security_code: Optional["_models.DcAccessSecurityCode"] = None,
        pod_secrets: Optional[List["_models.DataBoxSecret"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
        :paramtype dc_access_security_code: ~azure.mgmt.databox.v2019_09_01.models.DcAccessSecurityCode
        :keyword pod_secrets: Contains the list of secret objects for a job.
        :paramtype pod_secrets: list[~azure.mgmt.databox.v2019_09_01.models.DataBoxSecret]
        """
        super().__init__(dc_access_security_code=dc_access_security_code, **kwargs)
        self.job_secrets_type: str = "DataBox"
        self.pod_secrets = pod_secrets


class ScheduleAvailabilityRequest(_serialization.Model):
    """Request body to get the availability for scheduling orders.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxScheduleAvailabilityRequest, DiskScheduleAvailabilityRequest,
    HeavyScheduleAvailabilityRequest

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer.
     For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype sku_name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
    }

    _subtype_map = {
        "sku_name": {
            "DataBox": "DataBoxScheduleAvailabilityRequest",
            "DataBoxDisk": "DiskScheduleAvailabilityRequest",
            "DataBoxHeavy": "HeavyScheduleAvailabilityRequest",
        }
    }

    def __init__(self, *, storage_location: str, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer.
         For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        """
        super().__init__(**kwargs)
        self.storage_location = storage_location
        self.sku_name: Optional[str] = None


class DataBoxScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling data box orders orders.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer.
     For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype sku_name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
    }

    def __init__(self, *, storage_location: str, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer.
         For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        """
        super().__init__(storage_location=storage_location, **kwargs)
        self.sku_name: str = "DataBox"


class DataBoxSecret(_serialization.Model):
    """The secrets related to a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations:
     list[~azure.mgmt.databox.v2019_09_01.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details:
     list[~azure.mgmt.databox.v2019_09_01.models.AccountCredentialDetails]
    """

    _validation = {
        "device_serial_number": {"readonly": True},
        "device_password": {"readonly": True},
        "network_configurations": {"readonly": True},
        "encoded_validation_cert_pub_key": {"readonly": True},
        "account_credential_details": {"readonly": True},
    }

    _attribute_map = {
        "device_serial_number": {"key": "deviceSerialNumber", "type": "str"},
        "device_password": {"key": "devicePassword", "type": "str"},
        "network_configurations": {"key": "networkConfigurations", "type": "[ApplianceNetworkConfiguration]"},
        "encoded_validation_cert_pub_key": {"key": "encodedValidationCertPubKey", "type": "str"},
        "account_credential_details": {"key": "accountCredentialDetails", "type": "[AccountCredentialDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataDestinationDetailsValidationRequest(ValidationInputRequest):
    """Request to validate data destination details.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar destination_account_details: Destination account details list. Required.
    :vartype destination_account_details:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
    :ivar location: Location of stamp or geo. Required.
    :vartype location: str
    """

    _validation = {
        "validation_type": {"required": True},
        "destination_account_details": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "destination_account_details": {"key": "destinationAccountDetails", "type": "[DestinationAccountDetails]"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self, *, destination_account_details: List["_models.DestinationAccountDetails"], location: str, **kwargs: Any
    ) -> None:
        """
        :keyword destination_account_details: Destination account details list. Required.
        :paramtype destination_account_details:
         list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
        :keyword location: Location of stamp or geo. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateDataDestinationDetails"
        self.destination_account_details = destination_account_details
        self.location = location


class DataDestinationDetailsValidationResponseProperties(ValidationInputResponse):
    """Properties of data destination details validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar status: Data destination details validation status. Known values are: "Valid", "Invalid",
     and "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateDataDestinationDetails"
        self.status = None


class DcAccessSecurityCode(_serialization.Model):
    """Dc Access Security code for device.

    :ivar forward_dc_access_code: Dc Access Code for dispatching from DC.
    :vartype forward_dc_access_code: str
    :ivar reverse_dc_access_code: Dc Access code for dropping off at DC.
    :vartype reverse_dc_access_code: str
    """

    _attribute_map = {
        "forward_dc_access_code": {"key": "forwardDCAccessCode", "type": "str"},
        "reverse_dc_access_code": {"key": "reverseDCAccessCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        forward_dc_access_code: Optional[str] = None,
        reverse_dc_access_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword forward_dc_access_code: Dc Access Code for dispatching from DC.
        :paramtype forward_dc_access_code: str
        :keyword reverse_dc_access_code: Dc Access code for dropping off at DC.
        :paramtype reverse_dc_access_code: str
        """
        super().__init__(**kwargs)
        self.forward_dc_access_code = forward_dc_access_code
        self.reverse_dc_access_code = reverse_dc_access_code


class DestinationAccountDetails(_serialization.Model):
    """Details of the destination storage accounts.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DestinationManagedDiskDetails, DestinationStorageAccountDetails

    All required parameters must be populated in order to send to Azure.

    :ivar data_destination_type: Data Destination Type. Required. Known values are:
     "StorageAccount" and "ManagedDisk".
    :vartype data_destination_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.DataDestinationType
    :ivar account_id: Arm Id of the destination where the data has to be moved.
    :vartype account_id: str
    :ivar share_password: Share password to be shared by all shares in SA.
    :vartype share_password: str
    """

    _validation = {
        "data_destination_type": {"required": True},
    }

    _attribute_map = {
        "data_destination_type": {"key": "dataDestinationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "share_password": {"key": "sharePassword", "type": "str"},
    }

    _subtype_map = {
        "data_destination_type": {
            "ManagedDisk": "DestinationManagedDiskDetails",
            "StorageAccount": "DestinationStorageAccountDetails",
        }
    }

    def __init__(
        self, *, account_id: Optional[str] = None, share_password: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword account_id: Arm Id of the destination where the data has to be moved.
        :paramtype account_id: str
        :keyword share_password: Share password to be shared by all shares in SA.
        :paramtype share_password: str
        """
        super().__init__(**kwargs)
        self.data_destination_type: Optional[str] = None
        self.account_id = account_id
        self.share_password = share_password


class DestinationManagedDiskDetails(DestinationAccountDetails):
    """Details for the destination compute disks.

    All required parameters must be populated in order to send to Azure.

    :ivar data_destination_type: Data Destination Type. Required. Known values are:
     "StorageAccount" and "ManagedDisk".
    :vartype data_destination_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.DataDestinationType
    :ivar account_id: Arm Id of the destination where the data has to be moved.
    :vartype account_id: str
    :ivar share_password: Share password to be shared by all shares in SA.
    :vartype share_password: str
    :ivar resource_group_id: Destination Resource Group Id where the Compute disks should be
     created. Required.
    :vartype resource_group_id: str
    :ivar staging_storage_account_id: Arm Id of the storage account that can be used to copy the
     vhd for staging. Required.
    :vartype staging_storage_account_id: str
    """

    _validation = {
        "data_destination_type": {"required": True},
        "resource_group_id": {"required": True},
        "staging_storage_account_id": {"required": True},
    }

    _attribute_map = {
        "data_destination_type": {"key": "dataDestinationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "share_password": {"key": "sharePassword", "type": "str"},
        "resource_group_id": {"key": "resourceGroupId", "type": "str"},
        "staging_storage_account_id": {"key": "stagingStorageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_group_id: str,
        staging_storage_account_id: str,
        account_id: Optional[str] = None,
        share_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword account_id: Arm Id of the destination where the data has to be moved.
        :paramtype account_id: str
        :keyword share_password: Share password to be shared by all shares in SA.
        :paramtype share_password: str
        :keyword resource_group_id: Destination Resource Group Id where the Compute disks should be
         created. Required.
        :paramtype resource_group_id: str
        :keyword staging_storage_account_id: Arm Id of the storage account that can be used to copy the
         vhd for staging. Required.
        :paramtype staging_storage_account_id: str
        """
        super().__init__(account_id=account_id, share_password=share_password, **kwargs)
        self.data_destination_type: str = "ManagedDisk"
        self.resource_group_id = resource_group_id
        self.staging_storage_account_id = staging_storage_account_id


class DestinationStorageAccountDetails(DestinationAccountDetails):
    """Details for the destination storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar data_destination_type: Data Destination Type. Required. Known values are:
     "StorageAccount" and "ManagedDisk".
    :vartype data_destination_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.DataDestinationType
    :ivar account_id: Arm Id of the destination where the data has to be moved.
    :vartype account_id: str
    :ivar share_password: Share password to be shared by all shares in SA.
    :vartype share_password: str
    :ivar storage_account_id: Destination Storage Account Arm Id. Required.
    :vartype storage_account_id: str
    """

    _validation = {
        "data_destination_type": {"required": True},
        "storage_account_id": {"required": True},
    }

    _attribute_map = {
        "data_destination_type": {"key": "dataDestinationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "share_password": {"key": "sharePassword", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_account_id: str,
        account_id: Optional[str] = None,
        share_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword account_id: Arm Id of the destination where the data has to be moved.
        :paramtype account_id: str
        :keyword share_password: Share password to be shared by all shares in SA.
        :paramtype share_password: str
        :keyword storage_account_id: Destination Storage Account Arm Id. Required.
        :paramtype storage_account_id: str
        """
        super().__init__(account_id=account_id, share_password=share_password, **kwargs)
        self.data_destination_type: str = "StorageAccount"
        self.storage_account_id = storage_account_id


class DestinationToServiceLocationMap(_serialization.Model):
    """Map of destination location to service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar destination_location: Location of the destination.
    :vartype destination_location: str
    :ivar service_location: Location of the service.
    :vartype service_location: str
    """

    _validation = {
        "destination_location": {"readonly": True},
        "service_location": {"readonly": True},
    }

    _attribute_map = {
        "destination_location": {"key": "destinationLocation", "type": "str"},
        "service_location": {"key": "serviceLocation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.destination_location = None
        self.service_location = None


class DiskScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling disk orders.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer.
     For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype sku_name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes. Required.
    :vartype expected_data_size_in_tera_bytes: int
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
        "expected_data_size_in_tera_bytes": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
    }

    def __init__(self, *, storage_location: str, expected_data_size_in_tera_bytes: int, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer.
         For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes. Required.
        :paramtype expected_data_size_in_tera_bytes: int
        """
        super().__init__(storage_location=storage_location, **kwargs)
        self.sku_name: str = "DataBoxDisk"
        self.expected_data_size_in_tera_bytes = expected_data_size_in_tera_bytes


class DiskSecret(_serialization.Model):
    """Contains all the secrets of a Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_serial_number: Serial number of the assigned disk.
    :vartype disk_serial_number: str
    :ivar bit_locker_key: Bit Locker key of the disk which can be used to unlock the disk to copy
     data.
    :vartype bit_locker_key: str
    """

    _validation = {
        "disk_serial_number": {"readonly": True},
        "bit_locker_key": {"readonly": True},
    }

    _attribute_map = {
        "disk_serial_number": {"key": "diskSerialNumber", "type": "str"},
        "bit_locker_key": {"key": "bitLockerKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.disk_serial_number = None
        self.bit_locker_key = None


class Error(_serialization.Model):
    """Top level error for the job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code that can be used to programmatically identify the error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging information.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class HeavyScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling heavy orders.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer.
     For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", and "DataBoxHeavy".
    :vartype sku_name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
    }

    def __init__(self, *, storage_location: str, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer.
         For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        """
        super().__init__(storage_location=storage_location, **kwargs)
        self.sku_name: str = "DataBoxHeavy"


class JobDeliveryInfo(_serialization.Model):
    """Additional delivery info.

    :ivar scheduled_date_time: Scheduled date time.
    :vartype scheduled_date_time: ~datetime.datetime
    """

    _attribute_map = {
        "scheduled_date_time": {"key": "scheduledDateTime", "type": "iso-8601"},
    }

    def __init__(self, *, scheduled_date_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword scheduled_date_time: Scheduled date time.
        :paramtype scheduled_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.scheduled_date_time = scheduled_date_time


class JobErrorDetails(_serialization.Model):
    """Job Error Details for providing the information and recommended action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_message: Message for the error.
    :vartype error_message: str
    :ivar error_code: Code for the error.
    :vartype error_code: int
    :ivar recommended_action: Recommended action for the error.
    :vartype recommended_action: str
    :ivar exception_message: Contains the non localized exception message.
    :vartype exception_message: str
    """

    _validation = {
        "error_message": {"readonly": True},
        "error_code": {"readonly": True},
        "recommended_action": {"readonly": True},
        "exception_message": {"readonly": True},
    }

    _attribute_map = {
        "error_message": {"key": "errorMessage", "type": "str"},
        "error_code": {"key": "errorCode", "type": "int"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "exception_message": {"key": "exceptionMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_message = None
        self.error_code = None
        self.recommended_action = None
        self.exception_message = None


class Resource(_serialization.Model):
    """Model of the Resource.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The location of the resource. This will be one of the supported and registered
     Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be
     changed once it is created, but if an identical region is specified on update the request will
     succeed. Required.
    :vartype location: str
    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: The sku type. Required.
    :vartype sku: ~azure.mgmt.databox.v2019_09_01.models.Sku
    """

    _validation = {
        "location": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self, *, location: str, sku: "_models.Sku", tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This will be one of the supported and
         registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
         resource cannot be changed once it is created, but if an identical region is specified on
         update the request will succeed. Required.
        :paramtype location: str
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword sku: The sku type. Required.
        :paramtype sku: ~azure.mgmt.databox.v2019_09_01.models.Sku
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku


class JobResource(Resource):  # pylint: disable=too-many-instance-attributes
    """Job Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The location of the resource. This will be one of the supported and registered
     Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be
     changed once it is created, but if an identical region is specified on update the request will
     succeed. Required.
    :vartype location: str
    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: The sku type. Required.
    :vartype sku: ~azure.mgmt.databox.v2019_09_01.models.Sku
    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    :ivar is_cancellable: Describes whether the job is cancellable or not.
    :vartype is_cancellable: bool
    :ivar is_deletable: Describes whether the job is deletable or not.
    :vartype is_deletable: bool
    :ivar is_shipping_address_editable: Describes whether the shipping address is editable or not.
    :vartype is_shipping_address_editable: bool
    :ivar status: Name of the stage which is in progress. Known values are: "DeviceOrdered",
     "DevicePrepared", "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", and "ReadyToReceiveAtAzureDC".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.StageName
    :ivar start_time: Time at which the job was started in UTC ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar error: Top level error for the job.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar details: Details of a job run. This field will only be sent for expand details filter.
    :vartype details: ~azure.mgmt.databox.v2019_09_01.models.JobDetails
    :ivar cancellation_reason: Reason for cancellation.
    :vartype cancellation_reason: str
    :ivar delivery_type: Delivery type of Job. Known values are: "NonScheduled" and "Scheduled".
    :vartype delivery_type: str or ~azure.mgmt.databox.v2019_09_01.models.JobDeliveryType
    :ivar delivery_info: Delivery Info of Job.
    :vartype delivery_info: ~azure.mgmt.databox.v2019_09_01.models.JobDeliveryInfo
    :ivar is_cancellable_without_fee: Flag to indicate cancellation of scheduled job.
    :vartype is_cancellable_without_fee: bool
    """

    _validation = {
        "location": {"required": True},
        "sku": {"required": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "is_cancellable": {"readonly": True},
        "is_deletable": {"readonly": True},
        "is_shipping_address_editable": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "error": {"readonly": True},
        "cancellation_reason": {"readonly": True},
        "is_cancellable_without_fee": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
        "is_deletable": {"key": "properties.isDeletable", "type": "bool"},
        "is_shipping_address_editable": {"key": "properties.isShippingAddressEditable", "type": "bool"},
        "status": {"key": "properties.status", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "error": {"key": "properties.error", "type": "Error"},
        "details": {"key": "properties.details", "type": "JobDetails"},
        "cancellation_reason": {"key": "properties.cancellationReason", "type": "str"},
        "delivery_type": {"key": "properties.deliveryType", "type": "str"},
        "delivery_info": {"key": "properties.deliveryInfo", "type": "JobDeliveryInfo"},
        "is_cancellable_without_fee": {"key": "properties.isCancellableWithoutFee", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        details: Optional["_models.JobDetails"] = None,
        delivery_type: Union[str, "_models.JobDeliveryType"] = "NonScheduled",
        delivery_info: Optional["_models.JobDeliveryInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This will be one of the supported and
         registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
         resource cannot be changed once it is created, but if an identical region is specified on
         update the request will succeed. Required.
        :paramtype location: str
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword sku: The sku type. Required.
        :paramtype sku: ~azure.mgmt.databox.v2019_09_01.models.Sku
        :keyword details: Details of a job run. This field will only be sent for expand details filter.
        :paramtype details: ~azure.mgmt.databox.v2019_09_01.models.JobDetails
        :keyword delivery_type: Delivery type of Job. Known values are: "NonScheduled" and "Scheduled".
        :paramtype delivery_type: str or ~azure.mgmt.databox.v2019_09_01.models.JobDeliveryType
        :keyword delivery_info: Delivery Info of Job.
        :paramtype delivery_info: ~azure.mgmt.databox.v2019_09_01.models.JobDeliveryInfo
        """
        super().__init__(location=location, tags=tags, sku=sku, **kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.is_cancellable = None
        self.is_deletable = None
        self.is_shipping_address_editable = None
        self.status = None
        self.start_time = None
        self.error = None
        self.details = details
        self.cancellation_reason = None
        self.delivery_type = delivery_type
        self.delivery_info = delivery_info
        self.is_cancellable_without_fee = None


class JobResourceList(_serialization.Model):
    """Job Resource Collection.

    :ivar value: List of job resources.
    :vartype value: list[~azure.mgmt.databox.v2019_09_01.models.JobResource]
    :ivar next_link: Link for the next set of job resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[JobResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.JobResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of job resources.
        :paramtype value: list[~azure.mgmt.databox.v2019_09_01.models.JobResource]
        :keyword next_link: Link for the next set of job resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobResourceUpdateParameter(_serialization.Model):
    """The JobResourceUpdateParameter.

    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar details: Details of a job to be updated.
    :vartype details: ~azure.mgmt.databox.v2019_09_01.models.UpdateJobDetails
    :ivar destination_account_details: Destination account details.
    :vartype destination_account_details:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "details": {"key": "properties.details", "type": "UpdateJobDetails"},
        "destination_account_details": {
            "key": "properties.destinationAccountDetails",
            "type": "[DestinationAccountDetails]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        details: Optional["_models.UpdateJobDetails"] = None,
        destination_account_details: Optional[List["_models.DestinationAccountDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword details: Details of a job to be updated.
        :paramtype details: ~azure.mgmt.databox.v2019_09_01.models.UpdateJobDetails
        :keyword destination_account_details: Destination account details.
        :paramtype destination_account_details:
         list[~azure.mgmt.databox.v2019_09_01.models.DestinationAccountDetails]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.details = details
        self.destination_account_details = destination_account_details


class JobStages(_serialization.Model):
    """Job stages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar stage_name: Name of the job stage. Known values are: "DeviceOrdered", "DevicePrepared",
     "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", and "ReadyToReceiveAtAzureDC".
    :vartype stage_name: str or ~azure.mgmt.databox.v2019_09_01.models.StageName
    :ivar display_name: Display name of the job stage.
    :vartype display_name: str
    :ivar stage_status: Status of the job stage. Known values are: "None", "InProgress",
     "Succeeded", "Failed", "Cancelled", "Cancelling", and "SucceededWithErrors".
    :vartype stage_status: str or ~azure.mgmt.databox.v2019_09_01.models.StageStatus
    :ivar stage_time: Time for the job stage in UTC ISO 8601 format.
    :vartype stage_time: ~datetime.datetime
    :ivar job_stage_details: Job Stage Details.
    :vartype job_stage_details: JSON
    :ivar error_details: Error details for the stage.
    :vartype error_details: list[~azure.mgmt.databox.v2019_09_01.models.JobErrorDetails]
    """

    _validation = {
        "stage_name": {"readonly": True},
        "display_name": {"readonly": True},
        "stage_status": {"readonly": True},
        "stage_time": {"readonly": True},
        "job_stage_details": {"readonly": True},
        "error_details": {"readonly": True},
    }

    _attribute_map = {
        "stage_name": {"key": "stageName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "stage_status": {"key": "stageStatus", "type": "str"},
        "stage_time": {"key": "stageTime", "type": "iso-8601"},
        "job_stage_details": {"key": "jobStageDetails", "type": "object"},
        "error_details": {"key": "errorDetails", "type": "[JobErrorDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.stage_name = None
        self.display_name = None
        self.stage_status = None
        self.stage_time = None
        self.job_stage_details = None
        self.error_details = None


class NotificationPreference(_serialization.Model):
    """Notification preference for a job stage.

    All required parameters must be populated in order to send to Azure.

    :ivar stage_name: Name of the stage. Required. Known values are: "DevicePrepared",
     "Dispatched", "Delivered", "PickedUp", "AtAzureDC", and "DataCopy".
    :vartype stage_name: str or ~azure.mgmt.databox.v2019_09_01.models.NotificationStageName
    :ivar send_notification: Notification is required or not.
    :vartype send_notification: bool
    """

    _validation = {
        "stage_name": {"required": True},
        "send_notification": {"required": True},
    }

    _attribute_map = {
        "stage_name": {"key": "stageName", "type": "str"},
        "send_notification": {"key": "sendNotification", "type": "bool"},
    }

    def __init__(
        self, *, stage_name: Union[str, "_models.NotificationStageName"], send_notification: bool = True, **kwargs: Any
    ) -> None:
        """
        :keyword stage_name: Name of the stage. Required. Known values are: "DevicePrepared",
         "Dispatched", "Delivered", "PickedUp", "AtAzureDC", and "DataCopy".
        :paramtype stage_name: str or ~azure.mgmt.databox.v2019_09_01.models.NotificationStageName
        :keyword send_notification: Notification is required or not.
        :paramtype send_notification: bool
        """
        super().__init__(**kwargs)
        self.stage_name = stage_name
        self.send_notification = send_notification


class Operation(_serialization.Model):
    """Operation entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation. Format:
     {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}.
    :vartype name: str
    :ivar display: Operation display values.
    :vartype display: ~azure.mgmt.databox.v2019_09_01.models.OperationDisplay
    :ivar properties: Operation properties.
    :vartype properties: JSON
    :ivar origin: Origin of the operation. Can be : user|system|user,system.
    :vartype origin: str
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "properties": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "properties": {"key": "properties", "type": "object"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display = None
        self.properties = None
        self.origin = None


class OperationDisplay(_serialization.Model):
    """Operation display.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Localized name of the operation for display purpose.
    :vartype operation: str
    :ivar description: Localized description of the operation for display purpose.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Localized name of the operation for display purpose.
        :paramtype operation: str
        :keyword description: Localized description of the operation for display purpose.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """Operation Collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations.
    :vartype value: list[~azure.mgmt.databox.v2019_09_01.models.Operation]
    :ivar next_link: Link for the next set of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class PackageShippingDetails(_serialization.Model):
    """Shipping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking Id of shipment.
    :vartype tracking_id: str
    :ivar tracking_url: Url where shipment can be tracked.
    :vartype tracking_url: str
    """

    _validation = {
        "carrier_name": {"readonly": True},
        "tracking_id": {"readonly": True},
        "tracking_url": {"readonly": True},
    }

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "tracking_url": {"key": "trackingUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.carrier_name = None
        self.tracking_id = None
        self.tracking_url = None


class Preferences(_serialization.Model):
    """Preferences related to the order.

    :ivar preferred_data_center_region: Preferred Data Center Region.
    :vartype preferred_data_center_region: list[str]
    :ivar transport_preferences: Preferences related to the shipment logistics of the sku.
    :vartype transport_preferences: ~azure.mgmt.databox.v2019_09_01.models.TransportPreferences
    """

    _attribute_map = {
        "preferred_data_center_region": {"key": "preferredDataCenterRegion", "type": "[str]"},
        "transport_preferences": {"key": "transportPreferences", "type": "TransportPreferences"},
    }

    def __init__(
        self,
        *,
        preferred_data_center_region: Optional[List[str]] = None,
        transport_preferences: Optional["_models.TransportPreferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword preferred_data_center_region: Preferred Data Center Region.
        :paramtype preferred_data_center_region: list[str]
        :keyword transport_preferences: Preferences related to the shipment logistics of the sku.
        :paramtype transport_preferences: ~azure.mgmt.databox.v2019_09_01.models.TransportPreferences
        """
        super().__init__(**kwargs)
        self.preferred_data_center_region = preferred_data_center_region
        self.transport_preferences = transport_preferences


class PreferencesValidationRequest(ValidationInputRequest):
    """Request to validate preference of transport and data center.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar preference: Preference requested with respect to transport type and data center.
    :vartype preference: ~azure.mgmt.databox.v2019_09_01.models.Preferences
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", and "DataBoxHeavy".
    :vartype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "preference": {"key": "preference", "type": "Preferences"},
        "device_type": {"key": "deviceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        device_type: Union[str, "_models.SkuName"],
        preference: Optional["_models.Preferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword preference: Preference requested with respect to transport type and data center.
        :paramtype preference: ~azure.mgmt.databox.v2019_09_01.models.Preferences
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", and "DataBoxHeavy".
        :paramtype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidatePreferences"
        self.preference = preference
        self.device_type = device_type


class PreferencesValidationResponseProperties(ValidationInputResponse):
    """Properties of data center and transport preference validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar status: Validation status of requested data center and transport. Known values are:
     "Valid", "Invalid", and "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidatePreferences"
        self.status = None


class RegionConfigurationRequest(_serialization.Model):
    """Request body to get the configuration for the region.

    :ivar schedule_availability_request: Request body to get the availability for scheduling
     orders.
    :vartype schedule_availability_request:
     ~azure.mgmt.databox.v2019_09_01.models.ScheduleAvailabilityRequest
    :ivar transport_availability_request: Request body to get the transport availability for given
     sku.
    :vartype transport_availability_request:
     ~azure.mgmt.databox.v2019_09_01.models.TransportAvailabilityRequest
    """

    _attribute_map = {
        "schedule_availability_request": {"key": "scheduleAvailabilityRequest", "type": "ScheduleAvailabilityRequest"},
        "transport_availability_request": {
            "key": "transportAvailabilityRequest",
            "type": "TransportAvailabilityRequest",
        },
    }

    def __init__(
        self,
        *,
        schedule_availability_request: Optional["_models.ScheduleAvailabilityRequest"] = None,
        transport_availability_request: Optional["_models.TransportAvailabilityRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule_availability_request: Request body to get the availability for scheduling
         orders.
        :paramtype schedule_availability_request:
         ~azure.mgmt.databox.v2019_09_01.models.ScheduleAvailabilityRequest
        :keyword transport_availability_request: Request body to get the transport availability for
         given sku.
        :paramtype transport_availability_request:
         ~azure.mgmt.databox.v2019_09_01.models.TransportAvailabilityRequest
        """
        super().__init__(**kwargs)
        self.schedule_availability_request = schedule_availability_request
        self.transport_availability_request = transport_availability_request


class RegionConfigurationResponse(_serialization.Model):
    """Configuration response specific to a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schedule_availability_response: Schedule availability for given sku in a region.
    :vartype schedule_availability_response:
     ~azure.mgmt.databox.v2019_09_01.models.ScheduleAvailabilityResponse
    :ivar transport_availability_response: Transport options available for given sku in a region.
    :vartype transport_availability_response:
     ~azure.mgmt.databox.v2019_09_01.models.TransportAvailabilityResponse
    """

    _validation = {
        "schedule_availability_response": {"readonly": True},
        "transport_availability_response": {"readonly": True},
    }

    _attribute_map = {
        "schedule_availability_response": {
            "key": "scheduleAvailabilityResponse",
            "type": "ScheduleAvailabilityResponse",
        },
        "transport_availability_response": {
            "key": "transportAvailabilityResponse",
            "type": "TransportAvailabilityResponse",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.schedule_availability_response = None
        self.transport_availability_response = None


class ScheduleAvailabilityResponse(_serialization.Model):
    """Schedule availability response for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar available_dates: List of dates available to schedule.
    :vartype available_dates: list[~datetime.datetime]
    """

    _validation = {
        "available_dates": {"readonly": True},
    }

    _attribute_map = {
        "available_dates": {"key": "availableDates", "type": "[iso-8601]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.available_dates = None


class ShareCredentialDetails(_serialization.Model):
    """Credential details of the shares in account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar share_name: Name of the share.
    :vartype share_name: str
    :ivar share_type: Type of the share. Known values are: "UnknownType", "HCS", "BlockBlob",
     "PageBlob", "AzureFile", and "ManagedDisk".
    :vartype share_type: str or ~azure.mgmt.databox.v2019_09_01.models.ShareDestinationFormatType
    :ivar user_name: User name for the share.
    :vartype user_name: str
    :ivar password: Password for the share.
    :vartype password: str
    :ivar supported_access_protocols: Access protocols supported on the device.
    :vartype supported_access_protocols: list[str or
     ~azure.mgmt.databox.v2019_09_01.models.AccessProtocol]
    """

    _validation = {
        "share_name": {"readonly": True},
        "share_type": {"readonly": True},
        "user_name": {"readonly": True},
        "password": {"readonly": True},
        "supported_access_protocols": {"readonly": True},
    }

    _attribute_map = {
        "share_name": {"key": "shareName", "type": "str"},
        "share_type": {"key": "shareType", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "supported_access_protocols": {"key": "supportedAccessProtocols", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.share_name = None
        self.share_type = None
        self.user_name = None
        self.password = None
        self.supported_access_protocols = None


class ShipmentPickUpRequest(_serialization.Model):
    """Shipment pick up request details.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time: Minimum date after which the pick up should commence, this must be in local
     time of pick up area. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Maximum date before which the pick up should commence, this must be in local
     time of pick up area. Required.
    :vartype end_time: ~datetime.datetime
    :ivar shipment_location: Shipment Location in the pickup place. Eg.front desk. Required.
    :vartype shipment_location: str
    """

    _validation = {
        "start_time": {"required": True},
        "end_time": {"required": True},
        "shipment_location": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "shipment_location": {"key": "shipmentLocation", "type": "str"},
    }

    def __init__(
        self, *, start_time: datetime.datetime, end_time: datetime.datetime, shipment_location: str, **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Minimum date after which the pick up should commence, this must be in
         local time of pick up area. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Maximum date before which the pick up should commence, this must be in local
         time of pick up area. Required.
        :paramtype end_time: ~datetime.datetime
        :keyword shipment_location: Shipment Location in the pickup place. Eg.front desk. Required.
        :paramtype shipment_location: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.shipment_location = shipment_location


class ShipmentPickUpResponse(_serialization.Model):
    """Shipment pick up response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confirmation_number: Confirmation number for the pick up request.
    :vartype confirmation_number: str
    :ivar ready_by_time: Time by which shipment should be ready for pick up, this is in local time
     of pick up area.
    :vartype ready_by_time: ~datetime.datetime
    """

    _validation = {
        "confirmation_number": {"readonly": True},
        "ready_by_time": {"readonly": True},
    }

    _attribute_map = {
        "confirmation_number": {"key": "confirmationNumber", "type": "str"},
        "ready_by_time": {"key": "readyByTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.confirmation_number = None
        self.ready_by_time = None


class ShippingAddress(_serialization.Model):
    """Shipping address where customer wishes to receive the device.

    All required parameters must be populated in order to send to Azure.

    :ivar street_address1: Street Address line 1. Required.
    :vartype street_address1: str
    :ivar street_address2: Street Address line 2.
    :vartype street_address2: str
    :ivar street_address3: Street Address line 3.
    :vartype street_address3: str
    :ivar city: Name of the City.
    :vartype city: str
    :ivar state_or_province: Name of the State or Province.
    :vartype state_or_province: str
    :ivar country: Name of the Country. Required.
    :vartype country: str
    :ivar postal_code: Postal code. Required.
    :vartype postal_code: str
    :ivar zip_extended_code: Extended Zip Code.
    :vartype zip_extended_code: str
    :ivar company_name: Name of the company.
    :vartype company_name: str
    :ivar address_type: Type of address. Known values are: "None", "Residential", and "Commercial".
    :vartype address_type: str or ~azure.mgmt.databox.v2019_09_01.models.AddressType
    """

    _validation = {
        "street_address1": {"required": True},
        "country": {"required": True},
        "postal_code": {"required": True},
    }

    _attribute_map = {
        "street_address1": {"key": "streetAddress1", "type": "str"},
        "street_address2": {"key": "streetAddress2", "type": "str"},
        "street_address3": {"key": "streetAddress3", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state_or_province": {"key": "stateOrProvince", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "zip_extended_code": {"key": "zipExtendedCode", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "address_type": {"key": "addressType", "type": "str"},
    }

    def __init__(
        self,
        *,
        street_address1: str,
        country: str,
        postal_code: str,
        street_address2: Optional[str] = None,
        street_address3: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        zip_extended_code: Optional[str] = None,
        company_name: Optional[str] = None,
        address_type: Union[str, "_models.AddressType"] = "None",
        **kwargs: Any
    ) -> None:
        """
        :keyword street_address1: Street Address line 1. Required.
        :paramtype street_address1: str
        :keyword street_address2: Street Address line 2.
        :paramtype street_address2: str
        :keyword street_address3: Street Address line 3.
        :paramtype street_address3: str
        :keyword city: Name of the City.
        :paramtype city: str
        :keyword state_or_province: Name of the State or Province.
        :paramtype state_or_province: str
        :keyword country: Name of the Country. Required.
        :paramtype country: str
        :keyword postal_code: Postal code. Required.
        :paramtype postal_code: str
        :keyword zip_extended_code: Extended Zip Code.
        :paramtype zip_extended_code: str
        :keyword company_name: Name of the company.
        :paramtype company_name: str
        :keyword address_type: Type of address. Known values are: "None", "Residential", and
         "Commercial".
        :paramtype address_type: str or ~azure.mgmt.databox.v2019_09_01.models.AddressType
        """
        super().__init__(**kwargs)
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.street_address3 = street_address3
        self.city = city
        self.state_or_province = state_or_province
        self.country = country
        self.postal_code = postal_code
        self.zip_extended_code = zip_extended_code
        self.company_name = company_name
        self.address_type = address_type


class Sku(_serialization.Model):
    """The Sku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The sku name. Required. Known values are: "DataBox", "DataBoxDisk", and
     "DataBoxHeavy".
    :vartype name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    :ivar display_name: The display name of the sku.
    :vartype display_name: str
    :ivar family: The sku family.
    :vartype family: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        display_name: Optional[str] = None,
        family: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. Required. Known values are: "DataBox", "DataBoxDisk", and
         "DataBoxHeavy".
        :paramtype name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
        :keyword display_name: The display name of the sku.
        :paramtype display_name: str
        :keyword family: The sku family.
        :paramtype family: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.family = family


class SkuAvailabilityValidationRequest(ValidationInputRequest):
    """Request to validate sku availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", and "DataBoxHeavy".
    :vartype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    :ivar transfer_type: Type of the transfer. Required. Default value is "ImportToAzure".
    :vartype transfer_type: str
    :ivar country: ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
    :vartype country: str
    :ivar location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype location: str
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
        "transfer_type": {"required": True, "constant": True},
        "country": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    transfer_type = "ImportToAzure"

    def __init__(
        self, *, device_type: Union[str, "_models.SkuName"], country: str, location: str, **kwargs: Any
    ) -> None:
        """
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", and "DataBoxHeavy".
        :paramtype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
        :keyword country: ISO country code. Country for hardware shipment. For codes check:
         https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
        :paramtype country: str
        :keyword location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSkuAvailability"
        self.device_type = device_type
        self.country = country
        self.location = location


class SkuAvailabilityValidationResponseProperties(ValidationInputResponse):
    """Properties of sku availability validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar status: Sku availability validation status. Known values are: "Valid", "Invalid", and
     "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSkuAvailability"
        self.status = None


class SkuCapacity(_serialization.Model):
    """Capacity of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar usable: Usable capacity in TB.
    :vartype usable: str
    :ivar maximum: Maximum capacity in TB.
    :vartype maximum: str
    """

    _validation = {
        "usable": {"readonly": True},
        "maximum": {"readonly": True},
    }

    _attribute_map = {
        "usable": {"key": "usable", "type": "str"},
        "maximum": {"key": "maximum", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.usable = None
        self.maximum = None


class SkuCost(_serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Meter id of the Sku.
    :vartype meter_id: str
    :ivar meter_type: The type of the meter.
    :vartype meter_type: str
    """

    _validation = {
        "meter_id": {"readonly": True},
        "meter_type": {"readonly": True},
    }

    _attribute_map = {
        "meter_id": {"key": "meterId", "type": "str"},
        "meter_type": {"key": "meterType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.meter_id = None
        self.meter_type = None


class SkuInformation(_serialization.Model):
    """Information of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.databox.v2019_09_01.models.Sku
    :ivar enabled: The sku is enabled or not.
    :vartype enabled: bool
    :ivar destination_to_service_location_map: The map of destination location to service location.
    :vartype destination_to_service_location_map:
     list[~azure.mgmt.databox.v2019_09_01.models.DestinationToServiceLocationMap]
    :ivar capacity: Capacity of the Sku.
    :vartype capacity: ~azure.mgmt.databox.v2019_09_01.models.SkuCapacity
    :ivar costs: Cost of the Sku.
    :vartype costs: list[~azure.mgmt.databox.v2019_09_01.models.SkuCost]
    :ivar api_versions: Api versions that support this Sku.
    :vartype api_versions: list[str]
    :ivar disabled_reason: Reason why the Sku is disabled. Known values are: "None", "Country",
     "Region", "Feature", "OfferType", and "NoSubscriptionInfo".
    :vartype disabled_reason: str or ~azure.mgmt.databox.v2019_09_01.models.SkuDisabledReason
    :ivar disabled_reason_message: Message for why the Sku is disabled.
    :vartype disabled_reason_message: str
    :ivar required_feature: Required feature to access the sku.
    :vartype required_feature: str
    """

    _validation = {
        "sku": {"readonly": True},
        "enabled": {"readonly": True},
        "destination_to_service_location_map": {"readonly": True},
        "capacity": {"readonly": True},
        "costs": {"readonly": True},
        "api_versions": {"readonly": True},
        "disabled_reason": {"readonly": True},
        "disabled_reason_message": {"readonly": True},
        "required_feature": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "enabled": {"key": "enabled", "type": "bool"},
        "destination_to_service_location_map": {
            "key": "properties.destinationToServiceLocationMap",
            "type": "[DestinationToServiceLocationMap]",
        },
        "capacity": {"key": "properties.capacity", "type": "SkuCapacity"},
        "costs": {"key": "properties.costs", "type": "[SkuCost]"},
        "api_versions": {"key": "properties.apiVersions", "type": "[str]"},
        "disabled_reason": {"key": "properties.disabledReason", "type": "str"},
        "disabled_reason_message": {"key": "properties.disabledReasonMessage", "type": "str"},
        "required_feature": {"key": "properties.requiredFeature", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sku = None
        self.enabled = None
        self.destination_to_service_location_map = None
        self.capacity = None
        self.costs = None
        self.api_versions = None
        self.disabled_reason = None
        self.disabled_reason_message = None
        self.required_feature = None


class SubscriptionIsAllowedToCreateJobValidationRequest(ValidationInputRequest):
    """Request to validate subscription permission to create jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    """

    _validation = {
        "validation_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSubscriptionIsAllowedToCreateJob"


class SubscriptionIsAllowedToCreateJobValidationResponseProperties(ValidationInputResponse):
    """Properties of subscription permission to create job validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2019_09_01.models.Error
    :ivar status: Validation status of subscription permission to create job. Known values are:
     "Valid", "Invalid", and "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSubscriptionIsAllowedToCreateJob"
        self.status = None


class TransportAvailabilityDetails(_serialization.Model):
    """Transport options availability details for given region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar shipment_type: Transport Shipment Type supported for given region. Known values are:
     "CustomerManaged" and "MicrosoftManaged".
    :vartype shipment_type: str or ~azure.mgmt.databox.v2019_09_01.models.TransportShipmentTypes
    """

    _validation = {
        "shipment_type": {"readonly": True},
    }

    _attribute_map = {
        "shipment_type": {"key": "shipmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.shipment_type = None


class TransportAvailabilityRequest(_serialization.Model):
    """Request body to get the transport availability for given sku.

    :ivar sku_name: Type of the device. Known values are: "DataBox", "DataBoxDisk", and
     "DataBoxHeavy".
    :vartype sku_name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    """

    _attribute_map = {
        "sku_name": {"key": "skuName", "type": "str"},
    }

    def __init__(self, *, sku_name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs: Any) -> None:
        """
        :keyword sku_name: Type of the device. Known values are: "DataBox", "DataBoxDisk", and
         "DataBoxHeavy".
        :paramtype sku_name: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.sku_name = sku_name


class TransportAvailabilityResponse(_serialization.Model):
    """Transport options available for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar transport_availability_details: List of transport availability details for given region.
    :vartype transport_availability_details:
     list[~azure.mgmt.databox.v2019_09_01.models.TransportAvailabilityDetails]
    """

    _validation = {
        "transport_availability_details": {"readonly": True},
    }

    _attribute_map = {
        "transport_availability_details": {
            "key": "transportAvailabilityDetails",
            "type": "[TransportAvailabilityDetails]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.transport_availability_details = None


class TransportPreferences(_serialization.Model):
    """Preferences related to the shipment logistics of the sku.

    All required parameters must be populated in order to send to Azure.

    :ivar preferred_shipment_type: Indicates Shipment Logistics type that the customer preferred.
     Required. Known values are: "CustomerManaged" and "MicrosoftManaged".
    :vartype preferred_shipment_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.TransportShipmentTypes
    """

    _validation = {
        "preferred_shipment_type": {"required": True},
    }

    _attribute_map = {
        "preferred_shipment_type": {"key": "preferredShipmentType", "type": "str"},
    }

    def __init__(self, *, preferred_shipment_type: Union[str, "_models.TransportShipmentTypes"], **kwargs: Any) -> None:
        """
        :keyword preferred_shipment_type: Indicates Shipment Logistics type that the customer
         preferred. Required. Known values are: "CustomerManaged" and "MicrosoftManaged".
        :paramtype preferred_shipment_type: str or
         ~azure.mgmt.databox.v2019_09_01.models.TransportShipmentTypes
        """
        super().__init__(**kwargs)
        self.preferred_shipment_type = preferred_shipment_type


class UnencryptedCredentials(_serialization.Model):
    """Unencrypted credentials for accessing device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: Name of the job.
    :vartype job_name: str
    :ivar job_secrets: Secrets related to this job.
    :vartype job_secrets: ~azure.mgmt.databox.v2019_09_01.models.JobSecrets
    """

    _validation = {
        "job_name": {"readonly": True},
        "job_secrets": {"readonly": True},
    }

    _attribute_map = {
        "job_name": {"key": "jobName", "type": "str"},
        "job_secrets": {"key": "jobSecrets", "type": "JobSecrets"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_name = None
        self.job_secrets = None


class UnencryptedCredentialsList(_serialization.Model):
    """List of unencrypted credentials for accessing device.

    :ivar value: List of unencrypted credentials.
    :vartype value: list[~azure.mgmt.databox.v2019_09_01.models.UnencryptedCredentials]
    :ivar next_link: Link for the next set of unencrypted credentials.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[UnencryptedCredentials]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.UnencryptedCredentials"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of unencrypted credentials.
        :paramtype value: list[~azure.mgmt.databox.v2019_09_01.models.UnencryptedCredentials]
        :keyword next_link: Link for the next set of unencrypted credentials.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateJobDetails(_serialization.Model):
    """Job details for update.

    :ivar contact_details: Contact details for notification and shipping.
    :vartype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
    """

    _attribute_map = {
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
    }

    def __init__(
        self,
        *,
        contact_details: Optional["_models.ContactDetails"] = None,
        shipping_address: Optional["_models.ShippingAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping.
        :paramtype contact_details: ~azure.mgmt.databox.v2019_09_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
        """
        super().__init__(**kwargs)
        self.contact_details = contact_details
        self.shipping_address = shipping_address


class ValidateAddress(ValidationInputRequest):
    """The requirements to validate customer address where the device needs to be shipped.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateDataDestinationDetails",
     "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences", "ValidateCreateOrderLimit",
     and "ValidateSkuAvailability".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2019_09_01.models.ValidationInputDiscriminator
    :ivar shipping_address: Shipping address of the customer. Required.
    :vartype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", and "DataBoxHeavy".
    :vartype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
    :ivar transport_preferences: Preferences related to the shipment logistics of the sku.
    :vartype transport_preferences: ~azure.mgmt.databox.v2019_09_01.models.TransportPreferences
    """

    _validation = {
        "validation_type": {"required": True},
        "shipping_address": {"required": True},
        "device_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "device_type": {"key": "deviceType", "type": "str"},
        "transport_preferences": {"key": "transportPreferences", "type": "TransportPreferences"},
    }

    def __init__(
        self,
        *,
        shipping_address: "_models.ShippingAddress",
        device_type: Union[str, "_models.SkuName"],
        transport_preferences: Optional["_models.TransportPreferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword shipping_address: Shipping address of the customer. Required.
        :paramtype shipping_address: ~azure.mgmt.databox.v2019_09_01.models.ShippingAddress
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", and "DataBoxHeavy".
        :paramtype device_type: str or ~azure.mgmt.databox.v2019_09_01.models.SkuName
        :keyword transport_preferences: Preferences related to the shipment logistics of the sku.
        :paramtype transport_preferences: ~azure.mgmt.databox.v2019_09_01.models.TransportPreferences
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateAddress"
        self.shipping_address = shipping_address
        self.device_type = device_type
        self.transport_preferences = transport_preferences


class ValidationResponse(_serialization.Model):
    """Response of pre job creation validations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Overall validation status. Known values are: "AllValidToProceed",
     "InputsRevisitRequired", and "CertainInputValidationsSkipped".
    :vartype status: str or ~azure.mgmt.databox.v2019_09_01.models.OverallValidationStatus
    :ivar individual_response_details: List of response details contain validationType and its
     response as key and value respectively.
    :vartype individual_response_details:
     list[~azure.mgmt.databox.v2019_09_01.models.ValidationInputResponse]
    """

    _validation = {
        "status": {"readonly": True},
        "individual_response_details": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "properties.status", "type": "str"},
        "individual_response_details": {
            "key": "properties.individualResponseDetails",
            "type": "[ValidationInputResponse]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.individual_response_details = None
