# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, Iterable, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._model_base import AzureJSONEncoder, _deserialize
from .._serialization import Serializer
from .._vendor import ContentSafetyClientMixinABC, _format_url_section

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_content_safety_analyze_text_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text:analyze"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_analyze_image_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/image:analyze"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_get_text_blocklist_request(blocklist_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text/blocklists/{blocklistName}"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_create_or_update_text_blocklist_request(blocklist_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text/blocklists/{blocklistName}"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_delete_text_blocklist_request(blocklist_name: str, **kwargs: Any) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    # Construct URL
    _url = "/text/blocklists/{blocklistName}"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_content_safety_list_text_blocklists_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text/blocklists"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_add_block_items_request(blocklist_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text/blocklists/{blocklistName}:addBlockItems"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_remove_block_items_request(blocklist_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    # Construct URL
    _url = "/text/blocklists/{blocklistName}:removeBlockItems"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_get_text_blocklist_item_request(
    blocklist_name: str, block_item_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text/blocklists/{blocklistName}/blockItems/{blockItemId}"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
        "blockItemId": _SERIALIZER.url("block_item_id", block_item_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_content_safety_list_text_blocklist_items_request(
    blocklist_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-04-30-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/text/blocklists/{blocklistName}/blockItems"
    path_format_arguments = {
        "blocklistName": _SERIALIZER.url("blocklist_name", blocklist_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class ContentSafetyClientOperationsMixin(ContentSafetyClientMixinABC):
    @overload
    def analyze_text(
        self, body: _models.AnalyzeTextOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A sync API for harmful content analysis for text. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The request of text analysis. Required.
        :type body: ~azure.ai.contentsafety.models.AnalyzeTextOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def analyze_text(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A sync API for harmful content analysis for text. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The request of text analysis. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def analyze_text(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A sync API for harmful content analysis for text. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The request of text analysis. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def analyze_text(
        self, body: Union[_models.AnalyzeTextOptions, JSON, IO], **kwargs: Any
    ) -> _models.AnalyzeTextResult:
        """Analyze Text.

        A sync API for harmful content analysis for text. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The request of text analysis. Is one of the following types: AnalyzeTextOptions,
         JSON, IO Required.
        :type body: ~azure.ai.contentsafety.models.AnalyzeTextOptions or JSON or IO
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeTextResult. The AnalyzeTextResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AnalyzeTextResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=AzureJSONEncoder)  # type: ignore

        request = build_content_safety_analyze_text_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AnalyzeTextResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def analyze_image(
        self, body: _models.AnalyzeImageOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A sync API for harmful content analysis for image. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The analysis request of the image. Required.
        :type body: ~azure.ai.contentsafety.models.AnalyzeImageOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def analyze_image(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A sync API for harmful content analysis for image. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The analysis request of the image. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def analyze_image(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A sync API for harmful content analysis for image. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The analysis request of the image. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def analyze_image(
        self, body: Union[_models.AnalyzeImageOptions, JSON, IO], **kwargs: Any
    ) -> _models.AnalyzeImageResult:
        """Analyze Image.

        A sync API for harmful content analysis for image. Currently, we support four categories: Hate,
        SelfHarm, Sexual, Violence.

        :param body: The analysis request of the image. Is one of the following types:
         AnalyzeImageOptions, JSON, IO Required.
        :type body: ~azure.ai.contentsafety.models.AnalyzeImageOptions or JSON or IO
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AnalyzeImageResult. The AnalyzeImageResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AnalyzeImageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AnalyzeImageResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=AzureJSONEncoder)  # type: ignore

        request = build_content_safety_analyze_image_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AnalyzeImageResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_text_blocklist(self, blocklist_name: str, **kwargs: Any) -> _models.TextBlocklist:
        """Get Text Blocklist By blocklistName.

        Returns text blocklist details.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TextBlocklist] = kwargs.pop("cls", None)

        request = build_content_safety_get_text_blocklist_request(
            blocklist_name=blocklist_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TextBlocklist, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def create_or_update_text_blocklist(
        self,
        blocklist_name: str,
        resource: _models.TextBlocklist,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist, if blocklistName does not exist, create a new blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.ai.contentsafety.models.TextBlocklist
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_update_text_blocklist(
        self, blocklist_name: str, resource: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist, if blocklistName does not exist, create a new blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_update_text_blocklist(
        self, blocklist_name: str, resource: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist, if blocklistName does not exist, create a new blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param resource: The resource instance. Required.
        :type resource: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_update_text_blocklist(
        self, blocklist_name: str, resource: Union[_models.TextBlocklist, JSON, IO], **kwargs: Any
    ) -> _models.TextBlocklist:
        """Create Or Update Text Blocklist.

        Updates a text blocklist, if blocklistName does not exist, create a new blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param resource: The resource instance. Is one of the following types: TextBlocklist, JSON, IO
         Required.
        :type resource: ~azure.ai.contentsafety.models.TextBlocklist or JSON or IO
        :keyword content_type: This request has a JSON Merge Patch body. Default value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlocklist. The TextBlocklist is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlocklist
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TextBlocklist] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=AzureJSONEncoder)  # type: ignore

        request = build_content_safety_create_or_update_text_blocklist_request(
            blocklist_name=blocklist_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.TextBlocklist, response.json())

        if response.status_code == 201:
            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.TextBlocklist, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_text_blocklist(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, **kwargs: Any
    ) -> None:
        """Delete Text Blocklist By blocklistName.

        Deletes a text blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_content_safety_delete_text_blocklist_request(
            blocklist_name=blocklist_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_text_blocklists(self, **kwargs: Any) -> Iterable["_models.TextBlocklist"]:
        """Get All Text Blocklists.

        Get all text blocklists details.

        :return: An iterator like instance of TextBlocklist
        :rtype: ~azure.core.paging.ItemPaged[~azure.ai.contentsafety.models.TextBlocklist]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TextBlocklist]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_content_safety_list_text_blocklists_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TextBlocklist], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @overload
    def add_block_items(
        self,
        blocklist_name: str,
        body: _models.AddBlockItemsOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddBlockItemsResult:
        """Add BlockItems To Text Blocklist.

        Add blockItems to a text blocklist. You can add at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Required.
        :type body: ~azure.ai.contentsafety.models.AddBlockItemsOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddBlockItemsResult. The AddBlockItemsResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddBlockItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def add_block_items(
        self, blocklist_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AddBlockItemsResult:
        """Add BlockItems To Text Blocklist.

        Add blockItems to a text blocklist. You can add at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddBlockItemsResult. The AddBlockItemsResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddBlockItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def add_block_items(
        self, blocklist_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AddBlockItemsResult:
        """Add BlockItems To Text Blocklist.

        Add blockItems to a text blocklist. You can add at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddBlockItemsResult. The AddBlockItemsResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddBlockItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def add_block_items(
        self, blocklist_name: str, body: Union[_models.AddBlockItemsOptions, JSON, IO], **kwargs: Any
    ) -> _models.AddBlockItemsResult:
        """Add BlockItems To Text Blocklist.

        Add blockItems to a text blocklist. You can add at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Is one of the following types: AddBlockItemsOptions, JSON, IO Required.
        :type body: ~azure.ai.contentsafety.models.AddBlockItemsOptions or JSON or IO
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: AddBlockItemsResult. The AddBlockItemsResult is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.AddBlockItemsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddBlockItemsResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=AzureJSONEncoder)  # type: ignore

        request = build_content_safety_add_block_items_request(
            blocklist_name=blocklist_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AddBlockItemsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def remove_block_items(  # pylint: disable=inconsistent-return-statements
        self,
        blocklist_name: str,
        body: _models.RemoveBlockItemsOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Remove BlockItems From Text Blocklist.

        Remove blockItems from a text blocklist. You can remove at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Required.
        :type body: ~azure.ai.contentsafety.models.RemoveBlockItemsOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def remove_block_items(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove BlockItems From Text Blocklist.

        Remove blockItems from a text blocklist. You can remove at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def remove_block_items(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove BlockItems From Text Blocklist.

        Remove blockItems from a text blocklist. You can remove at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def remove_block_items(  # pylint: disable=inconsistent-return-statements
        self, blocklist_name: str, body: Union[_models.RemoveBlockItemsOptions, JSON, IO], **kwargs: Any
    ) -> None:
        """Remove BlockItems From Text Blocklist.

        Remove blockItems from a text blocklist. You can remove at most 100 BlockItems in one request.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param body: Is one of the following types: RemoveBlockItemsOptions, JSON, IO Required.
        :type body: ~azure.ai.contentsafety.models.RemoveBlockItemsOptions or JSON or IO
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=AzureJSONEncoder)  # type: ignore

        request = build_content_safety_remove_block_items_request(
            blocklist_name=blocklist_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def get_text_blocklist_item(self, blocklist_name: str, block_item_id: str, **kwargs: Any) -> _models.TextBlockItem:
        """Get BlockItem By blocklistName And blockItemId.

        Get blockItem By blockItemId from a text blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :param block_item_id: Block Item Id. It will be uuid. Required.
        :type block_item_id: str
        :keyword bool stream: Whether to stream the response of this operation. Defaults to False. You
         will have to context manage the returned stream.
        :return: TextBlockItem. The TextBlockItem is compatible with MutableMapping
        :rtype: ~azure.ai.contentsafety.models.TextBlockItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TextBlockItem] = kwargs.pop("cls", None)

        request = build_content_safety_get_text_blocklist_item_request(
            blocklist_name=blocklist_name,
            block_item_id=block_item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TextBlockItem, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_text_blocklist_items(
        self, blocklist_name: str, *, top: Optional[int] = None, skip: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.TextBlockItem"]:
        """Get All BlockItems By blocklistName.

        Get all blockItems in a text blocklist.

        :param blocklist_name: Text blocklist name. Required.
        :type blocklist_name: str
        :keyword top: The number of result items to return. Default value is None.
        :paramtype top: int
        :keyword skip: The number of result items to skip. Default value is None.
        :paramtype skip: int
        :return: An iterator like instance of TextBlockItem
        :rtype: ~azure.core.paging.ItemPaged[~azure.ai.contentsafety.models.TextBlockItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TextBlockItem]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_content_safety_list_text_blocklist_items_request(
                    blocklist_name=blocklist_name,
                    top=top,
                    skip=skip,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TextBlockItem], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
