# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class BackupScheduleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Backup schedule type.
    """

    MANUAL = "Manual"
    AUTOMATED = "Automated"

class ClusterConfiguration(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Cluster type.
    """

    DOMAINFUL = "Domainful"

class ClusterManagerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of
    the group and the OS type.
    """

    WSFC = "WSFC"

class ConnectivityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """SQL Server connectivity option.
    """

    LOCAL = "LOCAL"
    PRIVATE = "PRIVATE"
    PUBLIC = "PUBLIC"

class DayOfWeek(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Day of week to apply the patch on.
    """

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"

class DiskConfigurationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Disk configuration to apply to SQL Server.
    """

    NEW = "NEW"
    EXTEND = "EXTEND"
    ADD = "ADD"

class FullBackupFrequencyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Frequency of full backups. In both cases, full backups begin during the next scheduled time
    window.
    """

    DAILY = "Daily"
    WEEKLY = "Weekly"

class IdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an
    Azure Active Directory principal for the resource.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"

class OperationOrigin(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation.
    """

    USER = "user"
    SYSTEM = "system"

class ScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Scale type.
    """

    HA = "HA"

class SqlImageSku(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """SQL Server edition type.
    """

    DEVELOPER = "Developer"
    EXPRESS = "Express"
    STANDARD = "Standard"
    ENTERPRISE = "Enterprise"
    WEB = "Web"

class SqlManagementMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """SQL Server Management type.
    """

    FULL = "Full"
    LIGHT_WEIGHT = "LightWeight"
    NO_AGENT = "NoAgent"

class SqlServerLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """SQL Server license type.
    """

    PAYG = "PAYG"
    AHUB = "AHUB"
    DR = "DR"

class SqlVmGroupImageSku(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """SQL image sku.
    """

    DEVELOPER = "Developer"
    ENTERPRISE = "Enterprise"

class SqlWorkloadType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """SQL Server workload type.
    """

    GENERAL = "GENERAL"
    OLTP = "OLTP"
    DW = "DW"

class StorageWorkloadType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Storage workload type.
    """

    GENERAL = "GENERAL"
    OLTP = "OLTP"
    DW = "DW"
