# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class AppResource(ProxyResource):
    """App resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the App resource.
    :type properties: ~azure.mgmt.appplatform.v2019_05_01_preview.models.AppResourceProperties
    :param identity: The Managed Identity type of the app resource.
    :type identity: ~azure.mgmt.appplatform.v2019_05_01_preview.models.ManagedIdentityProperties
    :param location: The GEO location of the application, always the same with its parent resource.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AppResourceProperties'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentityProperties'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.identity = kwargs.get('identity', None)
        self.location = kwargs.get('location', None)


class AppResourceCollection(msrest.serialization.Model):
    """Object that includes an array of App resources and a possible link for next set.

    :param value: Collection of App resources.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.AppResource]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AppResourceProperties(msrest.serialization.Model):
    """App resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param public: Indicates whether the App exposes public endpoint.
    :type public: bool
    :ivar url: URL of the App.
    :vartype url: str
    :ivar provisioning_state: Provisioning state of the App. Possible values include: "Succeeded",
     "Failed", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.AppResourceProvisioningState
    :param active_deployment_name: Name of the active deployment of the App.
    :type active_deployment_name: str
    :param fqdn: Fully qualified dns Name.
    :type fqdn: str
    :param https_only: Indicate if only https is allowed.
    :type https_only: bool
    :ivar created_time: Date time when the resource is created.
    :vartype created_time: ~datetime.datetime
    :param temporary_disk: Temporary disk settings.
    :type temporary_disk: ~azure.mgmt.appplatform.v2019_05_01_preview.models.TemporaryDisk
    :param persistent_disk: Persistent disk settings.
    :type persistent_disk: ~azure.mgmt.appplatform.v2019_05_01_preview.models.PersistentDisk
    """

    _validation = {
        'url': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'public': {'key': 'public', 'type': 'bool'},
        'url': {'key': 'url', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'active_deployment_name': {'key': 'activeDeploymentName', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'https_only': {'key': 'httpsOnly', 'type': 'bool'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'temporary_disk': {'key': 'temporaryDisk', 'type': 'TemporaryDisk'},
        'persistent_disk': {'key': 'persistentDisk', 'type': 'PersistentDisk'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppResourceProperties, self).__init__(**kwargs)
        self.public = kwargs.get('public', None)
        self.url = None
        self.provisioning_state = None
        self.active_deployment_name = kwargs.get('active_deployment_name', None)
        self.fqdn = kwargs.get('fqdn', None)
        self.https_only = kwargs.get('https_only', False)
        self.created_time = None
        self.temporary_disk = kwargs.get('temporary_disk', None)
        self.persistent_disk = kwargs.get('persistent_disk', None)


class AvailableOperations(msrest.serialization.Model):
    """Available operations of the service.

    :param value: Collection of available operation details.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.OperationDetail]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableOperations, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AvailableRuntimeVersions(msrest.serialization.Model):
    """AvailableRuntimeVersions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of all supported runtime versions.
    :vartype value:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.SupportedRuntimeVersion]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SupportedRuntimeVersion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableRuntimeVersions, self).__init__(**kwargs)
        self.value = None


class BindingResource(ProxyResource):
    """Binding resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the Binding resource.
    :type properties: ~azure.mgmt.appplatform.v2019_05_01_preview.models.BindingResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BindingResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BindingResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BindingResourceCollection(msrest.serialization.Model):
    """Object that includes an array of Binding resources and a possible link for next set.

    :param value: Collection of Binding resources.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.BindingResource]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BindingResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BindingResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class BindingResourceProperties(msrest.serialization.Model):
    """Binding resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_name: The name of the bound resource.
    :vartype resource_name: str
    :ivar resource_type: The standard Azure resource type of the bound resource.
    :vartype resource_type: str
    :param resource_id: The Azure resource id of the bound resource.
    :type resource_id: str
    :param key: The key of the bound resource.
    :type key: str
    :param binding_parameters: Binding parameters of the Binding resource.
    :type binding_parameters: dict[str, any]
    :ivar generated_properties: The generated Spring Boot property file for this binding. The
     secret will be deducted.
    :vartype generated_properties: str
    :ivar created_at: Creation time of the Binding resource.
    :vartype created_at: str
    :ivar updated_at: Update time of the Binding resource.
    :vartype updated_at: str
    """

    _validation = {
        'resource_name': {'readonly': True},
        'resource_type': {'readonly': True},
        'generated_properties': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'binding_parameters': {'key': 'bindingParameters', 'type': '{object}'},
        'generated_properties': {'key': 'generatedProperties', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'str'},
        'updated_at': {'key': 'updatedAt', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BindingResourceProperties, self).__init__(**kwargs)
        self.resource_name = None
        self.resource_type = None
        self.resource_id = kwargs.get('resource_id', None)
        self.key = kwargs.get('key', None)
        self.binding_parameters = kwargs.get('binding_parameters', None)
        self.generated_properties = None
        self.created_at = None
        self.updated_at = None


class CertificateProperties(msrest.serialization.Model):
    """Certificate resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar thumbprint: The thumbprint of certificate.
    :vartype thumbprint: str
    :param vault_uri: Required. The vault uri of user key vault.
    :type vault_uri: str
    :param key_vault_cert_name: Required. The certificate name of key vault.
    :type key_vault_cert_name: str
    :param cert_version: The certificate version of key vault.
    :type cert_version: str
    :ivar issuer: The issuer of certificate.
    :vartype issuer: str
    :ivar issued_date: The issue date of certificate.
    :vartype issued_date: str
    :ivar expiration_date: The expiration date of certificate.
    :vartype expiration_date: str
    :ivar activate_date: The activate date of certificate.
    :vartype activate_date: str
    :ivar subject_name: The subject name of certificate.
    :vartype subject_name: str
    :ivar dns_names: The domain list of certificate.
    :vartype dns_names: list[str]
    """

    _validation = {
        'thumbprint': {'readonly': True},
        'vault_uri': {'required': True},
        'key_vault_cert_name': {'required': True},
        'issuer': {'readonly': True},
        'issued_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'activate_date': {'readonly': True},
        'subject_name': {'readonly': True},
        'dns_names': {'readonly': True},
    }

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'key_vault_cert_name': {'key': 'keyVaultCertName', 'type': 'str'},
        'cert_version': {'key': 'certVersion', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'issued_date': {'key': 'issuedDate', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'activate_date': {'key': 'activateDate', 'type': 'str'},
        'subject_name': {'key': 'subjectName', 'type': 'str'},
        'dns_names': {'key': 'dnsNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateProperties, self).__init__(**kwargs)
        self.thumbprint = None
        self.vault_uri = kwargs['vault_uri']
        self.key_vault_cert_name = kwargs['key_vault_cert_name']
        self.cert_version = kwargs.get('cert_version', None)
        self.issuer = None
        self.issued_date = None
        self.expiration_date = None
        self.activate_date = None
        self.subject_name = None
        self.dns_names = None


class CertificateResource(ProxyResource):
    """Certificate resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the certificate resource payload.
    :type properties: ~azure.mgmt.appplatform.v2019_05_01_preview.models.CertificateProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class CertificateResourceCollection(msrest.serialization.Model):
    """Collection compose of certificate resources list and a possible link for next page.

    :param value: The certificate resources list.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.CertificateResource]
    :param next_link: The link to next page of certificate list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ClusterResourceProperties(msrest.serialization.Model):
    """Service properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the Service. Possible values include:
     "Creating", "Updating", "Deleting", "Deleted", "Succeeded", "Failed", "Moving", "Moved",
     "MoveFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.ProvisioningState
    :param config_server_properties: Config server git properties of the Service.
    :type config_server_properties:
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.ConfigServerProperties
    :param trace: Trace properties of the Service.
    :type trace: ~azure.mgmt.appplatform.v2019_05_01_preview.models.TraceProperties
    :param network_profile: Network profile of the Service.
    :type network_profile: ~azure.mgmt.appplatform.v2019_05_01_preview.models.NetworkProfile
    :ivar version: Version of the Service.
    :vartype version: int
    :ivar service_id: ServiceInstanceEntity GUID which uniquely identifies a created resource.
    :vartype service_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'version': {'readonly': True},
        'service_id': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'config_server_properties': {'key': 'configServerProperties', 'type': 'ConfigServerProperties'},
        'trace': {'key': 'trace', 'type': 'TraceProperties'},
        'network_profile': {'key': 'networkProfile', 'type': 'NetworkProfile'},
        'version': {'key': 'version', 'type': 'int'},
        'service_id': {'key': 'serviceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterResourceProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.config_server_properties = kwargs.get('config_server_properties', None)
        self.trace = kwargs.get('trace', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.version = None
        self.service_id = None


class ConfigServerGitProperty(msrest.serialization.Model):
    """Property of git.

    All required parameters must be populated in order to send to Azure.

    :param repositories: Repositories of git.
    :type repositories:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.GitPatternRepository]
    :param uri: Required. URI of the repository.
    :type uri: str
    :param label: Label of the repository.
    :type label: str
    :param search_paths: Searching path of the repository.
    :type search_paths: list[str]
    :param username: Username of git repository basic auth.
    :type username: str
    :param password: Password of git repository basic auth.
    :type password: str
    :param host_key: Public sshKey of git repository.
    :type host_key: str
    :param host_key_algorithm: SshKey algorithm of git repository.
    :type host_key_algorithm: str
    :param private_key: Private sshKey algorithm of git repository.
    :type private_key: str
    :param strict_host_key_checking: Strict host key checking or not.
    :type strict_host_key_checking: bool
    """

    _validation = {
        'uri': {'required': True},
    }

    _attribute_map = {
        'repositories': {'key': 'repositories', 'type': '[GitPatternRepository]'},
        'uri': {'key': 'uri', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'search_paths': {'key': 'searchPaths', 'type': '[str]'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'host_key': {'key': 'hostKey', 'type': 'str'},
        'host_key_algorithm': {'key': 'hostKeyAlgorithm', 'type': 'str'},
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'strict_host_key_checking': {'key': 'strictHostKeyChecking', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigServerGitProperty, self).__init__(**kwargs)
        self.repositories = kwargs.get('repositories', None)
        self.uri = kwargs['uri']
        self.label = kwargs.get('label', None)
        self.search_paths = kwargs.get('search_paths', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.host_key = kwargs.get('host_key', None)
        self.host_key_algorithm = kwargs.get('host_key_algorithm', None)
        self.private_key = kwargs.get('private_key', None)
        self.strict_host_key_checking = kwargs.get('strict_host_key_checking', None)


class ConfigServerProperties(msrest.serialization.Model):
    """Config server git properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: State of the config server. Possible values include: "NotAvailable", "Deleted",
     "Failed", "Succeeded", "Updating".
    :vartype state: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.ConfigServerState
    :param error: Error when apply config server settings.
    :type error: ~azure.mgmt.appplatform.v2019_05_01_preview.models.Error
    :param config_server: Settings of config server.
    :type config_server: ~azure.mgmt.appplatform.v2019_05_01_preview.models.ConfigServerSettings
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'config_server': {'key': 'configServer', 'type': 'ConfigServerSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigServerProperties, self).__init__(**kwargs)
        self.state = None
        self.error = kwargs.get('error', None)
        self.config_server = kwargs.get('config_server', None)


class ConfigServerSettings(msrest.serialization.Model):
    """The settings of config server.

    :param git_property: Property of git environment.
    :type git_property: ~azure.mgmt.appplatform.v2019_05_01_preview.models.ConfigServerGitProperty
    """

    _attribute_map = {
        'git_property': {'key': 'gitProperty', 'type': 'ConfigServerGitProperty'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigServerSettings, self).__init__(**kwargs)
        self.git_property = kwargs.get('git_property', None)


class CustomDomainProperties(msrest.serialization.Model):
    """Custom domain of app resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param thumbprint: The thumbprint of bound certificate.
    :type thumbprint: str
    :ivar app_name: The app name of domain.
    :vartype app_name: str
    :param cert_name: The bound certificate name of domain.
    :type cert_name: str
    """

    _validation = {
        'app_name': {'readonly': True},
    }

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'app_name': {'key': 'appName', 'type': 'str'},
        'cert_name': {'key': 'certName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDomainProperties, self).__init__(**kwargs)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.app_name = None
        self.cert_name = kwargs.get('cert_name', None)


class CustomDomainResource(ProxyResource):
    """Custom domain resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the custom domain resource.
    :type properties: ~azure.mgmt.appplatform.v2019_05_01_preview.models.CustomDomainProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CustomDomainProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDomainResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class CustomDomainResourceCollection(msrest.serialization.Model):
    """Collection compose of a custom domain resources list and a possible link for next page.

    :param value: The custom domain resources list.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.CustomDomainResource]
    :param next_link: The link to next page of custom domain list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CustomDomainResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDomainResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class CustomDomainValidatePayload(msrest.serialization.Model):
    """Custom domain validate payload.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name to be validated.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDomainValidatePayload, self).__init__(**kwargs)
        self.name = kwargs['name']


class CustomDomainValidateResult(msrest.serialization.Model):
    """Validation result for custom domain.

    :param is_valid: Indicates if domain name is valid.
    :type is_valid: bool
    :param message: Message of why domain name is invalid.
    :type message: str
    """

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDomainValidateResult, self).__init__(**kwargs)
        self.is_valid = kwargs.get('is_valid', None)
        self.message = kwargs.get('message', None)


class DeploymentInstance(msrest.serialization.Model):
    """Deployment instance payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the deployment instance.
    :vartype name: str
    :ivar status: Status of the deployment instance.
    :vartype status: str
    :ivar reason: Failed reason of the deployment instance.
    :vartype reason: str
    :ivar discovery_status: Discovery status of the deployment instance.
    :vartype discovery_status: str
    :ivar start_time: Start time of the deployment instance.
    :vartype start_time: str
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'reason': {'readonly': True},
        'discovery_status': {'readonly': True},
        'start_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'discovery_status': {'key': 'discoveryStatus', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentInstance, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = None
        self.discovery_status = None
        self.start_time = None


class DeploymentResource(ProxyResource):
    """Deployment resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param properties: Properties of the Deployment resource.
    :type properties:
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.DeploymentResourceProperties
    :param sku: Sku of the Deployment resource.
    :type sku: ~azure.mgmt.appplatform.v2019_05_01_preview.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentResourceProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)


class DeploymentResourceCollection(msrest.serialization.Model):
    """Object that includes an array of App resources and a possible link for next set.

    :param value: Collection of Deployment resources.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.DeploymentResource]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DeploymentResourceProperties(msrest.serialization.Model):
    """Deployment resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param source: Uploaded source information of the deployment.
    :type source: ~azure.mgmt.appplatform.v2019_05_01_preview.models.UserSourceInfo
    :ivar app_name: App name of the deployment.
    :vartype app_name: str
    :param deployment_settings: Deployment settings of the Deployment.
    :type deployment_settings:
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.DeploymentSettings
    :ivar provisioning_state: Provisioning state of the Deployment. Possible values include:
     "Creating", "Updating", "Succeeded", "Failed", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.DeploymentResourceProvisioningState
    :ivar status: Status of the Deployment. Possible values include: "Unknown", "Stopped",
     "Running", "Failed", "Allocating", "Upgrading", "Compiling".
    :vartype status: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.DeploymentResourceStatus
    :ivar active: Indicates whether the Deployment is active.
    :vartype active: bool
    :ivar created_time: Date time when the resource is created.
    :vartype created_time: ~datetime.datetime
    :ivar instances: Collection of instances belong to the Deployment.
    :vartype instances: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.DeploymentInstance]
    """

    _validation = {
        'app_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'active': {'readonly': True},
        'created_time': {'readonly': True},
        'instances': {'readonly': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'UserSourceInfo'},
        'app_name': {'key': 'appName', 'type': 'str'},
        'deployment_settings': {'key': 'deploymentSettings', 'type': 'DeploymentSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'active': {'key': 'active', 'type': 'bool'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'instances': {'key': 'instances', 'type': '[DeploymentInstance]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentResourceProperties, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.app_name = None
        self.deployment_settings = kwargs.get('deployment_settings', None)
        self.provisioning_state = None
        self.status = None
        self.active = None
        self.created_time = None
        self.instances = None


class DeploymentSettings(msrest.serialization.Model):
    """Deployment settings payload.

    :param cpu: Required CPU, basic tier should be 1, standard tier should be in range (1, 4).
    :type cpu: int
    :param memory_in_gb: Required Memory size in GB, basic tier should be in range (1, 2), standard
     tier should be in range (1, 8).
    :type memory_in_gb: int
    :param jvm_options: JVM parameter.
    :type jvm_options: str
    :param net_core_main_entry_path: The path to the .NET executable relative to zip root.
    :type net_core_main_entry_path: str
    :param instance_count: Instance count, basic tier should be in range (1, 25), standard tier
     should be in range (1, 500).
    :type instance_count: int
    :param environment_variables: Collection of environment variables.
    :type environment_variables: dict[str, str]
    :param runtime_version: Runtime version. Possible values include: "Java_8", "Java_11",
     "NetCore_31". Default value: "Java_8".
    :type runtime_version: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.RuntimeVersion
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'int'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'int'},
        'jvm_options': {'key': 'jvmOptions', 'type': 'str'},
        'net_core_main_entry_path': {'key': 'netCoreMainEntryPath', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentSettings, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', 1)
        self.memory_in_gb = kwargs.get('memory_in_gb', 1)
        self.jvm_options = kwargs.get('jvm_options', None)
        self.net_core_main_entry_path = kwargs.get('net_core_main_entry_path', None)
        self.instance_count = kwargs.get('instance_count', 1)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.runtime_version = kwargs.get('runtime_version', "Java_8")


class Error(msrest.serialization.Model):
    """The error code compose of code and message.

    :param code: The code of error.
    :type code: str
    :param message: The message of error.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class GitPatternRepository(msrest.serialization.Model):
    """Git repository property payload.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the repository.
    :type name: str
    :param pattern: Collection of pattern of the repository.
    :type pattern: list[str]
    :param uri: Required. URI of the repository.
    :type uri: str
    :param label: Label of the repository.
    :type label: str
    :param search_paths: Searching path of the repository.
    :type search_paths: list[str]
    :param username: Username of git repository basic auth.
    :type username: str
    :param password: Password of git repository basic auth.
    :type password: str
    :param host_key: Public sshKey of git repository.
    :type host_key: str
    :param host_key_algorithm: SshKey algorithm of git repository.
    :type host_key_algorithm: str
    :param private_key: Private sshKey algorithm of git repository.
    :type private_key: str
    :param strict_host_key_checking: Strict host key checking or not.
    :type strict_host_key_checking: bool
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': '[str]'},
        'uri': {'key': 'uri', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'search_paths': {'key': 'searchPaths', 'type': '[str]'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'host_key': {'key': 'hostKey', 'type': 'str'},
        'host_key_algorithm': {'key': 'hostKeyAlgorithm', 'type': 'str'},
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'strict_host_key_checking': {'key': 'strictHostKeyChecking', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GitPatternRepository, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.pattern = kwargs.get('pattern', None)
        self.uri = kwargs['uri']
        self.label = kwargs.get('label', None)
        self.search_paths = kwargs.get('search_paths', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.host_key = kwargs.get('host_key', None)
        self.host_key_algorithm = kwargs.get('host_key_algorithm', None)
        self.private_key = kwargs.get('private_key', None)
        self.strict_host_key_checking = kwargs.get('strict_host_key_checking', None)


class LogFileUrlResponse(msrest.serialization.Model):
    """Log file URL payload.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. URL of the log file.
    :type url: str
    """

    _validation = {
        'url': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogFileUrlResponse, self).__init__(**kwargs)
        self.url = kwargs['url']


class LogSpecification(msrest.serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :param name: Name of the log.
    :type name: str
    :param display_name: Localized friendly display name of the log.
    :type display_name: str
    :param blob_duration: Blob duration of the log.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class ManagedIdentityProperties(msrest.serialization.Model):
    """Managed identity properties retrieved from ARM request headers.

    :param type:  Possible values include: "None", "SystemAssigned", "UserAssigned",
     "SystemAssigned,UserAssigned".
    :type type: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.ManagedIdentityType
    :param principal_id:
    :type principal_id: str
    :param tenant_id:
    :type tenant_id: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedIdentityProperties, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class MetricDimension(msrest.serialization.Model):
    """Specifications of the Dimension of metrics.

    :param name: Name of the dimension.
    :type name: str
    :param display_name: Localized friendly display name of the dimension.
    :type display_name: str
    :param to_be_exported_for_shoebox: Whether this dimension should be included for the Shoebox
     export scenario.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class MetricSpecification(msrest.serialization.Model):
    """Specifications of the Metrics for Azure Monitoring.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Localized friendly display name of the metric.
    :type display_name: str
    :param display_description: Localized friendly description of the metric.
    :type display_description: str
    :param unit: Unit that makes sense for the metric.
    :type unit: str
    :param category: Name of the metric category that the metric belongs to. A metric can only
     belong to a single category.
    :type category: str
    :param aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :type aggregation_type: str
    :param supported_aggregation_types: Supported aggregation types.
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: Supported time grain types.
    :type supported_time_grain_types: list[str]
    :param fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
    :type fill_gap_with_zero: bool
    :param dimensions: Dimensions of the metric.
    :type dimensions: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.MetricDimension]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.category = kwargs.get('category', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.dimensions = kwargs.get('dimensions', None)


class NameAvailability(msrest.serialization.Model):
    """Name availability result payload.

    :param name_available: Indicates whether the name is available.
    :type name_available: bool
    :param reason: Reason why the name is not available.
    :type reason: str
    :param message: Message why the name is not available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class NameAvailabilityParameters(msrest.serialization.Model):
    """Name availability parameters payload.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the resource to check name availability.
    :type type: str
    :param name: Required. Name to be checked.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityParameters, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.name = kwargs['name']


class NetworkProfile(msrest.serialization.Model):
    """Service network profile payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure
     Spring Cloud Service Runtime.
    :type service_runtime_subnet_id: str
    :param app_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Cloud
     Apps.
    :type app_subnet_id: str
    :param service_cidr: Azure Spring Cloud service reserved CIDR.
    :type service_cidr: str
    :param service_runtime_network_resource_group: Name of the resource group containing network
     resources of Azure Spring Cloud Service Runtime.
    :type service_runtime_network_resource_group: str
    :param app_network_resource_group: Name of the resource group containing network resources of
     Azure Spring Cloud Apps.
    :type app_network_resource_group: str
    :ivar outbound_i_ps: Desired outbound IP resources for Azure Spring Cloud instance.
    :vartype outbound_i_ps:
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.NetworkProfileOutboundIPs
    :ivar required_traffics: Required inbound or outbound traffics for Azure Spring Cloud instance.
    :vartype required_traffics:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.RequiredTraffic]
    """

    _validation = {
        'outbound_i_ps': {'readonly': True},
        'required_traffics': {'readonly': True},
    }

    _attribute_map = {
        'service_runtime_subnet_id': {'key': 'serviceRuntimeSubnetId', 'type': 'str'},
        'app_subnet_id': {'key': 'appSubnetId', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'service_runtime_network_resource_group': {'key': 'serviceRuntimeNetworkResourceGroup', 'type': 'str'},
        'app_network_resource_group': {'key': 'appNetworkResourceGroup', 'type': 'str'},
        'outbound_i_ps': {'key': 'outboundIPs', 'type': 'NetworkProfileOutboundIPs'},
        'required_traffics': {'key': 'requiredTraffics', 'type': '[RequiredTraffic]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.service_runtime_subnet_id = kwargs.get('service_runtime_subnet_id', None)
        self.app_subnet_id = kwargs.get('app_subnet_id', None)
        self.service_cidr = kwargs.get('service_cidr', None)
        self.service_runtime_network_resource_group = kwargs.get('service_runtime_network_resource_group', None)
        self.app_network_resource_group = kwargs.get('app_network_resource_group', None)
        self.outbound_i_ps = None
        self.required_traffics = None


class NetworkProfileOutboundIPs(msrest.serialization.Model):
    """Desired outbound IP resources for Azure Spring Cloud instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_i_ps: A list of public IP addresses.
    :vartype public_i_ps: list[str]
    """

    _validation = {
        'public_i_ps': {'readonly': True},
    }

    _attribute_map = {
        'public_i_ps': {'key': 'publicIPs', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfileOutboundIPs, self).__init__(**kwargs)
        self.public_i_ps = None


class OperationDetail(msrest.serialization.Model):
    """Operation detail payload.

    :param name: Name of the operation.
    :type name: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param display: Display of the operation.
    :type display: ~azure.mgmt.appplatform.v2019_05_01_preview.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: ~azure.mgmt.appplatform.v2019_05_01_preview.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDetail, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(msrest.serialization.Model):
    """Operation display payload.

    :param provider: Resource provider of the operation.
    :type provider: str
    :param resource: Resource of the operation.
    :type resource: str
    :param operation: Localized friendly name for the operation.
    :type operation: str
    :param description: Localized friendly description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationProperties(msrest.serialization.Model):
    """Extra Operation properties.

    :param service_specification: Service specifications of the operation.
    :type service_specification:
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class PersistentDisk(msrest.serialization.Model):
    """Persistent disk payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param size_in_gb: Size of the persistent disk in GB.
    :type size_in_gb: int
    :ivar used_in_gb: Size of the used persistent disk in GB.
    :vartype used_in_gb: int
    :param mount_path: Mount path of the persistent disk.
    :type mount_path: str
    """

    _validation = {
        'size_in_gb': {'maximum': 50, 'minimum': 0},
        'used_in_gb': {'readonly': True, 'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'used_in_gb': {'key': 'usedInGB', 'type': 'int'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PersistentDisk, self).__init__(**kwargs)
        self.size_in_gb = kwargs.get('size_in_gb', None)
        self.used_in_gb = None
        self.mount_path = kwargs.get('mount_path', None)


class RegenerateTestKeyRequestPayload(msrest.serialization.Model):
    """Regenerate test key request payload.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. Type of the test key. Possible values include: "Primary",
     "Secondary".
    :type key_type: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.TestKeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegenerateTestKeyRequestPayload, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']


class RequiredTraffic(msrest.serialization.Model):
    """Required inbound or outbound traffic for Azure Spring Cloud instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar protocol: The protocol of required traffic.
    :vartype protocol: str
    :ivar port: The port of required traffic.
    :vartype port: int
    :ivar ips: The ip list of required traffic.
    :vartype ips: list[str]
    :ivar fqdns: The FQDN list of required traffic.
    :vartype fqdns: list[str]
    :ivar direction: The direction of required traffic. Possible values include: "Inbound",
     "Outbound".
    :vartype direction: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.TrafficDirection
    """

    _validation = {
        'protocol': {'readonly': True},
        'port': {'readonly': True},
        'ips': {'readonly': True},
        'fqdns': {'readonly': True},
        'direction': {'readonly': True},
    }

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'ips': {'key': 'ips', 'type': '[str]'},
        'fqdns': {'key': 'fqdns', 'type': '[str]'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequiredTraffic, self).__init__(**kwargs)
        self.protocol = None
        self.port = None
        self.ips = None
        self.fqdns = None
        self.direction = None


class ResourceSku(msrest.serialization.Model):
    """Describes an available Azure Spring Cloud SKU.

    :param resource_type: Gets the type of resource the SKU applies to.
    :type resource_type: str
    :param name: Gets the name of SKU.
    :type name: str
    :param tier: Gets the tier of SKU.
    :type tier: str
    :param capacity: Gets the capacity of SKU.
    :type capacity: ~azure.mgmt.appplatform.v2019_05_01_preview.models.SkuCapacity
    :param locations: Gets the set of locations that the SKU is available.
    :type locations: list[str]
    :param location_info: Gets a list of locations and availability zones in those locations where
     the SKU is available.
    :type location_info:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuLocationInfo]
    :param restrictions: Gets the restrictions because of which SKU cannot be used. This is
     empty if there are no restrictions.
    :type restrictions:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuRestrictions]
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[ResourceSkuLocationInfo]'},
        'restrictions': {'key': 'restrictions', 'type': '[ResourceSkuRestrictions]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSku, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)
        self.locations = kwargs.get('locations', None)
        self.location_info = kwargs.get('location_info', None)
        self.restrictions = kwargs.get('restrictions', None)


class ResourceSkuCapabilities(msrest.serialization.Model):
    """ResourceSkuCapabilities.

    :param name: Gets an invariant to describe the feature.
    :type name: str
    :param value: Gets an invariant if the feature is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCapabilities, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ResourceSkuCollection(msrest.serialization.Model):
    """ResourceSkuCollection.

    :param value: Collection of resource SKU.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSku]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResourceSkuLocationInfo(msrest.serialization.Model):
    """ResourceSkuLocationInfo.

    :param location: Gets location of the SKU.
    :type location: str
    :param zones: Gets list of availability zones where the SKU is supported.
    :type zones: list[str]
    :param zone_details: Gets details of capabilities available to a SKU in specific zones.
    :type zone_details:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuZoneDetails]
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'zone_details': {'key': 'zoneDetails', 'type': '[ResourceSkuZoneDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuLocationInfo, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.zones = kwargs.get('zones', None)
        self.zone_details = kwargs.get('zone_details', None)


class ResourceSkuRestrictionInfo(msrest.serialization.Model):
    """ResourceSkuRestrictionInfo.

    :param locations: Gets locations where the SKU is restricted.
    :type locations: list[str]
    :param zones: Gets list of availability zones where the SKU is restricted.
    :type zones: list[str]
    """

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[str]'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuRestrictionInfo, self).__init__(**kwargs)
        self.locations = kwargs.get('locations', None)
        self.zones = kwargs.get('zones', None)


class ResourceSkuRestrictions(msrest.serialization.Model):
    """ResourceSkuRestrictions.

    :param type: Gets the type of restrictions. Possible values include: 'Location', 'Zone'.
     Possible values include: "Location", "Zone".
    :type type: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuRestrictionsType
    :param values: Gets the value of restrictions. If the restriction type is set to
     location. This would be different locations where the SKU is restricted.
    :type values: list[str]
    :param restriction_info: Gets the information about the restriction where the SKU cannot be
     used.
    :type restriction_info:
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuRestrictionInfo
    :param reason_code: Gets the reason for restriction. Possible values include: 'QuotaId',
     'NotAvailableForSubscription'. Possible values include: "QuotaId",
     "NotAvailableForSubscription".
    :type reason_code: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuRestrictionsReasonCode
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'restriction_info': {'key': 'restrictionInfo', 'type': 'ResourceSkuRestrictionInfo'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuRestrictions, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.values = kwargs.get('values', None)
        self.restriction_info = kwargs.get('restriction_info', None)
        self.reason_code = kwargs.get('reason_code', None)


class ResourceSkuZoneDetails(msrest.serialization.Model):
    """ResourceSkuZoneDetails.

    :param name: Gets the set of zones that the SKU is available in with the
     specified capabilities.
    :type name: list[str]
    :param capabilities: Gets a list of capabilities that are available for the SKU in the
     specified list of zones.
    :type capabilities:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.ResourceSkuCapabilities]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[ResourceSkuCapabilities]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuZoneDetails, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.capabilities = kwargs.get('capabilities', None)


class ResourceUploadDefinition(msrest.serialization.Model):
    """Resource upload definition payload.

    :param relative_path: Source relative path.
    :type relative_path: str
    :param upload_url: Upload URL.
    :type upload_url: str
    """

    _attribute_map = {
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceUploadDefinition, self).__init__(**kwargs)
        self.relative_path = kwargs.get('relative_path', None)
        self.upload_url = kwargs.get('upload_url', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The GEO location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the service which is a list of key value pairs that
     describe the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ServiceResource(TrackedResource):
    """Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The GEO location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the service which is a list of key value pairs that
     describe the resource.
    :type tags: dict[str, str]
    :param properties: Properties of the Service resource.
    :type properties: ~azure.mgmt.appplatform.v2019_05_01_preview.models.ClusterResourceProperties
    :param sku: Sku of the Service resource.
    :type sku: ~azure.mgmt.appplatform.v2019_05_01_preview.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ClusterResourceProperties'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)


class ServiceResourceList(msrest.serialization.Model):
    """Object that includes an array of Service resources and a possible link for next set.

    :param value: Collection of Service resources.
    :type value: list[~azure.mgmt.appplatform.v2019_05_01_preview.models.ServiceResource]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ServiceSpecification(msrest.serialization.Model):
    """Service specification payload.

    :param log_specifications: Specifications of the Log for Azure Monitoring.
    :type log_specifications:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.LogSpecification]
    :param metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :type metric_specifications:
     list[~azure.mgmt.appplatform.v2019_05_01_preview.models.MetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class Sku(msrest.serialization.Model):
    """Sku of Azure Spring Cloud.

    :param name: Name of the Sku.
    :type name: str
    :param tier: Tier of the Sku.
    :type tier: str
    :param capacity: Current capacity of the target resource.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', "S0")
        self.tier = kwargs.get('tier', "Standard")
        self.capacity = kwargs.get('capacity', None)


class SkuCapacity(msrest.serialization.Model):
    """The SKU capacity.

    All required parameters must be populated in order to send to Azure.

    :param minimum: Required. Gets or sets the minimum.
    :type minimum: int
    :param maximum: Gets or sets the maximum.
    :type maximum: int
    :param default: Gets or sets the default.
    :type default: int
    :param scale_type: Gets or sets the type of the scale. Possible values include: "None",
     "Manual", "Automatic".
    :type scale_type: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.SkuScaleType
    """

    _validation = {
        'minimum': {'required': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = kwargs['minimum']
        self.maximum = kwargs.get('maximum', None)
        self.default = kwargs.get('default', None)
        self.scale_type = kwargs.get('scale_type', None)


class SupportedRuntimeVersion(msrest.serialization.Model):
    """Supported deployment runtime version descriptor.

    :param value: The raw value which could be passed to deployment CRUD operations. Possible
     values include: "Java_8", "Java_11", "NetCore_31".
    :type value: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.SupportedRuntimeValue
    :param platform: The platform of this runtime version (possible values: "Java" or ".NET").
     Possible values include: "Java", ".NET Core".
    :type platform: str or
     ~azure.mgmt.appplatform.v2019_05_01_preview.models.SupportedRuntimePlatform
    :param version: The detailed version (major.minor) of the platform.
    :type version: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'platform': {'key': 'platform', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SupportedRuntimeVersion, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.platform = kwargs.get('platform', None)
        self.version = kwargs.get('version', None)


class TemporaryDisk(msrest.serialization.Model):
    """Temporary disk payload.

    :param size_in_gb: Size of the temporary disk in GB.
    :type size_in_gb: int
    :param mount_path: Mount path of the temporary disk.
    :type mount_path: str
    """

    _validation = {
        'size_in_gb': {'maximum': 5, 'minimum': 0},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TemporaryDisk, self).__init__(**kwargs)
        self.size_in_gb = kwargs.get('size_in_gb', None)
        self.mount_path = kwargs.get('mount_path', "/tmp")


class TestKeys(msrest.serialization.Model):
    """Test keys payload.

    :param primary_key: Primary key.
    :type primary_key: str
    :param secondary_key: Secondary key.
    :type secondary_key: str
    :param primary_test_endpoint: Primary test endpoint.
    :type primary_test_endpoint: str
    :param secondary_test_endpoint: Secondary test endpoint.
    :type secondary_test_endpoint: str
    :param enabled: Indicates whether the test endpoint feature enabled or not.
    :type enabled: bool
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'primary_test_endpoint': {'key': 'primaryTestEndpoint', 'type': 'str'},
        'secondary_test_endpoint': {'key': 'secondaryTestEndpoint', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestKeys, self).__init__(**kwargs)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.primary_test_endpoint = kwargs.get('primary_test_endpoint', None)
        self.secondary_test_endpoint = kwargs.get('secondary_test_endpoint', None)
        self.enabled = kwargs.get('enabled', None)


class TraceProperties(msrest.serialization.Model):
    """Trace properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: State of the trace proxy. Possible values include: "NotAvailable", "Failed",
     "Succeeded", "Updating".
    :vartype state: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.TraceProxyState
    :param error: Error when apply trace proxy changes.
    :type error: ~azure.mgmt.appplatform.v2019_05_01_preview.models.Error
    :param enabled: Indicates whether enable the tracing functionality.
    :type enabled: bool
    :param app_insight_instrumentation_key: Target application insight instrumentation key.
    :type app_insight_instrumentation_key: str
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'app_insight_instrumentation_key': {'key': 'appInsightInstrumentationKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TraceProperties, self).__init__(**kwargs)
        self.state = None
        self.error = kwargs.get('error', None)
        self.enabled = kwargs.get('enabled', None)
        self.app_insight_instrumentation_key = kwargs.get('app_insight_instrumentation_key', None)


class UserSourceInfo(msrest.serialization.Model):
    """Source information for a deployment.

    :param type: Type of the source uploaded. Possible values include: "Jar", "NetCoreZip",
     "Source".
    :type type: str or ~azure.mgmt.appplatform.v2019_05_01_preview.models.UserSourceType
    :param relative_path: Relative path of the storage which stores the source.
    :type relative_path: str
    :param version: Version of the source.
    :type version: str
    :param artifact_selector: Selector for the artifact to be used for the deployment for
     multi-module projects. This should be
     the relative path to the target module/project.
    :type artifact_selector: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'artifact_selector': {'key': 'artifactSelector', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserSourceInfo, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.relative_path = kwargs.get('relative_path', None)
        self.version = kwargs.get('version', None)
        self.artifact_selector = kwargs.get('artifact_selector', None)
