# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .catalog_item import CatalogItem


class USqlAssembly(CatalogItem):
    """A Data Lake Analytics catalog U-SQL Assembly.

    :param compute_account_name: the name of the Data Lake Analytics account.
    :type compute_account_name: str
    :param version: the version of the catalog item.
    :type version: str
    :param database_name: the name of the database.
    :type database_name: str
    :param name: the name of the assembly.
    :type name: str
    :param clr_name: the name of the CLR.
    :type clr_name: str
    :param is_visible: the switch indicating if this assembly is visible or
     not.
    :type is_visible: bool
    :param is_user_defined: the switch indicating if this assembly is user
     defined or not.
    :type is_user_defined: bool
    :param files: the list of files associated with the assembly
    :type files:
     list[~azure.mgmt.datalake.analytics.catalog.models.USqlAssemblyFileInfo]
    :param dependencies: the list of dependencies associated with the assembly
    :type dependencies:
     list[~azure.mgmt.datalake.analytics.catalog.models.USqlAssemblyDependencyInfo]
    """

    _attribute_map = {
        'compute_account_name': {'key': 'computeAccountName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'name': {'key': 'assemblyName', 'type': 'str'},
        'clr_name': {'key': 'clrName', 'type': 'str'},
        'is_visible': {'key': 'isVisible', 'type': 'bool'},
        'is_user_defined': {'key': 'isUserDefined', 'type': 'bool'},
        'files': {'key': 'files', 'type': '[USqlAssemblyFileInfo]'},
        'dependencies': {'key': 'dependencies', 'type': '[USqlAssemblyDependencyInfo]'},
    }

    def __init__(self, **kwargs):
        super(USqlAssembly, self).__init__(**kwargs)
        self.database_name = kwargs.get('database_name', None)
        self.name = kwargs.get('name', None)
        self.clr_name = kwargs.get('clr_name', None)
        self.is_visible = kwargs.get('is_visible', None)
        self.is_user_defined = kwargs.get('is_user_defined', None)
        self.files = kwargs.get('files', None)
        self.dependencies = kwargs.get('dependencies', None)
