# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TenantConfigurationSyncStateContract(Model):
    """Tenant Configuration Synchronization State.

    :param branch: The name of Git branch.
    :type branch: str
    :param commit_id: The latest commit Id.
    :type commit_id: str
    :param is_export: value indicating if last sync was save (true) or deploy
     (false) operation.
    :type is_export: bool
    :param is_synced: value indicating if last synchronization was later than
     the configuration change.
    :type is_synced: bool
    :param is_git_enabled: value indicating whether Git configuration access
     is enabled.
    :type is_git_enabled: bool
    :param sync_date: The date of the latest synchronization. The date
     conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by
     the ISO 8601 standard.
    :type sync_date: datetime
    :param configuration_change_date: The date of the latest configuration
     change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ`
     as specified by the ISO 8601 standard.
    :type configuration_change_date: datetime
    """

    _attribute_map = {
        'branch': {'key': 'branch', 'type': 'str'},
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'is_export': {'key': 'isExport', 'type': 'bool'},
        'is_synced': {'key': 'isSynced', 'type': 'bool'},
        'is_git_enabled': {'key': 'isGitEnabled', 'type': 'bool'},
        'sync_date': {'key': 'syncDate', 'type': 'iso-8601'},
        'configuration_change_date': {'key': 'configurationChangeDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(TenantConfigurationSyncStateContract, self).__init__(**kwargs)
        self.branch = kwargs.get('branch', None)
        self.commit_id = kwargs.get('commit_id', None)
        self.is_export = kwargs.get('is_export', None)
        self.is_synced = kwargs.get('is_synced', None)
        self.is_git_enabled = kwargs.get('is_git_enabled', None)
        self.sync_date = kwargs.get('sync_date', None)
        self.configuration_change_date = kwargs.get('configuration_change_date', None)
