# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CertificateConfiguration(Model):
    """Certificate configuration which consist of non-trusted intermediates and
    root certificates.

    All required parameters must be populated in order to send to Azure.

    :param encoded_certificate: Base64 Encoded certificate.
    :type encoded_certificate: str
    :param certificate_password: Certificate Password.
    :type certificate_password: str
    :param store_name: Required. The
     System.Security.Cryptography.x509certificates.StoreName certificate store
     location. Only Root and CertificateAuthority are valid locations. Possible
     values include: 'CertificateAuthority', 'Root'
    :type store_name: str or ~azure.mgmt.apimanagement.models.enum
    :param certificate: Certificate information.
    :type certificate: ~azure.mgmt.apimanagement.models.CertificateInformation
    """

    _validation = {
        'store_name': {'required': True},
    }

    _attribute_map = {
        'encoded_certificate': {'key': 'encodedCertificate', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'CertificateInformation'},
    }

    def __init__(self, **kwargs):
        super(CertificateConfiguration, self).__init__(**kwargs)
        self.encoded_certificate = kwargs.get('encoded_certificate', None)
        self.certificate_password = kwargs.get('certificate_password', None)
        self.store_name = kwargs.get('store_name', None)
        self.certificate = kwargs.get('certificate', None)
