# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class CacheContract(Resource):
    """Cache details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Cache description
    :type description: str
    :param connection_string: Required. Runtime connection string to cache
    :type connection_string: str
    :param resource_id: Original uri of entity in external system cache points
     to
    :type resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 2000},
        'connection_string': {'required': True, 'max_length': 300},
        'resource_id': {'max_length': 2000},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(self, *, connection_string: str, description: str=None, resource_id: str=None, **kwargs) -> None:
        super(CacheContract, self).__init__(**kwargs)
        self.description = description
        self.connection_string = connection_string
        self.resource_id = resource_id
