#!/usr/bin/python
# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0
from __future__ import annotations

'''Unit tests for QCollator'''

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from init_paths import init_test_paths
init_test_paths(False)

from PySide6.QtCore import QCollator, QLocale, Qt


class QCollatorTest(unittest.TestCase):
    def testState(self):
        c = QCollator()
        c.setCaseSensitivity(Qt.CaseSensitivity.CaseInsensitive)
        c.setLocale(QLocale.Language.German)

        print("compare a and b:", c.compare("a", "b"))

        self.assertEqual(c.caseSensitivity(), Qt.CaseSensitivity.CaseInsensitive)
        self.assertEqual(c.locale(), QLocale(QLocale.Language.German))

        c.setLocale(QLocale.Language.French)
        c.setNumericMode(True)
        c.setIgnorePunctuation(True)
        c.setLocale(QLocale.Language.NorwegianBokmal)

        self.assertEqual(c.caseSensitivity(), Qt.CaseSensitivity.CaseInsensitive)
        self.assertEqual(c.numericMode(), True)
        self.assertEqual(c.ignorePunctuation(), True)
        self.assertEqual(c.locale(), QLocale(QLocale.Language.NorwegianBokmal))


if __name__ == '__main__':
    unittest.main()
