#line 9 "putget.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 11
/*
 *	Copyright 2018, University Corporation for Atmospheric Research
 *      See netcdf/COPYRIGHT file for copying and redistribution conditions.
 */
/* $Id: putget.m4 2783 2014-10-26 05:19:35Z wkliao $ */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "netcdf.h"
#include "nc3dispatch.h"
#include "nc3internal.h"
#include "ncx.h"
#include "fbits.h"
#include "onstack.h"

#undef MIN  /* system may define MIN somewhere and complain */
#define MIN(mm,nn) (((mm) < (nn)) ? (mm) : (nn))

static int
readNCv(const NC3_INFO* ncp, const NC_var* varp, const size_t* start,
        const size_t nelems, void* value, const nc_type memtype);
static int
writeNCv(NC3_INFO* ncp, const NC_var* varp, const size_t* start,
         const size_t nelems, const void* value, const nc_type memtype);


/* #define ODEBUG 1 */

#if ODEBUG
#include <stdio.h>
/*
 * Print the values of an array of size_t
 */
void
arrayp(const char *label, size_t count, const size_t *array)
{
	(void) fprintf(stderr, "%s", label);
	(void) fputc('\t',stderr);
	for(; count > 0; count--, array++)
		(void) fprintf(stderr," %lu", (unsigned long)*array);
	(void) fputc('\n',stderr);
}
#endif /* ODEBUG */


/* Begin fill */
/*
 * This is tunable parameter.
 * It essentially controls the tradeoff between the number of times
 * memcpy() gets called to copy the external data to fill
 * a large buffer vs the number of times its called to
 * prepare the external data.
 */
#if	_SX
/* NEC SX specific optimization */
#define	NFILL	2048
#else
#define	NFILL	16
#endif


#line 103

/*
 * Next 6 type specific functions
 * Fill a some memory with the default special value.
 * Formerly
NC_arrayfill()
 */
static int
#line 110
NC_fill_schar(
#line 110
	void **xpp,
#line 110
	size_t nelems)	/* how many */
#line 110
{
#line 110
	schar fillp[NFILL * sizeof(double)/X_SIZEOF_CHAR];
#line 110

#line 110
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 110

#line 110
	{
#line 110
		schar *vp = fillp;	/* lower bound of area to be filled */
#line 110
		const schar *const end = vp + nelems;
#line 110
		while(vp < end)
#line 110
		{
#line 110
			*vp++ = NC_FILL_BYTE;
#line 110
		}
#line 110
	}
#line 110
	return ncx_putn_schar_schar(xpp, nelems, fillp ,NULL);
#line 110
}
#line 110

static int
#line 111
NC_fill_char(
#line 111
	void **xpp,
#line 111
	size_t nelems)	/* how many */
#line 111
{
#line 111
	char fillp[NFILL * sizeof(double)/X_SIZEOF_CHAR];
#line 111

#line 111
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 111

#line 111
	{
#line 111
		char *vp = fillp;	/* lower bound of area to be filled */
#line 111
		const char *const end = vp + nelems;
#line 111
		while(vp < end)
#line 111
		{
#line 111
			*vp++ = NC_FILL_CHAR;
#line 111
		}
#line 111
	}
#line 111
	return ncx_putn_char_char(xpp, nelems, fillp );
#line 111
}
#line 111

static int
#line 112
NC_fill_short(
#line 112
	void **xpp,
#line 112
	size_t nelems)	/* how many */
#line 112
{
#line 112
	short fillp[NFILL * sizeof(double)/X_SIZEOF_SHORT];
#line 112

#line 112
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 112

#line 112
	{
#line 112
		short *vp = fillp;	/* lower bound of area to be filled */
#line 112
		const short *const end = vp + nelems;
#line 112
		while(vp < end)
#line 112
		{
#line 112
			*vp++ = NC_FILL_SHORT;
#line 112
		}
#line 112
	}
#line 112
	return ncx_putn_short_short(xpp, nelems, fillp ,NULL);
#line 112
}
#line 112


#if (SIZEOF_INT >= X_SIZEOF_INT)
static int
#line 115
NC_fill_int(
#line 115
	void **xpp,
#line 115
	size_t nelems)	/* how many */
#line 115
{
#line 115
	int fillp[NFILL * sizeof(double)/X_SIZEOF_INT];
#line 115

#line 115
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 115

#line 115
	{
#line 115
		int *vp = fillp;	/* lower bound of area to be filled */
#line 115
		const int *const end = vp + nelems;
#line 115
		while(vp < end)
#line 115
		{
#line 115
			*vp++ = NC_FILL_INT;
#line 115
		}
#line 115
	}
#line 115
	return ncx_putn_int_int(xpp, nelems, fillp ,NULL);
#line 115
}
#line 115

#elif SIZEOF_LONG == X_SIZEOF_INT
static int
#line 117
NC_fill_int(
#line 117
	void **xpp,
#line 117
	size_t nelems)	/* how many */
#line 117
{
#line 117
	long fillp[NFILL * sizeof(double)/X_SIZEOF_INT];
#line 117

#line 117
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 117

#line 117
	{
#line 117
		long *vp = fillp;	/* lower bound of area to be filled */
#line 117
		const long *const end = vp + nelems;
#line 117
		while(vp < end)
#line 117
		{
#line 117
			*vp++ = NC_FILL_INT;
#line 117
		}
#line 117
	}
#line 117
	return ncx_putn_int_long(xpp, nelems, fillp ,NULL);
#line 117
}
#line 117

#else
#error "NC_fill_int implementation"
#endif

static int
#line 122
NC_fill_float(
#line 122
	void **xpp,
#line 122
	size_t nelems)	/* how many */
#line 122
{
#line 122
	float fillp[NFILL * sizeof(double)/X_SIZEOF_FLOAT];
#line 122

#line 122
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 122

#line 122
	{
#line 122
		float *vp = fillp;	/* lower bound of area to be filled */
#line 122
		const float *const end = vp + nelems;
#line 122
		while(vp < end)
#line 122
		{
#line 122
			*vp++ = NC_FILL_FLOAT;
#line 122
		}
#line 122
	}
#line 122
	return ncx_putn_float_float(xpp, nelems, fillp ,NULL);
#line 122
}
#line 122

static int
#line 123
NC_fill_double(
#line 123
	void **xpp,
#line 123
	size_t nelems)	/* how many */
#line 123
{
#line 123
	double fillp[NFILL * sizeof(double)/X_SIZEOF_DOUBLE];
#line 123

#line 123
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 123

#line 123
	{
#line 123
		double *vp = fillp;	/* lower bound of area to be filled */
#line 123
		const double *const end = vp + nelems;
#line 123
		while(vp < end)
#line 123
		{
#line 123
			*vp++ = NC_FILL_DOUBLE;
#line 123
		}
#line 123
	}
#line 123
	return ncx_putn_double_double(xpp, nelems, fillp ,NULL);
#line 123
}
#line 123


static int
#line 125
NC_fill_uchar(
#line 125
	void **xpp,
#line 125
	size_t nelems)	/* how many */
#line 125
{
#line 125
	uchar fillp[NFILL * sizeof(double)/X_SIZEOF_UBYTE];
#line 125

#line 125
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 125

#line 125
	{
#line 125
		uchar *vp = fillp;	/* lower bound of area to be filled */
#line 125
		const uchar *const end = vp + nelems;
#line 125
		while(vp < end)
#line 125
		{
#line 125
			*vp++ = NC_FILL_UBYTE;
#line 125
		}
#line 125
	}
#line 125
	return ncx_putn_uchar_uchar(xpp, nelems, fillp ,NULL);
#line 125
}
#line 125

static int
#line 126
NC_fill_ushort(
#line 126
	void **xpp,
#line 126
	size_t nelems)	/* how many */
#line 126
{
#line 126
	ushort fillp[NFILL * sizeof(double)/X_SIZEOF_USHORT];
#line 126

#line 126
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 126

#line 126
	{
#line 126
		ushort *vp = fillp;	/* lower bound of area to be filled */
#line 126
		const ushort *const end = vp + nelems;
#line 126
		while(vp < end)
#line 126
		{
#line 126
			*vp++ = NC_FILL_USHORT;
#line 126
		}
#line 126
	}
#line 126
	return ncx_putn_ushort_ushort(xpp, nelems, fillp ,NULL);
#line 126
}
#line 126

static int
#line 127
NC_fill_uint(
#line 127
	void **xpp,
#line 127
	size_t nelems)	/* how many */
#line 127
{
#line 127
	uint fillp[NFILL * sizeof(double)/X_SIZEOF_UINT];
#line 127

#line 127
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 127

#line 127
	{
#line 127
		uint *vp = fillp;	/* lower bound of area to be filled */
#line 127
		const uint *const end = vp + nelems;
#line 127
		while(vp < end)
#line 127
		{
#line 127
			*vp++ = NC_FILL_UINT;
#line 127
		}
#line 127
	}
#line 127
	return ncx_putn_uint_uint(xpp, nelems, fillp ,NULL);
#line 127
}
#line 127

static int
#line 128
NC_fill_longlong(
#line 128
	void **xpp,
#line 128
	size_t nelems)	/* how many */
#line 128
{
#line 128
	longlong fillp[NFILL * sizeof(double)/X_SIZEOF_LONGLONG];
#line 128

#line 128
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 128

#line 128
	{
#line 128
		longlong *vp = fillp;	/* lower bound of area to be filled */
#line 128
		const longlong *const end = vp + nelems;
#line 128
		while(vp < end)
#line 128
		{
#line 128
			*vp++ = NC_FILL_INT64;
#line 128
		}
#line 128
	}
#line 128
	return ncx_putn_longlong_longlong(xpp, nelems, fillp ,NULL);
#line 128
}
#line 128

static int
#line 129
NC_fill_ulonglong(
#line 129
	void **xpp,
#line 129
	size_t nelems)	/* how many */
#line 129
{
#line 129
	ulonglong fillp[NFILL * sizeof(double)/X_SIZEOF_ULONGLONG];
#line 129

#line 129
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 129

#line 129
	{
#line 129
		ulonglong *vp = fillp;	/* lower bound of area to be filled */
#line 129
		const ulonglong *const end = vp + nelems;
#line 129
		while(vp < end)
#line 129
		{
#line 129
			*vp++ = NC_FILL_UINT64;
#line 129
		}
#line 129
	}
#line 129
	return ncx_putn_ulonglong_ulonglong(xpp, nelems, fillp ,NULL);
#line 129
}
#line 129




/*
 * Fill the external space for variable 'varp' values at 'recno' with
 * the appropriate value. If 'varp' is not a record variable, fill the
 * whole thing.  For the special case when 'varp' is the only record
 * variable and it is of type byte, char, or short, varsize should be
 * ncp->recsize, otherwise it should be varp->len.
 * Formerly
xdr_NC_fill()
 */
int
fill_NC_var(NC3_INFO* ncp, const NC_var *varp, long long varsize, size_t recno)
{
	char xfillp[NFILL * X_SIZEOF_DOUBLE];
	const size_t step = varp->xsz;
	const size_t nelems = sizeof(xfillp)/step;
	const size_t xsz = varp->xsz * nelems;
	NC_attr **attrpp = NULL;
	off_t offset;
	long long remaining = varsize;

	void *xp;
	int status = NC_NOERR;

	/*
	 * Set up fill value
	 */
	attrpp = NC_findattr(&varp->attrs, _FillValue);
	if( attrpp != NULL )
	{
		/* User defined fill value */
		if( (*attrpp)->type != varp->type || (*attrpp)->nelems != 1 )
		{
			return NC_EBADTYPE;
		}
		else
		{
			/* Use the user defined value */
			char *cp = xfillp;
			const char *const end = &xfillp[sizeof(xfillp)];

			assert(step <= (*attrpp)->xsz);

			for( /*NADA*/; cp < end; cp += step)
			{
				(void) memcpy(cp, (*attrpp)->xvalue, step);
			}
		}
	}
	else
	{
		/* use the default */

		assert(xsz % X_ALIGN == 0);
		assert(xsz <= sizeof(xfillp));

		xp = xfillp;

		switch(varp->type){
		case NC_BYTE :
			status = NC_fill_schar(&xp, nelems);
			break;
		case NC_CHAR :
			status = NC_fill_char(&xp, nelems);
			break;
		case NC_SHORT :
			status = NC_fill_short(&xp, nelems);
			break;
		case NC_INT :
			status = NC_fill_int(&xp, nelems);
			break;
		case NC_FLOAT :
			status = NC_fill_float(&xp, nelems);
			break;
		case NC_DOUBLE :
			status = NC_fill_double(&xp, nelems);
			break;
                case NC_UBYTE :
                        status = NC_fill_uchar(&xp, nelems);
                        break;
                case NC_USHORT :
                        status = NC_fill_ushort(&xp, nelems);
                        break;
                case NC_UINT :
                        status = NC_fill_uint(&xp, nelems);
                        break;
                case NC_INT64 :
                        status = NC_fill_longlong(&xp, nelems);
                        break;
                case NC_UINT64 :
                        status = NC_fill_ulonglong(&xp, nelems);
                        break;
		default :
			assert("fill_NC_var invalid type" == 0);
			status = NC_EBADTYPE;
			break;
		}
		if(status != NC_NOERR)
			return status;

		assert(xp == xfillp + xsz);
	}

	/*
	 * copyout:
	 * xfillp now contains 'nelems' elements of the fill value
	 * in external representation.
	 */

	/*
	 * Copy it out.
	 */

	offset = varp->begin;
	if(IS_RECVAR(varp))
	{
		offset += (off_t)ncp->recsize * recno;
	}

	assert(remaining > 0);
	for(;;)
	{
		const size_t chunksz = MIN(remaining, ncp->chunk);
		size_t ii;

		status = ncio_get(ncp->nciop, offset, chunksz,
				 RGN_WRITE, &xp);
		if(status != NC_NOERR)
		{
			return status;
		}

		/*
		 * fill the chunksz buffer in units  of xsz
		 */
		for(ii = 0; ii < chunksz/xsz; ii++)
		{
			(void) memcpy(xp, xfillp, xsz);
			xp = (char *)xp + xsz;
		}
		/*
		 * Deal with any remainder
		 */
		{
			const size_t rem = chunksz % xsz;
			if(rem != 0)
			{
				(void) memcpy(xp, xfillp, rem);
				/* xp = (char *)xp + xsz; */
			}

		}

		status = ncio_rel(ncp->nciop, offset, RGN_MODIFIED);

		if(status != NC_NOERR)
		{
			break;
		}

		remaining -= chunksz;
		if(remaining == 0)
			break;	/* normal loop exit */
		offset += chunksz;

	}

	return status;
}
/* End fill */


/*
 * Add a record containing the fill values.
 */
static int
NCfillrecord(NC3_INFO* ncp, const NC_var *const *varpp, size_t recno)
{
	size_t ii = 0;
	for(; ii < ncp->vars.nelems; ii++, varpp++)
	{
		if( !IS_RECVAR(*varpp) )
		{
			continue;	/* skip non-record variables */
		}
		{
		const int status = fill_NC_var(ncp, *varpp, (*varpp)->len, recno);
		if(status != NC_NOERR)
			return status;
		}
	}
	return NC_NOERR;
}


/*
 * Add a record containing the fill values in the special case when
 * there is exactly one record variable, where we don't require each
 * record to be four-byte aligned (no record padding).
 */
static int
NCfillspecialrecord(NC3_INFO* ncp, const NC_var *varp, size_t recno)
{
    int status;
    assert(IS_RECVAR(varp));
    status = fill_NC_var(ncp, varp, ncp->recsize, recno);
    if(status != NC_NOERR)
	return status;
    return NC_NOERR;
}


/*
 * It is advantageous to
 * #define TOUCH_LAST
 * when using memory mapped io.
 */
#if TOUCH_LAST
/*
 * Grow the file to a size which can contain recno
 */
static int
NCtouchlast(NC3_INFO* ncp, const NC_var *const *varpp, size_t recno)
{
	int status = NC_NOERR;
	const NC_var *varp = NULL;

	{
	size_t ii = 0;
	for(; ii < ncp->vars.nelems; ii++, varpp++)
	{
		if( !IS_RECVAR(*varpp) )
		{
			continue;	/* skip non-record variables */
		}
		varp = *varpp;
	}
	}
	assert(varp != NULL);
	assert( IS_RECVAR(varp) );
	{
		const off_t offset = varp->begin
				+ (off_t)(recno-1) * (off_t)ncp->recsize
				+ (off_t)(varp->len - varp->xsz);
		void *xp;


		status = ncio_get(ncp->nciop, offset, varp->xsz,
				 RGN_WRITE, &xp);
		if(status != NC_NOERR)
			return status;
		(void)memset(xp, 0, varp->xsz);
		status = ncio_rel(ncp->nciop, offset, RGN_MODIFIED);
	}
	return status;
}
#endif /* TOUCH_LAST */


/*
 * Ensure that the netcdf file has 'numrecs' records,
 * add records and fill as necessary.
 */
static int
NCvnrecs(NC3_INFO* ncp, size_t numrecs)
{
	int status = NC_NOERR;

	if(numrecs > NC_get_numrecs(ncp))
	{


#if TOUCH_LAST
		status = NCtouchlast(ncp,
			(const NC_var *const*)ncp->vars.value,
			numrecs);
		if(status != NC_NOERR)
			goto common_return;
#endif /* TOUCH_LAST */

		set_NC_ndirty(ncp);

		if(!NC_dofill(ncp))
		{
			/* Simply set the new numrecs value */
			NC_set_numrecs(ncp, numrecs);
		}
		else
		{
		    /* Treat two cases differently:
		        - exactly one record variable (no padding)
                        - multiple record variables (each record padded
                          to 4-byte alignment)
		    */
		    NC_var **vpp = (NC_var **)ncp->vars.value;
		    NC_var *const *const end = &vpp[ncp->vars.nelems];
		    NC_var *recvarp = NULL;	/* last record var */
		    int numrecvars = 0;
		    size_t cur_nrecs;

		    /* determine how many record variables */
		    for( /*NADA*/; vpp < end; vpp++) {
			if(IS_RECVAR(*vpp)) {
			    recvarp = *vpp;
			    numrecvars++;
			}
		    }

		    if (numrecvars != 1) { /* usual case */
			/* Fill each record out to numrecs */
			while((cur_nrecs = NC_get_numrecs(ncp)) < numrecs)
			    {
				status = NCfillrecord(ncp,
					(const NC_var *const*)ncp->vars.value,
					cur_nrecs);
				if(status != NC_NOERR)
				{
					break;
				}
				NC_increase_numrecs(ncp, cur_nrecs +1);
			}
			if(status != NC_NOERR)
				goto common_return;
		    } else {	/* special case */
			/* Fill each record out to numrecs */
			while((cur_nrecs = NC_get_numrecs(ncp)) < numrecs)
			    {
				status = NCfillspecialrecord(ncp,
					recvarp,
					cur_nrecs);
				if(status != NC_NOERR)
				{
					break;
				}
				NC_increase_numrecs(ncp, cur_nrecs +1);
			}
			if(status != NC_NOERR)
				goto common_return;

		    }
		}

		if(NC_doNsync(ncp))
		{
			status = write_numrecs(ncp);
		}

	}
common_return:
	return status;
}


/*
 * Check whether 'coord' values are valid for the variable.
 */
static int
NCcoordck(NC3_INFO* ncp, const NC_var *varp, const size_t *coord)
{
	const size_t *ip;
	size_t *up;

	if(varp->ndims == 0)
		return NC_NOERR;	/* 'scalar' variable */

	if(IS_RECVAR(varp))
	{
		if(*coord > X_UINT_MAX) /* rkr: bug fix from previous X_INT_MAX */
			return NC_EINVALCOORDS; /* sanity check */
		if(NC_readonly(ncp) && *coord > NC_get_numrecs(ncp))
		{
			if(!NC_doNsync(ncp))
				return NC_EINVALCOORDS;
			/* else */
			{
				/* Update from disk and check again */
				const int status = read_numrecs(ncp);
				if(status != NC_NOERR)
					return status;
				if(*coord > NC_get_numrecs(ncp))
					return NC_EINVALCOORDS;
			}
		}
		ip = coord + 1;
		up = varp->shape + 1;
	}
	else
	{
		ip = coord;
		up = varp->shape;
	}

#ifdef CDEBUG
fprintf(stderr,"	NCcoordck: coord %ld, count %d, ip %ld\n",
		coord, varp->ndims, ip );
#endif /* CDEBUG */

	for(; ip < coord + varp->ndims; ip++, up++)
	{

#ifdef CDEBUG
fprintf(stderr,"	NCcoordck: ip %p, *ip %ld, up %p, *up %lu\n",
			ip, *ip, up, *up );
#endif /* CDEBUG */

		/* cast needed for braindead systems with signed size_t */
		if((unsigned long) *ip > (unsigned long) *up )
			return NC_EINVALCOORDS;
	}

	return NC_NOERR;
}


/*
 * Check whether 'edges' are valid for the variable and 'start'
 */
/*ARGSUSED*/
static int
NCedgeck(const NC3_INFO* ncp, const NC_var *varp,
	 const size_t *start, const size_t *edges)
{
	const size_t *const end = start + varp->ndims;
	const size_t *shp = varp->shape;

	if(varp->ndims == 0)
		return NC_NOERR;	/* 'scalar' variable */

	if(IS_RECVAR(varp))
	{
		if (NC_readonly(ncp) &&
                    (start[0] == NC_get_numrecs(ncp) && edges[0] > 0))
			return(NC_EINVALCOORDS);
		start++;
		edges++;
		shp++;
	}

	for(; start < end; start++, edges++, shp++)
	{
		if ((unsigned long) *start == *shp && *edges > 0)
			return(NC_EINVALCOORDS);
		/* cast needed for braindead systems with signed size_t */
		if((unsigned long) *edges > *shp ||
			(unsigned long) *start + (unsigned long) *edges > *shp)
		{
			return(NC_EEDGE);
		}
	}
	return NC_NOERR;
}


/*
 * Translate the (variable, coord) pair into a seek index
 */
static off_t
NC_varoffset(const NC3_INFO* ncp, const NC_var *varp, const size_t *coord)
{
	if(varp->ndims == 0) /* 'scalar' variable */
		return varp->begin;

	if(varp->ndims == 1)
	{
		if(IS_RECVAR(varp))
			return varp->begin +
				 (off_t)(*coord) * (off_t)ncp->recsize;
		/* else */
		return varp->begin + (off_t)(*coord) * (off_t)varp->xsz;
	}
	/* else */
	{
		off_t lcoord = (off_t)coord[varp->ndims -1];

		off_t *up = varp->dsizes +1;
		const size_t *ip = coord;
		const off_t *const end = varp->dsizes + varp->ndims;

		if(IS_RECVAR(varp))
			up++, ip++;

		for(; up < end; up++, ip++)
			lcoord += (off_t)(*up) * (off_t)(*ip);

		lcoord *= varp->xsz;

		if(IS_RECVAR(varp))
			lcoord += (off_t)(*coord) * ncp->recsize;

		lcoord += varp->begin;
		return lcoord;
	}
}


#line 693

static int
#line 694
putNCvx_char_char(NC3_INFO* ncp, const NC_var *varp,
#line 694
		 const size_t *start, size_t nelems, const char *value)
#line 694
{
#line 694
	off_t offset = NC_varoffset(ncp, varp, start);
#line 694
	size_t remaining = varp->xsz * nelems;
#line 694
	int status = NC_NOERR;
#line 694
	void *xp;
#line 694
        void *fillp=NULL;
#line 694

#line 694
	NC_UNUSED(fillp);
#line 694

#line 694
	if(nelems == 0)
#line 694
		return NC_NOERR;
#line 694

#line 694
	assert(value != NULL);
#line 694

#line 694
#ifdef ERANGE_FILL
#line 694
        fillp = malloc(varp->xsz);
#line 694
        status = NC3_inq_var_fill(varp, fillp);
#line 694
#endif
#line 694

#line 694
	for(;;)
#line 694
	{
#line 694
		size_t extent = MIN(remaining, ncp->chunk);
#line 694
		size_t nput = ncx_howmany(varp->type, extent);
#line 694

#line 694
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 694
				 RGN_WRITE, &xp);
#line 694
		if(lstatus != NC_NOERR)
#line 694
			return lstatus;
#line 694

#line 694
		lstatus = ncx_putn_char_char(&xp, nput, value );
#line 694
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 694
		{
#line 694
			/* not fatal to the loop */
#line 694
			status = lstatus;
#line 694
		}
#line 694

#line 694
		(void) ncio_rel(ncp->nciop, offset,
#line 694
				 RGN_MODIFIED);
#line 694

#line 694
		remaining -= extent;
#line 694
		if(remaining == 0)
#line 694
			break; /* normal loop exit */
#line 694
		offset += (off_t)extent;
#line 694
		value += nput;
#line 694

#line 694
	}
#line 694
#ifdef ERANGE_FILL
#line 694
        free(fillp);
#line 694
#endif
#line 694

#line 694
	return status;
#line 694
}
#line 694


static int
#line 696
putNCvx_schar_schar(NC3_INFO* ncp, const NC_var *varp,
#line 696
		 const size_t *start, size_t nelems, const schar *value)
#line 696
{
#line 696
	off_t offset = NC_varoffset(ncp, varp, start);
#line 696
	size_t remaining = varp->xsz * nelems;
#line 696
	int status = NC_NOERR;
#line 696
	void *xp;
#line 696
        void *fillp=NULL;
#line 696

#line 696
	NC_UNUSED(fillp);
#line 696

#line 696
	if(nelems == 0)
#line 696
		return NC_NOERR;
#line 696

#line 696
	assert(value != NULL);
#line 696

#line 696
#ifdef ERANGE_FILL
#line 696
        fillp = malloc(varp->xsz);
#line 696
        status = NC3_inq_var_fill(varp, fillp);
#line 696
#endif
#line 696

#line 696
	for(;;)
#line 696
	{
#line 696
		size_t extent = MIN(remaining, ncp->chunk);
#line 696
		size_t nput = ncx_howmany(varp->type, extent);
#line 696

#line 696
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 696
				 RGN_WRITE, &xp);
#line 696
		if(lstatus != NC_NOERR)
#line 696
			return lstatus;
#line 696

#line 696
		lstatus = ncx_putn_schar_schar(&xp, nput, value ,fillp);
#line 696
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 696
		{
#line 696
			/* not fatal to the loop */
#line 696
			status = lstatus;
#line 696
		}
#line 696

#line 696
		(void) ncio_rel(ncp->nciop, offset,
#line 696
				 RGN_MODIFIED);
#line 696

#line 696
		remaining -= extent;
#line 696
		if(remaining == 0)
#line 696
			break; /* normal loop exit */
#line 696
		offset += (off_t)extent;
#line 696
		value += nput;
#line 696

#line 696
	}
#line 696
#ifdef ERANGE_FILL
#line 696
        free(fillp);
#line 696
#endif
#line 696

#line 696
	return status;
#line 696
}
#line 696

static int
#line 697
putNCvx_schar_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 697
		 const size_t *start, size_t nelems, const uchar *value)
#line 697
{
#line 697
	off_t offset = NC_varoffset(ncp, varp, start);
#line 697
	size_t remaining = varp->xsz * nelems;
#line 697
	int status = NC_NOERR;
#line 697
	void *xp;
#line 697
        void *fillp=NULL;
#line 697

#line 697
	NC_UNUSED(fillp);
#line 697

#line 697
	if(nelems == 0)
#line 697
		return NC_NOERR;
#line 697

#line 697
	assert(value != NULL);
#line 697

#line 697
#ifdef ERANGE_FILL
#line 697
        fillp = malloc(varp->xsz);
#line 697
        status = NC3_inq_var_fill(varp, fillp);
#line 697
#endif
#line 697

#line 697
	for(;;)
#line 697
	{
#line 697
		size_t extent = MIN(remaining, ncp->chunk);
#line 697
		size_t nput = ncx_howmany(varp->type, extent);
#line 697

#line 697
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 697
				 RGN_WRITE, &xp);
#line 697
		if(lstatus != NC_NOERR)
#line 697
			return lstatus;
#line 697

#line 697
		lstatus = ncx_putn_schar_uchar(&xp, nput, value ,fillp);
#line 697
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 697
		{
#line 697
			/* not fatal to the loop */
#line 697
			status = lstatus;
#line 697
		}
#line 697

#line 697
		(void) ncio_rel(ncp->nciop, offset,
#line 697
				 RGN_MODIFIED);
#line 697

#line 697
		remaining -= extent;
#line 697
		if(remaining == 0)
#line 697
			break; /* normal loop exit */
#line 697
		offset += (off_t)extent;
#line 697
		value += nput;
#line 697

#line 697
	}
#line 697
#ifdef ERANGE_FILL
#line 697
        free(fillp);
#line 697
#endif
#line 697

#line 697
	return status;
#line 697
}
#line 697

static int
#line 698
putNCvx_schar_short(NC3_INFO* ncp, const NC_var *varp,
#line 698
		 const size_t *start, size_t nelems, const short *value)
#line 698
{
#line 698
	off_t offset = NC_varoffset(ncp, varp, start);
#line 698
	size_t remaining = varp->xsz * nelems;
#line 698
	int status = NC_NOERR;
#line 698
	void *xp;
#line 698
        void *fillp=NULL;
#line 698

#line 698
	NC_UNUSED(fillp);
#line 698

#line 698
	if(nelems == 0)
#line 698
		return NC_NOERR;
#line 698

#line 698
	assert(value != NULL);
#line 698

#line 698
#ifdef ERANGE_FILL
#line 698
        fillp = malloc(varp->xsz);
#line 698
        status = NC3_inq_var_fill(varp, fillp);
#line 698
#endif
#line 698

#line 698
	for(;;)
#line 698
	{
#line 698
		size_t extent = MIN(remaining, ncp->chunk);
#line 698
		size_t nput = ncx_howmany(varp->type, extent);
#line 698

#line 698
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 698
				 RGN_WRITE, &xp);
#line 698
		if(lstatus != NC_NOERR)
#line 698
			return lstatus;
#line 698

#line 698
		lstatus = ncx_putn_schar_short(&xp, nput, value ,fillp);
#line 698
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 698
		{
#line 698
			/* not fatal to the loop */
#line 698
			status = lstatus;
#line 698
		}
#line 698

#line 698
		(void) ncio_rel(ncp->nciop, offset,
#line 698
				 RGN_MODIFIED);
#line 698

#line 698
		remaining -= extent;
#line 698
		if(remaining == 0)
#line 698
			break; /* normal loop exit */
#line 698
		offset += (off_t)extent;
#line 698
		value += nput;
#line 698

#line 698
	}
#line 698
#ifdef ERANGE_FILL
#line 698
        free(fillp);
#line 698
#endif
#line 698

#line 698
	return status;
#line 698
}
#line 698

static int
#line 699
putNCvx_schar_int(NC3_INFO* ncp, const NC_var *varp,
#line 699
		 const size_t *start, size_t nelems, const int *value)
#line 699
{
#line 699
	off_t offset = NC_varoffset(ncp, varp, start);
#line 699
	size_t remaining = varp->xsz * nelems;
#line 699
	int status = NC_NOERR;
#line 699
	void *xp;
#line 699
        void *fillp=NULL;
#line 699

#line 699
	NC_UNUSED(fillp);
#line 699

#line 699
	if(nelems == 0)
#line 699
		return NC_NOERR;
#line 699

#line 699
	assert(value != NULL);
#line 699

#line 699
#ifdef ERANGE_FILL
#line 699
        fillp = malloc(varp->xsz);
#line 699
        status = NC3_inq_var_fill(varp, fillp);
#line 699
#endif
#line 699

#line 699
	for(;;)
#line 699
	{
#line 699
		size_t extent = MIN(remaining, ncp->chunk);
#line 699
		size_t nput = ncx_howmany(varp->type, extent);
#line 699

#line 699
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 699
				 RGN_WRITE, &xp);
#line 699
		if(lstatus != NC_NOERR)
#line 699
			return lstatus;
#line 699

#line 699
		lstatus = ncx_putn_schar_int(&xp, nput, value ,fillp);
#line 699
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 699
		{
#line 699
			/* not fatal to the loop */
#line 699
			status = lstatus;
#line 699
		}
#line 699

#line 699
		(void) ncio_rel(ncp->nciop, offset,
#line 699
				 RGN_MODIFIED);
#line 699

#line 699
		remaining -= extent;
#line 699
		if(remaining == 0)
#line 699
			break; /* normal loop exit */
#line 699
		offset += (off_t)extent;
#line 699
		value += nput;
#line 699

#line 699
	}
#line 699
#ifdef ERANGE_FILL
#line 699
        free(fillp);
#line 699
#endif
#line 699

#line 699
	return status;
#line 699
}
#line 699

static int
#line 700
putNCvx_schar_float(NC3_INFO* ncp, const NC_var *varp,
#line 700
		 const size_t *start, size_t nelems, const float *value)
#line 700
{
#line 700
	off_t offset = NC_varoffset(ncp, varp, start);
#line 700
	size_t remaining = varp->xsz * nelems;
#line 700
	int status = NC_NOERR;
#line 700
	void *xp;
#line 700
        void *fillp=NULL;
#line 700

#line 700
	NC_UNUSED(fillp);
#line 700

#line 700
	if(nelems == 0)
#line 700
		return NC_NOERR;
#line 700

#line 700
	assert(value != NULL);
#line 700

#line 700
#ifdef ERANGE_FILL
#line 700
        fillp = malloc(varp->xsz);
#line 700
        status = NC3_inq_var_fill(varp, fillp);
#line 700
#endif
#line 700

#line 700
	for(;;)
#line 700
	{
#line 700
		size_t extent = MIN(remaining, ncp->chunk);
#line 700
		size_t nput = ncx_howmany(varp->type, extent);
#line 700

#line 700
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 700
				 RGN_WRITE, &xp);
#line 700
		if(lstatus != NC_NOERR)
#line 700
			return lstatus;
#line 700

#line 700
		lstatus = ncx_putn_schar_float(&xp, nput, value ,fillp);
#line 700
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 700
		{
#line 700
			/* not fatal to the loop */
#line 700
			status = lstatus;
#line 700
		}
#line 700

#line 700
		(void) ncio_rel(ncp->nciop, offset,
#line 700
				 RGN_MODIFIED);
#line 700

#line 700
		remaining -= extent;
#line 700
		if(remaining == 0)
#line 700
			break; /* normal loop exit */
#line 700
		offset += (off_t)extent;
#line 700
		value += nput;
#line 700

#line 700
	}
#line 700
#ifdef ERANGE_FILL
#line 700
        free(fillp);
#line 700
#endif
#line 700

#line 700
	return status;
#line 700
}
#line 700

static int
#line 701
putNCvx_schar_double(NC3_INFO* ncp, const NC_var *varp,
#line 701
		 const size_t *start, size_t nelems, const double *value)
#line 701
{
#line 701
	off_t offset = NC_varoffset(ncp, varp, start);
#line 701
	size_t remaining = varp->xsz * nelems;
#line 701
	int status = NC_NOERR;
#line 701
	void *xp;
#line 701
        void *fillp=NULL;
#line 701

#line 701
	NC_UNUSED(fillp);
#line 701

#line 701
	if(nelems == 0)
#line 701
		return NC_NOERR;
#line 701

#line 701
	assert(value != NULL);
#line 701

#line 701
#ifdef ERANGE_FILL
#line 701
        fillp = malloc(varp->xsz);
#line 701
        status = NC3_inq_var_fill(varp, fillp);
#line 701
#endif
#line 701

#line 701
	for(;;)
#line 701
	{
#line 701
		size_t extent = MIN(remaining, ncp->chunk);
#line 701
		size_t nput = ncx_howmany(varp->type, extent);
#line 701

#line 701
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 701
				 RGN_WRITE, &xp);
#line 701
		if(lstatus != NC_NOERR)
#line 701
			return lstatus;
#line 701

#line 701
		lstatus = ncx_putn_schar_double(&xp, nput, value ,fillp);
#line 701
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 701
		{
#line 701
			/* not fatal to the loop */
#line 701
			status = lstatus;
#line 701
		}
#line 701

#line 701
		(void) ncio_rel(ncp->nciop, offset,
#line 701
				 RGN_MODIFIED);
#line 701

#line 701
		remaining -= extent;
#line 701
		if(remaining == 0)
#line 701
			break; /* normal loop exit */
#line 701
		offset += (off_t)extent;
#line 701
		value += nput;
#line 701

#line 701
	}
#line 701
#ifdef ERANGE_FILL
#line 701
        free(fillp);
#line 701
#endif
#line 701

#line 701
	return status;
#line 701
}
#line 701

static int
#line 702
putNCvx_schar_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 702
		 const size_t *start, size_t nelems, const longlong *value)
#line 702
{
#line 702
	off_t offset = NC_varoffset(ncp, varp, start);
#line 702
	size_t remaining = varp->xsz * nelems;
#line 702
	int status = NC_NOERR;
#line 702
	void *xp;
#line 702
        void *fillp=NULL;
#line 702

#line 702
	NC_UNUSED(fillp);
#line 702

#line 702
	if(nelems == 0)
#line 702
		return NC_NOERR;
#line 702

#line 702
	assert(value != NULL);
#line 702

#line 702
#ifdef ERANGE_FILL
#line 702
        fillp = malloc(varp->xsz);
#line 702
        status = NC3_inq_var_fill(varp, fillp);
#line 702
#endif
#line 702

#line 702
	for(;;)
#line 702
	{
#line 702
		size_t extent = MIN(remaining, ncp->chunk);
#line 702
		size_t nput = ncx_howmany(varp->type, extent);
#line 702

#line 702
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 702
				 RGN_WRITE, &xp);
#line 702
		if(lstatus != NC_NOERR)
#line 702
			return lstatus;
#line 702

#line 702
		lstatus = ncx_putn_schar_longlong(&xp, nput, value ,fillp);
#line 702
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 702
		{
#line 702
			/* not fatal to the loop */
#line 702
			status = lstatus;
#line 702
		}
#line 702

#line 702
		(void) ncio_rel(ncp->nciop, offset,
#line 702
				 RGN_MODIFIED);
#line 702

#line 702
		remaining -= extent;
#line 702
		if(remaining == 0)
#line 702
			break; /* normal loop exit */
#line 702
		offset += (off_t)extent;
#line 702
		value += nput;
#line 702

#line 702
	}
#line 702
#ifdef ERANGE_FILL
#line 702
        free(fillp);
#line 702
#endif
#line 702

#line 702
	return status;
#line 702
}
#line 702

static int
#line 703
putNCvx_schar_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 703
		 const size_t *start, size_t nelems, const ushort *value)
#line 703
{
#line 703
	off_t offset = NC_varoffset(ncp, varp, start);
#line 703
	size_t remaining = varp->xsz * nelems;
#line 703
	int status = NC_NOERR;
#line 703
	void *xp;
#line 703
        void *fillp=NULL;
#line 703

#line 703
	NC_UNUSED(fillp);
#line 703

#line 703
	if(nelems == 0)
#line 703
		return NC_NOERR;
#line 703

#line 703
	assert(value != NULL);
#line 703

#line 703
#ifdef ERANGE_FILL
#line 703
        fillp = malloc(varp->xsz);
#line 703
        status = NC3_inq_var_fill(varp, fillp);
#line 703
#endif
#line 703

#line 703
	for(;;)
#line 703
	{
#line 703
		size_t extent = MIN(remaining, ncp->chunk);
#line 703
		size_t nput = ncx_howmany(varp->type, extent);
#line 703

#line 703
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 703
				 RGN_WRITE, &xp);
#line 703
		if(lstatus != NC_NOERR)
#line 703
			return lstatus;
#line 703

#line 703
		lstatus = ncx_putn_schar_ushort(&xp, nput, value ,fillp);
#line 703
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 703
		{
#line 703
			/* not fatal to the loop */
#line 703
			status = lstatus;
#line 703
		}
#line 703

#line 703
		(void) ncio_rel(ncp->nciop, offset,
#line 703
				 RGN_MODIFIED);
#line 703

#line 703
		remaining -= extent;
#line 703
		if(remaining == 0)
#line 703
			break; /* normal loop exit */
#line 703
		offset += (off_t)extent;
#line 703
		value += nput;
#line 703

#line 703
	}
#line 703
#ifdef ERANGE_FILL
#line 703
        free(fillp);
#line 703
#endif
#line 703

#line 703
	return status;
#line 703
}
#line 703

static int
#line 704
putNCvx_schar_uint(NC3_INFO* ncp, const NC_var *varp,
#line 704
		 const size_t *start, size_t nelems, const uint *value)
#line 704
{
#line 704
	off_t offset = NC_varoffset(ncp, varp, start);
#line 704
	size_t remaining = varp->xsz * nelems;
#line 704
	int status = NC_NOERR;
#line 704
	void *xp;
#line 704
        void *fillp=NULL;
#line 704

#line 704
	NC_UNUSED(fillp);
#line 704

#line 704
	if(nelems == 0)
#line 704
		return NC_NOERR;
#line 704

#line 704
	assert(value != NULL);
#line 704

#line 704
#ifdef ERANGE_FILL
#line 704
        fillp = malloc(varp->xsz);
#line 704
        status = NC3_inq_var_fill(varp, fillp);
#line 704
#endif
#line 704

#line 704
	for(;;)
#line 704
	{
#line 704
		size_t extent = MIN(remaining, ncp->chunk);
#line 704
		size_t nput = ncx_howmany(varp->type, extent);
#line 704

#line 704
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 704
				 RGN_WRITE, &xp);
#line 704
		if(lstatus != NC_NOERR)
#line 704
			return lstatus;
#line 704

#line 704
		lstatus = ncx_putn_schar_uint(&xp, nput, value ,fillp);
#line 704
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 704
		{
#line 704
			/* not fatal to the loop */
#line 704
			status = lstatus;
#line 704
		}
#line 704

#line 704
		(void) ncio_rel(ncp->nciop, offset,
#line 704
				 RGN_MODIFIED);
#line 704

#line 704
		remaining -= extent;
#line 704
		if(remaining == 0)
#line 704
			break; /* normal loop exit */
#line 704
		offset += (off_t)extent;
#line 704
		value += nput;
#line 704

#line 704
	}
#line 704
#ifdef ERANGE_FILL
#line 704
        free(fillp);
#line 704
#endif
#line 704

#line 704
	return status;
#line 704
}
#line 704

static int
#line 705
putNCvx_schar_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 705
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 705
{
#line 705
	off_t offset = NC_varoffset(ncp, varp, start);
#line 705
	size_t remaining = varp->xsz * nelems;
#line 705
	int status = NC_NOERR;
#line 705
	void *xp;
#line 705
        void *fillp=NULL;
#line 705

#line 705
	NC_UNUSED(fillp);
#line 705

#line 705
	if(nelems == 0)
#line 705
		return NC_NOERR;
#line 705

#line 705
	assert(value != NULL);
#line 705

#line 705
#ifdef ERANGE_FILL
#line 705
        fillp = malloc(varp->xsz);
#line 705
        status = NC3_inq_var_fill(varp, fillp);
#line 705
#endif
#line 705

#line 705
	for(;;)
#line 705
	{
#line 705
		size_t extent = MIN(remaining, ncp->chunk);
#line 705
		size_t nput = ncx_howmany(varp->type, extent);
#line 705

#line 705
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 705
				 RGN_WRITE, &xp);
#line 705
		if(lstatus != NC_NOERR)
#line 705
			return lstatus;
#line 705

#line 705
		lstatus = ncx_putn_schar_ulonglong(&xp, nput, value ,fillp);
#line 705
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 705
		{
#line 705
			/* not fatal to the loop */
#line 705
			status = lstatus;
#line 705
		}
#line 705

#line 705
		(void) ncio_rel(ncp->nciop, offset,
#line 705
				 RGN_MODIFIED);
#line 705

#line 705
		remaining -= extent;
#line 705
		if(remaining == 0)
#line 705
			break; /* normal loop exit */
#line 705
		offset += (off_t)extent;
#line 705
		value += nput;
#line 705

#line 705
	}
#line 705
#ifdef ERANGE_FILL
#line 705
        free(fillp);
#line 705
#endif
#line 705

#line 705
	return status;
#line 705
}
#line 705


static int
#line 707
putNCvx_short_schar(NC3_INFO* ncp, const NC_var *varp,
#line 707
		 const size_t *start, size_t nelems, const schar *value)
#line 707
{
#line 707
	off_t offset = NC_varoffset(ncp, varp, start);
#line 707
	size_t remaining = varp->xsz * nelems;
#line 707
	int status = NC_NOERR;
#line 707
	void *xp;
#line 707
        void *fillp=NULL;
#line 707

#line 707
	NC_UNUSED(fillp);
#line 707

#line 707
	if(nelems == 0)
#line 707
		return NC_NOERR;
#line 707

#line 707
	assert(value != NULL);
#line 707

#line 707
#ifdef ERANGE_FILL
#line 707
        fillp = malloc(varp->xsz);
#line 707
        status = NC3_inq_var_fill(varp, fillp);
#line 707
#endif
#line 707

#line 707
	for(;;)
#line 707
	{
#line 707
		size_t extent = MIN(remaining, ncp->chunk);
#line 707
		size_t nput = ncx_howmany(varp->type, extent);
#line 707

#line 707
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 707
				 RGN_WRITE, &xp);
#line 707
		if(lstatus != NC_NOERR)
#line 707
			return lstatus;
#line 707

#line 707
		lstatus = ncx_putn_short_schar(&xp, nput, value ,fillp);
#line 707
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 707
		{
#line 707
			/* not fatal to the loop */
#line 707
			status = lstatus;
#line 707
		}
#line 707

#line 707
		(void) ncio_rel(ncp->nciop, offset,
#line 707
				 RGN_MODIFIED);
#line 707

#line 707
		remaining -= extent;
#line 707
		if(remaining == 0)
#line 707
			break; /* normal loop exit */
#line 707
		offset += (off_t)extent;
#line 707
		value += nput;
#line 707

#line 707
	}
#line 707
#ifdef ERANGE_FILL
#line 707
        free(fillp);
#line 707
#endif
#line 707

#line 707
	return status;
#line 707
}
#line 707

static int
#line 708
putNCvx_short_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 708
		 const size_t *start, size_t nelems, const uchar *value)
#line 708
{
#line 708
	off_t offset = NC_varoffset(ncp, varp, start);
#line 708
	size_t remaining = varp->xsz * nelems;
#line 708
	int status = NC_NOERR;
#line 708
	void *xp;
#line 708
        void *fillp=NULL;
#line 708

#line 708
	NC_UNUSED(fillp);
#line 708

#line 708
	if(nelems == 0)
#line 708
		return NC_NOERR;
#line 708

#line 708
	assert(value != NULL);
#line 708

#line 708
#ifdef ERANGE_FILL
#line 708
        fillp = malloc(varp->xsz);
#line 708
        status = NC3_inq_var_fill(varp, fillp);
#line 708
#endif
#line 708

#line 708
	for(;;)
#line 708
	{
#line 708
		size_t extent = MIN(remaining, ncp->chunk);
#line 708
		size_t nput = ncx_howmany(varp->type, extent);
#line 708

#line 708
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 708
				 RGN_WRITE, &xp);
#line 708
		if(lstatus != NC_NOERR)
#line 708
			return lstatus;
#line 708

#line 708
		lstatus = ncx_putn_short_uchar(&xp, nput, value ,fillp);
#line 708
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 708
		{
#line 708
			/* not fatal to the loop */
#line 708
			status = lstatus;
#line 708
		}
#line 708

#line 708
		(void) ncio_rel(ncp->nciop, offset,
#line 708
				 RGN_MODIFIED);
#line 708

#line 708
		remaining -= extent;
#line 708
		if(remaining == 0)
#line 708
			break; /* normal loop exit */
#line 708
		offset += (off_t)extent;
#line 708
		value += nput;
#line 708

#line 708
	}
#line 708
#ifdef ERANGE_FILL
#line 708
        free(fillp);
#line 708
#endif
#line 708

#line 708
	return status;
#line 708
}
#line 708

static int
#line 709
putNCvx_short_short(NC3_INFO* ncp, const NC_var *varp,
#line 709
		 const size_t *start, size_t nelems, const short *value)
#line 709
{
#line 709
	off_t offset = NC_varoffset(ncp, varp, start);
#line 709
	size_t remaining = varp->xsz * nelems;
#line 709
	int status = NC_NOERR;
#line 709
	void *xp;
#line 709
        void *fillp=NULL;
#line 709

#line 709
	NC_UNUSED(fillp);
#line 709

#line 709
	if(nelems == 0)
#line 709
		return NC_NOERR;
#line 709

#line 709
	assert(value != NULL);
#line 709

#line 709
#ifdef ERANGE_FILL
#line 709
        fillp = malloc(varp->xsz);
#line 709
        status = NC3_inq_var_fill(varp, fillp);
#line 709
#endif
#line 709

#line 709
	for(;;)
#line 709
	{
#line 709
		size_t extent = MIN(remaining, ncp->chunk);
#line 709
		size_t nput = ncx_howmany(varp->type, extent);
#line 709

#line 709
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 709
				 RGN_WRITE, &xp);
#line 709
		if(lstatus != NC_NOERR)
#line 709
			return lstatus;
#line 709

#line 709
		lstatus = ncx_putn_short_short(&xp, nput, value ,fillp);
#line 709
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 709
		{
#line 709
			/* not fatal to the loop */
#line 709
			status = lstatus;
#line 709
		}
#line 709

#line 709
		(void) ncio_rel(ncp->nciop, offset,
#line 709
				 RGN_MODIFIED);
#line 709

#line 709
		remaining -= extent;
#line 709
		if(remaining == 0)
#line 709
			break; /* normal loop exit */
#line 709
		offset += (off_t)extent;
#line 709
		value += nput;
#line 709

#line 709
	}
#line 709
#ifdef ERANGE_FILL
#line 709
        free(fillp);
#line 709
#endif
#line 709

#line 709
	return status;
#line 709
}
#line 709

static int
#line 710
putNCvx_short_int(NC3_INFO* ncp, const NC_var *varp,
#line 710
		 const size_t *start, size_t nelems, const int *value)
#line 710
{
#line 710
	off_t offset = NC_varoffset(ncp, varp, start);
#line 710
	size_t remaining = varp->xsz * nelems;
#line 710
	int status = NC_NOERR;
#line 710
	void *xp;
#line 710
        void *fillp=NULL;
#line 710

#line 710
	NC_UNUSED(fillp);
#line 710

#line 710
	if(nelems == 0)
#line 710
		return NC_NOERR;
#line 710

#line 710
	assert(value != NULL);
#line 710

#line 710
#ifdef ERANGE_FILL
#line 710
        fillp = malloc(varp->xsz);
#line 710
        status = NC3_inq_var_fill(varp, fillp);
#line 710
#endif
#line 710

#line 710
	for(;;)
#line 710
	{
#line 710
		size_t extent = MIN(remaining, ncp->chunk);
#line 710
		size_t nput = ncx_howmany(varp->type, extent);
#line 710

#line 710
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 710
				 RGN_WRITE, &xp);
#line 710
		if(lstatus != NC_NOERR)
#line 710
			return lstatus;
#line 710

#line 710
		lstatus = ncx_putn_short_int(&xp, nput, value ,fillp);
#line 710
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 710
		{
#line 710
			/* not fatal to the loop */
#line 710
			status = lstatus;
#line 710
		}
#line 710

#line 710
		(void) ncio_rel(ncp->nciop, offset,
#line 710
				 RGN_MODIFIED);
#line 710

#line 710
		remaining -= extent;
#line 710
		if(remaining == 0)
#line 710
			break; /* normal loop exit */
#line 710
		offset += (off_t)extent;
#line 710
		value += nput;
#line 710

#line 710
	}
#line 710
#ifdef ERANGE_FILL
#line 710
        free(fillp);
#line 710
#endif
#line 710

#line 710
	return status;
#line 710
}
#line 710

static int
#line 711
putNCvx_short_float(NC3_INFO* ncp, const NC_var *varp,
#line 711
		 const size_t *start, size_t nelems, const float *value)
#line 711
{
#line 711
	off_t offset = NC_varoffset(ncp, varp, start);
#line 711
	size_t remaining = varp->xsz * nelems;
#line 711
	int status = NC_NOERR;
#line 711
	void *xp;
#line 711
        void *fillp=NULL;
#line 711

#line 711
	NC_UNUSED(fillp);
#line 711

#line 711
	if(nelems == 0)
#line 711
		return NC_NOERR;
#line 711

#line 711
	assert(value != NULL);
#line 711

#line 711
#ifdef ERANGE_FILL
#line 711
        fillp = malloc(varp->xsz);
#line 711
        status = NC3_inq_var_fill(varp, fillp);
#line 711
#endif
#line 711

#line 711
	for(;;)
#line 711
	{
#line 711
		size_t extent = MIN(remaining, ncp->chunk);
#line 711
		size_t nput = ncx_howmany(varp->type, extent);
#line 711

#line 711
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 711
				 RGN_WRITE, &xp);
#line 711
		if(lstatus != NC_NOERR)
#line 711
			return lstatus;
#line 711

#line 711
		lstatus = ncx_putn_short_float(&xp, nput, value ,fillp);
#line 711
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 711
		{
#line 711
			/* not fatal to the loop */
#line 711
			status = lstatus;
#line 711
		}
#line 711

#line 711
		(void) ncio_rel(ncp->nciop, offset,
#line 711
				 RGN_MODIFIED);
#line 711

#line 711
		remaining -= extent;
#line 711
		if(remaining == 0)
#line 711
			break; /* normal loop exit */
#line 711
		offset += (off_t)extent;
#line 711
		value += nput;
#line 711

#line 711
	}
#line 711
#ifdef ERANGE_FILL
#line 711
        free(fillp);
#line 711
#endif
#line 711

#line 711
	return status;
#line 711
}
#line 711

static int
#line 712
putNCvx_short_double(NC3_INFO* ncp, const NC_var *varp,
#line 712
		 const size_t *start, size_t nelems, const double *value)
#line 712
{
#line 712
	off_t offset = NC_varoffset(ncp, varp, start);
#line 712
	size_t remaining = varp->xsz * nelems;
#line 712
	int status = NC_NOERR;
#line 712
	void *xp;
#line 712
        void *fillp=NULL;
#line 712

#line 712
	NC_UNUSED(fillp);
#line 712

#line 712
	if(nelems == 0)
#line 712
		return NC_NOERR;
#line 712

#line 712
	assert(value != NULL);
#line 712

#line 712
#ifdef ERANGE_FILL
#line 712
        fillp = malloc(varp->xsz);
#line 712
        status = NC3_inq_var_fill(varp, fillp);
#line 712
#endif
#line 712

#line 712
	for(;;)
#line 712
	{
#line 712
		size_t extent = MIN(remaining, ncp->chunk);
#line 712
		size_t nput = ncx_howmany(varp->type, extent);
#line 712

#line 712
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 712
				 RGN_WRITE, &xp);
#line 712
		if(lstatus != NC_NOERR)
#line 712
			return lstatus;
#line 712

#line 712
		lstatus = ncx_putn_short_double(&xp, nput, value ,fillp);
#line 712
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 712
		{
#line 712
			/* not fatal to the loop */
#line 712
			status = lstatus;
#line 712
		}
#line 712

#line 712
		(void) ncio_rel(ncp->nciop, offset,
#line 712
				 RGN_MODIFIED);
#line 712

#line 712
		remaining -= extent;
#line 712
		if(remaining == 0)
#line 712
			break; /* normal loop exit */
#line 712
		offset += (off_t)extent;
#line 712
		value += nput;
#line 712

#line 712
	}
#line 712
#ifdef ERANGE_FILL
#line 712
        free(fillp);
#line 712
#endif
#line 712

#line 712
	return status;
#line 712
}
#line 712

static int
#line 713
putNCvx_short_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 713
		 const size_t *start, size_t nelems, const longlong *value)
#line 713
{
#line 713
	off_t offset = NC_varoffset(ncp, varp, start);
#line 713
	size_t remaining = varp->xsz * nelems;
#line 713
	int status = NC_NOERR;
#line 713
	void *xp;
#line 713
        void *fillp=NULL;
#line 713

#line 713
	NC_UNUSED(fillp);
#line 713

#line 713
	if(nelems == 0)
#line 713
		return NC_NOERR;
#line 713

#line 713
	assert(value != NULL);
#line 713

#line 713
#ifdef ERANGE_FILL
#line 713
        fillp = malloc(varp->xsz);
#line 713
        status = NC3_inq_var_fill(varp, fillp);
#line 713
#endif
#line 713

#line 713
	for(;;)
#line 713
	{
#line 713
		size_t extent = MIN(remaining, ncp->chunk);
#line 713
		size_t nput = ncx_howmany(varp->type, extent);
#line 713

#line 713
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 713
				 RGN_WRITE, &xp);
#line 713
		if(lstatus != NC_NOERR)
#line 713
			return lstatus;
#line 713

#line 713
		lstatus = ncx_putn_short_longlong(&xp, nput, value ,fillp);
#line 713
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 713
		{
#line 713
			/* not fatal to the loop */
#line 713
			status = lstatus;
#line 713
		}
#line 713

#line 713
		(void) ncio_rel(ncp->nciop, offset,
#line 713
				 RGN_MODIFIED);
#line 713

#line 713
		remaining -= extent;
#line 713
		if(remaining == 0)
#line 713
			break; /* normal loop exit */
#line 713
		offset += (off_t)extent;
#line 713
		value += nput;
#line 713

#line 713
	}
#line 713
#ifdef ERANGE_FILL
#line 713
        free(fillp);
#line 713
#endif
#line 713

#line 713
	return status;
#line 713
}
#line 713

static int
#line 714
putNCvx_short_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 714
		 const size_t *start, size_t nelems, const ushort *value)
#line 714
{
#line 714
	off_t offset = NC_varoffset(ncp, varp, start);
#line 714
	size_t remaining = varp->xsz * nelems;
#line 714
	int status = NC_NOERR;
#line 714
	void *xp;
#line 714
        void *fillp=NULL;
#line 714

#line 714
	NC_UNUSED(fillp);
#line 714

#line 714
	if(nelems == 0)
#line 714
		return NC_NOERR;
#line 714

#line 714
	assert(value != NULL);
#line 714

#line 714
#ifdef ERANGE_FILL
#line 714
        fillp = malloc(varp->xsz);
#line 714
        status = NC3_inq_var_fill(varp, fillp);
#line 714
#endif
#line 714

#line 714
	for(;;)
#line 714
	{
#line 714
		size_t extent = MIN(remaining, ncp->chunk);
#line 714
		size_t nput = ncx_howmany(varp->type, extent);
#line 714

#line 714
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 714
				 RGN_WRITE, &xp);
#line 714
		if(lstatus != NC_NOERR)
#line 714
			return lstatus;
#line 714

#line 714
		lstatus = ncx_putn_short_ushort(&xp, nput, value ,fillp);
#line 714
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 714
		{
#line 714
			/* not fatal to the loop */
#line 714
			status = lstatus;
#line 714
		}
#line 714

#line 714
		(void) ncio_rel(ncp->nciop, offset,
#line 714
				 RGN_MODIFIED);
#line 714

#line 714
		remaining -= extent;
#line 714
		if(remaining == 0)
#line 714
			break; /* normal loop exit */
#line 714
		offset += (off_t)extent;
#line 714
		value += nput;
#line 714

#line 714
	}
#line 714
#ifdef ERANGE_FILL
#line 714
        free(fillp);
#line 714
#endif
#line 714

#line 714
	return status;
#line 714
}
#line 714

static int
#line 715
putNCvx_short_uint(NC3_INFO* ncp, const NC_var *varp,
#line 715
		 const size_t *start, size_t nelems, const uint *value)
#line 715
{
#line 715
	off_t offset = NC_varoffset(ncp, varp, start);
#line 715
	size_t remaining = varp->xsz * nelems;
#line 715
	int status = NC_NOERR;
#line 715
	void *xp;
#line 715
        void *fillp=NULL;
#line 715

#line 715
	NC_UNUSED(fillp);
#line 715

#line 715
	if(nelems == 0)
#line 715
		return NC_NOERR;
#line 715

#line 715
	assert(value != NULL);
#line 715

#line 715
#ifdef ERANGE_FILL
#line 715
        fillp = malloc(varp->xsz);
#line 715
        status = NC3_inq_var_fill(varp, fillp);
#line 715
#endif
#line 715

#line 715
	for(;;)
#line 715
	{
#line 715
		size_t extent = MIN(remaining, ncp->chunk);
#line 715
		size_t nput = ncx_howmany(varp->type, extent);
#line 715

#line 715
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 715
				 RGN_WRITE, &xp);
#line 715
		if(lstatus != NC_NOERR)
#line 715
			return lstatus;
#line 715

#line 715
		lstatus = ncx_putn_short_uint(&xp, nput, value ,fillp);
#line 715
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 715
		{
#line 715
			/* not fatal to the loop */
#line 715
			status = lstatus;
#line 715
		}
#line 715

#line 715
		(void) ncio_rel(ncp->nciop, offset,
#line 715
				 RGN_MODIFIED);
#line 715

#line 715
		remaining -= extent;
#line 715
		if(remaining == 0)
#line 715
			break; /* normal loop exit */
#line 715
		offset += (off_t)extent;
#line 715
		value += nput;
#line 715

#line 715
	}
#line 715
#ifdef ERANGE_FILL
#line 715
        free(fillp);
#line 715
#endif
#line 715

#line 715
	return status;
#line 715
}
#line 715

static int
#line 716
putNCvx_short_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 716
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 716
{
#line 716
	off_t offset = NC_varoffset(ncp, varp, start);
#line 716
	size_t remaining = varp->xsz * nelems;
#line 716
	int status = NC_NOERR;
#line 716
	void *xp;
#line 716
        void *fillp=NULL;
#line 716

#line 716
	NC_UNUSED(fillp);
#line 716

#line 716
	if(nelems == 0)
#line 716
		return NC_NOERR;
#line 716

#line 716
	assert(value != NULL);
#line 716

#line 716
#ifdef ERANGE_FILL
#line 716
        fillp = malloc(varp->xsz);
#line 716
        status = NC3_inq_var_fill(varp, fillp);
#line 716
#endif
#line 716

#line 716
	for(;;)
#line 716
	{
#line 716
		size_t extent = MIN(remaining, ncp->chunk);
#line 716
		size_t nput = ncx_howmany(varp->type, extent);
#line 716

#line 716
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 716
				 RGN_WRITE, &xp);
#line 716
		if(lstatus != NC_NOERR)
#line 716
			return lstatus;
#line 716

#line 716
		lstatus = ncx_putn_short_ulonglong(&xp, nput, value ,fillp);
#line 716
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 716
		{
#line 716
			/* not fatal to the loop */
#line 716
			status = lstatus;
#line 716
		}
#line 716

#line 716
		(void) ncio_rel(ncp->nciop, offset,
#line 716
				 RGN_MODIFIED);
#line 716

#line 716
		remaining -= extent;
#line 716
		if(remaining == 0)
#line 716
			break; /* normal loop exit */
#line 716
		offset += (off_t)extent;
#line 716
		value += nput;
#line 716

#line 716
	}
#line 716
#ifdef ERANGE_FILL
#line 716
        free(fillp);
#line 716
#endif
#line 716

#line 716
	return status;
#line 716
}
#line 716


static int
#line 718
putNCvx_int_schar(NC3_INFO* ncp, const NC_var *varp,
#line 718
		 const size_t *start, size_t nelems, const schar *value)
#line 718
{
#line 718
	off_t offset = NC_varoffset(ncp, varp, start);
#line 718
	size_t remaining = varp->xsz * nelems;
#line 718
	int status = NC_NOERR;
#line 718
	void *xp;
#line 718
        void *fillp=NULL;
#line 718

#line 718
	NC_UNUSED(fillp);
#line 718

#line 718
	if(nelems == 0)
#line 718
		return NC_NOERR;
#line 718

#line 718
	assert(value != NULL);
#line 718

#line 718
#ifdef ERANGE_FILL
#line 718
        fillp = malloc(varp->xsz);
#line 718
        status = NC3_inq_var_fill(varp, fillp);
#line 718
#endif
#line 718

#line 718
	for(;;)
#line 718
	{
#line 718
		size_t extent = MIN(remaining, ncp->chunk);
#line 718
		size_t nput = ncx_howmany(varp->type, extent);
#line 718

#line 718
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 718
				 RGN_WRITE, &xp);
#line 718
		if(lstatus != NC_NOERR)
#line 718
			return lstatus;
#line 718

#line 718
		lstatus = ncx_putn_int_schar(&xp, nput, value ,fillp);
#line 718
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 718
		{
#line 718
			/* not fatal to the loop */
#line 718
			status = lstatus;
#line 718
		}
#line 718

#line 718
		(void) ncio_rel(ncp->nciop, offset,
#line 718
				 RGN_MODIFIED);
#line 718

#line 718
		remaining -= extent;
#line 718
		if(remaining == 0)
#line 718
			break; /* normal loop exit */
#line 718
		offset += (off_t)extent;
#line 718
		value += nput;
#line 718

#line 718
	}
#line 718
#ifdef ERANGE_FILL
#line 718
        free(fillp);
#line 718
#endif
#line 718

#line 718
	return status;
#line 718
}
#line 718

static int
#line 719
putNCvx_int_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 719
		 const size_t *start, size_t nelems, const uchar *value)
#line 719
{
#line 719
	off_t offset = NC_varoffset(ncp, varp, start);
#line 719
	size_t remaining = varp->xsz * nelems;
#line 719
	int status = NC_NOERR;
#line 719
	void *xp;
#line 719
        void *fillp=NULL;
#line 719

#line 719
	NC_UNUSED(fillp);
#line 719

#line 719
	if(nelems == 0)
#line 719
		return NC_NOERR;
#line 719

#line 719
	assert(value != NULL);
#line 719

#line 719
#ifdef ERANGE_FILL
#line 719
        fillp = malloc(varp->xsz);
#line 719
        status = NC3_inq_var_fill(varp, fillp);
#line 719
#endif
#line 719

#line 719
	for(;;)
#line 719
	{
#line 719
		size_t extent = MIN(remaining, ncp->chunk);
#line 719
		size_t nput = ncx_howmany(varp->type, extent);
#line 719

#line 719
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 719
				 RGN_WRITE, &xp);
#line 719
		if(lstatus != NC_NOERR)
#line 719
			return lstatus;
#line 719

#line 719
		lstatus = ncx_putn_int_uchar(&xp, nput, value ,fillp);
#line 719
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 719
		{
#line 719
			/* not fatal to the loop */
#line 719
			status = lstatus;
#line 719
		}
#line 719

#line 719
		(void) ncio_rel(ncp->nciop, offset,
#line 719
				 RGN_MODIFIED);
#line 719

#line 719
		remaining -= extent;
#line 719
		if(remaining == 0)
#line 719
			break; /* normal loop exit */
#line 719
		offset += (off_t)extent;
#line 719
		value += nput;
#line 719

#line 719
	}
#line 719
#ifdef ERANGE_FILL
#line 719
        free(fillp);
#line 719
#endif
#line 719

#line 719
	return status;
#line 719
}
#line 719

static int
#line 720
putNCvx_int_short(NC3_INFO* ncp, const NC_var *varp,
#line 720
		 const size_t *start, size_t nelems, const short *value)
#line 720
{
#line 720
	off_t offset = NC_varoffset(ncp, varp, start);
#line 720
	size_t remaining = varp->xsz * nelems;
#line 720
	int status = NC_NOERR;
#line 720
	void *xp;
#line 720
        void *fillp=NULL;
#line 720

#line 720
	NC_UNUSED(fillp);
#line 720

#line 720
	if(nelems == 0)
#line 720
		return NC_NOERR;
#line 720

#line 720
	assert(value != NULL);
#line 720

#line 720
#ifdef ERANGE_FILL
#line 720
        fillp = malloc(varp->xsz);
#line 720
        status = NC3_inq_var_fill(varp, fillp);
#line 720
#endif
#line 720

#line 720
	for(;;)
#line 720
	{
#line 720
		size_t extent = MIN(remaining, ncp->chunk);
#line 720
		size_t nput = ncx_howmany(varp->type, extent);
#line 720

#line 720
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 720
				 RGN_WRITE, &xp);
#line 720
		if(lstatus != NC_NOERR)
#line 720
			return lstatus;
#line 720

#line 720
		lstatus = ncx_putn_int_short(&xp, nput, value ,fillp);
#line 720
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 720
		{
#line 720
			/* not fatal to the loop */
#line 720
			status = lstatus;
#line 720
		}
#line 720

#line 720
		(void) ncio_rel(ncp->nciop, offset,
#line 720
				 RGN_MODIFIED);
#line 720

#line 720
		remaining -= extent;
#line 720
		if(remaining == 0)
#line 720
			break; /* normal loop exit */
#line 720
		offset += (off_t)extent;
#line 720
		value += nput;
#line 720

#line 720
	}
#line 720
#ifdef ERANGE_FILL
#line 720
        free(fillp);
#line 720
#endif
#line 720

#line 720
	return status;
#line 720
}
#line 720

static int
#line 721
putNCvx_int_int(NC3_INFO* ncp, const NC_var *varp,
#line 721
		 const size_t *start, size_t nelems, const int *value)
#line 721
{
#line 721
	off_t offset = NC_varoffset(ncp, varp, start);
#line 721
	size_t remaining = varp->xsz * nelems;
#line 721
	int status = NC_NOERR;
#line 721
	void *xp;
#line 721
        void *fillp=NULL;
#line 721

#line 721
	NC_UNUSED(fillp);
#line 721

#line 721
	if(nelems == 0)
#line 721
		return NC_NOERR;
#line 721

#line 721
	assert(value != NULL);
#line 721

#line 721
#ifdef ERANGE_FILL
#line 721
        fillp = malloc(varp->xsz);
#line 721
        status = NC3_inq_var_fill(varp, fillp);
#line 721
#endif
#line 721

#line 721
	for(;;)
#line 721
	{
#line 721
		size_t extent = MIN(remaining, ncp->chunk);
#line 721
		size_t nput = ncx_howmany(varp->type, extent);
#line 721

#line 721
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 721
				 RGN_WRITE, &xp);
#line 721
		if(lstatus != NC_NOERR)
#line 721
			return lstatus;
#line 721

#line 721
		lstatus = ncx_putn_int_int(&xp, nput, value ,fillp);
#line 721
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 721
		{
#line 721
			/* not fatal to the loop */
#line 721
			status = lstatus;
#line 721
		}
#line 721

#line 721
		(void) ncio_rel(ncp->nciop, offset,
#line 721
				 RGN_MODIFIED);
#line 721

#line 721
		remaining -= extent;
#line 721
		if(remaining == 0)
#line 721
			break; /* normal loop exit */
#line 721
		offset += (off_t)extent;
#line 721
		value += nput;
#line 721

#line 721
	}
#line 721
#ifdef ERANGE_FILL
#line 721
        free(fillp);
#line 721
#endif
#line 721

#line 721
	return status;
#line 721
}
#line 721

static int
#line 722
putNCvx_int_float(NC3_INFO* ncp, const NC_var *varp,
#line 722
		 const size_t *start, size_t nelems, const float *value)
#line 722
{
#line 722
	off_t offset = NC_varoffset(ncp, varp, start);
#line 722
	size_t remaining = varp->xsz * nelems;
#line 722
	int status = NC_NOERR;
#line 722
	void *xp;
#line 722
        void *fillp=NULL;
#line 722

#line 722
	NC_UNUSED(fillp);
#line 722

#line 722
	if(nelems == 0)
#line 722
		return NC_NOERR;
#line 722

#line 722
	assert(value != NULL);
#line 722

#line 722
#ifdef ERANGE_FILL
#line 722
        fillp = malloc(varp->xsz);
#line 722
        status = NC3_inq_var_fill(varp, fillp);
#line 722
#endif
#line 722

#line 722
	for(;;)
#line 722
	{
#line 722
		size_t extent = MIN(remaining, ncp->chunk);
#line 722
		size_t nput = ncx_howmany(varp->type, extent);
#line 722

#line 722
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 722
				 RGN_WRITE, &xp);
#line 722
		if(lstatus != NC_NOERR)
#line 722
			return lstatus;
#line 722

#line 722
		lstatus = ncx_putn_int_float(&xp, nput, value ,fillp);
#line 722
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 722
		{
#line 722
			/* not fatal to the loop */
#line 722
			status = lstatus;
#line 722
		}
#line 722

#line 722
		(void) ncio_rel(ncp->nciop, offset,
#line 722
				 RGN_MODIFIED);
#line 722

#line 722
		remaining -= extent;
#line 722
		if(remaining == 0)
#line 722
			break; /* normal loop exit */
#line 722
		offset += (off_t)extent;
#line 722
		value += nput;
#line 722

#line 722
	}
#line 722
#ifdef ERANGE_FILL
#line 722
        free(fillp);
#line 722
#endif
#line 722

#line 722
	return status;
#line 722
}
#line 722

static int
#line 723
putNCvx_int_double(NC3_INFO* ncp, const NC_var *varp,
#line 723
		 const size_t *start, size_t nelems, const double *value)
#line 723
{
#line 723
	off_t offset = NC_varoffset(ncp, varp, start);
#line 723
	size_t remaining = varp->xsz * nelems;
#line 723
	int status = NC_NOERR;
#line 723
	void *xp;
#line 723
        void *fillp=NULL;
#line 723

#line 723
	NC_UNUSED(fillp);
#line 723

#line 723
	if(nelems == 0)
#line 723
		return NC_NOERR;
#line 723

#line 723
	assert(value != NULL);
#line 723

#line 723
#ifdef ERANGE_FILL
#line 723
        fillp = malloc(varp->xsz);
#line 723
        status = NC3_inq_var_fill(varp, fillp);
#line 723
#endif
#line 723

#line 723
	for(;;)
#line 723
	{
#line 723
		size_t extent = MIN(remaining, ncp->chunk);
#line 723
		size_t nput = ncx_howmany(varp->type, extent);
#line 723

#line 723
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 723
				 RGN_WRITE, &xp);
#line 723
		if(lstatus != NC_NOERR)
#line 723
			return lstatus;
#line 723

#line 723
		lstatus = ncx_putn_int_double(&xp, nput, value ,fillp);
#line 723
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 723
		{
#line 723
			/* not fatal to the loop */
#line 723
			status = lstatus;
#line 723
		}
#line 723

#line 723
		(void) ncio_rel(ncp->nciop, offset,
#line 723
				 RGN_MODIFIED);
#line 723

#line 723
		remaining -= extent;
#line 723
		if(remaining == 0)
#line 723
			break; /* normal loop exit */
#line 723
		offset += (off_t)extent;
#line 723
		value += nput;
#line 723

#line 723
	}
#line 723
#ifdef ERANGE_FILL
#line 723
        free(fillp);
#line 723
#endif
#line 723

#line 723
	return status;
#line 723
}
#line 723

static int
#line 724
putNCvx_int_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 724
		 const size_t *start, size_t nelems, const longlong *value)
#line 724
{
#line 724
	off_t offset = NC_varoffset(ncp, varp, start);
#line 724
	size_t remaining = varp->xsz * nelems;
#line 724
	int status = NC_NOERR;
#line 724
	void *xp;
#line 724
        void *fillp=NULL;
#line 724

#line 724
	NC_UNUSED(fillp);
#line 724

#line 724
	if(nelems == 0)
#line 724
		return NC_NOERR;
#line 724

#line 724
	assert(value != NULL);
#line 724

#line 724
#ifdef ERANGE_FILL
#line 724
        fillp = malloc(varp->xsz);
#line 724
        status = NC3_inq_var_fill(varp, fillp);
#line 724
#endif
#line 724

#line 724
	for(;;)
#line 724
	{
#line 724
		size_t extent = MIN(remaining, ncp->chunk);
#line 724
		size_t nput = ncx_howmany(varp->type, extent);
#line 724

#line 724
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 724
				 RGN_WRITE, &xp);
#line 724
		if(lstatus != NC_NOERR)
#line 724
			return lstatus;
#line 724

#line 724
		lstatus = ncx_putn_int_longlong(&xp, nput, value ,fillp);
#line 724
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 724
		{
#line 724
			/* not fatal to the loop */
#line 724
			status = lstatus;
#line 724
		}
#line 724

#line 724
		(void) ncio_rel(ncp->nciop, offset,
#line 724
				 RGN_MODIFIED);
#line 724

#line 724
		remaining -= extent;
#line 724
		if(remaining == 0)
#line 724
			break; /* normal loop exit */
#line 724
		offset += (off_t)extent;
#line 724
		value += nput;
#line 724

#line 724
	}
#line 724
#ifdef ERANGE_FILL
#line 724
        free(fillp);
#line 724
#endif
#line 724

#line 724
	return status;
#line 724
}
#line 724

static int
#line 725
putNCvx_int_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 725
		 const size_t *start, size_t nelems, const ushort *value)
#line 725
{
#line 725
	off_t offset = NC_varoffset(ncp, varp, start);
#line 725
	size_t remaining = varp->xsz * nelems;
#line 725
	int status = NC_NOERR;
#line 725
	void *xp;
#line 725
        void *fillp=NULL;
#line 725

#line 725
	NC_UNUSED(fillp);
#line 725

#line 725
	if(nelems == 0)
#line 725
		return NC_NOERR;
#line 725

#line 725
	assert(value != NULL);
#line 725

#line 725
#ifdef ERANGE_FILL
#line 725
        fillp = malloc(varp->xsz);
#line 725
        status = NC3_inq_var_fill(varp, fillp);
#line 725
#endif
#line 725

#line 725
	for(;;)
#line 725
	{
#line 725
		size_t extent = MIN(remaining, ncp->chunk);
#line 725
		size_t nput = ncx_howmany(varp->type, extent);
#line 725

#line 725
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 725
				 RGN_WRITE, &xp);
#line 725
		if(lstatus != NC_NOERR)
#line 725
			return lstatus;
#line 725

#line 725
		lstatus = ncx_putn_int_ushort(&xp, nput, value ,fillp);
#line 725
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 725
		{
#line 725
			/* not fatal to the loop */
#line 725
			status = lstatus;
#line 725
		}
#line 725

#line 725
		(void) ncio_rel(ncp->nciop, offset,
#line 725
				 RGN_MODIFIED);
#line 725

#line 725
		remaining -= extent;
#line 725
		if(remaining == 0)
#line 725
			break; /* normal loop exit */
#line 725
		offset += (off_t)extent;
#line 725
		value += nput;
#line 725

#line 725
	}
#line 725
#ifdef ERANGE_FILL
#line 725
        free(fillp);
#line 725
#endif
#line 725

#line 725
	return status;
#line 725
}
#line 725

static int
#line 726
putNCvx_int_uint(NC3_INFO* ncp, const NC_var *varp,
#line 726
		 const size_t *start, size_t nelems, const uint *value)
#line 726
{
#line 726
	off_t offset = NC_varoffset(ncp, varp, start);
#line 726
	size_t remaining = varp->xsz * nelems;
#line 726
	int status = NC_NOERR;
#line 726
	void *xp;
#line 726
        void *fillp=NULL;
#line 726

#line 726
	NC_UNUSED(fillp);
#line 726

#line 726
	if(nelems == 0)
#line 726
		return NC_NOERR;
#line 726

#line 726
	assert(value != NULL);
#line 726

#line 726
#ifdef ERANGE_FILL
#line 726
        fillp = malloc(varp->xsz);
#line 726
        status = NC3_inq_var_fill(varp, fillp);
#line 726
#endif
#line 726

#line 726
	for(;;)
#line 726
	{
#line 726
		size_t extent = MIN(remaining, ncp->chunk);
#line 726
		size_t nput = ncx_howmany(varp->type, extent);
#line 726

#line 726
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 726
				 RGN_WRITE, &xp);
#line 726
		if(lstatus != NC_NOERR)
#line 726
			return lstatus;
#line 726

#line 726
		lstatus = ncx_putn_int_uint(&xp, nput, value ,fillp);
#line 726
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 726
		{
#line 726
			/* not fatal to the loop */
#line 726
			status = lstatus;
#line 726
		}
#line 726

#line 726
		(void) ncio_rel(ncp->nciop, offset,
#line 726
				 RGN_MODIFIED);
#line 726

#line 726
		remaining -= extent;
#line 726
		if(remaining == 0)
#line 726
			break; /* normal loop exit */
#line 726
		offset += (off_t)extent;
#line 726
		value += nput;
#line 726

#line 726
	}
#line 726
#ifdef ERANGE_FILL
#line 726
        free(fillp);
#line 726
#endif
#line 726

#line 726
	return status;
#line 726
}
#line 726

static int
#line 727
putNCvx_int_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 727
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 727
{
#line 727
	off_t offset = NC_varoffset(ncp, varp, start);
#line 727
	size_t remaining = varp->xsz * nelems;
#line 727
	int status = NC_NOERR;
#line 727
	void *xp;
#line 727
        void *fillp=NULL;
#line 727

#line 727
	NC_UNUSED(fillp);
#line 727

#line 727
	if(nelems == 0)
#line 727
		return NC_NOERR;
#line 727

#line 727
	assert(value != NULL);
#line 727

#line 727
#ifdef ERANGE_FILL
#line 727
        fillp = malloc(varp->xsz);
#line 727
        status = NC3_inq_var_fill(varp, fillp);
#line 727
#endif
#line 727

#line 727
	for(;;)
#line 727
	{
#line 727
		size_t extent = MIN(remaining, ncp->chunk);
#line 727
		size_t nput = ncx_howmany(varp->type, extent);
#line 727

#line 727
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 727
				 RGN_WRITE, &xp);
#line 727
		if(lstatus != NC_NOERR)
#line 727
			return lstatus;
#line 727

#line 727
		lstatus = ncx_putn_int_ulonglong(&xp, nput, value ,fillp);
#line 727
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 727
		{
#line 727
			/* not fatal to the loop */
#line 727
			status = lstatus;
#line 727
		}
#line 727

#line 727
		(void) ncio_rel(ncp->nciop, offset,
#line 727
				 RGN_MODIFIED);
#line 727

#line 727
		remaining -= extent;
#line 727
		if(remaining == 0)
#line 727
			break; /* normal loop exit */
#line 727
		offset += (off_t)extent;
#line 727
		value += nput;
#line 727

#line 727
	}
#line 727
#ifdef ERANGE_FILL
#line 727
        free(fillp);
#line 727
#endif
#line 727

#line 727
	return status;
#line 727
}
#line 727


static int
#line 729
putNCvx_float_schar(NC3_INFO* ncp, const NC_var *varp,
#line 729
		 const size_t *start, size_t nelems, const schar *value)
#line 729
{
#line 729
	off_t offset = NC_varoffset(ncp, varp, start);
#line 729
	size_t remaining = varp->xsz * nelems;
#line 729
	int status = NC_NOERR;
#line 729
	void *xp;
#line 729
        void *fillp=NULL;
#line 729

#line 729
	NC_UNUSED(fillp);
#line 729

#line 729
	if(nelems == 0)
#line 729
		return NC_NOERR;
#line 729

#line 729
	assert(value != NULL);
#line 729

#line 729
#ifdef ERANGE_FILL
#line 729
        fillp = malloc(varp->xsz);
#line 729
        status = NC3_inq_var_fill(varp, fillp);
#line 729
#endif
#line 729

#line 729
	for(;;)
#line 729
	{
#line 729
		size_t extent = MIN(remaining, ncp->chunk);
#line 729
		size_t nput = ncx_howmany(varp->type, extent);
#line 729

#line 729
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 729
				 RGN_WRITE, &xp);
#line 729
		if(lstatus != NC_NOERR)
#line 729
			return lstatus;
#line 729

#line 729
		lstatus = ncx_putn_float_schar(&xp, nput, value ,fillp);
#line 729
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 729
		{
#line 729
			/* not fatal to the loop */
#line 729
			status = lstatus;
#line 729
		}
#line 729

#line 729
		(void) ncio_rel(ncp->nciop, offset,
#line 729
				 RGN_MODIFIED);
#line 729

#line 729
		remaining -= extent;
#line 729
		if(remaining == 0)
#line 729
			break; /* normal loop exit */
#line 729
		offset += (off_t)extent;
#line 729
		value += nput;
#line 729

#line 729
	}
#line 729
#ifdef ERANGE_FILL
#line 729
        free(fillp);
#line 729
#endif
#line 729

#line 729
	return status;
#line 729
}
#line 729

static int
#line 730
putNCvx_float_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 730
		 const size_t *start, size_t nelems, const uchar *value)
#line 730
{
#line 730
	off_t offset = NC_varoffset(ncp, varp, start);
#line 730
	size_t remaining = varp->xsz * nelems;
#line 730
	int status = NC_NOERR;
#line 730
	void *xp;
#line 730
        void *fillp=NULL;
#line 730

#line 730
	NC_UNUSED(fillp);
#line 730

#line 730
	if(nelems == 0)
#line 730
		return NC_NOERR;
#line 730

#line 730
	assert(value != NULL);
#line 730

#line 730
#ifdef ERANGE_FILL
#line 730
        fillp = malloc(varp->xsz);
#line 730
        status = NC3_inq_var_fill(varp, fillp);
#line 730
#endif
#line 730

#line 730
	for(;;)
#line 730
	{
#line 730
		size_t extent = MIN(remaining, ncp->chunk);
#line 730
		size_t nput = ncx_howmany(varp->type, extent);
#line 730

#line 730
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 730
				 RGN_WRITE, &xp);
#line 730
		if(lstatus != NC_NOERR)
#line 730
			return lstatus;
#line 730

#line 730
		lstatus = ncx_putn_float_uchar(&xp, nput, value ,fillp);
#line 730
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 730
		{
#line 730
			/* not fatal to the loop */
#line 730
			status = lstatus;
#line 730
		}
#line 730

#line 730
		(void) ncio_rel(ncp->nciop, offset,
#line 730
				 RGN_MODIFIED);
#line 730

#line 730
		remaining -= extent;
#line 730
		if(remaining == 0)
#line 730
			break; /* normal loop exit */
#line 730
		offset += (off_t)extent;
#line 730
		value += nput;
#line 730

#line 730
	}
#line 730
#ifdef ERANGE_FILL
#line 730
        free(fillp);
#line 730
#endif
#line 730

#line 730
	return status;
#line 730
}
#line 730

static int
#line 731
putNCvx_float_short(NC3_INFO* ncp, const NC_var *varp,
#line 731
		 const size_t *start, size_t nelems, const short *value)
#line 731
{
#line 731
	off_t offset = NC_varoffset(ncp, varp, start);
#line 731
	size_t remaining = varp->xsz * nelems;
#line 731
	int status = NC_NOERR;
#line 731
	void *xp;
#line 731
        void *fillp=NULL;
#line 731

#line 731
	NC_UNUSED(fillp);
#line 731

#line 731
	if(nelems == 0)
#line 731
		return NC_NOERR;
#line 731

#line 731
	assert(value != NULL);
#line 731

#line 731
#ifdef ERANGE_FILL
#line 731
        fillp = malloc(varp->xsz);
#line 731
        status = NC3_inq_var_fill(varp, fillp);
#line 731
#endif
#line 731

#line 731
	for(;;)
#line 731
	{
#line 731
		size_t extent = MIN(remaining, ncp->chunk);
#line 731
		size_t nput = ncx_howmany(varp->type, extent);
#line 731

#line 731
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 731
				 RGN_WRITE, &xp);
#line 731
		if(lstatus != NC_NOERR)
#line 731
			return lstatus;
#line 731

#line 731
		lstatus = ncx_putn_float_short(&xp, nput, value ,fillp);
#line 731
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 731
		{
#line 731
			/* not fatal to the loop */
#line 731
			status = lstatus;
#line 731
		}
#line 731

#line 731
		(void) ncio_rel(ncp->nciop, offset,
#line 731
				 RGN_MODIFIED);
#line 731

#line 731
		remaining -= extent;
#line 731
		if(remaining == 0)
#line 731
			break; /* normal loop exit */
#line 731
		offset += (off_t)extent;
#line 731
		value += nput;
#line 731

#line 731
	}
#line 731
#ifdef ERANGE_FILL
#line 731
        free(fillp);
#line 731
#endif
#line 731

#line 731
	return status;
#line 731
}
#line 731

static int
#line 732
putNCvx_float_int(NC3_INFO* ncp, const NC_var *varp,
#line 732
		 const size_t *start, size_t nelems, const int *value)
#line 732
{
#line 732
	off_t offset = NC_varoffset(ncp, varp, start);
#line 732
	size_t remaining = varp->xsz * nelems;
#line 732
	int status = NC_NOERR;
#line 732
	void *xp;
#line 732
        void *fillp=NULL;
#line 732

#line 732
	NC_UNUSED(fillp);
#line 732

#line 732
	if(nelems == 0)
#line 732
		return NC_NOERR;
#line 732

#line 732
	assert(value != NULL);
#line 732

#line 732
#ifdef ERANGE_FILL
#line 732
        fillp = malloc(varp->xsz);
#line 732
        status = NC3_inq_var_fill(varp, fillp);
#line 732
#endif
#line 732

#line 732
	for(;;)
#line 732
	{
#line 732
		size_t extent = MIN(remaining, ncp->chunk);
#line 732
		size_t nput = ncx_howmany(varp->type, extent);
#line 732

#line 732
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 732
				 RGN_WRITE, &xp);
#line 732
		if(lstatus != NC_NOERR)
#line 732
			return lstatus;
#line 732

#line 732
		lstatus = ncx_putn_float_int(&xp, nput, value ,fillp);
#line 732
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 732
		{
#line 732
			/* not fatal to the loop */
#line 732
			status = lstatus;
#line 732
		}
#line 732

#line 732
		(void) ncio_rel(ncp->nciop, offset,
#line 732
				 RGN_MODIFIED);
#line 732

#line 732
		remaining -= extent;
#line 732
		if(remaining == 0)
#line 732
			break; /* normal loop exit */
#line 732
		offset += (off_t)extent;
#line 732
		value += nput;
#line 732

#line 732
	}
#line 732
#ifdef ERANGE_FILL
#line 732
        free(fillp);
#line 732
#endif
#line 732

#line 732
	return status;
#line 732
}
#line 732

static int
#line 733
putNCvx_float_float(NC3_INFO* ncp, const NC_var *varp,
#line 733
		 const size_t *start, size_t nelems, const float *value)
#line 733
{
#line 733
	off_t offset = NC_varoffset(ncp, varp, start);
#line 733
	size_t remaining = varp->xsz * nelems;
#line 733
	int status = NC_NOERR;
#line 733
	void *xp;
#line 733
        void *fillp=NULL;
#line 733

#line 733
	NC_UNUSED(fillp);
#line 733

#line 733
	if(nelems == 0)
#line 733
		return NC_NOERR;
#line 733

#line 733
	assert(value != NULL);
#line 733

#line 733
#ifdef ERANGE_FILL
#line 733
        fillp = malloc(varp->xsz);
#line 733
        status = NC3_inq_var_fill(varp, fillp);
#line 733
#endif
#line 733

#line 733
	for(;;)
#line 733
	{
#line 733
		size_t extent = MIN(remaining, ncp->chunk);
#line 733
		size_t nput = ncx_howmany(varp->type, extent);
#line 733

#line 733
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 733
				 RGN_WRITE, &xp);
#line 733
		if(lstatus != NC_NOERR)
#line 733
			return lstatus;
#line 733

#line 733
		lstatus = ncx_putn_float_float(&xp, nput, value ,fillp);
#line 733
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 733
		{
#line 733
			/* not fatal to the loop */
#line 733
			status = lstatus;
#line 733
		}
#line 733

#line 733
		(void) ncio_rel(ncp->nciop, offset,
#line 733
				 RGN_MODIFIED);
#line 733

#line 733
		remaining -= extent;
#line 733
		if(remaining == 0)
#line 733
			break; /* normal loop exit */
#line 733
		offset += (off_t)extent;
#line 733
		value += nput;
#line 733

#line 733
	}
#line 733
#ifdef ERANGE_FILL
#line 733
        free(fillp);
#line 733
#endif
#line 733

#line 733
	return status;
#line 733
}
#line 733

static int
#line 734
putNCvx_float_double(NC3_INFO* ncp, const NC_var *varp,
#line 734
		 const size_t *start, size_t nelems, const double *value)
#line 734
{
#line 734
	off_t offset = NC_varoffset(ncp, varp, start);
#line 734
	size_t remaining = varp->xsz * nelems;
#line 734
	int status = NC_NOERR;
#line 734
	void *xp;
#line 734
        void *fillp=NULL;
#line 734

#line 734
	NC_UNUSED(fillp);
#line 734

#line 734
	if(nelems == 0)
#line 734
		return NC_NOERR;
#line 734

#line 734
	assert(value != NULL);
#line 734

#line 734
#ifdef ERANGE_FILL
#line 734
        fillp = malloc(varp->xsz);
#line 734
        status = NC3_inq_var_fill(varp, fillp);
#line 734
#endif
#line 734

#line 734
	for(;;)
#line 734
	{
#line 734
		size_t extent = MIN(remaining, ncp->chunk);
#line 734
		size_t nput = ncx_howmany(varp->type, extent);
#line 734

#line 734
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 734
				 RGN_WRITE, &xp);
#line 734
		if(lstatus != NC_NOERR)
#line 734
			return lstatus;
#line 734

#line 734
		lstatus = ncx_putn_float_double(&xp, nput, value ,fillp);
#line 734
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 734
		{
#line 734
			/* not fatal to the loop */
#line 734
			status = lstatus;
#line 734
		}
#line 734

#line 734
		(void) ncio_rel(ncp->nciop, offset,
#line 734
				 RGN_MODIFIED);
#line 734

#line 734
		remaining -= extent;
#line 734
		if(remaining == 0)
#line 734
			break; /* normal loop exit */
#line 734
		offset += (off_t)extent;
#line 734
		value += nput;
#line 734

#line 734
	}
#line 734
#ifdef ERANGE_FILL
#line 734
        free(fillp);
#line 734
#endif
#line 734

#line 734
	return status;
#line 734
}
#line 734

static int
#line 735
putNCvx_float_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 735
		 const size_t *start, size_t nelems, const longlong *value)
#line 735
{
#line 735
	off_t offset = NC_varoffset(ncp, varp, start);
#line 735
	size_t remaining = varp->xsz * nelems;
#line 735
	int status = NC_NOERR;
#line 735
	void *xp;
#line 735
        void *fillp=NULL;
#line 735

#line 735
	NC_UNUSED(fillp);
#line 735

#line 735
	if(nelems == 0)
#line 735
		return NC_NOERR;
#line 735

#line 735
	assert(value != NULL);
#line 735

#line 735
#ifdef ERANGE_FILL
#line 735
        fillp = malloc(varp->xsz);
#line 735
        status = NC3_inq_var_fill(varp, fillp);
#line 735
#endif
#line 735

#line 735
	for(;;)
#line 735
	{
#line 735
		size_t extent = MIN(remaining, ncp->chunk);
#line 735
		size_t nput = ncx_howmany(varp->type, extent);
#line 735

#line 735
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 735
				 RGN_WRITE, &xp);
#line 735
		if(lstatus != NC_NOERR)
#line 735
			return lstatus;
#line 735

#line 735
		lstatus = ncx_putn_float_longlong(&xp, nput, value ,fillp);
#line 735
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 735
		{
#line 735
			/* not fatal to the loop */
#line 735
			status = lstatus;
#line 735
		}
#line 735

#line 735
		(void) ncio_rel(ncp->nciop, offset,
#line 735
				 RGN_MODIFIED);
#line 735

#line 735
		remaining -= extent;
#line 735
		if(remaining == 0)
#line 735
			break; /* normal loop exit */
#line 735
		offset += (off_t)extent;
#line 735
		value += nput;
#line 735

#line 735
	}
#line 735
#ifdef ERANGE_FILL
#line 735
        free(fillp);
#line 735
#endif
#line 735

#line 735
	return status;
#line 735
}
#line 735

static int
#line 736
putNCvx_float_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 736
		 const size_t *start, size_t nelems, const ushort *value)
#line 736
{
#line 736
	off_t offset = NC_varoffset(ncp, varp, start);
#line 736
	size_t remaining = varp->xsz * nelems;
#line 736
	int status = NC_NOERR;
#line 736
	void *xp;
#line 736
        void *fillp=NULL;
#line 736

#line 736
	NC_UNUSED(fillp);
#line 736

#line 736
	if(nelems == 0)
#line 736
		return NC_NOERR;
#line 736

#line 736
	assert(value != NULL);
#line 736

#line 736
#ifdef ERANGE_FILL
#line 736
        fillp = malloc(varp->xsz);
#line 736
        status = NC3_inq_var_fill(varp, fillp);
#line 736
#endif
#line 736

#line 736
	for(;;)
#line 736
	{
#line 736
		size_t extent = MIN(remaining, ncp->chunk);
#line 736
		size_t nput = ncx_howmany(varp->type, extent);
#line 736

#line 736
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 736
				 RGN_WRITE, &xp);
#line 736
		if(lstatus != NC_NOERR)
#line 736
			return lstatus;
#line 736

#line 736
		lstatus = ncx_putn_float_ushort(&xp, nput, value ,fillp);
#line 736
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 736
		{
#line 736
			/* not fatal to the loop */
#line 736
			status = lstatus;
#line 736
		}
#line 736

#line 736
		(void) ncio_rel(ncp->nciop, offset,
#line 736
				 RGN_MODIFIED);
#line 736

#line 736
		remaining -= extent;
#line 736
		if(remaining == 0)
#line 736
			break; /* normal loop exit */
#line 736
		offset += (off_t)extent;
#line 736
		value += nput;
#line 736

#line 736
	}
#line 736
#ifdef ERANGE_FILL
#line 736
        free(fillp);
#line 736
#endif
#line 736

#line 736
	return status;
#line 736
}
#line 736

static int
#line 737
putNCvx_float_uint(NC3_INFO* ncp, const NC_var *varp,
#line 737
		 const size_t *start, size_t nelems, const uint *value)
#line 737
{
#line 737
	off_t offset = NC_varoffset(ncp, varp, start);
#line 737
	size_t remaining = varp->xsz * nelems;
#line 737
	int status = NC_NOERR;
#line 737
	void *xp;
#line 737
        void *fillp=NULL;
#line 737

#line 737
	NC_UNUSED(fillp);
#line 737

#line 737
	if(nelems == 0)
#line 737
		return NC_NOERR;
#line 737

#line 737
	assert(value != NULL);
#line 737

#line 737
#ifdef ERANGE_FILL
#line 737
        fillp = malloc(varp->xsz);
#line 737
        status = NC3_inq_var_fill(varp, fillp);
#line 737
#endif
#line 737

#line 737
	for(;;)
#line 737
	{
#line 737
		size_t extent = MIN(remaining, ncp->chunk);
#line 737
		size_t nput = ncx_howmany(varp->type, extent);
#line 737

#line 737
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 737
				 RGN_WRITE, &xp);
#line 737
		if(lstatus != NC_NOERR)
#line 737
			return lstatus;
#line 737

#line 737
		lstatus = ncx_putn_float_uint(&xp, nput, value ,fillp);
#line 737
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 737
		{
#line 737
			/* not fatal to the loop */
#line 737
			status = lstatus;
#line 737
		}
#line 737

#line 737
		(void) ncio_rel(ncp->nciop, offset,
#line 737
				 RGN_MODIFIED);
#line 737

#line 737
		remaining -= extent;
#line 737
		if(remaining == 0)
#line 737
			break; /* normal loop exit */
#line 737
		offset += (off_t)extent;
#line 737
		value += nput;
#line 737

#line 737
	}
#line 737
#ifdef ERANGE_FILL
#line 737
        free(fillp);
#line 737
#endif
#line 737

#line 737
	return status;
#line 737
}
#line 737

static int
#line 738
putNCvx_float_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 738
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 738
{
#line 738
	off_t offset = NC_varoffset(ncp, varp, start);
#line 738
	size_t remaining = varp->xsz * nelems;
#line 738
	int status = NC_NOERR;
#line 738
	void *xp;
#line 738
        void *fillp=NULL;
#line 738

#line 738
	NC_UNUSED(fillp);
#line 738

#line 738
	if(nelems == 0)
#line 738
		return NC_NOERR;
#line 738

#line 738
	assert(value != NULL);
#line 738

#line 738
#ifdef ERANGE_FILL
#line 738
        fillp = malloc(varp->xsz);
#line 738
        status = NC3_inq_var_fill(varp, fillp);
#line 738
#endif
#line 738

#line 738
	for(;;)
#line 738
	{
#line 738
		size_t extent = MIN(remaining, ncp->chunk);
#line 738
		size_t nput = ncx_howmany(varp->type, extent);
#line 738

#line 738
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 738
				 RGN_WRITE, &xp);
#line 738
		if(lstatus != NC_NOERR)
#line 738
			return lstatus;
#line 738

#line 738
		lstatus = ncx_putn_float_ulonglong(&xp, nput, value ,fillp);
#line 738
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 738
		{
#line 738
			/* not fatal to the loop */
#line 738
			status = lstatus;
#line 738
		}
#line 738

#line 738
		(void) ncio_rel(ncp->nciop, offset,
#line 738
				 RGN_MODIFIED);
#line 738

#line 738
		remaining -= extent;
#line 738
		if(remaining == 0)
#line 738
			break; /* normal loop exit */
#line 738
		offset += (off_t)extent;
#line 738
		value += nput;
#line 738

#line 738
	}
#line 738
#ifdef ERANGE_FILL
#line 738
        free(fillp);
#line 738
#endif
#line 738

#line 738
	return status;
#line 738
}
#line 738


static int
#line 740
putNCvx_double_schar(NC3_INFO* ncp, const NC_var *varp,
#line 740
		 const size_t *start, size_t nelems, const schar *value)
#line 740
{
#line 740
	off_t offset = NC_varoffset(ncp, varp, start);
#line 740
	size_t remaining = varp->xsz * nelems;
#line 740
	int status = NC_NOERR;
#line 740
	void *xp;
#line 740
        void *fillp=NULL;
#line 740

#line 740
	NC_UNUSED(fillp);
#line 740

#line 740
	if(nelems == 0)
#line 740
		return NC_NOERR;
#line 740

#line 740
	assert(value != NULL);
#line 740

#line 740
#ifdef ERANGE_FILL
#line 740
        fillp = malloc(varp->xsz);
#line 740
        status = NC3_inq_var_fill(varp, fillp);
#line 740
#endif
#line 740

#line 740
	for(;;)
#line 740
	{
#line 740
		size_t extent = MIN(remaining, ncp->chunk);
#line 740
		size_t nput = ncx_howmany(varp->type, extent);
#line 740

#line 740
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 740
				 RGN_WRITE, &xp);
#line 740
		if(lstatus != NC_NOERR)
#line 740
			return lstatus;
#line 740

#line 740
		lstatus = ncx_putn_double_schar(&xp, nput, value ,fillp);
#line 740
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 740
		{
#line 740
			/* not fatal to the loop */
#line 740
			status = lstatus;
#line 740
		}
#line 740

#line 740
		(void) ncio_rel(ncp->nciop, offset,
#line 740
				 RGN_MODIFIED);
#line 740

#line 740
		remaining -= extent;
#line 740
		if(remaining == 0)
#line 740
			break; /* normal loop exit */
#line 740
		offset += (off_t)extent;
#line 740
		value += nput;
#line 740

#line 740
	}
#line 740
#ifdef ERANGE_FILL
#line 740
        free(fillp);
#line 740
#endif
#line 740

#line 740
	return status;
#line 740
}
#line 740

static int
#line 741
putNCvx_double_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 741
		 const size_t *start, size_t nelems, const uchar *value)
#line 741
{
#line 741
	off_t offset = NC_varoffset(ncp, varp, start);
#line 741
	size_t remaining = varp->xsz * nelems;
#line 741
	int status = NC_NOERR;
#line 741
	void *xp;
#line 741
        void *fillp=NULL;
#line 741

#line 741
	NC_UNUSED(fillp);
#line 741

#line 741
	if(nelems == 0)
#line 741
		return NC_NOERR;
#line 741

#line 741
	assert(value != NULL);
#line 741

#line 741
#ifdef ERANGE_FILL
#line 741
        fillp = malloc(varp->xsz);
#line 741
        status = NC3_inq_var_fill(varp, fillp);
#line 741
#endif
#line 741

#line 741
	for(;;)
#line 741
	{
#line 741
		size_t extent = MIN(remaining, ncp->chunk);
#line 741
		size_t nput = ncx_howmany(varp->type, extent);
#line 741

#line 741
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 741
				 RGN_WRITE, &xp);
#line 741
		if(lstatus != NC_NOERR)
#line 741
			return lstatus;
#line 741

#line 741
		lstatus = ncx_putn_double_uchar(&xp, nput, value ,fillp);
#line 741
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 741
		{
#line 741
			/* not fatal to the loop */
#line 741
			status = lstatus;
#line 741
		}
#line 741

#line 741
		(void) ncio_rel(ncp->nciop, offset,
#line 741
				 RGN_MODIFIED);
#line 741

#line 741
		remaining -= extent;
#line 741
		if(remaining == 0)
#line 741
			break; /* normal loop exit */
#line 741
		offset += (off_t)extent;
#line 741
		value += nput;
#line 741

#line 741
	}
#line 741
#ifdef ERANGE_FILL
#line 741
        free(fillp);
#line 741
#endif
#line 741

#line 741
	return status;
#line 741
}
#line 741

static int
#line 742
putNCvx_double_short(NC3_INFO* ncp, const NC_var *varp,
#line 742
		 const size_t *start, size_t nelems, const short *value)
#line 742
{
#line 742
	off_t offset = NC_varoffset(ncp, varp, start);
#line 742
	size_t remaining = varp->xsz * nelems;
#line 742
	int status = NC_NOERR;
#line 742
	void *xp;
#line 742
        void *fillp=NULL;
#line 742

#line 742
	NC_UNUSED(fillp);
#line 742

#line 742
	if(nelems == 0)
#line 742
		return NC_NOERR;
#line 742

#line 742
	assert(value != NULL);
#line 742

#line 742
#ifdef ERANGE_FILL
#line 742
        fillp = malloc(varp->xsz);
#line 742
        status = NC3_inq_var_fill(varp, fillp);
#line 742
#endif
#line 742

#line 742
	for(;;)
#line 742
	{
#line 742
		size_t extent = MIN(remaining, ncp->chunk);
#line 742
		size_t nput = ncx_howmany(varp->type, extent);
#line 742

#line 742
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 742
				 RGN_WRITE, &xp);
#line 742
		if(lstatus != NC_NOERR)
#line 742
			return lstatus;
#line 742

#line 742
		lstatus = ncx_putn_double_short(&xp, nput, value ,fillp);
#line 742
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 742
		{
#line 742
			/* not fatal to the loop */
#line 742
			status = lstatus;
#line 742
		}
#line 742

#line 742
		(void) ncio_rel(ncp->nciop, offset,
#line 742
				 RGN_MODIFIED);
#line 742

#line 742
		remaining -= extent;
#line 742
		if(remaining == 0)
#line 742
			break; /* normal loop exit */
#line 742
		offset += (off_t)extent;
#line 742
		value += nput;
#line 742

#line 742
	}
#line 742
#ifdef ERANGE_FILL
#line 742
        free(fillp);
#line 742
#endif
#line 742

#line 742
	return status;
#line 742
}
#line 742

static int
#line 743
putNCvx_double_int(NC3_INFO* ncp, const NC_var *varp,
#line 743
		 const size_t *start, size_t nelems, const int *value)
#line 743
{
#line 743
	off_t offset = NC_varoffset(ncp, varp, start);
#line 743
	size_t remaining = varp->xsz * nelems;
#line 743
	int status = NC_NOERR;
#line 743
	void *xp;
#line 743
        void *fillp=NULL;
#line 743

#line 743
	NC_UNUSED(fillp);
#line 743

#line 743
	if(nelems == 0)
#line 743
		return NC_NOERR;
#line 743

#line 743
	assert(value != NULL);
#line 743

#line 743
#ifdef ERANGE_FILL
#line 743
        fillp = malloc(varp->xsz);
#line 743
        status = NC3_inq_var_fill(varp, fillp);
#line 743
#endif
#line 743

#line 743
	for(;;)
#line 743
	{
#line 743
		size_t extent = MIN(remaining, ncp->chunk);
#line 743
		size_t nput = ncx_howmany(varp->type, extent);
#line 743

#line 743
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 743
				 RGN_WRITE, &xp);
#line 743
		if(lstatus != NC_NOERR)
#line 743
			return lstatus;
#line 743

#line 743
		lstatus = ncx_putn_double_int(&xp, nput, value ,fillp);
#line 743
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 743
		{
#line 743
			/* not fatal to the loop */
#line 743
			status = lstatus;
#line 743
		}
#line 743

#line 743
		(void) ncio_rel(ncp->nciop, offset,
#line 743
				 RGN_MODIFIED);
#line 743

#line 743
		remaining -= extent;
#line 743
		if(remaining == 0)
#line 743
			break; /* normal loop exit */
#line 743
		offset += (off_t)extent;
#line 743
		value += nput;
#line 743

#line 743
	}
#line 743
#ifdef ERANGE_FILL
#line 743
        free(fillp);
#line 743
#endif
#line 743

#line 743
	return status;
#line 743
}
#line 743

static int
#line 744
putNCvx_double_float(NC3_INFO* ncp, const NC_var *varp,
#line 744
		 const size_t *start, size_t nelems, const float *value)
#line 744
{
#line 744
	off_t offset = NC_varoffset(ncp, varp, start);
#line 744
	size_t remaining = varp->xsz * nelems;
#line 744
	int status = NC_NOERR;
#line 744
	void *xp;
#line 744
        void *fillp=NULL;
#line 744

#line 744
	NC_UNUSED(fillp);
#line 744

#line 744
	if(nelems == 0)
#line 744
		return NC_NOERR;
#line 744

#line 744
	assert(value != NULL);
#line 744

#line 744
#ifdef ERANGE_FILL
#line 744
        fillp = malloc(varp->xsz);
#line 744
        status = NC3_inq_var_fill(varp, fillp);
#line 744
#endif
#line 744

#line 744
	for(;;)
#line 744
	{
#line 744
		size_t extent = MIN(remaining, ncp->chunk);
#line 744
		size_t nput = ncx_howmany(varp->type, extent);
#line 744

#line 744
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 744
				 RGN_WRITE, &xp);
#line 744
		if(lstatus != NC_NOERR)
#line 744
			return lstatus;
#line 744

#line 744
		lstatus = ncx_putn_double_float(&xp, nput, value ,fillp);
#line 744
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 744
		{
#line 744
			/* not fatal to the loop */
#line 744
			status = lstatus;
#line 744
		}
#line 744

#line 744
		(void) ncio_rel(ncp->nciop, offset,
#line 744
				 RGN_MODIFIED);
#line 744

#line 744
		remaining -= extent;
#line 744
		if(remaining == 0)
#line 744
			break; /* normal loop exit */
#line 744
		offset += (off_t)extent;
#line 744
		value += nput;
#line 744

#line 744
	}
#line 744
#ifdef ERANGE_FILL
#line 744
        free(fillp);
#line 744
#endif
#line 744

#line 744
	return status;
#line 744
}
#line 744

static int
#line 745
putNCvx_double_double(NC3_INFO* ncp, const NC_var *varp,
#line 745
		 const size_t *start, size_t nelems, const double *value)
#line 745
{
#line 745
	off_t offset = NC_varoffset(ncp, varp, start);
#line 745
	size_t remaining = varp->xsz * nelems;
#line 745
	int status = NC_NOERR;
#line 745
	void *xp;
#line 745
        void *fillp=NULL;
#line 745

#line 745
	NC_UNUSED(fillp);
#line 745

#line 745
	if(nelems == 0)
#line 745
		return NC_NOERR;
#line 745

#line 745
	assert(value != NULL);
#line 745

#line 745
#ifdef ERANGE_FILL
#line 745
        fillp = malloc(varp->xsz);
#line 745
        status = NC3_inq_var_fill(varp, fillp);
#line 745
#endif
#line 745

#line 745
	for(;;)
#line 745
	{
#line 745
		size_t extent = MIN(remaining, ncp->chunk);
#line 745
		size_t nput = ncx_howmany(varp->type, extent);
#line 745

#line 745
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 745
				 RGN_WRITE, &xp);
#line 745
		if(lstatus != NC_NOERR)
#line 745
			return lstatus;
#line 745

#line 745
		lstatus = ncx_putn_double_double(&xp, nput, value ,fillp);
#line 745
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 745
		{
#line 745
			/* not fatal to the loop */
#line 745
			status = lstatus;
#line 745
		}
#line 745

#line 745
		(void) ncio_rel(ncp->nciop, offset,
#line 745
				 RGN_MODIFIED);
#line 745

#line 745
		remaining -= extent;
#line 745
		if(remaining == 0)
#line 745
			break; /* normal loop exit */
#line 745
		offset += (off_t)extent;
#line 745
		value += nput;
#line 745

#line 745
	}
#line 745
#ifdef ERANGE_FILL
#line 745
        free(fillp);
#line 745
#endif
#line 745

#line 745
	return status;
#line 745
}
#line 745

static int
#line 746
putNCvx_double_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 746
		 const size_t *start, size_t nelems, const longlong *value)
#line 746
{
#line 746
	off_t offset = NC_varoffset(ncp, varp, start);
#line 746
	size_t remaining = varp->xsz * nelems;
#line 746
	int status = NC_NOERR;
#line 746
	void *xp;
#line 746
        void *fillp=NULL;
#line 746

#line 746
	NC_UNUSED(fillp);
#line 746

#line 746
	if(nelems == 0)
#line 746
		return NC_NOERR;
#line 746

#line 746
	assert(value != NULL);
#line 746

#line 746
#ifdef ERANGE_FILL
#line 746
        fillp = malloc(varp->xsz);
#line 746
        status = NC3_inq_var_fill(varp, fillp);
#line 746
#endif
#line 746

#line 746
	for(;;)
#line 746
	{
#line 746
		size_t extent = MIN(remaining, ncp->chunk);
#line 746
		size_t nput = ncx_howmany(varp->type, extent);
#line 746

#line 746
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 746
				 RGN_WRITE, &xp);
#line 746
		if(lstatus != NC_NOERR)
#line 746
			return lstatus;
#line 746

#line 746
		lstatus = ncx_putn_double_longlong(&xp, nput, value ,fillp);
#line 746
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 746
		{
#line 746
			/* not fatal to the loop */
#line 746
			status = lstatus;
#line 746
		}
#line 746

#line 746
		(void) ncio_rel(ncp->nciop, offset,
#line 746
				 RGN_MODIFIED);
#line 746

#line 746
		remaining -= extent;
#line 746
		if(remaining == 0)
#line 746
			break; /* normal loop exit */
#line 746
		offset += (off_t)extent;
#line 746
		value += nput;
#line 746

#line 746
	}
#line 746
#ifdef ERANGE_FILL
#line 746
        free(fillp);
#line 746
#endif
#line 746

#line 746
	return status;
#line 746
}
#line 746

static int
#line 747
putNCvx_double_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 747
		 const size_t *start, size_t nelems, const ushort *value)
#line 747
{
#line 747
	off_t offset = NC_varoffset(ncp, varp, start);
#line 747
	size_t remaining = varp->xsz * nelems;
#line 747
	int status = NC_NOERR;
#line 747
	void *xp;
#line 747
        void *fillp=NULL;
#line 747

#line 747
	NC_UNUSED(fillp);
#line 747

#line 747
	if(nelems == 0)
#line 747
		return NC_NOERR;
#line 747

#line 747
	assert(value != NULL);
#line 747

#line 747
#ifdef ERANGE_FILL
#line 747
        fillp = malloc(varp->xsz);
#line 747
        status = NC3_inq_var_fill(varp, fillp);
#line 747
#endif
#line 747

#line 747
	for(;;)
#line 747
	{
#line 747
		size_t extent = MIN(remaining, ncp->chunk);
#line 747
		size_t nput = ncx_howmany(varp->type, extent);
#line 747

#line 747
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 747
				 RGN_WRITE, &xp);
#line 747
		if(lstatus != NC_NOERR)
#line 747
			return lstatus;
#line 747

#line 747
		lstatus = ncx_putn_double_ushort(&xp, nput, value ,fillp);
#line 747
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 747
		{
#line 747
			/* not fatal to the loop */
#line 747
			status = lstatus;
#line 747
		}
#line 747

#line 747
		(void) ncio_rel(ncp->nciop, offset,
#line 747
				 RGN_MODIFIED);
#line 747

#line 747
		remaining -= extent;
#line 747
		if(remaining == 0)
#line 747
			break; /* normal loop exit */
#line 747
		offset += (off_t)extent;
#line 747
		value += nput;
#line 747

#line 747
	}
#line 747
#ifdef ERANGE_FILL
#line 747
        free(fillp);
#line 747
#endif
#line 747

#line 747
	return status;
#line 747
}
#line 747

static int
#line 748
putNCvx_double_uint(NC3_INFO* ncp, const NC_var *varp,
#line 748
		 const size_t *start, size_t nelems, const uint *value)
#line 748
{
#line 748
	off_t offset = NC_varoffset(ncp, varp, start);
#line 748
	size_t remaining = varp->xsz * nelems;
#line 748
	int status = NC_NOERR;
#line 748
	void *xp;
#line 748
        void *fillp=NULL;
#line 748

#line 748
	NC_UNUSED(fillp);
#line 748

#line 748
	if(nelems == 0)
#line 748
		return NC_NOERR;
#line 748

#line 748
	assert(value != NULL);
#line 748

#line 748
#ifdef ERANGE_FILL
#line 748
        fillp = malloc(varp->xsz);
#line 748
        status = NC3_inq_var_fill(varp, fillp);
#line 748
#endif
#line 748

#line 748
	for(;;)
#line 748
	{
#line 748
		size_t extent = MIN(remaining, ncp->chunk);
#line 748
		size_t nput = ncx_howmany(varp->type, extent);
#line 748

#line 748
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 748
				 RGN_WRITE, &xp);
#line 748
		if(lstatus != NC_NOERR)
#line 748
			return lstatus;
#line 748

#line 748
		lstatus = ncx_putn_double_uint(&xp, nput, value ,fillp);
#line 748
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 748
		{
#line 748
			/* not fatal to the loop */
#line 748
			status = lstatus;
#line 748
		}
#line 748

#line 748
		(void) ncio_rel(ncp->nciop, offset,
#line 748
				 RGN_MODIFIED);
#line 748

#line 748
		remaining -= extent;
#line 748
		if(remaining == 0)
#line 748
			break; /* normal loop exit */
#line 748
		offset += (off_t)extent;
#line 748
		value += nput;
#line 748

#line 748
	}
#line 748
#ifdef ERANGE_FILL
#line 748
        free(fillp);
#line 748
#endif
#line 748

#line 748
	return status;
#line 748
}
#line 748

static int
#line 749
putNCvx_double_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 749
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 749
{
#line 749
	off_t offset = NC_varoffset(ncp, varp, start);
#line 749
	size_t remaining = varp->xsz * nelems;
#line 749
	int status = NC_NOERR;
#line 749
	void *xp;
#line 749
        void *fillp=NULL;
#line 749

#line 749
	NC_UNUSED(fillp);
#line 749

#line 749
	if(nelems == 0)
#line 749
		return NC_NOERR;
#line 749

#line 749
	assert(value != NULL);
#line 749

#line 749
#ifdef ERANGE_FILL
#line 749
        fillp = malloc(varp->xsz);
#line 749
        status = NC3_inq_var_fill(varp, fillp);
#line 749
#endif
#line 749

#line 749
	for(;;)
#line 749
	{
#line 749
		size_t extent = MIN(remaining, ncp->chunk);
#line 749
		size_t nput = ncx_howmany(varp->type, extent);
#line 749

#line 749
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 749
				 RGN_WRITE, &xp);
#line 749
		if(lstatus != NC_NOERR)
#line 749
			return lstatus;
#line 749

#line 749
		lstatus = ncx_putn_double_ulonglong(&xp, nput, value ,fillp);
#line 749
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 749
		{
#line 749
			/* not fatal to the loop */
#line 749
			status = lstatus;
#line 749
		}
#line 749

#line 749
		(void) ncio_rel(ncp->nciop, offset,
#line 749
				 RGN_MODIFIED);
#line 749

#line 749
		remaining -= extent;
#line 749
		if(remaining == 0)
#line 749
			break; /* normal loop exit */
#line 749
		offset += (off_t)extent;
#line 749
		value += nput;
#line 749

#line 749
	}
#line 749
#ifdef ERANGE_FILL
#line 749
        free(fillp);
#line 749
#endif
#line 749

#line 749
	return status;
#line 749
}
#line 749


static int
#line 751
putNCvx_uchar_schar(NC3_INFO* ncp, const NC_var *varp,
#line 751
		 const size_t *start, size_t nelems, const schar *value)
#line 751
{
#line 751
	off_t offset = NC_varoffset(ncp, varp, start);
#line 751
	size_t remaining = varp->xsz * nelems;
#line 751
	int status = NC_NOERR;
#line 751
	void *xp;
#line 751
        void *fillp=NULL;
#line 751

#line 751
	NC_UNUSED(fillp);
#line 751

#line 751
	if(nelems == 0)
#line 751
		return NC_NOERR;
#line 751

#line 751
	assert(value != NULL);
#line 751

#line 751
#ifdef ERANGE_FILL
#line 751
        fillp = malloc(varp->xsz);
#line 751
        status = NC3_inq_var_fill(varp, fillp);
#line 751
#endif
#line 751

#line 751
	for(;;)
#line 751
	{
#line 751
		size_t extent = MIN(remaining, ncp->chunk);
#line 751
		size_t nput = ncx_howmany(varp->type, extent);
#line 751

#line 751
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 751
				 RGN_WRITE, &xp);
#line 751
		if(lstatus != NC_NOERR)
#line 751
			return lstatus;
#line 751

#line 751
		lstatus = ncx_putn_uchar_schar(&xp, nput, value ,fillp);
#line 751
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 751
		{
#line 751
			/* not fatal to the loop */
#line 751
			status = lstatus;
#line 751
		}
#line 751

#line 751
		(void) ncio_rel(ncp->nciop, offset,
#line 751
				 RGN_MODIFIED);
#line 751

#line 751
		remaining -= extent;
#line 751
		if(remaining == 0)
#line 751
			break; /* normal loop exit */
#line 751
		offset += (off_t)extent;
#line 751
		value += nput;
#line 751

#line 751
	}
#line 751
#ifdef ERANGE_FILL
#line 751
        free(fillp);
#line 751
#endif
#line 751

#line 751
	return status;
#line 751
}
#line 751

static int
#line 752
putNCvx_uchar_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 752
		 const size_t *start, size_t nelems, const uchar *value)
#line 752
{
#line 752
	off_t offset = NC_varoffset(ncp, varp, start);
#line 752
	size_t remaining = varp->xsz * nelems;
#line 752
	int status = NC_NOERR;
#line 752
	void *xp;
#line 752
        void *fillp=NULL;
#line 752

#line 752
	NC_UNUSED(fillp);
#line 752

#line 752
	if(nelems == 0)
#line 752
		return NC_NOERR;
#line 752

#line 752
	assert(value != NULL);
#line 752

#line 752
#ifdef ERANGE_FILL
#line 752
        fillp = malloc(varp->xsz);
#line 752
        status = NC3_inq_var_fill(varp, fillp);
#line 752
#endif
#line 752

#line 752
	for(;;)
#line 752
	{
#line 752
		size_t extent = MIN(remaining, ncp->chunk);
#line 752
		size_t nput = ncx_howmany(varp->type, extent);
#line 752

#line 752
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 752
				 RGN_WRITE, &xp);
#line 752
		if(lstatus != NC_NOERR)
#line 752
			return lstatus;
#line 752

#line 752
		lstatus = ncx_putn_uchar_uchar(&xp, nput, value ,fillp);
#line 752
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 752
		{
#line 752
			/* not fatal to the loop */
#line 752
			status = lstatus;
#line 752
		}
#line 752

#line 752
		(void) ncio_rel(ncp->nciop, offset,
#line 752
				 RGN_MODIFIED);
#line 752

#line 752
		remaining -= extent;
#line 752
		if(remaining == 0)
#line 752
			break; /* normal loop exit */
#line 752
		offset += (off_t)extent;
#line 752
		value += nput;
#line 752

#line 752
	}
#line 752
#ifdef ERANGE_FILL
#line 752
        free(fillp);
#line 752
#endif
#line 752

#line 752
	return status;
#line 752
}
#line 752

static int
#line 753
putNCvx_uchar_short(NC3_INFO* ncp, const NC_var *varp,
#line 753
		 const size_t *start, size_t nelems, const short *value)
#line 753
{
#line 753
	off_t offset = NC_varoffset(ncp, varp, start);
#line 753
	size_t remaining = varp->xsz * nelems;
#line 753
	int status = NC_NOERR;
#line 753
	void *xp;
#line 753
        void *fillp=NULL;
#line 753

#line 753
	NC_UNUSED(fillp);
#line 753

#line 753
	if(nelems == 0)
#line 753
		return NC_NOERR;
#line 753

#line 753
	assert(value != NULL);
#line 753

#line 753
#ifdef ERANGE_FILL
#line 753
        fillp = malloc(varp->xsz);
#line 753
        status = NC3_inq_var_fill(varp, fillp);
#line 753
#endif
#line 753

#line 753
	for(;;)
#line 753
	{
#line 753
		size_t extent = MIN(remaining, ncp->chunk);
#line 753
		size_t nput = ncx_howmany(varp->type, extent);
#line 753

#line 753
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 753
				 RGN_WRITE, &xp);
#line 753
		if(lstatus != NC_NOERR)
#line 753
			return lstatus;
#line 753

#line 753
		lstatus = ncx_putn_uchar_short(&xp, nput, value ,fillp);
#line 753
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 753
		{
#line 753
			/* not fatal to the loop */
#line 753
			status = lstatus;
#line 753
		}
#line 753

#line 753
		(void) ncio_rel(ncp->nciop, offset,
#line 753
				 RGN_MODIFIED);
#line 753

#line 753
		remaining -= extent;
#line 753
		if(remaining == 0)
#line 753
			break; /* normal loop exit */
#line 753
		offset += (off_t)extent;
#line 753
		value += nput;
#line 753

#line 753
	}
#line 753
#ifdef ERANGE_FILL
#line 753
        free(fillp);
#line 753
#endif
#line 753

#line 753
	return status;
#line 753
}
#line 753

static int
#line 754
putNCvx_uchar_int(NC3_INFO* ncp, const NC_var *varp,
#line 754
		 const size_t *start, size_t nelems, const int *value)
#line 754
{
#line 754
	off_t offset = NC_varoffset(ncp, varp, start);
#line 754
	size_t remaining = varp->xsz * nelems;
#line 754
	int status = NC_NOERR;
#line 754
	void *xp;
#line 754
        void *fillp=NULL;
#line 754

#line 754
	NC_UNUSED(fillp);
#line 754

#line 754
	if(nelems == 0)
#line 754
		return NC_NOERR;
#line 754

#line 754
	assert(value != NULL);
#line 754

#line 754
#ifdef ERANGE_FILL
#line 754
        fillp = malloc(varp->xsz);
#line 754
        status = NC3_inq_var_fill(varp, fillp);
#line 754
#endif
#line 754

#line 754
	for(;;)
#line 754
	{
#line 754
		size_t extent = MIN(remaining, ncp->chunk);
#line 754
		size_t nput = ncx_howmany(varp->type, extent);
#line 754

#line 754
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 754
				 RGN_WRITE, &xp);
#line 754
		if(lstatus != NC_NOERR)
#line 754
			return lstatus;
#line 754

#line 754
		lstatus = ncx_putn_uchar_int(&xp, nput, value ,fillp);
#line 754
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 754
		{
#line 754
			/* not fatal to the loop */
#line 754
			status = lstatus;
#line 754
		}
#line 754

#line 754
		(void) ncio_rel(ncp->nciop, offset,
#line 754
				 RGN_MODIFIED);
#line 754

#line 754
		remaining -= extent;
#line 754
		if(remaining == 0)
#line 754
			break; /* normal loop exit */
#line 754
		offset += (off_t)extent;
#line 754
		value += nput;
#line 754

#line 754
	}
#line 754
#ifdef ERANGE_FILL
#line 754
        free(fillp);
#line 754
#endif
#line 754

#line 754
	return status;
#line 754
}
#line 754

static int
#line 755
putNCvx_uchar_float(NC3_INFO* ncp, const NC_var *varp,
#line 755
		 const size_t *start, size_t nelems, const float *value)
#line 755
{
#line 755
	off_t offset = NC_varoffset(ncp, varp, start);
#line 755
	size_t remaining = varp->xsz * nelems;
#line 755
	int status = NC_NOERR;
#line 755
	void *xp;
#line 755
        void *fillp=NULL;
#line 755

#line 755
	NC_UNUSED(fillp);
#line 755

#line 755
	if(nelems == 0)
#line 755
		return NC_NOERR;
#line 755

#line 755
	assert(value != NULL);
#line 755

#line 755
#ifdef ERANGE_FILL
#line 755
        fillp = malloc(varp->xsz);
#line 755
        status = NC3_inq_var_fill(varp, fillp);
#line 755
#endif
#line 755

#line 755
	for(;;)
#line 755
	{
#line 755
		size_t extent = MIN(remaining, ncp->chunk);
#line 755
		size_t nput = ncx_howmany(varp->type, extent);
#line 755

#line 755
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 755
				 RGN_WRITE, &xp);
#line 755
		if(lstatus != NC_NOERR)
#line 755
			return lstatus;
#line 755

#line 755
		lstatus = ncx_putn_uchar_float(&xp, nput, value ,fillp);
#line 755
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 755
		{
#line 755
			/* not fatal to the loop */
#line 755
			status = lstatus;
#line 755
		}
#line 755

#line 755
		(void) ncio_rel(ncp->nciop, offset,
#line 755
				 RGN_MODIFIED);
#line 755

#line 755
		remaining -= extent;
#line 755
		if(remaining == 0)
#line 755
			break; /* normal loop exit */
#line 755
		offset += (off_t)extent;
#line 755
		value += nput;
#line 755

#line 755
	}
#line 755
#ifdef ERANGE_FILL
#line 755
        free(fillp);
#line 755
#endif
#line 755

#line 755
	return status;
#line 755
}
#line 755

static int
#line 756
putNCvx_uchar_double(NC3_INFO* ncp, const NC_var *varp,
#line 756
		 const size_t *start, size_t nelems, const double *value)
#line 756
{
#line 756
	off_t offset = NC_varoffset(ncp, varp, start);
#line 756
	size_t remaining = varp->xsz * nelems;
#line 756
	int status = NC_NOERR;
#line 756
	void *xp;
#line 756
        void *fillp=NULL;
#line 756

#line 756
	NC_UNUSED(fillp);
#line 756

#line 756
	if(nelems == 0)
#line 756
		return NC_NOERR;
#line 756

#line 756
	assert(value != NULL);
#line 756

#line 756
#ifdef ERANGE_FILL
#line 756
        fillp = malloc(varp->xsz);
#line 756
        status = NC3_inq_var_fill(varp, fillp);
#line 756
#endif
#line 756

#line 756
	for(;;)
#line 756
	{
#line 756
		size_t extent = MIN(remaining, ncp->chunk);
#line 756
		size_t nput = ncx_howmany(varp->type, extent);
#line 756

#line 756
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 756
				 RGN_WRITE, &xp);
#line 756
		if(lstatus != NC_NOERR)
#line 756
			return lstatus;
#line 756

#line 756
		lstatus = ncx_putn_uchar_double(&xp, nput, value ,fillp);
#line 756
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 756
		{
#line 756
			/* not fatal to the loop */
#line 756
			status = lstatus;
#line 756
		}
#line 756

#line 756
		(void) ncio_rel(ncp->nciop, offset,
#line 756
				 RGN_MODIFIED);
#line 756

#line 756
		remaining -= extent;
#line 756
		if(remaining == 0)
#line 756
			break; /* normal loop exit */
#line 756
		offset += (off_t)extent;
#line 756
		value += nput;
#line 756

#line 756
	}
#line 756
#ifdef ERANGE_FILL
#line 756
        free(fillp);
#line 756
#endif
#line 756

#line 756
	return status;
#line 756
}
#line 756

static int
#line 757
putNCvx_uchar_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 757
		 const size_t *start, size_t nelems, const longlong *value)
#line 757
{
#line 757
	off_t offset = NC_varoffset(ncp, varp, start);
#line 757
	size_t remaining = varp->xsz * nelems;
#line 757
	int status = NC_NOERR;
#line 757
	void *xp;
#line 757
        void *fillp=NULL;
#line 757

#line 757
	NC_UNUSED(fillp);
#line 757

#line 757
	if(nelems == 0)
#line 757
		return NC_NOERR;
#line 757

#line 757
	assert(value != NULL);
#line 757

#line 757
#ifdef ERANGE_FILL
#line 757
        fillp = malloc(varp->xsz);
#line 757
        status = NC3_inq_var_fill(varp, fillp);
#line 757
#endif
#line 757

#line 757
	for(;;)
#line 757
	{
#line 757
		size_t extent = MIN(remaining, ncp->chunk);
#line 757
		size_t nput = ncx_howmany(varp->type, extent);
#line 757

#line 757
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 757
				 RGN_WRITE, &xp);
#line 757
		if(lstatus != NC_NOERR)
#line 757
			return lstatus;
#line 757

#line 757
		lstatus = ncx_putn_uchar_longlong(&xp, nput, value ,fillp);
#line 757
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 757
		{
#line 757
			/* not fatal to the loop */
#line 757
			status = lstatus;
#line 757
		}
#line 757

#line 757
		(void) ncio_rel(ncp->nciop, offset,
#line 757
				 RGN_MODIFIED);
#line 757

#line 757
		remaining -= extent;
#line 757
		if(remaining == 0)
#line 757
			break; /* normal loop exit */
#line 757
		offset += (off_t)extent;
#line 757
		value += nput;
#line 757

#line 757
	}
#line 757
#ifdef ERANGE_FILL
#line 757
        free(fillp);
#line 757
#endif
#line 757

#line 757
	return status;
#line 757
}
#line 757

static int
#line 758
putNCvx_uchar_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 758
		 const size_t *start, size_t nelems, const ushort *value)
#line 758
{
#line 758
	off_t offset = NC_varoffset(ncp, varp, start);
#line 758
	size_t remaining = varp->xsz * nelems;
#line 758
	int status = NC_NOERR;
#line 758
	void *xp;
#line 758
        void *fillp=NULL;
#line 758

#line 758
	NC_UNUSED(fillp);
#line 758

#line 758
	if(nelems == 0)
#line 758
		return NC_NOERR;
#line 758

#line 758
	assert(value != NULL);
#line 758

#line 758
#ifdef ERANGE_FILL
#line 758
        fillp = malloc(varp->xsz);
#line 758
        status = NC3_inq_var_fill(varp, fillp);
#line 758
#endif
#line 758

#line 758
	for(;;)
#line 758
	{
#line 758
		size_t extent = MIN(remaining, ncp->chunk);
#line 758
		size_t nput = ncx_howmany(varp->type, extent);
#line 758

#line 758
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 758
				 RGN_WRITE, &xp);
#line 758
		if(lstatus != NC_NOERR)
#line 758
			return lstatus;
#line 758

#line 758
		lstatus = ncx_putn_uchar_ushort(&xp, nput, value ,fillp);
#line 758
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 758
		{
#line 758
			/* not fatal to the loop */
#line 758
			status = lstatus;
#line 758
		}
#line 758

#line 758
		(void) ncio_rel(ncp->nciop, offset,
#line 758
				 RGN_MODIFIED);
#line 758

#line 758
		remaining -= extent;
#line 758
		if(remaining == 0)
#line 758
			break; /* normal loop exit */
#line 758
		offset += (off_t)extent;
#line 758
		value += nput;
#line 758

#line 758
	}
#line 758
#ifdef ERANGE_FILL
#line 758
        free(fillp);
#line 758
#endif
#line 758

#line 758
	return status;
#line 758
}
#line 758

static int
#line 759
putNCvx_uchar_uint(NC3_INFO* ncp, const NC_var *varp,
#line 759
		 const size_t *start, size_t nelems, const uint *value)
#line 759
{
#line 759
	off_t offset = NC_varoffset(ncp, varp, start);
#line 759
	size_t remaining = varp->xsz * nelems;
#line 759
	int status = NC_NOERR;
#line 759
	void *xp;
#line 759
        void *fillp=NULL;
#line 759

#line 759
	NC_UNUSED(fillp);
#line 759

#line 759
	if(nelems == 0)
#line 759
		return NC_NOERR;
#line 759

#line 759
	assert(value != NULL);
#line 759

#line 759
#ifdef ERANGE_FILL
#line 759
        fillp = malloc(varp->xsz);
#line 759
        status = NC3_inq_var_fill(varp, fillp);
#line 759
#endif
#line 759

#line 759
	for(;;)
#line 759
	{
#line 759
		size_t extent = MIN(remaining, ncp->chunk);
#line 759
		size_t nput = ncx_howmany(varp->type, extent);
#line 759

#line 759
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 759
				 RGN_WRITE, &xp);
#line 759
		if(lstatus != NC_NOERR)
#line 759
			return lstatus;
#line 759

#line 759
		lstatus = ncx_putn_uchar_uint(&xp, nput, value ,fillp);
#line 759
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 759
		{
#line 759
			/* not fatal to the loop */
#line 759
			status = lstatus;
#line 759
		}
#line 759

#line 759
		(void) ncio_rel(ncp->nciop, offset,
#line 759
				 RGN_MODIFIED);
#line 759

#line 759
		remaining -= extent;
#line 759
		if(remaining == 0)
#line 759
			break; /* normal loop exit */
#line 759
		offset += (off_t)extent;
#line 759
		value += nput;
#line 759

#line 759
	}
#line 759
#ifdef ERANGE_FILL
#line 759
        free(fillp);
#line 759
#endif
#line 759

#line 759
	return status;
#line 759
}
#line 759

static int
#line 760
putNCvx_uchar_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 760
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 760
{
#line 760
	off_t offset = NC_varoffset(ncp, varp, start);
#line 760
	size_t remaining = varp->xsz * nelems;
#line 760
	int status = NC_NOERR;
#line 760
	void *xp;
#line 760
        void *fillp=NULL;
#line 760

#line 760
	NC_UNUSED(fillp);
#line 760

#line 760
	if(nelems == 0)
#line 760
		return NC_NOERR;
#line 760

#line 760
	assert(value != NULL);
#line 760

#line 760
#ifdef ERANGE_FILL
#line 760
        fillp = malloc(varp->xsz);
#line 760
        status = NC3_inq_var_fill(varp, fillp);
#line 760
#endif
#line 760

#line 760
	for(;;)
#line 760
	{
#line 760
		size_t extent = MIN(remaining, ncp->chunk);
#line 760
		size_t nput = ncx_howmany(varp->type, extent);
#line 760

#line 760
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 760
				 RGN_WRITE, &xp);
#line 760
		if(lstatus != NC_NOERR)
#line 760
			return lstatus;
#line 760

#line 760
		lstatus = ncx_putn_uchar_ulonglong(&xp, nput, value ,fillp);
#line 760
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 760
		{
#line 760
			/* not fatal to the loop */
#line 760
			status = lstatus;
#line 760
		}
#line 760

#line 760
		(void) ncio_rel(ncp->nciop, offset,
#line 760
				 RGN_MODIFIED);
#line 760

#line 760
		remaining -= extent;
#line 760
		if(remaining == 0)
#line 760
			break; /* normal loop exit */
#line 760
		offset += (off_t)extent;
#line 760
		value += nput;
#line 760

#line 760
	}
#line 760
#ifdef ERANGE_FILL
#line 760
        free(fillp);
#line 760
#endif
#line 760

#line 760
	return status;
#line 760
}
#line 760


static int
#line 762
putNCvx_ushort_schar(NC3_INFO* ncp, const NC_var *varp,
#line 762
		 const size_t *start, size_t nelems, const schar *value)
#line 762
{
#line 762
	off_t offset = NC_varoffset(ncp, varp, start);
#line 762
	size_t remaining = varp->xsz * nelems;
#line 762
	int status = NC_NOERR;
#line 762
	void *xp;
#line 762
        void *fillp=NULL;
#line 762

#line 762
	NC_UNUSED(fillp);
#line 762

#line 762
	if(nelems == 0)
#line 762
		return NC_NOERR;
#line 762

#line 762
	assert(value != NULL);
#line 762

#line 762
#ifdef ERANGE_FILL
#line 762
        fillp = malloc(varp->xsz);
#line 762
        status = NC3_inq_var_fill(varp, fillp);
#line 762
#endif
#line 762

#line 762
	for(;;)
#line 762
	{
#line 762
		size_t extent = MIN(remaining, ncp->chunk);
#line 762
		size_t nput = ncx_howmany(varp->type, extent);
#line 762

#line 762
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 762
				 RGN_WRITE, &xp);
#line 762
		if(lstatus != NC_NOERR)
#line 762
			return lstatus;
#line 762

#line 762
		lstatus = ncx_putn_ushort_schar(&xp, nput, value ,fillp);
#line 762
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 762
		{
#line 762
			/* not fatal to the loop */
#line 762
			status = lstatus;
#line 762
		}
#line 762

#line 762
		(void) ncio_rel(ncp->nciop, offset,
#line 762
				 RGN_MODIFIED);
#line 762

#line 762
		remaining -= extent;
#line 762
		if(remaining == 0)
#line 762
			break; /* normal loop exit */
#line 762
		offset += (off_t)extent;
#line 762
		value += nput;
#line 762

#line 762
	}
#line 762
#ifdef ERANGE_FILL
#line 762
        free(fillp);
#line 762
#endif
#line 762

#line 762
	return status;
#line 762
}
#line 762

static int
#line 763
putNCvx_ushort_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 763
		 const size_t *start, size_t nelems, const uchar *value)
#line 763
{
#line 763
	off_t offset = NC_varoffset(ncp, varp, start);
#line 763
	size_t remaining = varp->xsz * nelems;
#line 763
	int status = NC_NOERR;
#line 763
	void *xp;
#line 763
        void *fillp=NULL;
#line 763

#line 763
	NC_UNUSED(fillp);
#line 763

#line 763
	if(nelems == 0)
#line 763
		return NC_NOERR;
#line 763

#line 763
	assert(value != NULL);
#line 763

#line 763
#ifdef ERANGE_FILL
#line 763
        fillp = malloc(varp->xsz);
#line 763
        status = NC3_inq_var_fill(varp, fillp);
#line 763
#endif
#line 763

#line 763
	for(;;)
#line 763
	{
#line 763
		size_t extent = MIN(remaining, ncp->chunk);
#line 763
		size_t nput = ncx_howmany(varp->type, extent);
#line 763

#line 763
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 763
				 RGN_WRITE, &xp);
#line 763
		if(lstatus != NC_NOERR)
#line 763
			return lstatus;
#line 763

#line 763
		lstatus = ncx_putn_ushort_uchar(&xp, nput, value ,fillp);
#line 763
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 763
		{
#line 763
			/* not fatal to the loop */
#line 763
			status = lstatus;
#line 763
		}
#line 763

#line 763
		(void) ncio_rel(ncp->nciop, offset,
#line 763
				 RGN_MODIFIED);
#line 763

#line 763
		remaining -= extent;
#line 763
		if(remaining == 0)
#line 763
			break; /* normal loop exit */
#line 763
		offset += (off_t)extent;
#line 763
		value += nput;
#line 763

#line 763
	}
#line 763
#ifdef ERANGE_FILL
#line 763
        free(fillp);
#line 763
#endif
#line 763

#line 763
	return status;
#line 763
}
#line 763

static int
#line 764
putNCvx_ushort_short(NC3_INFO* ncp, const NC_var *varp,
#line 764
		 const size_t *start, size_t nelems, const short *value)
#line 764
{
#line 764
	off_t offset = NC_varoffset(ncp, varp, start);
#line 764
	size_t remaining = varp->xsz * nelems;
#line 764
	int status = NC_NOERR;
#line 764
	void *xp;
#line 764
        void *fillp=NULL;
#line 764

#line 764
	NC_UNUSED(fillp);
#line 764

#line 764
	if(nelems == 0)
#line 764
		return NC_NOERR;
#line 764

#line 764
	assert(value != NULL);
#line 764

#line 764
#ifdef ERANGE_FILL
#line 764
        fillp = malloc(varp->xsz);
#line 764
        status = NC3_inq_var_fill(varp, fillp);
#line 764
#endif
#line 764

#line 764
	for(;;)
#line 764
	{
#line 764
		size_t extent = MIN(remaining, ncp->chunk);
#line 764
		size_t nput = ncx_howmany(varp->type, extent);
#line 764

#line 764
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 764
				 RGN_WRITE, &xp);
#line 764
		if(lstatus != NC_NOERR)
#line 764
			return lstatus;
#line 764

#line 764
		lstatus = ncx_putn_ushort_short(&xp, nput, value ,fillp);
#line 764
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 764
		{
#line 764
			/* not fatal to the loop */
#line 764
			status = lstatus;
#line 764
		}
#line 764

#line 764
		(void) ncio_rel(ncp->nciop, offset,
#line 764
				 RGN_MODIFIED);
#line 764

#line 764
		remaining -= extent;
#line 764
		if(remaining == 0)
#line 764
			break; /* normal loop exit */
#line 764
		offset += (off_t)extent;
#line 764
		value += nput;
#line 764

#line 764
	}
#line 764
#ifdef ERANGE_FILL
#line 764
        free(fillp);
#line 764
#endif
#line 764

#line 764
	return status;
#line 764
}
#line 764

static int
#line 765
putNCvx_ushort_int(NC3_INFO* ncp, const NC_var *varp,
#line 765
		 const size_t *start, size_t nelems, const int *value)
#line 765
{
#line 765
	off_t offset = NC_varoffset(ncp, varp, start);
#line 765
	size_t remaining = varp->xsz * nelems;
#line 765
	int status = NC_NOERR;
#line 765
	void *xp;
#line 765
        void *fillp=NULL;
#line 765

#line 765
	NC_UNUSED(fillp);
#line 765

#line 765
	if(nelems == 0)
#line 765
		return NC_NOERR;
#line 765

#line 765
	assert(value != NULL);
#line 765

#line 765
#ifdef ERANGE_FILL
#line 765
        fillp = malloc(varp->xsz);
#line 765
        status = NC3_inq_var_fill(varp, fillp);
#line 765
#endif
#line 765

#line 765
	for(;;)
#line 765
	{
#line 765
		size_t extent = MIN(remaining, ncp->chunk);
#line 765
		size_t nput = ncx_howmany(varp->type, extent);
#line 765

#line 765
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 765
				 RGN_WRITE, &xp);
#line 765
		if(lstatus != NC_NOERR)
#line 765
			return lstatus;
#line 765

#line 765
		lstatus = ncx_putn_ushort_int(&xp, nput, value ,fillp);
#line 765
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 765
		{
#line 765
			/* not fatal to the loop */
#line 765
			status = lstatus;
#line 765
		}
#line 765

#line 765
		(void) ncio_rel(ncp->nciop, offset,
#line 765
				 RGN_MODIFIED);
#line 765

#line 765
		remaining -= extent;
#line 765
		if(remaining == 0)
#line 765
			break; /* normal loop exit */
#line 765
		offset += (off_t)extent;
#line 765
		value += nput;
#line 765

#line 765
	}
#line 765
#ifdef ERANGE_FILL
#line 765
        free(fillp);
#line 765
#endif
#line 765

#line 765
	return status;
#line 765
}
#line 765

static int
#line 766
putNCvx_ushort_float(NC3_INFO* ncp, const NC_var *varp,
#line 766
		 const size_t *start, size_t nelems, const float *value)
#line 766
{
#line 766
	off_t offset = NC_varoffset(ncp, varp, start);
#line 766
	size_t remaining = varp->xsz * nelems;
#line 766
	int status = NC_NOERR;
#line 766
	void *xp;
#line 766
        void *fillp=NULL;
#line 766

#line 766
	NC_UNUSED(fillp);
#line 766

#line 766
	if(nelems == 0)
#line 766
		return NC_NOERR;
#line 766

#line 766
	assert(value != NULL);
#line 766

#line 766
#ifdef ERANGE_FILL
#line 766
        fillp = malloc(varp->xsz);
#line 766
        status = NC3_inq_var_fill(varp, fillp);
#line 766
#endif
#line 766

#line 766
	for(;;)
#line 766
	{
#line 766
		size_t extent = MIN(remaining, ncp->chunk);
#line 766
		size_t nput = ncx_howmany(varp->type, extent);
#line 766

#line 766
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 766
				 RGN_WRITE, &xp);
#line 766
		if(lstatus != NC_NOERR)
#line 766
			return lstatus;
#line 766

#line 766
		lstatus = ncx_putn_ushort_float(&xp, nput, value ,fillp);
#line 766
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 766
		{
#line 766
			/* not fatal to the loop */
#line 766
			status = lstatus;
#line 766
		}
#line 766

#line 766
		(void) ncio_rel(ncp->nciop, offset,
#line 766
				 RGN_MODIFIED);
#line 766

#line 766
		remaining -= extent;
#line 766
		if(remaining == 0)
#line 766
			break; /* normal loop exit */
#line 766
		offset += (off_t)extent;
#line 766
		value += nput;
#line 766

#line 766
	}
#line 766
#ifdef ERANGE_FILL
#line 766
        free(fillp);
#line 766
#endif
#line 766

#line 766
	return status;
#line 766
}
#line 766

static int
#line 767
putNCvx_ushort_double(NC3_INFO* ncp, const NC_var *varp,
#line 767
		 const size_t *start, size_t nelems, const double *value)
#line 767
{
#line 767
	off_t offset = NC_varoffset(ncp, varp, start);
#line 767
	size_t remaining = varp->xsz * nelems;
#line 767
	int status = NC_NOERR;
#line 767
	void *xp;
#line 767
        void *fillp=NULL;
#line 767

#line 767
	NC_UNUSED(fillp);
#line 767

#line 767
	if(nelems == 0)
#line 767
		return NC_NOERR;
#line 767

#line 767
	assert(value != NULL);
#line 767

#line 767
#ifdef ERANGE_FILL
#line 767
        fillp = malloc(varp->xsz);
#line 767
        status = NC3_inq_var_fill(varp, fillp);
#line 767
#endif
#line 767

#line 767
	for(;;)
#line 767
	{
#line 767
		size_t extent = MIN(remaining, ncp->chunk);
#line 767
		size_t nput = ncx_howmany(varp->type, extent);
#line 767

#line 767
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 767
				 RGN_WRITE, &xp);
#line 767
		if(lstatus != NC_NOERR)
#line 767
			return lstatus;
#line 767

#line 767
		lstatus = ncx_putn_ushort_double(&xp, nput, value ,fillp);
#line 767
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 767
		{
#line 767
			/* not fatal to the loop */
#line 767
			status = lstatus;
#line 767
		}
#line 767

#line 767
		(void) ncio_rel(ncp->nciop, offset,
#line 767
				 RGN_MODIFIED);
#line 767

#line 767
		remaining -= extent;
#line 767
		if(remaining == 0)
#line 767
			break; /* normal loop exit */
#line 767
		offset += (off_t)extent;
#line 767
		value += nput;
#line 767

#line 767
	}
#line 767
#ifdef ERANGE_FILL
#line 767
        free(fillp);
#line 767
#endif
#line 767

#line 767
	return status;
#line 767
}
#line 767

static int
#line 768
putNCvx_ushort_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 768
		 const size_t *start, size_t nelems, const longlong *value)
#line 768
{
#line 768
	off_t offset = NC_varoffset(ncp, varp, start);
#line 768
	size_t remaining = varp->xsz * nelems;
#line 768
	int status = NC_NOERR;
#line 768
	void *xp;
#line 768
        void *fillp=NULL;
#line 768

#line 768
	NC_UNUSED(fillp);
#line 768

#line 768
	if(nelems == 0)
#line 768
		return NC_NOERR;
#line 768

#line 768
	assert(value != NULL);
#line 768

#line 768
#ifdef ERANGE_FILL
#line 768
        fillp = malloc(varp->xsz);
#line 768
        status = NC3_inq_var_fill(varp, fillp);
#line 768
#endif
#line 768

#line 768
	for(;;)
#line 768
	{
#line 768
		size_t extent = MIN(remaining, ncp->chunk);
#line 768
		size_t nput = ncx_howmany(varp->type, extent);
#line 768

#line 768
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 768
				 RGN_WRITE, &xp);
#line 768
		if(lstatus != NC_NOERR)
#line 768
			return lstatus;
#line 768

#line 768
		lstatus = ncx_putn_ushort_longlong(&xp, nput, value ,fillp);
#line 768
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 768
		{
#line 768
			/* not fatal to the loop */
#line 768
			status = lstatus;
#line 768
		}
#line 768

#line 768
		(void) ncio_rel(ncp->nciop, offset,
#line 768
				 RGN_MODIFIED);
#line 768

#line 768
		remaining -= extent;
#line 768
		if(remaining == 0)
#line 768
			break; /* normal loop exit */
#line 768
		offset += (off_t)extent;
#line 768
		value += nput;
#line 768

#line 768
	}
#line 768
#ifdef ERANGE_FILL
#line 768
        free(fillp);
#line 768
#endif
#line 768

#line 768
	return status;
#line 768
}
#line 768

static int
#line 769
putNCvx_ushort_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 769
		 const size_t *start, size_t nelems, const ushort *value)
#line 769
{
#line 769
	off_t offset = NC_varoffset(ncp, varp, start);
#line 769
	size_t remaining = varp->xsz * nelems;
#line 769
	int status = NC_NOERR;
#line 769
	void *xp;
#line 769
        void *fillp=NULL;
#line 769

#line 769
	NC_UNUSED(fillp);
#line 769

#line 769
	if(nelems == 0)
#line 769
		return NC_NOERR;
#line 769

#line 769
	assert(value != NULL);
#line 769

#line 769
#ifdef ERANGE_FILL
#line 769
        fillp = malloc(varp->xsz);
#line 769
        status = NC3_inq_var_fill(varp, fillp);
#line 769
#endif
#line 769

#line 769
	for(;;)
#line 769
	{
#line 769
		size_t extent = MIN(remaining, ncp->chunk);
#line 769
		size_t nput = ncx_howmany(varp->type, extent);
#line 769

#line 769
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 769
				 RGN_WRITE, &xp);
#line 769
		if(lstatus != NC_NOERR)
#line 769
			return lstatus;
#line 769

#line 769
		lstatus = ncx_putn_ushort_ushort(&xp, nput, value ,fillp);
#line 769
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 769
		{
#line 769
			/* not fatal to the loop */
#line 769
			status = lstatus;
#line 769
		}
#line 769

#line 769
		(void) ncio_rel(ncp->nciop, offset,
#line 769
				 RGN_MODIFIED);
#line 769

#line 769
		remaining -= extent;
#line 769
		if(remaining == 0)
#line 769
			break; /* normal loop exit */
#line 769
		offset += (off_t)extent;
#line 769
		value += nput;
#line 769

#line 769
	}
#line 769
#ifdef ERANGE_FILL
#line 769
        free(fillp);
#line 769
#endif
#line 769

#line 769
	return status;
#line 769
}
#line 769

static int
#line 770
putNCvx_ushort_uint(NC3_INFO* ncp, const NC_var *varp,
#line 770
		 const size_t *start, size_t nelems, const uint *value)
#line 770
{
#line 770
	off_t offset = NC_varoffset(ncp, varp, start);
#line 770
	size_t remaining = varp->xsz * nelems;
#line 770
	int status = NC_NOERR;
#line 770
	void *xp;
#line 770
        void *fillp=NULL;
#line 770

#line 770
	NC_UNUSED(fillp);
#line 770

#line 770
	if(nelems == 0)
#line 770
		return NC_NOERR;
#line 770

#line 770
	assert(value != NULL);
#line 770

#line 770
#ifdef ERANGE_FILL
#line 770
        fillp = malloc(varp->xsz);
#line 770
        status = NC3_inq_var_fill(varp, fillp);
#line 770
#endif
#line 770

#line 770
	for(;;)
#line 770
	{
#line 770
		size_t extent = MIN(remaining, ncp->chunk);
#line 770
		size_t nput = ncx_howmany(varp->type, extent);
#line 770

#line 770
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 770
				 RGN_WRITE, &xp);
#line 770
		if(lstatus != NC_NOERR)
#line 770
			return lstatus;
#line 770

#line 770
		lstatus = ncx_putn_ushort_uint(&xp, nput, value ,fillp);
#line 770
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 770
		{
#line 770
			/* not fatal to the loop */
#line 770
			status = lstatus;
#line 770
		}
#line 770

#line 770
		(void) ncio_rel(ncp->nciop, offset,
#line 770
				 RGN_MODIFIED);
#line 770

#line 770
		remaining -= extent;
#line 770
		if(remaining == 0)
#line 770
			break; /* normal loop exit */
#line 770
		offset += (off_t)extent;
#line 770
		value += nput;
#line 770

#line 770
	}
#line 770
#ifdef ERANGE_FILL
#line 770
        free(fillp);
#line 770
#endif
#line 770

#line 770
	return status;
#line 770
}
#line 770

static int
#line 771
putNCvx_ushort_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 771
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 771
{
#line 771
	off_t offset = NC_varoffset(ncp, varp, start);
#line 771
	size_t remaining = varp->xsz * nelems;
#line 771
	int status = NC_NOERR;
#line 771
	void *xp;
#line 771
        void *fillp=NULL;
#line 771

#line 771
	NC_UNUSED(fillp);
#line 771

#line 771
	if(nelems == 0)
#line 771
		return NC_NOERR;
#line 771

#line 771
	assert(value != NULL);
#line 771

#line 771
#ifdef ERANGE_FILL
#line 771
        fillp = malloc(varp->xsz);
#line 771
        status = NC3_inq_var_fill(varp, fillp);
#line 771
#endif
#line 771

#line 771
	for(;;)
#line 771
	{
#line 771
		size_t extent = MIN(remaining, ncp->chunk);
#line 771
		size_t nput = ncx_howmany(varp->type, extent);
#line 771

#line 771
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 771
				 RGN_WRITE, &xp);
#line 771
		if(lstatus != NC_NOERR)
#line 771
			return lstatus;
#line 771

#line 771
		lstatus = ncx_putn_ushort_ulonglong(&xp, nput, value ,fillp);
#line 771
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 771
		{
#line 771
			/* not fatal to the loop */
#line 771
			status = lstatus;
#line 771
		}
#line 771

#line 771
		(void) ncio_rel(ncp->nciop, offset,
#line 771
				 RGN_MODIFIED);
#line 771

#line 771
		remaining -= extent;
#line 771
		if(remaining == 0)
#line 771
			break; /* normal loop exit */
#line 771
		offset += (off_t)extent;
#line 771
		value += nput;
#line 771

#line 771
	}
#line 771
#ifdef ERANGE_FILL
#line 771
        free(fillp);
#line 771
#endif
#line 771

#line 771
	return status;
#line 771
}
#line 771


static int
#line 773
putNCvx_uint_schar(NC3_INFO* ncp, const NC_var *varp,
#line 773
		 const size_t *start, size_t nelems, const schar *value)
#line 773
{
#line 773
	off_t offset = NC_varoffset(ncp, varp, start);
#line 773
	size_t remaining = varp->xsz * nelems;
#line 773
	int status = NC_NOERR;
#line 773
	void *xp;
#line 773
        void *fillp=NULL;
#line 773

#line 773
	NC_UNUSED(fillp);
#line 773

#line 773
	if(nelems == 0)
#line 773
		return NC_NOERR;
#line 773

#line 773
	assert(value != NULL);
#line 773

#line 773
#ifdef ERANGE_FILL
#line 773
        fillp = malloc(varp->xsz);
#line 773
        status = NC3_inq_var_fill(varp, fillp);
#line 773
#endif
#line 773

#line 773
	for(;;)
#line 773
	{
#line 773
		size_t extent = MIN(remaining, ncp->chunk);
#line 773
		size_t nput = ncx_howmany(varp->type, extent);
#line 773

#line 773
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 773
				 RGN_WRITE, &xp);
#line 773
		if(lstatus != NC_NOERR)
#line 773
			return lstatus;
#line 773

#line 773
		lstatus = ncx_putn_uint_schar(&xp, nput, value ,fillp);
#line 773
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 773
		{
#line 773
			/* not fatal to the loop */
#line 773
			status = lstatus;
#line 773
		}
#line 773

#line 773
		(void) ncio_rel(ncp->nciop, offset,
#line 773
				 RGN_MODIFIED);
#line 773

#line 773
		remaining -= extent;
#line 773
		if(remaining == 0)
#line 773
			break; /* normal loop exit */
#line 773
		offset += (off_t)extent;
#line 773
		value += nput;
#line 773

#line 773
	}
#line 773
#ifdef ERANGE_FILL
#line 773
        free(fillp);
#line 773
#endif
#line 773

#line 773
	return status;
#line 773
}
#line 773

static int
#line 774
putNCvx_uint_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 774
		 const size_t *start, size_t nelems, const uchar *value)
#line 774
{
#line 774
	off_t offset = NC_varoffset(ncp, varp, start);
#line 774
	size_t remaining = varp->xsz * nelems;
#line 774
	int status = NC_NOERR;
#line 774
	void *xp;
#line 774
        void *fillp=NULL;
#line 774

#line 774
	NC_UNUSED(fillp);
#line 774

#line 774
	if(nelems == 0)
#line 774
		return NC_NOERR;
#line 774

#line 774
	assert(value != NULL);
#line 774

#line 774
#ifdef ERANGE_FILL
#line 774
        fillp = malloc(varp->xsz);
#line 774
        status = NC3_inq_var_fill(varp, fillp);
#line 774
#endif
#line 774

#line 774
	for(;;)
#line 774
	{
#line 774
		size_t extent = MIN(remaining, ncp->chunk);
#line 774
		size_t nput = ncx_howmany(varp->type, extent);
#line 774

#line 774
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 774
				 RGN_WRITE, &xp);
#line 774
		if(lstatus != NC_NOERR)
#line 774
			return lstatus;
#line 774

#line 774
		lstatus = ncx_putn_uint_uchar(&xp, nput, value ,fillp);
#line 774
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 774
		{
#line 774
			/* not fatal to the loop */
#line 774
			status = lstatus;
#line 774
		}
#line 774

#line 774
		(void) ncio_rel(ncp->nciop, offset,
#line 774
				 RGN_MODIFIED);
#line 774

#line 774
		remaining -= extent;
#line 774
		if(remaining == 0)
#line 774
			break; /* normal loop exit */
#line 774
		offset += (off_t)extent;
#line 774
		value += nput;
#line 774

#line 774
	}
#line 774
#ifdef ERANGE_FILL
#line 774
        free(fillp);
#line 774
#endif
#line 774

#line 774
	return status;
#line 774
}
#line 774

static int
#line 775
putNCvx_uint_short(NC3_INFO* ncp, const NC_var *varp,
#line 775
		 const size_t *start, size_t nelems, const short *value)
#line 775
{
#line 775
	off_t offset = NC_varoffset(ncp, varp, start);
#line 775
	size_t remaining = varp->xsz * nelems;
#line 775
	int status = NC_NOERR;
#line 775
	void *xp;
#line 775
        void *fillp=NULL;
#line 775

#line 775
	NC_UNUSED(fillp);
#line 775

#line 775
	if(nelems == 0)
#line 775
		return NC_NOERR;
#line 775

#line 775
	assert(value != NULL);
#line 775

#line 775
#ifdef ERANGE_FILL
#line 775
        fillp = malloc(varp->xsz);
#line 775
        status = NC3_inq_var_fill(varp, fillp);
#line 775
#endif
#line 775

#line 775
	for(;;)
#line 775
	{
#line 775
		size_t extent = MIN(remaining, ncp->chunk);
#line 775
		size_t nput = ncx_howmany(varp->type, extent);
#line 775

#line 775
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 775
				 RGN_WRITE, &xp);
#line 775
		if(lstatus != NC_NOERR)
#line 775
			return lstatus;
#line 775

#line 775
		lstatus = ncx_putn_uint_short(&xp, nput, value ,fillp);
#line 775
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 775
		{
#line 775
			/* not fatal to the loop */
#line 775
			status = lstatus;
#line 775
		}
#line 775

#line 775
		(void) ncio_rel(ncp->nciop, offset,
#line 775
				 RGN_MODIFIED);
#line 775

#line 775
		remaining -= extent;
#line 775
		if(remaining == 0)
#line 775
			break; /* normal loop exit */
#line 775
		offset += (off_t)extent;
#line 775
		value += nput;
#line 775

#line 775
	}
#line 775
#ifdef ERANGE_FILL
#line 775
        free(fillp);
#line 775
#endif
#line 775

#line 775
	return status;
#line 775
}
#line 775

static int
#line 776
putNCvx_uint_int(NC3_INFO* ncp, const NC_var *varp,
#line 776
		 const size_t *start, size_t nelems, const int *value)
#line 776
{
#line 776
	off_t offset = NC_varoffset(ncp, varp, start);
#line 776
	size_t remaining = varp->xsz * nelems;
#line 776
	int status = NC_NOERR;
#line 776
	void *xp;
#line 776
        void *fillp=NULL;
#line 776

#line 776
	NC_UNUSED(fillp);
#line 776

#line 776
	if(nelems == 0)
#line 776
		return NC_NOERR;
#line 776

#line 776
	assert(value != NULL);
#line 776

#line 776
#ifdef ERANGE_FILL
#line 776
        fillp = malloc(varp->xsz);
#line 776
        status = NC3_inq_var_fill(varp, fillp);
#line 776
#endif
#line 776

#line 776
	for(;;)
#line 776
	{
#line 776
		size_t extent = MIN(remaining, ncp->chunk);
#line 776
		size_t nput = ncx_howmany(varp->type, extent);
#line 776

#line 776
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 776
				 RGN_WRITE, &xp);
#line 776
		if(lstatus != NC_NOERR)
#line 776
			return lstatus;
#line 776

#line 776
		lstatus = ncx_putn_uint_int(&xp, nput, value ,fillp);
#line 776
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 776
		{
#line 776
			/* not fatal to the loop */
#line 776
			status = lstatus;
#line 776
		}
#line 776

#line 776
		(void) ncio_rel(ncp->nciop, offset,
#line 776
				 RGN_MODIFIED);
#line 776

#line 776
		remaining -= extent;
#line 776
		if(remaining == 0)
#line 776
			break; /* normal loop exit */
#line 776
		offset += (off_t)extent;
#line 776
		value += nput;
#line 776

#line 776
	}
#line 776
#ifdef ERANGE_FILL
#line 776
        free(fillp);
#line 776
#endif
#line 776

#line 776
	return status;
#line 776
}
#line 776

static int
#line 777
putNCvx_uint_float(NC3_INFO* ncp, const NC_var *varp,
#line 777
		 const size_t *start, size_t nelems, const float *value)
#line 777
{
#line 777
	off_t offset = NC_varoffset(ncp, varp, start);
#line 777
	size_t remaining = varp->xsz * nelems;
#line 777
	int status = NC_NOERR;
#line 777
	void *xp;
#line 777
        void *fillp=NULL;
#line 777

#line 777
	NC_UNUSED(fillp);
#line 777

#line 777
	if(nelems == 0)
#line 777
		return NC_NOERR;
#line 777

#line 777
	assert(value != NULL);
#line 777

#line 777
#ifdef ERANGE_FILL
#line 777
        fillp = malloc(varp->xsz);
#line 777
        status = NC3_inq_var_fill(varp, fillp);
#line 777
#endif
#line 777

#line 777
	for(;;)
#line 777
	{
#line 777
		size_t extent = MIN(remaining, ncp->chunk);
#line 777
		size_t nput = ncx_howmany(varp->type, extent);
#line 777

#line 777
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 777
				 RGN_WRITE, &xp);
#line 777
		if(lstatus != NC_NOERR)
#line 777
			return lstatus;
#line 777

#line 777
		lstatus = ncx_putn_uint_float(&xp, nput, value ,fillp);
#line 777
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 777
		{
#line 777
			/* not fatal to the loop */
#line 777
			status = lstatus;
#line 777
		}
#line 777

#line 777
		(void) ncio_rel(ncp->nciop, offset,
#line 777
				 RGN_MODIFIED);
#line 777

#line 777
		remaining -= extent;
#line 777
		if(remaining == 0)
#line 777
			break; /* normal loop exit */
#line 777
		offset += (off_t)extent;
#line 777
		value += nput;
#line 777

#line 777
	}
#line 777
#ifdef ERANGE_FILL
#line 777
        free(fillp);
#line 777
#endif
#line 777

#line 777
	return status;
#line 777
}
#line 777

static int
#line 778
putNCvx_uint_double(NC3_INFO* ncp, const NC_var *varp,
#line 778
		 const size_t *start, size_t nelems, const double *value)
#line 778
{
#line 778
	off_t offset = NC_varoffset(ncp, varp, start);
#line 778
	size_t remaining = varp->xsz * nelems;
#line 778
	int status = NC_NOERR;
#line 778
	void *xp;
#line 778
        void *fillp=NULL;
#line 778

#line 778
	NC_UNUSED(fillp);
#line 778

#line 778
	if(nelems == 0)
#line 778
		return NC_NOERR;
#line 778

#line 778
	assert(value != NULL);
#line 778

#line 778
#ifdef ERANGE_FILL
#line 778
        fillp = malloc(varp->xsz);
#line 778
        status = NC3_inq_var_fill(varp, fillp);
#line 778
#endif
#line 778

#line 778
	for(;;)
#line 778
	{
#line 778
		size_t extent = MIN(remaining, ncp->chunk);
#line 778
		size_t nput = ncx_howmany(varp->type, extent);
#line 778

#line 778
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 778
				 RGN_WRITE, &xp);
#line 778
		if(lstatus != NC_NOERR)
#line 778
			return lstatus;
#line 778

#line 778
		lstatus = ncx_putn_uint_double(&xp, nput, value ,fillp);
#line 778
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 778
		{
#line 778
			/* not fatal to the loop */
#line 778
			status = lstatus;
#line 778
		}
#line 778

#line 778
		(void) ncio_rel(ncp->nciop, offset,
#line 778
				 RGN_MODIFIED);
#line 778

#line 778
		remaining -= extent;
#line 778
		if(remaining == 0)
#line 778
			break; /* normal loop exit */
#line 778
		offset += (off_t)extent;
#line 778
		value += nput;
#line 778

#line 778
	}
#line 778
#ifdef ERANGE_FILL
#line 778
        free(fillp);
#line 778
#endif
#line 778

#line 778
	return status;
#line 778
}
#line 778

static int
#line 779
putNCvx_uint_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 779
		 const size_t *start, size_t nelems, const longlong *value)
#line 779
{
#line 779
	off_t offset = NC_varoffset(ncp, varp, start);
#line 779
	size_t remaining = varp->xsz * nelems;
#line 779
	int status = NC_NOERR;
#line 779
	void *xp;
#line 779
        void *fillp=NULL;
#line 779

#line 779
	NC_UNUSED(fillp);
#line 779

#line 779
	if(nelems == 0)
#line 779
		return NC_NOERR;
#line 779

#line 779
	assert(value != NULL);
#line 779

#line 779
#ifdef ERANGE_FILL
#line 779
        fillp = malloc(varp->xsz);
#line 779
        status = NC3_inq_var_fill(varp, fillp);
#line 779
#endif
#line 779

#line 779
	for(;;)
#line 779
	{
#line 779
		size_t extent = MIN(remaining, ncp->chunk);
#line 779
		size_t nput = ncx_howmany(varp->type, extent);
#line 779

#line 779
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 779
				 RGN_WRITE, &xp);
#line 779
		if(lstatus != NC_NOERR)
#line 779
			return lstatus;
#line 779

#line 779
		lstatus = ncx_putn_uint_longlong(&xp, nput, value ,fillp);
#line 779
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 779
		{
#line 779
			/* not fatal to the loop */
#line 779
			status = lstatus;
#line 779
		}
#line 779

#line 779
		(void) ncio_rel(ncp->nciop, offset,
#line 779
				 RGN_MODIFIED);
#line 779

#line 779
		remaining -= extent;
#line 779
		if(remaining == 0)
#line 779
			break; /* normal loop exit */
#line 779
		offset += (off_t)extent;
#line 779
		value += nput;
#line 779

#line 779
	}
#line 779
#ifdef ERANGE_FILL
#line 779
        free(fillp);
#line 779
#endif
#line 779

#line 779
	return status;
#line 779
}
#line 779

static int
#line 780
putNCvx_uint_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 780
		 const size_t *start, size_t nelems, const ushort *value)
#line 780
{
#line 780
	off_t offset = NC_varoffset(ncp, varp, start);
#line 780
	size_t remaining = varp->xsz * nelems;
#line 780
	int status = NC_NOERR;
#line 780
	void *xp;
#line 780
        void *fillp=NULL;
#line 780

#line 780
	NC_UNUSED(fillp);
#line 780

#line 780
	if(nelems == 0)
#line 780
		return NC_NOERR;
#line 780

#line 780
	assert(value != NULL);
#line 780

#line 780
#ifdef ERANGE_FILL
#line 780
        fillp = malloc(varp->xsz);
#line 780
        status = NC3_inq_var_fill(varp, fillp);
#line 780
#endif
#line 780

#line 780
	for(;;)
#line 780
	{
#line 780
		size_t extent = MIN(remaining, ncp->chunk);
#line 780
		size_t nput = ncx_howmany(varp->type, extent);
#line 780

#line 780
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 780
				 RGN_WRITE, &xp);
#line 780
		if(lstatus != NC_NOERR)
#line 780
			return lstatus;
#line 780

#line 780
		lstatus = ncx_putn_uint_ushort(&xp, nput, value ,fillp);
#line 780
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 780
		{
#line 780
			/* not fatal to the loop */
#line 780
			status = lstatus;
#line 780
		}
#line 780

#line 780
		(void) ncio_rel(ncp->nciop, offset,
#line 780
				 RGN_MODIFIED);
#line 780

#line 780
		remaining -= extent;
#line 780
		if(remaining == 0)
#line 780
			break; /* normal loop exit */
#line 780
		offset += (off_t)extent;
#line 780
		value += nput;
#line 780

#line 780
	}
#line 780
#ifdef ERANGE_FILL
#line 780
        free(fillp);
#line 780
#endif
#line 780

#line 780
	return status;
#line 780
}
#line 780

static int
#line 781
putNCvx_uint_uint(NC3_INFO* ncp, const NC_var *varp,
#line 781
		 const size_t *start, size_t nelems, const uint *value)
#line 781
{
#line 781
	off_t offset = NC_varoffset(ncp, varp, start);
#line 781
	size_t remaining = varp->xsz * nelems;
#line 781
	int status = NC_NOERR;
#line 781
	void *xp;
#line 781
        void *fillp=NULL;
#line 781

#line 781
	NC_UNUSED(fillp);
#line 781

#line 781
	if(nelems == 0)
#line 781
		return NC_NOERR;
#line 781

#line 781
	assert(value != NULL);
#line 781

#line 781
#ifdef ERANGE_FILL
#line 781
        fillp = malloc(varp->xsz);
#line 781
        status = NC3_inq_var_fill(varp, fillp);
#line 781
#endif
#line 781

#line 781
	for(;;)
#line 781
	{
#line 781
		size_t extent = MIN(remaining, ncp->chunk);
#line 781
		size_t nput = ncx_howmany(varp->type, extent);
#line 781

#line 781
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 781
				 RGN_WRITE, &xp);
#line 781
		if(lstatus != NC_NOERR)
#line 781
			return lstatus;
#line 781

#line 781
		lstatus = ncx_putn_uint_uint(&xp, nput, value ,fillp);
#line 781
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 781
		{
#line 781
			/* not fatal to the loop */
#line 781
			status = lstatus;
#line 781
		}
#line 781

#line 781
		(void) ncio_rel(ncp->nciop, offset,
#line 781
				 RGN_MODIFIED);
#line 781

#line 781
		remaining -= extent;
#line 781
		if(remaining == 0)
#line 781
			break; /* normal loop exit */
#line 781
		offset += (off_t)extent;
#line 781
		value += nput;
#line 781

#line 781
	}
#line 781
#ifdef ERANGE_FILL
#line 781
        free(fillp);
#line 781
#endif
#line 781

#line 781
	return status;
#line 781
}
#line 781

static int
#line 782
putNCvx_uint_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 782
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 782
{
#line 782
	off_t offset = NC_varoffset(ncp, varp, start);
#line 782
	size_t remaining = varp->xsz * nelems;
#line 782
	int status = NC_NOERR;
#line 782
	void *xp;
#line 782
        void *fillp=NULL;
#line 782

#line 782
	NC_UNUSED(fillp);
#line 782

#line 782
	if(nelems == 0)
#line 782
		return NC_NOERR;
#line 782

#line 782
	assert(value != NULL);
#line 782

#line 782
#ifdef ERANGE_FILL
#line 782
        fillp = malloc(varp->xsz);
#line 782
        status = NC3_inq_var_fill(varp, fillp);
#line 782
#endif
#line 782

#line 782
	for(;;)
#line 782
	{
#line 782
		size_t extent = MIN(remaining, ncp->chunk);
#line 782
		size_t nput = ncx_howmany(varp->type, extent);
#line 782

#line 782
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 782
				 RGN_WRITE, &xp);
#line 782
		if(lstatus != NC_NOERR)
#line 782
			return lstatus;
#line 782

#line 782
		lstatus = ncx_putn_uint_ulonglong(&xp, nput, value ,fillp);
#line 782
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 782
		{
#line 782
			/* not fatal to the loop */
#line 782
			status = lstatus;
#line 782
		}
#line 782

#line 782
		(void) ncio_rel(ncp->nciop, offset,
#line 782
				 RGN_MODIFIED);
#line 782

#line 782
		remaining -= extent;
#line 782
		if(remaining == 0)
#line 782
			break; /* normal loop exit */
#line 782
		offset += (off_t)extent;
#line 782
		value += nput;
#line 782

#line 782
	}
#line 782
#ifdef ERANGE_FILL
#line 782
        free(fillp);
#line 782
#endif
#line 782

#line 782
	return status;
#line 782
}
#line 782


static int
#line 784
putNCvx_longlong_schar(NC3_INFO* ncp, const NC_var *varp,
#line 784
		 const size_t *start, size_t nelems, const schar *value)
#line 784
{
#line 784
	off_t offset = NC_varoffset(ncp, varp, start);
#line 784
	size_t remaining = varp->xsz * nelems;
#line 784
	int status = NC_NOERR;
#line 784
	void *xp;
#line 784
        void *fillp=NULL;
#line 784

#line 784
	NC_UNUSED(fillp);
#line 784

#line 784
	if(nelems == 0)
#line 784
		return NC_NOERR;
#line 784

#line 784
	assert(value != NULL);
#line 784

#line 784
#ifdef ERANGE_FILL
#line 784
        fillp = malloc(varp->xsz);
#line 784
        status = NC3_inq_var_fill(varp, fillp);
#line 784
#endif
#line 784

#line 784
	for(;;)
#line 784
	{
#line 784
		size_t extent = MIN(remaining, ncp->chunk);
#line 784
		size_t nput = ncx_howmany(varp->type, extent);
#line 784

#line 784
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 784
				 RGN_WRITE, &xp);
#line 784
		if(lstatus != NC_NOERR)
#line 784
			return lstatus;
#line 784

#line 784
		lstatus = ncx_putn_longlong_schar(&xp, nput, value ,fillp);
#line 784
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 784
		{
#line 784
			/* not fatal to the loop */
#line 784
			status = lstatus;
#line 784
		}
#line 784

#line 784
		(void) ncio_rel(ncp->nciop, offset,
#line 784
				 RGN_MODIFIED);
#line 784

#line 784
		remaining -= extent;
#line 784
		if(remaining == 0)
#line 784
			break; /* normal loop exit */
#line 784
		offset += (off_t)extent;
#line 784
		value += nput;
#line 784

#line 784
	}
#line 784
#ifdef ERANGE_FILL
#line 784
        free(fillp);
#line 784
#endif
#line 784

#line 784
	return status;
#line 784
}
#line 784

static int
#line 785
putNCvx_longlong_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 785
		 const size_t *start, size_t nelems, const uchar *value)
#line 785
{
#line 785
	off_t offset = NC_varoffset(ncp, varp, start);
#line 785
	size_t remaining = varp->xsz * nelems;
#line 785
	int status = NC_NOERR;
#line 785
	void *xp;
#line 785
        void *fillp=NULL;
#line 785

#line 785
	NC_UNUSED(fillp);
#line 785

#line 785
	if(nelems == 0)
#line 785
		return NC_NOERR;
#line 785

#line 785
	assert(value != NULL);
#line 785

#line 785
#ifdef ERANGE_FILL
#line 785
        fillp = malloc(varp->xsz);
#line 785
        status = NC3_inq_var_fill(varp, fillp);
#line 785
#endif
#line 785

#line 785
	for(;;)
#line 785
	{
#line 785
		size_t extent = MIN(remaining, ncp->chunk);
#line 785
		size_t nput = ncx_howmany(varp->type, extent);
#line 785

#line 785
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 785
				 RGN_WRITE, &xp);
#line 785
		if(lstatus != NC_NOERR)
#line 785
			return lstatus;
#line 785

#line 785
		lstatus = ncx_putn_longlong_uchar(&xp, nput, value ,fillp);
#line 785
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 785
		{
#line 785
			/* not fatal to the loop */
#line 785
			status = lstatus;
#line 785
		}
#line 785

#line 785
		(void) ncio_rel(ncp->nciop, offset,
#line 785
				 RGN_MODIFIED);
#line 785

#line 785
		remaining -= extent;
#line 785
		if(remaining == 0)
#line 785
			break; /* normal loop exit */
#line 785
		offset += (off_t)extent;
#line 785
		value += nput;
#line 785

#line 785
	}
#line 785
#ifdef ERANGE_FILL
#line 785
        free(fillp);
#line 785
#endif
#line 785

#line 785
	return status;
#line 785
}
#line 785

static int
#line 786
putNCvx_longlong_short(NC3_INFO* ncp, const NC_var *varp,
#line 786
		 const size_t *start, size_t nelems, const short *value)
#line 786
{
#line 786
	off_t offset = NC_varoffset(ncp, varp, start);
#line 786
	size_t remaining = varp->xsz * nelems;
#line 786
	int status = NC_NOERR;
#line 786
	void *xp;
#line 786
        void *fillp=NULL;
#line 786

#line 786
	NC_UNUSED(fillp);
#line 786

#line 786
	if(nelems == 0)
#line 786
		return NC_NOERR;
#line 786

#line 786
	assert(value != NULL);
#line 786

#line 786
#ifdef ERANGE_FILL
#line 786
        fillp = malloc(varp->xsz);
#line 786
        status = NC3_inq_var_fill(varp, fillp);
#line 786
#endif
#line 786

#line 786
	for(;;)
#line 786
	{
#line 786
		size_t extent = MIN(remaining, ncp->chunk);
#line 786
		size_t nput = ncx_howmany(varp->type, extent);
#line 786

#line 786
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 786
				 RGN_WRITE, &xp);
#line 786
		if(lstatus != NC_NOERR)
#line 786
			return lstatus;
#line 786

#line 786
		lstatus = ncx_putn_longlong_short(&xp, nput, value ,fillp);
#line 786
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 786
		{
#line 786
			/* not fatal to the loop */
#line 786
			status = lstatus;
#line 786
		}
#line 786

#line 786
		(void) ncio_rel(ncp->nciop, offset,
#line 786
				 RGN_MODIFIED);
#line 786

#line 786
		remaining -= extent;
#line 786
		if(remaining == 0)
#line 786
			break; /* normal loop exit */
#line 786
		offset += (off_t)extent;
#line 786
		value += nput;
#line 786

#line 786
	}
#line 786
#ifdef ERANGE_FILL
#line 786
        free(fillp);
#line 786
#endif
#line 786

#line 786
	return status;
#line 786
}
#line 786

static int
#line 787
putNCvx_longlong_int(NC3_INFO* ncp, const NC_var *varp,
#line 787
		 const size_t *start, size_t nelems, const int *value)
#line 787
{
#line 787
	off_t offset = NC_varoffset(ncp, varp, start);
#line 787
	size_t remaining = varp->xsz * nelems;
#line 787
	int status = NC_NOERR;
#line 787
	void *xp;
#line 787
        void *fillp=NULL;
#line 787

#line 787
	NC_UNUSED(fillp);
#line 787

#line 787
	if(nelems == 0)
#line 787
		return NC_NOERR;
#line 787

#line 787
	assert(value != NULL);
#line 787

#line 787
#ifdef ERANGE_FILL
#line 787
        fillp = malloc(varp->xsz);
#line 787
        status = NC3_inq_var_fill(varp, fillp);
#line 787
#endif
#line 787

#line 787
	for(;;)
#line 787
	{
#line 787
		size_t extent = MIN(remaining, ncp->chunk);
#line 787
		size_t nput = ncx_howmany(varp->type, extent);
#line 787

#line 787
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 787
				 RGN_WRITE, &xp);
#line 787
		if(lstatus != NC_NOERR)
#line 787
			return lstatus;
#line 787

#line 787
		lstatus = ncx_putn_longlong_int(&xp, nput, value ,fillp);
#line 787
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 787
		{
#line 787
			/* not fatal to the loop */
#line 787
			status = lstatus;
#line 787
		}
#line 787

#line 787
		(void) ncio_rel(ncp->nciop, offset,
#line 787
				 RGN_MODIFIED);
#line 787

#line 787
		remaining -= extent;
#line 787
		if(remaining == 0)
#line 787
			break; /* normal loop exit */
#line 787
		offset += (off_t)extent;
#line 787
		value += nput;
#line 787

#line 787
	}
#line 787
#ifdef ERANGE_FILL
#line 787
        free(fillp);
#line 787
#endif
#line 787

#line 787
	return status;
#line 787
}
#line 787

static int
#line 788
putNCvx_longlong_float(NC3_INFO* ncp, const NC_var *varp,
#line 788
		 const size_t *start, size_t nelems, const float *value)
#line 788
{
#line 788
	off_t offset = NC_varoffset(ncp, varp, start);
#line 788
	size_t remaining = varp->xsz * nelems;
#line 788
	int status = NC_NOERR;
#line 788
	void *xp;
#line 788
        void *fillp=NULL;
#line 788

#line 788
	NC_UNUSED(fillp);
#line 788

#line 788
	if(nelems == 0)
#line 788
		return NC_NOERR;
#line 788

#line 788
	assert(value != NULL);
#line 788

#line 788
#ifdef ERANGE_FILL
#line 788
        fillp = malloc(varp->xsz);
#line 788
        status = NC3_inq_var_fill(varp, fillp);
#line 788
#endif
#line 788

#line 788
	for(;;)
#line 788
	{
#line 788
		size_t extent = MIN(remaining, ncp->chunk);
#line 788
		size_t nput = ncx_howmany(varp->type, extent);
#line 788

#line 788
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 788
				 RGN_WRITE, &xp);
#line 788
		if(lstatus != NC_NOERR)
#line 788
			return lstatus;
#line 788

#line 788
		lstatus = ncx_putn_longlong_float(&xp, nput, value ,fillp);
#line 788
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 788
		{
#line 788
			/* not fatal to the loop */
#line 788
			status = lstatus;
#line 788
		}
#line 788

#line 788
		(void) ncio_rel(ncp->nciop, offset,
#line 788
				 RGN_MODIFIED);
#line 788

#line 788
		remaining -= extent;
#line 788
		if(remaining == 0)
#line 788
			break; /* normal loop exit */
#line 788
		offset += (off_t)extent;
#line 788
		value += nput;
#line 788

#line 788
	}
#line 788
#ifdef ERANGE_FILL
#line 788
        free(fillp);
#line 788
#endif
#line 788

#line 788
	return status;
#line 788
}
#line 788

static int
#line 789
putNCvx_longlong_double(NC3_INFO* ncp, const NC_var *varp,
#line 789
		 const size_t *start, size_t nelems, const double *value)
#line 789
{
#line 789
	off_t offset = NC_varoffset(ncp, varp, start);
#line 789
	size_t remaining = varp->xsz * nelems;
#line 789
	int status = NC_NOERR;
#line 789
	void *xp;
#line 789
        void *fillp=NULL;
#line 789

#line 789
	NC_UNUSED(fillp);
#line 789

#line 789
	if(nelems == 0)
#line 789
		return NC_NOERR;
#line 789

#line 789
	assert(value != NULL);
#line 789

#line 789
#ifdef ERANGE_FILL
#line 789
        fillp = malloc(varp->xsz);
#line 789
        status = NC3_inq_var_fill(varp, fillp);
#line 789
#endif
#line 789

#line 789
	for(;;)
#line 789
	{
#line 789
		size_t extent = MIN(remaining, ncp->chunk);
#line 789
		size_t nput = ncx_howmany(varp->type, extent);
#line 789

#line 789
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 789
				 RGN_WRITE, &xp);
#line 789
		if(lstatus != NC_NOERR)
#line 789
			return lstatus;
#line 789

#line 789
		lstatus = ncx_putn_longlong_double(&xp, nput, value ,fillp);
#line 789
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 789
		{
#line 789
			/* not fatal to the loop */
#line 789
			status = lstatus;
#line 789
		}
#line 789

#line 789
		(void) ncio_rel(ncp->nciop, offset,
#line 789
				 RGN_MODIFIED);
#line 789

#line 789
		remaining -= extent;
#line 789
		if(remaining == 0)
#line 789
			break; /* normal loop exit */
#line 789
		offset += (off_t)extent;
#line 789
		value += nput;
#line 789

#line 789
	}
#line 789
#ifdef ERANGE_FILL
#line 789
        free(fillp);
#line 789
#endif
#line 789

#line 789
	return status;
#line 789
}
#line 789

static int
#line 790
putNCvx_longlong_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 790
		 const size_t *start, size_t nelems, const longlong *value)
#line 790
{
#line 790
	off_t offset = NC_varoffset(ncp, varp, start);
#line 790
	size_t remaining = varp->xsz * nelems;
#line 790
	int status = NC_NOERR;
#line 790
	void *xp;
#line 790
        void *fillp=NULL;
#line 790

#line 790
	NC_UNUSED(fillp);
#line 790

#line 790
	if(nelems == 0)
#line 790
		return NC_NOERR;
#line 790

#line 790
	assert(value != NULL);
#line 790

#line 790
#ifdef ERANGE_FILL
#line 790
        fillp = malloc(varp->xsz);
#line 790
        status = NC3_inq_var_fill(varp, fillp);
#line 790
#endif
#line 790

#line 790
	for(;;)
#line 790
	{
#line 790
		size_t extent = MIN(remaining, ncp->chunk);
#line 790
		size_t nput = ncx_howmany(varp->type, extent);
#line 790

#line 790
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 790
				 RGN_WRITE, &xp);
#line 790
		if(lstatus != NC_NOERR)
#line 790
			return lstatus;
#line 790

#line 790
		lstatus = ncx_putn_longlong_longlong(&xp, nput, value ,fillp);
#line 790
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 790
		{
#line 790
			/* not fatal to the loop */
#line 790
			status = lstatus;
#line 790
		}
#line 790

#line 790
		(void) ncio_rel(ncp->nciop, offset,
#line 790
				 RGN_MODIFIED);
#line 790

#line 790
		remaining -= extent;
#line 790
		if(remaining == 0)
#line 790
			break; /* normal loop exit */
#line 790
		offset += (off_t)extent;
#line 790
		value += nput;
#line 790

#line 790
	}
#line 790
#ifdef ERANGE_FILL
#line 790
        free(fillp);
#line 790
#endif
#line 790

#line 790
	return status;
#line 790
}
#line 790

static int
#line 791
putNCvx_longlong_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 791
		 const size_t *start, size_t nelems, const ushort *value)
#line 791
{
#line 791
	off_t offset = NC_varoffset(ncp, varp, start);
#line 791
	size_t remaining = varp->xsz * nelems;
#line 791
	int status = NC_NOERR;
#line 791
	void *xp;
#line 791
        void *fillp=NULL;
#line 791

#line 791
	NC_UNUSED(fillp);
#line 791

#line 791
	if(nelems == 0)
#line 791
		return NC_NOERR;
#line 791

#line 791
	assert(value != NULL);
#line 791

#line 791
#ifdef ERANGE_FILL
#line 791
        fillp = malloc(varp->xsz);
#line 791
        status = NC3_inq_var_fill(varp, fillp);
#line 791
#endif
#line 791

#line 791
	for(;;)
#line 791
	{
#line 791
		size_t extent = MIN(remaining, ncp->chunk);
#line 791
		size_t nput = ncx_howmany(varp->type, extent);
#line 791

#line 791
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 791
				 RGN_WRITE, &xp);
#line 791
		if(lstatus != NC_NOERR)
#line 791
			return lstatus;
#line 791

#line 791
		lstatus = ncx_putn_longlong_ushort(&xp, nput, value ,fillp);
#line 791
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 791
		{
#line 791
			/* not fatal to the loop */
#line 791
			status = lstatus;
#line 791
		}
#line 791

#line 791
		(void) ncio_rel(ncp->nciop, offset,
#line 791
				 RGN_MODIFIED);
#line 791

#line 791
		remaining -= extent;
#line 791
		if(remaining == 0)
#line 791
			break; /* normal loop exit */
#line 791
		offset += (off_t)extent;
#line 791
		value += nput;
#line 791

#line 791
	}
#line 791
#ifdef ERANGE_FILL
#line 791
        free(fillp);
#line 791
#endif
#line 791

#line 791
	return status;
#line 791
}
#line 791

static int
#line 792
putNCvx_longlong_uint(NC3_INFO* ncp, const NC_var *varp,
#line 792
		 const size_t *start, size_t nelems, const uint *value)
#line 792
{
#line 792
	off_t offset = NC_varoffset(ncp, varp, start);
#line 792
	size_t remaining = varp->xsz * nelems;
#line 792
	int status = NC_NOERR;
#line 792
	void *xp;
#line 792
        void *fillp=NULL;
#line 792

#line 792
	NC_UNUSED(fillp);
#line 792

#line 792
	if(nelems == 0)
#line 792
		return NC_NOERR;
#line 792

#line 792
	assert(value != NULL);
#line 792

#line 792
#ifdef ERANGE_FILL
#line 792
        fillp = malloc(varp->xsz);
#line 792
        status = NC3_inq_var_fill(varp, fillp);
#line 792
#endif
#line 792

#line 792
	for(;;)
#line 792
	{
#line 792
		size_t extent = MIN(remaining, ncp->chunk);
#line 792
		size_t nput = ncx_howmany(varp->type, extent);
#line 792

#line 792
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 792
				 RGN_WRITE, &xp);
#line 792
		if(lstatus != NC_NOERR)
#line 792
			return lstatus;
#line 792

#line 792
		lstatus = ncx_putn_longlong_uint(&xp, nput, value ,fillp);
#line 792
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 792
		{
#line 792
			/* not fatal to the loop */
#line 792
			status = lstatus;
#line 792
		}
#line 792

#line 792
		(void) ncio_rel(ncp->nciop, offset,
#line 792
				 RGN_MODIFIED);
#line 792

#line 792
		remaining -= extent;
#line 792
		if(remaining == 0)
#line 792
			break; /* normal loop exit */
#line 792
		offset += (off_t)extent;
#line 792
		value += nput;
#line 792

#line 792
	}
#line 792
#ifdef ERANGE_FILL
#line 792
        free(fillp);
#line 792
#endif
#line 792

#line 792
	return status;
#line 792
}
#line 792

static int
#line 793
putNCvx_longlong_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 793
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 793
{
#line 793
	off_t offset = NC_varoffset(ncp, varp, start);
#line 793
	size_t remaining = varp->xsz * nelems;
#line 793
	int status = NC_NOERR;
#line 793
	void *xp;
#line 793
        void *fillp=NULL;
#line 793

#line 793
	NC_UNUSED(fillp);
#line 793

#line 793
	if(nelems == 0)
#line 793
		return NC_NOERR;
#line 793

#line 793
	assert(value != NULL);
#line 793

#line 793
#ifdef ERANGE_FILL
#line 793
        fillp = malloc(varp->xsz);
#line 793
        status = NC3_inq_var_fill(varp, fillp);
#line 793
#endif
#line 793

#line 793
	for(;;)
#line 793
	{
#line 793
		size_t extent = MIN(remaining, ncp->chunk);
#line 793
		size_t nput = ncx_howmany(varp->type, extent);
#line 793

#line 793
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 793
				 RGN_WRITE, &xp);
#line 793
		if(lstatus != NC_NOERR)
#line 793
			return lstatus;
#line 793

#line 793
		lstatus = ncx_putn_longlong_ulonglong(&xp, nput, value ,fillp);
#line 793
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 793
		{
#line 793
			/* not fatal to the loop */
#line 793
			status = lstatus;
#line 793
		}
#line 793

#line 793
		(void) ncio_rel(ncp->nciop, offset,
#line 793
				 RGN_MODIFIED);
#line 793

#line 793
		remaining -= extent;
#line 793
		if(remaining == 0)
#line 793
			break; /* normal loop exit */
#line 793
		offset += (off_t)extent;
#line 793
		value += nput;
#line 793

#line 793
	}
#line 793
#ifdef ERANGE_FILL
#line 793
        free(fillp);
#line 793
#endif
#line 793

#line 793
	return status;
#line 793
}
#line 793


static int
#line 795
putNCvx_ulonglong_schar(NC3_INFO* ncp, const NC_var *varp,
#line 795
		 const size_t *start, size_t nelems, const schar *value)
#line 795
{
#line 795
	off_t offset = NC_varoffset(ncp, varp, start);
#line 795
	size_t remaining = varp->xsz * nelems;
#line 795
	int status = NC_NOERR;
#line 795
	void *xp;
#line 795
        void *fillp=NULL;
#line 795

#line 795
	NC_UNUSED(fillp);
#line 795

#line 795
	if(nelems == 0)
#line 795
		return NC_NOERR;
#line 795

#line 795
	assert(value != NULL);
#line 795

#line 795
#ifdef ERANGE_FILL
#line 795
        fillp = malloc(varp->xsz);
#line 795
        status = NC3_inq_var_fill(varp, fillp);
#line 795
#endif
#line 795

#line 795
	for(;;)
#line 795
	{
#line 795
		size_t extent = MIN(remaining, ncp->chunk);
#line 795
		size_t nput = ncx_howmany(varp->type, extent);
#line 795

#line 795
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 795
				 RGN_WRITE, &xp);
#line 795
		if(lstatus != NC_NOERR)
#line 795
			return lstatus;
#line 795

#line 795
		lstatus = ncx_putn_ulonglong_schar(&xp, nput, value ,fillp);
#line 795
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 795
		{
#line 795
			/* not fatal to the loop */
#line 795
			status = lstatus;
#line 795
		}
#line 795

#line 795
		(void) ncio_rel(ncp->nciop, offset,
#line 795
				 RGN_MODIFIED);
#line 795

#line 795
		remaining -= extent;
#line 795
		if(remaining == 0)
#line 795
			break; /* normal loop exit */
#line 795
		offset += (off_t)extent;
#line 795
		value += nput;
#line 795

#line 795
	}
#line 795
#ifdef ERANGE_FILL
#line 795
        free(fillp);
#line 795
#endif
#line 795

#line 795
	return status;
#line 795
}
#line 795

static int
#line 796
putNCvx_ulonglong_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 796
		 const size_t *start, size_t nelems, const uchar *value)
#line 796
{
#line 796
	off_t offset = NC_varoffset(ncp, varp, start);
#line 796
	size_t remaining = varp->xsz * nelems;
#line 796
	int status = NC_NOERR;
#line 796
	void *xp;
#line 796
        void *fillp=NULL;
#line 796

#line 796
	NC_UNUSED(fillp);
#line 796

#line 796
	if(nelems == 0)
#line 796
		return NC_NOERR;
#line 796

#line 796
	assert(value != NULL);
#line 796

#line 796
#ifdef ERANGE_FILL
#line 796
        fillp = malloc(varp->xsz);
#line 796
        status = NC3_inq_var_fill(varp, fillp);
#line 796
#endif
#line 796

#line 796
	for(;;)
#line 796
	{
#line 796
		size_t extent = MIN(remaining, ncp->chunk);
#line 796
		size_t nput = ncx_howmany(varp->type, extent);
#line 796

#line 796
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 796
				 RGN_WRITE, &xp);
#line 796
		if(lstatus != NC_NOERR)
#line 796
			return lstatus;
#line 796

#line 796
		lstatus = ncx_putn_ulonglong_uchar(&xp, nput, value ,fillp);
#line 796
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 796
		{
#line 796
			/* not fatal to the loop */
#line 796
			status = lstatus;
#line 796
		}
#line 796

#line 796
		(void) ncio_rel(ncp->nciop, offset,
#line 796
				 RGN_MODIFIED);
#line 796

#line 796
		remaining -= extent;
#line 796
		if(remaining == 0)
#line 796
			break; /* normal loop exit */
#line 796
		offset += (off_t)extent;
#line 796
		value += nput;
#line 796

#line 796
	}
#line 796
#ifdef ERANGE_FILL
#line 796
        free(fillp);
#line 796
#endif
#line 796

#line 796
	return status;
#line 796
}
#line 796

static int
#line 797
putNCvx_ulonglong_short(NC3_INFO* ncp, const NC_var *varp,
#line 797
		 const size_t *start, size_t nelems, const short *value)
#line 797
{
#line 797
	off_t offset = NC_varoffset(ncp, varp, start);
#line 797
	size_t remaining = varp->xsz * nelems;
#line 797
	int status = NC_NOERR;
#line 797
	void *xp;
#line 797
        void *fillp=NULL;
#line 797

#line 797
	NC_UNUSED(fillp);
#line 797

#line 797
	if(nelems == 0)
#line 797
		return NC_NOERR;
#line 797

#line 797
	assert(value != NULL);
#line 797

#line 797
#ifdef ERANGE_FILL
#line 797
        fillp = malloc(varp->xsz);
#line 797
        status = NC3_inq_var_fill(varp, fillp);
#line 797
#endif
#line 797

#line 797
	for(;;)
#line 797
	{
#line 797
		size_t extent = MIN(remaining, ncp->chunk);
#line 797
		size_t nput = ncx_howmany(varp->type, extent);
#line 797

#line 797
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 797
				 RGN_WRITE, &xp);
#line 797
		if(lstatus != NC_NOERR)
#line 797
			return lstatus;
#line 797

#line 797
		lstatus = ncx_putn_ulonglong_short(&xp, nput, value ,fillp);
#line 797
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 797
		{
#line 797
			/* not fatal to the loop */
#line 797
			status = lstatus;
#line 797
		}
#line 797

#line 797
		(void) ncio_rel(ncp->nciop, offset,
#line 797
				 RGN_MODIFIED);
#line 797

#line 797
		remaining -= extent;
#line 797
		if(remaining == 0)
#line 797
			break; /* normal loop exit */
#line 797
		offset += (off_t)extent;
#line 797
		value += nput;
#line 797

#line 797
	}
#line 797
#ifdef ERANGE_FILL
#line 797
        free(fillp);
#line 797
#endif
#line 797

#line 797
	return status;
#line 797
}
#line 797

static int
#line 798
putNCvx_ulonglong_int(NC3_INFO* ncp, const NC_var *varp,
#line 798
		 const size_t *start, size_t nelems, const int *value)
#line 798
{
#line 798
	off_t offset = NC_varoffset(ncp, varp, start);
#line 798
	size_t remaining = varp->xsz * nelems;
#line 798
	int status = NC_NOERR;
#line 798
	void *xp;
#line 798
        void *fillp=NULL;
#line 798

#line 798
	NC_UNUSED(fillp);
#line 798

#line 798
	if(nelems == 0)
#line 798
		return NC_NOERR;
#line 798

#line 798
	assert(value != NULL);
#line 798

#line 798
#ifdef ERANGE_FILL
#line 798
        fillp = malloc(varp->xsz);
#line 798
        status = NC3_inq_var_fill(varp, fillp);
#line 798
#endif
#line 798

#line 798
	for(;;)
#line 798
	{
#line 798
		size_t extent = MIN(remaining, ncp->chunk);
#line 798
		size_t nput = ncx_howmany(varp->type, extent);
#line 798

#line 798
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 798
				 RGN_WRITE, &xp);
#line 798
		if(lstatus != NC_NOERR)
#line 798
			return lstatus;
#line 798

#line 798
		lstatus = ncx_putn_ulonglong_int(&xp, nput, value ,fillp);
#line 798
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 798
		{
#line 798
			/* not fatal to the loop */
#line 798
			status = lstatus;
#line 798
		}
#line 798

#line 798
		(void) ncio_rel(ncp->nciop, offset,
#line 798
				 RGN_MODIFIED);
#line 798

#line 798
		remaining -= extent;
#line 798
		if(remaining == 0)
#line 798
			break; /* normal loop exit */
#line 798
		offset += (off_t)extent;
#line 798
		value += nput;
#line 798

#line 798
	}
#line 798
#ifdef ERANGE_FILL
#line 798
        free(fillp);
#line 798
#endif
#line 798

#line 798
	return status;
#line 798
}
#line 798

static int
#line 799
putNCvx_ulonglong_float(NC3_INFO* ncp, const NC_var *varp,
#line 799
		 const size_t *start, size_t nelems, const float *value)
#line 799
{
#line 799
	off_t offset = NC_varoffset(ncp, varp, start);
#line 799
	size_t remaining = varp->xsz * nelems;
#line 799
	int status = NC_NOERR;
#line 799
	void *xp;
#line 799
        void *fillp=NULL;
#line 799

#line 799
	NC_UNUSED(fillp);
#line 799

#line 799
	if(nelems == 0)
#line 799
		return NC_NOERR;
#line 799

#line 799
	assert(value != NULL);
#line 799

#line 799
#ifdef ERANGE_FILL
#line 799
        fillp = malloc(varp->xsz);
#line 799
        status = NC3_inq_var_fill(varp, fillp);
#line 799
#endif
#line 799

#line 799
	for(;;)
#line 799
	{
#line 799
		size_t extent = MIN(remaining, ncp->chunk);
#line 799
		size_t nput = ncx_howmany(varp->type, extent);
#line 799

#line 799
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 799
				 RGN_WRITE, &xp);
#line 799
		if(lstatus != NC_NOERR)
#line 799
			return lstatus;
#line 799

#line 799
		lstatus = ncx_putn_ulonglong_float(&xp, nput, value ,fillp);
#line 799
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 799
		{
#line 799
			/* not fatal to the loop */
#line 799
			status = lstatus;
#line 799
		}
#line 799

#line 799
		(void) ncio_rel(ncp->nciop, offset,
#line 799
				 RGN_MODIFIED);
#line 799

#line 799
		remaining -= extent;
#line 799
		if(remaining == 0)
#line 799
			break; /* normal loop exit */
#line 799
		offset += (off_t)extent;
#line 799
		value += nput;
#line 799

#line 799
	}
#line 799
#ifdef ERANGE_FILL
#line 799
        free(fillp);
#line 799
#endif
#line 799

#line 799
	return status;
#line 799
}
#line 799

static int
#line 800
putNCvx_ulonglong_double(NC3_INFO* ncp, const NC_var *varp,
#line 800
		 const size_t *start, size_t nelems, const double *value)
#line 800
{
#line 800
	off_t offset = NC_varoffset(ncp, varp, start);
#line 800
	size_t remaining = varp->xsz * nelems;
#line 800
	int status = NC_NOERR;
#line 800
	void *xp;
#line 800
        void *fillp=NULL;
#line 800

#line 800
	NC_UNUSED(fillp);
#line 800

#line 800
	if(nelems == 0)
#line 800
		return NC_NOERR;
#line 800

#line 800
	assert(value != NULL);
#line 800

#line 800
#ifdef ERANGE_FILL
#line 800
        fillp = malloc(varp->xsz);
#line 800
        status = NC3_inq_var_fill(varp, fillp);
#line 800
#endif
#line 800

#line 800
	for(;;)
#line 800
	{
#line 800
		size_t extent = MIN(remaining, ncp->chunk);
#line 800
		size_t nput = ncx_howmany(varp->type, extent);
#line 800

#line 800
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 800
				 RGN_WRITE, &xp);
#line 800
		if(lstatus != NC_NOERR)
#line 800
			return lstatus;
#line 800

#line 800
		lstatus = ncx_putn_ulonglong_double(&xp, nput, value ,fillp);
#line 800
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 800
		{
#line 800
			/* not fatal to the loop */
#line 800
			status = lstatus;
#line 800
		}
#line 800

#line 800
		(void) ncio_rel(ncp->nciop, offset,
#line 800
				 RGN_MODIFIED);
#line 800

#line 800
		remaining -= extent;
#line 800
		if(remaining == 0)
#line 800
			break; /* normal loop exit */
#line 800
		offset += (off_t)extent;
#line 800
		value += nput;
#line 800

#line 800
	}
#line 800
#ifdef ERANGE_FILL
#line 800
        free(fillp);
#line 800
#endif
#line 800

#line 800
	return status;
#line 800
}
#line 800

static int
#line 801
putNCvx_ulonglong_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 801
		 const size_t *start, size_t nelems, const longlong *value)
#line 801
{
#line 801
	off_t offset = NC_varoffset(ncp, varp, start);
#line 801
	size_t remaining = varp->xsz * nelems;
#line 801
	int status = NC_NOERR;
#line 801
	void *xp;
#line 801
        void *fillp=NULL;
#line 801

#line 801
	NC_UNUSED(fillp);
#line 801

#line 801
	if(nelems == 0)
#line 801
		return NC_NOERR;
#line 801

#line 801
	assert(value != NULL);
#line 801

#line 801
#ifdef ERANGE_FILL
#line 801
        fillp = malloc(varp->xsz);
#line 801
        status = NC3_inq_var_fill(varp, fillp);
#line 801
#endif
#line 801

#line 801
	for(;;)
#line 801
	{
#line 801
		size_t extent = MIN(remaining, ncp->chunk);
#line 801
		size_t nput = ncx_howmany(varp->type, extent);
#line 801

#line 801
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 801
				 RGN_WRITE, &xp);
#line 801
		if(lstatus != NC_NOERR)
#line 801
			return lstatus;
#line 801

#line 801
		lstatus = ncx_putn_ulonglong_longlong(&xp, nput, value ,fillp);
#line 801
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 801
		{
#line 801
			/* not fatal to the loop */
#line 801
			status = lstatus;
#line 801
		}
#line 801

#line 801
		(void) ncio_rel(ncp->nciop, offset,
#line 801
				 RGN_MODIFIED);
#line 801

#line 801
		remaining -= extent;
#line 801
		if(remaining == 0)
#line 801
			break; /* normal loop exit */
#line 801
		offset += (off_t)extent;
#line 801
		value += nput;
#line 801

#line 801
	}
#line 801
#ifdef ERANGE_FILL
#line 801
        free(fillp);
#line 801
#endif
#line 801

#line 801
	return status;
#line 801
}
#line 801

static int
#line 802
putNCvx_ulonglong_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 802
		 const size_t *start, size_t nelems, const ushort *value)
#line 802
{
#line 802
	off_t offset = NC_varoffset(ncp, varp, start);
#line 802
	size_t remaining = varp->xsz * nelems;
#line 802
	int status = NC_NOERR;
#line 802
	void *xp;
#line 802
        void *fillp=NULL;
#line 802

#line 802
	NC_UNUSED(fillp);
#line 802

#line 802
	if(nelems == 0)
#line 802
		return NC_NOERR;
#line 802

#line 802
	assert(value != NULL);
#line 802

#line 802
#ifdef ERANGE_FILL
#line 802
        fillp = malloc(varp->xsz);
#line 802
        status = NC3_inq_var_fill(varp, fillp);
#line 802
#endif
#line 802

#line 802
	for(;;)
#line 802
	{
#line 802
		size_t extent = MIN(remaining, ncp->chunk);
#line 802
		size_t nput = ncx_howmany(varp->type, extent);
#line 802

#line 802
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 802
				 RGN_WRITE, &xp);
#line 802
		if(lstatus != NC_NOERR)
#line 802
			return lstatus;
#line 802

#line 802
		lstatus = ncx_putn_ulonglong_ushort(&xp, nput, value ,fillp);
#line 802
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 802
		{
#line 802
			/* not fatal to the loop */
#line 802
			status = lstatus;
#line 802
		}
#line 802

#line 802
		(void) ncio_rel(ncp->nciop, offset,
#line 802
				 RGN_MODIFIED);
#line 802

#line 802
		remaining -= extent;
#line 802
		if(remaining == 0)
#line 802
			break; /* normal loop exit */
#line 802
		offset += (off_t)extent;
#line 802
		value += nput;
#line 802

#line 802
	}
#line 802
#ifdef ERANGE_FILL
#line 802
        free(fillp);
#line 802
#endif
#line 802

#line 802
	return status;
#line 802
}
#line 802

static int
#line 803
putNCvx_ulonglong_uint(NC3_INFO* ncp, const NC_var *varp,
#line 803
		 const size_t *start, size_t nelems, const uint *value)
#line 803
{
#line 803
	off_t offset = NC_varoffset(ncp, varp, start);
#line 803
	size_t remaining = varp->xsz * nelems;
#line 803
	int status = NC_NOERR;
#line 803
	void *xp;
#line 803
        void *fillp=NULL;
#line 803

#line 803
	NC_UNUSED(fillp);
#line 803

#line 803
	if(nelems == 0)
#line 803
		return NC_NOERR;
#line 803

#line 803
	assert(value != NULL);
#line 803

#line 803
#ifdef ERANGE_FILL
#line 803
        fillp = malloc(varp->xsz);
#line 803
        status = NC3_inq_var_fill(varp, fillp);
#line 803
#endif
#line 803

#line 803
	for(;;)
#line 803
	{
#line 803
		size_t extent = MIN(remaining, ncp->chunk);
#line 803
		size_t nput = ncx_howmany(varp->type, extent);
#line 803

#line 803
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 803
				 RGN_WRITE, &xp);
#line 803
		if(lstatus != NC_NOERR)
#line 803
			return lstatus;
#line 803

#line 803
		lstatus = ncx_putn_ulonglong_uint(&xp, nput, value ,fillp);
#line 803
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 803
		{
#line 803
			/* not fatal to the loop */
#line 803
			status = lstatus;
#line 803
		}
#line 803

#line 803
		(void) ncio_rel(ncp->nciop, offset,
#line 803
				 RGN_MODIFIED);
#line 803

#line 803
		remaining -= extent;
#line 803
		if(remaining == 0)
#line 803
			break; /* normal loop exit */
#line 803
		offset += (off_t)extent;
#line 803
		value += nput;
#line 803

#line 803
	}
#line 803
#ifdef ERANGE_FILL
#line 803
        free(fillp);
#line 803
#endif
#line 803

#line 803
	return status;
#line 803
}
#line 803

static int
#line 804
putNCvx_ulonglong_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 804
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 804
{
#line 804
	off_t offset = NC_varoffset(ncp, varp, start);
#line 804
	size_t remaining = varp->xsz * nelems;
#line 804
	int status = NC_NOERR;
#line 804
	void *xp;
#line 804
        void *fillp=NULL;
#line 804

#line 804
	NC_UNUSED(fillp);
#line 804

#line 804
	if(nelems == 0)
#line 804
		return NC_NOERR;
#line 804

#line 804
	assert(value != NULL);
#line 804

#line 804
#ifdef ERANGE_FILL
#line 804
        fillp = malloc(varp->xsz);
#line 804
        status = NC3_inq_var_fill(varp, fillp);
#line 804
#endif
#line 804

#line 804
	for(;;)
#line 804
	{
#line 804
		size_t extent = MIN(remaining, ncp->chunk);
#line 804
		size_t nput = ncx_howmany(varp->type, extent);
#line 804

#line 804
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 804
				 RGN_WRITE, &xp);
#line 804
		if(lstatus != NC_NOERR)
#line 804
			return lstatus;
#line 804

#line 804
		lstatus = ncx_putn_ulonglong_ulonglong(&xp, nput, value ,fillp);
#line 804
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 804
		{
#line 804
			/* not fatal to the loop */
#line 804
			status = lstatus;
#line 804
		}
#line 804

#line 804
		(void) ncio_rel(ncp->nciop, offset,
#line 804
				 RGN_MODIFIED);
#line 804

#line 804
		remaining -= extent;
#line 804
		if(remaining == 0)
#line 804
			break; /* normal loop exit */
#line 804
		offset += (off_t)extent;
#line 804
		value += nput;
#line 804

#line 804
	}
#line 804
#ifdef ERANGE_FILL
#line 804
        free(fillp);
#line 804
#endif
#line 804

#line 804
	return status;
#line 804
}
#line 804


#line 851

#if 0 /*unused*/
static int
#line 853
getNCvx_char_char(const NC3_INFO* ncp, const NC_var *varp,
#line 853
		 const size_t *start, size_t nelems, char *value)
#line 853
{
#line 853
	off_t offset = NC_varoffset(ncp, varp, start);
#line 853
	size_t remaining = varp->xsz * nelems;
#line 853
	int status = NC_NOERR;
#line 853
	const void *xp;
#line 853

#line 853
	if(nelems == 0)
#line 853
		return NC_NOERR;
#line 853

#line 853
	assert(value != NULL);
#line 853

#line 853
	for(;;)
#line 853
	{
#line 853
		size_t extent = MIN(remaining, ncp->chunk);
#line 853
		size_t nget = ncx_howmany(varp->type, extent);
#line 853

#line 853
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 853
				 0, (void **)&xp);	/* cast away const */
#line 853
		if(lstatus != NC_NOERR)
#line 853
			return lstatus;
#line 853

#line 853
		lstatus = ncx_getn_char_char(&xp, nget, value);
#line 853
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 853
			status = lstatus;
#line 853

#line 853
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 853

#line 853
		remaining -= extent;
#line 853
		if(remaining == 0)
#line 853
			break; /* normal loop exit */
#line 853
		offset += (off_t)extent;
#line 853
		value += nget;
#line 853
	}
#line 853

#line 853
	return status;
#line 853
}
#line 853

#endif

static int
#line 856
getNCvx_schar_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 856
		 const size_t *start, size_t nelems, schar *value)
#line 856
{
#line 856
	off_t offset = NC_varoffset(ncp, varp, start);
#line 856
	size_t remaining = varp->xsz * nelems;
#line 856
	int status = NC_NOERR;
#line 856
	const void *xp;
#line 856

#line 856
	if(nelems == 0)
#line 856
		return NC_NOERR;
#line 856

#line 856
	assert(value != NULL);
#line 856

#line 856
	for(;;)
#line 856
	{
#line 856
		size_t extent = MIN(remaining, ncp->chunk);
#line 856
		size_t nget = ncx_howmany(varp->type, extent);
#line 856

#line 856
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 856
				 0, (void **)&xp);	/* cast away const */
#line 856
		if(lstatus != NC_NOERR)
#line 856
			return lstatus;
#line 856

#line 856
		lstatus = ncx_getn_schar_schar(&xp, nget, value);
#line 856
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 856
			status = lstatus;
#line 856

#line 856
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 856

#line 856
		remaining -= extent;
#line 856
		if(remaining == 0)
#line 856
			break; /* normal loop exit */
#line 856
		offset += (off_t)extent;
#line 856
		value += nget;
#line 856
	}
#line 856

#line 856
	return status;
#line 856
}
#line 856

static int
#line 857
getNCvx_schar_short(const NC3_INFO* ncp, const NC_var *varp,
#line 857
		 const size_t *start, size_t nelems, short *value)
#line 857
{
#line 857
	off_t offset = NC_varoffset(ncp, varp, start);
#line 857
	size_t remaining = varp->xsz * nelems;
#line 857
	int status = NC_NOERR;
#line 857
	const void *xp;
#line 857

#line 857
	if(nelems == 0)
#line 857
		return NC_NOERR;
#line 857

#line 857
	assert(value != NULL);
#line 857

#line 857
	for(;;)
#line 857
	{
#line 857
		size_t extent = MIN(remaining, ncp->chunk);
#line 857
		size_t nget = ncx_howmany(varp->type, extent);
#line 857

#line 857
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 857
				 0, (void **)&xp);	/* cast away const */
#line 857
		if(lstatus != NC_NOERR)
#line 857
			return lstatus;
#line 857

#line 857
		lstatus = ncx_getn_schar_short(&xp, nget, value);
#line 857
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 857
			status = lstatus;
#line 857

#line 857
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 857

#line 857
		remaining -= extent;
#line 857
		if(remaining == 0)
#line 857
			break; /* normal loop exit */
#line 857
		offset += (off_t)extent;
#line 857
		value += nget;
#line 857
	}
#line 857

#line 857
	return status;
#line 857
}
#line 857

static int
#line 858
getNCvx_schar_int(const NC3_INFO* ncp, const NC_var *varp,
#line 858
		 const size_t *start, size_t nelems, int *value)
#line 858
{
#line 858
	off_t offset = NC_varoffset(ncp, varp, start);
#line 858
	size_t remaining = varp->xsz * nelems;
#line 858
	int status = NC_NOERR;
#line 858
	const void *xp;
#line 858

#line 858
	if(nelems == 0)
#line 858
		return NC_NOERR;
#line 858

#line 858
	assert(value != NULL);
#line 858

#line 858
	for(;;)
#line 858
	{
#line 858
		size_t extent = MIN(remaining, ncp->chunk);
#line 858
		size_t nget = ncx_howmany(varp->type, extent);
#line 858

#line 858
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 858
				 0, (void **)&xp);	/* cast away const */
#line 858
		if(lstatus != NC_NOERR)
#line 858
			return lstatus;
#line 858

#line 858
		lstatus = ncx_getn_schar_int(&xp, nget, value);
#line 858
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 858
			status = lstatus;
#line 858

#line 858
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 858

#line 858
		remaining -= extent;
#line 858
		if(remaining == 0)
#line 858
			break; /* normal loop exit */
#line 858
		offset += (off_t)extent;
#line 858
		value += nget;
#line 858
	}
#line 858

#line 858
	return status;
#line 858
}
#line 858

static int
#line 859
getNCvx_schar_float(const NC3_INFO* ncp, const NC_var *varp,
#line 859
		 const size_t *start, size_t nelems, float *value)
#line 859
{
#line 859
	off_t offset = NC_varoffset(ncp, varp, start);
#line 859
	size_t remaining = varp->xsz * nelems;
#line 859
	int status = NC_NOERR;
#line 859
	const void *xp;
#line 859

#line 859
	if(nelems == 0)
#line 859
		return NC_NOERR;
#line 859

#line 859
	assert(value != NULL);
#line 859

#line 859
	for(;;)
#line 859
	{
#line 859
		size_t extent = MIN(remaining, ncp->chunk);
#line 859
		size_t nget = ncx_howmany(varp->type, extent);
#line 859

#line 859
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 859
				 0, (void **)&xp);	/* cast away const */
#line 859
		if(lstatus != NC_NOERR)
#line 859
			return lstatus;
#line 859

#line 859
		lstatus = ncx_getn_schar_float(&xp, nget, value);
#line 859
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 859
			status = lstatus;
#line 859

#line 859
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 859

#line 859
		remaining -= extent;
#line 859
		if(remaining == 0)
#line 859
			break; /* normal loop exit */
#line 859
		offset += (off_t)extent;
#line 859
		value += nget;
#line 859
	}
#line 859

#line 859
	return status;
#line 859
}
#line 859

static int
#line 860
getNCvx_schar_double(const NC3_INFO* ncp, const NC_var *varp,
#line 860
		 const size_t *start, size_t nelems, double *value)
#line 860
{
#line 860
	off_t offset = NC_varoffset(ncp, varp, start);
#line 860
	size_t remaining = varp->xsz * nelems;
#line 860
	int status = NC_NOERR;
#line 860
	const void *xp;
#line 860

#line 860
	if(nelems == 0)
#line 860
		return NC_NOERR;
#line 860

#line 860
	assert(value != NULL);
#line 860

#line 860
	for(;;)
#line 860
	{
#line 860
		size_t extent = MIN(remaining, ncp->chunk);
#line 860
		size_t nget = ncx_howmany(varp->type, extent);
#line 860

#line 860
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 860
				 0, (void **)&xp);	/* cast away const */
#line 860
		if(lstatus != NC_NOERR)
#line 860
			return lstatus;
#line 860

#line 860
		lstatus = ncx_getn_schar_double(&xp, nget, value);
#line 860
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 860
			status = lstatus;
#line 860

#line 860
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 860

#line 860
		remaining -= extent;
#line 860
		if(remaining == 0)
#line 860
			break; /* normal loop exit */
#line 860
		offset += (off_t)extent;
#line 860
		value += nget;
#line 860
	}
#line 860

#line 860
	return status;
#line 860
}
#line 860

static int
#line 861
getNCvx_schar_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 861
		 const size_t *start, size_t nelems, longlong *value)
#line 861
{
#line 861
	off_t offset = NC_varoffset(ncp, varp, start);
#line 861
	size_t remaining = varp->xsz * nelems;
#line 861
	int status = NC_NOERR;
#line 861
	const void *xp;
#line 861

#line 861
	if(nelems == 0)
#line 861
		return NC_NOERR;
#line 861

#line 861
	assert(value != NULL);
#line 861

#line 861
	for(;;)
#line 861
	{
#line 861
		size_t extent = MIN(remaining, ncp->chunk);
#line 861
		size_t nget = ncx_howmany(varp->type, extent);
#line 861

#line 861
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 861
				 0, (void **)&xp);	/* cast away const */
#line 861
		if(lstatus != NC_NOERR)
#line 861
			return lstatus;
#line 861

#line 861
		lstatus = ncx_getn_schar_longlong(&xp, nget, value);
#line 861
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 861
			status = lstatus;
#line 861

#line 861
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 861

#line 861
		remaining -= extent;
#line 861
		if(remaining == 0)
#line 861
			break; /* normal loop exit */
#line 861
		offset += (off_t)extent;
#line 861
		value += nget;
#line 861
	}
#line 861

#line 861
	return status;
#line 861
}
#line 861

static int
#line 862
getNCvx_schar_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 862
		 const size_t *start, size_t nelems, uint *value)
#line 862
{
#line 862
	off_t offset = NC_varoffset(ncp, varp, start);
#line 862
	size_t remaining = varp->xsz * nelems;
#line 862
	int status = NC_NOERR;
#line 862
	const void *xp;
#line 862

#line 862
	if(nelems == 0)
#line 862
		return NC_NOERR;
#line 862

#line 862
	assert(value != NULL);
#line 862

#line 862
	for(;;)
#line 862
	{
#line 862
		size_t extent = MIN(remaining, ncp->chunk);
#line 862
		size_t nget = ncx_howmany(varp->type, extent);
#line 862

#line 862
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 862
				 0, (void **)&xp);	/* cast away const */
#line 862
		if(lstatus != NC_NOERR)
#line 862
			return lstatus;
#line 862

#line 862
		lstatus = ncx_getn_schar_uint(&xp, nget, value);
#line 862
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 862
			status = lstatus;
#line 862

#line 862
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 862

#line 862
		remaining -= extent;
#line 862
		if(remaining == 0)
#line 862
			break; /* normal loop exit */
#line 862
		offset += (off_t)extent;
#line 862
		value += nget;
#line 862
	}
#line 862

#line 862
	return status;
#line 862
}
#line 862

static int
#line 863
getNCvx_schar_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 863
		 const size_t *start, size_t nelems, ulonglong *value)
#line 863
{
#line 863
	off_t offset = NC_varoffset(ncp, varp, start);
#line 863
	size_t remaining = varp->xsz * nelems;
#line 863
	int status = NC_NOERR;
#line 863
	const void *xp;
#line 863

#line 863
	if(nelems == 0)
#line 863
		return NC_NOERR;
#line 863

#line 863
	assert(value != NULL);
#line 863

#line 863
	for(;;)
#line 863
	{
#line 863
		size_t extent = MIN(remaining, ncp->chunk);
#line 863
		size_t nget = ncx_howmany(varp->type, extent);
#line 863

#line 863
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 863
				 0, (void **)&xp);	/* cast away const */
#line 863
		if(lstatus != NC_NOERR)
#line 863
			return lstatus;
#line 863

#line 863
		lstatus = ncx_getn_schar_ulonglong(&xp, nget, value);
#line 863
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 863
			status = lstatus;
#line 863

#line 863
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 863

#line 863
		remaining -= extent;
#line 863
		if(remaining == 0)
#line 863
			break; /* normal loop exit */
#line 863
		offset += (off_t)extent;
#line 863
		value += nget;
#line 863
	}
#line 863

#line 863
	return status;
#line 863
}
#line 863

static int
#line 864
getNCvx_schar_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 864
		 const size_t *start, size_t nelems, uchar *value)
#line 864
{
#line 864
	off_t offset = NC_varoffset(ncp, varp, start);
#line 864
	size_t remaining = varp->xsz * nelems;
#line 864
	int status = NC_NOERR;
#line 864
	const void *xp;
#line 864

#line 864
	if(nelems == 0)
#line 864
		return NC_NOERR;
#line 864

#line 864
	assert(value != NULL);
#line 864

#line 864
	for(;;)
#line 864
	{
#line 864
		size_t extent = MIN(remaining, ncp->chunk);
#line 864
		size_t nget = ncx_howmany(varp->type, extent);
#line 864

#line 864
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 864
				 0, (void **)&xp);	/* cast away const */
#line 864
		if(lstatus != NC_NOERR)
#line 864
			return lstatus;
#line 864

#line 864
		lstatus = ncx_getn_schar_uchar(&xp, nget, value);
#line 864
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 864
			status = lstatus;
#line 864

#line 864
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 864

#line 864
		remaining -= extent;
#line 864
		if(remaining == 0)
#line 864
			break; /* normal loop exit */
#line 864
		offset += (off_t)extent;
#line 864
		value += nget;
#line 864
	}
#line 864

#line 864
	return status;
#line 864
}
#line 864

static int
#line 865
getNCvx_schar_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 865
		 const size_t *start, size_t nelems, ushort *value)
#line 865
{
#line 865
	off_t offset = NC_varoffset(ncp, varp, start);
#line 865
	size_t remaining = varp->xsz * nelems;
#line 865
	int status = NC_NOERR;
#line 865
	const void *xp;
#line 865

#line 865
	if(nelems == 0)
#line 865
		return NC_NOERR;
#line 865

#line 865
	assert(value != NULL);
#line 865

#line 865
	for(;;)
#line 865
	{
#line 865
		size_t extent = MIN(remaining, ncp->chunk);
#line 865
		size_t nget = ncx_howmany(varp->type, extent);
#line 865

#line 865
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 865
				 0, (void **)&xp);	/* cast away const */
#line 865
		if(lstatus != NC_NOERR)
#line 865
			return lstatus;
#line 865

#line 865
		lstatus = ncx_getn_schar_ushort(&xp, nget, value);
#line 865
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 865
			status = lstatus;
#line 865

#line 865
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 865

#line 865
		remaining -= extent;
#line 865
		if(remaining == 0)
#line 865
			break; /* normal loop exit */
#line 865
		offset += (off_t)extent;
#line 865
		value += nget;
#line 865
	}
#line 865

#line 865
	return status;
#line 865
}
#line 865


static int
#line 867
getNCvx_short_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 867
		 const size_t *start, size_t nelems, schar *value)
#line 867
{
#line 867
	off_t offset = NC_varoffset(ncp, varp, start);
#line 867
	size_t remaining = varp->xsz * nelems;
#line 867
	int status = NC_NOERR;
#line 867
	const void *xp;
#line 867

#line 867
	if(nelems == 0)
#line 867
		return NC_NOERR;
#line 867

#line 867
	assert(value != NULL);
#line 867

#line 867
	for(;;)
#line 867
	{
#line 867
		size_t extent = MIN(remaining, ncp->chunk);
#line 867
		size_t nget = ncx_howmany(varp->type, extent);
#line 867

#line 867
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 867
				 0, (void **)&xp);	/* cast away const */
#line 867
		if(lstatus != NC_NOERR)
#line 867
			return lstatus;
#line 867

#line 867
		lstatus = ncx_getn_short_schar(&xp, nget, value);
#line 867
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 867
			status = lstatus;
#line 867

#line 867
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 867

#line 867
		remaining -= extent;
#line 867
		if(remaining == 0)
#line 867
			break; /* normal loop exit */
#line 867
		offset += (off_t)extent;
#line 867
		value += nget;
#line 867
	}
#line 867

#line 867
	return status;
#line 867
}
#line 867

static int
#line 868
getNCvx_short_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 868
		 const size_t *start, size_t nelems, uchar *value)
#line 868
{
#line 868
	off_t offset = NC_varoffset(ncp, varp, start);
#line 868
	size_t remaining = varp->xsz * nelems;
#line 868
	int status = NC_NOERR;
#line 868
	const void *xp;
#line 868

#line 868
	if(nelems == 0)
#line 868
		return NC_NOERR;
#line 868

#line 868
	assert(value != NULL);
#line 868

#line 868
	for(;;)
#line 868
	{
#line 868
		size_t extent = MIN(remaining, ncp->chunk);
#line 868
		size_t nget = ncx_howmany(varp->type, extent);
#line 868

#line 868
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 868
				 0, (void **)&xp);	/* cast away const */
#line 868
		if(lstatus != NC_NOERR)
#line 868
			return lstatus;
#line 868

#line 868
		lstatus = ncx_getn_short_uchar(&xp, nget, value);
#line 868
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 868
			status = lstatus;
#line 868

#line 868
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 868

#line 868
		remaining -= extent;
#line 868
		if(remaining == 0)
#line 868
			break; /* normal loop exit */
#line 868
		offset += (off_t)extent;
#line 868
		value += nget;
#line 868
	}
#line 868

#line 868
	return status;
#line 868
}
#line 868

static int
#line 869
getNCvx_short_short(const NC3_INFO* ncp, const NC_var *varp,
#line 869
		 const size_t *start, size_t nelems, short *value)
#line 869
{
#line 869
	off_t offset = NC_varoffset(ncp, varp, start);
#line 869
	size_t remaining = varp->xsz * nelems;
#line 869
	int status = NC_NOERR;
#line 869
	const void *xp;
#line 869

#line 869
	if(nelems == 0)
#line 869
		return NC_NOERR;
#line 869

#line 869
	assert(value != NULL);
#line 869

#line 869
	for(;;)
#line 869
	{
#line 869
		size_t extent = MIN(remaining, ncp->chunk);
#line 869
		size_t nget = ncx_howmany(varp->type, extent);
#line 869

#line 869
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 869
				 0, (void **)&xp);	/* cast away const */
#line 869
		if(lstatus != NC_NOERR)
#line 869
			return lstatus;
#line 869

#line 869
		lstatus = ncx_getn_short_short(&xp, nget, value);
#line 869
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 869
			status = lstatus;
#line 869

#line 869
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 869

#line 869
		remaining -= extent;
#line 869
		if(remaining == 0)
#line 869
			break; /* normal loop exit */
#line 869
		offset += (off_t)extent;
#line 869
		value += nget;
#line 869
	}
#line 869

#line 869
	return status;
#line 869
}
#line 869

static int
#line 870
getNCvx_short_int(const NC3_INFO* ncp, const NC_var *varp,
#line 870
		 const size_t *start, size_t nelems, int *value)
#line 870
{
#line 870
	off_t offset = NC_varoffset(ncp, varp, start);
#line 870
	size_t remaining = varp->xsz * nelems;
#line 870
	int status = NC_NOERR;
#line 870
	const void *xp;
#line 870

#line 870
	if(nelems == 0)
#line 870
		return NC_NOERR;
#line 870

#line 870
	assert(value != NULL);
#line 870

#line 870
	for(;;)
#line 870
	{
#line 870
		size_t extent = MIN(remaining, ncp->chunk);
#line 870
		size_t nget = ncx_howmany(varp->type, extent);
#line 870

#line 870
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 870
				 0, (void **)&xp);	/* cast away const */
#line 870
		if(lstatus != NC_NOERR)
#line 870
			return lstatus;
#line 870

#line 870
		lstatus = ncx_getn_short_int(&xp, nget, value);
#line 870
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 870
			status = lstatus;
#line 870

#line 870
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 870

#line 870
		remaining -= extent;
#line 870
		if(remaining == 0)
#line 870
			break; /* normal loop exit */
#line 870
		offset += (off_t)extent;
#line 870
		value += nget;
#line 870
	}
#line 870

#line 870
	return status;
#line 870
}
#line 870

static int
#line 871
getNCvx_short_float(const NC3_INFO* ncp, const NC_var *varp,
#line 871
		 const size_t *start, size_t nelems, float *value)
#line 871
{
#line 871
	off_t offset = NC_varoffset(ncp, varp, start);
#line 871
	size_t remaining = varp->xsz * nelems;
#line 871
	int status = NC_NOERR;
#line 871
	const void *xp;
#line 871

#line 871
	if(nelems == 0)
#line 871
		return NC_NOERR;
#line 871

#line 871
	assert(value != NULL);
#line 871

#line 871
	for(;;)
#line 871
	{
#line 871
		size_t extent = MIN(remaining, ncp->chunk);
#line 871
		size_t nget = ncx_howmany(varp->type, extent);
#line 871

#line 871
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 871
				 0, (void **)&xp);	/* cast away const */
#line 871
		if(lstatus != NC_NOERR)
#line 871
			return lstatus;
#line 871

#line 871
		lstatus = ncx_getn_short_float(&xp, nget, value);
#line 871
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 871
			status = lstatus;
#line 871

#line 871
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 871

#line 871
		remaining -= extent;
#line 871
		if(remaining == 0)
#line 871
			break; /* normal loop exit */
#line 871
		offset += (off_t)extent;
#line 871
		value += nget;
#line 871
	}
#line 871

#line 871
	return status;
#line 871
}
#line 871

static int
#line 872
getNCvx_short_double(const NC3_INFO* ncp, const NC_var *varp,
#line 872
		 const size_t *start, size_t nelems, double *value)
#line 872
{
#line 872
	off_t offset = NC_varoffset(ncp, varp, start);
#line 872
	size_t remaining = varp->xsz * nelems;
#line 872
	int status = NC_NOERR;
#line 872
	const void *xp;
#line 872

#line 872
	if(nelems == 0)
#line 872
		return NC_NOERR;
#line 872

#line 872
	assert(value != NULL);
#line 872

#line 872
	for(;;)
#line 872
	{
#line 872
		size_t extent = MIN(remaining, ncp->chunk);
#line 872
		size_t nget = ncx_howmany(varp->type, extent);
#line 872

#line 872
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 872
				 0, (void **)&xp);	/* cast away const */
#line 872
		if(lstatus != NC_NOERR)
#line 872
			return lstatus;
#line 872

#line 872
		lstatus = ncx_getn_short_double(&xp, nget, value);
#line 872
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 872
			status = lstatus;
#line 872

#line 872
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 872

#line 872
		remaining -= extent;
#line 872
		if(remaining == 0)
#line 872
			break; /* normal loop exit */
#line 872
		offset += (off_t)extent;
#line 872
		value += nget;
#line 872
	}
#line 872

#line 872
	return status;
#line 872
}
#line 872

static int
#line 873
getNCvx_short_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 873
		 const size_t *start, size_t nelems, longlong *value)
#line 873
{
#line 873
	off_t offset = NC_varoffset(ncp, varp, start);
#line 873
	size_t remaining = varp->xsz * nelems;
#line 873
	int status = NC_NOERR;
#line 873
	const void *xp;
#line 873

#line 873
	if(nelems == 0)
#line 873
		return NC_NOERR;
#line 873

#line 873
	assert(value != NULL);
#line 873

#line 873
	for(;;)
#line 873
	{
#line 873
		size_t extent = MIN(remaining, ncp->chunk);
#line 873
		size_t nget = ncx_howmany(varp->type, extent);
#line 873

#line 873
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 873
				 0, (void **)&xp);	/* cast away const */
#line 873
		if(lstatus != NC_NOERR)
#line 873
			return lstatus;
#line 873

#line 873
		lstatus = ncx_getn_short_longlong(&xp, nget, value);
#line 873
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 873
			status = lstatus;
#line 873

#line 873
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 873

#line 873
		remaining -= extent;
#line 873
		if(remaining == 0)
#line 873
			break; /* normal loop exit */
#line 873
		offset += (off_t)extent;
#line 873
		value += nget;
#line 873
	}
#line 873

#line 873
	return status;
#line 873
}
#line 873

static int
#line 874
getNCvx_short_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 874
		 const size_t *start, size_t nelems, uint *value)
#line 874
{
#line 874
	off_t offset = NC_varoffset(ncp, varp, start);
#line 874
	size_t remaining = varp->xsz * nelems;
#line 874
	int status = NC_NOERR;
#line 874
	const void *xp;
#line 874

#line 874
	if(nelems == 0)
#line 874
		return NC_NOERR;
#line 874

#line 874
	assert(value != NULL);
#line 874

#line 874
	for(;;)
#line 874
	{
#line 874
		size_t extent = MIN(remaining, ncp->chunk);
#line 874
		size_t nget = ncx_howmany(varp->type, extent);
#line 874

#line 874
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 874
				 0, (void **)&xp);	/* cast away const */
#line 874
		if(lstatus != NC_NOERR)
#line 874
			return lstatus;
#line 874

#line 874
		lstatus = ncx_getn_short_uint(&xp, nget, value);
#line 874
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 874
			status = lstatus;
#line 874

#line 874
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 874

#line 874
		remaining -= extent;
#line 874
		if(remaining == 0)
#line 874
			break; /* normal loop exit */
#line 874
		offset += (off_t)extent;
#line 874
		value += nget;
#line 874
	}
#line 874

#line 874
	return status;
#line 874
}
#line 874

static int
#line 875
getNCvx_short_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 875
		 const size_t *start, size_t nelems, ulonglong *value)
#line 875
{
#line 875
	off_t offset = NC_varoffset(ncp, varp, start);
#line 875
	size_t remaining = varp->xsz * nelems;
#line 875
	int status = NC_NOERR;
#line 875
	const void *xp;
#line 875

#line 875
	if(nelems == 0)
#line 875
		return NC_NOERR;
#line 875

#line 875
	assert(value != NULL);
#line 875

#line 875
	for(;;)
#line 875
	{
#line 875
		size_t extent = MIN(remaining, ncp->chunk);
#line 875
		size_t nget = ncx_howmany(varp->type, extent);
#line 875

#line 875
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 875
				 0, (void **)&xp);	/* cast away const */
#line 875
		if(lstatus != NC_NOERR)
#line 875
			return lstatus;
#line 875

#line 875
		lstatus = ncx_getn_short_ulonglong(&xp, nget, value);
#line 875
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 875
			status = lstatus;
#line 875

#line 875
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 875

#line 875
		remaining -= extent;
#line 875
		if(remaining == 0)
#line 875
			break; /* normal loop exit */
#line 875
		offset += (off_t)extent;
#line 875
		value += nget;
#line 875
	}
#line 875

#line 875
	return status;
#line 875
}
#line 875

static int
#line 876
getNCvx_short_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 876
		 const size_t *start, size_t nelems, ushort *value)
#line 876
{
#line 876
	off_t offset = NC_varoffset(ncp, varp, start);
#line 876
	size_t remaining = varp->xsz * nelems;
#line 876
	int status = NC_NOERR;
#line 876
	const void *xp;
#line 876

#line 876
	if(nelems == 0)
#line 876
		return NC_NOERR;
#line 876

#line 876
	assert(value != NULL);
#line 876

#line 876
	for(;;)
#line 876
	{
#line 876
		size_t extent = MIN(remaining, ncp->chunk);
#line 876
		size_t nget = ncx_howmany(varp->type, extent);
#line 876

#line 876
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 876
				 0, (void **)&xp);	/* cast away const */
#line 876
		if(lstatus != NC_NOERR)
#line 876
			return lstatus;
#line 876

#line 876
		lstatus = ncx_getn_short_ushort(&xp, nget, value);
#line 876
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 876
			status = lstatus;
#line 876

#line 876
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 876

#line 876
		remaining -= extent;
#line 876
		if(remaining == 0)
#line 876
			break; /* normal loop exit */
#line 876
		offset += (off_t)extent;
#line 876
		value += nget;
#line 876
	}
#line 876

#line 876
	return status;
#line 876
}
#line 876


static int
#line 878
getNCvx_int_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 878
		 const size_t *start, size_t nelems, schar *value)
#line 878
{
#line 878
	off_t offset = NC_varoffset(ncp, varp, start);
#line 878
	size_t remaining = varp->xsz * nelems;
#line 878
	int status = NC_NOERR;
#line 878
	const void *xp;
#line 878

#line 878
	if(nelems == 0)
#line 878
		return NC_NOERR;
#line 878

#line 878
	assert(value != NULL);
#line 878

#line 878
	for(;;)
#line 878
	{
#line 878
		size_t extent = MIN(remaining, ncp->chunk);
#line 878
		size_t nget = ncx_howmany(varp->type, extent);
#line 878

#line 878
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 878
				 0, (void **)&xp);	/* cast away const */
#line 878
		if(lstatus != NC_NOERR)
#line 878
			return lstatus;
#line 878

#line 878
		lstatus = ncx_getn_int_schar(&xp, nget, value);
#line 878
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 878
			status = lstatus;
#line 878

#line 878
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 878

#line 878
		remaining -= extent;
#line 878
		if(remaining == 0)
#line 878
			break; /* normal loop exit */
#line 878
		offset += (off_t)extent;
#line 878
		value += nget;
#line 878
	}
#line 878

#line 878
	return status;
#line 878
}
#line 878

static int
#line 879
getNCvx_int_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 879
		 const size_t *start, size_t nelems, uchar *value)
#line 879
{
#line 879
	off_t offset = NC_varoffset(ncp, varp, start);
#line 879
	size_t remaining = varp->xsz * nelems;
#line 879
	int status = NC_NOERR;
#line 879
	const void *xp;
#line 879

#line 879
	if(nelems == 0)
#line 879
		return NC_NOERR;
#line 879

#line 879
	assert(value != NULL);
#line 879

#line 879
	for(;;)
#line 879
	{
#line 879
		size_t extent = MIN(remaining, ncp->chunk);
#line 879
		size_t nget = ncx_howmany(varp->type, extent);
#line 879

#line 879
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 879
				 0, (void **)&xp);	/* cast away const */
#line 879
		if(lstatus != NC_NOERR)
#line 879
			return lstatus;
#line 879

#line 879
		lstatus = ncx_getn_int_uchar(&xp, nget, value);
#line 879
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 879
			status = lstatus;
#line 879

#line 879
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 879

#line 879
		remaining -= extent;
#line 879
		if(remaining == 0)
#line 879
			break; /* normal loop exit */
#line 879
		offset += (off_t)extent;
#line 879
		value += nget;
#line 879
	}
#line 879

#line 879
	return status;
#line 879
}
#line 879

static int
#line 880
getNCvx_int_short(const NC3_INFO* ncp, const NC_var *varp,
#line 880
		 const size_t *start, size_t nelems, short *value)
#line 880
{
#line 880
	off_t offset = NC_varoffset(ncp, varp, start);
#line 880
	size_t remaining = varp->xsz * nelems;
#line 880
	int status = NC_NOERR;
#line 880
	const void *xp;
#line 880

#line 880
	if(nelems == 0)
#line 880
		return NC_NOERR;
#line 880

#line 880
	assert(value != NULL);
#line 880

#line 880
	for(;;)
#line 880
	{
#line 880
		size_t extent = MIN(remaining, ncp->chunk);
#line 880
		size_t nget = ncx_howmany(varp->type, extent);
#line 880

#line 880
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 880
				 0, (void **)&xp);	/* cast away const */
#line 880
		if(lstatus != NC_NOERR)
#line 880
			return lstatus;
#line 880

#line 880
		lstatus = ncx_getn_int_short(&xp, nget, value);
#line 880
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 880
			status = lstatus;
#line 880

#line 880
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 880

#line 880
		remaining -= extent;
#line 880
		if(remaining == 0)
#line 880
			break; /* normal loop exit */
#line 880
		offset += (off_t)extent;
#line 880
		value += nget;
#line 880
	}
#line 880

#line 880
	return status;
#line 880
}
#line 880

static int
#line 881
getNCvx_int_int(const NC3_INFO* ncp, const NC_var *varp,
#line 881
		 const size_t *start, size_t nelems, int *value)
#line 881
{
#line 881
	off_t offset = NC_varoffset(ncp, varp, start);
#line 881
	size_t remaining = varp->xsz * nelems;
#line 881
	int status = NC_NOERR;
#line 881
	const void *xp;
#line 881

#line 881
	if(nelems == 0)
#line 881
		return NC_NOERR;
#line 881

#line 881
	assert(value != NULL);
#line 881

#line 881
	for(;;)
#line 881
	{
#line 881
		size_t extent = MIN(remaining, ncp->chunk);
#line 881
		size_t nget = ncx_howmany(varp->type, extent);
#line 881

#line 881
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 881
				 0, (void **)&xp);	/* cast away const */
#line 881
		if(lstatus != NC_NOERR)
#line 881
			return lstatus;
#line 881

#line 881
		lstatus = ncx_getn_int_int(&xp, nget, value);
#line 881
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 881
			status = lstatus;
#line 881

#line 881
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 881

#line 881
		remaining -= extent;
#line 881
		if(remaining == 0)
#line 881
			break; /* normal loop exit */
#line 881
		offset += (off_t)extent;
#line 881
		value += nget;
#line 881
	}
#line 881

#line 881
	return status;
#line 881
}
#line 881

static int
#line 882
getNCvx_int_float(const NC3_INFO* ncp, const NC_var *varp,
#line 882
		 const size_t *start, size_t nelems, float *value)
#line 882
{
#line 882
	off_t offset = NC_varoffset(ncp, varp, start);
#line 882
	size_t remaining = varp->xsz * nelems;
#line 882
	int status = NC_NOERR;
#line 882
	const void *xp;
#line 882

#line 882
	if(nelems == 0)
#line 882
		return NC_NOERR;
#line 882

#line 882
	assert(value != NULL);
#line 882

#line 882
	for(;;)
#line 882
	{
#line 882
		size_t extent = MIN(remaining, ncp->chunk);
#line 882
		size_t nget = ncx_howmany(varp->type, extent);
#line 882

#line 882
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 882
				 0, (void **)&xp);	/* cast away const */
#line 882
		if(lstatus != NC_NOERR)
#line 882
			return lstatus;
#line 882

#line 882
		lstatus = ncx_getn_int_float(&xp, nget, value);
#line 882
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 882
			status = lstatus;
#line 882

#line 882
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 882

#line 882
		remaining -= extent;
#line 882
		if(remaining == 0)
#line 882
			break; /* normal loop exit */
#line 882
		offset += (off_t)extent;
#line 882
		value += nget;
#line 882
	}
#line 882

#line 882
	return status;
#line 882
}
#line 882

static int
#line 883
getNCvx_int_double(const NC3_INFO* ncp, const NC_var *varp,
#line 883
		 const size_t *start, size_t nelems, double *value)
#line 883
{
#line 883
	off_t offset = NC_varoffset(ncp, varp, start);
#line 883
	size_t remaining = varp->xsz * nelems;
#line 883
	int status = NC_NOERR;
#line 883
	const void *xp;
#line 883

#line 883
	if(nelems == 0)
#line 883
		return NC_NOERR;
#line 883

#line 883
	assert(value != NULL);
#line 883

#line 883
	for(;;)
#line 883
	{
#line 883
		size_t extent = MIN(remaining, ncp->chunk);
#line 883
		size_t nget = ncx_howmany(varp->type, extent);
#line 883

#line 883
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 883
				 0, (void **)&xp);	/* cast away const */
#line 883
		if(lstatus != NC_NOERR)
#line 883
			return lstatus;
#line 883

#line 883
		lstatus = ncx_getn_int_double(&xp, nget, value);
#line 883
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 883
			status = lstatus;
#line 883

#line 883
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 883

#line 883
		remaining -= extent;
#line 883
		if(remaining == 0)
#line 883
			break; /* normal loop exit */
#line 883
		offset += (off_t)extent;
#line 883
		value += nget;
#line 883
	}
#line 883

#line 883
	return status;
#line 883
}
#line 883

static int
#line 884
getNCvx_int_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 884
		 const size_t *start, size_t nelems, longlong *value)
#line 884
{
#line 884
	off_t offset = NC_varoffset(ncp, varp, start);
#line 884
	size_t remaining = varp->xsz * nelems;
#line 884
	int status = NC_NOERR;
#line 884
	const void *xp;
#line 884

#line 884
	if(nelems == 0)
#line 884
		return NC_NOERR;
#line 884

#line 884
	assert(value != NULL);
#line 884

#line 884
	for(;;)
#line 884
	{
#line 884
		size_t extent = MIN(remaining, ncp->chunk);
#line 884
		size_t nget = ncx_howmany(varp->type, extent);
#line 884

#line 884
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 884
				 0, (void **)&xp);	/* cast away const */
#line 884
		if(lstatus != NC_NOERR)
#line 884
			return lstatus;
#line 884

#line 884
		lstatus = ncx_getn_int_longlong(&xp, nget, value);
#line 884
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 884
			status = lstatus;
#line 884

#line 884
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 884

#line 884
		remaining -= extent;
#line 884
		if(remaining == 0)
#line 884
			break; /* normal loop exit */
#line 884
		offset += (off_t)extent;
#line 884
		value += nget;
#line 884
	}
#line 884

#line 884
	return status;
#line 884
}
#line 884

static int
#line 885
getNCvx_int_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 885
		 const size_t *start, size_t nelems, uint *value)
#line 885
{
#line 885
	off_t offset = NC_varoffset(ncp, varp, start);
#line 885
	size_t remaining = varp->xsz * nelems;
#line 885
	int status = NC_NOERR;
#line 885
	const void *xp;
#line 885

#line 885
	if(nelems == 0)
#line 885
		return NC_NOERR;
#line 885

#line 885
	assert(value != NULL);
#line 885

#line 885
	for(;;)
#line 885
	{
#line 885
		size_t extent = MIN(remaining, ncp->chunk);
#line 885
		size_t nget = ncx_howmany(varp->type, extent);
#line 885

#line 885
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 885
				 0, (void **)&xp);	/* cast away const */
#line 885
		if(lstatus != NC_NOERR)
#line 885
			return lstatus;
#line 885

#line 885
		lstatus = ncx_getn_int_uint(&xp, nget, value);
#line 885
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 885
			status = lstatus;
#line 885

#line 885
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 885

#line 885
		remaining -= extent;
#line 885
		if(remaining == 0)
#line 885
			break; /* normal loop exit */
#line 885
		offset += (off_t)extent;
#line 885
		value += nget;
#line 885
	}
#line 885

#line 885
	return status;
#line 885
}
#line 885

static int
#line 886
getNCvx_int_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 886
		 const size_t *start, size_t nelems, ulonglong *value)
#line 886
{
#line 886
	off_t offset = NC_varoffset(ncp, varp, start);
#line 886
	size_t remaining = varp->xsz * nelems;
#line 886
	int status = NC_NOERR;
#line 886
	const void *xp;
#line 886

#line 886
	if(nelems == 0)
#line 886
		return NC_NOERR;
#line 886

#line 886
	assert(value != NULL);
#line 886

#line 886
	for(;;)
#line 886
	{
#line 886
		size_t extent = MIN(remaining, ncp->chunk);
#line 886
		size_t nget = ncx_howmany(varp->type, extent);
#line 886

#line 886
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 886
				 0, (void **)&xp);	/* cast away const */
#line 886
		if(lstatus != NC_NOERR)
#line 886
			return lstatus;
#line 886

#line 886
		lstatus = ncx_getn_int_ulonglong(&xp, nget, value);
#line 886
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 886
			status = lstatus;
#line 886

#line 886
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 886

#line 886
		remaining -= extent;
#line 886
		if(remaining == 0)
#line 886
			break; /* normal loop exit */
#line 886
		offset += (off_t)extent;
#line 886
		value += nget;
#line 886
	}
#line 886

#line 886
	return status;
#line 886
}
#line 886

static int
#line 887
getNCvx_int_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 887
		 const size_t *start, size_t nelems, ushort *value)
#line 887
{
#line 887
	off_t offset = NC_varoffset(ncp, varp, start);
#line 887
	size_t remaining = varp->xsz * nelems;
#line 887
	int status = NC_NOERR;
#line 887
	const void *xp;
#line 887

#line 887
	if(nelems == 0)
#line 887
		return NC_NOERR;
#line 887

#line 887
	assert(value != NULL);
#line 887

#line 887
	for(;;)
#line 887
	{
#line 887
		size_t extent = MIN(remaining, ncp->chunk);
#line 887
		size_t nget = ncx_howmany(varp->type, extent);
#line 887

#line 887
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 887
				 0, (void **)&xp);	/* cast away const */
#line 887
		if(lstatus != NC_NOERR)
#line 887
			return lstatus;
#line 887

#line 887
		lstatus = ncx_getn_int_ushort(&xp, nget, value);
#line 887
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 887
			status = lstatus;
#line 887

#line 887
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 887

#line 887
		remaining -= extent;
#line 887
		if(remaining == 0)
#line 887
			break; /* normal loop exit */
#line 887
		offset += (off_t)extent;
#line 887
		value += nget;
#line 887
	}
#line 887

#line 887
	return status;
#line 887
}
#line 887


static int
#line 889
getNCvx_float_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 889
		 const size_t *start, size_t nelems, schar *value)
#line 889
{
#line 889
	off_t offset = NC_varoffset(ncp, varp, start);
#line 889
	size_t remaining = varp->xsz * nelems;
#line 889
	int status = NC_NOERR;
#line 889
	const void *xp;
#line 889

#line 889
	if(nelems == 0)
#line 889
		return NC_NOERR;
#line 889

#line 889
	assert(value != NULL);
#line 889

#line 889
	for(;;)
#line 889
	{
#line 889
		size_t extent = MIN(remaining, ncp->chunk);
#line 889
		size_t nget = ncx_howmany(varp->type, extent);
#line 889

#line 889
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 889
				 0, (void **)&xp);	/* cast away const */
#line 889
		if(lstatus != NC_NOERR)
#line 889
			return lstatus;
#line 889

#line 889
		lstatus = ncx_getn_float_schar(&xp, nget, value);
#line 889
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 889
			status = lstatus;
#line 889

#line 889
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 889

#line 889
		remaining -= extent;
#line 889
		if(remaining == 0)
#line 889
			break; /* normal loop exit */
#line 889
		offset += (off_t)extent;
#line 889
		value += nget;
#line 889
	}
#line 889

#line 889
	return status;
#line 889
}
#line 889

static int
#line 890
getNCvx_float_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 890
		 const size_t *start, size_t nelems, uchar *value)
#line 890
{
#line 890
	off_t offset = NC_varoffset(ncp, varp, start);
#line 890
	size_t remaining = varp->xsz * nelems;
#line 890
	int status = NC_NOERR;
#line 890
	const void *xp;
#line 890

#line 890
	if(nelems == 0)
#line 890
		return NC_NOERR;
#line 890

#line 890
	assert(value != NULL);
#line 890

#line 890
	for(;;)
#line 890
	{
#line 890
		size_t extent = MIN(remaining, ncp->chunk);
#line 890
		size_t nget = ncx_howmany(varp->type, extent);
#line 890

#line 890
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 890
				 0, (void **)&xp);	/* cast away const */
#line 890
		if(lstatus != NC_NOERR)
#line 890
			return lstatus;
#line 890

#line 890
		lstatus = ncx_getn_float_uchar(&xp, nget, value);
#line 890
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 890
			status = lstatus;
#line 890

#line 890
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 890

#line 890
		remaining -= extent;
#line 890
		if(remaining == 0)
#line 890
			break; /* normal loop exit */
#line 890
		offset += (off_t)extent;
#line 890
		value += nget;
#line 890
	}
#line 890

#line 890
	return status;
#line 890
}
#line 890

static int
#line 891
getNCvx_float_short(const NC3_INFO* ncp, const NC_var *varp,
#line 891
		 const size_t *start, size_t nelems, short *value)
#line 891
{
#line 891
	off_t offset = NC_varoffset(ncp, varp, start);
#line 891
	size_t remaining = varp->xsz * nelems;
#line 891
	int status = NC_NOERR;
#line 891
	const void *xp;
#line 891

#line 891
	if(nelems == 0)
#line 891
		return NC_NOERR;
#line 891

#line 891
	assert(value != NULL);
#line 891

#line 891
	for(;;)
#line 891
	{
#line 891
		size_t extent = MIN(remaining, ncp->chunk);
#line 891
		size_t nget = ncx_howmany(varp->type, extent);
#line 891

#line 891
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 891
				 0, (void **)&xp);	/* cast away const */
#line 891
		if(lstatus != NC_NOERR)
#line 891
			return lstatus;
#line 891

#line 891
		lstatus = ncx_getn_float_short(&xp, nget, value);
#line 891
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 891
			status = lstatus;
#line 891

#line 891
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 891

#line 891
		remaining -= extent;
#line 891
		if(remaining == 0)
#line 891
			break; /* normal loop exit */
#line 891
		offset += (off_t)extent;
#line 891
		value += nget;
#line 891
	}
#line 891

#line 891
	return status;
#line 891
}
#line 891

static int
#line 892
getNCvx_float_int(const NC3_INFO* ncp, const NC_var *varp,
#line 892
		 const size_t *start, size_t nelems, int *value)
#line 892
{
#line 892
	off_t offset = NC_varoffset(ncp, varp, start);
#line 892
	size_t remaining = varp->xsz * nelems;
#line 892
	int status = NC_NOERR;
#line 892
	const void *xp;
#line 892

#line 892
	if(nelems == 0)
#line 892
		return NC_NOERR;
#line 892

#line 892
	assert(value != NULL);
#line 892

#line 892
	for(;;)
#line 892
	{
#line 892
		size_t extent = MIN(remaining, ncp->chunk);
#line 892
		size_t nget = ncx_howmany(varp->type, extent);
#line 892

#line 892
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 892
				 0, (void **)&xp);	/* cast away const */
#line 892
		if(lstatus != NC_NOERR)
#line 892
			return lstatus;
#line 892

#line 892
		lstatus = ncx_getn_float_int(&xp, nget, value);
#line 892
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 892
			status = lstatus;
#line 892

#line 892
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 892

#line 892
		remaining -= extent;
#line 892
		if(remaining == 0)
#line 892
			break; /* normal loop exit */
#line 892
		offset += (off_t)extent;
#line 892
		value += nget;
#line 892
	}
#line 892

#line 892
	return status;
#line 892
}
#line 892

static int
#line 893
getNCvx_float_float(const NC3_INFO* ncp, const NC_var *varp,
#line 893
		 const size_t *start, size_t nelems, float *value)
#line 893
{
#line 893
	off_t offset = NC_varoffset(ncp, varp, start);
#line 893
	size_t remaining = varp->xsz * nelems;
#line 893
	int status = NC_NOERR;
#line 893
	const void *xp;
#line 893

#line 893
	if(nelems == 0)
#line 893
		return NC_NOERR;
#line 893

#line 893
	assert(value != NULL);
#line 893

#line 893
	for(;;)
#line 893
	{
#line 893
		size_t extent = MIN(remaining, ncp->chunk);
#line 893
		size_t nget = ncx_howmany(varp->type, extent);
#line 893

#line 893
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 893
				 0, (void **)&xp);	/* cast away const */
#line 893
		if(lstatus != NC_NOERR)
#line 893
			return lstatus;
#line 893

#line 893
		lstatus = ncx_getn_float_float(&xp, nget, value);
#line 893
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 893
			status = lstatus;
#line 893

#line 893
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 893

#line 893
		remaining -= extent;
#line 893
		if(remaining == 0)
#line 893
			break; /* normal loop exit */
#line 893
		offset += (off_t)extent;
#line 893
		value += nget;
#line 893
	}
#line 893

#line 893
	return status;
#line 893
}
#line 893

static int
#line 894
getNCvx_float_double(const NC3_INFO* ncp, const NC_var *varp,
#line 894
		 const size_t *start, size_t nelems, double *value)
#line 894
{
#line 894
	off_t offset = NC_varoffset(ncp, varp, start);
#line 894
	size_t remaining = varp->xsz * nelems;
#line 894
	int status = NC_NOERR;
#line 894
	const void *xp;
#line 894

#line 894
	if(nelems == 0)
#line 894
		return NC_NOERR;
#line 894

#line 894
	assert(value != NULL);
#line 894

#line 894
	for(;;)
#line 894
	{
#line 894
		size_t extent = MIN(remaining, ncp->chunk);
#line 894
		size_t nget = ncx_howmany(varp->type, extent);
#line 894

#line 894
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 894
				 0, (void **)&xp);	/* cast away const */
#line 894
		if(lstatus != NC_NOERR)
#line 894
			return lstatus;
#line 894

#line 894
		lstatus = ncx_getn_float_double(&xp, nget, value);
#line 894
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 894
			status = lstatus;
#line 894

#line 894
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 894

#line 894
		remaining -= extent;
#line 894
		if(remaining == 0)
#line 894
			break; /* normal loop exit */
#line 894
		offset += (off_t)extent;
#line 894
		value += nget;
#line 894
	}
#line 894

#line 894
	return status;
#line 894
}
#line 894

static int
#line 895
getNCvx_float_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 895
		 const size_t *start, size_t nelems, longlong *value)
#line 895
{
#line 895
	off_t offset = NC_varoffset(ncp, varp, start);
#line 895
	size_t remaining = varp->xsz * nelems;
#line 895
	int status = NC_NOERR;
#line 895
	const void *xp;
#line 895

#line 895
	if(nelems == 0)
#line 895
		return NC_NOERR;
#line 895

#line 895
	assert(value != NULL);
#line 895

#line 895
	for(;;)
#line 895
	{
#line 895
		size_t extent = MIN(remaining, ncp->chunk);
#line 895
		size_t nget = ncx_howmany(varp->type, extent);
#line 895

#line 895
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 895
				 0, (void **)&xp);	/* cast away const */
#line 895
		if(lstatus != NC_NOERR)
#line 895
			return lstatus;
#line 895

#line 895
		lstatus = ncx_getn_float_longlong(&xp, nget, value);
#line 895
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 895
			status = lstatus;
#line 895

#line 895
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 895

#line 895
		remaining -= extent;
#line 895
		if(remaining == 0)
#line 895
			break; /* normal loop exit */
#line 895
		offset += (off_t)extent;
#line 895
		value += nget;
#line 895
	}
#line 895

#line 895
	return status;
#line 895
}
#line 895

static int
#line 896
getNCvx_float_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 896
		 const size_t *start, size_t nelems, uint *value)
#line 896
{
#line 896
	off_t offset = NC_varoffset(ncp, varp, start);
#line 896
	size_t remaining = varp->xsz * nelems;
#line 896
	int status = NC_NOERR;
#line 896
	const void *xp;
#line 896

#line 896
	if(nelems == 0)
#line 896
		return NC_NOERR;
#line 896

#line 896
	assert(value != NULL);
#line 896

#line 896
	for(;;)
#line 896
	{
#line 896
		size_t extent = MIN(remaining, ncp->chunk);
#line 896
		size_t nget = ncx_howmany(varp->type, extent);
#line 896

#line 896
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 896
				 0, (void **)&xp);	/* cast away const */
#line 896
		if(lstatus != NC_NOERR)
#line 896
			return lstatus;
#line 896

#line 896
		lstatus = ncx_getn_float_uint(&xp, nget, value);
#line 896
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 896
			status = lstatus;
#line 896

#line 896
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 896

#line 896
		remaining -= extent;
#line 896
		if(remaining == 0)
#line 896
			break; /* normal loop exit */
#line 896
		offset += (off_t)extent;
#line 896
		value += nget;
#line 896
	}
#line 896

#line 896
	return status;
#line 896
}
#line 896

static int
#line 897
getNCvx_float_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 897
		 const size_t *start, size_t nelems, ulonglong *value)
#line 897
{
#line 897
	off_t offset = NC_varoffset(ncp, varp, start);
#line 897
	size_t remaining = varp->xsz * nelems;
#line 897
	int status = NC_NOERR;
#line 897
	const void *xp;
#line 897

#line 897
	if(nelems == 0)
#line 897
		return NC_NOERR;
#line 897

#line 897
	assert(value != NULL);
#line 897

#line 897
	for(;;)
#line 897
	{
#line 897
		size_t extent = MIN(remaining, ncp->chunk);
#line 897
		size_t nget = ncx_howmany(varp->type, extent);
#line 897

#line 897
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 897
				 0, (void **)&xp);	/* cast away const */
#line 897
		if(lstatus != NC_NOERR)
#line 897
			return lstatus;
#line 897

#line 897
		lstatus = ncx_getn_float_ulonglong(&xp, nget, value);
#line 897
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 897
			status = lstatus;
#line 897

#line 897
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 897

#line 897
		remaining -= extent;
#line 897
		if(remaining == 0)
#line 897
			break; /* normal loop exit */
#line 897
		offset += (off_t)extent;
#line 897
		value += nget;
#line 897
	}
#line 897

#line 897
	return status;
#line 897
}
#line 897

static int
#line 898
getNCvx_float_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 898
		 const size_t *start, size_t nelems, ushort *value)
#line 898
{
#line 898
	off_t offset = NC_varoffset(ncp, varp, start);
#line 898
	size_t remaining = varp->xsz * nelems;
#line 898
	int status = NC_NOERR;
#line 898
	const void *xp;
#line 898

#line 898
	if(nelems == 0)
#line 898
		return NC_NOERR;
#line 898

#line 898
	assert(value != NULL);
#line 898

#line 898
	for(;;)
#line 898
	{
#line 898
		size_t extent = MIN(remaining, ncp->chunk);
#line 898
		size_t nget = ncx_howmany(varp->type, extent);
#line 898

#line 898
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 898
				 0, (void **)&xp);	/* cast away const */
#line 898
		if(lstatus != NC_NOERR)
#line 898
			return lstatus;
#line 898

#line 898
		lstatus = ncx_getn_float_ushort(&xp, nget, value);
#line 898
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 898
			status = lstatus;
#line 898

#line 898
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 898

#line 898
		remaining -= extent;
#line 898
		if(remaining == 0)
#line 898
			break; /* normal loop exit */
#line 898
		offset += (off_t)extent;
#line 898
		value += nget;
#line 898
	}
#line 898

#line 898
	return status;
#line 898
}
#line 898


static int
#line 900
getNCvx_double_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 900
		 const size_t *start, size_t nelems, schar *value)
#line 900
{
#line 900
	off_t offset = NC_varoffset(ncp, varp, start);
#line 900
	size_t remaining = varp->xsz * nelems;
#line 900
	int status = NC_NOERR;
#line 900
	const void *xp;
#line 900

#line 900
	if(nelems == 0)
#line 900
		return NC_NOERR;
#line 900

#line 900
	assert(value != NULL);
#line 900

#line 900
	for(;;)
#line 900
	{
#line 900
		size_t extent = MIN(remaining, ncp->chunk);
#line 900
		size_t nget = ncx_howmany(varp->type, extent);
#line 900

#line 900
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 900
				 0, (void **)&xp);	/* cast away const */
#line 900
		if(lstatus != NC_NOERR)
#line 900
			return lstatus;
#line 900

#line 900
		lstatus = ncx_getn_double_schar(&xp, nget, value);
#line 900
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 900
			status = lstatus;
#line 900

#line 900
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 900

#line 900
		remaining -= extent;
#line 900
		if(remaining == 0)
#line 900
			break; /* normal loop exit */
#line 900
		offset += (off_t)extent;
#line 900
		value += nget;
#line 900
	}
#line 900

#line 900
	return status;
#line 900
}
#line 900

static int
#line 901
getNCvx_double_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 901
		 const size_t *start, size_t nelems, uchar *value)
#line 901
{
#line 901
	off_t offset = NC_varoffset(ncp, varp, start);
#line 901
	size_t remaining = varp->xsz * nelems;
#line 901
	int status = NC_NOERR;
#line 901
	const void *xp;
#line 901

#line 901
	if(nelems == 0)
#line 901
		return NC_NOERR;
#line 901

#line 901
	assert(value != NULL);
#line 901

#line 901
	for(;;)
#line 901
	{
#line 901
		size_t extent = MIN(remaining, ncp->chunk);
#line 901
		size_t nget = ncx_howmany(varp->type, extent);
#line 901

#line 901
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 901
				 0, (void **)&xp);	/* cast away const */
#line 901
		if(lstatus != NC_NOERR)
#line 901
			return lstatus;
#line 901

#line 901
		lstatus = ncx_getn_double_uchar(&xp, nget, value);
#line 901
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 901
			status = lstatus;
#line 901

#line 901
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 901

#line 901
		remaining -= extent;
#line 901
		if(remaining == 0)
#line 901
			break; /* normal loop exit */
#line 901
		offset += (off_t)extent;
#line 901
		value += nget;
#line 901
	}
#line 901

#line 901
	return status;
#line 901
}
#line 901

static int
#line 902
getNCvx_double_short(const NC3_INFO* ncp, const NC_var *varp,
#line 902
		 const size_t *start, size_t nelems, short *value)
#line 902
{
#line 902
	off_t offset = NC_varoffset(ncp, varp, start);
#line 902
	size_t remaining = varp->xsz * nelems;
#line 902
	int status = NC_NOERR;
#line 902
	const void *xp;
#line 902

#line 902
	if(nelems == 0)
#line 902
		return NC_NOERR;
#line 902

#line 902
	assert(value != NULL);
#line 902

#line 902
	for(;;)
#line 902
	{
#line 902
		size_t extent = MIN(remaining, ncp->chunk);
#line 902
		size_t nget = ncx_howmany(varp->type, extent);
#line 902

#line 902
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 902
				 0, (void **)&xp);	/* cast away const */
#line 902
		if(lstatus != NC_NOERR)
#line 902
			return lstatus;
#line 902

#line 902
		lstatus = ncx_getn_double_short(&xp, nget, value);
#line 902
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 902
			status = lstatus;
#line 902

#line 902
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 902

#line 902
		remaining -= extent;
#line 902
		if(remaining == 0)
#line 902
			break; /* normal loop exit */
#line 902
		offset += (off_t)extent;
#line 902
		value += nget;
#line 902
	}
#line 902

#line 902
	return status;
#line 902
}
#line 902

static int
#line 903
getNCvx_double_int(const NC3_INFO* ncp, const NC_var *varp,
#line 903
		 const size_t *start, size_t nelems, int *value)
#line 903
{
#line 903
	off_t offset = NC_varoffset(ncp, varp, start);
#line 903
	size_t remaining = varp->xsz * nelems;
#line 903
	int status = NC_NOERR;
#line 903
	const void *xp;
#line 903

#line 903
	if(nelems == 0)
#line 903
		return NC_NOERR;
#line 903

#line 903
	assert(value != NULL);
#line 903

#line 903
	for(;;)
#line 903
	{
#line 903
		size_t extent = MIN(remaining, ncp->chunk);
#line 903
		size_t nget = ncx_howmany(varp->type, extent);
#line 903

#line 903
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 903
				 0, (void **)&xp);	/* cast away const */
#line 903
		if(lstatus != NC_NOERR)
#line 903
			return lstatus;
#line 903

#line 903
		lstatus = ncx_getn_double_int(&xp, nget, value);
#line 903
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 903
			status = lstatus;
#line 903

#line 903
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 903

#line 903
		remaining -= extent;
#line 903
		if(remaining == 0)
#line 903
			break; /* normal loop exit */
#line 903
		offset += (off_t)extent;
#line 903
		value += nget;
#line 903
	}
#line 903

#line 903
	return status;
#line 903
}
#line 903

static int
#line 904
getNCvx_double_float(const NC3_INFO* ncp, const NC_var *varp,
#line 904
		 const size_t *start, size_t nelems, float *value)
#line 904
{
#line 904
	off_t offset = NC_varoffset(ncp, varp, start);
#line 904
	size_t remaining = varp->xsz * nelems;
#line 904
	int status = NC_NOERR;
#line 904
	const void *xp;
#line 904

#line 904
	if(nelems == 0)
#line 904
		return NC_NOERR;
#line 904

#line 904
	assert(value != NULL);
#line 904

#line 904
	for(;;)
#line 904
	{
#line 904
		size_t extent = MIN(remaining, ncp->chunk);
#line 904
		size_t nget = ncx_howmany(varp->type, extent);
#line 904

#line 904
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 904
				 0, (void **)&xp);	/* cast away const */
#line 904
		if(lstatus != NC_NOERR)
#line 904
			return lstatus;
#line 904

#line 904
		lstatus = ncx_getn_double_float(&xp, nget, value);
#line 904
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 904
			status = lstatus;
#line 904

#line 904
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 904

#line 904
		remaining -= extent;
#line 904
		if(remaining == 0)
#line 904
			break; /* normal loop exit */
#line 904
		offset += (off_t)extent;
#line 904
		value += nget;
#line 904
	}
#line 904

#line 904
	return status;
#line 904
}
#line 904

static int
#line 905
getNCvx_double_double(const NC3_INFO* ncp, const NC_var *varp,
#line 905
		 const size_t *start, size_t nelems, double *value)
#line 905
{
#line 905
	off_t offset = NC_varoffset(ncp, varp, start);
#line 905
	size_t remaining = varp->xsz * nelems;
#line 905
	int status = NC_NOERR;
#line 905
	const void *xp;
#line 905

#line 905
	if(nelems == 0)
#line 905
		return NC_NOERR;
#line 905

#line 905
	assert(value != NULL);
#line 905

#line 905
	for(;;)
#line 905
	{
#line 905
		size_t extent = MIN(remaining, ncp->chunk);
#line 905
		size_t nget = ncx_howmany(varp->type, extent);
#line 905

#line 905
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 905
				 0, (void **)&xp);	/* cast away const */
#line 905
		if(lstatus != NC_NOERR)
#line 905
			return lstatus;
#line 905

#line 905
		lstatus = ncx_getn_double_double(&xp, nget, value);
#line 905
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 905
			status = lstatus;
#line 905

#line 905
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 905

#line 905
		remaining -= extent;
#line 905
		if(remaining == 0)
#line 905
			break; /* normal loop exit */
#line 905
		offset += (off_t)extent;
#line 905
		value += nget;
#line 905
	}
#line 905

#line 905
	return status;
#line 905
}
#line 905

static int
#line 906
getNCvx_double_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 906
		 const size_t *start, size_t nelems, longlong *value)
#line 906
{
#line 906
	off_t offset = NC_varoffset(ncp, varp, start);
#line 906
	size_t remaining = varp->xsz * nelems;
#line 906
	int status = NC_NOERR;
#line 906
	const void *xp;
#line 906

#line 906
	if(nelems == 0)
#line 906
		return NC_NOERR;
#line 906

#line 906
	assert(value != NULL);
#line 906

#line 906
	for(;;)
#line 906
	{
#line 906
		size_t extent = MIN(remaining, ncp->chunk);
#line 906
		size_t nget = ncx_howmany(varp->type, extent);
#line 906

#line 906
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 906
				 0, (void **)&xp);	/* cast away const */
#line 906
		if(lstatus != NC_NOERR)
#line 906
			return lstatus;
#line 906

#line 906
		lstatus = ncx_getn_double_longlong(&xp, nget, value);
#line 906
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 906
			status = lstatus;
#line 906

#line 906
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 906

#line 906
		remaining -= extent;
#line 906
		if(remaining == 0)
#line 906
			break; /* normal loop exit */
#line 906
		offset += (off_t)extent;
#line 906
		value += nget;
#line 906
	}
#line 906

#line 906
	return status;
#line 906
}
#line 906

static int
#line 907
getNCvx_double_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 907
		 const size_t *start, size_t nelems, uint *value)
#line 907
{
#line 907
	off_t offset = NC_varoffset(ncp, varp, start);
#line 907
	size_t remaining = varp->xsz * nelems;
#line 907
	int status = NC_NOERR;
#line 907
	const void *xp;
#line 907

#line 907
	if(nelems == 0)
#line 907
		return NC_NOERR;
#line 907

#line 907
	assert(value != NULL);
#line 907

#line 907
	for(;;)
#line 907
	{
#line 907
		size_t extent = MIN(remaining, ncp->chunk);
#line 907
		size_t nget = ncx_howmany(varp->type, extent);
#line 907

#line 907
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 907
				 0, (void **)&xp);	/* cast away const */
#line 907
		if(lstatus != NC_NOERR)
#line 907
			return lstatus;
#line 907

#line 907
		lstatus = ncx_getn_double_uint(&xp, nget, value);
#line 907
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 907
			status = lstatus;
#line 907

#line 907
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 907

#line 907
		remaining -= extent;
#line 907
		if(remaining == 0)
#line 907
			break; /* normal loop exit */
#line 907
		offset += (off_t)extent;
#line 907
		value += nget;
#line 907
	}
#line 907

#line 907
	return status;
#line 907
}
#line 907

static int
#line 908
getNCvx_double_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 908
		 const size_t *start, size_t nelems, ulonglong *value)
#line 908
{
#line 908
	off_t offset = NC_varoffset(ncp, varp, start);
#line 908
	size_t remaining = varp->xsz * nelems;
#line 908
	int status = NC_NOERR;
#line 908
	const void *xp;
#line 908

#line 908
	if(nelems == 0)
#line 908
		return NC_NOERR;
#line 908

#line 908
	assert(value != NULL);
#line 908

#line 908
	for(;;)
#line 908
	{
#line 908
		size_t extent = MIN(remaining, ncp->chunk);
#line 908
		size_t nget = ncx_howmany(varp->type, extent);
#line 908

#line 908
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 908
				 0, (void **)&xp);	/* cast away const */
#line 908
		if(lstatus != NC_NOERR)
#line 908
			return lstatus;
#line 908

#line 908
		lstatus = ncx_getn_double_ulonglong(&xp, nget, value);
#line 908
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 908
			status = lstatus;
#line 908

#line 908
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 908

#line 908
		remaining -= extent;
#line 908
		if(remaining == 0)
#line 908
			break; /* normal loop exit */
#line 908
		offset += (off_t)extent;
#line 908
		value += nget;
#line 908
	}
#line 908

#line 908
	return status;
#line 908
}
#line 908

static int
#line 909
getNCvx_double_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 909
		 const size_t *start, size_t nelems, ushort *value)
#line 909
{
#line 909
	off_t offset = NC_varoffset(ncp, varp, start);
#line 909
	size_t remaining = varp->xsz * nelems;
#line 909
	int status = NC_NOERR;
#line 909
	const void *xp;
#line 909

#line 909
	if(nelems == 0)
#line 909
		return NC_NOERR;
#line 909

#line 909
	assert(value != NULL);
#line 909

#line 909
	for(;;)
#line 909
	{
#line 909
		size_t extent = MIN(remaining, ncp->chunk);
#line 909
		size_t nget = ncx_howmany(varp->type, extent);
#line 909

#line 909
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 909
				 0, (void **)&xp);	/* cast away const */
#line 909
		if(lstatus != NC_NOERR)
#line 909
			return lstatus;
#line 909

#line 909
		lstatus = ncx_getn_double_ushort(&xp, nget, value);
#line 909
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 909
			status = lstatus;
#line 909

#line 909
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 909

#line 909
		remaining -= extent;
#line 909
		if(remaining == 0)
#line 909
			break; /* normal loop exit */
#line 909
		offset += (off_t)extent;
#line 909
		value += nget;
#line 909
	}
#line 909

#line 909
	return status;
#line 909
}
#line 909


static int
#line 911
getNCvx_uchar_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 911
		 const size_t *start, size_t nelems, schar *value)
#line 911
{
#line 911
	off_t offset = NC_varoffset(ncp, varp, start);
#line 911
	size_t remaining = varp->xsz * nelems;
#line 911
	int status = NC_NOERR;
#line 911
	const void *xp;
#line 911

#line 911
	if(nelems == 0)
#line 911
		return NC_NOERR;
#line 911

#line 911
	assert(value != NULL);
#line 911

#line 911
	for(;;)
#line 911
	{
#line 911
		size_t extent = MIN(remaining, ncp->chunk);
#line 911
		size_t nget = ncx_howmany(varp->type, extent);
#line 911

#line 911
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 911
				 0, (void **)&xp);	/* cast away const */
#line 911
		if(lstatus != NC_NOERR)
#line 911
			return lstatus;
#line 911

#line 911
		lstatus = ncx_getn_uchar_schar(&xp, nget, value);
#line 911
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 911
			status = lstatus;
#line 911

#line 911
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 911

#line 911
		remaining -= extent;
#line 911
		if(remaining == 0)
#line 911
			break; /* normal loop exit */
#line 911
		offset += (off_t)extent;
#line 911
		value += nget;
#line 911
	}
#line 911

#line 911
	return status;
#line 911
}
#line 911

static int
#line 912
getNCvx_uchar_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 912
		 const size_t *start, size_t nelems, uchar *value)
#line 912
{
#line 912
	off_t offset = NC_varoffset(ncp, varp, start);
#line 912
	size_t remaining = varp->xsz * nelems;
#line 912
	int status = NC_NOERR;
#line 912
	const void *xp;
#line 912

#line 912
	if(nelems == 0)
#line 912
		return NC_NOERR;
#line 912

#line 912
	assert(value != NULL);
#line 912

#line 912
	for(;;)
#line 912
	{
#line 912
		size_t extent = MIN(remaining, ncp->chunk);
#line 912
		size_t nget = ncx_howmany(varp->type, extent);
#line 912

#line 912
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 912
				 0, (void **)&xp);	/* cast away const */
#line 912
		if(lstatus != NC_NOERR)
#line 912
			return lstatus;
#line 912

#line 912
		lstatus = ncx_getn_uchar_uchar(&xp, nget, value);
#line 912
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 912
			status = lstatus;
#line 912

#line 912
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 912

#line 912
		remaining -= extent;
#line 912
		if(remaining == 0)
#line 912
			break; /* normal loop exit */
#line 912
		offset += (off_t)extent;
#line 912
		value += nget;
#line 912
	}
#line 912

#line 912
	return status;
#line 912
}
#line 912

static int
#line 913
getNCvx_uchar_short(const NC3_INFO* ncp, const NC_var *varp,
#line 913
		 const size_t *start, size_t nelems, short *value)
#line 913
{
#line 913
	off_t offset = NC_varoffset(ncp, varp, start);
#line 913
	size_t remaining = varp->xsz * nelems;
#line 913
	int status = NC_NOERR;
#line 913
	const void *xp;
#line 913

#line 913
	if(nelems == 0)
#line 913
		return NC_NOERR;
#line 913

#line 913
	assert(value != NULL);
#line 913

#line 913
	for(;;)
#line 913
	{
#line 913
		size_t extent = MIN(remaining, ncp->chunk);
#line 913
		size_t nget = ncx_howmany(varp->type, extent);
#line 913

#line 913
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 913
				 0, (void **)&xp);	/* cast away const */
#line 913
		if(lstatus != NC_NOERR)
#line 913
			return lstatus;
#line 913

#line 913
		lstatus = ncx_getn_uchar_short(&xp, nget, value);
#line 913
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 913
			status = lstatus;
#line 913

#line 913
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 913

#line 913
		remaining -= extent;
#line 913
		if(remaining == 0)
#line 913
			break; /* normal loop exit */
#line 913
		offset += (off_t)extent;
#line 913
		value += nget;
#line 913
	}
#line 913

#line 913
	return status;
#line 913
}
#line 913

static int
#line 914
getNCvx_uchar_int(const NC3_INFO* ncp, const NC_var *varp,
#line 914
		 const size_t *start, size_t nelems, int *value)
#line 914
{
#line 914
	off_t offset = NC_varoffset(ncp, varp, start);
#line 914
	size_t remaining = varp->xsz * nelems;
#line 914
	int status = NC_NOERR;
#line 914
	const void *xp;
#line 914

#line 914
	if(nelems == 0)
#line 914
		return NC_NOERR;
#line 914

#line 914
	assert(value != NULL);
#line 914

#line 914
	for(;;)
#line 914
	{
#line 914
		size_t extent = MIN(remaining, ncp->chunk);
#line 914
		size_t nget = ncx_howmany(varp->type, extent);
#line 914

#line 914
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 914
				 0, (void **)&xp);	/* cast away const */
#line 914
		if(lstatus != NC_NOERR)
#line 914
			return lstatus;
#line 914

#line 914
		lstatus = ncx_getn_uchar_int(&xp, nget, value);
#line 914
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 914
			status = lstatus;
#line 914

#line 914
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 914

#line 914
		remaining -= extent;
#line 914
		if(remaining == 0)
#line 914
			break; /* normal loop exit */
#line 914
		offset += (off_t)extent;
#line 914
		value += nget;
#line 914
	}
#line 914

#line 914
	return status;
#line 914
}
#line 914

static int
#line 915
getNCvx_uchar_float(const NC3_INFO* ncp, const NC_var *varp,
#line 915
		 const size_t *start, size_t nelems, float *value)
#line 915
{
#line 915
	off_t offset = NC_varoffset(ncp, varp, start);
#line 915
	size_t remaining = varp->xsz * nelems;
#line 915
	int status = NC_NOERR;
#line 915
	const void *xp;
#line 915

#line 915
	if(nelems == 0)
#line 915
		return NC_NOERR;
#line 915

#line 915
	assert(value != NULL);
#line 915

#line 915
	for(;;)
#line 915
	{
#line 915
		size_t extent = MIN(remaining, ncp->chunk);
#line 915
		size_t nget = ncx_howmany(varp->type, extent);
#line 915

#line 915
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 915
				 0, (void **)&xp);	/* cast away const */
#line 915
		if(lstatus != NC_NOERR)
#line 915
			return lstatus;
#line 915

#line 915
		lstatus = ncx_getn_uchar_float(&xp, nget, value);
#line 915
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 915
			status = lstatus;
#line 915

#line 915
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 915

#line 915
		remaining -= extent;
#line 915
		if(remaining == 0)
#line 915
			break; /* normal loop exit */
#line 915
		offset += (off_t)extent;
#line 915
		value += nget;
#line 915
	}
#line 915

#line 915
	return status;
#line 915
}
#line 915

static int
#line 916
getNCvx_uchar_double(const NC3_INFO* ncp, const NC_var *varp,
#line 916
		 const size_t *start, size_t nelems, double *value)
#line 916
{
#line 916
	off_t offset = NC_varoffset(ncp, varp, start);
#line 916
	size_t remaining = varp->xsz * nelems;
#line 916
	int status = NC_NOERR;
#line 916
	const void *xp;
#line 916

#line 916
	if(nelems == 0)
#line 916
		return NC_NOERR;
#line 916

#line 916
	assert(value != NULL);
#line 916

#line 916
	for(;;)
#line 916
	{
#line 916
		size_t extent = MIN(remaining, ncp->chunk);
#line 916
		size_t nget = ncx_howmany(varp->type, extent);
#line 916

#line 916
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 916
				 0, (void **)&xp);	/* cast away const */
#line 916
		if(lstatus != NC_NOERR)
#line 916
			return lstatus;
#line 916

#line 916
		lstatus = ncx_getn_uchar_double(&xp, nget, value);
#line 916
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 916
			status = lstatus;
#line 916

#line 916
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 916

#line 916
		remaining -= extent;
#line 916
		if(remaining == 0)
#line 916
			break; /* normal loop exit */
#line 916
		offset += (off_t)extent;
#line 916
		value += nget;
#line 916
	}
#line 916

#line 916
	return status;
#line 916
}
#line 916

static int
#line 917
getNCvx_uchar_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 917
		 const size_t *start, size_t nelems, longlong *value)
#line 917
{
#line 917
	off_t offset = NC_varoffset(ncp, varp, start);
#line 917
	size_t remaining = varp->xsz * nelems;
#line 917
	int status = NC_NOERR;
#line 917
	const void *xp;
#line 917

#line 917
	if(nelems == 0)
#line 917
		return NC_NOERR;
#line 917

#line 917
	assert(value != NULL);
#line 917

#line 917
	for(;;)
#line 917
	{
#line 917
		size_t extent = MIN(remaining, ncp->chunk);
#line 917
		size_t nget = ncx_howmany(varp->type, extent);
#line 917

#line 917
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 917
				 0, (void **)&xp);	/* cast away const */
#line 917
		if(lstatus != NC_NOERR)
#line 917
			return lstatus;
#line 917

#line 917
		lstatus = ncx_getn_uchar_longlong(&xp, nget, value);
#line 917
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 917
			status = lstatus;
#line 917

#line 917
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 917

#line 917
		remaining -= extent;
#line 917
		if(remaining == 0)
#line 917
			break; /* normal loop exit */
#line 917
		offset += (off_t)extent;
#line 917
		value += nget;
#line 917
	}
#line 917

#line 917
	return status;
#line 917
}
#line 917

static int
#line 918
getNCvx_uchar_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 918
		 const size_t *start, size_t nelems, uint *value)
#line 918
{
#line 918
	off_t offset = NC_varoffset(ncp, varp, start);
#line 918
	size_t remaining = varp->xsz * nelems;
#line 918
	int status = NC_NOERR;
#line 918
	const void *xp;
#line 918

#line 918
	if(nelems == 0)
#line 918
		return NC_NOERR;
#line 918

#line 918
	assert(value != NULL);
#line 918

#line 918
	for(;;)
#line 918
	{
#line 918
		size_t extent = MIN(remaining, ncp->chunk);
#line 918
		size_t nget = ncx_howmany(varp->type, extent);
#line 918

#line 918
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 918
				 0, (void **)&xp);	/* cast away const */
#line 918
		if(lstatus != NC_NOERR)
#line 918
			return lstatus;
#line 918

#line 918
		lstatus = ncx_getn_uchar_uint(&xp, nget, value);
#line 918
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 918
			status = lstatus;
#line 918

#line 918
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 918

#line 918
		remaining -= extent;
#line 918
		if(remaining == 0)
#line 918
			break; /* normal loop exit */
#line 918
		offset += (off_t)extent;
#line 918
		value += nget;
#line 918
	}
#line 918

#line 918
	return status;
#line 918
}
#line 918

static int
#line 919
getNCvx_uchar_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 919
		 const size_t *start, size_t nelems, ulonglong *value)
#line 919
{
#line 919
	off_t offset = NC_varoffset(ncp, varp, start);
#line 919
	size_t remaining = varp->xsz * nelems;
#line 919
	int status = NC_NOERR;
#line 919
	const void *xp;
#line 919

#line 919
	if(nelems == 0)
#line 919
		return NC_NOERR;
#line 919

#line 919
	assert(value != NULL);
#line 919

#line 919
	for(;;)
#line 919
	{
#line 919
		size_t extent = MIN(remaining, ncp->chunk);
#line 919
		size_t nget = ncx_howmany(varp->type, extent);
#line 919

#line 919
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 919
				 0, (void **)&xp);	/* cast away const */
#line 919
		if(lstatus != NC_NOERR)
#line 919
			return lstatus;
#line 919

#line 919
		lstatus = ncx_getn_uchar_ulonglong(&xp, nget, value);
#line 919
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 919
			status = lstatus;
#line 919

#line 919
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 919

#line 919
		remaining -= extent;
#line 919
		if(remaining == 0)
#line 919
			break; /* normal loop exit */
#line 919
		offset += (off_t)extent;
#line 919
		value += nget;
#line 919
	}
#line 919

#line 919
	return status;
#line 919
}
#line 919

static int
#line 920
getNCvx_uchar_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 920
		 const size_t *start, size_t nelems, ushort *value)
#line 920
{
#line 920
	off_t offset = NC_varoffset(ncp, varp, start);
#line 920
	size_t remaining = varp->xsz * nelems;
#line 920
	int status = NC_NOERR;
#line 920
	const void *xp;
#line 920

#line 920
	if(nelems == 0)
#line 920
		return NC_NOERR;
#line 920

#line 920
	assert(value != NULL);
#line 920

#line 920
	for(;;)
#line 920
	{
#line 920
		size_t extent = MIN(remaining, ncp->chunk);
#line 920
		size_t nget = ncx_howmany(varp->type, extent);
#line 920

#line 920
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 920
				 0, (void **)&xp);	/* cast away const */
#line 920
		if(lstatus != NC_NOERR)
#line 920
			return lstatus;
#line 920

#line 920
		lstatus = ncx_getn_uchar_ushort(&xp, nget, value);
#line 920
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 920
			status = lstatus;
#line 920

#line 920
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 920

#line 920
		remaining -= extent;
#line 920
		if(remaining == 0)
#line 920
			break; /* normal loop exit */
#line 920
		offset += (off_t)extent;
#line 920
		value += nget;
#line 920
	}
#line 920

#line 920
	return status;
#line 920
}
#line 920


static int
#line 922
getNCvx_ushort_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 922
		 const size_t *start, size_t nelems, schar *value)
#line 922
{
#line 922
	off_t offset = NC_varoffset(ncp, varp, start);
#line 922
	size_t remaining = varp->xsz * nelems;
#line 922
	int status = NC_NOERR;
#line 922
	const void *xp;
#line 922

#line 922
	if(nelems == 0)
#line 922
		return NC_NOERR;
#line 922

#line 922
	assert(value != NULL);
#line 922

#line 922
	for(;;)
#line 922
	{
#line 922
		size_t extent = MIN(remaining, ncp->chunk);
#line 922
		size_t nget = ncx_howmany(varp->type, extent);
#line 922

#line 922
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 922
				 0, (void **)&xp);	/* cast away const */
#line 922
		if(lstatus != NC_NOERR)
#line 922
			return lstatus;
#line 922

#line 922
		lstatus = ncx_getn_ushort_schar(&xp, nget, value);
#line 922
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 922
			status = lstatus;
#line 922

#line 922
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 922

#line 922
		remaining -= extent;
#line 922
		if(remaining == 0)
#line 922
			break; /* normal loop exit */
#line 922
		offset += (off_t)extent;
#line 922
		value += nget;
#line 922
	}
#line 922

#line 922
	return status;
#line 922
}
#line 922

static int
#line 923
getNCvx_ushort_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 923
		 const size_t *start, size_t nelems, uchar *value)
#line 923
{
#line 923
	off_t offset = NC_varoffset(ncp, varp, start);
#line 923
	size_t remaining = varp->xsz * nelems;
#line 923
	int status = NC_NOERR;
#line 923
	const void *xp;
#line 923

#line 923
	if(nelems == 0)
#line 923
		return NC_NOERR;
#line 923

#line 923
	assert(value != NULL);
#line 923

#line 923
	for(;;)
#line 923
	{
#line 923
		size_t extent = MIN(remaining, ncp->chunk);
#line 923
		size_t nget = ncx_howmany(varp->type, extent);
#line 923

#line 923
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 923
				 0, (void **)&xp);	/* cast away const */
#line 923
		if(lstatus != NC_NOERR)
#line 923
			return lstatus;
#line 923

#line 923
		lstatus = ncx_getn_ushort_uchar(&xp, nget, value);
#line 923
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 923
			status = lstatus;
#line 923

#line 923
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 923

#line 923
		remaining -= extent;
#line 923
		if(remaining == 0)
#line 923
			break; /* normal loop exit */
#line 923
		offset += (off_t)extent;
#line 923
		value += nget;
#line 923
	}
#line 923

#line 923
	return status;
#line 923
}
#line 923

static int
#line 924
getNCvx_ushort_short(const NC3_INFO* ncp, const NC_var *varp,
#line 924
		 const size_t *start, size_t nelems, short *value)
#line 924
{
#line 924
	off_t offset = NC_varoffset(ncp, varp, start);
#line 924
	size_t remaining = varp->xsz * nelems;
#line 924
	int status = NC_NOERR;
#line 924
	const void *xp;
#line 924

#line 924
	if(nelems == 0)
#line 924
		return NC_NOERR;
#line 924

#line 924
	assert(value != NULL);
#line 924

#line 924
	for(;;)
#line 924
	{
#line 924
		size_t extent = MIN(remaining, ncp->chunk);
#line 924
		size_t nget = ncx_howmany(varp->type, extent);
#line 924

#line 924
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 924
				 0, (void **)&xp);	/* cast away const */
#line 924
		if(lstatus != NC_NOERR)
#line 924
			return lstatus;
#line 924

#line 924
		lstatus = ncx_getn_ushort_short(&xp, nget, value);
#line 924
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 924
			status = lstatus;
#line 924

#line 924
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 924

#line 924
		remaining -= extent;
#line 924
		if(remaining == 0)
#line 924
			break; /* normal loop exit */
#line 924
		offset += (off_t)extent;
#line 924
		value += nget;
#line 924
	}
#line 924

#line 924
	return status;
#line 924
}
#line 924

static int
#line 925
getNCvx_ushort_int(const NC3_INFO* ncp, const NC_var *varp,
#line 925
		 const size_t *start, size_t nelems, int *value)
#line 925
{
#line 925
	off_t offset = NC_varoffset(ncp, varp, start);
#line 925
	size_t remaining = varp->xsz * nelems;
#line 925
	int status = NC_NOERR;
#line 925
	const void *xp;
#line 925

#line 925
	if(nelems == 0)
#line 925
		return NC_NOERR;
#line 925

#line 925
	assert(value != NULL);
#line 925

#line 925
	for(;;)
#line 925
	{
#line 925
		size_t extent = MIN(remaining, ncp->chunk);
#line 925
		size_t nget = ncx_howmany(varp->type, extent);
#line 925

#line 925
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 925
				 0, (void **)&xp);	/* cast away const */
#line 925
		if(lstatus != NC_NOERR)
#line 925
			return lstatus;
#line 925

#line 925
		lstatus = ncx_getn_ushort_int(&xp, nget, value);
#line 925
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 925
			status = lstatus;
#line 925

#line 925
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 925

#line 925
		remaining -= extent;
#line 925
		if(remaining == 0)
#line 925
			break; /* normal loop exit */
#line 925
		offset += (off_t)extent;
#line 925
		value += nget;
#line 925
	}
#line 925

#line 925
	return status;
#line 925
}
#line 925

static int
#line 926
getNCvx_ushort_float(const NC3_INFO* ncp, const NC_var *varp,
#line 926
		 const size_t *start, size_t nelems, float *value)
#line 926
{
#line 926
	off_t offset = NC_varoffset(ncp, varp, start);
#line 926
	size_t remaining = varp->xsz * nelems;
#line 926
	int status = NC_NOERR;
#line 926
	const void *xp;
#line 926

#line 926
	if(nelems == 0)
#line 926
		return NC_NOERR;
#line 926

#line 926
	assert(value != NULL);
#line 926

#line 926
	for(;;)
#line 926
	{
#line 926
		size_t extent = MIN(remaining, ncp->chunk);
#line 926
		size_t nget = ncx_howmany(varp->type, extent);
#line 926

#line 926
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 926
				 0, (void **)&xp);	/* cast away const */
#line 926
		if(lstatus != NC_NOERR)
#line 926
			return lstatus;
#line 926

#line 926
		lstatus = ncx_getn_ushort_float(&xp, nget, value);
#line 926
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 926
			status = lstatus;
#line 926

#line 926
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 926

#line 926
		remaining -= extent;
#line 926
		if(remaining == 0)
#line 926
			break; /* normal loop exit */
#line 926
		offset += (off_t)extent;
#line 926
		value += nget;
#line 926
	}
#line 926

#line 926
	return status;
#line 926
}
#line 926

static int
#line 927
getNCvx_ushort_double(const NC3_INFO* ncp, const NC_var *varp,
#line 927
		 const size_t *start, size_t nelems, double *value)
#line 927
{
#line 927
	off_t offset = NC_varoffset(ncp, varp, start);
#line 927
	size_t remaining = varp->xsz * nelems;
#line 927
	int status = NC_NOERR;
#line 927
	const void *xp;
#line 927

#line 927
	if(nelems == 0)
#line 927
		return NC_NOERR;
#line 927

#line 927
	assert(value != NULL);
#line 927

#line 927
	for(;;)
#line 927
	{
#line 927
		size_t extent = MIN(remaining, ncp->chunk);
#line 927
		size_t nget = ncx_howmany(varp->type, extent);
#line 927

#line 927
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 927
				 0, (void **)&xp);	/* cast away const */
#line 927
		if(lstatus != NC_NOERR)
#line 927
			return lstatus;
#line 927

#line 927
		lstatus = ncx_getn_ushort_double(&xp, nget, value);
#line 927
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 927
			status = lstatus;
#line 927

#line 927
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 927

#line 927
		remaining -= extent;
#line 927
		if(remaining == 0)
#line 927
			break; /* normal loop exit */
#line 927
		offset += (off_t)extent;
#line 927
		value += nget;
#line 927
	}
#line 927

#line 927
	return status;
#line 927
}
#line 927

static int
#line 928
getNCvx_ushort_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 928
		 const size_t *start, size_t nelems, longlong *value)
#line 928
{
#line 928
	off_t offset = NC_varoffset(ncp, varp, start);
#line 928
	size_t remaining = varp->xsz * nelems;
#line 928
	int status = NC_NOERR;
#line 928
	const void *xp;
#line 928

#line 928
	if(nelems == 0)
#line 928
		return NC_NOERR;
#line 928

#line 928
	assert(value != NULL);
#line 928

#line 928
	for(;;)
#line 928
	{
#line 928
		size_t extent = MIN(remaining, ncp->chunk);
#line 928
		size_t nget = ncx_howmany(varp->type, extent);
#line 928

#line 928
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 928
				 0, (void **)&xp);	/* cast away const */
#line 928
		if(lstatus != NC_NOERR)
#line 928
			return lstatus;
#line 928

#line 928
		lstatus = ncx_getn_ushort_longlong(&xp, nget, value);
#line 928
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 928
			status = lstatus;
#line 928

#line 928
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 928

#line 928
		remaining -= extent;
#line 928
		if(remaining == 0)
#line 928
			break; /* normal loop exit */
#line 928
		offset += (off_t)extent;
#line 928
		value += nget;
#line 928
	}
#line 928

#line 928
	return status;
#line 928
}
#line 928

static int
#line 929
getNCvx_ushort_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 929
		 const size_t *start, size_t nelems, uint *value)
#line 929
{
#line 929
	off_t offset = NC_varoffset(ncp, varp, start);
#line 929
	size_t remaining = varp->xsz * nelems;
#line 929
	int status = NC_NOERR;
#line 929
	const void *xp;
#line 929

#line 929
	if(nelems == 0)
#line 929
		return NC_NOERR;
#line 929

#line 929
	assert(value != NULL);
#line 929

#line 929
	for(;;)
#line 929
	{
#line 929
		size_t extent = MIN(remaining, ncp->chunk);
#line 929
		size_t nget = ncx_howmany(varp->type, extent);
#line 929

#line 929
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 929
				 0, (void **)&xp);	/* cast away const */
#line 929
		if(lstatus != NC_NOERR)
#line 929
			return lstatus;
#line 929

#line 929
		lstatus = ncx_getn_ushort_uint(&xp, nget, value);
#line 929
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 929
			status = lstatus;
#line 929

#line 929
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 929

#line 929
		remaining -= extent;
#line 929
		if(remaining == 0)
#line 929
			break; /* normal loop exit */
#line 929
		offset += (off_t)extent;
#line 929
		value += nget;
#line 929
	}
#line 929

#line 929
	return status;
#line 929
}
#line 929

static int
#line 930
getNCvx_ushort_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 930
		 const size_t *start, size_t nelems, ulonglong *value)
#line 930
{
#line 930
	off_t offset = NC_varoffset(ncp, varp, start);
#line 930
	size_t remaining = varp->xsz * nelems;
#line 930
	int status = NC_NOERR;
#line 930
	const void *xp;
#line 930

#line 930
	if(nelems == 0)
#line 930
		return NC_NOERR;
#line 930

#line 930
	assert(value != NULL);
#line 930

#line 930
	for(;;)
#line 930
	{
#line 930
		size_t extent = MIN(remaining, ncp->chunk);
#line 930
		size_t nget = ncx_howmany(varp->type, extent);
#line 930

#line 930
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 930
				 0, (void **)&xp);	/* cast away const */
#line 930
		if(lstatus != NC_NOERR)
#line 930
			return lstatus;
#line 930

#line 930
		lstatus = ncx_getn_ushort_ulonglong(&xp, nget, value);
#line 930
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 930
			status = lstatus;
#line 930

#line 930
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 930

#line 930
		remaining -= extent;
#line 930
		if(remaining == 0)
#line 930
			break; /* normal loop exit */
#line 930
		offset += (off_t)extent;
#line 930
		value += nget;
#line 930
	}
#line 930

#line 930
	return status;
#line 930
}
#line 930

static int
#line 931
getNCvx_ushort_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 931
		 const size_t *start, size_t nelems, ushort *value)
#line 931
{
#line 931
	off_t offset = NC_varoffset(ncp, varp, start);
#line 931
	size_t remaining = varp->xsz * nelems;
#line 931
	int status = NC_NOERR;
#line 931
	const void *xp;
#line 931

#line 931
	if(nelems == 0)
#line 931
		return NC_NOERR;
#line 931

#line 931
	assert(value != NULL);
#line 931

#line 931
	for(;;)
#line 931
	{
#line 931
		size_t extent = MIN(remaining, ncp->chunk);
#line 931
		size_t nget = ncx_howmany(varp->type, extent);
#line 931

#line 931
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 931
				 0, (void **)&xp);	/* cast away const */
#line 931
		if(lstatus != NC_NOERR)
#line 931
			return lstatus;
#line 931

#line 931
		lstatus = ncx_getn_ushort_ushort(&xp, nget, value);
#line 931
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 931
			status = lstatus;
#line 931

#line 931
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 931

#line 931
		remaining -= extent;
#line 931
		if(remaining == 0)
#line 931
			break; /* normal loop exit */
#line 931
		offset += (off_t)extent;
#line 931
		value += nget;
#line 931
	}
#line 931

#line 931
	return status;
#line 931
}
#line 931


static int
#line 933
getNCvx_uint_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 933
		 const size_t *start, size_t nelems, schar *value)
#line 933
{
#line 933
	off_t offset = NC_varoffset(ncp, varp, start);
#line 933
	size_t remaining = varp->xsz * nelems;
#line 933
	int status = NC_NOERR;
#line 933
	const void *xp;
#line 933

#line 933
	if(nelems == 0)
#line 933
		return NC_NOERR;
#line 933

#line 933
	assert(value != NULL);
#line 933

#line 933
	for(;;)
#line 933
	{
#line 933
		size_t extent = MIN(remaining, ncp->chunk);
#line 933
		size_t nget = ncx_howmany(varp->type, extent);
#line 933

#line 933
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 933
				 0, (void **)&xp);	/* cast away const */
#line 933
		if(lstatus != NC_NOERR)
#line 933
			return lstatus;
#line 933

#line 933
		lstatus = ncx_getn_uint_schar(&xp, nget, value);
#line 933
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 933
			status = lstatus;
#line 933

#line 933
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 933

#line 933
		remaining -= extent;
#line 933
		if(remaining == 0)
#line 933
			break; /* normal loop exit */
#line 933
		offset += (off_t)extent;
#line 933
		value += nget;
#line 933
	}
#line 933

#line 933
	return status;
#line 933
}
#line 933

static int
#line 934
getNCvx_uint_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 934
		 const size_t *start, size_t nelems, uchar *value)
#line 934
{
#line 934
	off_t offset = NC_varoffset(ncp, varp, start);
#line 934
	size_t remaining = varp->xsz * nelems;
#line 934
	int status = NC_NOERR;
#line 934
	const void *xp;
#line 934

#line 934
	if(nelems == 0)
#line 934
		return NC_NOERR;
#line 934

#line 934
	assert(value != NULL);
#line 934

#line 934
	for(;;)
#line 934
	{
#line 934
		size_t extent = MIN(remaining, ncp->chunk);
#line 934
		size_t nget = ncx_howmany(varp->type, extent);
#line 934

#line 934
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 934
				 0, (void **)&xp);	/* cast away const */
#line 934
		if(lstatus != NC_NOERR)
#line 934
			return lstatus;
#line 934

#line 934
		lstatus = ncx_getn_uint_uchar(&xp, nget, value);
#line 934
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 934
			status = lstatus;
#line 934

#line 934
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 934

#line 934
		remaining -= extent;
#line 934
		if(remaining == 0)
#line 934
			break; /* normal loop exit */
#line 934
		offset += (off_t)extent;
#line 934
		value += nget;
#line 934
	}
#line 934

#line 934
	return status;
#line 934
}
#line 934

static int
#line 935
getNCvx_uint_short(const NC3_INFO* ncp, const NC_var *varp,
#line 935
		 const size_t *start, size_t nelems, short *value)
#line 935
{
#line 935
	off_t offset = NC_varoffset(ncp, varp, start);
#line 935
	size_t remaining = varp->xsz * nelems;
#line 935
	int status = NC_NOERR;
#line 935
	const void *xp;
#line 935

#line 935
	if(nelems == 0)
#line 935
		return NC_NOERR;
#line 935

#line 935
	assert(value != NULL);
#line 935

#line 935
	for(;;)
#line 935
	{
#line 935
		size_t extent = MIN(remaining, ncp->chunk);
#line 935
		size_t nget = ncx_howmany(varp->type, extent);
#line 935

#line 935
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 935
				 0, (void **)&xp);	/* cast away const */
#line 935
		if(lstatus != NC_NOERR)
#line 935
			return lstatus;
#line 935

#line 935
		lstatus = ncx_getn_uint_short(&xp, nget, value);
#line 935
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 935
			status = lstatus;
#line 935

#line 935
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 935

#line 935
		remaining -= extent;
#line 935
		if(remaining == 0)
#line 935
			break; /* normal loop exit */
#line 935
		offset += (off_t)extent;
#line 935
		value += nget;
#line 935
	}
#line 935

#line 935
	return status;
#line 935
}
#line 935

static int
#line 936
getNCvx_uint_int(const NC3_INFO* ncp, const NC_var *varp,
#line 936
		 const size_t *start, size_t nelems, int *value)
#line 936
{
#line 936
	off_t offset = NC_varoffset(ncp, varp, start);
#line 936
	size_t remaining = varp->xsz * nelems;
#line 936
	int status = NC_NOERR;
#line 936
	const void *xp;
#line 936

#line 936
	if(nelems == 0)
#line 936
		return NC_NOERR;
#line 936

#line 936
	assert(value != NULL);
#line 936

#line 936
	for(;;)
#line 936
	{
#line 936
		size_t extent = MIN(remaining, ncp->chunk);
#line 936
		size_t nget = ncx_howmany(varp->type, extent);
#line 936

#line 936
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 936
				 0, (void **)&xp);	/* cast away const */
#line 936
		if(lstatus != NC_NOERR)
#line 936
			return lstatus;
#line 936

#line 936
		lstatus = ncx_getn_uint_int(&xp, nget, value);
#line 936
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 936
			status = lstatus;
#line 936

#line 936
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 936

#line 936
		remaining -= extent;
#line 936
		if(remaining == 0)
#line 936
			break; /* normal loop exit */
#line 936
		offset += (off_t)extent;
#line 936
		value += nget;
#line 936
	}
#line 936

#line 936
	return status;
#line 936
}
#line 936

static int
#line 937
getNCvx_uint_float(const NC3_INFO* ncp, const NC_var *varp,
#line 937
		 const size_t *start, size_t nelems, float *value)
#line 937
{
#line 937
	off_t offset = NC_varoffset(ncp, varp, start);
#line 937
	size_t remaining = varp->xsz * nelems;
#line 937
	int status = NC_NOERR;
#line 937
	const void *xp;
#line 937

#line 937
	if(nelems == 0)
#line 937
		return NC_NOERR;
#line 937

#line 937
	assert(value != NULL);
#line 937

#line 937
	for(;;)
#line 937
	{
#line 937
		size_t extent = MIN(remaining, ncp->chunk);
#line 937
		size_t nget = ncx_howmany(varp->type, extent);
#line 937

#line 937
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 937
				 0, (void **)&xp);	/* cast away const */
#line 937
		if(lstatus != NC_NOERR)
#line 937
			return lstatus;
#line 937

#line 937
		lstatus = ncx_getn_uint_float(&xp, nget, value);
#line 937
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 937
			status = lstatus;
#line 937

#line 937
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 937

#line 937
		remaining -= extent;
#line 937
		if(remaining == 0)
#line 937
			break; /* normal loop exit */
#line 937
		offset += (off_t)extent;
#line 937
		value += nget;
#line 937
	}
#line 937

#line 937
	return status;
#line 937
}
#line 937

static int
#line 938
getNCvx_uint_double(const NC3_INFO* ncp, const NC_var *varp,
#line 938
		 const size_t *start, size_t nelems, double *value)
#line 938
{
#line 938
	off_t offset = NC_varoffset(ncp, varp, start);
#line 938
	size_t remaining = varp->xsz * nelems;
#line 938
	int status = NC_NOERR;
#line 938
	const void *xp;
#line 938

#line 938
	if(nelems == 0)
#line 938
		return NC_NOERR;
#line 938

#line 938
	assert(value != NULL);
#line 938

#line 938
	for(;;)
#line 938
	{
#line 938
		size_t extent = MIN(remaining, ncp->chunk);
#line 938
		size_t nget = ncx_howmany(varp->type, extent);
#line 938

#line 938
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 938
				 0, (void **)&xp);	/* cast away const */
#line 938
		if(lstatus != NC_NOERR)
#line 938
			return lstatus;
#line 938

#line 938
		lstatus = ncx_getn_uint_double(&xp, nget, value);
#line 938
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 938
			status = lstatus;
#line 938

#line 938
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 938

#line 938
		remaining -= extent;
#line 938
		if(remaining == 0)
#line 938
			break; /* normal loop exit */
#line 938
		offset += (off_t)extent;
#line 938
		value += nget;
#line 938
	}
#line 938

#line 938
	return status;
#line 938
}
#line 938

static int
#line 939
getNCvx_uint_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 939
		 const size_t *start, size_t nelems, longlong *value)
#line 939
{
#line 939
	off_t offset = NC_varoffset(ncp, varp, start);
#line 939
	size_t remaining = varp->xsz * nelems;
#line 939
	int status = NC_NOERR;
#line 939
	const void *xp;
#line 939

#line 939
	if(nelems == 0)
#line 939
		return NC_NOERR;
#line 939

#line 939
	assert(value != NULL);
#line 939

#line 939
	for(;;)
#line 939
	{
#line 939
		size_t extent = MIN(remaining, ncp->chunk);
#line 939
		size_t nget = ncx_howmany(varp->type, extent);
#line 939

#line 939
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 939
				 0, (void **)&xp);	/* cast away const */
#line 939
		if(lstatus != NC_NOERR)
#line 939
			return lstatus;
#line 939

#line 939
		lstatus = ncx_getn_uint_longlong(&xp, nget, value);
#line 939
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 939
			status = lstatus;
#line 939

#line 939
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 939

#line 939
		remaining -= extent;
#line 939
		if(remaining == 0)
#line 939
			break; /* normal loop exit */
#line 939
		offset += (off_t)extent;
#line 939
		value += nget;
#line 939
	}
#line 939

#line 939
	return status;
#line 939
}
#line 939

static int
#line 940
getNCvx_uint_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 940
		 const size_t *start, size_t nelems, uint *value)
#line 940
{
#line 940
	off_t offset = NC_varoffset(ncp, varp, start);
#line 940
	size_t remaining = varp->xsz * nelems;
#line 940
	int status = NC_NOERR;
#line 940
	const void *xp;
#line 940

#line 940
	if(nelems == 0)
#line 940
		return NC_NOERR;
#line 940

#line 940
	assert(value != NULL);
#line 940

#line 940
	for(;;)
#line 940
	{
#line 940
		size_t extent = MIN(remaining, ncp->chunk);
#line 940
		size_t nget = ncx_howmany(varp->type, extent);
#line 940

#line 940
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 940
				 0, (void **)&xp);	/* cast away const */
#line 940
		if(lstatus != NC_NOERR)
#line 940
			return lstatus;
#line 940

#line 940
		lstatus = ncx_getn_uint_uint(&xp, nget, value);
#line 940
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 940
			status = lstatus;
#line 940

#line 940
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 940

#line 940
		remaining -= extent;
#line 940
		if(remaining == 0)
#line 940
			break; /* normal loop exit */
#line 940
		offset += (off_t)extent;
#line 940
		value += nget;
#line 940
	}
#line 940

#line 940
	return status;
#line 940
}
#line 940

static int
#line 941
getNCvx_uint_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 941
		 const size_t *start, size_t nelems, ulonglong *value)
#line 941
{
#line 941
	off_t offset = NC_varoffset(ncp, varp, start);
#line 941
	size_t remaining = varp->xsz * nelems;
#line 941
	int status = NC_NOERR;
#line 941
	const void *xp;
#line 941

#line 941
	if(nelems == 0)
#line 941
		return NC_NOERR;
#line 941

#line 941
	assert(value != NULL);
#line 941

#line 941
	for(;;)
#line 941
	{
#line 941
		size_t extent = MIN(remaining, ncp->chunk);
#line 941
		size_t nget = ncx_howmany(varp->type, extent);
#line 941

#line 941
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 941
				 0, (void **)&xp);	/* cast away const */
#line 941
		if(lstatus != NC_NOERR)
#line 941
			return lstatus;
#line 941

#line 941
		lstatus = ncx_getn_uint_ulonglong(&xp, nget, value);
#line 941
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 941
			status = lstatus;
#line 941

#line 941
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 941

#line 941
		remaining -= extent;
#line 941
		if(remaining == 0)
#line 941
			break; /* normal loop exit */
#line 941
		offset += (off_t)extent;
#line 941
		value += nget;
#line 941
	}
#line 941

#line 941
	return status;
#line 941
}
#line 941

static int
#line 942
getNCvx_uint_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 942
		 const size_t *start, size_t nelems, ushort *value)
#line 942
{
#line 942
	off_t offset = NC_varoffset(ncp, varp, start);
#line 942
	size_t remaining = varp->xsz * nelems;
#line 942
	int status = NC_NOERR;
#line 942
	const void *xp;
#line 942

#line 942
	if(nelems == 0)
#line 942
		return NC_NOERR;
#line 942

#line 942
	assert(value != NULL);
#line 942

#line 942
	for(;;)
#line 942
	{
#line 942
		size_t extent = MIN(remaining, ncp->chunk);
#line 942
		size_t nget = ncx_howmany(varp->type, extent);
#line 942

#line 942
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 942
				 0, (void **)&xp);	/* cast away const */
#line 942
		if(lstatus != NC_NOERR)
#line 942
			return lstatus;
#line 942

#line 942
		lstatus = ncx_getn_uint_ushort(&xp, nget, value);
#line 942
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 942
			status = lstatus;
#line 942

#line 942
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 942

#line 942
		remaining -= extent;
#line 942
		if(remaining == 0)
#line 942
			break; /* normal loop exit */
#line 942
		offset += (off_t)extent;
#line 942
		value += nget;
#line 942
	}
#line 942

#line 942
	return status;
#line 942
}
#line 942


static int
#line 944
getNCvx_longlong_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 944
		 const size_t *start, size_t nelems, schar *value)
#line 944
{
#line 944
	off_t offset = NC_varoffset(ncp, varp, start);
#line 944
	size_t remaining = varp->xsz * nelems;
#line 944
	int status = NC_NOERR;
#line 944
	const void *xp;
#line 944

#line 944
	if(nelems == 0)
#line 944
		return NC_NOERR;
#line 944

#line 944
	assert(value != NULL);
#line 944

#line 944
	for(;;)
#line 944
	{
#line 944
		size_t extent = MIN(remaining, ncp->chunk);
#line 944
		size_t nget = ncx_howmany(varp->type, extent);
#line 944

#line 944
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 944
				 0, (void **)&xp);	/* cast away const */
#line 944
		if(lstatus != NC_NOERR)
#line 944
			return lstatus;
#line 944

#line 944
		lstatus = ncx_getn_longlong_schar(&xp, nget, value);
#line 944
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 944
			status = lstatus;
#line 944

#line 944
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 944

#line 944
		remaining -= extent;
#line 944
		if(remaining == 0)
#line 944
			break; /* normal loop exit */
#line 944
		offset += (off_t)extent;
#line 944
		value += nget;
#line 944
	}
#line 944

#line 944
	return status;
#line 944
}
#line 944

static int
#line 945
getNCvx_longlong_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 945
		 const size_t *start, size_t nelems, uchar *value)
#line 945
{
#line 945
	off_t offset = NC_varoffset(ncp, varp, start);
#line 945
	size_t remaining = varp->xsz * nelems;
#line 945
	int status = NC_NOERR;
#line 945
	const void *xp;
#line 945

#line 945
	if(nelems == 0)
#line 945
		return NC_NOERR;
#line 945

#line 945
	assert(value != NULL);
#line 945

#line 945
	for(;;)
#line 945
	{
#line 945
		size_t extent = MIN(remaining, ncp->chunk);
#line 945
		size_t nget = ncx_howmany(varp->type, extent);
#line 945

#line 945
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 945
				 0, (void **)&xp);	/* cast away const */
#line 945
		if(lstatus != NC_NOERR)
#line 945
			return lstatus;
#line 945

#line 945
		lstatus = ncx_getn_longlong_uchar(&xp, nget, value);
#line 945
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 945
			status = lstatus;
#line 945

#line 945
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 945

#line 945
		remaining -= extent;
#line 945
		if(remaining == 0)
#line 945
			break; /* normal loop exit */
#line 945
		offset += (off_t)extent;
#line 945
		value += nget;
#line 945
	}
#line 945

#line 945
	return status;
#line 945
}
#line 945

static int
#line 946
getNCvx_longlong_short(const NC3_INFO* ncp, const NC_var *varp,
#line 946
		 const size_t *start, size_t nelems, short *value)
#line 946
{
#line 946
	off_t offset = NC_varoffset(ncp, varp, start);
#line 946
	size_t remaining = varp->xsz * nelems;
#line 946
	int status = NC_NOERR;
#line 946
	const void *xp;
#line 946

#line 946
	if(nelems == 0)
#line 946
		return NC_NOERR;
#line 946

#line 946
	assert(value != NULL);
#line 946

#line 946
	for(;;)
#line 946
	{
#line 946
		size_t extent = MIN(remaining, ncp->chunk);
#line 946
		size_t nget = ncx_howmany(varp->type, extent);
#line 946

#line 946
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 946
				 0, (void **)&xp);	/* cast away const */
#line 946
		if(lstatus != NC_NOERR)
#line 946
			return lstatus;
#line 946

#line 946
		lstatus = ncx_getn_longlong_short(&xp, nget, value);
#line 946
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 946
			status = lstatus;
#line 946

#line 946
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 946

#line 946
		remaining -= extent;
#line 946
		if(remaining == 0)
#line 946
			break; /* normal loop exit */
#line 946
		offset += (off_t)extent;
#line 946
		value += nget;
#line 946
	}
#line 946

#line 946
	return status;
#line 946
}
#line 946

static int
#line 947
getNCvx_longlong_int(const NC3_INFO* ncp, const NC_var *varp,
#line 947
		 const size_t *start, size_t nelems, int *value)
#line 947
{
#line 947
	off_t offset = NC_varoffset(ncp, varp, start);
#line 947
	size_t remaining = varp->xsz * nelems;
#line 947
	int status = NC_NOERR;
#line 947
	const void *xp;
#line 947

#line 947
	if(nelems == 0)
#line 947
		return NC_NOERR;
#line 947

#line 947
	assert(value != NULL);
#line 947

#line 947
	for(;;)
#line 947
	{
#line 947
		size_t extent = MIN(remaining, ncp->chunk);
#line 947
		size_t nget = ncx_howmany(varp->type, extent);
#line 947

#line 947
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 947
				 0, (void **)&xp);	/* cast away const */
#line 947
		if(lstatus != NC_NOERR)
#line 947
			return lstatus;
#line 947

#line 947
		lstatus = ncx_getn_longlong_int(&xp, nget, value);
#line 947
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 947
			status = lstatus;
#line 947

#line 947
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 947

#line 947
		remaining -= extent;
#line 947
		if(remaining == 0)
#line 947
			break; /* normal loop exit */
#line 947
		offset += (off_t)extent;
#line 947
		value += nget;
#line 947
	}
#line 947

#line 947
	return status;
#line 947
}
#line 947

static int
#line 948
getNCvx_longlong_float(const NC3_INFO* ncp, const NC_var *varp,
#line 948
		 const size_t *start, size_t nelems, float *value)
#line 948
{
#line 948
	off_t offset = NC_varoffset(ncp, varp, start);
#line 948
	size_t remaining = varp->xsz * nelems;
#line 948
	int status = NC_NOERR;
#line 948
	const void *xp;
#line 948

#line 948
	if(nelems == 0)
#line 948
		return NC_NOERR;
#line 948

#line 948
	assert(value != NULL);
#line 948

#line 948
	for(;;)
#line 948
	{
#line 948
		size_t extent = MIN(remaining, ncp->chunk);
#line 948
		size_t nget = ncx_howmany(varp->type, extent);
#line 948

#line 948
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 948
				 0, (void **)&xp);	/* cast away const */
#line 948
		if(lstatus != NC_NOERR)
#line 948
			return lstatus;
#line 948

#line 948
		lstatus = ncx_getn_longlong_float(&xp, nget, value);
#line 948
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 948
			status = lstatus;
#line 948

#line 948
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 948

#line 948
		remaining -= extent;
#line 948
		if(remaining == 0)
#line 948
			break; /* normal loop exit */
#line 948
		offset += (off_t)extent;
#line 948
		value += nget;
#line 948
	}
#line 948

#line 948
	return status;
#line 948
}
#line 948

static int
#line 949
getNCvx_longlong_double(const NC3_INFO* ncp, const NC_var *varp,
#line 949
		 const size_t *start, size_t nelems, double *value)
#line 949
{
#line 949
	off_t offset = NC_varoffset(ncp, varp, start);
#line 949
	size_t remaining = varp->xsz * nelems;
#line 949
	int status = NC_NOERR;
#line 949
	const void *xp;
#line 949

#line 949
	if(nelems == 0)
#line 949
		return NC_NOERR;
#line 949

#line 949
	assert(value != NULL);
#line 949

#line 949
	for(;;)
#line 949
	{
#line 949
		size_t extent = MIN(remaining, ncp->chunk);
#line 949
		size_t nget = ncx_howmany(varp->type, extent);
#line 949

#line 949
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 949
				 0, (void **)&xp);	/* cast away const */
#line 949
		if(lstatus != NC_NOERR)
#line 949
			return lstatus;
#line 949

#line 949
		lstatus = ncx_getn_longlong_double(&xp, nget, value);
#line 949
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 949
			status = lstatus;
#line 949

#line 949
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 949

#line 949
		remaining -= extent;
#line 949
		if(remaining == 0)
#line 949
			break; /* normal loop exit */
#line 949
		offset += (off_t)extent;
#line 949
		value += nget;
#line 949
	}
#line 949

#line 949
	return status;
#line 949
}
#line 949

static int
#line 950
getNCvx_longlong_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 950
		 const size_t *start, size_t nelems, longlong *value)
#line 950
{
#line 950
	off_t offset = NC_varoffset(ncp, varp, start);
#line 950
	size_t remaining = varp->xsz * nelems;
#line 950
	int status = NC_NOERR;
#line 950
	const void *xp;
#line 950

#line 950
	if(nelems == 0)
#line 950
		return NC_NOERR;
#line 950

#line 950
	assert(value != NULL);
#line 950

#line 950
	for(;;)
#line 950
	{
#line 950
		size_t extent = MIN(remaining, ncp->chunk);
#line 950
		size_t nget = ncx_howmany(varp->type, extent);
#line 950

#line 950
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 950
				 0, (void **)&xp);	/* cast away const */
#line 950
		if(lstatus != NC_NOERR)
#line 950
			return lstatus;
#line 950

#line 950
		lstatus = ncx_getn_longlong_longlong(&xp, nget, value);
#line 950
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 950
			status = lstatus;
#line 950

#line 950
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 950

#line 950
		remaining -= extent;
#line 950
		if(remaining == 0)
#line 950
			break; /* normal loop exit */
#line 950
		offset += (off_t)extent;
#line 950
		value += nget;
#line 950
	}
#line 950

#line 950
	return status;
#line 950
}
#line 950

static int
#line 951
getNCvx_longlong_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 951
		 const size_t *start, size_t nelems, uint *value)
#line 951
{
#line 951
	off_t offset = NC_varoffset(ncp, varp, start);
#line 951
	size_t remaining = varp->xsz * nelems;
#line 951
	int status = NC_NOERR;
#line 951
	const void *xp;
#line 951

#line 951
	if(nelems == 0)
#line 951
		return NC_NOERR;
#line 951

#line 951
	assert(value != NULL);
#line 951

#line 951
	for(;;)
#line 951
	{
#line 951
		size_t extent = MIN(remaining, ncp->chunk);
#line 951
		size_t nget = ncx_howmany(varp->type, extent);
#line 951

#line 951
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 951
				 0, (void **)&xp);	/* cast away const */
#line 951
		if(lstatus != NC_NOERR)
#line 951
			return lstatus;
#line 951

#line 951
		lstatus = ncx_getn_longlong_uint(&xp, nget, value);
#line 951
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 951
			status = lstatus;
#line 951

#line 951
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 951

#line 951
		remaining -= extent;
#line 951
		if(remaining == 0)
#line 951
			break; /* normal loop exit */
#line 951
		offset += (off_t)extent;
#line 951
		value += nget;
#line 951
	}
#line 951

#line 951
	return status;
#line 951
}
#line 951

static int
#line 952
getNCvx_longlong_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 952
		 const size_t *start, size_t nelems, ulonglong *value)
#line 952
{
#line 952
	off_t offset = NC_varoffset(ncp, varp, start);
#line 952
	size_t remaining = varp->xsz * nelems;
#line 952
	int status = NC_NOERR;
#line 952
	const void *xp;
#line 952

#line 952
	if(nelems == 0)
#line 952
		return NC_NOERR;
#line 952

#line 952
	assert(value != NULL);
#line 952

#line 952
	for(;;)
#line 952
	{
#line 952
		size_t extent = MIN(remaining, ncp->chunk);
#line 952
		size_t nget = ncx_howmany(varp->type, extent);
#line 952

#line 952
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 952
				 0, (void **)&xp);	/* cast away const */
#line 952
		if(lstatus != NC_NOERR)
#line 952
			return lstatus;
#line 952

#line 952
		lstatus = ncx_getn_longlong_ulonglong(&xp, nget, value);
#line 952
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 952
			status = lstatus;
#line 952

#line 952
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 952

#line 952
		remaining -= extent;
#line 952
		if(remaining == 0)
#line 952
			break; /* normal loop exit */
#line 952
		offset += (off_t)extent;
#line 952
		value += nget;
#line 952
	}
#line 952

#line 952
	return status;
#line 952
}
#line 952

static int
#line 953
getNCvx_longlong_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 953
		 const size_t *start, size_t nelems, ushort *value)
#line 953
{
#line 953
	off_t offset = NC_varoffset(ncp, varp, start);
#line 953
	size_t remaining = varp->xsz * nelems;
#line 953
	int status = NC_NOERR;
#line 953
	const void *xp;
#line 953

#line 953
	if(nelems == 0)
#line 953
		return NC_NOERR;
#line 953

#line 953
	assert(value != NULL);
#line 953

#line 953
	for(;;)
#line 953
	{
#line 953
		size_t extent = MIN(remaining, ncp->chunk);
#line 953
		size_t nget = ncx_howmany(varp->type, extent);
#line 953

#line 953
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 953
				 0, (void **)&xp);	/* cast away const */
#line 953
		if(lstatus != NC_NOERR)
#line 953
			return lstatus;
#line 953

#line 953
		lstatus = ncx_getn_longlong_ushort(&xp, nget, value);
#line 953
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 953
			status = lstatus;
#line 953

#line 953
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 953

#line 953
		remaining -= extent;
#line 953
		if(remaining == 0)
#line 953
			break; /* normal loop exit */
#line 953
		offset += (off_t)extent;
#line 953
		value += nget;
#line 953
	}
#line 953

#line 953
	return status;
#line 953
}
#line 953


static int
#line 955
getNCvx_ulonglong_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 955
		 const size_t *start, size_t nelems, schar *value)
#line 955
{
#line 955
	off_t offset = NC_varoffset(ncp, varp, start);
#line 955
	size_t remaining = varp->xsz * nelems;
#line 955
	int status = NC_NOERR;
#line 955
	const void *xp;
#line 955

#line 955
	if(nelems == 0)
#line 955
		return NC_NOERR;
#line 955

#line 955
	assert(value != NULL);
#line 955

#line 955
	for(;;)
#line 955
	{
#line 955
		size_t extent = MIN(remaining, ncp->chunk);
#line 955
		size_t nget = ncx_howmany(varp->type, extent);
#line 955

#line 955
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 955
				 0, (void **)&xp);	/* cast away const */
#line 955
		if(lstatus != NC_NOERR)
#line 955
			return lstatus;
#line 955

#line 955
		lstatus = ncx_getn_ulonglong_schar(&xp, nget, value);
#line 955
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 955
			status = lstatus;
#line 955

#line 955
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 955

#line 955
		remaining -= extent;
#line 955
		if(remaining == 0)
#line 955
			break; /* normal loop exit */
#line 955
		offset += (off_t)extent;
#line 955
		value += nget;
#line 955
	}
#line 955

#line 955
	return status;
#line 955
}
#line 955

static int
#line 956
getNCvx_ulonglong_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 956
		 const size_t *start, size_t nelems, uchar *value)
#line 956
{
#line 956
	off_t offset = NC_varoffset(ncp, varp, start);
#line 956
	size_t remaining = varp->xsz * nelems;
#line 956
	int status = NC_NOERR;
#line 956
	const void *xp;
#line 956

#line 956
	if(nelems == 0)
#line 956
		return NC_NOERR;
#line 956

#line 956
	assert(value != NULL);
#line 956

#line 956
	for(;;)
#line 956
	{
#line 956
		size_t extent = MIN(remaining, ncp->chunk);
#line 956
		size_t nget = ncx_howmany(varp->type, extent);
#line 956

#line 956
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 956
				 0, (void **)&xp);	/* cast away const */
#line 956
		if(lstatus != NC_NOERR)
#line 956
			return lstatus;
#line 956

#line 956
		lstatus = ncx_getn_ulonglong_uchar(&xp, nget, value);
#line 956
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 956
			status = lstatus;
#line 956

#line 956
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 956

#line 956
		remaining -= extent;
#line 956
		if(remaining == 0)
#line 956
			break; /* normal loop exit */
#line 956
		offset += (off_t)extent;
#line 956
		value += nget;
#line 956
	}
#line 956

#line 956
	return status;
#line 956
}
#line 956

static int
#line 957
getNCvx_ulonglong_short(const NC3_INFO* ncp, const NC_var *varp,
#line 957
		 const size_t *start, size_t nelems, short *value)
#line 957
{
#line 957
	off_t offset = NC_varoffset(ncp, varp, start);
#line 957
	size_t remaining = varp->xsz * nelems;
#line 957
	int status = NC_NOERR;
#line 957
	const void *xp;
#line 957

#line 957
	if(nelems == 0)
#line 957
		return NC_NOERR;
#line 957

#line 957
	assert(value != NULL);
#line 957

#line 957
	for(;;)
#line 957
	{
#line 957
		size_t extent = MIN(remaining, ncp->chunk);
#line 957
		size_t nget = ncx_howmany(varp->type, extent);
#line 957

#line 957
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 957
				 0, (void **)&xp);	/* cast away const */
#line 957
		if(lstatus != NC_NOERR)
#line 957
			return lstatus;
#line 957

#line 957
		lstatus = ncx_getn_ulonglong_short(&xp, nget, value);
#line 957
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 957
			status = lstatus;
#line 957

#line 957
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 957

#line 957
		remaining -= extent;
#line 957
		if(remaining == 0)
#line 957
			break; /* normal loop exit */
#line 957
		offset += (off_t)extent;
#line 957
		value += nget;
#line 957
	}
#line 957

#line 957
	return status;
#line 957
}
#line 957

static int
#line 958
getNCvx_ulonglong_int(const NC3_INFO* ncp, const NC_var *varp,
#line 958
		 const size_t *start, size_t nelems, int *value)
#line 958
{
#line 958
	off_t offset = NC_varoffset(ncp, varp, start);
#line 958
	size_t remaining = varp->xsz * nelems;
#line 958
	int status = NC_NOERR;
#line 958
	const void *xp;
#line 958

#line 958
	if(nelems == 0)
#line 958
		return NC_NOERR;
#line 958

#line 958
	assert(value != NULL);
#line 958

#line 958
	for(;;)
#line 958
	{
#line 958
		size_t extent = MIN(remaining, ncp->chunk);
#line 958
		size_t nget = ncx_howmany(varp->type, extent);
#line 958

#line 958
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 958
				 0, (void **)&xp);	/* cast away const */
#line 958
		if(lstatus != NC_NOERR)
#line 958
			return lstatus;
#line 958

#line 958
		lstatus = ncx_getn_ulonglong_int(&xp, nget, value);
#line 958
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 958
			status = lstatus;
#line 958

#line 958
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 958

#line 958
		remaining -= extent;
#line 958
		if(remaining == 0)
#line 958
			break; /* normal loop exit */
#line 958
		offset += (off_t)extent;
#line 958
		value += nget;
#line 958
	}
#line 958

#line 958
	return status;
#line 958
}
#line 958

static int
#line 959
getNCvx_ulonglong_float(const NC3_INFO* ncp, const NC_var *varp,
#line 959
		 const size_t *start, size_t nelems, float *value)
#line 959
{
#line 959
	off_t offset = NC_varoffset(ncp, varp, start);
#line 959
	size_t remaining = varp->xsz * nelems;
#line 959
	int status = NC_NOERR;
#line 959
	const void *xp;
#line 959

#line 959
	if(nelems == 0)
#line 959
		return NC_NOERR;
#line 959

#line 959
	assert(value != NULL);
#line 959

#line 959
	for(;;)
#line 959
	{
#line 959
		size_t extent = MIN(remaining, ncp->chunk);
#line 959
		size_t nget = ncx_howmany(varp->type, extent);
#line 959

#line 959
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 959
				 0, (void **)&xp);	/* cast away const */
#line 959
		if(lstatus != NC_NOERR)
#line 959
			return lstatus;
#line 959

#line 959
		lstatus = ncx_getn_ulonglong_float(&xp, nget, value);
#line 959
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 959
			status = lstatus;
#line 959

#line 959
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 959

#line 959
		remaining -= extent;
#line 959
		if(remaining == 0)
#line 959
			break; /* normal loop exit */
#line 959
		offset += (off_t)extent;
#line 959
		value += nget;
#line 959
	}
#line 959

#line 959
	return status;
#line 959
}
#line 959

static int
#line 960
getNCvx_ulonglong_double(const NC3_INFO* ncp, const NC_var *varp,
#line 960
		 const size_t *start, size_t nelems, double *value)
#line 960
{
#line 960
	off_t offset = NC_varoffset(ncp, varp, start);
#line 960
	size_t remaining = varp->xsz * nelems;
#line 960
	int status = NC_NOERR;
#line 960
	const void *xp;
#line 960

#line 960
	if(nelems == 0)
#line 960
		return NC_NOERR;
#line 960

#line 960
	assert(value != NULL);
#line 960

#line 960
	for(;;)
#line 960
	{
#line 960
		size_t extent = MIN(remaining, ncp->chunk);
#line 960
		size_t nget = ncx_howmany(varp->type, extent);
#line 960

#line 960
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 960
				 0, (void **)&xp);	/* cast away const */
#line 960
		if(lstatus != NC_NOERR)
#line 960
			return lstatus;
#line 960

#line 960
		lstatus = ncx_getn_ulonglong_double(&xp, nget, value);
#line 960
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 960
			status = lstatus;
#line 960

#line 960
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 960

#line 960
		remaining -= extent;
#line 960
		if(remaining == 0)
#line 960
			break; /* normal loop exit */
#line 960
		offset += (off_t)extent;
#line 960
		value += nget;
#line 960
	}
#line 960

#line 960
	return status;
#line 960
}
#line 960

static int
#line 961
getNCvx_ulonglong_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 961
		 const size_t *start, size_t nelems, longlong *value)
#line 961
{
#line 961
	off_t offset = NC_varoffset(ncp, varp, start);
#line 961
	size_t remaining = varp->xsz * nelems;
#line 961
	int status = NC_NOERR;
#line 961
	const void *xp;
#line 961

#line 961
	if(nelems == 0)
#line 961
		return NC_NOERR;
#line 961

#line 961
	assert(value != NULL);
#line 961

#line 961
	for(;;)
#line 961
	{
#line 961
		size_t extent = MIN(remaining, ncp->chunk);
#line 961
		size_t nget = ncx_howmany(varp->type, extent);
#line 961

#line 961
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 961
				 0, (void **)&xp);	/* cast away const */
#line 961
		if(lstatus != NC_NOERR)
#line 961
			return lstatus;
#line 961

#line 961
		lstatus = ncx_getn_ulonglong_longlong(&xp, nget, value);
#line 961
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 961
			status = lstatus;
#line 961

#line 961
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 961

#line 961
		remaining -= extent;
#line 961
		if(remaining == 0)
#line 961
			break; /* normal loop exit */
#line 961
		offset += (off_t)extent;
#line 961
		value += nget;
#line 961
	}
#line 961

#line 961
	return status;
#line 961
}
#line 961

static int
#line 962
getNCvx_ulonglong_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 962
		 const size_t *start, size_t nelems, uint *value)
#line 962
{
#line 962
	off_t offset = NC_varoffset(ncp, varp, start);
#line 962
	size_t remaining = varp->xsz * nelems;
#line 962
	int status = NC_NOERR;
#line 962
	const void *xp;
#line 962

#line 962
	if(nelems == 0)
#line 962
		return NC_NOERR;
#line 962

#line 962
	assert(value != NULL);
#line 962

#line 962
	for(;;)
#line 962
	{
#line 962
		size_t extent = MIN(remaining, ncp->chunk);
#line 962
		size_t nget = ncx_howmany(varp->type, extent);
#line 962

#line 962
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 962
				 0, (void **)&xp);	/* cast away const */
#line 962
		if(lstatus != NC_NOERR)
#line 962
			return lstatus;
#line 962

#line 962
		lstatus = ncx_getn_ulonglong_uint(&xp, nget, value);
#line 962
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 962
			status = lstatus;
#line 962

#line 962
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 962

#line 962
		remaining -= extent;
#line 962
		if(remaining == 0)
#line 962
			break; /* normal loop exit */
#line 962
		offset += (off_t)extent;
#line 962
		value += nget;
#line 962
	}
#line 962

#line 962
	return status;
#line 962
}
#line 962

static int
#line 963
getNCvx_ulonglong_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 963
		 const size_t *start, size_t nelems, ulonglong *value)
#line 963
{
#line 963
	off_t offset = NC_varoffset(ncp, varp, start);
#line 963
	size_t remaining = varp->xsz * nelems;
#line 963
	int status = NC_NOERR;
#line 963
	const void *xp;
#line 963

#line 963
	if(nelems == 0)
#line 963
		return NC_NOERR;
#line 963

#line 963
	assert(value != NULL);
#line 963

#line 963
	for(;;)
#line 963
	{
#line 963
		size_t extent = MIN(remaining, ncp->chunk);
#line 963
		size_t nget = ncx_howmany(varp->type, extent);
#line 963

#line 963
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 963
				 0, (void **)&xp);	/* cast away const */
#line 963
		if(lstatus != NC_NOERR)
#line 963
			return lstatus;
#line 963

#line 963
		lstatus = ncx_getn_ulonglong_ulonglong(&xp, nget, value);
#line 963
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 963
			status = lstatus;
#line 963

#line 963
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 963

#line 963
		remaining -= extent;
#line 963
		if(remaining == 0)
#line 963
			break; /* normal loop exit */
#line 963
		offset += (off_t)extent;
#line 963
		value += nget;
#line 963
	}
#line 963

#line 963
	return status;
#line 963
}
#line 963

static int
#line 964
getNCvx_ulonglong_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 964
		 const size_t *start, size_t nelems, ushort *value)
#line 964
{
#line 964
	off_t offset = NC_varoffset(ncp, varp, start);
#line 964
	size_t remaining = varp->xsz * nelems;
#line 964
	int status = NC_NOERR;
#line 964
	const void *xp;
#line 964

#line 964
	if(nelems == 0)
#line 964
		return NC_NOERR;
#line 964

#line 964
	assert(value != NULL);
#line 964

#line 964
	for(;;)
#line 964
	{
#line 964
		size_t extent = MIN(remaining, ncp->chunk);
#line 964
		size_t nget = ncx_howmany(varp->type, extent);
#line 964

#line 964
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 964
				 0, (void **)&xp);	/* cast away const */
#line 964
		if(lstatus != NC_NOERR)
#line 964
			return lstatus;
#line 964

#line 964
		lstatus = ncx_getn_ulonglong_ushort(&xp, nget, value);
#line 964
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 964
			status = lstatus;
#line 964

#line 964
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 964

#line 964
		remaining -= extent;
#line 964
		if(remaining == 0)
#line 964
			break; /* normal loop exit */
#line 964
		offset += (off_t)extent;
#line 964
		value += nget;
#line 964
	}
#line 964

#line 964
	return status;
#line 964
}
#line 964


#line 967
#ifdef NOTUSED
static int
#line 968
getNCvx_schar_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 968
		 const size_t *start, size_t nelems, uchar *value)
#line 968
{
#line 968
	off_t offset = NC_varoffset(ncp, varp, start);
#line 968
	size_t remaining = varp->xsz * nelems;
#line 968
	int status = NC_NOERR;
#line 968
	const void *xp;
#line 968

#line 968
	if(nelems == 0)
#line 968
		return NC_NOERR;
#line 968

#line 968
	assert(value != NULL);
#line 968

#line 968
	for(;;)
#line 968
	{
#line 968
		size_t extent = MIN(remaining, ncp->chunk);
#line 968
		size_t nget = ncx_howmany(varp->type, extent);
#line 968

#line 968
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 968
				 0, (void **)&xp);	/* cast away const */
#line 968
		if(lstatus != NC_NOERR)
#line 968
			return lstatus;
#line 968

#line 968
		lstatus = ncx_getn_schar_uchar(&xp, nget, value);
#line 968
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 968
			status = lstatus;
#line 968

#line 968
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 968

#line 968
		remaining -= extent;
#line 968
		if(remaining == 0)
#line 968
			break; /* normal loop exit */
#line 968
		offset += (off_t)extent;
#line 968
		value += nget;
#line 968
	}
#line 968

#line 968
	return status;
#line 968
}
#line 968

#endif /*NOTUSED*/

/*
 *  For ncvar{put,get},
 *  find the largest contiguous block from within 'edges'.
 *  returns the index to the left of this (which may be -1).
 *  Compute the number of contiguous elements and return
 *  that in *iocountp.
 *  The presence of "record" variables makes this routine
 *  overly subtle.
 */
static int
NCiocount(const NC3_INFO* const ncp, const NC_var *const varp,
	const size_t *const edges,
	size_t *const iocountp)
{
	const size_t *edp0 = edges;
	const size_t *edp = edges + varp->ndims;
	const size_t *shp = varp->shape + varp->ndims;

	if(IS_RECVAR(varp))
	{
		if(varp->ndims == 1 && ncp->recsize <= varp->len)
		{
			/* one dimensional && the only 'record' variable */
			*iocountp = *edges;
			return(0);
		}
		/* else */
		edp0++;
	}

	assert(edges != NULL);

	/* find max contiguous */
	while(edp > edp0)
	{
		shp--; edp--;
		if(*edp < *shp )
		{
			const size_t *zedp = edp;
			while(zedp >= edp0)
			{
				if(*zedp == 0)
				{
					*iocountp = 0;
					goto done;
				}
				/* Tip of the hat to segmented architectures */
				if(zedp == edp0)
					break;
				zedp--;
			}
			break;
		}
		assert(*edp == *shp);
	}

	/*
	 * edp, shp reference rightmost index s.t. *(edp +1) == *(shp +1)
	 *
	 * Or there is only one dimension.
	 * If there is only one dimension and it is 'non record' dimension,
	 * 	edp is &edges[0] and we will return -1.
	 * If there is only one dimension and and it is a "record dimension",
	 *	edp is &edges[1] (out of bounds) and we will return 0;
	 */
	assert(shp >= varp->shape + varp->ndims -1
		|| *(edp +1) == *(shp +1));

	/* now accumulate max count for a single io operation */
	for(*iocountp = 1, edp0 = edp;
		 	edp0 < edges + varp->ndims;
			edp0++)
	{
		*iocountp *= *edp0;
	}

done:
	return((int)(edp - edges) - 1);
}


/*
 * Set the elements of the array 'upp' to
 * the sum of the corresponding elements of
 * 'stp' and 'edp'. 'end' should be &stp[nelems].
 */
static void
set_upper(size_t *upp, /* modified on return */
	const size_t *stp,
	const size_t *edp,
	const size_t *const end)
{
	while(upp < end) {
		*upp++ = *stp++ + *edp++;
	}
}


/*
 * The infamous and oft-discussed odometer code.
 *
 * 'start[]' is the starting coordinate.
 * 'upper[]' is the upper bound s.t. start[ii] < upper[ii].
 * 'coord[]' is the register, the current coordinate value.
 * For some ii,
 * upp == &upper[ii]
 * cdp == &coord[ii]
 *
 * Running this routine increments *cdp.
 *
 * If after the increment, *cdp is equal to *upp
 * (and cdp is not the leftmost dimension),
 * *cdp is "zeroed" to the starting value and
 * we need to "carry", eg, increment one place to
 * the left.
 *
 * TODO: Some architectures hate recursion?
 * 	Reimplement non-recursively.
 */
static void
odo1(const size_t *const start, const size_t *const upper,
	size_t *const coord, /* modified on return */
	const size_t *upp,
	size_t *cdp)
{
	assert(coord <= cdp && cdp <= coord + NC_MAX_VAR_DIMS);
	assert(upper <= upp && upp <= upper + NC_MAX_VAR_DIMS);
	assert(upp - upper == cdp - coord);

	assert(*cdp <= *upp);

	(*cdp)++;
	if(cdp != coord && *cdp >= *upp)
	{
		*cdp = start[cdp - coord];
		odo1(start, upper, coord, upp -1, cdp -1);
	}
}
#ifdef _CRAYC
#pragma _CRI noinline odo1
#endif


#line 1130

/* Define a macro to allow hash on two type values */
#define CASE(nc1,nc2) (nc1*256+nc2)

static int
readNCv(const NC3_INFO* ncp, const NC_var* varp, const size_t* start,
        const size_t nelems, void* value, const nc_type memtype)
{
    int status = NC_NOERR;
    switch (CASE(varp->type,memtype)) {

    case CASE(NC_CHAR,NC_CHAR):
    case CASE(NC_CHAR,NC_UBYTE):
    return getNCvx_schar_schar(ncp,varp,start,nelems,(signed char*)value);
    break;
    case CASE(NC_BYTE,NC_BYTE):
        return getNCvx_schar_schar(ncp,varp,start,nelems, (schar*)value);
	break;
    case CASE(NC_BYTE,NC_UBYTE):
        if (fIsSet(ncp->flags,NC_64BIT_DATA))
            return getNCvx_schar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
        else
            /* for CDF-1 and CDF-2, NC_BYTE is treated the same type as uchar memtype */
            return getNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_BYTE,NC_SHORT):
        return getNCvx_schar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_BYTE,NC_INT):
        return getNCvx_schar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_BYTE,NC_FLOAT):
        return getNCvx_schar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_BYTE,NC_DOUBLE):
        return getNCvx_schar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_BYTE,NC_INT64):
        return getNCvx_schar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_BYTE,NC_UINT):
        return getNCvx_schar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_BYTE,NC_UINT64):
        return getNCvx_schar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
    	break;
    case CASE(NC_BYTE,NC_USHORT):
        return getNCvx_schar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_SHORT,NC_BYTE):
        return getNCvx_short_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_SHORT,NC_UBYTE):
        return getNCvx_short_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_SHORT,NC_SHORT):
        return getNCvx_short_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_SHORT,NC_INT):
        return getNCvx_short_int(ncp,varp,start,nelems,(int*)value);
	break;
   case CASE(NC_SHORT,NC_FLOAT):
        return getNCvx_short_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_SHORT,NC_DOUBLE):
        return getNCvx_short_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_SHORT,NC_INT64):
        return getNCvx_short_longlong(ncp,varp,start,nelems,(long long*)value);
   	break;
    case CASE(NC_SHORT,NC_UINT):
        return getNCvx_short_uint(ncp,varp,start,nelems,(unsigned int*)value);
    	break;
    case CASE(NC_SHORT,NC_UINT64):
        return getNCvx_short_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_SHORT,NC_USHORT):
        return getNCvx_short_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_INT,NC_BYTE):
        return getNCvx_int_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT,NC_UBYTE):
        return getNCvx_int_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT,NC_SHORT):
        return getNCvx_int_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT,NC_INT):
        return getNCvx_int_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT,NC_FLOAT):
        return getNCvx_int_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT,NC_DOUBLE):
        return getNCvx_int_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT,NC_INT64):
        return getNCvx_int_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT,NC_UINT):
        return getNCvx_int_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT,NC_UINT64):
        return getNCvx_int_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT,NC_USHORT):
        return getNCvx_int_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_FLOAT,NC_BYTE):
        return getNCvx_float_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_FLOAT,NC_UBYTE):
        return getNCvx_float_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_FLOAT,NC_SHORT):
        return getNCvx_float_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_FLOAT,NC_INT):
        return getNCvx_float_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_FLOAT,NC_FLOAT):
        return getNCvx_float_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_FLOAT,NC_DOUBLE):
        return getNCvx_float_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_FLOAT,NC_INT64):
        return getNCvx_float_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT):
        return getNCvx_float_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT64):
        return getNCvx_float_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_FLOAT,NC_USHORT):
        return getNCvx_float_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_DOUBLE,NC_BYTE):
        return getNCvx_double_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_DOUBLE,NC_UBYTE):
        return getNCvx_double_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_DOUBLE,NC_SHORT):
        return getNCvx_double_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT):
        return getNCvx_double_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_DOUBLE,NC_FLOAT):
        return getNCvx_double_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_DOUBLE,NC_DOUBLE):
        return getNCvx_double_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT64):
        return getNCvx_double_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT):
        return getNCvx_double_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT64):
        return getNCvx_double_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_USHORT):
        return getNCvx_double_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_UBYTE,NC_UBYTE):
        return getNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UBYTE,NC_BYTE):
        return getNCvx_uchar_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UBYTE,NC_SHORT):
        return getNCvx_uchar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UBYTE,NC_INT):
        return getNCvx_uchar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UBYTE,NC_FLOAT):
        return getNCvx_uchar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UBYTE,NC_DOUBLE):
        return getNCvx_uchar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_UBYTE,NC_INT64):
        return getNCvx_uchar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT):
        return getNCvx_uchar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT64):
        return getNCvx_uchar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UBYTE,NC_USHORT):
        return getNCvx_uchar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_USHORT,NC_BYTE):
        return getNCvx_ushort_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_USHORT,NC_UBYTE):
        return getNCvx_ushort_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_USHORT,NC_SHORT):
        return getNCvx_ushort_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_USHORT,NC_INT):
        return getNCvx_ushort_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_USHORT,NC_FLOAT):
        return getNCvx_ushort_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_USHORT,NC_DOUBLE):
        return getNCvx_ushort_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_USHORT,NC_INT64):
        return getNCvx_ushort_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_USHORT,NC_UINT):
        return getNCvx_ushort_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_USHORT,NC_UINT64):
        return getNCvx_ushort_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_USHORT,NC_USHORT):
        return getNCvx_ushort_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_UINT,NC_BYTE):
        return getNCvx_uint_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT,NC_UBYTE):
        return getNCvx_uint_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT,NC_SHORT):
        return getNCvx_uint_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT,NC_INT):
        return getNCvx_uint_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT,NC_FLOAT):
        return getNCvx_uint_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT,NC_DOUBLE):
        return getNCvx_uint_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT,NC_INT64):
        return getNCvx_uint_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT,NC_UINT):
        return getNCvx_uint_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT,NC_UINT64):
        return getNCvx_uint_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT,NC_USHORT):
        return getNCvx_uint_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_INT64,NC_BYTE):
        return getNCvx_longlong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT64,NC_UBYTE):
        return getNCvx_longlong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT64,NC_SHORT):
        return getNCvx_longlong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT64,NC_INT):
        return getNCvx_longlong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT64,NC_FLOAT):
        return getNCvx_longlong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT64,NC_DOUBLE):
        return getNCvx_longlong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT64,NC_INT64):
        return getNCvx_longlong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT64,NC_UINT):
        return getNCvx_longlong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT64,NC_UINT64):
        return getNCvx_longlong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT64,NC_USHORT):
        return getNCvx_longlong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_UINT64,NC_BYTE):
        return getNCvx_ulonglong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT64,NC_UBYTE):
        return getNCvx_ulonglong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT64,NC_SHORT):
        return getNCvx_ulonglong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT64,NC_INT):
        return getNCvx_ulonglong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT64,NC_FLOAT):
        return getNCvx_ulonglong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT64,NC_DOUBLE):
        return getNCvx_ulonglong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT64,NC_INT64):
        return getNCvx_ulonglong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT64,NC_UINT):
        return getNCvx_ulonglong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT64,NC_UINT64):
        return getNCvx_ulonglong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT64,NC_USHORT):
        return getNCvx_ulonglong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    default:
	return NC_EBADTYPE;
	break;
    }
    return status;
}


static int
writeNCv(NC3_INFO* ncp, const NC_var* varp, const size_t* start,
         const size_t nelems, const void* value, const nc_type memtype)
{
    int status = NC_NOERR;
    switch (CASE(varp->type,memtype)) {

    case CASE(NC_CHAR,NC_CHAR):
    case CASE(NC_CHAR,NC_UBYTE):
        return putNCvx_char_char(ncp,varp,start,nelems,(char*)value);
	break;
    case CASE(NC_BYTE,NC_BYTE):
        return putNCvx_schar_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_BYTE,NC_UBYTE):
        if (fIsSet(ncp->flags,NC_64BIT_DATA))
            return putNCvx_schar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
        else
            /* for CDF-1 and CDF-2, NC_BYTE is treated the same type as uchar memtype */
            return putNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_BYTE,NC_SHORT):
        return putNCvx_schar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_BYTE,NC_INT):
        return putNCvx_schar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_BYTE,NC_FLOAT):
        return putNCvx_schar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_BYTE,NC_DOUBLE):
        return putNCvx_schar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_BYTE,NC_INT64):
        return putNCvx_schar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_BYTE,NC_UINT):
        return putNCvx_schar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_BYTE,NC_UINT64):
        return putNCvx_schar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_BYTE,NC_USHORT):
        return putNCvx_schar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_SHORT,NC_BYTE):
        return putNCvx_short_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_SHORT,NC_UBYTE):
        return putNCvx_short_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_SHORT,NC_SHORT):
        return putNCvx_short_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_SHORT,NC_INT):
        return putNCvx_short_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_SHORT,NC_FLOAT):
        return putNCvx_short_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_SHORT,NC_DOUBLE):
        return putNCvx_short_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_SHORT,NC_INT64):
        return putNCvx_short_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_SHORT,NC_UINT):
        return putNCvx_short_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_SHORT,NC_UINT64):
        return putNCvx_short_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_SHORT,NC_USHORT):
        return putNCvx_short_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_INT,NC_BYTE):
        return putNCvx_int_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT,NC_UBYTE):
        return putNCvx_int_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT,NC_SHORT):
        return putNCvx_int_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT,NC_INT):
        return putNCvx_int_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT,NC_FLOAT):
        return putNCvx_int_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT,NC_DOUBLE):
        return putNCvx_int_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT,NC_INT64):
        return putNCvx_int_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT,NC_UINT):
        return putNCvx_int_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT,NC_UINT64):
        return putNCvx_int_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT,NC_USHORT):
        return putNCvx_int_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_FLOAT,NC_BYTE):
        return putNCvx_float_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_FLOAT,NC_UBYTE):
        return putNCvx_float_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_FLOAT,NC_SHORT):
        return putNCvx_float_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_FLOAT,NC_INT):
        return putNCvx_float_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_FLOAT,NC_FLOAT):
        return putNCvx_float_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_FLOAT,NC_DOUBLE):
        return putNCvx_float_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_FLOAT,NC_INT64):
        return putNCvx_float_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT):
        return putNCvx_float_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT64):
        return putNCvx_float_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_FLOAT,NC_USHORT):
        return putNCvx_float_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_DOUBLE,NC_BYTE):
        return putNCvx_double_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_DOUBLE,NC_UBYTE):
        return putNCvx_double_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_DOUBLE,NC_SHORT):
        return putNCvx_double_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT):
        return putNCvx_double_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_DOUBLE,NC_FLOAT):
        return putNCvx_double_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_DOUBLE,NC_DOUBLE):
        return putNCvx_double_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT64):
        return putNCvx_double_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT):
        return putNCvx_double_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT64):
        return putNCvx_double_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_USHORT):
        return putNCvx_double_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_UBYTE,NC_UBYTE):
        return putNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UBYTE,NC_BYTE):
        return putNCvx_uchar_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UBYTE,NC_SHORT):
        return putNCvx_uchar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UBYTE,NC_INT):
        return putNCvx_uchar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UBYTE,NC_FLOAT):
        return putNCvx_uchar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UBYTE,NC_DOUBLE):
        return putNCvx_uchar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_UBYTE,NC_INT64):
        return putNCvx_uchar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT):
        return putNCvx_uchar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT64):
        return putNCvx_uchar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UBYTE,NC_USHORT):
        return putNCvx_uchar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_USHORT,NC_BYTE):
        return putNCvx_ushort_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_USHORT,NC_UBYTE):
        return putNCvx_ushort_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_USHORT,NC_SHORT):
        return putNCvx_ushort_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_USHORT,NC_INT):
        return putNCvx_ushort_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_USHORT,NC_FLOAT):
        return putNCvx_ushort_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_USHORT,NC_DOUBLE):
        return putNCvx_ushort_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_USHORT,NC_INT64):
        return putNCvx_ushort_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_USHORT,NC_UINT):
        return putNCvx_ushort_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_USHORT,NC_UINT64):
        return putNCvx_ushort_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_USHORT,NC_USHORT):
        return putNCvx_ushort_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_UINT,NC_BYTE):
        return putNCvx_uint_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT,NC_UBYTE):
        return putNCvx_uint_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT,NC_SHORT):
        return putNCvx_uint_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT,NC_INT):
        return putNCvx_uint_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT,NC_FLOAT):
        return putNCvx_uint_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT,NC_DOUBLE):
        return putNCvx_uint_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT,NC_INT64):
        return putNCvx_uint_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT,NC_UINT):
        return putNCvx_uint_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT,NC_UINT64):
        return putNCvx_uint_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT,NC_USHORT):
        return putNCvx_uint_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_INT64,NC_BYTE):
        return putNCvx_longlong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT64,NC_UBYTE):
        return putNCvx_longlong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT64,NC_SHORT):
        return putNCvx_longlong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT64,NC_INT):
        return putNCvx_longlong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT64,NC_FLOAT):
        return putNCvx_longlong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT64,NC_DOUBLE):
        return putNCvx_longlong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT64,NC_INT64):
        return putNCvx_longlong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT64,NC_UINT):
        return putNCvx_longlong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT64,NC_UINT64):
        return putNCvx_longlong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT64,NC_USHORT):
        return putNCvx_longlong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_UINT64,NC_BYTE):
        return putNCvx_ulonglong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT64,NC_UBYTE):
        return putNCvx_ulonglong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT64,NC_SHORT):
        return putNCvx_ulonglong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT64,NC_INT):
        return putNCvx_ulonglong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT64,NC_FLOAT):
        return putNCvx_ulonglong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT64,NC_DOUBLE):
        return putNCvx_ulonglong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT64,NC_INT64):
        return putNCvx_ulonglong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT64,NC_UINT):
        return putNCvx_ulonglong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT64,NC_UINT64):
        return putNCvx_ulonglong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT64,NC_USHORT):
        return putNCvx_ulonglong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    default:
	return NC_EBADTYPE;
	break;
    }
    return status;
}

/**************************************************/

int
NC3_get_vara(int ncid, int varid,
	    const size_t *start, const size_t *edges0,
            void *value0,
	    nc_type memtype)
{
    int status = NC_NOERR;
    NC* nc;
    NC3_INFO* nc3;
    NC_var *varp;
    int ii;
    size_t iocount;
    size_t memtypelen;
    signed char* value = (signed char*) value0; /* legally allow ptr arithmetic */
    const size_t* edges = edges0; /* so we can modify for special cases */
    size_t modedges[NC_MAX_VAR_DIMS];

    status = NC_check_id(ncid, &nc);
    if(status != NC_NOERR)
        return status;
    nc3 = NC3_DATA(nc);

    if(NC_indef(nc3))
        return NC_EINDEFINE;

    status = NC_lookupvar(nc3, varid, &varp);
    if(status != NC_NOERR)
        return status;

    if(memtype == NC_NAT) memtype=varp->type;

    if(memtype == NC_CHAR && varp->type != NC_CHAR)
        return NC_ECHAR;
    else if(memtype != NC_CHAR && varp->type == NC_CHAR)
        return NC_ECHAR;

    /* If edges is NULL, then this was called from nc_get_var() */
    if(edges == NULL && varp->ndims > 0) {
	/* If this is a record variable, then we have to
           substitute the number of records into dimension 0. */
	if(varp->shape[0] == 0) {
	    (void)memcpy((void*)modedges,(void*)varp->shape,
                          sizeof(size_t)*varp->ndims);
	    modedges[0] = NC_get_numrecs(nc3);
	    edges = modedges;
	} else
	    edges = varp->shape;
    }

    status = NCcoordck(nc3, varp, start);
    if(status != NC_NOERR)
        return status;

    status = NCedgeck(nc3, varp, start, edges);
    if(status != NC_NOERR)
        return status;

    /* Get the size of the memtype */
    memtypelen = nctypelen(memtype);

    if(varp->ndims == 0) /* scalar variable */
    {
        return( readNCv(nc3, varp, start, 1, (void*)value, memtype) );
    }

    if(IS_RECVAR(varp))
    {
        if(*start + *edges > NC_get_numrecs(nc3))
            return NC_EEDGE;
        if(varp->ndims == 1 && nc3->recsize <= varp->len)
        {
            /* one dimensional && the only record variable  */
            return( readNCv(nc3, varp, start, *edges, (void*)value, memtype) );
        }
    }

    /*
     * find max contiguous
     *   and accumulate max count for a single io operation
     */
    ii = NCiocount(nc3, varp, edges, &iocount);

    if(ii == -1)
    {
        return( readNCv(nc3, varp, start, iocount, (void*)value, memtype) );
    }

    assert(ii >= 0);

    { /* inline */
    ALLOC_ONSTACK(coord, size_t, varp->ndims);
    ALLOC_ONSTACK(upper, size_t, varp->ndims);
    const size_t index = ii;

    /* copy in starting indices */
    (void) memcpy(coord, start, varp->ndims * sizeof(size_t));

    /* set up in maximum indices */
    set_upper(upper, start, edges, &upper[varp->ndims]);

    /* ripple counter */
    while(*coord < *upper)
    {
        const int lstatus = readNCv(nc3, varp, coord, iocount, (void*)value, memtype);
	if(lstatus != NC_NOERR)
        {
            if(lstatus != NC_ERANGE)
            {
                status = lstatus;
                /* fatal for the loop */
                break;
            }
            /* else NC_ERANGE, not fatal for the loop */
            if(status == NC_NOERR)
                status = lstatus;
        }
        value += (iocount * memtypelen);
        odo1(start, upper, coord, &upper[index], &coord[index]);
    }

    FREE_ONSTACK(upper);
    FREE_ONSTACK(coord);
    } /* end inline */

    return status;
}

int
NC3_put_vara(int ncid, int varid,
	    const size_t *start, const size_t *edges0,
            const void *value0,
	    nc_type memtype)
{
    int status = NC_NOERR;
    NC *nc;
    NC3_INFO* nc3;
    NC_var *varp;
    int ii;
    size_t iocount;
    size_t memtypelen;
    signed char* value = (signed char*) value0; /* legally allow ptr arithmetic */
    const size_t* edges = edges0; /* so we can modify for special cases */
    size_t modedges[NC_MAX_VAR_DIMS];

    status = NC_check_id(ncid, &nc);
    if(status != NC_NOERR)
        return status;
    nc3 = NC3_DATA(nc);

    if(NC_readonly(nc3))
        return NC_EPERM;

    if(NC_indef(nc3))
        return NC_EINDEFINE;

    status = NC_lookupvar(nc3, varid, &varp);
    if(status != NC_NOERR)
       return status; /*invalid varid */


    if(memtype == NC_NAT) memtype=varp->type;

    if(memtype == NC_CHAR && varp->type != NC_CHAR)
        return NC_ECHAR;
    else if(memtype != NC_CHAR && varp->type == NC_CHAR)
        return NC_ECHAR;

    /* Get the size of the memtype */
    memtypelen = nctypelen(memtype);

    /* If edges is NULL, then this was called from nc_get_var() */
    if(edges == NULL && varp->ndims > 0) {
	/* If this is a record variable, then we have to
           substitute the number of records into dimension 0. */
	if(varp->shape[0] == 0) {
	    (void)memcpy((void*)modedges,(void*)varp->shape,
                          sizeof(size_t)*varp->ndims);
	    modedges[0] = NC_get_numrecs(nc3);
	    edges = modedges;
	} else
	    edges = varp->shape;
    }

    status = NCcoordck(nc3, varp, start);
    if(status != NC_NOERR)
        return status;
    status = NCedgeck(nc3, varp, start, edges);
    if(status != NC_NOERR)
        return status;

    if(varp->ndims == 0) /* scalar variable */
    {
        return( writeNCv(nc3, varp, start, 1, (void*)value, memtype) );
    }

    if(IS_RECVAR(varp))
    {
        status = NCvnrecs(nc3, *start + *edges);
        if(status != NC_NOERR)
            return status;

        if(varp->ndims == 1
            && nc3->recsize <= varp->len)
        {
            /* one dimensional && the only record variable  */
            return( writeNCv(nc3, varp, start, *edges, (void*)value, memtype) );
        }
    }

    /*
     * find max contiguous
     *   and accumulate max count for a single io operation
     */
    ii = NCiocount(nc3, varp, edges, &iocount);

    if(ii == -1)
    {
        return( writeNCv(nc3, varp, start, iocount, (void*)value, memtype) );
    }

    assert(ii >= 0);

    { /* inline */
    ALLOC_ONSTACK(coord, size_t, varp->ndims);
    ALLOC_ONSTACK(upper, size_t, varp->ndims);
    const size_t index = ii;

    /* copy in starting indices */
    (void) memcpy(coord, start, varp->ndims * sizeof(size_t));

    /* set up in maximum indices */
    set_upper(upper, start, edges, &upper[varp->ndims]);

    /* ripple counter */
    while(*coord < *upper)
    {
        const int lstatus = writeNCv(nc3, varp, coord, iocount, (void*)value, memtype);
        if(lstatus != NC_NOERR)
        {
            if(lstatus != NC_ERANGE)
            {
                status = lstatus;
                /* fatal for the loop */
                break;
            }
            /* else NC_ERANGE, not fatal for the loop */
            if(status == NC_NOERR)
                status = lstatus;
        }
        value += (iocount * memtypelen);
        odo1(start, upper, coord, &upper[index], &coord[index]);
    }

    FREE_ONSTACK(upper);
    FREE_ONSTACK(coord);
    } /* end inline */

    return status;
}
