/*
 * @(#)DefaultAnalysisMetaData.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.module;

import net.sourceforge.groboutils.codecoverage.v2.IAnalysisMetaData;


/**
 * Contains data necessary for storing the meta-data associated with a specific
 * marked bytecode instruction.
 * <P>
 * There is an optional "weight" value which can associate a number from
 * -128 to 127 for this particular instruction.  This will create a weighted
 * coverage value to indicate on each summary level how important it is
 * for this particular bytecode to be executed.  If the analysis module doesn't
 * use weights, then this should return the same value for all instructions.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:51:28 $
 * @since     December 15, 2002
 */
public class DefaultAnalysisMetaData implements IAnalysisMetaData
{
    private String covered;
    private String notCovered;
    private byte weight;
    
    
    public DefaultAnalysisMetaData( String c, String nc, byte w )
    {
        if (c == null || nc == null)
        {
            throw new IllegalArgumentException( "No null args." );
        }
        this.covered = c;
        this.notCovered = nc;
        this.weight = w;
    }
    
    
    /**
     * Returns the formatted, localized text for a report on this instruction
     * if it was covered during the runtime execution.
     *
     * @return formatted, localized, human-readable report
     */
    public String getCoveredFormattedText()
    {
        return this.covered;
    }
    
    
    /**
     * Returns the formatted, localized text for a report on this instruction
     * if it was <em>not</em> covered during the runtime execution.
     *
     * @return formatted, localized, human-readable report
     */
    public String getNotCoveredFormattedText()
    {
        return this.notCovered;
    }
    
    
    /**
     * Returns any value in the range of a <tt>byte</tt> that assigns an
     * importance "weight" to this instruction.  If weights are not used
     * by the analysis module, then this needs to return the same value
     * for every instruction.
     *
     * @return an instruction weight value.
     */
    public byte getInstructionWeight()
    {
        return this.weight;
    }
}

