package net.noderunner.exml;

interface Stack<T> {
	/**
	 * Returns and removes the last item <code>push</code>ed.
	 * @throws NoSuchElementException if no elements are in the
	 * collection 
	 */
	T pop();
	/**
	 * Returns the last item <code>push</code>ed.
	 * @throws NoSuchElementException if no elements are in the
	 * collection 
	 */
	T peek();
	/**
	 * Returns the number of elements on the stack.
	 */
	int size();
	/**
	 * Adds an item to the top of the stack.
	 * This object can be null.
	 * @param obj object to add
	 */
	void push(T obj);
}

