/*
  Copyright:    © 2018 SIL International.
  Description:  API declarations for modifier keys, handy access masks and
                Keyman VKEY names.  These follow the same keytop->code
                associations as the Windows API. This is a separate header to
                maintain readability of the primary API header.
  Create Date:  17 Oct 2018
  Authors:      Tim Eves (TSE)
  History:      17 Oct 2018 - TSE - Moved & refactored km_kbp_modifier_state
                                    from keyboardprocessor.h.
                                  - Added VKey and mask definitions.
                 6 Oct 2018 - TSE - Move into keyman folder.

*/
enum km_kbp_modifier_state {
  KM_KBP_MODIFIER_LCTRL       = 1 << 0,
  KM_KBP_MODIFIER_RCTRL       = 1 << 1,
  KM_KBP_MODIFIER_LALT        = 1 << 2,
  KM_KBP_MODIFIER_RALT        = 1 << 3,
  KM_KBP_MODIFIER_SHIFT       = 1 << 4,
  KM_KBP_MODIFIER_CTRL        = 1 << 5,
  KM_KBP_MODIFIER_ALT         = 1 << 6
  /*
    KM_KBP_MODIFIER_CAPS        = 1 << 7,
    KM_KBP_MODIFIER_NOCAPS      = 1 << 8,
    KM_KBP_MODIFIER_NUMLOCK     = 1 << 9,
    KM_KBP_MODIFIER_NONUMLOCK   = 1 << 10,
    KM_KBP_MODIFIER_SCROLLOCK   = 1 << 11,
    KM_KBP_MODIFIER_NOSCROLLOCK = 1 << 12,
    KM_KBP_MODIFIER_VIRTUALKEY  = 1 << 13,
  */
};


enum km_kbp_modifier_mask {
  KM_KBP_MODIFIER_MASK_ALL         = 0x7f,
  KM_KBP_MODIFIER_MASK_ALT_GR_SIM  = KM_KBP_MODIFIER_LCTRL|KM_KBP_MODIFIER_LALT,
  KM_KBP_MODIFIER_MASK_CHIRAL      = 0x1f,
  KM_KBP_MODIFIER_MASK_IS_CHIRAL   = 0x0f,
  KM_KBP_MODIFIER_MASK_NON_CHIRAL  = 0x7f
/*  KM_KBP_MODIFIER_MASK_CAPS        = 0x0300,
  KM_KBP_MODIFIER_MASK_NUMLOCK     = 0x0C00,
  KM_KBP_MODIFIER_MASK_SCROLLLOCK  = 0x3000,*/
};

// These are Windows API VKEYs, using Keyman VKEY names.
enum km_kpb_virtual_key {
  KM_KBP_VKEY__00,
  KM_KBP_VKEY_LBUTTON,
  KM_KBP_VKEY_RBUTTON,
  KM_KBP_VKEY_CANCEL,
  KM_KBP_VKEY_MBUTTON,
  KM_KBP_VKEY__05,
  KM_KBP_VKEY__06,
  KM_KBP_VKEY__07,
  KM_KBP_VKEY_BKSP,
  KM_KBP_VKEY_TAB,
  KM_KBP_VKEY__0A,
  KM_KBP_VKEY__0B,
  KM_KBP_VKEY_KP5,
  KM_KBP_VKEY_ENTER,
  KM_KBP_VKEY__0E,
  KM_KBP_VKEY__0F,
  KM_KBP_VKEY_SHIFT,
  KM_KBP_VKEY_CONTROL,
  KM_KBP_VKEY_ALT,
  KM_KBP_VKEY_PAUSE,
  KM_KBP_VKEY_CAPS,
  KM_KBP_VKEY__15,
  KM_KBP_VKEY__16,
  KM_KBP_VKEY__17,
  KM_KBP_VKEY__18,
  KM_KBP_VKEY__19,
  KM_KBP_VKEY__1A,
  KM_KBP_VKEY_ESC,
  KM_KBP_VKEY__1C,
  KM_KBP_VKEY__1D,
  KM_KBP_VKEY__1E,
  KM_KBP_VKEY__1F,
  KM_KBP_VKEY_SPACE,
  KM_KBP_VKEY_PGUP,
  KM_KBP_VKEY_PGDN,
  KM_KBP_VKEY_END,
  KM_KBP_VKEY_HOME,
  KM_KBP_VKEY_LEFT,
  KM_KBP_VKEY_UP,
  KM_KBP_VKEY_RIGHT,
  KM_KBP_VKEY_DOWN,
  KM_KBP_VKEY_SEL,
  KM_KBP_VKEY_PRINT,
  KM_KBP_VKEY_EXEC,
  KM_KBP_VKEY_PRTSCN,
  KM_KBP_VKEY_INS,
  KM_KBP_VKEY_DEL,
  KM_KBP_VKEY_HELP,
  KM_KBP_VKEY_0,
  KM_KBP_VKEY_1,
  KM_KBP_VKEY_2,
  KM_KBP_VKEY_3,
  KM_KBP_VKEY_4,
  KM_KBP_VKEY_5,
  KM_KBP_VKEY_6,
  KM_KBP_VKEY_7,
  KM_KBP_VKEY_8,
  KM_KBP_VKEY_9,
  KM_KBP_VKEY__3A,
  KM_KBP_VKEY__3B,
  KM_KBP_VKEY__3C,
  KM_KBP_VKEY__3D,
  KM_KBP_VKEY__3E,
  KM_KBP_VKEY__3F,
  KM_KBP_VKEY__40,
  KM_KBP_VKEY_A,
  KM_KBP_VKEY_B,
  KM_KBP_VKEY_C,
  KM_KBP_VKEY_D,
  KM_KBP_VKEY_E,
  KM_KBP_VKEY_F,
  KM_KBP_VKEY_G,
  KM_KBP_VKEY_H,
  KM_KBP_VKEY_I,
  KM_KBP_VKEY_J,
  KM_KBP_VKEY_K,
  KM_KBP_VKEY_L,
  KM_KBP_VKEY_M,
  KM_KBP_VKEY_N,
  KM_KBP_VKEY_O,
  KM_KBP_VKEY_P,
  KM_KBP_VKEY_Q,
  KM_KBP_VKEY_R,
  KM_KBP_VKEY_S,
  KM_KBP_VKEY_T,
  KM_KBP_VKEY_U,
  KM_KBP_VKEY_V,
  KM_KBP_VKEY_W,
  KM_KBP_VKEY_X,
  KM_KBP_VKEY_Y,
  KM_KBP_VKEY_Z,
  KM_KBP_VKEY__5B,
  KM_KBP_VKEY__5C,
  KM_KBP_VKEY__5D,
  KM_KBP_VKEY__5E,
  KM_KBP_VKEY__5F,
  KM_KBP_VKEY_NP0,
  KM_KBP_VKEY_NP1,
  KM_KBP_VKEY_NP2,
  KM_KBP_VKEY_NP3,
  KM_KBP_VKEY_NP4,
  KM_KBP_VKEY_NP5,
  KM_KBP_VKEY_NP6,
  KM_KBP_VKEY_NP7,
  KM_KBP_VKEY_NP8,
  KM_KBP_VKEY_NP9,
  KM_KBP_VKEY_NPSTAR,
  KM_KBP_VKEY_NPPLUS,
  KM_KBP_VKEY_SEPARATOR,
  KM_KBP_VKEY_NPMINUS,
  KM_KBP_VKEY_NPDOT,
  KM_KBP_VKEY_NPSLASH,
  KM_KBP_VKEY_F1,
  KM_KBP_VKEY_F2,
  KM_KBP_VKEY_F3,
  KM_KBP_VKEY_F4,
  KM_KBP_VKEY_F5,
  KM_KBP_VKEY_F6,
  KM_KBP_VKEY_F7,
  KM_KBP_VKEY_F8,
  KM_KBP_VKEY_F9,
  KM_KBP_VKEY_F10,
  KM_KBP_VKEY_F11,
  KM_KBP_VKEY_F12,
  KM_KBP_VKEY_F13,
  KM_KBP_VKEY_F14,
  KM_KBP_VKEY_F15,
  KM_KBP_VKEY_F16,
  KM_KBP_VKEY_F17,
  KM_KBP_VKEY_F18,
  KM_KBP_VKEY_F19,
  KM_KBP_VKEY_F20,
  KM_KBP_VKEY_F21,
  KM_KBP_VKEY_F22,
  KM_KBP_VKEY_F23,
  KM_KBP_VKEY_F24,
  KM_KBP_VKEY__88,
  KM_KBP_VKEY__89,
  KM_KBP_VKEY__8A,
  KM_KBP_VKEY__8B,
  KM_KBP_VKEY__8C,
  KM_KBP_VKEY__8D,
  KM_KBP_VKEY__8E,
  KM_KBP_VKEY__8F,
  KM_KBP_VKEY_NUMLOCK,
  KM_KBP_VKEY_SCROLL,
  KM_KBP_VKEY__92,
  KM_KBP_VKEY__93,
  KM_KBP_VKEY__94,
  KM_KBP_VKEY__95,
  KM_KBP_VKEY__96,
  KM_KBP_VKEY__97,
  KM_KBP_VKEY__98,
  KM_KBP_VKEY__99,
  KM_KBP_VKEY__9A,
  KM_KBP_VKEY__9B,
  KM_KBP_VKEY__9C,
  KM_KBP_VKEY__9D,
  KM_KBP_VKEY__9E,
  KM_KBP_VKEY__9F,
  KM_KBP_VKEY__A0,
  KM_KBP_VKEY__A1,
  KM_KBP_VKEY__A2,
  KM_KBP_VKEY__A3,
  KM_KBP_VKEY__A4,
  KM_KBP_VKEY__A5,
  KM_KBP_VKEY__A6,
  KM_KBP_VKEY__A7,
  KM_KBP_VKEY__A8,
  KM_KBP_VKEY__A9,
  KM_KBP_VKEY__AA,
  KM_KBP_VKEY__AB,
  KM_KBP_VKEY__AC,
  KM_KBP_VKEY__AD,
  KM_KBP_VKEY__AE,
  KM_KBP_VKEY__AF,
  KM_KBP_VKEY__B0,
  KM_KBP_VKEY__B1,
  KM_KBP_VKEY__B2,
  KM_KBP_VKEY__B3,
  KM_KBP_VKEY__B4,
  KM_KBP_VKEY__B5,
  KM_KBP_VKEY__B6,
  KM_KBP_VKEY__B7,
  KM_KBP_VKEY__B8,
  KM_KBP_VKEY__B9,
  KM_KBP_VKEY_COLON,
  KM_KBP_VKEY_EQUAL,
  KM_KBP_VKEY_COMMA,
  KM_KBP_VKEY_HYPHEN,
  KM_KBP_VKEY_PERIOD,
  KM_KBP_VKEY_SLASH,
  KM_KBP_VKEY_BKQUOTE,
  KM_KBP_VKEY__C1,
  KM_KBP_VKEY__C2,
  KM_KBP_VKEY__C3,
  KM_KBP_VKEY__C4,
  KM_KBP_VKEY__C5,
  KM_KBP_VKEY__C6,
  KM_KBP_VKEY__C7,
  KM_KBP_VKEY__C8,
  KM_KBP_VKEY__C9,
  KM_KBP_VKEY__CA,
  KM_KBP_VKEY__CB,
  KM_KBP_VKEY__CC,
  KM_KBP_VKEY__CD,
  KM_KBP_VKEY__CE,
  KM_KBP_VKEY__CF,
  KM_KBP_VKEY__D0,
  KM_KBP_VKEY__D1,
  KM_KBP_VKEY__D2,
  KM_KBP_VKEY__D3,
  KM_KBP_VKEY__D4,
  KM_KBP_VKEY__D5,
  KM_KBP_VKEY__D6,
  KM_KBP_VKEY__D7,
  KM_KBP_VKEY__D8,
  KM_KBP_VKEY__D9,
  KM_KBP_VKEY__DA,
  KM_KBP_VKEY_LBRKT,
  KM_KBP_VKEY_BKSLASH,
  KM_KBP_VKEY_RBRKT,
  KM_KBP_VKEY_QUOTE,
  KM_KBP_VKEY_oDF,
  KM_KBP_VKEY_oE0,
  KM_KBP_VKEY_oE1,
  KM_KBP_VKEY_oE2,  // 102nd key on European layouts
  KM_KBP_VKEY_oE3,
  KM_KBP_VKEY_oE4,
  KM_KBP_VKEY__E5,
  KM_KBP_VKEY_oE6,
  KM_KBP_VKEY__E7,
  KM_KBP_VKEY__E8,
  KM_KBP_VKEY_oE9,
  KM_KBP_VKEY_oEA,
  KM_KBP_VKEY_oEB,
  KM_KBP_VKEY_oEC,
  KM_KBP_VKEY_oED,
  KM_KBP_VKEY_oEE,
  KM_KBP_VKEY_oEF,
  KM_KBP_VKEY_oF0,
  KM_KBP_VKEY_oF1,
  KM_KBP_VKEY_oF2,
  KM_KBP_VKEY_oF3,
  KM_KBP_VKEY_oF4,
  KM_KBP_VKEY_oF5,
  KM_KBP_VKEY__F6,
  KM_KBP_VKEY__F7,
  KM_KBP_VKEY__F8,
  KM_KBP_VKEY__F9,
  KM_KBP_VKEY__FA,
  KM_KBP_VKEY__FB,
  KM_KBP_VKEY__FC,
  KM_KBP_VKEY__FD,
  KM_KBP_VKEY__FE,
  KM_KBP_VKEY__FF,
};
