//*****************************************************************************
//                               SimnGnuCap.hpp                               *
//                              ----------------                              *
// Description : A class to contain the values required to define a GNU-Cap   *
//               simulation.                                                  *
// Started     : 07/05/2008                                                   *
// Last Update : 26/05/2011                                                   *
// Copyright   : (C) 2008 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef SIMNGNUCAP_HPP
#define SIMNGNUCAP_HPP

// System Includes

#include <cfloat>

// wxWidgets Includes

#include <wx/wx.h>

// Application Includes

#include "base/SimnBase.hpp"
#include "gnucap/commands/CmdGnuCapOPT.hpp"
#include "gnucap/commands/CmdGnuCapOP.hpp"
#include "gnucap/commands/CmdGnuCapDC.hpp"
#include "gnucap/commands/CmdGnuCapAC.hpp"
#include "gnucap/commands/CmdGnuCapTR.hpp"
#include "gnucap/commands/CmdGnuCapFO.hpp"
#include "gnucap/commands/CmdGnuCapPR.hpp"
#include "gnucap/commands/CmdGnuCapGEN.hpp"
#include "netlist/SimnNgSpice.hpp"

struct SimnNgSpice;

// Local Constant Declarations


//*****************************************************************************

struct SimnGnuCap : public SimnBase
{
  public :

    // GNU-Cap simulation object attributes
    CmdGnuCapOPT  m_oCmdOPT;
    CmdGnuCapOP   m_oCmdOP;
    CmdGnuCapDC   m_oCmdDC;
    CmdGnuCapAC   m_oCmdAC;
    CmdGnuCapTR   m_oCmdTR;
    CmdGnuCapFO   m_oCmdFO;
    CmdGnuCapPR   m_oCmdPR;
    CmdGnuCapGEN  m_oCmdGEN;

  private :

    // Function to extract information from the circuit description
    virtual  bool  bLoadSimEng ( void );
    virtual  bool  bLoadSimCmds( void );

    // Functions to save the circuit description to file
    virtual  bool  bSaveSimCmds( void ) { return( FALSE ); } // ??? 26/05/2011 Not yet implemented

  public :

             SimnGnuCap( void );
            ~SimnGnuCap( );

    virtual  bool  bClear    ( void );
    virtual  bool  bClrCmds  ( void );
    virtual  bool  bClrTstPts( void );

    virtual  bool  bValidate( void );

    virtual  bool  bLoadFile( const wxString & rosFName=wxT("") );
    virtual  bool  bSaveFile( const wxString & rosFName=wxT("") );

    virtual  bool  bSetAnaType( eCmdType eAnaType )
                                { return( m_oCmdPR.bSetAnaType( eAnaType ) ); }

    virtual  bool  bAddTstNode( const wxString & rosName );
    virtual  bool  bAddTstCpnt( const wxString & rosName );

    virtual        eCmdType           eGetAnaType ( void ) const
                                             { return( m_oCmdPR.m_eAnaType ); }
    virtual  const wxArrayString & rosaGetTstNodes( void )
                                             { return( m_oCmdPR.m_osaNodes ); }
    virtual  const wxArrayString & rosaGetTstCpnts( void )
                                             { return( m_oCmdPR.m_osaCpnts ); }

    SimnGnuCap & operator = ( const SimnNgSpice & roSimn );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // SIMNGNUCAP_HPP
