# - Find gpstk library
# Find the native gpstk includes and library
# This module defines
#  GPSTK_INCLUDE_DIR, where to find tiff.h, etc.
#  GPSTK_LIBRARIES, libraries to link against to use GPSTK.
#  GPSTK_FOUND, If false, do not try to use GPSTK.
# also defined, but not for general use are
#  GPSTK_LIBRARY, where to find the GPSTK library.

FIND_PATH(GPSTK_INCLUDE_DIR gpstk/Matrix.hpp)
FIND_PATH(GEOMATICS_INCLUDE_DIR gpstk/random.hpp)
FIND_PATH(PROCFRAME_INCLUDE_DIR gpstk/SolverWMS.hpp)
FIND_PATH(VDRAW_INCLUDE_DIR gpstk/Layout.hpp)
FIND_PATH(VPLOT_INCLUDE_DIR gpstk/ScatterPlot.hpp)
FIND_PATH(RXIO_INCLUDE_DIR gpstk/EphReader.hpp)

SET(GPSTK_NAMES ${GPSTK_NAMES} gpstk libgpstk)
FIND_LIBRARY(GPSTK_LIBRARY NAMES ${GPSTK_NAMES} )

SET(GEOMATICS_NAMES ${GEOMATICS_NAMES} geomatics libgeomatics)
FIND_LIBRARY(GEOMATICS_LIBRARY NAMES ${GEOMATICS_NAMES} )

SET(PROCFRAME_NAMES ${PROCFRAME_NAMES} procframe libprocframe)
FIND_LIBRARY(PROCFRAME_LIBRARY NAMES ${PROCFRAME_NAMES} )

SET(VDRAW_NAMES ${VDRAW_NAMES} vdraw libvdraw)
FIND_LIBRARY(VDRAW_LIBRARY NAMES ${VDRAW_NAMES} )

SET(VPLOT_NAMES ${VPLOT_NAMES} vplot libvplot)
FIND_LIBRARY(VPLOT_LIBRARY NAMES ${VPLOT_NAMES} )

SET(RXIO_NAMES ${RXIO_NAMES} rxio librxio)
FIND_LIBRARY(RXIO_LIBRARY NAMES ${RXIO_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set GPSTK_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(GPSTK  DEFAULT_MSG  GPSTK_LIBRARY  GPSTK_INCLUDE_DIR)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(GEOMATICS  DEFAULT_MSG  GEOMATICS_LIBRARY  GEOMATICS_INCLUDE_DIR)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(PROCFRAME  DEFAULT_MSG  PROCFRAME_LIBRARY  PROCFRAME_INCLUDE_DIR)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(VDRAW  DEFAULT_MSG  VDRAW_LIBRARY  VDRAW_INCLUDE_DIR)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(VPLOT  DEFAULT_MSG  VPLOT_LIBRARY  VPLOT_INCLUDE_DIR)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(RXIO  DEFAULT_MSG  RXIO_LIBRARY  RXIO_INCLUDE_DIR)

IF(GPSTK_FOUND)
  SET( GPSTK_LIBRARIES ${GPSTK_LIBRARY} )
ENDIF(GPSTK_FOUND)

IF(GEOMATICS_FOUND)
  SET( GEOMATICS_LIBRARIES ${GEOMATICS_LIBRARY} )
ENDIF(GEOMATICS_FOUND)

IF(PROCFRAME_FOUND)
  SET( PROCFRAME_LIBRARIES ${PROCFRAME_LIBRARY} )
ENDIF(PROCFRAME_FOUND)

IF(VDRAW_FOUND)
  SET( VDRAW_LIBRARIES ${VDRAW_LIBRARY} )
ENDIF(VDRAW_FOUND)

IF(VPLOT_FOUND)
  SET( VPLOT_LIBRARIES ${VPLOT_LIBRARY} )
ENDIF(VPLOT_FOUND)

IF(RXIO_FOUND)
  SET( RXIO_LIBRARIES ${RXIO_LIBRARY} )
ENDIF(RXIO_FOUND)

MARK_AS_ADVANCED(GPSTK_INCLUDE_DIR GPSTK_LIBRARY)

MARK_AS_ADVANCED(GEOMATICS_INCLUDE_DIR GEOMATICS_LIBRARY)

MARK_AS_ADVANCED(PROCFRAME_INCLUDE_DIR PROCFRAME_LIBRARY)

MARK_AS_ADVANCED(VDRAW_INCLUDE_DIR VDRAW_LIBRARY)

MARK_AS_ADVANCED(VPLOT_INCLUDE_DIR VPLOT_LIBRARY)

MARK_AS_ADVANCED(RXIO_INCLUDE_DIR RXIO_LIBRARY)


