# +========================================================================+
# || Copyright (C) 2009 Christian Kuelker                                 ||
# ||                                                                      ||
# || License: GNU General Public License - GNU GPL - version 2            ||
# ||          or (at your opinion) any later version                      ||
# +========================================================================+
#  ID:       $ID$
#  Revision: $Revision$
#  Head URL: $Head URL$
#  Date:     $Date$
#  Source:   $Source$

package CipUX::CAT::Web::Module::Chooser;

use warnings;
use strict;
use Log::Log4perl qw(get_logger :levels);
use base qw( CipUX::CAT::Web::Module CipUX::CAT::Web::L10N);

{

    use version; our $VERSION = qv('3.4.0.3');
    use re 'taint';    # Keep data captured by parens tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safer

    # CONST
    Readonly::Scalar my $EMPTY_STRING => q{};
    Readonly::Array my @MODULE        => qw(language.cgi theme.cgi);

    # OBJECT
    # used in BUILD/new to pass entity from Comtroller.pm
    my %name_of : ATTR( init_arg => 'name' :default('theme') );

    # METHOD
    sub register {

        my $self = shift;

        my $c = __PACKAGE__;    # module class name
        foreach my $m (@MODULE) {
            $self->set_module_name_register( { class => $c, name => $m } );
            my $c_ar = $self->module_cfg( $self, $m );
            $self->set_module_cfg_register( { cfg_ar => $c_ar, name => $m } );
        }

        return 1;

    }

    sub module_cfg : CUMULATIVE(BASE FIRST) {

        my $self   = shift;
        my $module = shift;
        my $name = $self;
	        if ( defined $module ) { $name = $module; }
		        $name =~ s{\.cgi}{}smx;


        #my $name = $module;
        #$name =~ s{\.cgi}{}smx;

        my %desc = (
            'theme'    => 'Choose a theme',
            'language' => 'Choose a language',
        );
        my %ldesc = (
            'theme'    => 'This module let you chosse your theme.',
            'language' => 'This module let you chosse your language.',
        );
        my $module_hr = {};
        $module_hr->{cipuxName}             = $name;
        $module_hr->{cipuxTemplateDir}      = 'chooser';
        $module_hr->{cipuxIcon}             = 'chooser.png';
        $module_hr->{cipuxDescription}      = $ldesc{$name};
        $module_hr->{cipuxShortDescription} = $desc{$name};
        $module_hr->{cipuxTask}             = 'NULL';
        return [$module_hr];
    }

    sub module {

        my ( $self, $arg_r ) = @_;

        my $cgi = $arg_r->{cgi};
        my $lh
            = ( exists $arg_r->{lh_obj} )
            ? $arg_r->{lh_obj}
            : $self->perr('lh_obj');
        my $cfg_hr
            = ( exists $arg_r->{cfg_hr} )
            ? $self->h( $arg_r->{cfg_hr} )
            : $self->perr('cfg_hr');
        my $c_hr
            = ( exists $arg_r->{c_hr} )
            ? $self->h( $arg_r->{c_hr} )
            : $self->perr('c_hr');

        my $l = get_logger(__PACKAGE__);
        my $name   = $name_of{ ident $self};
        $l->debug("name [$name]");

        # chooser_hr could have for example this keys and values:
        # $chooser_hr->{field_ar}  | ['cat_theme'],
        # $chooser_hr->{submit_ar} | ['change'],
        # $chooser_hr->{name}      | 'cat_theme'
        # $chooser_hr->{value}     | 'theme' | 'Berlin'
        # $chooser_hr->{options_hr}| {default=>'default', Berlin=>'Berlin'}
        # $chooser_hr->{CHOOSER_TITLE} | "Chooser"
        # $chooser_hr->{CHOOSER_LABEL} | "Please choose a value"
        my $chooser_hr = {};
        if ( $name eq 'theme' ) {    # its a theme chooser
            my $theme_hr
                = $self->i18n_theme( { lh_obj => $lh, cfg_hr => $cfg_hr } );
            $chooser_hr = {
                field_ar  => ['cat_theme'],
                submit_ar => [ $lh->maketext('change') ],

                name          => 'cat_theme',
                value         => $cfg_hr->{base}->{catweb_login_theme},
                options_hr    => $theme_hr,
                CHOOSER_TITLE => $lh->maketext('theme'),
                CHOOSER_LABEL => $lh->maketext('Please choose a theme'),
            };
        }
        if ( $name eq 'language' ) {    # is a language chooser
            my $locale_hr
                = $self->i18n_locale( { lh_obj => $lh, cfg_hr => $cfg_hr } );
            $chooser_hr = {
                field_ar      => ['cat_locale'],
                submit_ar     => [ $lh->maketext('change') ],
                name          => 'cat_locale',
                value         => $cfg_hr->{base}->{catweb_login_language},
                options_hr    => $locale_hr,
                CHOOSER_TITLE => $lh->maketext('Language'),
                CHOOSER_LABEL => $lh->maketext('Please choose a language'),
            };
        }
        my $path     = "tpl/$c_hr->{cat_theme}";
        my $style    = $path . '/form.css';
        my $template = $path . '/chooser/index.html';

        my $form = CGI::FormBuilder->new(
            method     => 'post',
            fields     => $chooser_hr->{field_ar},
            submit     => $chooser_hr->{submit_ar},
            keepextra  => 1,
            debug      => 0,
            reset      => 0,
            sticky     => 0,
            stylesheet => $style,
            template   => {
                type     => 'TT2',
                template => $template,
                variable => 'form',
                data     => {
                    MODULE        => $name .'.cgi',
                    NAME          => $name,
                    CHOOSER_NAME  => $chooser_hr->{name},
                    CHOOSER_TITLE => $chooser_hr->{CHOOSER_TITLE},
                    CHOOSER_LABEL => $chooser_hr->{CHOOSER_LABEL},
                    lh            => $lh,
                },
            }
        );

        # use this if, you want that it jumps not to index.cgi
        # (however this could completely deleted and has the same effect:
        # it jumps to index.cgi - where else should it jump?)
        $form->field(
            name  => 'module',
            type  => 'hidden',
            value => "index.cgi"
        );

        $form->field(
            name       => $chooser_hr->{name},
            type       => 'select',
            selectname => 0,
            size       => 1,
            value      => $chooser_hr->{value},
            options    => $chooser_hr->{options_hr},
        );

        return {

            #   cookie_hr => {
            #       cat_login   => $self->$login_of{ ident $self},
            #       cat_session => $session_of{ ident $self},
            #       cat_locale  => $locale_of{ ident $self},
            #       cat_theme   => $theme_of{ ident $self},
            #   },
            layout    => "$path/chooser/layout.html",
            layout_ar => [
                { begin_html => 1, },
                {
                    body_ar =>
                        [ $lh->maketext( $chooser_hr->{CHOOSER_TITLE} ) ]
                },

                { formbuilder_hr => { form => $form }, },
                {
                    footer_hr =>
                        { show_index_back => 1, show_script_back => 0 },
                },
                { end_html => 1, },
            ],

        };
    }

}

1;

__END__

