/*
    Sega/Stern Whitestar
*/


#include "emu.h"
#include "video/mc6845.h"
#include "audio/decobsmt.h"
#include "video/decodmd2.h"
#include "rendlay.h"

class whitestar_state : public driver_device
{
public:
	whitestar_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
		m_maincpu(*this, "maincpu"),
		m_decobsmt(*this, "decobsmt"),
		m_decodmd(*this, "decodmd")
	{ }

	required_device<cpu_device> m_maincpu;
	//required_device<cpu_device> m_dmdcpu;
	//required_device<mc6845_device> m_mc6845;
	required_device<decobsmt_device> m_decobsmt;
	required_device<decodmd_type2_device> m_decodmd;

	UINT8 m_dmd_latch;
	UINT8 m_dmd_ctrl;
	UINT8 m_dmd_status;
	UINT8 m_dmd_busy;

	DECLARE_WRITE8_MEMBER(dmd_latch_w);
	DECLARE_READ8_MEMBER(dmd_latch_r);
	DECLARE_WRITE8_MEMBER(dmd_ctrl_w);
	DECLARE_READ8_MEMBER(dmd_ctrl_r);
	DECLARE_READ8_MEMBER(dmd_status_r);
	DECLARE_WRITE8_MEMBER(dmd_status_w);

	DECLARE_WRITE8_MEMBER(bank_w);
	DECLARE_WRITE8_MEMBER(dmd_bank_w);
	DECLARE_WRITE8_MEMBER(dmddata_w);

	DECLARE_READ8_MEMBER(dips_r);
	DECLARE_READ8_MEMBER(switch_r);
	DECLARE_WRITE8_MEMBER(switch_w);
	DECLARE_READ8_MEMBER(dedicated_switch_r);
	DECLARE_DRIVER_INIT(whitestar);
	virtual void machine_reset();
	INTERRUPT_GEN_MEMBER(whitestar_firq_interrupt);
};

static INPUT_PORTS_START( whitestar )
/*-- Dedicated Switches --*/
// Note: active low
// D0 - DED #1 - Left Flipper
// D1 - DED #2 - Left Flipper EOS
// D2 - DED #3 - Right Flipper
// D3 - DED #4 - Right Flipper EOS
// D4 - DED #5 - Not Used (Upper Flipper on some games!)
// D5 - DED #6 - Volume (Red Button)
// D6 - DED #7 - Service Credit (Green Button)
// D7 - DED #8 - Begin Test (Black Button)
	PORT_START("DEDICATED")
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_START("DSW0")
	PORT_BIT( 0xff, IP_ACTIVE_LOW, IPT_UNUSED )
INPUT_PORTS_END

static ADDRESS_MAP_START( whitestar_map, AS_PROGRAM, 8, whitestar_state )
	AM_RANGE(0x0000, 0x1fff) AM_RAM
	AM_RANGE(0x3000, 0x3000) AM_READ_PORT("DEDICATED")
	AM_RANGE(0x3100, 0x3100) AM_READ_PORT("DSW0")
	AM_RANGE(0x3200, 0x3200) AM_WRITE(bank_w)
	AM_RANGE(0x3300, 0x3300) AM_WRITE(switch_w)
	AM_RANGE(0x3400, 0x3400) AM_READ(switch_r)
	AM_RANGE(0x3600, 0x3600) AM_WRITE(dmddata_w)
	AM_RANGE(0x3601, 0x3601) AM_DEVREADWRITE("decodmd",decodmd_type2_device,ctrl_r, ctrl_w)
	AM_RANGE(0x3700, 0x3700) AM_DEVREAD("decodmd",decodmd_type2_device,busy_r)
	AM_RANGE(0x3800, 0x3800) AM_DEVWRITE(DECOBSMT_TAG, decobsmt_device, bsmt_comms_w)
	AM_RANGE(0x4000, 0x7fff) AM_ROMBANK("bank1")
	AM_RANGE(0x8000, 0xffff) AM_ROM AM_REGION("user1", 0x18000)
ADDRESS_MAP_END

READ8_MEMBER(whitestar_state::switch_r)
{
	return 0;
}

WRITE8_MEMBER(whitestar_state::switch_w)
{
}

WRITE8_MEMBER(whitestar_state::bank_w)
{
	membank("bank1")->set_base(memregion("user1")->base() + (data & 0x1f) * 0x4000);
}

// Whitestar automatically pulses the DMD IRQ line?  DE hardware doesn't do that...
WRITE8_MEMBER(whitestar_state::dmddata_w)
{
	m_decodmd->data_w(space,offset,data);
	m_decodmd->ctrl_w(space,0,1);
	m_decodmd->ctrl_w(space,0,0);
}
void whitestar_state::machine_reset()
{
	membank("bank1")->set_base(memregion("user1")->base());
}

DRIVER_INIT_MEMBER(whitestar_state,whitestar)
{
}

// the appropriate device is passed in, so we can share this routine
INTERRUPT_GEN_MEMBER(whitestar_state::whitestar_firq_interrupt)
{
	device.execute().set_input_line(M6809_FIRQ_LINE, HOLD_LINE);
}

static MACHINE_CONFIG_START( whitestar, whitestar_state )
	/* basic machine hardware */
	MCFG_CPU_ADD("maincpu", M6809, 2000000)
	MCFG_CPU_PROGRAM_MAP(whitestar_map)
	MCFG_CPU_PERIODIC_INT_DRIVER(whitestar_state, whitestar_firq_interrupt,  976) // value taken from PinMAME

	/* sound hardware */
	MCFG_DECOBSMT_ADD(DECOBSMT_TAG)

	MCFG_DECODMD_TYPE2_ADD("decodmd",":dmdcpu")
MACHINE_CONFIG_END

// 8Mbit ROMs are mapped oddly: the first 4Mbit of each of the ROMs goes in order u17, u21, u36, u37
// then the second 4Mbit of each of the ROMs in the same order starting at 0x200000
#define ROM_LOAD_SND_8M(name, start, checksums) \
	ROM_LOAD(name, start, 0x080000, checksums) \
	ROM_CONTINUE(0x200000+start, 0x080000)

/*-------------------------------------------------------------------
/ Apollo 13
/-------------------------------------------------------------------*/
ROM_START(apollo13)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apolcpu.501", 0x00000, 0x20000, CRC(5afb8801) SHA1(65608148817f487c384dd36c221138962f1d9824))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("a13dspa.500", 0x00000, 0x80000, CRC(bf8e3249) SHA1(5e04681901ca794feb970f5388cb355427cf9a9a))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apollo13.u7", 0x0000, 0x10000, CRC(e58a36b8) SHA1(ae60470a7b6c41cd40dbb7c0bea6f2f148f7b088))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("apollo13.u17", 0x000000, 0x80000, CRC(4e863aca) SHA1(264f9176a1abf758b7a894d83883330ef91b7388))
	ROM_LOAD("apollo13.u21", 0x080000, 0x80000, CRC(28169e37) SHA1(df5209d24187b546a4296fc4629c58bf729349d2))
	ROM_LOAD("apollo13.u36", 0x100000, 0x80000, CRC(cede5e0f) SHA1(fa3b5820ed58e57b3c6185d91e9aea28aebc28d7))
ROM_END

/*-------------------------------------------------------------------
/ Austin Powers (3.01)
/-------------------------------------------------------------------*/
ROM_START(aust301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.301", 0x00000, 0x20000, CRC(868d1f38) SHA1(df08b48437f88e66c4caa80602c28a2223f180b9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-a.300", 0x00000, 0x80000, CRC(ecf2c3bb) SHA1(952a7873067b8c70043a38a39a8f65089103336b)) // ver 3.00
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END

/*-------------------------------------------------------------------
/ Austin Powers (3.00)
/-------------------------------------------------------------------*/
ROM_START(aust300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.300", 0x00000, 0x20000, CRC(a06b2b03) SHA1(4c36212b43fdc497773425e586f64c3064e7000c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-a.300", 0x00000, 0x80000, CRC(ecf2c3bb) SHA1(952a7873067b8c70043a38a39a8f65089103336b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END

/*-------------------------------------------------------------------
/ Austin Powers (2.01)
/-------------------------------------------------------------------*/
ROM_START(aust201)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.201", 0x00000, 0x20000, CRC(a4ddcdca) SHA1(c1eb1ae3b9c9b10410d107165f3bddaa514c2113))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-a.200", 0x00000, 0x80000, CRC(f3ca7fca) SHA1(b6b702ad7af75b3010a280adb99e4ee484a03242))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END

/*-------------------------------------------------------------------
/ Austin Powers (3.02)
/-------------------------------------------------------------------*/
ROM_START(austin)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.302", 0x00000, 0x20000, CRC(2920b59b) SHA1(280cebbb39980fbcfd91fc1cf87a40ad926ffecb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-a.300", 0x00000, 0x80000, CRC(ecf2c3bb) SHA1(952a7873067b8c70043a38a39a8f65089103336b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END
ROM_START(austnew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.302", 0x00000, 0x20000, CRC(2920b59b) SHA1(280cebbb39980fbcfd91fc1cf87a40ad926ffecb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-a.300", 0x00000, 0x80000, CRC(ecf2c3bb) SHA1(952a7873067b8c70043a38a39a8f65089103336b))
	ROM_REGION32_LE(0x600000, "cpu2", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END
ROM_START(austinf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.302", 0x00000, 0x20000, CRC(2920b59b) SHA1(280cebbb39980fbcfd91fc1cf87a40ad926ffecb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-f.300", 0x00000, 0x80000, CRC(1aeaa83e) SHA1(8a749c0fbf7b03441780c2158e63d4a87c8d0702))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END
ROM_START(austing)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.302", 0x00000, 0x20000, CRC(2920b59b) SHA1(280cebbb39980fbcfd91fc1cf87a40ad926ffecb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-g.300", 0x00000, 0x80000, CRC(28b91cc4) SHA1(037628c78955495f10a60cfc329232289417562e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END
ROM_START(austini)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("apcpu.302", 0x00000, 0x20000, CRC(2920b59b) SHA1(280cebbb39980fbcfd91fc1cf87a40ad926ffecb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("apdsp-i.300", 0x00000, 0x80000, CRC(8b1dd747) SHA1(b29d39a2fb464bd11f4bc5daeb35360126ddf45b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("apsndu7.100",0x0000,0x10000,CRC(d0e79d59) SHA1(7c3f1fa79ff193a976986339a551e3d03208550f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("apsndu17.100", 0x000000, CRC(c1e33fee) SHA1(5a3581584cc1a841d884de4628f7b65d8670f96a))
	ROM_LOAD_SND_8M("apsndu21.100", 0x080000, CRC(07c3e077) SHA1(d48020f7da400c3682035d537289ce9a30732d74))
	ROM_LOAD_SND_8M("apsndu36.100", 0x100000, CRC(f70f2828) SHA1(9efbed4f68c22eb26e9100afaca5ebe85a97b605))
	ROM_LOAD_SND_8M("apsndu37.100", 0x180000, CRC(ddf0144b) SHA1(c2a56703a41ee31841993d63385491259d5a13f8))
ROM_END

/*-------------------------------------------------------------------
/ Godzilla
/-------------------------------------------------------------------*/
ROM_START(godzillp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gdzcpu.205", 0x00000, 0x20000, CRC(0156c21c) SHA1(37dcbe84c54e1b8f279f78e7a11544040e98c0b3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("gzdspa.200", 0x00000, 0x80000, CRC(a254a01d) SHA1(e624a81437ab4d4b3c133baf47993facf6079f4b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("gdzu7.100", 0x0000, 0x10000, CRC(a0afe8b7) SHA1(33e4a824b26b58e8f963fa8a525a64f4779b45db))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("gdzu17.100", 0x000000, 0x80000, CRC(6bba69c8) SHA1(51341e188b4191eb1836349dfdd456163d464ad6))
	ROM_LOAD("gdzu21.100", 0x080000, 0x80000, CRC(db738958) SHA1(23082cf98bbcc6d356145414267da887a5ca9305))
	ROM_LOAD("gdzu36.100", 0x100000, 0x80000, CRC(e3f24234) SHA1(eb123200928221a647e10839ebb7f4628501c581))
	ROM_LOAD("gdzu37.100", 0x180000, 0x80000, CRC(2c1acb14) SHA1(4d710e09f5500da937932b4b01d862abb4a89e5a))
ROM_END

/*-------------------------------------------------------------------
/ Goldeneye
/-------------------------------------------------------------------*/
ROM_START(gldneye)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("bondcpu.404", 0x00000, 0x20000, CRC(5aa6ffcc) SHA1(0c8ffcfe008a650060c42d385e91addf44f5d88e))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("bondispa.400", 0x00000, 0x80000, CRC(9cc0c710) SHA1(3c6df97d881aed9d1d08cc2a5d0c4ec020295902))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("bondu7.bin", 0x0000, 0x10000, CRC(7581a349) SHA1(493236bdc52b601a08009f9b03d64b6047d52661))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("bondu17.bin", 0x000000, 0x80000, CRC(d9c56b9d) SHA1(df8cde0b63d6a8437a1cb239094547262c3f8774))
	ROM_LOAD("bondu21.bin", 0x080000, 0x80000, CRC(5be0f205) SHA1(aaef8f6ee6c8d5ebf08f90368061288adf850a18))
ROM_END

/*-------------------------------------------------------------------
/ Golden Cue
/-------------------------------------------------------------------*/
ROM_START(goldcue)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("gc_cpu.210", 0x00000, 0x20000, CRC(8447eaee) SHA1(dcca699508809d66dcb2887968c7628067927798))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("gc_disp.u12", 0x00000, 0x80000, CRC(87f74b9d) SHA1(e8610ba2409dc6c5070fd413597e3629851b6106))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("gc_sound.u7", 0x0000, 0x10000, CRC(8b559e39) SHA1(59c33615b53864cd542c8bd3be2ba18e91c57dfd))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("gc_sound.u17", 0x000000, 0x80000, CRC(28c39bae) SHA1(a11343a4043d8d5a8eaec383e1bb1f42016e33d2))
	ROM_LOAD("gc_sound.u21", 0x080000, 0x80000, CRC(d3f43a37) SHA1(e845370e75200570f828b8452453287b5f599276))
	ROM_LOAD("gc_sound.u36", 0x100000, 0x80000, CRC(81f27955) SHA1(eba4250898f6de96111232e49d965b78fc6ee2e2))
ROM_END

/*-------------------------------------------------------------------
/ Harley Davidson
/-------------------------------------------------------------------*/
ROM_START(harl_a13)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.103", 0x00000, 0x20000, CRC(2a812c75) SHA1(46e1f18e1c9992ca1823f7818b6d51c001f5a934))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispa.104", 0x00000, 0x80000, CRC(fc7c2924) SHA1(172fceb4d3221608f48a4abe4c4c5f3043834957))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_a10)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.103", 0x00000, 0x20000, CRC(2a812c75) SHA1(46e1f18e1c9992ca1823f7818b6d51c001f5a934))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispa.100", 0x00000, 0x80000, CRC(bdeac0fd) SHA1(5aa1392a13f3c632b660ea6cb3dee23327404d80))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_f13)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.103", 0x00000, 0x20000, CRC(2a812c75) SHA1(46e1f18e1c9992ca1823f7818b6d51c001f5a934))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispf.104", 0x00000, 0x80000, CRC(5f80436e) SHA1(e89e561807670118c3d9e623d4aec2321c774576))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_g13)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.103", 0x00000, 0x20000, CRC(2a812c75) SHA1(46e1f18e1c9992ca1823f7818b6d51c001f5a934))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispg.104", 0x00000, 0x80000, CRC(c7f197a0) SHA1(3b7f0699c08d387c67ff6cd185360e60fcd21b9e))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_i13)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.103", 0x00000, 0x20000, CRC(2a812c75) SHA1(46e1f18e1c9992ca1823f7818b6d51c001f5a934))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispi.104", 0x00000, 0x80000, CRC(387a5aad) SHA1(a0eb99b240f6044db05668c4504e908aee205220))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_l13)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.103", 0x00000, 0x20000, CRC(2a812c75) SHA1(46e1f18e1c9992ca1823f7818b6d51c001f5a934))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddisps.104", 0x00000, 0x80000, CRC(2d26514a) SHA1(f15b22cad6329f29cd5cccfb91a2ba7ca2cd6d59))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_a30)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.300", 0x00000, 0x20000, CRC(c4ba9df5) SHA1(6bdcd555db946e396b630953db1ba50677177137))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispa.300", 0x00000, 0x80000, CRC(61b274f8) SHA1(954e4b3527cefcb24376de9f6f7e5f9192ab3304))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_f30)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.300", 0x00000, 0x20000, CRC(c4ba9df5) SHA1(6bdcd555db946e396b630953db1ba50677177137))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispf.300", 0x00000, 0x80000, CRC(106f7f1f) SHA1(92a8ab7d834439a2211208e0812cdb1199acb21d))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_g30)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.300", 0x00000, 0x20000, CRC(c4ba9df5) SHA1(6bdcd555db946e396b630953db1ba50677177137))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispg.300", 0x00000, 0x80000, CRC(8f7da748) SHA1(fee1534b76769517d4e6dbed373583e573fb95b6))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_i30)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.300", 0x00000, 0x20000, CRC(c4ba9df5) SHA1(6bdcd555db946e396b630953db1ba50677177137))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispi.300", 0x00000, 0x80000, CRC(686d3cf6) SHA1(fb27e2e4b39abb56deb1e66f012d151126971474))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_l30)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.300", 0x00000, 0x20000, CRC(c4ba9df5) SHA1(6bdcd555db946e396b630953db1ba50677177137))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispl.300", 0x00000, 0x80000, CRC(4cc7251b) SHA1(7660fca37ac9fb442a059ddbafc2fa13f94dfae1))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_a18)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.108", 0x00000, 0x20000, CRC(a8e24328) SHA1(cc32d97521f706e3d8ddcf4117ec0c0e7424a378))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispa.105", 0x00000, 0x80000, CRC(401a7b9f) SHA1(37e99a42738c1147c073585391772ecc55c9a759))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_f18)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.108", 0x00000, 0x20000, CRC(a8e24328) SHA1(cc32d97521f706e3d8ddcf4117ec0c0e7424a378))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispf.105", 0x00000, 0x80000, CRC(31c77078) SHA1(8a0e2dbb698da77dffa1ab01df0f360fecf6c4c7))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_g18)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.108", 0x00000, 0x20000, CRC(a8e24328) SHA1(cc32d97521f706e3d8ddcf4117ec0c0e7424a378))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispg.105", 0x00000, 0x80000, CRC(aed5a82f) SHA1(4c44b052a9b1fa702ff49c9b2fb7cf48173459d2))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_i18)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.108", 0x00000, 0x20000, CRC(a8e24328) SHA1(cc32d97521f706e3d8ddcf4117ec0c0e7424a378))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispi.105", 0x00000, 0x80000, CRC(49c53391) SHA1(98f88eb8a49bbc59f78996d713c72ec495ba806f))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_l18)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.108", 0x00000, 0x20000, CRC(a8e24328) SHA1(cc32d97521f706e3d8ddcf4117ec0c0e7424a378))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddisps.105", 0x00000, 0x80000, CRC(6d6f2a7c) SHA1(1609c69a1584398c3504bb5a0c46f878e8dd547c))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END

ROM_START(harl_a40)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.400", 0x00000, 0x20000, CRC(752ed258) SHA1(aea0ab3c45649178a3b0e17a2eacc516600a2b63))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispa.400", 0x00000, 0x80000, CRC(e2c98397) SHA1(212ac1a509f608c490dc4dfdc5cc04187ed2fe10))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_f40)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.400", 0x00000, 0x20000, CRC(752ed258) SHA1(aea0ab3c45649178a3b0e17a2eacc516600a2b63))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispf.400", 0x00000, 0x80000, CRC(d061c238) SHA1(cb29e58970d43c2845c96e149e8fdd0c16e501c9))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_g40)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.400", 0x00000, 0x20000, CRC(752ed258) SHA1(aea0ab3c45649178a3b0e17a2eacc516600a2b63))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispg.400", 0x00000, 0x80000, CRC(4bc89a23) SHA1(fb7dcc61194560845e150bc1c032c098ffd026e8))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_i40)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.400", 0x00000, 0x20000, CRC(752ed258) SHA1(aea0ab3c45649178a3b0e17a2eacc516600a2b63))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispi.400", 0x00000, 0x80000, CRC(c4fc4990) SHA1(79d501c3123b604becbb87c12aca9848675811ec))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
ROM_START(harl_l40)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("harcpu.400", 0x00000, 0x20000, CRC(752ed258) SHA1(aea0ab3c45649178a3b0e17a2eacc516600a2b63))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hddispl.400", 0x00000, 0x80000, CRC(96096e73) SHA1(b22f03ab3f08ff192a55e92ebe85bafa893c6234))
	ROM_REGION(0x010000, "soundcpu",0)
	ROM_LOAD("hdsnd.u7",0x0000,0x10000,CRC(b9accb75) SHA1(9575f1c372ec5603322255778fc003047acc8b01))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hdvc1.u17", 0x000000, CRC(0265fe72) SHA1(7bd7b321bfa2a5092cdf273dfaf4ccdb043c06e8))
	ROM_LOAD_SND_8M("hdvc2.u21", 0x080000, CRC(89230898) SHA1(42d225e33ac1d679415e9dbf659591b7c4109740))
	ROM_LOAD_SND_8M("hdvc3.u36", 0x100000, CRC(41239811) SHA1(94fceff4dbefd3467ecb8b19e4b8baf24ddd68a3))
	ROM_LOAD("hdvc4.u37", 0x180000, 0x080000, CRC(a1bc39f6) SHA1(25af40cb3d8f774e1e37cbef9166e41753440460))
ROM_END
/*-------------------------------------------------------------------
/ High Roller Casino
/-------------------------------------------------------------------*/
ROM_START(hirolcas)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.300", 0x00000, 0x20000, CRC(0d1117fa) SHA1(a19f9dfc2288fc16cb8e992ffd7f13e70ef042c7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispa.300", 0x00000, 0x80000, CRC(099ccaf0) SHA1(2e0c2706881208f08e8a1d30915424c8f9b1cf67))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hirolcas_210)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.210", 0x00000, 0x20000, CRC(2e3c682a) SHA1(d9993ae7a0aad80e1eeff226a635873cb25437ce))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispa.200", 0x00000, 0x80000, CRC(642bdce7) SHA1(7cd922a15c1443c6ed7636c9def4bc3ab0b47096))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hironew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.300", 0x00000, 0x20000, CRC(0d1117fa) SHA1(a19f9dfc2288fc16cb8e992ffd7f13e70ef042c7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispa.300", 0x00000, 0x80000, CRC(099ccaf0) SHA1(2e0c2706881208f08e8a1d30915424c8f9b1cf67))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("hrsndu17.100", 0x000000, 0x100000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD("hrsndu21.100", 0x100000, 0x100000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD("hrsndu36.100", 0x200000, 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD("hrsndu37.100", 0x300000, 0x100000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hirolcat)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccput3.300", 0x00000, 0x20000, CRC(b70e04a0) SHA1(0c8d6c1e488471617ba9e24704d0d44826c1daf3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdspt3.300", 0x00000, 0x80000, CRC(e262f36c) SHA1(116b2b96adce953e00d1e6d7f2b4ed4cdc4a3f61))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hirol_fr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.300", 0x00000, 0x20000, CRC(0d1117fa) SHA1(a19f9dfc2288fc16cb8e992ffd7f13e70ef042c7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispf.300", 0x00000, 0x80000, CRC(1fb5046b) SHA1(8b121a9c75a7d9a312b8c03615838b748d149819))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hirol_gr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.300", 0x00000, 0x20000, CRC(0d1117fa) SHA1(a19f9dfc2288fc16cb8e992ffd7f13e70ef042c7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispg.300", 0x00000, 0x80000, CRC(a880903a) SHA1(4049f50ceaeb6c9e869150ec3d903775cdd865ff))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hirol_gr_210)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.210", 0x00000, 0x20000, CRC(2e3c682a) SHA1(d9993ae7a0aad80e1eeff226a635873cb25437ce))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispg.201", 0x00000, 0x80000, CRC(57b95712) SHA1(f7abe7511aa8b258615cd844dc76f3d2f9b47c31))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END
ROM_START(hirol_it)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("hrccpu.300", 0x00000, 0x20000, CRC(0d1117fa) SHA1(a19f9dfc2288fc16cb8e992ffd7f13e70ef042c7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("hrcdispi.300", 0x00000, 0x80000, CRC(2734f746) SHA1(aa924d998b6c3fbd80e9325093c9b3267dfaadef))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("hrsndu7.100",0x0000,0x10000,CRC(c41f91a7) SHA1(2af3be10754ea633558bdbeded21c6f82d85cd1d))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("hrsndu17.100", 0x000000, CRC(5858dfd0) SHA1(0d88daf3b480f0e0a2653d9be37cafed79036a48))
	ROM_LOAD_SND_8M("hrsndu21.100", 0x080000, CRC(c653de96) SHA1(352567f4f4f973ed3d8c018c9bf37aeecdd101bf))
	ROM_LOAD_SND_8M("hrsndu36.100", 0x100000, CRC(5634eb4e) SHA1(8c76f49423fc0d7887aa5c57ad029b7371372739))
	ROM_LOAD_SND_8M("hrsndu37.100", 0x180000, CRC(d4d23c00) SHA1(c574dc4553bff693d9216229ce38a55f69e7368a))
ROM_END

/*-------------------------------------------------------------------
/ Independence Day
/-------------------------------------------------------------------*/
ROM_START(id4)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("id4cpu.202", 0x00000, 0x20000, CRC(108d88fd) SHA1(8317944201acfb97dadfdd364696c9e81a21d2c5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("id4dspa.200", 0x00000, 0x80000, CRC(2d3fbcc4) SHA1(0bd69ebb68ae880ac9aae40916f13e1ff84ecfaa))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("id4sndu7.512", 0x0000, 0x10000, CRC(deeaed37) SHA1(06d79967a25af0b90a5f1d6360a5b5fdbb972d5a))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("id4sdu17.400", 0x000000, 0x80000, CRC(89ffeca3) SHA1(b94c60e3a433f797d6c5ea793c3ecff0a3b6ba60))
	ROM_LOAD("id4sdu21.400", 0x080000, 0x80000, CRC(f384a9ab) SHA1(06bd607e7efd761017a7b605e0294a34e4c6255c))
ROM_END

/*-------------------------------------------------------------------
/ Irons & Woods
/-------------------------------------------------------------------*/

/*-------------------------------------------------------------------
/ Lost in Space
/-------------------------------------------------------------------*/
ROM_START(lostspc)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("liscpu.101", 0x00000, 0x20000, CRC(81b2ced8) SHA1(a1933e2686b2a4e48d0f327593df95a927b132cb))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("lisdspa.102", 0x00000, 0x80000, CRC(e8bf4a58) SHA1(572313fb79e5a0c0034938a09b04ef43fc235c84))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("lisu7.100", 0x0000, 0x10000, CRC(96e6b3c4) SHA1(5cfb43b8c182aed4b49ad1b8803812a18c6c8b6f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("lisu17.100", 0x000000, 0x80000, CRC(69076939) SHA1(f2cdf61a2b469d1a69eb3f08fc6e511d72336586))
	ROM_LOAD("lisu21.100", 0x080000, 0x80000, CRC(56eede09) SHA1(9ff53d7a188bd7293ad92089d143bd54623a50d4))
	ROM_LOAD("lisu36.100", 0x100000, 0x80000, CRC(56f2c53b) SHA1(5c2daf17116016fbead1320eb150cf655984662b))
	ROM_LOAD("lisu37.100", 0x180000, 0x80000, CRC(f9430c59) SHA1(f0f7169e63fc12d29fe39cd24dd67c5fb17779f7))
ROM_END

/*-------------------------------------------------------------------
/ Mini-Viper
/-------------------------------------------------------------------*/

/*-------------------------------------------------------------------
/ Monopoly (3.20)
/-------------------------------------------------------------------*/
ROM_START(monopolp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.320", 0x00000, 0x20000, CRC(6c107c8b) SHA1(236d85b971c70a30e663787d643e6d589591d582))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-a.301", 0x00000, 0x80000, CRC(c4e2e032) SHA1(691f7b6ed0616338683f7e3f316d64a70db58dd4))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (3.03)
/-------------------------------------------------------------------*/
ROM_START(monop303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.303", 0x00000, 0x20000, CRC(4a66c9e4) SHA1(a368b0ced32f1017e781a59108670b979b50c9d7))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-a.301", 0x00000, 0x80000, CRC(c4e2e032) SHA1(691f7b6ed0616338683f7e3f316d64a70db58dd4))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (3.01)
/-------------------------------------------------------------------*/
ROM_START(monop301)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.301", 0x00000, 0x20000, CRC(24978872) SHA1(48ef94fd720cdafc61f8de5efd5c6b6731237b18))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-a.301", 0x00000, 0x80000, CRC(c4e2e032) SHA1(691f7b6ed0616338683f7e3f316d64a70db58dd4))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (2.51)
/-------------------------------------------------------------------*/
ROM_START(monop251)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.251", 0x00000, 0x20000, CRC(0645cfae) SHA1(d979234150b7fb62718debbeeeca1466a6c0344f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-a.206", 0x00000, 0x80000, CRC(6df6e158) SHA1(d3a9be2dc189b44b9e4b9f77f5011ed931df5634))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (2.33)
/-------------------------------------------------------------------*/
ROM_START(monop233)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.233", 0x00000, 0x20000, CRC(f20a5ca6) SHA1(12ae56bd149aa6635c19f4dd73580db550b26963))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-a.203", 0x00000, 0x80000, CRC(6e4678fb) SHA1(c0f41f01e9e20e741f1b13d3bd6e824486ba9a0a))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (3.20) (ARM7 Sound Board)
/-------------------------------------------------------------------*/
ROM_START(mononew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.320", 0x00000, 0x20000, CRC(6c107c8b) SHA1(236d85b971c70a30e663787d643e6d589591d582))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-a.301", 0x00000, 0x80000, CRC(c4e2e032) SHA1(691f7b6ed0616338683f7e3f316d64a70db58dd4))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x100000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("mnsndu17.100", 0x000000, 0x100000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD("mnsndu21.100", 0x100000, 0x100000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD("mnsndu36.100", 0x200000, 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (France)
/-------------------------------------------------------------------*/
ROM_START(monopolf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.320", 0x00000, 0x20000, CRC(6c107c8b) SHA1(236d85b971c70a30e663787d643e6d589591d582))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-f.301", 0x00000, 0x80000, CRC(e78b1998) SHA1(bd022dc90b55374baed17360fad7bf0f89e2ee33))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (France)
/-------------------------------------------------------------------*/
ROM_START(monopolg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.320", 0x00000, 0x20000, CRC(6c107c8b) SHA1(236d85b971c70a30e663787d643e6d589591d582))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-g.301", 0x00000, 0x80000, CRC(aab48728) SHA1(b9ed8574ac463a5fc21dc5f41d090cf0ad3f8362))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (Italy)
/-------------------------------------------------------------------*/
ROM_START(monopoli)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.320", 0x00000, 0x20000, CRC(6c107c8b) SHA1(236d85b971c70a30e663787d643e6d589591d582))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-i.301", 0x00000, 0x80000, CRC(32431b3c) SHA1(6266e17e705bd50d2358d9f7c0168de51aa13750))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (Spain)
/-------------------------------------------------------------------*/
ROM_START(monopoll)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("moncpu.320", 0x00000, 0x20000, CRC(6c107c8b) SHA1(236d85b971c70a30e663787d643e6d589591d582))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("mondsp-s.301", 0x00000, 0x80000, CRC(9f70dad6) SHA1(bf4b1c579b4bdead51e6b34de81fe65c45b6596a))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("mnsndu7.100",0x0000,0x10000,CRC(400442e7) SHA1(d6c075dc439d5366b7ae71b5a523b86543b1ecd6))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("mnsndu17.100", 0x000000, CRC(f9bc55e8) SHA1(7dc41521305021961927ebde4dcf22611e3d622d))
	ROM_LOAD_SND_8M("mnsndu21.100", 0x080000, CRC(e0727e1f) SHA1(2093dba6e2f59cd1d1fc49c8d995b603ea0913ba))
	ROM_LOAD_SND_8M("mnsndu36.100", 0x100000, CRC(c845aa97) SHA1(2632aa8c5576b7afcb96693fa524c7d0350ac9a8))
ROM_END

/*-------------------------------------------------------------------
/ NFL
/-------------------------------------------------------------------*/
ROM_START(nfl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("nfl_v101.cpu", 0x00000, 0x20000, CRC(eeb81a51) SHA1(c87e5f50cc95b1d0206abc3c132f5f3314a9253c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("nfl_v102.dmd", 0x00000, 0x80000, CRC(fd7bc50a) SHA1(5c92af91e7e12024026a06002e6c6bf68230fcc0))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("nfl_v100.u7",0x0000,0x10000,CRC(3fc766f8) SHA1(27341594e7d4a23146e6e6ec8ebdea125231cf91))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("nfl_v100.u17", 0x000000, CRC(f36b72ed) SHA1(f8fcbdb31295d363d1e7ad98dc318ab52bcfc52b))
	ROM_LOAD_SND_8M("nfl_v100.u21", 0x080000, CRC(f5a6c053) SHA1(30a9cda6c9d9c43f0f6690138cf74c39c79ba43e))
	ROM_LOAD_SND_8M("nfl_v100.u36", 0x100000, CRC(26dae8ac) SHA1(ec18f13578c5c291b777344b2830cde2ecf3581c))
	ROM_LOAD_SND_8M("nfl_v100.u37", 0x180000, CRC(375d5a99) SHA1(4b49c58968da645bd0ad60ed16744974b863164e))
ROM_END


/*-------------------------------------------------------------------
/ Playboy
/-------------------------------------------------------------------*/
ROM_START(playboys)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.500", 0x00000, 0x20000, CRC(e4d924ae) SHA1(2aab64eee57e9569c3cc1bde28cda69ff4cacc69))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispa.500", 0x00000, 0x80000, CRC(40450165) SHA1(80295466838cb08fe1499b19a98bf759fb7a306e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboys_401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.401", 0x00000, 0x20000, CRC(cb2e2824) SHA1(01413ff1f4fbee9d62776babb60ccc88f97feedf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispa.400", 0x00000, 0x80000, CRC(244e9740) SHA1(1a2de2c53104e1123cbcc9ccc92e0888b4cf4bec))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboys_303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.303", 0x00000, 0x20000, CRC(6a6f6aab) SHA1(cac5d68d699db4016244ffd56355e2834be3da1f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispa.300", 0x00000, 0x80000, CRC(2dbb372a) SHA1(b694ae06f380ea9f9730ea6bbfab7f9f7ec7342b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboys_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.300", 0x00000, 0x20000, CRC(d7e5bada) SHA1(e4d5bc015751a559eb95acb6da04246b7418eaf5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispa.300", 0x00000, 0x80000, CRC(2dbb372a) SHA1(b694ae06f380ea9f9730ea6bbfab7f9f7ec7342b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboys_203)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.203", 0x00000, 0x20000, CRC(50eb01b0) SHA1(1618874f35432bd9fb2592e1a56592e7624257c4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdisp-a.201", 0x00000, 0x80000, CRC(78ec6af8) SHA1(35b8de8ab345cf81eec4f7b7d4f654115fe69ddf))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END

ROM_START(playnew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.500", 0x00000, 0x20000, CRC(e4d924ae) SHA1(2aab64eee57e9569c3cc1bde28cda69ff4cacc69))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispa.500", 0x00000, 0x80000, CRC(40450165) SHA1(80295466838cb08fe1499b19a98bf759fb7a306e))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("pbsndu17.100", 0x000000, 0x100000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD("pbsndu21.100", 0x100000, 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD("pbsndu36.100", 0x200000, 0x100000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD("pbsndu37.100", 0x300000, 0x100000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.500", 0x00000, 0x20000, CRC(e4d924ae) SHA1(2aab64eee57e9569c3cc1bde28cda69ff4cacc69))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispf.500", 0x00000, 0x80000, CRC(aedc6c32) SHA1(c930ae1b1308ae641553de34f8249b17f408be56))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyf_401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.401", 0x00000, 0x20000, CRC(cb2e2824) SHA1(01413ff1f4fbee9d62776babb60ccc88f97feedf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispf.400", 0x00000, 0x80000, CRC(8ccce5d9) SHA1(28370445d38b065001e96b455d283bc047ed0f21))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyf_303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.303", 0x00000, 0x20000, CRC(6a6f6aab) SHA1(cac5d68d699db4016244ffd56355e2834be3da1f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispf.300", 0x00000, 0x80000, CRC(69ab3bb2) SHA1(59d7ad5eca701d1216200cd489d2d07825a0856e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyf_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.300", 0x00000, 0x20000, CRC(d7e5bada) SHA1(e4d5bc015751a559eb95acb6da04246b7418eaf5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispf.300", 0x00000, 0x80000, CRC(69ab3bb2) SHA1(59d7ad5eca701d1216200cd489d2d07825a0856e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyf_203)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.203", 0x00000, 0x20000, CRC(50eb01b0) SHA1(1618874f35432bd9fb2592e1a56592e7624257c4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdisp-f.201", 0x00000, 0x80000, CRC(eedea4f4) SHA1(31eb1d4de0a4aee73c424c0f21dd2042e6ad0dca))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END

ROM_START(playboyg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.500", 0x00000, 0x20000, CRC(e4d924ae) SHA1(2aab64eee57e9569c3cc1bde28cda69ff4cacc69))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispg.500", 0x00000, 0x80000, CRC(681392fe) SHA1(23011d538282da144b8ff9cbb7c5655567017e5e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyg_401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.401", 0x00000, 0x20000, CRC(cb2e2824) SHA1(01413ff1f4fbee9d62776babb60ccc88f97feedf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispg.400", 0x00000, 0x80000, CRC(c26a0c73) SHA1(1841ab278e5d3e146cb3b43dfedc208d302dbc17))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyg_303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.303", 0x00000, 0x20000, CRC(6a6f6aab) SHA1(cac5d68d699db4016244ffd56355e2834be3da1f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispg.300", 0x00000, 0x80000, CRC(ed7b7c62) SHA1(28b0ab490f8abd5f29e8cb0996da9e7200918157))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyg_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.300", 0x00000, 0x20000, CRC(d7e5bada) SHA1(e4d5bc015751a559eb95acb6da04246b7418eaf5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispg.300", 0x00000, 0x80000, CRC(ed7b7c62) SHA1(28b0ab490f8abd5f29e8cb0996da9e7200918157))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyg_203)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.203", 0x00000, 0x20000, CRC(50eb01b0) SHA1(1618874f35432bd9fb2592e1a56592e7624257c4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdisp-g.201", 0x00000, 0x80000, CRC(ff525cc7) SHA1(475578cf8b2262a11f640883b70b706f705d90ff))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyi)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.500", 0x00000, 0x20000, CRC(e4d924ae) SHA1(2aab64eee57e9569c3cc1bde28cda69ff4cacc69))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispi.500", 0x00000, 0x80000, CRC(d90d7ec6) SHA1(7442160f403a8ccabfc9dc8dc53f8b44f5df26bc))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyi_401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.401", 0x00000, 0x20000, CRC(cb2e2824) SHA1(01413ff1f4fbee9d62776babb60ccc88f97feedf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispi.400", 0x00000, 0x80000, CRC(90c5afed) SHA1(ea7ab06adb18854c9871b02f39fe616a27293415))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyi_303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.303", 0x00000, 0x20000, CRC(6a6f6aab) SHA1(cac5d68d699db4016244ffd56355e2834be3da1f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispi.300", 0x00000, 0x80000, CRC(74c8cedf) SHA1(474ad1939ea0a58852003e549ed85478e239a67c))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyi_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.300", 0x00000, 0x20000, CRC(d7e5bada) SHA1(e4d5bc015751a559eb95acb6da04246b7418eaf5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispi.300", 0x00000, 0x80000, CRC(74c8cedf) SHA1(474ad1939ea0a58852003e549ed85478e239a67c))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyi_203)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.203", 0x00000, 0x20000, CRC(50eb01b0) SHA1(1618874f35432bd9fb2592e1a56592e7624257c4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdisp-i.201", 0x00000, 0x80000, CRC(48f190dc) SHA1(bf5c096f755871b12783a63b55908751f9fa5b07))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.500", 0x00000, 0x20000, CRC(e4d924ae) SHA1(2aab64eee57e9569c3cc1bde28cda69ff4cacc69))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispl.500", 0x00000, 0x80000, CRC(b019f0f6) SHA1(184a9905cd3af9d272577e43666aed5e5a8a5281))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyl_401)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.401", 0x00000, 0x20000, CRC(cb2e2824) SHA1(01413ff1f4fbee9d62776babb60ccc88f97feedf))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdisps.400", 0x00000, 0x80000, CRC(92b48fdd) SHA1(deebb0bf6ec13b0cead3970c19bd0e8321046786))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyl_303)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.303", 0x00000, 0x20000, CRC(6a6f6aab) SHA1(cac5d68d699db4016244ffd56355e2834be3da1f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispl.300", 0x00000, 0x80000, CRC(e7697fc3) SHA1(7a9796e7b99af0d3d2079876a8054209a3067e64))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyl_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.300", 0x00000, 0x20000, CRC(d7e5bada) SHA1(e4d5bc015751a559eb95acb6da04246b7418eaf5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdispl.300", 0x00000, 0x80000, CRC(e7697fc3) SHA1(7a9796e7b99af0d3d2079876a8054209a3067e64))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
ROM_START(playboyl_203)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("pbcpu.203", 0x00000, 0x20000, CRC(50eb01b0) SHA1(1618874f35432bd9fb2592e1a56592e7624257c4))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("pbdisp-l.201", 0x00000, 0x80000, CRC(eaa65c45) SHA1(4ec9f815e40ac2185812faad7b991723f0b5775b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("pbsndu7.102",0x0000,0x10000,CRC(12a68f34) SHA1(f2cd42918dec353883bc465f6302c2d94dcd6b87))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("pbsndu17.100", 0x000000, CRC(f5502fec) SHA1(c8edd56e0c4365dd6b4bef0f1c7cc83ea5fd73d6))
	ROM_LOAD_SND_8M("pbsndu21.100", 0x100000, CRC(7869d34f) SHA1(48a051045523c14ca06a7227b34ed9e3818828d0))
	ROM_LOAD_SND_8M("pbsndu36.100", 0x200000, CRC(d10f14a3) SHA1(972b480c23d484b627ecdce0322c08fe760a127f))
	ROM_LOAD_SND_8M("pbsndu37.100", 0x300000, CRC(6642524a) SHA1(9d0c0be5887cf4510c11243ee47b11c08cbae17c))
ROM_END
/*-------------------------------------------------------------------
/ Roller Coaster Tycoon
/-------------------------------------------------------------------*/
ROM_START(rctycn)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.702", 0x00000, 0x20000, CRC(5736a816) SHA1(fcfd06eeca74df0bca2c0bc57aeaa00400e4ab55))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispa.701", 0x00000, 0x80000, CRC(0d527f13) SHA1(954116a79578b2a7679c401a2bb99b5bbfb603f2))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycn_701)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.701",    0x0000, 0x20000, CRC(e1fe89f6) SHA1(9a76a5c267e055fcf0418394762bcea758da02d6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispa.700",  0x0000, 0x80000, CRC(6a8925d7) SHA1(82a6c069f1e8f8e053fec708f56c8ffe56d70fc8))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycn_600)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.600",    0x0000, 0x20000, CRC(2ada30e5) SHA1(fdcd608af155b16c15ec14c83927004c63e9c513))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispa.600",  0x0000, 0x80000, CRC(dbd294e1) SHA1(53c540594bfe5544b4a009665a1ca3edb1cb874c))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycn_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.400", 0x00000, 0x20000, CRC(4691de23) SHA1(f47fc03f9b030cb7a1201d015bbec5a426176338))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispa.400", 0x00000, 0x80000, CRC(d128a8fa) SHA1(8fece3df33d21da020ba06d14d588384d90dd89f))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctnew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.702", 0x00000, 0x20000, CRC(5736a816) SHA1(fcfd06eeca74df0bca2c0bc57aeaa00400e4ab55))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispa.701", 0x00000, 0x80000, CRC(0d527f13) SHA1(954116a79578b2a7679c401a2bb99b5bbfb603f2))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x100000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycng)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.702", 0x00000, 0x20000, CRC(5736a816) SHA1(fcfd06eeca74df0bca2c0bc57aeaa00400e4ab55))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispg.701", 0x00000, 0x80000, CRC(6c70ab29) SHA1(fa3b713b79c0d724b918fa318795681308a4fce3))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycng_701)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.701", 0x00000, 0x20000, CRC(e1fe89f6) SHA1(9a76a5c267e055fcf0418394762bcea758da02d6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispg.700", 0x00000, 0x80000, CRC(0babf1ed) SHA1(db683aa392968d255d355d4a1b0c9d8d4fb9e799))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycng_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.400", 0x00000, 0x20000, CRC(4691de23) SHA1(f47fc03f9b030cb7a1201d015bbec5a426176338))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispg.400", 0x00000, 0x80000, CRC(c88dc915) SHA1(894c3bb7f5d200448740f021b5b9421f6ee74c5f))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.702", 0x00000, 0x20000, CRC(5736a816) SHA1(fcfd06eeca74df0bca2c0bc57aeaa00400e4ab55))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispf.701", 0x00000, 0x80000, CRC(4a3bb40c) SHA1(053f494765ac7708401a7816af7186e71083fe8d))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnf_701)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.701", 0x00000, 0x20000, CRC(e1fe89f6) SHA1(9a76a5c267e055fcf0418394762bcea758da02d6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispf.700", 0x00000, 0x80000, CRC(2de0eec8) SHA1(5b48eabddc1fb735866767ae008baf58205954db))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnf_600)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.600", 0x00000, 0x20000, CRC(2ada30e5) SHA1(fdcd608af155b16c15ec14c83927004c63e9c513))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispf.600", 0x00000, 0x80000, CRC(50aa2f48) SHA1(e7c0fb30ef15861e342bd6fada45885bd2403547))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnf_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.400", 0x00000, 0x20000, CRC(4691de23) SHA1(f47fc03f9b030cb7a1201d015bbec5a426176338))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispf.400", 0x00000, 0x80000, CRC(5b41893b) SHA1(66930d0f5d6542b41f22995df55447ba0e435576))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycni)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.702", 0x00000, 0x20000, CRC(5736a816) SHA1(fcfd06eeca74df0bca2c0bc57aeaa00400e4ab55))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispi.701", 0x00000, 0x80000, CRC(6adc8236) SHA1(bb908c88e47987777c921f2948dfb802ee29c868))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycni_701)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.701", 0x00000, 0x20000, CRC(e1fe89f6) SHA1(9a76a5c267e055fcf0418394762bcea758da02d6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispi.700", 0x00000, 0x80000, CRC(0d07d8f2) SHA1(3ffd8ad7183ba20844c1e5d1933c8002ca4707aa))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycni_600)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.600", 0x00000, 0x20000, CRC(2ada30e5) SHA1(fdcd608af155b16c15ec14c83927004c63e9c513))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispi.600", 0x00000, 0x80000, CRC(a55a86c1) SHA1(b18197063e2e4cc50b04f43de41d870eb672ce68))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycni_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.400", 0x00000, 0x20000, CRC(4691de23) SHA1(f47fc03f9b030cb7a1201d015bbec5a426176338))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdispi.400", 0x00000, 0x80000, CRC(7c1c0adb) SHA1(c9321a64ee4af8d475b441ae2385120bba66ccf9))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.702", 0x00000, 0x20000, CRC(5736a816) SHA1(fcfd06eeca74df0bca2c0bc57aeaa00400e4ab55))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdisps.701", 0x00000, 0x80000, CRC(0efa8208) SHA1(6706ea3e31b478970fc65a8cf9db749db9c0fa39))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnl_701)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.701", 0x00000, 0x20000, CRC(e1fe89f6) SHA1(9a76a5c267e055fcf0418394762bcea758da02d6))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdisps.700", 0x00000, 0x80000, CRC(6921d8cc) SHA1(1ada415af8e949829ceac75da507982ea2091f4d))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnl_600)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.600", 0x00000, 0x20000, CRC(2ada30e5) SHA1(fdcd608af155b16c15ec14c83927004c63e9c513))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdisps.600", 0x00000, 0x80000, CRC(84a970a3) SHA1(8e00830ba446c8cef99d8e721b65597d9dd98379))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
ROM_START(rctycnl_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("rctcpu.400", 0x00000, 0x20000, CRC(4691de23) SHA1(f47fc03f9b030cb7a1201d015bbec5a426176338))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("rctdisps.400", 0x00000, 0x80000, CRC(c06e6669) SHA1(af389ba74e62d7065b3bc7d5f771a3461704cbe3))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("rcsndu7.100",0x0000,0x10000,CRC(e6cde9b1) SHA1(cbaadafd18ad9c0338bf2cce94b2c2a89e734778))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("rcsndu17.100", 0x000000, CRC(18ba20ec) SHA1(c6e7a8a5fd6029b8e884a6eeb779a10d819e8c7c))
	ROM_LOAD_SND_8M("rcsndu21.100", 0x080000, CRC(64b19c11) SHA1(9ac714d372437cf1d8c4e01512c0647f13e40ddb))
	ROM_LOAD_SND_8M("rcsndu36.100", 0x100000, CRC(05c8bac9) SHA1(0771a393d5361c9a35d42a18b6c6a105b7752e03))
ROM_END
/*-------------------------------------------------------------------
/ Sharkey's Shootout
/-------------------------------------------------------------------*/
ROM_START(shrkysht)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.211", 0x00000, 0x20000, CRC(66a0e5ce) SHA1(d33615081cd8cdf8a17a44b389c6d9746e093510))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispa.201", 0x00000, 0x80000, CRC(3360300b) SHA1(3169651a49bb7168fc04b2ae678b696ec6a21c85))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrknew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.211", 0x00000, 0x20000, CRC(66a0e5ce) SHA1(d33615081cd8cdf8a17a44b389c6d9746e093510))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispa.201", 0x00000, 0x80000, CRC(3360300b) SHA1(3169651a49bb7168fc04b2ae678b696ec6a21c85))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x100000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sssndu17.100", 0x000000, 0x100000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD("sssndu21.100", 0x100000, 0x100000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD("sssndu36.100", 0x200000, 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrkygr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.211", 0x00000, 0x20000, CRC(66a0e5ce) SHA1(d33615081cd8cdf8a17a44b389c6d9746e093510))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispg.201", 0x00000, 0x80000, CRC(1ad88b75) SHA1(f82ae59b59e545e2023879aad7e99862d9d339c5))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrkyfr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.211", 0x00000, 0x20000, CRC(66a0e5ce) SHA1(d33615081cd8cdf8a17a44b389c6d9746e093510))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispf.201", 0x00000, 0x80000, CRC(89eaaebf) SHA1(0945a11a8f632cea3b9e9982cc4aed54f12ec55a))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrkyit)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.211", 0x00000, 0x20000, CRC(66a0e5ce) SHA1(d33615081cd8cdf8a17a44b389c6d9746e093510))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispi.201", 0x00000, 0x80000, CRC(fb70641d) SHA1(d152838eeacacc5dfe6fc3bc3f26b4d3e9e4c9cc))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END

ROM_START(shrky_207)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.207", 0x00000, 0x20000, CRC(7355d65d) SHA1(d501cf1ff8b4be01970d47997f71f539df57b702))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispa.201", 0x00000, 0x80000, CRC(3360300b) SHA1(3169651a49bb7168fc04b2ae678b696ec6a21c85))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrkygr_207)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.207", 0x00000, 0x20000, CRC(7355d65d) SHA1(d501cf1ff8b4be01970d47997f71f539df57b702))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispg.201", 0x00000, 0x80000, CRC(1ad88b75) SHA1(f82ae59b59e545e2023879aad7e99862d9d339c5))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrkyfr_207)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.207", 0x00000, 0x20000, CRC(7355d65d) SHA1(d501cf1ff8b4be01970d47997f71f539df57b702))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispf.201", 0x00000, 0x80000, CRC(89eaaebf) SHA1(0945a11a8f632cea3b9e9982cc4aed54f12ec55a))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END
ROM_START(shrkyit_207)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sscpu.207", 0x00000, 0x20000, CRC(7355d65d) SHA1(d501cf1ff8b4be01970d47997f71f539df57b702))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ssdispi.201", 0x00000, 0x80000, CRC(fb70641d) SHA1(d152838eeacacc5dfe6fc3bc3f26b4d3e9e4c9cc))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sssndu7.101",0x0000,0x10000,CRC(fbc6267b) SHA1(e6e70662031e5209385f8b9c59296d7423cc03b4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sssndu17.100", 0x000000, CRC(dae78d8d) SHA1(a0e1722a19505e7d08266c490d27f772357722d3))
	ROM_LOAD_SND_8M("sssndu21.100", 0x080000, CRC(e1fa3f2a) SHA1(08731fd53ef81453a8f20602e76d435c6771bbb9))
	ROM_LOAD_SND_8M("sssndu36.100", 0x100000, CRC(d22fcfa3) SHA1(3fa407f72ecc64f9d00b92122c4e4d85022e4202))
ROM_END

/*-------------------------------------------------------------------
/ South Park
/-------------------------------------------------------------------*/
ROM_START(sprk_103)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spkcpu.103", 0x00000, 0x20000, CRC(55ca8aa1) SHA1(ee3dda7d7e6ad32072cbf3acc8087a27b95cc68d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("spdspa.101", 0x00000, 0x80000, CRC(48ca598d) SHA1(0827ac7bb5cf12b0e63860b73a808273d984509e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spku7.101",0x0000,0x10000,CRC(3d831d3e) SHA1(fd12e4639bf806c518a2733c32572b051517ff27))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spku17.100", 0x000000, CRC(829262c9) SHA1(88adb13a6773f88658d6b8d6520a03ecd377e4e7))
	ROM_LOAD_SND_8M("spku21.100", 0x080000, CRC(3a55eef3) SHA1(2a643bd7a433a39d764294c1569182e6ff0af240))
	ROM_LOAD_SND_8M("spku36.100", 0x100000, CRC(bcf6d2cb) SHA1(8e8186f08ff1e39a7889469ec1fdfa9402a8695c))
	ROM_LOAD_SND_8M("spku37.100", 0x180000, CRC(7d8f6bcb) SHA1(579cfef19cf9b5c91151ae833bc6c21734589849))
ROM_END
ROM_START(sprk_096)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spkcpu.096", 0x00000, 0x20000, CRC(4d7e862a) SHA1(962c129504f678264ab847fac08bac91cbbccb33))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("spdspa.090", 0x00000, 0x80000, CRC(c333dd48) SHA1(fe2be9274c06b2f39fa2e14e0d44ce7213282f3b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spku7.090",0x0000,0x10000,CRC(19937fbd) SHA1(ebd7c8f1604accbeb7c00066ecf811193a2cb588))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spku17.090", 0x000000, CRC(05a8670e) SHA1(7c0f1f0c9b94f0327c820f002bffc4ea05670ec8))
	ROM_LOAD_SND_8M("spku21.090", 0x080000, CRC(c8629ee7) SHA1(843a742cb5cfce21a83618d14ae08ee1930d36cc))
	ROM_LOAD_SND_8M("spku36.090", 0x100000, CRC(727d4624) SHA1(9019014e6057d279a37cc3ce269a1c68baeb9673))
	ROM_LOAD_SND_8M("spku37.090", 0x180000, CRC(0c01b0c7) SHA1(76b5af50514d110b49721e6916dd16b3e3a2f5fa))
ROM_END
ROM_START(sprk_090)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spkcpu.090", 0x00000, 0x20000, CRC(bc3f8531) SHA1(5408e008c4f545bb4f82308b118d15525f8a263a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("spdspa.090", 0x00000, 0x80000, CRC(c333dd48) SHA1(fe2be9274c06b2f39fa2e14e0d44ce7213282f3b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spku7.090",0x0000,0x10000,CRC(19937fbd) SHA1(ebd7c8f1604accbeb7c00066ecf811193a2cb588))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spku17.090", 0x000000, CRC(05a8670e) SHA1(7c0f1f0c9b94f0327c820f002bffc4ea05670ec8))
	ROM_LOAD_SND_8M("spku21.090", 0x080000, CRC(c8629ee7) SHA1(843a742cb5cfce21a83618d14ae08ee1930d36cc))
	ROM_LOAD_SND_8M("spku36.090", 0x100000, CRC(727d4624) SHA1(9019014e6057d279a37cc3ce269a1c68baeb9673))
	ROM_LOAD_SND_8M("spku37.090", 0x180000, CRC(0c01b0c7) SHA1(76b5af50514d110b49721e6916dd16b3e3a2f5fa))
ROM_END

/*-------------------------------------------------------------------
/ Space Jam
/-------------------------------------------------------------------*/
ROM_START(spacejam)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("jamcpu.300", 0x00000, 0x20000, CRC(9dc8df2e) SHA1(b3b111afb5b1f1236be73e899b34a5d5a73813e9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("jamdspa.300", 0x00000, 0x80000, CRC(198e5e34) SHA1(e2ba9ff1cea84c5d41f32afc50229cb5a18c7666))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spcjam.u7", 0x0000, 0x10000, CRC(c693d853) SHA1(3e81e60967dff496c681962f3ff8c7c1fbb7746a))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("spcjam.u17", 0x000000, 0x80000, CRC(ccefe457) SHA1(4186dee689fbfc08e5070ccfe8d4be95220cd87b))
	ROM_LOAD("spcjam.u21", 0x080000, 0x80000, CRC(14cb71cb) SHA1(46752c1792c26345abb4d5219917a1cda50c600b))
	ROM_LOAD("spcjam.u36", 0x100000, 0x80000, CRC(7f61143c) SHA1(40695d1d14695d3e4991ed39f4a354c16227975e))
ROM_END
ROM_START(spacejmg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("jamcpu.300", 0x00000, 0x20000, CRC(9dc8df2e) SHA1(b3b111afb5b1f1236be73e899b34a5d5a73813e9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("jamdspg.300", 0x00000, 0x80000, CRC(41f6e188) SHA1(da2247022aadb0ead5a3b1d7b829c13ff1153ec8))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spcjam.u7", 0x0000, 0x10000, CRC(c693d853) SHA1(3e81e60967dff496c681962f3ff8c7c1fbb7746a))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("spcjam.u17", 0x000000, 0x80000, CRC(ccefe457) SHA1(4186dee689fbfc08e5070ccfe8d4be95220cd87b))
	ROM_LOAD("spcjamg.u21", 0x080000, 0x80000, CRC(9e7fe0a6) SHA1(187e5893f84d0c0fd70d15c3978fc3fc51e12a51))
	ROM_LOAD("spcjamg.u36", 0x100000, 0x80000, CRC(7d11e1eb) SHA1(96d4635b1edf8a22947a5cd529ce9025cf7d0c71))
ROM_END
ROM_START(spacejmf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("jamcpu.300", 0x00000, 0x20000, CRC(9dc8df2e) SHA1(b3b111afb5b1f1236be73e899b34a5d5a73813e9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("jamdspf.300", 0x00000, 0x80000, CRC(1683909f) SHA1(e14810a5d8704ea052fddcb3b54043bf9d57b296))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spcjam.u7", 0x0000, 0x10000, CRC(c693d853) SHA1(3e81e60967dff496c681962f3ff8c7c1fbb7746a))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("spcjam.u17", 0x000000, 0x80000, CRC(ccefe457) SHA1(4186dee689fbfc08e5070ccfe8d4be95220cd87b))
	ROM_LOAD("spcjamf.u21", 0x080000, 0x80000, CRC(9e7fe0a6) SHA1(187e5893f84d0c0fd70d15c3978fc3fc51e12a51))
	ROM_LOAD("spcjamf.u36", 0x100000, 0x80000, CRC(7d11e1eb) SHA1(96d4635b1edf8a22947a5cd529ce9025cf7d0c71))
ROM_END
ROM_START(spacejmi)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("jamcpu.300", 0x00000, 0x20000, CRC(9dc8df2e) SHA1(b3b111afb5b1f1236be73e899b34a5d5a73813e9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("jamdspi.300", 0x00000, 0x80000, CRC(eb9b5971) SHA1(0bfac0511d0cd9d56eee59782c199ee0a78abe5e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spcjam.u7", 0x0000, 0x10000, CRC(c693d853) SHA1(3e81e60967dff496c681962f3ff8c7c1fbb7746a))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("spcjam.u17", 0x000000, 0x80000, CRC(ccefe457) SHA1(4186dee689fbfc08e5070ccfe8d4be95220cd87b))
	ROM_LOAD("spcjami.u21", 0x080000, 0x80000, CRC(9e7fe0a6) SHA1(187e5893f84d0c0fd70d15c3978fc3fc51e12a51))
	ROM_LOAD("spcjami.u36", 0x100000, 0x80000, CRC(7d11e1eb) SHA1(96d4635b1edf8a22947a5cd529ce9025cf7d0c71))
ROM_END

/*-------------------------------------------------------------------
/ Star Wars Trilogy
/-------------------------------------------------------------------*/
ROM_START(swtril43)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("swcpu.403", 0x00000, 0x20000, CRC(d022880e) SHA1(c1a2acf5740cef6a8aeee9b6a60942b51147963f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("swsedspa.400", 0x00000, 0x80000, CRC(b9bcbf71) SHA1(036f53e638699de0447ecd02221f673a40f656be))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sw0219.u7", 0x0000, 0x10000, CRC(cd7c84d9) SHA1(55b0208089933e4a30f0eb87b123dd178383ed43))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("sw0211.u17", 0x000000, 0x80000, CRC(6863e7f6) SHA1(99f1e0170fbbb91a0eb7a796ab3bf757cb1b23ce))
	ROM_LOAD("sw0211.u21", 0x080000, 0x80000, CRC(6be68450) SHA1(d24652f74b109e47eb5d3d02e04f63c99e92c590))
ROM_END
ROM_START(swtril41)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("swcpu.401", 0x00000, 0x20000, CRC(707dce87) SHA1(45fc3ffe646e5be72af9f7f00990ee5f85338f34))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("swsedspa.400", 0x00000, 0x80000, CRC(b9bcbf71) SHA1(036f53e638699de0447ecd02221f673a40f656be))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sw0219.u7", 0x0000, 0x10000, CRC(cd7c84d9) SHA1(55b0208089933e4a30f0eb87b123dd178383ed43))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("sw0211.u17", 0x000000, 0x80000, CRC(6863e7f6) SHA1(99f1e0170fbbb91a0eb7a796ab3bf757cb1b23ce))
	ROM_LOAD("sw0211.u21", 0x080000, 0x80000, CRC(6be68450) SHA1(d24652f74b109e47eb5d3d02e04f63c99e92c590))
ROM_END

/*-------------------------------------------------------------------
/ Starship Troopers
/-------------------------------------------------------------------*/
ROM_START(startrp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sstcpu.201", 0x00000, 0x20000, CRC(549699fe) SHA1(7d3a12c7a41716ee38b822f924ca94c6932ebc4e))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sstdspa.200", 0x00000, 0x80000, CRC(76a0e09e) SHA1(a4103aeee752d824a3811124079e40acc7286271))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("u7_b130.512", 0x0000, 0x10000, CRC(f1559e4f) SHA1(82b56f097412052bc1638a3f1c1319009df707f4))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("u17_152a.040", 0x000000, 0x80000, CRC(8caeccdb) SHA1(390f07e48a176a24fe99a202f3fa2b9767d84230))
	ROM_LOAD("u21_0291.040", 0x080000, 0x80000, CRC(0c5321f6) SHA1(4a51daa16d489ab61d462d44f887c8422f863c5c))
	ROM_LOAD("u36_95a7.040", 0x100000, 0x80000, CRC(c1e4ca6a) SHA1(487de78ebf1ee8cc721f2ef7b1bd42d2f7b27456))
ROM_END

/*-------------------------------------------------------------------
/ Striker Extreme
/-------------------------------------------------------------------*/
ROM_START(strikext)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpua.102", 0x00000, 0x20000, CRC(5e5f0fb8) SHA1(1425d66064e59193ce7cacb496c12ae956670435))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispa.103", 0x00000, 0x80000, CRC(e4cf849f) SHA1(27b61f1659762b396ca3af375e28f9c56500f79e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sxsnda.u7",0x0000,0x10000,CRC(e7e1a0cb) SHA1(be8b3e4d4232519db8344ae9e75f77d159bb1911))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sxsnda.u17", 0x000000, CRC(aeeed88f) SHA1(e150fd243feffcdc5d66487e840cefdfb50213da))
	ROM_LOAD_SND_8M("sxsnda.u21", 0x080000, CRC(62c9bfe3) SHA1(14a65a673a33b7e3d3005f76acf3098dc37958f8))
	ROM_LOAD_SND_8M("sxsnda.u36", 0x100000, CRC(a0bc0edb) SHA1(1025a28fe9a0e3681e8e99b513da29ec294da045))
	ROM_LOAD_SND_8M("sxsnda.u37", 0x180000, CRC(4c08c33c) SHA1(36bfad0c59fd228db76a6ff36698edd929c11336))
ROM_END
ROM_START(strknew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpua.102", 0x00000, 0x20000, CRC(5e5f0fb8) SHA1(1425d66064e59193ce7cacb496c12ae956670435))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispa.103", 0x00000, 0x80000, CRC(e4cf849f) SHA1(27b61f1659762b396ca3af375e28f9c56500f79e))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("sxsnda.u7",0x0000,0x10000,CRC(e7e1a0cb) SHA1(be8b3e4d4232519db8344ae9e75f77d159bb1911))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("sxsnda.u17", 0x000000, 0x100000, CRC(aeeed88f) SHA1(e150fd243feffcdc5d66487e840cefdfb50213da))
	ROM_LOAD("sxsnda.u21", 0x100000, 0x100000, CRC(62c9bfe3) SHA1(14a65a673a33b7e3d3005f76acf3098dc37958f8))
	ROM_LOAD("sxsnda.u36", 0x200000, 0x100000, CRC(a0bc0edb) SHA1(1025a28fe9a0e3681e8e99b513da29ec294da045))
	ROM_LOAD("sxsnda.u37", 0x300000, 0x100000, CRC(4c08c33c) SHA1(36bfad0c59fd228db76a6ff36698edd929c11336))
ROM_END
ROM_START(strxt_uk)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpue.101", 0x00000, 0x20000, CRC(eac29785) SHA1(42e01c501b4a0a7eaae244040777be8ba69860d5))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispa.103", 0x00000, 0x80000, CRC(e4cf849f) SHA1(27b61f1659762b396ca3af375e28f9c56500f79e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sxsnda.u7",0x0000,0x10000,CRC(e7e1a0cb) SHA1(be8b3e4d4232519db8344ae9e75f77d159bb1911))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sxsnda.u17", 0x000000, CRC(aeeed88f) SHA1(e150fd243feffcdc5d66487e840cefdfb50213da))
	ROM_LOAD_SND_8M("sxsnda.u21", 0x080000, CRC(62c9bfe3) SHA1(14a65a673a33b7e3d3005f76acf3098dc37958f8))
	ROM_LOAD_SND_8M("sxsnda.u36", 0x100000, CRC(a0bc0edb) SHA1(1025a28fe9a0e3681e8e99b513da29ec294da045))
	ROM_LOAD_SND_8M("sxsnda.u37", 0x180000, CRC(4c08c33c) SHA1(36bfad0c59fd228db76a6ff36698edd929c11336))
ROM_END
ROM_START(strxt_gr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpug.103", 0x00000, 0x20000, CRC(d73b9020) SHA1(491cd9db172db0a35870524ed4f1b15fb67f2e78))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispg.103", 0x00000, 0x80000, CRC(eb656489) SHA1(476315a5d22b6d8c63e9a592167a00f0c87e86c9))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sxsndg.u7",0x0000,0x10000,CRC(b38ec07d) SHA1(239a3a51c049b007d4c16c3bd1e003a5dfd3cecc))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sxsndg.u17", 0x000000, CRC(19ecf6ca) SHA1(f61f9e821bb0cf7978073a2d2cb939999265277b))
	ROM_LOAD_SND_8M("sxsndg.u21", 0x080000, CRC(ee410b1e) SHA1(a0f7ff46536060be8f7c2c0e575e85814cd183e1))
	ROM_LOAD_SND_8M("sxsndg.u36", 0x100000, CRC(f0e126c2) SHA1(a8c5eed27b33d20c2ff3bfd3d317c8b56bfa3625))
	ROM_LOAD_SND_8M("sxsndg.u37", 0x180000, CRC(82260f4b) SHA1(6c2eba67762bcdd01e7b0c1b8b03b91b778444d4))
ROM_END
ROM_START(strxt_fr)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpuf.102", 0x00000, 0x20000, CRC(2804bc9f) SHA1(3c75d8cc4d2833baa163d99c709dcb9475ba0831))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispf.103", 0x00000, 0x80000, CRC(4b4b5c19) SHA1(d2612a2b8099b45cb67ac9b55c88b5b10519d49b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sxsndf.u7",0x0000,0x10000,CRC(e68b0607) SHA1(cd3a5ff51932914e977fe866f7ab569d0901967a))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sxsndf.u17", 0x000000, CRC(443efde2) SHA1(823f395cc5b0c7f5665bd8c804707fb9bbad1066))
	ROM_LOAD_SND_8M("sxsndf.u21", 0x080000, CRC(e8ba1618) SHA1(920cecbdcfc948670ddf11b572af0bb536a1153d))
	ROM_LOAD_SND_8M("sxsndf.u36", 0x100000, CRC(89107426) SHA1(9e3c51f17aee0e803e54f9400c304b4da0b8cf7a))
	ROM_LOAD_SND_8M("sxsndf.u37", 0x180000, CRC(67c0f1de) SHA1(46867403d4b13d18c4ebcc5b042faf3aca165ffb))
ROM_END
ROM_START(strxt_it)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpui.102", 0x00000, 0x20000, CRC(f955d0ef) SHA1(0f4ee87715bc085e2fb05e9ebdc89403f6bac444))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispi.103", 0x00000, 0x80000, CRC(40be3fe2) SHA1(a5e37ecf3b9772736ac88256c470f785dc113aa1))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sxsndi.u7",0x0000,0x10000,CRC(81caf0a7) SHA1(5bb05c5bb49d12417b3ad49398623c3c222fd63b))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sxsndi.u17", 0x000000, CRC(d0b21193) SHA1(2e5f92a67f0f18913e5d0af9936ab8694d095c66))
	ROM_LOAD_SND_8M("sxsndi.u21", 0x080000, CRC(5ab3f8f4) SHA1(44982725eb31b0b144e3ad6549734b5fc46cd8c5))
	ROM_LOAD_SND_8M("sxsndi.u36", 0x100000, CRC(4ee21ade) SHA1(1887f81b5f6753ce75ddcd0d7557c1644a925fcf))
	ROM_LOAD_SND_8M("sxsndi.u37", 0x180000, CRC(4427e364) SHA1(7046b65086aafc4c14793d7036bc5130fe1e7dbc))
ROM_END
ROM_START(strxt_sp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("sxcpul.102", 0x00000, 0x20000, CRC(6b1e417f) SHA1(b87e8659bc4481384913a28c1cb2d7c96532b8e3))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sxdispl.103", 0x00000, 0x80000, CRC(3efd4a18) SHA1(64f6998f82947a5bd053ad8dd56682adb239b676))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("sxsndl.u7",0x0000,0x10000,CRC(a03131cf) SHA1(e50f665eb15cef799fdc0d1d88bc7d5e23390225))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("sxsndl.u17", 0x000000, CRC(e7ee91cb) SHA1(1bc9992601bd7d194e2f33241179d682a62bff4b))
	ROM_LOAD_SND_8M("sxsndl.u21", 0x080000, CRC(88cbf553) SHA1(d6afd262b47e31983c734c0054a7af2489da2f13))
	ROM_LOAD_SND_8M("sxsndl.u36", 0x100000, CRC(35474ad5) SHA1(818a0f86fa4aa0b0457c16a20f8358655c42ea0a))
	ROM_LOAD_SND_8M("sxsndl.u37", 0x180000, CRC(0e53f2a0) SHA1(7b89989ff87c25618d6f1c6479efd45b57f850fb))
ROM_END

/*-------------------------------------------------------------------
/ Terminator 3: Rise of the Machines
/-------------------------------------------------------------------*/
ROM_START(term3)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("t3cpu.400", 0x00000, 0x20000, CRC(872f9351) SHA1(8fa8b503d8c3dbac66df1cb0ba400dbd58ee28ee))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("t3dispa.400", 0x00000, 0x80000, CRC(6b7cc4f8) SHA1(214e9b3e45b778841fc166acf4ff5fd634ae2670))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3_205)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "t3cpu.205",     0x0000, 0x20000, CRC(219d8155) SHA1(dac3c390d238872703a0ec65cb3dddc89630359c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "t3dispa.201",   0x0000, 0x80000, CRC(a314acd1) SHA1(4d5072e65f8041d24c1bab2985ef5b30e1895bf3))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(t3new)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("t3cpu.400", 0x00000, 0x20000, CRC(872f9351) SHA1(8fa8b503d8c3dbac66df1cb0ba400dbd58ee28ee))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("t3dispa.400", 0x00000, 0x80000, CRC(6b7cc4f8) SHA1(214e9b3e45b778841fc166acf4ff5fd634ae2670))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("t3100.u17", 0x000000, 0x100000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD("t3100.u21", 0x100000, 0x100000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD("t3100.u36", 0x200000, 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD("t3100.u37", 0x300000, 0x100000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3g)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("t3cpu.400", 0x00000, 0x20000, CRC(872f9351) SHA1(8fa8b503d8c3dbac66df1cb0ba400dbd58ee28ee))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("t3dispg.400", 0x00000, 0x80000, CRC(20da21b2) SHA1(9115aef55d9ac36a49ae5c5fd423f05c669b0335))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3l)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("t3cpu.400", 0x00000, 0x20000, CRC(872f9351) SHA1(8fa8b503d8c3dbac66df1cb0ba400dbd58ee28ee))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("t3displ.400", 0x00000, 0x80000, CRC(2e21caba) SHA1(d29afa05d68484c762799c799bd1ccd1aad252b7))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3l_205)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "t3cpu.205",     0x0000, 0x20000, CRC(219d8155) SHA1(dac3c390d238872703a0ec65cb3dddc89630359c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "t3displ.201",   0x0000, 0x80000, CRC(180b55a2) SHA1(1d8161fc806804e0712ee8a07a2cac0561949f0c))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3f)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("t3cpu.400", 0x00000, 0x20000, CRC(872f9351) SHA1(8fa8b503d8c3dbac66df1cb0ba400dbd58ee28ee))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("t3dispf.400", 0x00000, 0x80000, CRC(0645fe6d) SHA1(1a7dfa160ba6cc1335a59b018289982f2a46a7bb))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3f_205)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "t3cpu.205",     0x0000, 0x20000, CRC(219d8155) SHA1(dac3c390d238872703a0ec65cb3dddc89630359c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "t3dispf.201",   0x0000, 0x80000, CRC(ced87154) SHA1(893c071bb2427429ca45f4d2088b015c5f638207))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END
ROM_START(term3i)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("t3cpu.400", 0x00000, 0x20000, CRC(872f9351) SHA1(8fa8b503d8c3dbac66df1cb0ba400dbd58ee28ee))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("t3dispi.400", 0x00000, 0x80000, CRC(e8ea9ab8) SHA1(7b25bb7d3095e6bd2d94342d0e078590cb75074b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END

ROM_START(term3i_205)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "t3cpu.205",     0x0000, 0x20000, CRC(219d8155) SHA1(dac3c390d238872703a0ec65cb3dddc89630359c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "t3dispi.201",   0x0000, 0x80000, CRC(c1f3604f) SHA1(8a391e6471ced52662aa69261ac29a279c7b8a7d))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("t3100.u7",0x0000,0x10000,CRC(7f99e3af) SHA1(4916c074e2a4c947d1a658300f9f9629da1a8bb8))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("t3100.u17", 0x000000, CRC(f0c71b5d) SHA1(e9f726a232fbd4f34b8b07069f337dbb3daf394a))
	ROM_LOAD_SND_8M("t3100.u21", 0x080000, CRC(694331f7) SHA1(e9ae8c5db2e59c0f9df923c98f6e75896e150807))
	ROM_LOAD_SND_8M("t3100.u36", 0x100000, CRC(9eb512e9) SHA1(fa2fecf6cb0c1af3c6db244f9d94ba53d13e10fc))
	ROM_LOAD_SND_8M("t3100.u37", 0x180000, CRC(3efb0c19) SHA1(6894295eef05891d64c7274512ba27f2b63ca3ec))
ROM_END

/*-------------------------------------------------------------------
/ The Brain
/-------------------------------------------------------------------*/

/*-------------------------------------------------------------------
/ The Lost World: Jurassic Park
/-------------------------------------------------------------------*/
ROM_START(jplstw22)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("jp2cpu.202", 0x00000, 0x20000, CRC(d317e601) SHA1(fb4fee5fd08e0f1b5afb9817654bdb3d54a5220d))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("jp2dspa.201", 0x00000, 0x80000, CRC(8fc41ace) SHA1(9d11f7623eec41972d2be4313c7715e30116d889))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("jp2_u7.bin", 0x0000, 0x10000, CRC(73b74c96) SHA1(ffa47cbf1491ed4fbadc984189abbfffc70c9888))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("jp2_u17.bin", 0x000000, 0x80000, CRC(8d6c0dbd) SHA1(e1179b2c94927a07efa7d16cf841d5ff7334ff36))
	ROM_LOAD("jp2_u21.bin", 0x080000, 0x80000, CRC(c670a997) SHA1(1576e11ec3669f61ff16188de31b9ef3a067c473))
ROM_END
ROM_START(jplstw20)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("jp2cpu.200", 0x00000, 0x20000, CRC(42f5526e) SHA1(66254492c981117c06567305237cadfc0ce391b0))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("jp2dspa.201", 0x00000, 0x80000, CRC(8fc41ace) SHA1(9d11f7623eec41972d2be4313c7715e30116d889))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("jp2_u7.bin", 0x0000, 0x10000, CRC(73b74c96) SHA1(ffa47cbf1491ed4fbadc984189abbfffc70c9888))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("jp2_u17.bin", 0x000000, 0x80000, CRC(8d6c0dbd) SHA1(e1179b2c94927a07efa7d16cf841d5ff7334ff36))
	ROM_LOAD("jp2_u21.bin", 0x080000, 0x80000, CRC(c670a997) SHA1(1576e11ec3669f61ff16188de31b9ef3a067c473))
ROM_END

/*-------------------------------------------------------------------
/ The Simpsons Pinball Party
/-------------------------------------------------------------------*/
ROM_START(simpprty)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.500", 0x00000, 0x20000, CRC(215ce09c) SHA1(f3baaaa1b9f12a98109da55746031eb9f5f8790c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispa.500", 0x00000, 0x80000, CRC(c6db83ec) SHA1(6079981e19b4651a074b0005eca85faf0eebcec0))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprty_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "spp-cpu.400",  0x00000, 0x20000, CRC(530b9782) SHA1(573b20cac205b7989cdefceb2c31cb7d88c2951a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "sppdspa.400",   0x00000, 0x80000, CRC(cd5eaab7) SHA1(a06bef6fc0e7f3c0616439cb0e0431a3d52cdfa1))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprty_204)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.204",  0x00000, 0x20000, CRC(5bc155f7) SHA1(78d793cecbc6561a891ff8007f33c63ec5515e9f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispa.201", 0x00000, 0x80000, CRC(f55505a4) SHA1(5616959caafc836d13db9c1a1e93cb4954f0c321))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpnew)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.500", 0x00000, 0x20000, CRC(215ce09c) SHA1(f3baaaa1b9f12a98109da55746031eb9f5f8790c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispa.500", 0x00000, 0x80000, CRC(c6db83ec) SHA1(6079981e19b4651a074b0005eca85faf0eebcec0))
	ROM_REGION32_LE(0x600000, "soundcpu", ROMREGION_ERASEMASK | 0)
	ROM_LOAD("bios.u8", 0x400000, 0x200000, CRC(c049bf99) SHA1(89e76760e8010fe642ed4312732de81c8a25f548))
	ROM_RELOAD(0x0,0x200000)
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x400000, "sound2", 0)
	ROM_LOAD("spp100.u17", 0x000000, 0x100000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD("spp100.u21", 0x100000, 0x100000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD("spp100.u36", 0x200000, 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD("spp100.u37", 0x300000, 0x100000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtg)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.500", 0x00000, 0x20000, CRC(215ce09c) SHA1(f3baaaa1b9f12a98109da55746031eb9f5f8790c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispg.500", 0x00000, 0x80000, CRC(6503bffc) SHA1(717aa8b7a0329c886ddb4b167c022b3a2ee3ab2d))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtg_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "spp-cpu.400",  0x00000, 0x20000, CRC(530b9782) SHA1(573b20cac205b7989cdefceb2c31cb7d88c2951a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "sppdspg.400",   0x00000, 0x80000, CRC(3b408fe2) SHA1(ce8d7f0d58b5f8fb4df0b9811449e4dc0e1e6580))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtl)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.500", 0x00000, 0x20000, CRC(215ce09c) SHA1(f3baaaa1b9f12a98109da55746031eb9f5f8790c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispl.500", 0x00000, 0x80000, CRC(0821f182) SHA1(7998ab29dae59d077b1dedd28a30a3477251d107))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtl_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "spp-cpu.400",  0x00000, 0x20000, CRC(530b9782) SHA1(573b20cac205b7989cdefceb2c31cb7d88c2951a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "sppdspl.400",   0x00000, 0x80000, CRC(a0bf567e) SHA1(ce6eb65da6bff15aeb787fd2cdac7cf6b4300108))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtl_204)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.204",  0x00000, 0x20000, CRC(5bc155f7) SHA1(78d793cecbc6561a891ff8007f33c63ec5515e9f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispl.201", 0x00000, 0x80000, CRC(78a67e23) SHA1(c4ef2b0301104280410aefdacc847e74a8c6a49f))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtf)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.500", 0x00000, 0x20000, CRC(215ce09c) SHA1(f3baaaa1b9f12a98109da55746031eb9f5f8790c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispf.500", 0x00000, 0x80000, CRC(8d3383ed) SHA1(a56b1043fe1b0280d11386981fe9c181c9b6f1b7))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtf_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "spp-cpu.400",  0x00000, 0x20000, CRC(530b9782) SHA1(573b20cac205b7989cdefceb2c31cb7d88c2951a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "sppdspf.400",   0x00000, 0x80000, CRC(6cc306e2) SHA1(bfe6ef0cd5d0cb5e3b29d85ade1700005e22d81b))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprtf_204)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.204",  0x00000, 0x20000, CRC(5bc155f7) SHA1(78d793cecbc6561a891ff8007f33c63ec5515e9f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispf.201", 0x00000, 0x80000, CRC(d1c0c484) SHA1(615e3a8ba62b3f6d0ba53fbaf4b7d9e7fcdc9d82))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprti)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.500", 0x00000, 0x20000, CRC(215ce09c) SHA1(f3baaaa1b9f12a98109da55746031eb9f5f8790c))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispi.500", 0x00000, 0x80000, CRC(eefe84db) SHA1(97c60f9182bdfe346ca4981b844a71f57414d470))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprti_400)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD( "spp-cpu.400",  0x00000, 0x20000, CRC(530b9782) SHA1(573b20cac205b7989cdefceb2c31cb7d88c2951a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD( "sppdspi.400",   0x00000, 0x80000, CRC(ebe45dee) SHA1(4cdf0f01b1df1fa35df67f19c67b82a39d887be8))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END
ROM_START(simpprti_204)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("spp-cpu.204",  0x00000, 0x20000, CRC(5bc155f7) SHA1(78d793cecbc6561a891ff8007f33c63ec5515e9f))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("sppdispi.201", 0x00000, 0x80000, CRC(b4594819) SHA1(4ab83f3b6466eebdec802e57d6542ad4a3cf3fb0))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("spp101.u7",0x0000,0x10000,CRC(32efcdf6) SHA1(1d437e8649408be91e0dd10598cc67336203077f))
	ROM_REGION(0x1000000, "bsmt", 0 )
	ROM_LOAD_SND_8M("spp100.u17", 0x000000, CRC(65e9344e) SHA1(fe4797ccb71b31aa39d6a5d373a01fc22f9d055c))
	ROM_LOAD_SND_8M("spp100.u21", 0x080000, CRC(17fee0f9) SHA1(5b5ceb667f3bc9bde4ea08a1ef837e3b56c01977))
	ROM_LOAD_SND_8M("spp100.u36", 0x100000, CRC(ffb957b0) SHA1(d6876ec63525099a7073c196867c17111272c69a))
	ROM_LOAD_SND_8M("spp100.u37", 0x180000, CRC(0738e1fc) SHA1(268462c06e5c1f286e5faaee1c0815448cc2eafa))
ROM_END

/*-------------------------------------------------------------------
/ X-Files
/-------------------------------------------------------------------*/
ROM_START(xfilesp)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("xfcpu.303", 0x00000, 0x20000, CRC(c7ab5efe) SHA1(dcb4b89adfb5ba39e59c1118a00b29941d3ea4e9))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("xfildspa.300", 0x00000, 0x80000, CRC(03c96af8) SHA1(06a26116f863bb9b2d127e18c5ba500537923d62))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("xfsndu7.512", 0x0000, 0x10000, CRC(01d65239) SHA1(9e680de940a15ef85a5615b789c58cd5973ff11b))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("xfsndu17.c40", 0x000000, 0x80000, CRC(40bfc835) SHA1(2d6ac82acbbf9645bcb84fab7f285f2373e516a8))
	ROM_LOAD("xfsndu21.c40", 0x080000, 0x80000, CRC(b56a5ca6) SHA1(5fa23a8bb57e45aca159882226e603d9a6be078b))
ROM_END

ROM_START(xfiles2)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("xfcpu.204", 0x00000, 0x20000, CRC(a4913128) SHA1(1fe348725e13fd5dc56b6b2dbd173d0b49953483))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("xfildspa.201", 0x00000, 0x80000, CRC(bb015f24) SHA1(ca539d978ef0b8244227ea0c60087da5e7f0ee9e))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("xfsndu7.512", 0x0000, 0x10000, CRC(01d65239) SHA1(9e680de940a15ef85a5615b789c58cd5973ff11b))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("xfsndu17.c40", 0x000000, 0x80000, CRC(40bfc835) SHA1(2d6ac82acbbf9645bcb84fab7f285f2373e516a8))
	ROM_LOAD("xfsndu21.c40", 0x080000, 0x80000, CRC(b56a5ca6) SHA1(5fa23a8bb57e45aca159882226e603d9a6be078b))
ROM_END

/*-------------------------------------------------------------------
/ Twister
/-------------------------------------------------------------------*/
ROM_START(twst_405)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("twstcpu.405", 0x00000, 0x20000, CRC(8c3ea1a8) SHA1(d495b7dc79186d442a89b6382a6dc1c83e64ef95))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("twstdspa.400", 0x00000, 0x80000, CRC(a6a3d41d) SHA1(ad42b3390ceeeea43c1cd47f300bcd4b4a4d2558))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("twstsnd.u7", 0x0000, 0x10000, CRC(5ccf0798) SHA1(ac591c508de8e9687c20b01c298084c99a251016))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("twstsnd.u17", 0x000000, 0x80000, CRC(0e35d640) SHA1(ce38a03fcc321cd9af07d24bf7aa35f254b629fc))
	ROM_LOAD("twstsnd.u21", 0x080000, 0x80000, CRC(c3eae590) SHA1(bda3e0a725339069c49c4282676a07b4e0e8d2eb))
ROM_END
ROM_START(twst_404)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("twstcpu.404", 0x00000, 0x20000, CRC(43ac7f8b) SHA1(fc087b741c00baa9093dfec009440a7d64f4ca65))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("twstdspa.400", 0x00000, 0x80000, CRC(a6a3d41d) SHA1(ad42b3390ceeeea43c1cd47f300bcd4b4a4d2558))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("twstsnd.u7", 0x0000, 0x10000, CRC(5ccf0798) SHA1(ac591c508de8e9687c20b01c298084c99a251016))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("twstsnd.u17", 0x000000, 0x80000, CRC(0e35d640) SHA1(ce38a03fcc321cd9af07d24bf7aa35f254b629fc))
	ROM_LOAD("twstsnd.u21", 0x080000, 0x80000, CRC(c3eae590) SHA1(bda3e0a725339069c49c4282676a07b4e0e8d2eb))
ROM_END
ROM_START(twst_300)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("twstcpu.300", 0x00000, 0x20000, CRC(5cc057d4) SHA1(9ff4b6951a974e3013edc30ba2310c3bffb224d2))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("twstdspa.301", 0x00000, 0x80000, CRC(78bc45cb) SHA1(d1915fab46f178c9842e44701c91a0db2495e4fd))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("twstsnd.u7", 0x0000, 0x10000, CRC(5ccf0798) SHA1(ac591c508de8e9687c20b01c298084c99a251016))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("twstsnd.u17", 0x000000, 0x80000, CRC(0e35d640) SHA1(ce38a03fcc321cd9af07d24bf7aa35f254b629fc))
	ROM_LOAD("twstsnd.u21", 0x080000, 0x80000, CRC(c3eae590) SHA1(bda3e0a725339069c49c4282676a07b4e0e8d2eb))
ROM_END

/*-------------------------------------------------------------------
/ Viper Night Drivin'
/-------------------------------------------------------------------*/
ROM_START(viprsega)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("vipcpu.201", 0x00000, 0x20000, CRC(476557aa) SHA1(9018bb6850a3f4b37cc05d9c3ce6e2d9a1931bfd))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("vipdspa.201", 0x00000, 0x80000, CRC(24b1dc21) SHA1(73d92083c4795e143e7c34f52032292a142534f4))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("vpru7.dat", 0x0000, 0x10000, CRC(f21617d7) SHA1(78d1ade400b83c62bb6288bccf386ef34050dd04))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("vpru17.dat", 0x000000, 0x80000, CRC(47b1317c) SHA1(32259965b5a12f63267af96eef8396bf71895a65))
	ROM_LOAD("vpru21.dat", 0x080000, 0x80000, CRC(0e0e2dd6) SHA1(b409c837a52eb399c9a4896ca0c502360c93dcc9))
	ROM_LOAD("vpru36.dat", 0x100000, 0x80000, CRC(7b482876) SHA1(c8960c2d45a77a35d22408c7bb8ba322e7af36f0))
	ROM_LOAD("vpru37.dat", 0x180000, 0x80000, CRC(0bf23e0e) SHA1(b5724ed6cfe791320a8cf208cc20a2d3f0db85c8))
ROM_END

/*-------------------------------------------------------------
/ Cut The Cheese Deluxe (Redemption, Whitestar hardware)
/------------------------------------------------------------*/
ROM_START(ctchzdlx)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("ctcdxcpu.100", 0x00000, 0x20000, CRC(faad6656) SHA1(4d868bc31f35e848424e3bb66cb87efe0cf24eca))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("ctcdxdsp.100", 0x00000, 0x80000, CRC(de61b12e) SHA1(2ef8f02ca995e67d1feebd33306f92e885077101))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("ctcu7d.bin", 0x0000, 0x10000, CRC(92bfe454) SHA1(8182f7ac84addf8bdb7976a85c801edf3424d16b))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("ctcdxu17.bin", 0x000000, 0x80000, CRC(7ee35d17) SHA1(f2c9b70285926fc782a2e1289532395cd8dbf999))
	ROM_LOAD("ctcdxu21.bin", 0x080000, 0x80000, CRC(84dd40ac) SHA1(c9327b95f1730a3aa741540c28078f214af214b8))
ROM_END

/*-------------------------------------------------------------------
/ Wack-A-Doodle-Doo (Redemption)
/-------------------------------------------------------------------*/
ROM_START(wackadoo)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("wackcpu.100", 0x00000, 0x20000, CRC(995e0219) SHA1(57b2352a5a96e71ff48f838fde87a158afbf3701))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("wackdisp.bin", 0x00000, 0x80000, CRC(8b46f074) SHA1(38a98fff56186d1a152e2c2e321496fd24e9ad56))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("wacku7.bin", 0x0000, 0x10000, CRC(99df3022) SHA1(5a38cf0816b95ea399d659d724b3259fadb42a62))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("wacku17.bin", 0x000000, 0x80000, CRC(1876e659) SHA1(1ff3a6d7a7b2582d0482eae024efa078d0a61dbe))
	ROM_LOAD("wacku21.bin", 0x080000, 0x80000, CRC(a3207296) SHA1(19af8ebab298a353fe42fc297b61182d8f772347))
ROM_END

/*-------------------------------------------------------------------
/ Titanic (Coin dropper)
/-------------------------------------------------------------------*/
ROM_START(titanic)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("titacpu.101", 0x00000, 0x20000, CRC(4217becf) SHA1(8b7aacbe75717f13623f6ceaa4ba2de61b1b732a))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("titadspa.101", 0x00000, 0x80000, CRC(5b4300b6) SHA1(c2b2de20f6c74b71d2a9ac43c17694eadd795586))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("titau7.101", 0x0000, 0x10000, CRC(544fe1ac) SHA1(5c62eef6a42660b13e626d1a6bb8cd09b77b0cc1))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD("titau17.100", 0x000000, 0x80000, CRC(ab919e99) SHA1(8735b632a62d9cd3db26b3c832785c48552ba231))
	ROM_LOAD("titau21.100", 0x080000, 0x80000, CRC(76ca05f8) SHA1(3e1c56fe37393c345111665fd8ab730d53cb6970))
ROM_END

/*-------------------------------------------------------------------
/ Monopoly (Coin dropper)
/-------------------------------------------------------------------*/
ROM_START(monopred)
	ROM_REGION(0x80000, "user1", 0)
	ROM_LOAD("monopcpu.401", 0x00000, 0x20000, CRC(2d0ff130) SHA1(c0b7baa6973db8743186a950b0a1ad3383db5c98))
	ROM_RELOAD(0x20000, 0x20000)
	ROM_RELOAD(0x40000, 0x20000)
	ROM_RELOAD(0x60000, 0x20000)
	ROM_REGION(0x80000, "dmdcpu", 0)
	ROM_LOAD("monopdsp.400", 0x00000, 0x80000, CRC(0105572b) SHA1(fd9e1dfa4f396b953f82ccde11b54ee638382bee))
	ROM_REGION(0x010000, "soundcpu", 0)
	ROM_LOAD("monopred.u7", 0x0000, 0x10000, CRC(1ca0cf63) SHA1(c4ce78718e3e3f1a8451b134f2869dd6410fee30))
	ROM_REGION(0x1000000, "bsmt", 0)
	ROM_LOAD_SND_8M("monopred.u17", 0x000000, CRC(467dca62) SHA1(c727748b6b0b39ead19ce98bddd89fd05fb62d00))
ROM_END

#define GAME_IS_PINBALL GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL

GAME(1995,  apollo13,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Apollo 13",                GAME_IS_PINBALL)
GAME(2001,  austin,     0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (3.02)",             GAME_IS_PINBALL)
GAME(2001,  aust301,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (3.01)",             GAME_IS_PINBALL)
GAME(2001,  aust300,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (3.00)",             GAME_IS_PINBALL)
GAME(2001,  aust201,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (2.01)",             GAME_IS_PINBALL)
GAME(2001,  austnew,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (ARM7 Sound Board)",             GAME_IS_PINBALL)
GAME(2001,  austinf,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (France)",               GAME_IS_PINBALL)
GAME(2001,  austing,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (Germany)",              GAME_IS_PINBALL)
GAME(2001,  austini,    austin,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Austin Powers (Italy)",                GAME_IS_PINBALL)
GAME(1998,  godzillp,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Godzilla (Pinball)",               GAME_IS_PINBALL)
GAME(1996,  gldneye,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Goldeneye",                GAME_IS_PINBALL)
GAME(1998,  goldcue,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Golden Cue",               GAME_IS_PINBALL)
GAME(1999,  harl_a13,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Harley Davidson (1.03)",               GAME_IS_PINBALL)
GAME(1999,  harl_a10,   harl_a13,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Harley Davidson (1.03 Display rev. 1.00)",             GAME_IS_PINBALL)
GAME(1999,  harl_f13,   harl_a13,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Harley Davidson (1.03 France)",                GAME_IS_PINBALL)
GAME(1999,  harl_g13,   harl_a13,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Harley Davidson (1.03 Germany)",               GAME_IS_PINBALL)
GAME(1999,  harl_i13,   harl_a13,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Harley Davidson (1.03 Italy)",             GAME_IS_PINBALL)
GAME(1999,  harl_l13,   harl_a13,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Harley Davidson (1.03 Spain)",             GAME_IS_PINBALL)
GAME(2004,  harl_a40,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (4.00)",               GAME_IS_PINBALL)
GAME(2004,  harl_f40,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (4.00 France)",                GAME_IS_PINBALL)
GAME(2004,  harl_g40,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (4.00 Germany)",               GAME_IS_PINBALL)
GAME(2004,  harl_i40,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (4.00 Italy)",             GAME_IS_PINBALL)
GAME(2004,  harl_l40,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (4.00 Spain)",             GAME_IS_PINBALL)
GAME(2004,  harl_a30,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (3.00)",               GAME_IS_PINBALL)
GAME(2004,  harl_f30,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (3.00 France)",                GAME_IS_PINBALL)
GAME(2004,  harl_g30,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (3.00 Germany)",               GAME_IS_PINBALL)
GAME(2004,  harl_i30,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (3.00 Italy)",             GAME_IS_PINBALL)
GAME(2004,  harl_l30,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (3.00 Spain)",             GAME_IS_PINBALL)
GAME(2003,  harl_a18,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (1.08)",               GAME_IS_PINBALL)
GAME(2003,  harl_f18,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (1.08 France)",                GAME_IS_PINBALL)
GAME(2003,  harl_g18,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (1.08 Germany)",               GAME_IS_PINBALL)
GAME(2003,  harl_i18,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (1.08 Italy)",             GAME_IS_PINBALL)
GAME(2003,  harl_l18,   harl_a40,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Harley Davidson (1.08 Spain)",             GAME_IS_PINBALL)
GAME(2001,  hirolcas,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (3.00)",                GAME_IS_PINBALL)
GAME(2001,  hironew,    hirolcas,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (ARM7 Sound Board)",                GAME_IS_PINBALL)
GAME(2001,  hirolcat,   hirolcas,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (3.00) TEST",               GAME_IS_PINBALL)
GAME(2001,  hirolcas_210,hirolcas,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (2.10)",                GAME_IS_PINBALL)
GAME(2001,  hirol_fr,   hirolcas,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (3.00 France)",             GAME_IS_PINBALL)
GAME(2001,  hirol_gr,   hirolcas,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (3.00 Germany)",                GAME_IS_PINBALL)
GAME(2001,  hirol_gr_210,hirolcas,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (2.10 Germany)",                GAME_IS_PINBALL)
GAME(2001,  hirol_it,   hirolcas,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "High Roller Casino (3.00 Italy)",              GAME_IS_PINBALL)
GAME(1996,  id4,        0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Independence Day",             GAME_IS_PINBALL)
GAME(1998,  lostspc,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Lost in Space",                GAME_IS_PINBALL)
GAME(2001,  monopolp,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (3.20)",              GAME_IS_PINBALL)
GAME(2002,  monop303,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (3.03)",              GAME_IS_PINBALL)
GAME(2002,  monop301,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (3.01)",              GAME_IS_PINBALL)
GAME(2002,  monop251,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (2.51)",              GAME_IS_PINBALL)
GAME(2002,  monop233,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (2.33)",              GAME_IS_PINBALL)
GAME(2002,  monopolf,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (France)",                GAME_IS_PINBALL)
GAME(2002,  monopolg,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (Germany)",               GAME_IS_PINBALL)
GAME(2002,  monopoli,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (Italy)",             GAME_IS_PINBALL)
GAME(2002,  monopoll,   monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (Spain)",             GAME_IS_PINBALL)
GAME(2002,  mononew,    monopolp,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (ARM7 Sound Board)",              GAME_IS_PINBALL)
GAME(2001,  nfl,        0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "NFL",              GAME_IS_PINBALL)
GAME(2002,  playboys,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (5.00)",               GAME_IS_PINBALL)
GAME(2002,  playboys_401,playboys,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (4.01)",               GAME_IS_PINBALL)
GAME(2002,  playboys_303,playboys,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.03)",               GAME_IS_PINBALL)
GAME(2002,  playboys_300,playboys,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.00)",               GAME_IS_PINBALL)
GAME(2002,  playboys_203,playboys,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (2.03)",               GAME_IS_PINBALL)
GAME(2002,  playnew,    playboys,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (ARM7 Sound Board)",               GAME_IS_PINBALL)
GAME(2002,  playboyf,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (5.00 France)",                GAME_IS_PINBALL)
GAME(2002,  playboyf_401,playboyf,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (4.01 France)",                GAME_IS_PINBALL)
GAME(2002,  playboyf_303,playboyf,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.03 France)",                GAME_IS_PINBALL)
GAME(2002,  playboyf_300,playboyf,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.00 France)",                GAME_IS_PINBALL)
GAME(2002,  playboyf_203,playboyf,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (2.03 France)",                GAME_IS_PINBALL)
GAME(2002,  playboyg,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (5.00 Germany)",               GAME_IS_PINBALL)
GAME(2002,  playboyg_401,playboyg,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (4.01 Germany)",               GAME_IS_PINBALL)
GAME(2002,  playboyg_303,playboyg,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.03 Germany)",               GAME_IS_PINBALL)
GAME(2002,  playboyg_300,playboyg,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.00 Germany)",               GAME_IS_PINBALL)
GAME(2002,  playboyg_203,playboyg,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (2.03 Germany)",               GAME_IS_PINBALL)
GAME(2002,  playboyi,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (5.00 Italy)",             GAME_IS_PINBALL)
GAME(2002,  playboyi_401,playboyi,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (4.01 Italy)",             GAME_IS_PINBALL)
GAME(2002,  playboyi_303,playboyi,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.03 Italy)",             GAME_IS_PINBALL)
GAME(2002,  playboyi_300,playboyi,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.00 Italy)",             GAME_IS_PINBALL)
GAME(2002,  playboyi_203,playboyi,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (2.03 Italy)",             GAME_IS_PINBALL)
GAME(2002,  playboyl,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (5.00 Spain)",             GAME_IS_PINBALL)
GAME(2002,  playboyl_401,playboyl,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (4.01 Spain)",             GAME_IS_PINBALL)
GAME(2002,  playboyl_303,playboyl,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.03 Spain)",             GAME_IS_PINBALL)
GAME(2002,  playboyl_300,playboyl,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (3.00 Spain)",             GAME_IS_PINBALL)
GAME(2002,  playboyl_203,playboyl,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Playboy (2.03 Spain)",             GAME_IS_PINBALL)
GAME(2002,  rctycn,     0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.02)",             GAME_IS_PINBALL)
GAME(2002,  rctycn_701, rctycn,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.01)",             GAME_IS_PINBALL)
GAME(2002,  rctycn_600, rctycn,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (6.00)",             GAME_IS_PINBALL)
GAME(2002,  rctycn_400, rctycn,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (4.00)",             GAME_IS_PINBALL)
GAME(2002,  rctnew,     rctycn,     whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (ARM7 Sound Board)",             GAME_IS_PINBALL)
GAME(2002,  rctycng,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.02 Germany)",             GAME_IS_PINBALL)
GAME(2002,  rctycng_701,rctycng,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.01 Germany)",             GAME_IS_PINBALL)
GAME(2002,  rctycng_400,rctycng,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (4.00 Germany)",             GAME_IS_PINBALL)
GAME(2002,  rctycnf,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.02 France)",              GAME_IS_PINBALL)
GAME(2002,  rctycnf_701,rctycnf,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.01 France)",              GAME_IS_PINBALL)
GAME(2002,  rctycnf_600,rctycnf,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (6.00 France)",              GAME_IS_PINBALL)
GAME(2002,  rctycnf_400,rctycnf,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (4.00 France)",              GAME_IS_PINBALL)
GAME(2002,  rctycni,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.02 Italy)",               GAME_IS_PINBALL)
GAME(2002,  rctycni_701,rctycni,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.01 Italy)",               GAME_IS_PINBALL)
GAME(2002,  rctycni_600,rctycni,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (6.00 Italy)",               GAME_IS_PINBALL)
GAME(2002,  rctycni_400,rctycni,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (4.00 Italy)",               GAME_IS_PINBALL)
GAME(2002,  rctycnl,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.02 Spain)",               GAME_IS_PINBALL)
GAME(2002,  rctycnl_701,rctycnl,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (7.01 Spain)",               GAME_IS_PINBALL)
GAME(2002,  rctycnl_600,rctycnl,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (6.00 Spain)",               GAME_IS_PINBALL)
GAME(2002,  rctycnl_400,rctycnl,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Roller Coaster Tycoon (4.00 Spain)",               GAME_IS_PINBALL)
GAME(2000,  shrkysht,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.11)",                GAME_IS_PINBALL)
GAME(2000,  shrky_207,  shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.07)",                GAME_IS_PINBALL)
GAME(2001,  shrknew,    shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (ARM7 Sound Board)",                GAME_IS_PINBALL)
GAME(2001,  shrkygr,    shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.11 Germany)",                GAME_IS_PINBALL)
GAME(2001,  shrkygr_207,shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.07 Germany)",                GAME_IS_PINBALL)
GAME(2001,  shrkyfr,    shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.11 France)",             GAME_IS_PINBALL)
GAME(2001,  shrkyfr_207,shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.07 France)",             GAME_IS_PINBALL)
GAME(2001,  shrkyit,    shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.11 Italy)",              GAME_IS_PINBALL)
GAME(2001,  shrkyit_207,shrkysht,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Sharkey's Shootout (2.07 Italy)",              GAME_IS_PINBALL)
GAME(1999,  sprk_103,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "South Park (1.03)",                GAME_IS_PINBALL)
GAME(1999,  sprk_096,   sprk_103,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "South Park (0.96)",                GAME_IS_PINBALL)
GAME(1999,  sprk_090,   sprk_103,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "South Park (0.90)",                GAME_IS_PINBALL)
GAME(1997,  spacejam,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Space Jam",                GAME_IS_PINBALL)
GAME(1997,  spacejmg,   spacejam,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Space Jam (Germany)",              GAME_IS_PINBALL)
GAME(1997,  spacejmf,   spacejam,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Space Jam (France)",               GAME_IS_PINBALL)
GAME(1997,  spacejmi,   spacejam,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Space Jam (Italy)",                GAME_IS_PINBALL)
GAME(1997,  swtril43,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Star Wars Trilogy (4.03)",             GAME_IS_PINBALL)
GAME(1997,  swtril41,   swtril43,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Star Wars Trilogy (4.01)",             GAME_IS_PINBALL)
GAME(1997,  startrp,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Starship Troopers",                GAME_IS_PINBALL)
GAME(1999,  strikext,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (1.02)",                GAME_IS_PINBALL)
GAME(1999,  strknew,    strikext,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (ARM7 Sound Board)",                GAME_IS_PINBALL)
GAME(1999,  strxt_uk,   strikext,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (UK)",              GAME_IS_PINBALL)
GAME(1999,  strxt_gr,   strikext,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (Germany)",             GAME_IS_PINBALL)
GAME(1999,  strxt_fr,   strikext,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (France)",              GAME_IS_PINBALL)
GAME(1999,  strxt_it,   strikext,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (Italy)",               GAME_IS_PINBALL)
GAME(1999,  strxt_sp,   strikext,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Striker Xtreme (Spain)",               GAME_IS_PINBALL)
GAME(2003,  term3,      0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (4.00)",                GAME_IS_PINBALL)
GAME(2003,  term3_205,  term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (2.05)",                GAME_IS_PINBALL)
GAME(2003,  t3new,      term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (ARM7 Sound Board)",                GAME_IS_PINBALL)
GAME(2003,  term3g,     term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (4.00 Germany)",                GAME_IS_PINBALL)
GAME(2003,  term3l,     term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (4.00 Spain)",              GAME_IS_PINBALL)
GAME(2003,  term3l_205, term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (2.05 Spain)",              GAME_IS_PINBALL)
GAME(2003,  term3f,     term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (4.00 France)",             GAME_IS_PINBALL)
GAME(2003,  term3f_205, term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (2.05 France)",             GAME_IS_PINBALL)
GAME(2003,  term3i,     term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (4.00 Italy)",              GAME_IS_PINBALL)
GAME(2003,  term3i_205, term3,      whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Terminator 3: Rise of the Machines (2.05 Italy)",              GAME_IS_PINBALL)
GAME(1997,  jplstw22,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Lost World: Jurassic Park, The (2.02)",                GAME_IS_PINBALL)
GAME(1997,  jplstw20,   jplstw22,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Lost World: Jurassic Park, The (2.00)",                GAME_IS_PINBALL)
GAME(2003,  simpprty,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (5.00)",               GAME_IS_PINBALL)
GAME(2003,  simpprty_400,simpprty,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (4.00)",               GAME_IS_PINBALL)
GAME(2003,  simpprty_204,simpprty,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (2.04)",               GAME_IS_PINBALL)
GAME(2003,  simpnew,    simpprty,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (ARM7 Sound Board)",               GAME_IS_PINBALL)
GAME(2003,  simpprtg,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (5.00 Germany)",               GAME_IS_PINBALL)
GAME(2003,  simpprtg_400,simpprtg,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (4.00 Germany)",               GAME_IS_PINBALL)
GAME(2003,  simpprtl,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (5.00 Spain)",             GAME_IS_PINBALL)
GAME(2003,  simpprtl_400,simpprtl,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (4.00 Spain)",             GAME_IS_PINBALL)
GAME(2003,  simpprtl_204,simpprtl,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (2.04 Spain)",             GAME_IS_PINBALL)
GAME(2003,  simpprtf,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (5.00 France)",                GAME_IS_PINBALL)
GAME(2003,  simpprtf_400,simpprtf,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (4.00 France)",                GAME_IS_PINBALL)
GAME(2003,  simpprtf_204,simpprtf,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (2.04 France)",                GAME_IS_PINBALL)
GAME(2003,  simpprti,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (5.00 Italy)",             GAME_IS_PINBALL)
GAME(2003,  simpprti_400,simpprti,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (4.00 Italy)",             GAME_IS_PINBALL)
GAME(2003,  simpprti_204,simpprti,  whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Simpsons Pinball Party, The (2.04 Italy)",             GAME_IS_PINBALL)
GAME(1997,  xfilesp,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "X-Files (3.03)",               GAME_IS_PINBALL)
GAME(1997,  xfiles2,    xfilesp,    whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "X-Files (2.04)",               GAME_IS_PINBALL)
GAME(1996,  twst_405,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Twister (4.05)",               GAME_IS_PINBALL)
GAME(1996,  twst_404,   twst_405,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Twister (4.04)",               GAME_IS_PINBALL)
GAME(1996,  twst_300,   twst_405,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Twister (3.00)",               GAME_IS_PINBALL)
GAME(1998,  viprsega,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Viper Night Drivin'",              GAME_IS_PINBALL)
GAME(1998,  ctchzdlx,   ctcheese,   whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Cut The Cheese Deluxe (Redemption)",               GAME_IS_PINBALL)
GAME(1998,  titanic,    0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Titanic (Coin dropper)",               GAME_IS_PINBALL)
GAME(2002,  monopred,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Stern",    "Monopoly (Coin dropper)",              GAME_IS_PINBALL)
GAME(1998,  wackadoo,   0,          whitestar,  whitestar, whitestar_state, whitestar,  ROT0,   "Sega",     "Wack-A-Doodle-Doo (Redemption)",               GAME_IS_PINBALL)
