/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class XSLGeneralVariable
extends StyleElement {
    protected Expression select = null;
    protected SequenceType requiredType = null;
    protected String constantText = null;
    protected boolean global;
    protected SlotManager slotManager = null;
    protected boolean assignable = false;
    protected boolean redundant = false;
    protected boolean requiredParam = false;
    protected boolean implicitlyRequiredParam = false;
    protected boolean tunnel = false;
    private boolean textonly;

    protected ItemType getReturnedItemType() {
        return null;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean allowsAsAttribute() {
        return true;
    }

    protected boolean allowsTunnelAttribute() {
        return false;
    }

    protected boolean allowsValue() {
        return true;
    }

    protected boolean allowsRequired() {
        return false;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public boolean isTunnelParam() {
        return this.tunnel;
    }

    public boolean isRequiredParam() {
        return this.requiredParam;
    }

    public boolean isGlobal() {
        return this.isTopLevel();
    }

    public String getVariableDisplayName() {
        return this.getAttributeValue("name");
    }

    public void setRedundant() {
        this.redundant = true;
    }

    public StructuredQName getVariableQName() {
        if (this.getObjectName() == null) {
            String nameAttribute = this.getAttributeValue("name");
            if (nameAttribute == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "error-variable-name");
            }
            try {
                this.setObjectName(this.makeQName(nameAttribute));
            }
            catch (NamespaceException err) {
                this.setObjectName(new StructuredQName("saxon", "http://saxon.sf.net/", "error-variable-name"));
            }
            catch (XPathException err) {
                this.setObjectName(new StructuredQName("saxon", "http://saxon.sf.net/", "error-variable-name"));
            }
        }
        return this.getObjectName();
    }

    public void prepareAttributes() throws XPathException {
        this.getVariableQName();
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String assignAtt = null;
        String nameAtt = null;
        String asAtt = null;
        String requiredAtt = null;
        String tunnelAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("as") && this.allowsAsAttribute()) {
                asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("required") && this.allowsRequired()) {
                requiredAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("tunnel") && this.allowsTunnelAttribute()) {
                tunnelAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}assignable") && this instanceof XSLVariableDeclaration) {
                assignAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            try {
                this.setObjectName(this.makeQName(nameAtt));
            }
            catch (NamespaceException e) {
                this.compileError("Prefix in variable name has not been declared: " + nameAtt, "XTSE0280");
            }
            catch (XPathException e) {
                String expl = nameAtt.startsWith("$") ? " (must not start with '$')" : "";
                this.compileError("Variable name is not a valid QName: " + nameAtt + expl, "XTSE0020");
            }
        }
        if (selectAtt != null) {
            if (!this.allowsValue()) {
                this.compileError("Function parameters cannot have a default value", "XTSE0760");
            }
            this.select = this.makeExpression(selectAtt);
        }
        if (assignAtt != null && assignAtt.equals("yes")) {
            this.assignable = true;
        }
        if (requiredAtt != null) {
            if (requiredAtt.equals("yes")) {
                this.requiredParam = true;
            } else if (requiredAtt.equals("no")) {
                this.requiredParam = false;
            } else {
                this.compileError("The attribute 'required' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (tunnelAtt != null) {
            if (tunnelAtt.equals("yes")) {
                this.tunnel = true;
                if (this instanceof XSLParam && this.getParent() instanceof XSLFunction) {
                    this.compileError("For attribute 'tunnel' within xsl:function, the only permitted value is 'no'", "XTSE0020");
                }
            } else if (tunnelAtt.equals("no")) {
                this.tunnel = false;
            } else {
                this.compileError("The attribute 'tunnel' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (asAtt != null) {
            this.requiredType = this.makeSequenceType(asAtt);
        }
    }

    public void validate() throws XPathException {
        this.global = this.isTopLevel();
        if (this.global) {
            this.slotManager = this.getConfiguration().makeSlotManager();
        }
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", "XTSE0620");
        }
        if (this.hasChildNodes() && !this.allowsValue()) {
            this.compileError("Function parameters cannot have a default value", "XTSE0760");
        }
        if (this.assignable && !this.global) {
            this.compileError("saxon:assignable='yes' is no longer permitted for local variables");
        }
        this.checkAgainstRequiredType(this.requiredType);
        if (this.select == null && this.allowsValue()) {
            this.textonly = true;
            AxisIterator kids = this.iterateAxis((byte)3);
            NodeInfo first = (NodeInfo)kids.next();
            if (first == null) {
                if (this.requiredType == null) {
                    this.select = new StringLiteral(StringValue.EMPTY_STRING);
                } else if (this instanceof XSLParam) {
                    if (!this.requiredParam) {
                        if (Cardinality.allowsZero(this.requiredType.getCardinality())) {
                            this.select = Literal.makeEmptySequence();
                        } else {
                            this.implicitlyRequiredParam = true;
                        }
                    }
                } else if (Cardinality.allowsZero(this.requiredType.getCardinality())) {
                    this.select = Literal.makeEmptySequence();
                } else {
                    this.compileError("The implicit value () is not valid for the declared type", "XTTE0570");
                }
            } else {
                if (kids.next() == null && first.getNodeKind() == 3) {
                    this.constantText = first.getStringValue();
                }
                this.textonly = this.getCommonChildItemType() == NodeKindTest.TEXT;
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    protected void checkAgainstRequiredType(SequenceType required) throws XPathException {
        try {
            if (required != null && this.select != null) {
                int category = 3;
                String errorCode = "XTTE0570";
                if (this instanceof XSLParam) {
                    category = 8;
                    errorCode = "XTTE0600";
                } else if (this instanceof XSLWithParam) {
                    category = 8;
                }
                RoleLocator role = new RoleLocator(category, this.getVariableDisplayName(), 0, null);
                role.setSourceLocator(new ExpressionLocation(this));
                role.setErrorCode(errorCode);
                this.select = TypeChecker.staticTypeCheck(this.select, required, false, role, this.makeExpressionVisitor());
            }
        }
        catch (XPathException err) {
            err.setLocator(this);
            this.compileError(err);
            this.select = new ErrorExpression(err);
        }
    }

    protected void initializeInstruction(Executable exec, GeneralVariable var) throws XPathException {
        var.init(this.select, this.getVariableQName());
        var.setAssignable(this.assignable);
        var.setRequiredParam(this.requiredParam);
        var.setImplicitlyRequiredParam(this.implicitlyRequiredParam);
        var.setRequiredType(this.requiredType);
        var.setTunnel(this.tunnel);
        if (this.hasChildNodes()) {
            if (this.requiredType == null) {
                DocumentInstr doc = new DocumentInstr(this.textonly, this.constantText, this.getBaseURI());
                var.adoptChildExpression(doc);
                Expression b = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
                if (b == null) {
                    b = Literal.makeEmptySequence();
                }
                doc.setContentExpression(b);
                this.select = doc;
                var.setSelectExpression(doc);
            } else {
                this.select = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
                var.adoptChildExpression(this.select);
                if (this.select == null) {
                    this.select = Literal.makeEmptySequence();
                }
                try {
                    if (this.requiredType != null) {
                        var.setContainer(this);
                        this.select.setContainer(this);
                        RoleLocator role = new RoleLocator(3, this.getVariableDisplayName(), 0, null);
                        role.setErrorCode("XTTE0570");
                        role.setSourceLocator(new ExpressionLocation(this));
                        this.select = this.makeExpressionVisitor().simplify(this.select);
                        this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, role, this.makeExpressionVisitor());
                    }
                }
                catch (XPathException err) {
                    err.setLocator(this);
                    this.compileError(err);
                    this.select = new ErrorExpression(err);
                }
                var.setSelectExpression(this.select);
            }
        }
        if (this.global) {
            GlobalVariable gvar = (GlobalVariable)var;
            Expression exp2 = this.select;
            if (exp2 != null) {
                try {
                    ExpressionVisitor visitor = this.makeExpressionVisitor();
                    exp2.setContainer(gvar);
                    exp2 = visitor.typeCheck(visitor.simplify(this.select), Type.NODE_TYPE);
                    exp2 = exp2.optimize(visitor, Type.NODE_TYPE);
                }
                catch (XPathException err) {
                    this.compileError(err);
                }
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceInstruction trace = new TraceInstruction(exp2, this);
                    trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    trace.setContainer(gvar);
                    exp2 = trace;
                }
                this.allocateSlots(exp2);
            }
            if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
                gvar.setContainsLocals(this.slotManager);
            }
            exec.registerGlobalVariable(gvar);
            this.setReferenceCount(gvar);
            if (exp2 != this.select) {
                gvar.setSelectExpression(exp2);
            }
        }
    }

    protected void setReferenceCount(GeneralVariable var) {
    }

    public int getConstructType() {
        return 185;
    }
}

