/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.lang.Sentence;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class SentenceAndAnd<D extends Diagram>
implements Sentence<D> {
    private final SentenceSimple<D> sentence1;
    private final SentenceSimple<D> sentence2;
    private final SentenceSimple<D> sentence3;

    public SentenceAndAnd(SentenceSimple<D> sentence1, SentenceSimple<D> sentence2, SentenceSimple<D> sentence3) {
        this.sentence1 = sentence1;
        this.sentence2 = sentence2;
        this.sentence3 = sentence3;
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(RegexLeaf.start(), this.sentence1.getSubject().toRegex(), RegexLeaf.spaceOneOrMore(), this.sentence1.getVerbRegex(), this.sentence1.getAdverbialOrPropositon(), RegexLeaf.spaceOneOrMore(), this.sentence1.getComplement().toRegex("1"), SENTENCE_SEPARATOR, this.sentence2.getVerbRegex(), this.sentence2.getAdverbialOrPropositon(), RegexLeaf.spaceOneOrMore(), this.sentence2.getComplement().toRegex("2"), SENTENCE_SEPARATOR, this.sentence3.getVerbRegex(), this.sentence3.getAdverbialOrPropositon(), RegexLeaf.spaceOneOrMore(), this.sentence3.getComplement().toRegex("3"), OPTIONAL_FINAL_DOT);
    }

    @Override
    public final CommandExecutionResult execute(D project, RegexResult arg) {
        Failable<Object> subject = this.sentence1.getSubject().getMe(project, arg);
        if (subject.isFail()) {
            return CommandExecutionResult.error(subject.getError());
        }
        Failable<Object> complement1 = this.sentence1.getComplement().getMe(project, arg, "1");
        if (complement1.isFail()) {
            return CommandExecutionResult.error(complement1.getError());
        }
        CommandExecutionResult result1 = this.sentence1.execute(project, subject.get(), complement1.get());
        if (!result1.isOk()) {
            return result1;
        }
        Failable<Object> complement2 = this.sentence2.getComplement().getMe(project, arg, "2");
        if (complement2.isFail()) {
            return CommandExecutionResult.error(complement2.getError());
        }
        CommandExecutionResult result2 = this.sentence2.execute(project, subject.get(), complement2.get());
        if (!result2.isOk()) {
            return result2;
        }
        Failable<Object> complement3 = this.sentence3.getComplement().getMe(project, arg, "3");
        if (complement3.isFail()) {
            return CommandExecutionResult.error(complement3.getError());
        }
        CommandExecutionResult result3 = this.sentence3.execute(project, subject.get(), complement3.get());
        return result3;
    }
}

